<?php

/*
* @category    Vista Evolucion de Terapias
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.desarrollo@ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/
    require("../../../core/php/constantes.php");
    require("../../../core/php/_database.php");
    require("../../../core/php/php_functions.php");
    $idVersion = ofiVERSION;
    session_start();
    require("includes/varconf.php");
    header("Cache-control: private"); // IE 6 Fix
    if( isset( $_SESSION['ID_EMPRESA'])){
        $idEmpresa = $_SESSION['ID_EMPRESA'];
        $nomEmpresa = $_SESSION['NOM_EMPRESA'];
        $nomAplicacion = $_SESSION['IdAplicacion'];
        $idClienteConsultorio = $_SESSION['IDBD'];
        $nomConsultorio = $_SESSION['IdNombreConsultorio'];
        $nomEspecialidad = $_SESSION['IdEspecialidadConsultorio'];
        $nomSubEspecialidad = $_SESSION['IdSubEspecialidadConsultorio'];
        $dirConsultorio = $_SESSION['IdDireccionConsultorio'];
        $telConsultorio = $_SESSION['IdTelefonoConsultorio'];
        $ciuConsultorio = $_SESSION['IdCiudadConsultorio'];
        $usaPatrocinador = $_SESSION['Patrocinador'];
        $idPatrocinador = $_SESSION['IdPatrocinador'];
        $idCliente = 0;
        $nomCliente = "&nbsp;";
        $idSede = $_SESSION['ID_SEDE'];
        $nomSede = $_SESSION['NOM_SEDE'];
        $idIps = $_SESSION['ID_IPS'];
        $nomIps = $_SESSION['NOM_IPS'];
        $idUsuario = $_SESSION['ID_USUARIO'];
        $codUsuario = $_SESSION['COD_USUARIO'];
        $nomUsuario = $_SESSION['NOM_USUARIO'];
        $idPerfil = $_SESSION['ID_PERFIL'];
        $seguir = true;
    }
    else{
        $idEmpresa = 0;
        $nomEmpresa = "&nbsp;";
        $idCliente = 0;
        $nomCliente = "&nbsp;";
        $idSede = 0;
        $nomSede = "&nbsp;";
        $idIps = 0;
        $nomIps = "&nbsp;";
        $idUsuario = 0;
        $codUsuario = "&nbsp;";
        $nomUsuario = "&nbsp;";
        $idPerfil = 0;
        $seguir = false;
        $nomAplicacion = "OfiClinic";
        $nomConsultorio = "&nbsp;";
        $nomEspecialidad = "&nbsp;";
        $nomSubEspecialidad = "&nbsp;";
        $dirConsultorio = "&nbsp;";
        $telConsultorio = "&nbsp;";
        $ciuConsultorio = "&nbsp;";
        $usaPatrocinador = "NA";
        $idPatrocinador = "&nbsp;";
        $idClienteConsultorio = "X1";
        $nomOpcion = "&nbsp;";
        $desOpcion = "&nbsp;";
    }
?>
<!DOCTYPE html>
<html lang="es" class="no-js">
    <head>
        <meta charset="utf-8">
        <title>.:: CONSULTAR RESULTADOS ::.</title>
        <meta name="description" content="Planificador">
        <meta name="author" content="Green TICS">
        <meta name="robots" content="noindex, nofollow">
        <meta name="viewport" content="width=device-width,initial-scale=1,maximum-scale=1.0">
        <meta name="robots" content="noindex, nofollow">
        <meta name="viewport" content="width=device-width,initial-scale=1,maximum-scale=1.0">
        <link rel="shortcut icon" href="../../images/logo/favicon-32x32.png">
        <link rel="stylesheet" type="text/css" href="../../../libjq/extjs/resources/css/ext-all.css"/>
        <link rel="stylesheet" type="text/css" href="../../../libjq/extjs/resources/css/xtheme-gray.css" />
        <script type="text/javascript" src="../../../libjq/extjs/adapter/ext/ext-base.js"></script> 
        <script type="text/javascript" src="../../../libjq/extjs/ext-all.js"></script>
        <link rel="stylesheet" href="../../../libjq/css/bootstrap.min.css">
        <link rel="stylesheet" href="../../../libjq/css/plugins.css">
        <link rel="stylesheet" href="../../../libjq/css/jquery.gritter.css" >
        <link rel="stylesheet" href="../../../libjq/css/main.css">
        <link rel="stylesheet" href="../../../libjq/chosen/bootstrap-chosen.css">
        <link rel="stylesheet" href="../../../libjq/css/themes/agropartners.css">
        <script src="../../../libjq/js/vendor/modernizr-respond.min.js"></script>
    </head>
    <body style="background-color: whitesmoke; padding: 10px;">
        <div class="row">
            <div class="col-sm-10">
                <center><span style="font-size: 36px; color: darkblue;"><?php echo $_SESSION['NOM_OPCION_MENU'];?></span></center>
            </div>
            <div class="col-sm-2" style="padding-top: 5px; text-align: right;">
                <?php echo '<img alt=""  src="../../../empresas/' . $idEmpresa . '/logo/logopeq.png">';?>
            </div>
        </div>
        <div class="row">
            <div class="col-sm-11" style="font-size: 27px;">
                <div class="form-group">
                    <label for="sysNomPaciente">Paciente:&nbsp;&nbsp;</label>
                    <input type="text" class="form-control" style="font-size: 27px;" id="sysNomPaciente" name="sysNomPaciente" readonly="true" value="<?php echo $_SESSION['NOM_PACIENTE']; ?>">
                </div>
            </div>
            <div class="col-sm-1" style="font-size: 27px;">
		<br><button id="btnLogOut" class="btn btn-sm btn-danger" onclick="window.open('http://www.medicareips.com.co', '_self');"><i class="fa fa-angle-right"></i> Salir</button>
            </div>
        </div>

        <?php
        $records_per_page = 40;
        $from_record_num = ($records_per_page * $page) - $records_per_page;
        include_once 'includes/config.php';
        include_once 'includes/data.inc.php';
        $database = new ConfigCRUD();
        $db = $database->getConnection();
        $objCRUD = new DataCRUD($db);
        /*
         * $_SESSION['ID_PACIENTE'] = htmlentities($row[0]["idpaciente"]);
        $_SESSION['NOM_PACIENTE'] = htmlentities($row[0]["nomPaciente"]);
        $_SESSION['ESPACIENTE'] = "SI";
        $_SESSION['COD_USUARIO'] = htmlentities($row[0]["codusuario"]);
        $_SESSION['CLAVE_USUARIO'] = htmlentities($row[0]["claveusuario"]);
         */
        $stmt = $objCRUD->readAll($page, $from_record_num, $records_per_page, $_SESSION['CLAVE_USUARIO']);
        $num = $stmt->rowCount();
        ?>
        <div class="table-responsive" style="margin-right: 10px; margin-left: 10px;">
            <?php if($num>0){ ?>
                <table class="table table-bordered table-hover table-striped">
                    <thead>
                        <tr>
                            <th width="80%">Examen</th>
                            <th width="20%" align="center">Estado</th>
                        </tr>
                    </thead>
                    <tbody>
                    <?php
                    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)){
                        extract($row);
                        if($DescEstadoReg != "03 - CERRADO"){
                            if($DescEstadoReg == "02 - SIN CERRAR"){
                                echo '<tr class="warning">';
                            }else{
                                echo '<tr class="danger">';
                            }
                        }else{
                            if($Entregar == "SI"){
                                echo '<tr class="success">';
                            }else{
                                echo '<tr class="info">';
                            }
                        }
                        echo "<td width=\"80%\"><h5><span style=\"color: darkblue;\"><b>{$Examen}</b></span></h5></td>";
                        if($DescEstadoReg != "03 - CERRADO"){
                            if($DescEstadoReg == "02 - SIN CERRAR"){
                                echo "<td width=\"20%\" align='center'><h5><b>PENDIENTE CONFIRMAR RESULTADO</b></h5></td>";
                            }else{
                                echo "<td width=\"20%\" align='center'><h5><b>EN PROCESO</b></h5></td>";
                            }
                        }else{
                            if($Entregar == "SI"){
                                echo "<td width=\"20%\" align='center'><h5>
                                <a class='text-success' onclick=\"_oreport({$Paciente},{$CAS},{$ConsecutivoDetalle});\" role='button'><b><span class='gi gi-paperclip' aria-hidden='true'></span></b></a>&nbsp;&nbsp;<span style=\"color: darkgreen;\"><b>Ver</b></span>
                                </h5></td>";
                            }else{
                                echo "<td width=\"20%\" align='center'><h5><span style=\"color: darkred;\"><b>RECLAMAR EN LA IPS</b></span></h5></td>";
                            }
                        }
                        echo "</tr>";
                    } ?>
                    </tbody>
                </table>
                <?php
                $total_rows = $objCRUD->countAll($psearch);
                $total_pages = ceil($total_rows / $records_per_page);
                $range = 2;
                $initial_num = $page - $range;
                $condition_limit_num = ($page + $range) + 1;
            }else{?>
                <div class="alert alert-warning alert-dismissible" role="alert">
                    <span style="font-size: x-large;" class="fa fa-warning"></span>  No existen registros.
                </div>
            <?php } ?>
        </div>
        
        <!-- Modal -->
        <div id="winQuestionDelCRUD" class="modal fade bs-modal-static" tablist="-1" role="dialog" aria-labelledby="mySmallModalLabel" data-backdrop="static" aria-hidden="true">
            <div class="signinpanel">    
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                            <h4 class="modal-title" style="color:#0066cc;">Clientes</h4>
                        </div>
                        <div class="modal-body">
                            <p id="sysQuestionDelCRUD">Esta seguro que desea eliminar el registro seleccionado?</p>
                            <input type="hidden" id="sysCRUDId" name="sysCRUDId" value="0"/>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-default" data-dismiss="modal">NO</button>
                            <button type="button" class="btn btn-primary" data-dismiss="modal" id="btnDelCRUD">SI</button>
                        </div>
                    </div>
                </div>
            </div>
        </div><!-- modal -->
        <script>
            var txtSearch = "<?php echo $psearch; ?>";
            if(txtSearch !== "%"){
                $('#txtSearchList01').val("<?php echo $psearch; ?>");
            }
            $('#btnDelCRUD').click(function() {
                loadContenent('pages/clientes/delete.php?id='+$('#sysCRUDId').val());
            });
            function _oreport(p,c,x){
                window.open("../../controlador/asistencial/imprimirhclabaql.php?pT=N&pEmpresa=1&pIPS=1&pPaciente=" + p + "&pCAS=" + c + "&pConsecutivoDetalle=" + x,"Reporte Laboratorio");
            }
        </script>

        <script src="../../../libjq/js/vendor/jquery-2.2.1.js"></script>
        <script src="../../../libjq/js/vendor/jquery.gritter.min.js"></script>
        <script src="../../../libjq/js/vendor/bootstrap.min.js"></script>
        <script src="../../../libjq/js/plugins.js"></script>
        <script src="../../../libjq/js/app.js"></script>
        <script src="../../../libjq/js/tools.js"></script>
        <!--<script type="text/javascript" src="../../frm_js/agendauam1701/frmplantillaxconsultorio.js"></script>-->
    </body>
</html>

