<?php
/*
* @category    CRUD - Usuarios Sistema Clase
* @package     Nube Apps - Planificador
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@nubeapps.com.co>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     Planificador Ver 1.0
* @license     COMERCIAL
* @link        http://www.nubeapps.com.co
* @country     Colombia
* @teleph
*/
session_start();
class DataCRUD{
    private $conn;
    public $Prestador;
    public $Sede;
    public $IPS;
    public $Paciente;
    public $CAS;
    public $ConsecutivoDetalle;
    public $ConsecutivoHC;
    public $idCliente;
    public $idPlan;
    public $idSubPlan;
    public $idContrato;
    public $MarcaExenta;
    public $FechaCita;
    public $Profesional;
    public $Cliente;
    public $IdProcedimiento;
    public $CodProcedimiento;
    public $Examen;
    public $Agendado;
    public $YaLegalizado;
    public $HoraAgenda;
    public $HoraAtencion;
    public $FechaLegaliza;
    public $TipoLegalizacion;
    public $TipDoc;
    public $Documento;
    public $PrimerApellido;
    public $SegundoApellido;
    public $PrimerNombre;
    public $SegundoNombre;
    public $FecNac;
    public $Edad;
    public $Genero;
    public $Direccion;
    public $Zona;
    public $Telefono;
    public $Telefono1;
    public $YaRealizado;
    public $FechaRealizado;
    public $QuienRealizo;
    public $QuienTranscribio;
    public $Cerrado;
    public $EstadoReg;
    public $DescEstadoReg;
    public $TipoEstudio;
    public $FormatoDosColumnas;
    public $Entregar;
    public function __construct($db){
        $this->conn = $db;
    }
    
    function readAll($page, $from_record_num, $records_per_page, $pCAS){
        $query = 'SELECT
estudios.Prestador,
estudios.Sede,
estudios.IPS,
estudios.Paciente,
estudios.CAS,
estudios_detalle.ConsecutivoDetalle,
pacientes_evolucionhc.ConsecutivoHC,
estudios.Cliente AS idCliente,
estudios.Plan AS idPlan,
estudios.Subplan AS idSubPlan,
estudios.Contrato AS idContrato,
estudios.MarcaExenta,
estudios.FechaEstudio AS FechaCita,
IF(ISNULL(pprofesionales.Descripcion),"RADICACION",pprofesionales.Descripcion) AS Profesional,
pprestatario_clientes.Descripcion AS Cliente,
estudios_detalle.IdProcedimiento,
estudios_detalle.CodProcedimiento,
estudios_detalle.DescProcedimiento AS Examen,
estudios_detalle.Agendado,
estudios.YaLegalizado,
DATE_FORMAT(estudios.FechaLegaliza,"%h:%i %p") AS FechaLegaliza,
estudios.TipoLegalizacion,
pacientes.TipDoc,
pacientes.Documento,
pacientes.PrimerApellido,
pacientes.SegundoApellido,
pacientes.PrimerNombre,
pacientes.SegundoNombre,
DATE_FORMAT(pacientes.FecNac,"%d/%m/%Y") AS FecNac,
pacientes.Edad,
pacientes.Genero,
pacientes.Direccion,
pacientes.Zona,
pacientes.Telefono,
pacientes.Telefono1,
estudios_detalle.YaRealizado,
estudios_detalle.FechaRealizado,
ProfeRealiza.Descripcion AS QuienRealizo,
pprestatario_usuariossist.Descripcion AS QuienTranscribio,
pacientes_evolucionhc.ProfesionalTomaSignos AS Cerrado,
IF(ISNULL(pacientes_evolucionhc.ConsecutivoHC),"01",IF(ISNULL(estudios_detalle.YaRealizado),"02",IF(estudios_detalle.YaRealizado=0,"02","03"))) AS EstadoReg,
IF(ISNULL(pacientes_evolucionhc.ConsecutivoHC),"01 - SIN TRANSCRIBIR",IF(ISNULL(estudios_detalle.YaRealizado),"02 - SIN CERRAR",IF(estudios_detalle.YaRealizado=0,"02 - SIN CERRAR","03 - CERRADO"))) AS DescEstadoReg,
IF(estudios_detalle.CodProcedimiento IN ("906222", "906223", "906220", "906221", "906332", "906318", "906317", "908806", "908818", "908803", "906225", "908807", "908833", "906818", "908823", "906228", "906229", "906230", "906231", "908808", "908824", "906019", "906020", "906039", "906039", "906040", "906041", "906039", "906625", "908802", "908801", "906302", "908832", "908832", "906249", "906250", "908802", "904508", "904508", "905724", "905726", "905726", "906915"),"NO","SI") AS Entregar,
ptipoestudio.Descripcion AS TipoEstudio,
IF(ISNULL(pprocedimientos.LabFormato2Cols),0,pprocedimientos.LabFormato2Cols) AS FormatoDosColumnas
FROM
estudios
Inner Join estudios_detalle ON estudios.CAS = estudios_detalle.CAS
Inner Join pprestatario_clientes ON estudios.Cliente = pprestatario_clientes.IdCliente AND estudios.Prestador = pprestatario_clientes.Prestador
Inner Join pacientes ON pacientes.Paciente = estudios.Paciente
Left Join pprofesionales ON estudios.ProfesionalCita = pprofesionales.idProfesional
Left Join pacientes_evolucionhc ON estudios_detalle.ConsecutivoDetalle = pacientes_evolucionhc.ConsecutivoDetalle
Left Join pprofesionales AS ProfeRealiza ON pacientes_evolucionhc.Profesional = ProfeRealiza.idProfesional
Left Join pprestatario_usuariossist ON pacientes_evolucionhc.Usuario = pprestatario_usuariossist.IdUsuario
Inner Join pprocedimientos ON estudios_detalle.IdProcedimiento = pprocedimientos.IdProced
Inner Join ptipoestudio ON pprocedimientos.IdTipoEstudio = ptipoestudio.IdTipoEstudio
WHERE
(estudios_detalle.CodProcedimiento LIKE "90%" OR ptipoestudio.Descripcion LIKE "%LABORATORIO%" OR ptipoestudio.Descripcion LIKE "%QUIMICA%" OR ptipoestudio.Descripcion LIKE "%HEMATOLOG%") AND 
estudios.CAS = ' . $pCAS . ' ORDER BY
estudios.FechaEstudio,
IF(ISNULL(pacientes_evolucionhc.ConsecutivoHC),"01",IF(estudios_detalle.YaRealizado=0,"02","03")),
IF(ISNULL(pprofesionales.Descripcion),"RADICACION",pprofesionales.Descripcion),
estudios.CAS';
        //echo $query;
        $stmt = $this->conn->prepare( $query );
        $stmt->execute();
        return $stmt;
    }
    public function countAll($pCAS){
        $query = 'SELECT
estudios.Prestador,
estudios.Sede,
estudios.IPS,
estudios.Paciente,
estudios.CAS,
estudios_detalle.ConsecutivoDetalle,
pacientes_evolucionhc.ConsecutivoHC,
estudios.Cliente AS idCliente,
estudios.Plan AS idPlan,
estudios.Subplan AS idSubPlan,
estudios.Contrato AS idContrato,
estudios.MarcaExenta,
estudios.FechaEstudio AS FechaCita,
IF(ISNULL(pprofesionales.Descripcion),"RADICACION",pprofesionales.Descripcion) AS Profesional,
pprestatario_clientes.Descripcion AS Cliente,
estudios_detalle.IdProcedimiento,
estudios_detalle.CodProcedimiento,
estudios_detalle.DescProcedimiento AS Examen,
estudios_detalle.Agendado,
estudios.YaLegalizado,
DATE_FORMAT(estudios.FechaLegaliza,"%h:%i %p") AS FechaLegaliza,
estudios.TipoLegalizacion,
pacientes.TipDoc,
pacientes.Documento,
pacientes.PrimerApellido,
pacientes.SegundoApellido,
pacientes.PrimerNombre,
pacientes.SegundoNombre,
DATE_FORMAT(pacientes.FecNac,"%d/%m/%Y") AS FecNac,
pacientes.Edad,
pacientes.Genero,
pacientes.Direccion,
pacientes.Zona,
pacientes.Telefono,
pacientes.Telefono1,
estudios_detalle.YaRealizado,
estudios_detalle.FechaRealizado,
ProfeRealiza.Descripcion AS QuienRealizo,
pprestatario_usuariossist.Descripcion AS QuienTranscribio,
pacientes_evolucionhc.ProfesionalTomaSignos AS Cerrado,
IF(ISNULL(pacientes_evolucionhc.ConsecutivoHC),"01",IF(ISNULL(estudios_detalle.YaRealizado),"02",IF(estudios_detalle.YaRealizado=0,"02","03"))) AS EstadoReg,
IF(ISNULL(pacientes_evolucionhc.ConsecutivoHC),"01 - SIN TRANSCRIBIR",IF(ISNULL(estudios_detalle.YaRealizado),"02 - SIN CERRAR",IF(estudios_detalle.YaRealizado=0,"02 - SIN CERRAR","03 - CERRADO"))) AS DescEstadoReg,
ptipoestudio.Descripcion AS TipoEstudio,
IF(ISNULL(pprocedimientos.LabFormato2Cols),0,pprocedimientos.LabFormato2Cols) AS FormatoDosColumnas
FROM
estudios
Inner Join estudios_detalle ON estudios.CAS = estudios_detalle.CAS
Inner Join pprestatario_clientes ON estudios.Cliente = pprestatario_clientes.IdCliente AND estudios.Prestador = pprestatario_clientes.Prestador
Inner Join pacientes ON pacientes.Paciente = estudios.Paciente
Left Join pprofesionales ON estudios.ProfesionalCita = pprofesionales.idProfesional
Left Join pacientes_evolucionhc ON estudios_detalle.ConsecutivoDetalle = pacientes_evolucionhc.ConsecutivoDetalle
Left Join pprofesionales AS ProfeRealiza ON pacientes_evolucionhc.Profesional = ProfeRealiza.idProfesional
Left Join pprestatario_usuariossist ON pacientes_evolucionhc.Usuario = pprestatario_usuariossist.IdUsuario
Inner Join pprocedimientos ON estudios_detalle.IdProcedimiento = pprocedimientos.IdProced
Inner Join ptipoestudio ON pprocedimientos.IdTipoEstudio = ptipoestudio.IdTipoEstudio
WHERE
(estudios_detalle.CodProcedimiento LIKE "90%" OR ptipoestudio.Descripcion LIKE "%LABORATORIO%" OR ptipoestudio.Descripcion LIKE "%QUIMICA%" OR ptipoestudio.Descripcion LIKE "%HEMATOLOG%") AND 
estudios.CAS = ' . $pCAS . ' ORDER BY
estudios.FechaEstudio,
IF(ISNULL(pacientes_evolucionhc.ConsecutivoHC),"01",IF(estudios_detalle.YaRealizado=0,"02","03")),
IF(ISNULL(pprofesionales.Descripcion),"RADICACION",pprofesionales.Descripcion), 
estudios.CAS';
        $stmt = $this->conn->prepare( $query );
        $stmt->execute();
        $num = $stmt->rowCount();
        //echo $query;
        return $num;
    }
}