/*
* @category    Formulario Excluir Horario
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winFrmEnvioSMSUi = Ext.extend(Ext.Window, {
    //title: 'OfiClinic© Web..! .:: Agenda por Profesional ::.',
    id: 'winFrmEnvioSMS',
    closable:false,
    autoScroll: true,
    width:450,
    //height:260,
    autoHeight: true,
    closeAction: 'hide',
    plain: true,
    modal: true,
    frame: true,
    border: false,
    draggable: false,
    resizable: false,
    //draggable : false,
    y:120,
    padding: 5,
    layout: 'form',
    initComponent: function() {
        
        var mybbar = new utilBbarUi();
        this.bbar = mybbar;
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmEnvioSMS',
                border: false,
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'compositefield',
                        anchor: '100%',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'datefield',
                                fieldLabel: 'Fecha',
                                anchor: '23%',
                                allowBlank: false,
                                id: 'sysFecAgenda'
                            },
                            {
                                html: ' - '
                            },
                            {
                                xtype: 'button',
                                text: 'Enviar Mensajes de Recordatorio',
                                iconCls: 'btnAceptar',
                                id: 'btnEnvioSMS',
                                listeners:{
                                    click : function(){
                                        var myToken = "";
                                        var frm = Ext.getCmp('frmEnvioSMS').getForm();
                                        if (frm.isValid()){
                                            Ext.Msg.show({
                                                title: 'OfiClinic',
                                                msg: 'Esta Seguro que Desea Enviar los Recordatorios de Citas?',
                                                buttons: Ext.Msg.YESNO,
                                                icon: Ext.Msg.QUESTION,
                                                fn: function(btn){
                                                    if(btn === "yes"){
                                                        Ext.Ajax.request({
                                                            url: '../../controlador/sms/controlador_smstoma2021.php',
                                                            params:{
                                                                task: 'getConnection'
                                                            },
                                                            success: function(response,options){
                                                                var el = Ext.get('response'); // get the LOG
                                                                var Respuesta = response.responseText;
                                                                var Contenido = Respuesta.split('^');
                                                                if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                                    Ext.Msg.show({
                                                                        title: 'eOfiClinic',
                                                                        msg: 'Error al establecer conexion 01',
                                                                        buttons: Ext.Msg.OK,
                                                                        icon: Ext.Msg.ERROR
                                                                    });
                                                                } else {
                                                                    //Enviar solicitud de los Mensajes
                                                                    var myHeaders = new Headers();
                                                                    myHeaders.append("Content-Type", "application/json");
                                                                    var raw = JSON.stringify({
                                                                        "correo": Contenido[0],
                                                                        "password": Contenido[1]
                                                                    });
                                                                    var requestOptions = {
                                                                        method: 'POST',
                                                                        headers: myHeaders,
                                                                        body: raw,
                                                                        redirect: 'follow'
                                                                    };
                                                                    fetch("https://apis.medicareips.com.co//api/auth/login", requestOptions)
                                                                    .then(response => response.json())
                                                                    .then(result => {
                                                                        myToken = result.token;
                                                                        //Traer los registros para el envio del mensaje de texto
                                                                        Ext.Msg.wait('Enviando recordatorio de citas... por favor espere!');
                                                                        Ext.Ajax.request({
                                                                            url: '../../controlador/sms/controlador_smstoma2021.php',
                                                                            params:{
                                                                                task: 'getCitas',
                                                                                pFecha: Ext.getCmp('sysFecAgenda').getValue().format('Y-m-d')
                                                                            },
                                                                            success: function(response,options){
                                                                                var el = Ext.get('response'); 
                                                                                var objCitas = response.responseText;
                                                                                const myArr = JSON.parse(objCitas);
                                                                                var reg = 0;
                                                                                myArr.forEach(item => {
                                                                                    if(item.Mensaje !== "" && item.Mensaje !== null){
                                                                                        reg++;
                                                                                        var newCelular = "57" + item.Celular;
                                                                                        var myHeaders = new Headers();
                                                                                        myHeaders.append("x-token", myToken);
                                                                                        myHeaders.append("Content-Type", "application/json");

                                                                                        var raw = JSON.stringify({
                                                                                          "from": "MEDICARE",
                                                                                          "to": newCelular,
                                                                                          "text": item.Mensaje
                                                                                        });

                                                                                        var requestOptions = {
                                                                                          method: 'POST',
                                                                                          headers: myHeaders,
                                                                                          body: raw,
                                                                                          redirect: 'follow'
                                                                                        };

                                                                                        fetch("https://apis.medicareips.com.co//api/contact-service/enviar-sms", requestOptions)
                                                                                          .then(response => response.text())
                                                                                          .then(result => console.log("ok"))
                                                                                          .catch(error => console.log('error', error));
                                                                                    }
                                                                                });
                                                                                Ext.Msg.hide();
                                                                                if(reg === 0){
                                                                                    Ext.Msg.show({
                                                                                        title: 'eOfiClinic',
                                                                                        msg: 'No existen citas para enviar recordatorio y/o fecha ya no es valida',
                                                                                        buttons: Ext.Msg.OK,
                                                                                        icon: Ext.Msg.ERROR
                                                                                    });
                                                                                }else{
                                                                                    Ext.Msg.show({
                                                                                    title: 'eOfiClinic',
                                                                                    msg: 'Se enviaron los mensajes de texto con exito',
                                                                                    buttons: Ext.Msg.OK,
                                                                                    icon: Ext.Msg.INFO
                                                                                });
                                                                                }
                                                                            },
                                                                            failure: function(response,options){
                                                                                Ext.Msg.show({
                                                                                    title: 'eOfiClinic',
                                                                                    msg: 'Error Generar al establecer conexion 02',
                                                                                    buttons: Ext.Msg.OK,
                                                                                    icon: Ext.Msg.ERROR
                                                                                });
                                                                            },
                                                                            scope:this //bind the callbacks

                                                                        });
                                                                    })
                                                                    .catch(error => console.log('error', error));
                                                                }
                                                            },
                                                            failure: function(response,options){
                                                                Ext.Msg.show({
                                                                    title: 'eOfiClinic',
                                                                    msg: 'Error Generar al establecer conexion',
                                                                    buttons: Ext.Msg.OK,
                                                                    icon: Ext.Msg.ERROR
                                                                });
                                                            },
                                                            scope:this //bind the callbacks
                                                        });
                                                    }
                                                }
                                            });
                                        }else{
                                            Ext.MessageBox.show({
                                                title: 'Error',
                                                msg: 'Todos los campos son Requeridos',
                                                buttons: Ext.MessageBox.OK,
                                                icon: Ext.MessageBox.ERROR
                                            });
                                        }
                                    }
                                }
                            }
                        ]
                    }
                ]
            }
        ];
        winFrmEnvioSMSUi.superclass.initComponent.call(this);
    }
});
