/*
* @category    Formulario Grid Horarios
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winFrmHorariosUi = Ext.extend(Ext.Window, {
    title: 'OfiClinic© Web..! .:: Tipos de Horario ::.',
    id: 'winFrmTipoHorarios',
    closable:false,
    width:980,
    height:480,
    plain:true,
    resizable : false,
    y:120,
    layout: 'fit',
    initComponent: function() {
        var mybbar = new utilBbarUi();
        var stGrid = new StoreGridTiposHorario();
        el = Ext.get('idempresa');
        var ID_EMPRESA = el.getValue();
        this.tbar = [
            {
                xtype: 'toolbar',
                anchor: '99%',
                items: [
                    {
                        xtype: 'tbfill'
                    },
                    {
                        xtype: 'button',
                        text: 'Exportar a Excel',
                        iconCls: 'btnExcel',
                        ref: '../btnExcelTipoHorario',
                        id: 'btnExcelTipoHorario'
                    },
                    {
                        xtype: 'tbseparator'
                    },
                    {
                        xtype: 'button',
                        text: 'Imprimir',
                        iconCls: 'btnImprimir',
                        ref: '../btnImprimirTipoHorario',
                        id: 'btnImprimirTipoHorario'
                    }
                ]
            }
        ],
        this.bbar = mybbar;
        this.items = [
            {
                xtype: 'grid',
                id: 'gridTiposHorario',
                store: stGrid,
                anchor: "100%",
                border: false,
                frame: true,
                columns: [
                    {
                        xtype: 'gridcolumn',
                        header: 'Id',
                        sortable: false,
                        width: 1,
                        hidden: true,
                        hideable: false,
                        dataIndex: 'IdTipoHorario',
                        id: 'IdTipoHorario'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Prestador',
                        sortable: false,
                        width: 1,
                        hidden: true,
                        hideable: false,
                        dataIndex: 'Prestador',
                        id: 'Prestador'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'IdCita',
                        sortable: false,
                        width: 1,
                        hidden: true,
                        hideable: false,
                        dataIndex: 'IdCita',
                        id: 'IdCita'
                    },

                    {
                        xtype: 'gridcolumn',
                        header: 'Descripción Cita',
                        sortable: false,
                        width: 330,
                        dataIndex: 'DesCita',
                        id: 'DesCita'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Descripción Impresión',
                        sortable: false,
                        width: 150,
                        dataIndex: 'DesImprime',
                        id: 'DesImprime'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Hora Estimada Atención',
                        sortable: false,
                        width: 150,
                        dataIndex: 'HoraAtencion',
                        id: 'HoraAtencion'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Modificado Por',
                        sortable: false,
                        width: 150,
                        dataIndex: 'Usuario',
                        id: 'Usuario'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Fecha Modificación',
                        sortable: false,
                        width: 150,
                        dataIndex: 'FechaAct',
                        id: 'FechaAct'
                    }
                ],
                selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                tbar:
                    {
                        xtype: 'toolbar',
                        items: [
                            {
                                xtype: 'button',
                                text: 'Adicionar Tipo Horario',
                                iconCls: 'btnAddRow',
                                ref: '../btnAddTipoHorario',
                                id: 'btnAddTipoHorario'
                            },
                            {
                                xtype: 'tbseparator'
                            },
                            {
                                xtype: 'button',
                                text: 'Modificar Tipo Horario',
                                iconCls: 'btnEditRow',
                                ref: '../btnEditTipoHorario',
                                id: 'btnEditTipoHorario'
                            },
                            {
                                xtype: 'tbseparator'
                            },
                            {
                                xtype: 'button',
                                text: 'Eliminar Tipo Horario',
                                iconCls: 'btnDelRow',
                                ref: '../btnDelTipoHorario',
                                id: 'btnDelTipoHorario'
                            },
                            {
                                xtype: 'tbfill'
                            },
                            new Ext.app.SearchField({
                                id: 'qryTipoHorario',
                                store: stGrid,
                                ValparamP1: ID_EMPRESA,
                                emptyText: 'Escriba el criterio que desea buscar',
                                params: {pEmpresa: Ext.get('idempresa').getValue(), start: 0, limit: 15},
                                width: 120
                            })
                        ]
                    },
                bbar: new Ext.PagingToolbar({
                    pageSize: 15,
                    store: stGrid,
                    displayInfo: true
                })
            }
        ];
        winFrmHorariosUi.superclass.initComponent.call(this);
    }
});
