/*
* @category    Formulario Tipo Horarios
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winTipoHorarioUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic .:: Tipo Horarios ::.',
    width: 900,
    autoHeight: true,
    modal: true,
    closable: false,
    padding: 10,
    id: 'winTipoHorarioUi',
    initComponent: function() {
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmTipoHorario',
                padding: 10,
                items: [
                    {
                        html:'<img src="../../../resources/varios/tipohorario.png" align="left" alt=""/>',border: false
                    },
                    {
                        html:'</br>',border: false
                    },
                    {
                        xtype: 'panel',
                        layout: 'form',
                        border: false,
                        labelWidth: 170,
                        items: [
                            {
                                xtype: 'hidden',
                                id: 'intIdTipoHorario',
                                value: 0
                            },
                            {
                                xtype: 'hidden',
                                id: 'intPrestador',
                                value: 0
                            },
                            {
                                xtype: 'hidden',
                                id: 'intUsuario',
                                value: 0
                            },
                            {
                                xtype: 'textfield',
                                anchor: '100%',
                                fieldLabel: 'ID Cita',
                                name: 'strIdCita',
                                allowBlank: false,
                                emptyText: 'Digite el ID Cita p.e. 07:00a08:00',
                                id: 'strIdCita'
                            },
                            {
                                xtype: 'textfield',
                                anchor: '100%',
                                fieldLabel: 'Descripción Cita',
                                name: 'strDesCita',
                                allowBlank: false,
                                emptyText: 'Digite la Descripción p.e. 07:00 - 08:00 am',
                                id: 'strDesCita'
                            },
                            {
                                xtype: 'textfield',
                                anchor: '100%',
                                fieldLabel: 'Texto Impresión Cita',
                                name: 'strDesImprime',
                                allowBlank: false,
                                emptyText: 'Digite la Descripción a Imprimir p.e. 07:00 am',
                                id: 'strDesImprime'
                            },
                            {
                                xtype: 'timefield',
                                fieldLabel: 'Hora Estimada de Atención',
                                anchor: '100%',
                                name: 'strHoraAtencion',
                                allowBlank: true,
                                minValue: '6:00 AM',
                                maxValue: '9:00 PM',
                                emptyText: 'p.e. 07:00:00',
                                format:'H:i:s',
                                id: 'strHoraAtencion'
                            },
                            {
                                xtype: 'textfield',
                                anchor: '100%',
                                fieldLabel: 'Usuario',
                                name: 'sysUsuario',
                                readOnly: true,
                                allowBlank: true,
                                id: 'sysUsuario'
                            },
                            {
                                xtype: 'textfield',
                                anchor: '100%',
                                fieldLabel: 'Fecha Modificación',
                                name: 'sysFechaAct',
                                readOnly: true,
                                allowBlank: true,
                                id: 'sysFechaAct'
                            }
                        ]
                    },
                    {
                        html:'</br>',border: false
                    },
                ],
                tbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar',
                            iconCls: 'btnGuardar',
                            ref: '../btn_AdicionarHorario',
                            id: 'btn_AdicionarHorario'
                        },
                        {
                            xtype: 'button',
                            text: 'Modificar',
                            iconCls: 'btnGuardar',
                            ref: '../btn_ModificarHorario',
                            id: 'btn_ModificarHorario'
                        }
                    ]
                },
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            ref: '../btn_SalirHorario',
                            id: 'btn_SalirHorario'
                        }
                    ]
                }
            }
        ];
        winTipoHorarioUi.superclass.initComponent.call(this);
    }
});
