/*
* @category    Formulario Grid Historial de Citas 
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winFrmHistorialCitasUi = Ext.extend(Ext.Window, {
    title: 'OfiClinic© Web..! .:: Historial de Citas ::.',
    id: 'winFrmHistorialCitas',
    closable: true,
    width: 980,
    height: 480,
    plain: true,
    resizable: false,
    modal: true,
    y:120,
    layout: 'fit',
    initComponent: function() {
        var stGrid = new StoreGridHistorialCitasConfirmadas();
        el = Ext.get('idempresa');
        var ID_EMPRESA = el.getValue();
        
        function VerMotivoCancela(value,metaData){
            metaData.attr = 'style="white-space:normal; color:#8A0808"';
            return value;
	}
        
        /*var linkButton = new Ext.LinkButton({
            id: 'grid-excel-button',
            //iconCls: 'btnExcel',
            text: 'Exportar'
        });
        
        this.linkButton.getEl().child('a', true).href = 'data:application/vnd.ms-excel;base64,' +
        Base64.encode(Ext.getCmp('gridHistorialCitas').getExcelXml());
        */
        this.items = [
            {
                xtype: 'grid',
                id: 'gridHistorialCitas',
                store: stGrid,
                anchor: "100%",
                border: false,
                frame: true,
                stripeRows: true,
                columns:[
                    {
                        xtype: 'gridcolumn',
                        header: 'Id',
                        sortable: false,
                        width: 1,
                        hidden: true,
                        hideable: false,
                        dataIndex: 'idPaciente',
                        id: 'idPacienteHistorialCitas'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Fecha',
                        sortable: false,
                        width: 90,
                        dataIndex: 'FecCita',
                        id: 'FecCitaHistorialCitas'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Descripción Cita',
                        sortable: false,
                        width: 200,
                        dataIndex: 'DesCita',
                        id: 'DesCitaHistorialCitas'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Info Add Cita',
                        sortable: false,
                        width: 100,
                        dataIndex: 'DescAdiHora',
                        id: 'DescAdiHoraHistorialCitas'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'CAS',
                        sortable: true,
                        width: 100,
                        dataIndex: 'CAS',
                        id: 'CASHistorialCitas'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Fecha Cancelación',
                        sortable: false,
                        width: 110,
                        dataIndex: 'FechaCancela',
                        id: 'FechaCancelaHistorialCitas'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Usuario Quien Cancela',
                        sortable: false,
                        width: 150,
                        dataIndex: 'UsuarioCancela',
                        id: 'UsuarioCancelaHistorialCitas'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Motivo Cancelación',
                        sortable: false,
                        width: 250,
                        renderer: VerMotivoCancela,
                        dataIndex: 'MotivoCancela',
                        id: 'MotivoCancelaHistorialCitas'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Usuario Quien Marca Inasistencia',
                        sortable: false,
                        width: 150,
                        dataIndex: 'UsuarioInasistencia',
                        id: 'UsuarioInasistenciaHistorialCitas'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Profesional',
                        sortable: false,
                        width: 250,
                        dataIndex: 'Profesional',
                        id: 'ProfesionalHistorialCitas'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Ubicación',
                        sortable: false,
                        width: 250,
                        dataIndex: 'Ubicacion',
                        id: 'UbicacionHistorialCitas'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Actividad Programada',
                        sortable: false,
                        width: 250,
                        dataIndex: 'DescProcedimiento',
                        id: 'DescProcedimientoHistorialCitas'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Cliente',
                        sortable: false,
                        width: 250,
                        dataIndex: 'Cliente',
                        id: 'ClienteHistorialCitas'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Usuario Quien Asigno',
                        sortable: false,
                        width: 150,
                        dataIndex: 'UsuarioAsigna',
                        id: 'UsuarioAsignoHistorialCitas'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Fecha Asignación',
                        sortable: false,
                        width: 120,
                        dataIndex: 'FecAsigna',
                        id: 'FechaAsignaHistorialCitas'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Observaciones',
                        sortable: false,
                        width: 250,
                        dataIndex: 'ObservacionesAsigna',
                        id: 'ObservacionesHistorialCitas'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Oportunidad',
                        sortable: false,
                        width: 100,
                        dataIndex: 'Oportunidad',
                        id: 'OportunidadHistorialCitas'
                    }
                ],   
                columnLines: true,
                /*tbar: new Ext.Toolbar({
                    buttons: [linkButton]
                }),*/
                bbar: new Ext.PagingToolbar({
                    pageSize: 15,
                    store: stGrid,
                    displayInfo: true
                })
            }
        ];
        winFrmHistorialCitasUi.superclass.initComponent.call(this);
            
    }
});
