/*
* @category    Formulario Cancelar Cita
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winCitaRechazadaPacienteUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic .:: Cita Rechazada o Cancelada ::.',
    width: 900,
    autoHeight: true,
    modal: true,
    closable: true,
    padding: 10,
    id: 'winConfirmacionCitaPaciente',
    initComponent: function() {
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmConfirmacionCitaPaciente',
                padding: 10,
                border: false,
                style: 'background:transparent;',
                items: [
                    {
                        html: '<img src="../../../resources/varios/agendablock.png" align="left" alt=""/>',
                        style: 'background:transparent;',
                        border: false
                    },
                    {
                        html:'&nbsp;&nbsp;&nbsp;',
                        border: false
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        value: 'NA',
                        fieldLabel: 'Pantalla',
                        id: 'sysPantalla'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        value: 'NA',
                        fieldLabel: 'Pantalla',
                        id: 'sysIdAgendaManual'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Usuario',
                        id: 'sysUsuario'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'IdPaciente',
                        id: 'sysIdPaciente'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'CAS',
                        id: 'sysCAS'
                    },
                    {
                        xtype: 'compositefield',
                        anchor: '100%',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                width: 150,
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'Paciente',
                                id: 'sysPrimerApellido'
                            },
                            {
                                xtype: 'textfield',
                                width: 150,
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysSegundoApellido'
                            },
                            {
                                xtype: 'textfield',
                                width: 150,
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysPrimerNombre'
                            },
                            {
                                xtype: 'textfield',
                                width: 150,
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysSegundoNombre'
                            },
                        ]
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Profesional',
                        id: 'sysProfesionalAgenda'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Sede',
                        id: 'sysSede'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Fecha',
                        id: 'sysFecha'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Hora',
                        id: 'sysHora'
                    },
                    {
                        xtype: 'displayfield',
                        value: ' '
                    },
                    {
                        xtype: 'textarea',
                        anchor: '100%',
                        fieldLabel: 'Informacion de la Cancelacion o Rechazo Cita',
                        name: 'strObservacionConfirmacion',
                        maxLength: 250,
                        allowBlank: false,
                        emptyText: 'Digite el Motivo de la Informacion de la Cancelacion o Rechazo Cita...!',
                        id: 'strObservacionConfirmacion'
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Cancelacion Cita',
                            iconCls: 'btnAsignarCita',
                            id: 'btnConfirmarCita',
                            listeners:{
                                click : function(){
                                    Ext.Msg.show({
                                    title: 'Confirmar Cita....!',
                                    msg: 'Esta seguro que desea Confirmar la Cancelacion de la Cita del Usuario Seleccionado?',
                                    buttons: Ext.Msg.YESNO,
                                    icon: Ext.Msg.QUESTION,
                                    fn: function(btn)
                                    {
                                        if(btn=="yes")
                                        {
                                          var frm = Ext.getCmp('frmConfirmacionCitaPaciente').getForm();
                                            if (frm.isValid())
                                            {
                                                frm.submit({
                                                    url: '../../controlador/asignarcitasesp/controlador_confirmacion_citas.php',
                                                    params: {
                                                        task: 'RECHAZO_CITA',
                                                        pUsuario: Ext.getCmp('sysUsuario').getValue(),
                                                        pCAS: Ext.getCmp('sysCAS').getValue(),
                                                        pFecha: Ext.getCmp('sysFecha').getValue(),
                                                        pHora: Ext.getCmp('sysHora').getValue(),
                                                        pIdAgendaManual: Ext.getCmp('sysIdAgendaManual').getValue(),
                                                        pPaciente: Ext.getCmp('sysIdPaciente').getValue(),
                                                        pObservacionesCon: Ext.getCmp('strObservacionConfirmacion').getValue()
                                                    },
                                                    success: function(res,req)
                                                    {
                                                        switch(req.result.requestedId){
                                                            case "1":
                                                                Ext.MessageBox.show({
                                                                    title: 'Confirmar Cita',
                                                                    msg: 'Se realizo la Marcacion de Rechazo a la Cita Seleccionada con Exito.',
                                                                    buttons: Ext.MessageBox.OK,
                                                                    icon: Ext.MessageBox.INFO
                                                                });
                                                                Ext.getCmp('winConfirmacionCitaPaciente').close();
                                                                Ext.getCmp('gridConfirmacionCitas').store.reload();
                                                                break;

                                                            default:
                                                                Ext.MessageBox.show({
                                                                    title: 'Confirmar Cita',
                                                                    msg: 'Ocurrio un error o no se pudo establecer conexión con el servidor.',
                                                                    buttons: Ext.MessageBox.OK,
                                                                    icon: Ext.MessageBox.ERROR
                                                                });
                                                                break;
                                                        }
                                                    },
                                                    failure: function(response,options)
                                                    {
                                                        Ext.MessageBox.show({
                                                            title: 'Error Base Datos',
                                                            msg: 'No podemos Marcar la Cita como Rechazada en estos momentos',
                                                            buttons: Ext.MessageBox.OK,
                                                            icon: Ext.MessageBox.ERROR
                                                        });
                                                    }
                                                });
                                            }else{
                                                Ext.MessageBox.show({
                                                    title: 'Error',
                                                    msg: 'El Usuario es Requerido',
                                                    buttons: Ext.MessageBox.OK,
                                                    icon: Ext.MessageBox.ERROR
                                                });
                                            }
                                        }
                                    }
                                });
                            }
                        }
                    }
                ]
            }
        }];
        winCitaRechazadaPacienteUi.superclass.initComponent.call(this);
    }
});
