/*
* @category    Formulario Radicar Citas Especialistas
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winFrmConfirmacionCitaEspUi = Ext.extend(Ext.Window, {
    layout: 'fit',
    title: '.:: Confirmacion de Citas con Especialistas ::.',
    width: 1000,
    height: 540,
    closeAction: 'hide',
    plain: true,
    modal: true,
    frame: true,
    border: false,
    closable: false,
    draggable: false,
    resizable: false,
    id: 'winFrmConfirmacionCitaEsp',
    initComponent: function() {
        Ext.BLANK_IMAGE_URL = '../../../lib/extjs/resources/images/default/s.gif';
        wPaciente = 0;
        wCAS = 0;
        
        var stGrid = new StoreGridConsultasxConfirmar();
        
        
        //Store Local
        
        this.items = [
            {
                xtype: 'form',
                frame: true,
                autoHeight: true,
                anchor: '100%',
                autoScroll: true,
                id: 'frmPacientesConfirmacionCitaManual',
                items: [
                    {
                        xtype: 'hidden',
                        id: 'intPacienteLegalizacion',
                        value: 0
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysIdEmpresa',
                        value: 0
                    },
                    {
                        xtype: 'compositefield',
                        anchor: '100%',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                width: 800,
                                fieldLabel: 'Paciente',
                                readOnly: true,
                                allowBlank: true,
                                emptyText: 'Debe Buscar Paciente....',
                                id: 'sysPacienteLegalizacion'
                            },
                            {
                                xtype: 'button',
                                iconCls: 'btnBuscar',
                                tooltip: 'Buscar Paciente',
                                id: 'btnBuscarPacienteLegalizacion'
                            },
                            {
                                xtype: 'button',
                                tooltip: 'Limpiar Datos del Paciente',
                                iconCls: 'btnLimpiar',
                                id: 'btnLimpiarPacienteLegalizacion'
                            }
                        ]
                    },
                    {
                        xtype: 'compositefield',
                        anchor: '100%',
                        style: 'background:transparent;',
                        items: [
                            {
                                html: 'Desde'
                            },
                            {
                                xtype: 'datefield',
                                width: 120,
                                fieldLabel: 'Fecha Agenda',
                                name: 'Fecha Agenda Desde',
                                allowBlank: true,
                                emptyText: '(dia/mes/año) ',
                                style: 'text-align:center;',
                                id: 'fecAgendaDesde'
                            },
                            {
                                html: 'Hasta'
                            },
                            {
                                xtype: 'datefield',
                                width: 120,
                                name: 'Fecha Agenda Hasta',
                                allowBlank: true,
                                emptyText: '(dia/mes/año) ',
                                style: 'text-align:center;',
                                id: 'fecAgendaHasta'
                            }
                        ]
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: 'Municipio',
                        width: 400,
                        allowBlank: true,
                        store: 'StoreDeptoMuni',
                        valueField: 'IdDeptoMunicipio',
                        displayField: 'Descripcion',
                        emptyText: 'Seleccione Municipio - Departamento....',
                        mode: 'local',
                        listWidth: 450,
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        id: 'strAgendaMunicipio'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: 'Cliente',
                        width: 400,
                        allowBlank: true,
                        store: 'StoreCliente',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        valueField: 'Codigo',
                        displayField: 'Descripcion',
                        emptyText: 'Seleccione Cliente....',
                        mode: 'local',
                        triggerAction: 'all',
                        forceSelection: true,
                        id: 'sysCliente'
                    },
                ]
            },
            {
                xtype: 'grid',
                id: 'gridConfirmacionCitas',
                store: stGrid,
                autoWidth: true,
                height: 350,
                border: false,
                frame: true,
                loadMask: true,
                stripeRows: true,
                colModel: new Ext.ux.grid.LockingColumnModel([
                    {
                        header: 'Profesional',
                        readOnly: true,
                        sortable: false,
                        dataIndex: 'Profesional',
                        width: 250,
                        hideable: false
                    },
                    {
                        header: 'Sede Cita',
                        readOnly: true,
                        sortable: false,
                        dataIndex: 'Sede',
                        width: 100,
                        hideable: false
                    },
                    {
                        header: 'Fecha Cita',
                        readOnly: true,
                        sortable: false,
                        dataIndex: 'FechaCita',
                        width: 90,
                        align: 'center',
                        hideable: false
                    },
                    {
                        header: 'Hora Cita',
                        readOnly: true,
                        sortable: false,
                        dataIndex: 'HoraCita',
                        width: 70,
                        align: 'center',
                        hideable: false
                    },
                    {
                        header: 'TipoDoc',
                        readOnly: true,
                        sortable: false,
                        dataIndex: 'TipDoc',
                        width: 50,
                        hideable: false
                    },
                    {
                        header: 'Documento',
                        readOnly: true,
                        sortable: false,
                        dataIndex: 'Documento',
                        width: 100,
                        hideable: false
                    },
                    {
                        header: 'PrimerApellido',
                        readOnly: true,
                        sortable: false,
                        dataIndex: 'PrimerApellido',
                        width: 120,
                        hideable: false
                    },
                    {
                        header: 'SegundoApellido',
                        readOnly: true,
                        sortable: false,
                        dataIndex: 'SegundoApellido',
                        width: 120,
                        hideable: false
                    },
                    {
                        header: 'PrimerNombre',
                        readOnly: true,
                        sortable: false,
                        dataIndex: 'PrimerNombre',
                        width: 120,
                        hideable: false
                    },
                    {
                        header: 'SegundoNombre',
                        readOnly: true,
                        sortable: false,
                        dataIndex: 'SegundoNombre',
                        width: 120,
                        hideable: false
                    },
                    {
                        header: 'Observaciones',
                        readOnly: true,
                        sortable: false,
                        dataIndex: 'Observaciones',
                        width: 320,
                        hideable: false
                    },
                    {
                        header: 'Telefono1',
                        readOnly: true,
                        sortable: false,
                        dataIndex: 'Telefono',
                        width: 70,
                        hideable: false
                    },
                    {
                        header: 'Telefono2',
                        readOnly: true,
                        sortable: false,
                        dataIndex: 'Telefono1',
                        width: 70,
                        hideable: false
                    }
                ]),
                selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                view: new Ext.ux.grid.LockingGridView({
                    getRowClass: function(record, index, rowParams, store){
                        var EstadoCita = record.data.EstadoCon;
                        switch(EstadoCita){
                            case "C":
                                return "Apto";
                                break;
                            case "A":
                                return "Triage3";
                                break;
                            default:
                                return "NoActivo";
                                break;
                        }
                    }
                }),
                columnLines: true,
                tbar:
                {
                    xtype: 'toolbar',
                    anchor:'100%',
                    items:[
                        {
                            xtype: 'button',
                            text: 'Listar',
                            iconCls: 'btnAsignarCita',
                            id: 'btnCitasxConfirmar'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Confirmar Cita',
                            iconCls: 'btnAsignarCita',
                            id: 'btnAbrirConfirmarCita'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Cita Rechazada',
                            iconCls: 'btnAsignarCita',
                            id: 'btnCitaRechazada'
                        },
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'button',
                            iconCls: 'btnCitasAsignadas',
                            text: 'Ver Historial Citas',
                            tooltip: 'Ver Historial de Citas Asignadas por Paciente',
                            id: 'btnVerHistorialCitas_citas'
                        }
                    ]
                }
            }
        ];
        this.bbar = {
            xtype: 'toolbar',
            id: 'bbar',
            items: [
                {
                    xtype: 'button',
                    text: 'Actualizar',
                    iconCls: 'btnActualizarGrid',
                    tooltip: 'Actualizar Agenda',
                    id: 'btnActualizar'
                },
                {
                    xtype: 'tbfill'
                },
                {
                    xtype: 'button',
                    text: 'Salir',
                    iconCls: 'btnSalir',
                    ref: '../btnSalir',
                    id: 'btnSalir'
                }
            ]
        };
        winFrmConfirmacionCitaEspUi.superclass.initComponent.call(this);
    }
});
