/*
* @category    Formulario Grid Historial de Citas Radicadas
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winFrmHistorialCitaRadicadasUi = Ext.extend(Ext.Window, {
    title: 'OfiClinic© Web..! .:: Historial de Citas Radicadas::.',
    id: 'winFrmHistorialCitaRadicadas',
    closable: true,
    width: 980,
    height: 480,
    plain: true,
    resizable: false,
    modal: true,
    y:120,
    layout: 'fit',
    initComponent: function() {
        var stGrid = new StoreGridHistorialCitasRadicadas();
        el = Ext.get('idempresa');
        var ID_EMPRESA = el.getValue();
        
        function VerInfoCliente(value, metaData, record, rowIndex, colIndex, store){  
            metaData.attr = 'style="white-space:normal"';  
            return record.get('NomCliente') + '</br>' + record.get('NomPlan') + '</br>' + record.get('NomSubPlan');  
        }
        
        this.items = [
            {
                xtype: 'grid',
                id: 'gridHistorialCitasRadicada',
                store: stGrid,
                anchor: "100%",
                border: false,
                frame: true,
                stripeRows: true,
                columns:[
                    {
                        xtype: 'gridcolumn',
                        header: 'Id',
                        sortable: false,
                        width: 1,
                        hidden: true,
                        hideable: false,
                        dataIndex: 'IdRadicaAgendaEspecialista',
                        id: 'IdRadicaAgendaEspecialista'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Fecha Radicado',
                        sortable: true,
                        width: 90,
                        dataIndex: 'FechaRadicado',
                        id: 'FechaRadicado'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Fecha Atencion',
                        sortable: true,
                        width: 90,
                        dataIndex: 'FechaAtendieron',
                        id: 'FechaAtendieron'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Especialidad',
                        sortable: false,
                        width: 200,
                        dataIndex: 'Especialidad',
                        id: 'Especialidad'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Tipo',
                        sortable: false,
                        width: 100,
                        dataIndex: 'TipoAtencion',
                        id: 'TipoAtencion'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Cliente',
                        sortable: false,
                        width: 150,
                        renderer: VerInfoCliente,
                        dataIndex: 'NomCliente',
                        id: 'NomCliente'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'CAS',
                        sortable: true,
                        width: 100,
                        dataIndex: 'CAS',
                        id: 'CAS'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Estado',
                        sortable: false,
                        width: 20,
                        dataIndex: 'EstadoReg',
                        id: 'EstadoReg'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Usuario Quien Radico',
                        sortable: false,
                        width: 150,
                        dataIndex: 'UsuarioRadico',
                        id: 'UsuarioRadico'
                    }
                ],   
                columnLines: true
            }
        ];
        winFrmHistorialCitaRadicadasUi.superclass.initComponent.call(this);
    }
});
