/*
* @category    Formulario Pacientes
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winPacientesUi = Ext.extend(Ext.Window, {
    title: 'OfiClinic .:: Pacientes - AIEPI ::.',
    width: 1014,
    height: 600,
    modal: true,
    closable: false,
    padding: 10,
    id: 'winPacientesUi',
    initComponent: function() {
        Ext.BLANK_IMAGE_URL = '../../../lib/extjs/resources/images/default/s.gif';
        
        wPaciente = 0;
        wCAS = 0;
        
        var picBox = {
            columnWidth: .5,
            bodyStyle: 'padding:0px 0px 0px 40px',
            items: [
                { 
                    xtype: 'box',
                    autoEl: { tag: 'div', style: 'padding-bottom:20px',
                        html: '<img id="pic" src="' + Ext.BLANK_IMAGE_URL + '"/>'
                    }
                }
            ]
        }

        var aPanelPublicidad = new Ext.Panel({
            autoLoad:{url:'../publicidad/frminferior/frmpublicidadinf.php',scripts:true,scope:this},
            id: 'Publicidad',
            title: '',
            border: false,
            autoScroll: false,
            closable: true,
            width: 915,
            height: 155
        });
        
        function DescripcionConducta(val, x, store){
            if(val != null && val != ""){
                var estructurahc = val.split("¬");
                var mostrarHC = "";
                var txtContenido = "";

                for (var i = 0; i < (estructurahc.length-1); i++){
                    var contenidohc = estructurahc[i].split("^~");
                    switch(contenidohc[1]){
                        case "TRUE":
                            txtContenido = "SI";
                            break;

                        case "FALSE":
                            txtContenido = "NO";
                            break;

                        default:
                            txtContenido = contenidohc[1];
                            break;
                    }
                    if(contenidohc[2].substr(0,8) == "CONDUCTA"){
                        mostrarHC = '<table><tr><td style="padding: 1px;">';
                        mostrarHC += txtContenido;
                        mostrarHC += '</td></tr></table>';
                    }
                }
                return mostrarHC;
            }else{
                return "";
            }
        }
        
        function DescripcionMotivoConsulta(val, x, store){
            if(val != null && val != ""){
                var estructurahc = val.split("¬");
                var mostrarHC = "";
                var txtContenido = "";

                for (var i = 0; i < (estructurahc.length-1); i++){
                    var contenidohc = estructurahc[i].split("^~");
                    switch(contenidohc[1]){
                        case "TRUE":
                            txtContenido = "SI";
                            break;

                        case "FALSE":
                            txtContenido = "NO";
                            break;

                        default:
                            txtContenido = contenidohc[1];
                            break;
                    }
                    if(contenidohc[2].substr(0,18) == "MOTIVO DE CONSULTA"){
                        mostrarHC = '<table><tr><td style="padding: 1px;">';
                        mostrarHC += txtContenido;
                        mostrarHC += '</td></tr></table>';
                    }else{
                        if(contenidohc[2].substr(0,7) == "CONTROL"){
                            mostrarHC = '<table><tr><td style="padding: 1px;">';
                            mostrarHC += txtContenido;
                            mostrarHC += '</td></tr></table>';
                        }
                    }
                }
                return mostrarHC;
            }else{
                return "";
            }
        }

        this.items = [
            {
                xtype: 'tabpanel',
                id: 'tbOpcionesPacientes',
                activeTab: 0,
                anchor: '100%',
                height: 570,
                //autoHeight: true,
                border: false,
                items: [
                    {
                        xtype: 'panel',
                        style: 'background:transparent;',
                        title: 'Datos del Paciente',
                        items:[
                            {
                                xtype: 'form',
                                frame: true,
                                height: 542,
                                //autoHeight: true,
                                anchor: '100%',
                                autoScroll: true,
                                id: 'frmPacientes',
                                fileUpload: true,
                                padding: 10,
                                items: [
                                    {
                                        xtype: 'panel',
                                        layout: 'form',
                                        border: false,
                                        labelWidth: 130,
                                        items: [
                                            {
                                                xtype: 'hidden',
                                                id: 'intIdPaciente',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                id: 'sysPacienteValido',
                                                value: 0
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'Datos del Paciente',
                                                layout: 'table',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                width: 915,
                                                //height: 380,
                                                autoHeight: true,
                                                id: 'fsPaciente',
                                                layoutConfig: {
                                                    columns: 4
                                                },
                                                items: [
                                                    {
                                                        xtype: 'panel',
                                                        title: '',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        padding: 5,
                                                        width: 221,
                                                        border: false,
                                                        id: 'pnTdoc',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Tipo Doc ID',
                                                                anchor: '100%',
                                                                name: 'cbTdoc',
                                                                allowBlank: false,
                                                                //store: 'StoreTdocPac',
                                                                store: 'StoreTdocPac',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                valueField: 'Codigo',
                                                                displayField: 'Descripcion',
                                                                emptyText: 'Seleccione Tipo Documento....',
                                                                mode: 'local',
                                                                triggerAction: 'all',
                                                                forceSelection: true,
                                                                id: 'strTdoc'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: '',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        padding: 5,
                                                        width: 269,
                                                        border: false,
                                                        id: 'pnDocID',
                                                        items: [
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Documento ID',
                                                                        name: 'txtDocID',
                                                                        allowBlank: false,
                                                                        width: 200,
                                                                        id: 'strDocID'
                                                                    },
                                                                    {
                                                                        xtype: 'button',
                                                                        iconCls: 'btnBuscar',
                                                                        tooltip: 'Buscar Paciente',
                                                                        id: 'btnBuscarPacienteFrm'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: '',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        padding: 5,
                                                        width: 172,
                                                        border: false,
                                                        colspan: 2,
                                                        id: 'pnGenero',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Genero',
                                                                anchor: '100%',
                                                                name: 'cbGenero',
                                                                allowBlank: false,
                                                                store: 'StoreGenero',
                                                                valueField: 'Codigo',
                                                                displayField: 'Descripcion',
                                                                triggerAction: 'all',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                mode: 'local',
                                                                emptyText: 'Seleccione Genero....',
                                                                forceSelection: true,
                                                                id: 'strGenero'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: '',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        padding: 5,
                                                        width: 271,
                                                        border: false,
                                                        id: 'pnApe1',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                fieldLabel: '1er Apellido',
                                                                anchor: '100%',
                                                                name: 'txtApe1',
                                                                style: 'text-transform:uppercase;',
                                                                allowBlank: false,
                                                                id: 'strApe1'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: '',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        padding: 5,
                                                        width: 271,
                                                        border: false,
                                                        id: 'pnApe2',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                fieldLabel: '2do Apellido',
                                                                anchor: '100%',
                                                                name: 'txtApe2',
                                                                style: 'text-transform:uppercase;',
                                                                id: 'strApe2'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: '',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        padding: 5,
                                                        width: 215,
                                                        border: false,
                                                        id: 'pnNom1',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                fieldLabel: '1er Nombre',
                                                                anchor: '96%',
                                                                name: 'txtNom1',
                                                                allowBlank: false,
                                                                style: 'text-transform:uppercase;',
                                                                id: 'strNom1'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: '',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        padding: 5,
                                                        border: false,
                                                        width: 145,
                                                        id: 'pnNom2',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                fieldLabel: '2do Nombre',
                                                                anchor: '78%',
                                                                name: 'txtNom2',
                                                                style: 'text-transform:uppercase;',
                                                                id: 'strNom2'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: '',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        padding: 5,
                                                        width: 146,
                                                        border: false,
                                                        id: 'pnFecNac',
                                                        items: [
                                                            {
                                                                xtype: 'datefield',
                                                                fieldLabel: 'Fecha Nacimiento',
                                                                anchor: '100%',
                                                                name: 'txtFecNac',
                                                                allowBlank: false,
                                                                disabledDates: '',
                                                                emptyText: '(dia/mes/año) ',
                                                                style: 'text-align:center;',
                                                                id: 'fecFecNac'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: '',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        padding: 5,
                                                        width: 271,
                                                        border: false,
                                                        id: 'pnEdad',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                fieldLabel: 'Edad Actual',
                                                                anchor: '100%',
                                                                name: 'txtEdad',
                                                                readOnly: true,
                                                                allowBlank: false,
                                                                style: 'color: blue;text-align:center',
                                                                id: 'strEdad'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: '',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        padding: 5,
                                                        width: 366,
                                                        border: false,
                                                        colspan: 2,
                                                        id: 'pnDeptoMuni',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Municipio - Departamento',
                                                                anchor: '93%',
                                                                name: 'cbDeptoMuni',
                                                                allowBlank: false,
                                                                store: 'StoreDeptoMuni',
                                                                valueField: 'IdDeptoMunicipio',
                                                                displayField: 'Descripcion',
                                                                emptyText: 'Seleccione Municipio - Departamento....',
                                                                mode: 'local',
                                                                listWidth: 450,
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                id: 'strDeptoMuni'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: '',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        padding: 5,
                                                        width: 928,
                                                        border: false,
                                                        colspan: 4,
                                                        height: 54,
                                                        id: 'pnDatDirTel',
                                                        items: [
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                //fieldLabel: 'Dirección - Teléfono - Teléfono (Otro - Cel.) - Zona - Email',
                                                                fieldLabel: 'Dirección - Teléfono - Teléfono (Otro - Cel.) - Zona',
                                                                anchor: '100%',
                                                                id: 'composDatDirTel',
                                                                items: [
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'txtDireccion',
                                                                        allowBlank: false,
                                                                        emptyText: 'Dirección....',
                                                                        style: 'text-transform:uppercase;',
                                                                        width: 280,
                                                                        id: 'strDireccion'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'txtTel1',
                                                                        allowBlank: false,
                                                                        emptyText: 'Teléfono',
                                                                        width: 160,
                                                                        id: 'strTel1'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'txtTel2',
                                                                        emptyText: 'Teléfono (Otro - Cel.)',
                                                                        width: 160,
                                                                        id: 'strTel2'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        flex: 1,
                                                                        fieldLabel: 'Zona',
                                                                        store: 'StoreZonaResidencia',
                                                                        valueField: 'Codigo',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        name: 'cbZona',
                                                                        emptyText: 'Zona....',
                                                                        allowBlank: false,
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        width: 80,
                                                                        value: 'Urbana',
                                                                        triggerAction: 'all',
                                                                        id: 'strZona'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'txtEmail',
                                                                        vtype: 'email',
                                                                        emptyText: 'Email....',
                                                                        width: 180,
                                                                        id: 'strEmail'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: '',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        padding: 5,
                                                        width: 928,
                                                        border: false,
                                                        colspan: 4,
                                                        autoHeight: true,
                                                        id: 'pnPacEmpresa',
                                                        items: [
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                fieldLabel: 'Empresa Donde Trabaja',
                                                                anchor: '100%',
                                                                id: 'composDatEmpresa',
                                                                items: [
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'txtEmpresaTrabaja',
                                                                        width: 880,
                                                                        id: 'strEmpresaTrabaja'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: '',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        padding: 5,
                                                        width: 928,
                                                        border: false,
                                                        colspan: 4,
                                                        height: 54,
                                                        id: 'pnPacOtro',
                                                        items: [
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                fieldLabel: 'Estado Civil - Escolaridad - Profesión',
                                                                anchor: '100%',
                                                                id: 'composDatOtro',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        flex: 1,
                                                                        store: 'StoreEstadoCivil',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        emptyText: 'Estado Civil',
                                                                        allowBlank: true,
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        width: 120,
                                                                        triggerAction: 'all',
                                                                        id: 'strEstadoCivilPac'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        flex: 1,
                                                                        store: 'StoreEscolaridad',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        emptyText: 'Escolaridad',
                                                                        allowBlank: true,
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        width: 180,
                                                                        triggerAction: 'all',
                                                                        id: 'strEscolaridadPac'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        flex: 1,
                                                                        store: 'StoreProfesion',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        emptyText: 'Profesión',
                                                                        allowBlank: true,
                                                                        forceSelection: false,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        width: 570,
                                                                        triggerAction: 'all',
                                                                        id: 'strProfesionPac'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'Firma del Paciente',
                                                layout: 'table',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                width: 915,
                                                autoHeight: true,
                                                id: 'fsFirmaPaciente',
                                                layoutConfig: {
                                                    columns: 2
                                                },
                                                items: [
                                                    {
                                                        xtype: 'button',
                                                        iconCls: 'btnCargarFile',
                                                        tooltip: 'Adjuntar Firma',
                                                        id: 'btnAdjuntarFirmaPacienteFrm',
                                                        listeners:{
                                                            click : function(){
                                                                if (Ext.getCmp('intIdPaciente').getValue() != 0 && Ext.getCmp('sysPacienteValido').getValue() != 0){
                                                                    var fileAdjuntarFirma = new CargarFirmaPacienteUi();
                                                                    Ext.getCmp('sysPacienteFirma').setValue(Ext.getCmp('intIdPaciente').getValue());
                                                                    fileAdjuntarFirma.show();
                                                                }else{
                                                                    Ext.MessageBox.show({
                                                                        title: 'Error',
                                                                        msg: 'El Paciente no es valido o no ha sido creado',
                                                                        buttons: Ext.MessageBox.OK,
                                                                        icon: Ext.MessageBox.ERROR
                                                                    });
                                                                }
                                                            }
                                                        }
                                                    },
                                                    picBox
                                                ]
                                            }
                                            //aPanelPublicidad
                                        ]
                                    }
                                ],
                                tbar:{
                                    items: [
                                        {
                                            xtype: 'button',
                                            text: 'Nuevo',
                                            iconCls: 'btnNuevo',
                                            id: 'btnNuevoFrm'
                                        },
                                        '-',
                                        {
                                            xtype: 'button',
                                            text: 'Imagenes Asociadas',
                                            iconCls: 'btnCargarFoto',
                                            id: 'btnImgxPacFrm1'
                                        },
                                        '-',
                                        {
                                            xtype: 'button',
                                            text: 'Documentos Asociados',
                                            iconCls: 'btnCargarFile',
                                            id: 'btnDocxPacFrm1'
                                        },
                                        {
                                            xtype: 'tbfill'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Guardar',
                                            iconCls: 'btnGuardar',
                                            id: 'btn_AdicionarItemFrm'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Modificar',
                                            iconCls: 'btnGuardar',
                                            id: 'btn_ModificarItemFrm'
                                        }
                                    ]
                                }
                            }
                        ]
                    },
                    {
                        xtype: 'panel',
                        style: 'background:transparent;',
                        title: 'Evoluciones',
                        id: 'pntabEvolucion',
                        items:[
                            {
                                xtype: 'hidden',
                                id: 'sysCASRefHC'
                            },
                            {
                                xtype: 'hidden',
                                id: 'sysPacienteRefHC'
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: false,
                                style: 'background:transparent; color: darkblue; font-size:14px; text-align: center; text-transform:uppercase;',
                                width: 972,
                                height: 30,
                                border: false,
                                id: 'sysInfoPaciente'
                            },
                            {
                                xtype: 'grid',
                                id: 'gridFormulario',
                                store: 'StoreGridEvolucionesxPacienteOfimedical',
                                title: '',
                                anchor: "100%",
                                border: false,
                                frame: true,
                                height: 470,
                                columns: [
                                    {
                                        xtype: 'gridcolumn',
                                        header: 'IdCliente',
                                        sortable: false,
                                        width: 1,
                                        hidden: true,
                                        hideable: false,
                                        dataIndex: 'IdCliente'
                                    },
                                    {
                                        xtype: 'gridcolumn',
                                        header: 'CAS',
                                        sortable: false,
                                        width: 80,
                                        hidden: false,
                                        hideable: false,
                                        dataIndex: 'CAS',
                                        listeners:{
                                            dblclick : function(){
                                                //************
                                                //Extraer los formatos de la hc para modificarla
                                                if(Ext.getCmp('gridFormulario').selModel.getCount() == 1){
                                                    var selections = Ext.getCmp('gridFormulario').selModel.getSelections();
                                                    if(selections[0].json.idPlantillaHC != null || selections[0].json.idPlantillaHC != 0){
                                                        Ext.Ajax.request({
                                                            url: '../../controlador/asistencial/controlador_plantillashc.php',
                                                            params:{
                                                                task: 'BUSCAR',
                                                                pPlantilla: selections[0].json.idPlantillaHC
                                                            },
                                                            success: function(response,options)
                                                            {
                                                                var el = Ext.get('response'); // get the LOG
                                                                var Respuesta = response.responseText;
                                                                var Contenido = Respuesta.split('^');
                                                                if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                    // No Hace Nada
                                                                } else {
                                                                    stCIE10 = new StoreCIE10();
                                                                    objMX = "NA";
                                                                    objMXADD = "NA";
                                                                    objEXA = "NA";
                                                                    objEXAADD = "NA";
                                                                    objREM = "NA";
                                                                    objREMADD = "NA";
                                                                    Ext.getCmp('sysPacienteRefHC').setValue(selections[0].json.Paciente);
                                                                    Ext.getCmp('sysCASRefHC').setValue(selections[0].json.CAS);

                                                                    if(Contenido[5] != null && Contenido[5] != ""){
                                                                        ScriptMgr.loadJs({
                                                                            scripts : Contenido[5],
                                                                            callback : function(){
                                                                                objMX = Contenido[6];
                                                                                ScriptMgr.loadJs({
                                                                                    scripts : Contenido[7],
                                                                                    callback : function(){
                                                                                        objMXADD = Contenido[8];
                                                                                    }
                                                                                });
                                                                            }
                                                                        });
                                                                    }
                                                                    if(Contenido[9] != null && Contenido[9] != ""){
                                                                        ScriptMgr.loadJs({
                                                                            scripts : Contenido[9],
                                                                            callback : function(){
                                                                                objEXA = Contenido[10];
                                                                                ScriptMgr.loadJs({
                                                                                    scripts : Contenido[11],
                                                                                    callback : function(){
                                                                                        objEXAADD = Contenido[12];
                                                                                    }
                                                                                });
                                                                            }
                                                                        });
                                                                    }
                                                                    if(Contenido[13] != null && Contenido[13] != ""){
                                                                        ScriptMgr.loadJs({
                                                                            scripts : Contenido[13],
                                                                            callback : function(){
                                                                                objREM = Contenido[14];
                                                                                ScriptMgr.loadJs({
                                                                                    scripts : Contenido[15],
                                                                                    callback : function(){
                                                                                        objREMADD = Contenido[16];
                                                                                    }
                                                                                });
                                                                            }
                                                                        });
                                                                    }
                                                                    if(Contenido[17] != null && Contenido[17] != "" && Contenido[17] == "1"){
                                                                        ScriptMgr.loadJs({
                                                                            scripts : '../../../app/frm_js/asistencial/ofimedical/wintestbarthel.ui.js'
                                                                        });
                                                                    }
                                                                    if(Contenido[18] != null && Contenido[19] != "" && Contenido[18] == "1"){
                                                                        ScriptMgr.loadJs({
                                                                            scripts : '../../../app/frm_js/asistencial/ofimedical/wintestfolstein.ui.js'
                                                                        });
                                                                    }
                                                                    if(Contenido[19] != null && Contenido[19] != "" && Contenido[19] == "1"){
                                                                        ScriptMgr.loadJs({
                                                                            scripts : '../../../app/frm_js/asistencial/ofimedical/wintesthachinski.ui.js'
                                                                        });
                                                                    }
                                                                    if(Contenido[20] != null && Contenido[20] != "" && Contenido[20] == "1"){
                                                                        ScriptMgr.loadJs({
                                                                            scripts : '../../../app/frm_js/asistencial/ofimedical/wintestlawton.ui.js'
                                                                        });
                                                                    }
                                                                    if(Contenido[21] != null && Contenido[21] != "" && Contenido[21] == "1"){
                                                                        ScriptMgr.loadJs({
                                                                            scripts : '../../../app/frm_js/asistencial/ofimedical/wintestyesavage.ui.js'
                                                                        });
                                                                    }
                                                                    
                                                                    ScriptMgr.loadJs({
                                                                        scripts : Contenido[3],
                                                                        waitMsg: 'Por favor Espere...',
                                                                        callback : function(){
                                                                            
                                                                            wPaciente = selections[0].json.Paciente;
                                                                            wCAS = selections[0].json.CAS;
                                                                            
                                                                            var winHC = eval(Contenido[4]);//new winHCUi();
                                                                            Ext.getCmp('sysPlantillaHC').setValue(Contenido[2]);
                                                                            Ext.getCmp('sysActividadHC').setValue(PonerAcentosMayusculas(selections[0].json.Actividad));
                                                                            Ext.getCmp('sysEmpresaHC').setValue(ID_EMPRESA);
                                                                            Ext.getCmp('sysIPSHC').setValue(ID_IPS);
                                                                            Ext.getCmp('sysUsuarioHC').setValue(ID_USUARIO);
                                                                            Ext.getCmp('sysProfesionalHC').setValue(selections[0].json.idProfesional); 
                                                                            Ext.getCmp('sysIdPacienteHC').setValue(selections[0].json.Paciente);
                                                                            Ext.getCmp('sysClienteHC').setValue(selections[0].json.Cliente);
                                                                            Ext.getCmp('sysCASHC').setValue(selections[0].json.CAS);
                                                                            Ext.getCmp('sysProfesionalAgendaHC').setValue(selections[0].json.NomProfesional);
                                                                            Ext.getCmp('sysFechaHC').setValue(selections[0].json.FechaAtencion);
                                                                            Ext.getCmp('sysHoraHC').setValue(selections[0].json.HoraApertura);
                                                                            Ext.getCmp('sysLegalizaHC').setValue(selections[0].json.HoraApertura);
                                                                            Ext.getCmp('sysPacienteHC').setValue(Ext.getCmp('sysInfoPaciente').getValue());
                                                                            Ext.getCmp('sysAperturaHC').setValue(selections[0].json.HoraApertura);
                                                                            Ext.getCmp('sysConsecutivoDetalleHC').setValue(selections[0].json.ConsecutivoDetalle);
                                                                            Ext.getCmp('sysIdClienteHC').setValue(selections[0].json.IdCliente);
                                                                            Ext.getCmp('sysIdContratoHC').setValue(1);
                                                                            Ext.getCmp('sysIdCodPlantillaHC').setValue(Contenido[0]);
                                                                            Ext.getCmp('sysYaGuardoHC').setValue(1);
                                                                            CargarDataHC(selections[0].json.Evolucion);
                                                                            CargarDataHC(selections[0].json.Barthel);
                                                                            CargarDataHC(selections[0].json.Hachinski);
                                                                            CargarDataHC(selections[0].json.Lawton);
                                                                            CargarDataHC(selections[0].json.Folstein);
                                                                            CargarDataHC(selections[0].json.Yesavage);
                                                                            CargarDataHC(selections[0].json.MNA);
                                                                            try {
                                                                                var campo = Ext.getCmp('sysNroAutorizacionHC');
                                                                                if ( campo != null ) {
                                                                                    Ext.getCmp('sysNroAutorizacionHC').setValue(selections[0].json.NroAutorizacion);
                                                                                }
                                                                                var campo1 = Ext.getCmp('strEmpresaSaludOcupacional');
                                                                                if ( campo1 != null ) {
                                                                                    Ext.getCmp('strEmpresaSaludOcupacional').setValue(Ext.getCmp('strEmpresaTrabaja').getValue());
                                                                                }
                                                                                if(Ext.getCmp('strGenero').getValue() == "F"){
                                                                                    var campoAP_Ginecologicos = Ext.getCmp('memAP_Ginecologicos');
                                                                                    if ( campoAP_Ginecologicos != null ) {
                                                                                        Ext.getCmp('memAP_Ginecologicos').setVisible(true);
                                                                                    }
                                                                                }
                                                                                var campoDiagppal = Ext.getCmp('sysDiagPpalHC');
                                                                                if ( campoDiagppal != null ) {
                                                                                    Ext.getCmp('sysDiagPpalHC').setValue(selections[0].json.Diagppal);
                                                                                    Ext.Ajax.request({
                                                                                        url: '../../controlador/cie10/controlador_cie10.php',
                                                                                        params:{
                                                                                            task: 'BUSCAR',
                                                                                            pCodigo: selections[0].json.Diagppal.toUpperCase()
                                                                                        },
                                                                                        success: function(response,options)
                                                                                        {
                                                                                            var el = Ext.get('response'); // get the LOG
                                                                                            var Respuesta = response.responseText;
                                                                                            var Contenido = Respuesta.split('^');
                                                                                            if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                                // Nada
                                                                                            } else {
                                                                                                Ext.getCmp('sysDiagPpalHCNom').setValue(Contenido[1]);
                                                                                            }
                                                                                        },
                                                                                        failure: function(response,options){
                                                                                            //nada
                                                                                        },
                                                                                        scope:this //bind the callbacks
                                                                                    });
                                                                                }
                                                                                var campoDiagrel1 = Ext.getCmp('sysDiagRel1HC');
                                                                                if ( campoDiagrel1 != null ) {
                                                                                    Ext.getCmp('sysDiagRel1HC').setValue(selections[0].json.Diagrel1);
                                                                                    Ext.Ajax.request({
                                                                                        url: '../../controlador/cie10/controlador_cie10.php',
                                                                                        params:{
                                                                                            task: 'BUSCAR',
                                                                                            pCodigo: selections[0].json.Diagrel1.toUpperCase()
                                                                                        },
                                                                                        success: function(response,options)
                                                                                        {
                                                                                            var el = Ext.get('response'); // get the LOG
                                                                                            var Respuesta = response.responseText;
                                                                                            var Contenido = Respuesta.split('^');
                                                                                            if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                                // Nada
                                                                                            } else {
                                                                                                Ext.getCmp('sysDiagRel1HCNom').setValue(Contenido[1]);
                                                                                            }
                                                                                        },
                                                                                        failure: function(response,options){
                                                                                            //nada
                                                                                        },
                                                                                        scope:this //bind the callbacks
                                                                                    });
                                                                                }
                                                                                var campoDiagrel2 = Ext.getCmp('sysDiagRel2HC');
                                                                                if ( campoDiagrel2 != null ) {
                                                                                    Ext.getCmp('sysDiagRel2HC').setValue(selections[0].json.DiagRel2);
                                                                                    Ext.Ajax.request({
                                                                                        url: '../../controlador/cie10/controlador_cie10.php',
                                                                                        params:{
                                                                                            task: 'BUSCAR',
                                                                                            pCodigo: selections[0].json.DiagRel2.toUpperCase()
                                                                                        },
                                                                                        success: function(response,options)
                                                                                        {
                                                                                            var el = Ext.get('response'); // get the LOG
                                                                                            var Respuesta = response.responseText;
                                                                                            var Contenido = Respuesta.split('^');
                                                                                            if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                                // Nada
                                                                                            } else {
                                                                                                Ext.getCmp('sysDiagRel2HCNom').setValue(Contenido[1]);
                                                                                            }
                                                                                        },
                                                                                        failure: function(response,options){
                                                                                            //nada
                                                                                        },
                                                                                        scope:this //bind the callbacks
                                                                                    });
                                                                                }
                                                                                var campoDiagrel3 = Ext.getCmp('sysDiagRel3HC');
                                                                                if ( campoDiagrel3 != null ) {
                                                                                    Ext.getCmp('sysDiagRel3HC').setValue(selections[0].json.DiagRel3);
                                                                                    Ext.Ajax.request({
                                                                                        url: '../../controlador/cie10/controlador_cie10.php',
                                                                                        params:{
                                                                                            task: 'BUSCAR',
                                                                                            pCodigo: selections[0].json.DiagRel3.toUpperCase()
                                                                                        },
                                                                                        success: function(response,options)
                                                                                        {
                                                                                            var el = Ext.get('response'); // get the LOG
                                                                                            var Respuesta = response.responseText;
                                                                                            var Contenido = Respuesta.split('^');
                                                                                            if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                                // Nada
                                                                                            } else {
                                                                                                Ext.getCmp('sysDiagRel3HCNom').setValue(Contenido[1]);
                                                                                            }
                                                                                        },
                                                                                        failure: function(response,options){
                                                                                            //nada
                                                                                        },
                                                                                        scope:this //bind the callbacks
                                                                                    });
                                                                                }
                                                                                var campoTipodiag = Ext.getCmp('sysTipoDiagosticoHC');
                                                                                if ( campoTipodiag != null ) {
                                                                                    Ext.getCmp('sysTipoDiagosticoHC').setValue(selections[0].json.Tipodiag);
                                                                                }
                                                                                var campoFinalidad = Ext.getCmp('sysFinalidadConsultaHC');
                                                                                if ( campoFinalidad != null ) {
                                                                                    Ext.getCmp('sysFinalidadConsultaHC').setValue(selections[0].json.Finalidad);
                                                                                }
                                                                                var campoCausaExterna = Ext.getCmp('sysCausaExternaHC');
                                                                                if ( campoCausaExterna != null ) {
                                                                                    Ext.getCmp('sysCausaExternaHC').setValue(selections[0].json.CausaExterna);
                                                                                }
                                                                                var campo6 = Ext.getCmp('sysInfoPacHCEdad');
                                                                                if ( campo6 != null ) {
                                                                                    Ext.getCmp('sysInfoPacHCEdad').setValue(Ext.getCmp('strEdad').getValue());
                                                                                }
                                                                                var campo7 = Ext.getCmp('sysInfoPacHCGenero');
                                                                                if ( campo7 != null ) {
                                                                                    Ext.getCmp('sysInfoPacHCGenero').setValue(Ext.getCmp('strGenero').getRawValue());
                                                                                }
                                                                                var campo8 = Ext.getCmp('sysInfoPacHCOcupacion');
                                                                                if ( campo8 != null ) {
                                                                                    Ext.getCmp('sysInfoPacHCOcupacion').setValue(Ext.getCmp('strProfesionPac').getRawValue());
                                                                                }
                                                                                var campo9 = Ext.getCmp('sysInfoPacHCDireccion');
                                                                                if ( campo9 != null ) {
                                                                                    Ext.getCmp('sysInfoPacHCDireccion').setValue(Ext.getCmp('strDireccion').getValue());
                                                                                }
                                                                                var campo10 = Ext.getCmp('sysInfoPacHCTelefonos');
                                                                                if ( campo10 != null ) {
                                                                                    Ext.getCmp('sysInfoPacHCTelefonos').setValue(Ext.getCmp('strTel1').getValue() + " - " + Ext.getCmp('strTel2').getValue());
                                                                                }
                                                                            }catch(ex) {
                                                                                // aqui se atrapo el error y se le puede mandar un mensaje al usuario o hacer alguna acción que controle el error.
                                                                                //Ext.Msg('El campo no se encontro,' + ex.Message);
                                                                            }
                                                                            //Ext.getCmp('fecDesdeIncapacidad').setMinValue(new Date().format("d/m/Y"));
                                                                            winHC.show();
                                                                        }
                                                                    });
                                                                }
                                                            },
                                                            failure: function(response,options){
                                                                var el = Ext.get('response');
                                                                // No hace nada
                                                            },
                                                            scope:this //bind the callbacks
                                                        });
                                                    }
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'gridcolumn',
                                        header: 'Fecha',
                                        sortable: false,
                                        width: 80,
                                        hidden: false,
                                        hideable: false,
                                        dataIndex: 'FechaAtencion'
                                    },
                                    {
                                        xtype: 'gridcolumn',
                                        header: 'Cliente',
                                        sortable: false,
                                        width: 200,
                                        hidden: false,
                                        hideable: false,
                                        dataIndex: 'Cliente'
                                    },
                                    {
                                        header: 'Motivo de Consulta / Evolución',
                                        dataIndex: 'Evolucion',
                                        renderer: DescripcionMotivoConsulta,
                                        sortable: true,
                                        width: 300,
                                        height: 150
                                    },
                                    {
                                        header: 'Conducta',
                                        dataIndex: 'Evolucion',
                                        renderer: DescripcionConducta,
                                        sortable: true,
                                        width: 290,
                                        height: 150
                                    },
                                    {
                                        xtype: 'gridcolumn',
                                        header: 'DiagPpal',
                                        sortable: false,
                                        hidden: false,
                                        hideable: false,
                                        dataIndex: 'Diagppal'
                                    },
                                    {
                                        xtype: 'gridcolumn',
                                        header: 'DiagRel1',
                                        sortable: false,
                                        hidden: false,
                                        hideable: false,
                                        dataIndex: 'Diagprel1'
                                    },
                                    {
                                        xtype: 'gridcolumn',
                                        header: 'DiagRel2',
                                        sortable: false,
                                        hidden: false,
                                        hideable: false,
                                        dataIndex: 'Diagprel2'
                                    },
                                    {
                                        xtype: 'gridcolumn',
                                        header: 'DiagRel3',
                                        sortable: false,
                                        hidden: false,
                                        hideable: false,
                                        dataIndex: 'Diagprel3'
                                    }
                                ],
                                selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                                tbar:
                                    {
                                        xtype: 'toolbar',
                                        items: [
                                            {
                                                xtype: 'tbseparator'
                                            },
                                            {
                                                xtype: 'button',
                                                text: 'Adicionar Evolución',
                                                iconCls: 'btnAddRow',
                                                id: 'btnAddEvolucionHC'
                                            },
                                            {
                                                xtype: 'tbseparator'
                                            },
                                            {
                                                xtype: 'button',
                                                text: 'Toda la Historia',
                                                iconCls: 'btnImprimir',
                                                id: 'btnPrintAllHC'
                                            },
                                            {
                                                xtype: 'tbseparator'
                                            },
                                            {
                                                xtype: 'button',
                                                text: 'Evolución',
                                                iconCls: 'btnImprimir',
                                                id: 'btnPrintEvolucionHC'
                                            },
                                            {
                                                xtype: 'tbseparator'
                                            },
                                            '->',
                                            {
                                                xtype: 'tbseparator'
                                            },
                                            {
                                                xtype: 'button',
                                                text: 'Incapacidad',
                                                iconCls: 'btnImprimir',
                                                id: 'btnPrintIncapacidadHC'
                                            },
                                            {
                                                xtype: 'tbseparator'
                                            },
                                            {
                                                xtype: 'button',
                                                text: 'Medicamentos',
                                                iconCls: 'btnImprimir',
                                                id: 'btnPrintMxHC'
                                            },
                                            {
                                                xtype: 'tbseparator'
                                            },
                                            {
                                                xtype: 'button',
                                                text: 'Orden Examenes',
                                                iconCls: 'btnImprimir',
                                                id: 'btnPrintExamenesHC'
                                            },
                                            {
                                                xtype: 'tbseparator'
                                            },
                                            {
                                                xtype: 'button',
                                                text: 'Remisiones',
                                                iconCls: 'btnImprimir',
                                                id: 'btnPrintRemiHC'
                                            },
                                            {
                                                xtype: 'tbseparator'
                                            }
                                        ]
                                    }
                            },
                        ]
                    }
                ]
            }
        ];
        this.bbar = {
            xtype: 'toolbar',
            id: 'bbar',
            items: [
                {
                    xtype: 'button',
                    text: '',
                    iconCls: 'btnAyuda',
                    tooltip: 'Ver Ayuda en Linea',
                    ref: '../btnAyuda',
                    id: 'btnAyuda'
                },
                {
                    xtype: 'tbfill'
                },
                {
                    xtype: 'displayfield',
                    value: 'Empresa: PASBISALUD IPS',
                    name: 'txtNomEmpresa',
                    ref: '../fNomEmpresa',
                    id: 'fNomEmpresa'
                },
                {
                    xtype: 'tbseparator'
                },
                {
                    xtype: 'displayfield',
                    value: 'Sede: MANIZALES',
                    name: 'txtNomSede',
                    ref: '../fNomSede',
                    id: 'fNomSede'
                },
                {
                    xtype: 'tbseparator'
                },
                {
                    xtype: 'displayfield',
                    value: 'IPS: BELEN',
                    name: 'txtNomSede',
                    ref: '../fNomIPS',
                    id: 'fNomIPS'
                },
                {
                    xtype: 'tbseparator'
                },
                {
                    xtype: 'button',
                    text: '',
                    iconCls: 'btnUsr',
                    ref: '../btnUsr',
                    id: 'btnUsr'
                },
                {
                    xtype: 'displayfield',
                    value: 'Usuario: GJUAN ',
                    name: 'txtNomUSR',
                    style: 'color:royalblue',
                    ref: '../fNomUSR',
                    id: 'fNomUSR'
                },
                {
                    xtype: 'tbseparator'
                },
                {
                    xtype: 'button',
                    text: 'Salir',
                    iconCls: 'btnSalir',
                    id: 'btnSalir'
                }
            ]
        };
        winPacientesUi.superclass.initComponent.call(this);
    }
});
