/*
* @category    Formulario Modelo Evolucion Historia Clinica AIEPI Niño(a)s 0 a 2 Meses
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/
HTML_SIGNO_PELIGRO1 = '<div style="background-color:#FFC6C6; padding:5px"><table border="1" width="400" style="font-family:Arial, Helvetica, sans-serif; font-size:9px"><tr><td colspan="2" style="text-align:center; font-size:12px"><b>ENFERMEDAD MUY GRAVE</b></td></tr><tr><td width="190" style="text-align:center">SIGNOS</td><td width="190" style="text-align:center">TRATAMIENTO</td></tr><tr><td style="padding:5px">Uno de los siguientes signos:<ul><li>Se mueve solo al estímulo, letárgico "Se ve mal o luce mal" o irritable</li><li>No puede tomar el pecho</li><li>Vomita todo lo que ingiere</li><li>Convulsiones</li><li>Palidez, cianosis central, ictericia precoz o importante por clínica o bilirrubinas</li><li>FR ≥ 60 o < 30 por min.</li><li>FC >180 o < 100 por minuto</li><li>Llenado capilar mayor de 2 segundos</li><li>Temperatura axilar < 35,5 o > 38 °C</li><li>Fontanela abombada</li><li>Apneas</li><li>Aleteo nasal</li><li>Quejido, estridor o sibilancia</li><li>Tiraje subcostal grave</li><li>Secreción purulenta conjuntival más edema palpebral</li><li>Supuración de oído</li><li>Pústulas o vesículas en la piel (muchas o extensas)</li><li>Eritema periumbilical</li><li>Equimosis, petequias o hemorragias</li><li>Distensión abdominal</li><li>VIH positivo(materna o neonatal)</li><li>Menos de 4 diuresis en 24 horas</ul></td><td style="padding:5px"><ul><li><b>Referir URGENTEMENTE al hospital, según las normas de estabilización y transporte “REFIERA”</b></li><li>Administrar la primera dosis de los antibióticos recomendados </li><li>Administrar oxigeno si hay cianosis, tiraje, quejido o apnea</li><li>Prevenir la hipoglicemia</li><li>Administrar Acetaminofén para la fiebre</li><li>Administrar vitamina K si hay evidencia de sangrado.</li><li>Evitar la hipotermia, mantener abrigado</li><li>Recomendar a la madre que siga dándole lactancia si es posible durante el traslado </li><li>Revise resultados de tamizaje prenatal y neonatal (serología: VIH, sífilis y TSH), si no los tiene solicítelos. Si es positivo refiéralo </li></ul></td></tr></table></div>';
HTML_SIGNO_PELIGRO2 = '<div style="background-color:#FFFFD2; padding:5px"><table border="1" width="400" style="font-family:Arial, Helvetica, sans-serif; font-size:9px"><tr><td colspan="2" style="text-align:center; font-size:12px"><b>INFECCIÓN LOCAL</b></td></tr><tr><td width="190" style="text-align:center">SIGNOS</td><td width="190" style="text-align:center">TRATAMIENTO</td></tr><tr><td style="padding:5px">Uno de los siguientes signos:<ul><li>Secreción purulenta con eritema conjuntival</li><li>Ombligo con secreción purulenta sin eritema que se extiende a la piel</li><li>Pústulas en la piel, pocas y localizadas</li><li>Placas blanquecinas en la boca</li></ul></td><td style="padding:5px"><ul><li>Administrar un antibiótico recomendado o nistatina según corresponda</li><li>Continuar lactancia materna exclusiva</li><li>Enseñar a la madre a tratar las infecciones locales </li><li>Enseñar a la madre las medidas preventivas</li><li>Enseñar a la madre los signos de alarma  para regresar de inmediato</li><li>Incluir en el programa de Crecimiento y desarrollo</li><li>Hacer el seguimiento 2 días después</li><li>Revise resultados de tamizaje prenatal y neonatal (serología: VIH, sífilis y TSH), si no los tiene solicítelos.  Si es positivo refiéralo.</li></ul></td></tr></table></div>';
HTML_SIGNO_PELIGRO3 = '<div style="background-color:#D5FFEA; padding:5px"><table border="1" width="400" style="font-family:Arial, Helvetica, sans-serif; font-size:9px"><tr><td colspan="2" style="text-align:center; font-size:12px"><b>NO TIENE ENFERMEDAD MUY GRAVE O INFECCIÓN LOCAL</b></td></tr><tr><td width="190" style="text-align:center">SIGNOS</td><td width="190" style="text-align:center">TRATAMIENTO</td></tr><tr><td style="padding:5px">Ningún signo para clasificarse como ENFERMEDAD GRAVE O INFECCIÓN LOCAL</td><td style="padding:5px"><ul><ul><li>Aconsejar a la madre para que siga dándole lactancia materna exclusiva</li><li>Enseñar los signos de alarma para regresar de inmediato</li><li>Enseñar a la madre medidas preventivas</li><li>Verificar inmunizaciones</li><li>Incluir en programa de Crecimiento y desarrollo</li><li>Revise resultados de tamizaje prenatal y neonatal (serología: VIH, sífilis y TSH), si no los tiene solicítelos.  Si es positivo refiéralo</li></ul></td></tr></table></div>';
HTML_SIGNO_PRINCIPAL_DIARREA1 = '<div style="background-color:#FFC6C6; padding:5px"><table border="1" width="400" style="font-family:Arial, Helvetica, sans-serif; font-size:9px"><tr><td colspan="2" style="text-align:center; font-size:12px"><b>DESHIDRATACIÓN</b></td></tr><tr><td width="190" style="text-align:center">SIGNOS</td><td width="190" style="text-align:center">TRATAMIENTO</td></tr><tr><td style="padding:5px">Dos de los siguientes signos:<br />• Letárgico o Inconsciente<br />• Intranquilo o irritable<br />• Ojos hundidos<br />• Signo de pliegue cutáneo: La piel vuelve lentamente al estado anterior</td><td style="padding:5px"><b>• Referir URGENTEMENTE al hospital según las normas de estabilización y transporte “REFIERA”</b><br />• Dar líquidos para la deshidratación, iniciar PLAN B o C según corresponda<br />• Aconsejar a la madre que continúe dando el pecho si es posible</td></tr></table></div>'; 
HTML_SIGNO_PRINCIPAL_DIARREA2 = '<div style="background-color:#D5FFEA; padding:5px"><table border="1" width="400" style="font-family:Arial, Helvetica, sans-serif; font-size:9px"><tr><td colspan="2" style="text-align:center; font-size:12px"><b>NO TIENE DESHIDRATACIÓN</b></td></tr><tr><td width="190" style="text-align:center">SIGNOS</td><td width="190" style="text-align:center">TRATAMIENTO</td></tr><tr><td style="padding:5px">• No tiene signos suficientes para clasificarse como deshidratación</td><td style="padding:5px">• Dar lactancia materna exclusiva <br />• Dar recomendaciones para tratar la diarrea en casa (PLAN A), sin iniciar ningún alimento<br />• Suplementación terapéutica con zinc por 14 días<br />• Enseñar a la madre signos de alarma para regresar de inmediato<br />• Enseñar a la madre las medidas preventivas<br />• Hacer seguimiento 2 días después</td></tr></table></div>'; 
HTML_SIGNO_PRINCIPAL_DIARREA3 = '<div style="background-color:#FFC6C6; padding:5px"><table border="1" width="400" style="font-family:Arial, Helvetica, sans-serif; font-size:9px"><tr><td colspan="2" style="text-align:center; font-size:12px"><b>DIARREA PROLONGADA</b></td></tr><tr><td width="190" style="text-align:center">SIGNOS</td><td width="190" style="text-align:center">TRATAMIENTO</td></tr><tr><td style="padding:5px">• Tiene diarrea hace 7 días o más</td><td style="padding:5px"><b>• Referir URGENTEMENTE al hospital, según las normas de estabilización y transporte “REFIERA”</b><br />• Recomendar a la madre que continúe dándole lactancia materna</td></tr></table></div>'; 
HTML_SIGNO_PRINCIPAL_DIARREA4 = '<div style="background-color:#FFC6C6; padding:5px"><table border="1" width="400" style="font-family:Arial, Helvetica, sans-serif; font-size:9px"><tr><td colspan="2" style="text-align:center; font-size:12px"><b>DIARREA CON SANGRE</b></td></tr><tr><td width="190" style="text-align:center">SIGNOS</td><td width="190" style="text-align:center">TRATAMIENTO</td></tr><tr><td style="padding:5px">• Tiene sangre en las heces</td><td style="padding:5px"><b>• Referir URGENTEMENTE al hospital, según las normas de estabilización y transporte “REFIERA”</b><br />• Administrar dosis de vitamina K<br />• Administrar primera dosis de los antibióticos recomendados<br />• Recomendar a la madre que continúe dándole lactancia materna</td></tr></table></div>'; 
HTML_CRECIMIENTO_ALIMENTA1 = '<div style="background-color:#FFC6C6; padding:5px"><table border="1" width="400" style="font-family:Arial, Helvetica, sans-serif; font-size:9px"><tr><td colspan="2" style="text-align:center; font-size:12px"><b>PESO MUY BAJO</b></td></tr><tr><td width="190" style="text-align:center">SIGNOS</td><td width="190" style="text-align:center">TRATAMIENTO</td></tr><tr><td style="padding:5px">Uno de los siguientes:<br />• Peso/Edad menor −3DE (peso muy bajo/edad)<br />• Peso/Talla menor −3 DE (peso muy bajo para la talla)<br />• Peso menor a 2.000 gr</td><td style="padding:5px"><b>• Referir URGENTEMENTE  al hospital siguiendo las normas de estabilización y transporte “REFIERA”</b><br />• Prevenir la hipoglicemia<br />• Prevenir la hipotermia</td></tr></table></div>';
HTML_CRECIMIENTO_ALIMENTA2 = '<div style="background-color:#FFC6C6; padding:5px"><table border="1" width="400" style="font-family:Arial, Helvetica, sans-serif; font-size:9px"><tr><td colspan="2" style="text-align:center; font-size:12px"><b>PROBLEMA SEVERO DE ALIMENTACIÓN</b></td></tr><tr><td width="190" style="text-align:center">SIGNOS</td><td width="190" style="text-align:center">TRATAMIENTO</td></tr><tr><td style="padding:5px">Uno de los siguientes:<br />• No hay agarre<br />• No succiona nada<br />• Pérdida de peso del 10% o mayor en la primera semana<br />• Tendencia del peso descendente después de los 7 días de edad</td><td style="padding:5px"><b>• Referir URGENTEMENTE  al hospital siguiendo las normas de estabilización y transporte “REFIERA”</b><br />• Prevenir la hipoglicemia<br />• Prevenir la hipotermia</td></tr></table></div>';
HTML_CRECIMIENTO_ALIMENTA3 = '<div style="background-color:#FFFFD2; padding:5px"><table border="1" width="400" style="font-family:Arial, Helvetica, sans-serif; font-size:9px"><tr><td colspan="2" style="text-align:center; font-size:12px"><b>PESO BAJO O EN RIESGO</b></td></tr><tr><td width="190" style="text-align:center">SIGNOS</td><td width="190" style="text-align:center">TRATAMIENTO</td></tr><tr><td style="padding:5px"><b>Uno de los siguientes:</b><br />• Peso/Edad mayor igual −3 y menor −2 DE (peso bajo/edad)<br />• Peso/Talla: mayor igual −3 y menor −2 DE (peso bajo para la talla)<br />• Peso/Edad mayor igual −2 y menor −1 DE (Riesgo de peso bajo/edad)<br />• Peso/Talla: mayor igual −2 y menor −1 DE (Riesgo de peso bajo para la talla)</td><td style="padding:5px"><b>Si el niño recibe pecho:</b><br />• Aconsejar a la madre que le dé el pecho las veces y el tiempo que el niño quiera de día y de noche, mínimo 8 veces al día<br />• Si el niño tiene agarre deficiente o no mama bien, enseñar a la madre la posición y el agarre correctos<br />• Si recibe otros alimentos o líquidos: aconsejar a la madre que le dé el pecho más veces, reduciendo los otros alimentos o líquidos hasta eliminarlos y que no use biberón.<br />• Si la madre presenta molestias en las mamas, tratarla<br /><br /><b>Si el niño no se alimenta al pecho:</b><br />• Referir para asesoramiento sobre lactancia materna <br />• Iniciar un suplemento vitamínico recomendado<br />• En caso necesario enseñar a preparar una fórmula y a usar una taza<br /><br /><b>En todos los niños:</b><br />• Hacer el seguimiento para problema de alimentación 2 días después<br />• Hacer el seguimiento de peso  7 días después<br />• Enseñar a la madre signos de alarma para regresar de inmediato<br />• Remitir a consulta de pediatría<br />• Incluir en consulta de crecimiento y desarrollo<br />• Enseñar medidas preventivas específicas.</td></tr></table></div>';
HTML_CRECIMIENTO_ALIMENTA4 = '<div style="background-color:#FFFFD2; padding:5px"><table border="1" width="400" style="font-family:Arial, Helvetica, sans-serif; font-size:9px"><tr><td colspan="2" style="text-align:center; font-size:12px"><b>PROBLEMA DE ALIMENTACIÓN</b></td></tr><tr><td width="190" style="text-align:center">SIGNOS</td><td width="190" style="text-align:center">TRATAMIENTO</td></tr><tr><td style="padding:5px"><b>Uno de los siguientes:</b><br />• Tendencia de peso horizontal<br />• Pérdida de peso del 7 dia menor 10% en la primera semana<br />• Agarre deficiente<br />• No succiona bien<br />• Se alimenta al pecho menos de 8 veces en 24 horas<br />• Recibe otros alimentos o bebidas<br />• Recibe fórmula</td><td style="padding:5px"><b>Si el niño recibe pecho:</b><br />• Aconsejar a la madre que le dé el pecho las veces y el tiempo que el niño quiera de día y de noche, mínimo 8 veces al día<br />• Si el niño tiene agarre deficiente o no mama bien, enseñar a la madre la posición y el agarre correctos<br />• Si recibe otros alimentos o líquidos: aconsejar a la madre que le dé el pecho más veces, reduciendo los otros alimentos o líquidos hasta eliminarlos y que no use biberón.<br />• Si la madre presenta molestias en las mamas, tratarla<br /><br /><b>Si el niño no se alimenta al pecho:</b><br />• Referir para asesoramiento sobre lactancia materna <br />• Iniciar un suplemento vitamínico recomendado<br />• En caso necesario enseñar a preparar una fórmula y a usar una taza<br /><br /><b>En todos los niños:</b><br />• Hacer el seguimiento para problema de alimentación 2 días después<br />• Hacer el seguimiento de peso  7 días después<br />• Enseñar a la madre signos de alarma para regresar de inmediato<br />• Remitir a consulta de pediatría<br />• Incluir en consulta de crecimiento y desarrollo<br />• Enseñar medidas preventivas específicas.</td></tr></table></div>';
HTML_CRECIMIENTO_ALIMENTA5 = '<div style="background-color:#D5FFEA; padding:5px"><table border="1" width="400" style="font-family:Arial, Helvetica, sans-serif; font-size:9px"><tr><td colspan="2" style="text-align:center; font-size:12px"><b>ADECUADAS PRÁCTICAS DE ALIMENTACIÓN Y PESO ADECUADO</b></td></tr><tr><td width="190" style="text-align:center">SIGNOS</td><td width="190" style="text-align:center">TRATAMIENTO</td></tr><tr><td style="padding:5px"><b>Todos los siguientes:</b><br />• PesoEdad mayor −1 DE<br />• No hay ningún problema de alimentación<br />• Tendencia de crecimiento ascendente</td><td style="padding:5px">• Enseñar a la madre los cuidados del niño en el hogar<br />• Elogiar a la madre porque lo alimenta bien e indicar la importancia de lactancia exclusiva por 6 meses<br />• Enseñar signos de alarma para regresar de inmediato <br />• Control de peso en 30 días en consulta de crecimiento y desarrollo</td></tr></table></div>';
HTML_CRECIMIENTO_ALIMENTA6 = '<div style="background-color: #F60; padding:5px"><table border="1" width="400" style="font-family:Arial, Helvetica, sans-serif; font-size:9px"><tr><td colspan="2" style="text-align:center; font-size:12px"><b>SIN CLASIFICACION....!</b></td></tr></table></div>';
HTML_DESARROLLO1 = '<div style="background-color:#FFC6C6; padding:5px"><table border="1" width="400" style="font-family:Arial, Helvetica, sans-serif; font-size:9px"><tr><td colspan="2" style="text-align:center; font-size:12px"><b>PROBABLE RETRASO DEL DESARROLLO</b></td></tr><tr><td width="190" style="text-align:center">SIGNOS</td><td width="190" style="text-align:center">TRATAMIENTO</td></tr><tr><td style="padding:5px">Uno de los siguientes:<br />• Ausencia de uno o más reflejos/posturas/ habilidades para el grupo de edad anterior en el lactante de 1 a  2 meses<br />• En el menor de 1 mes, ausencia de uno o más reflejos/habilidades/posturas de su grupo de edad<br />• Perímetro cefálico < de -2 DE ó > de +2 DE para la edad<br />• Presencia de 3 o más alteraciones fenotípicas</td><td style="padding:5px"><b>• Refiera a una evaluación del neurodesarrollo por especialista (pediatra)</b><br />• Consulta de seguimiento en la siguiente semana para evaluar que sucedió en la consulta de referencia<br />• Enseñe signos de alarma para regresar de inmediato<br />• Recomendación de cuidados en casa y medidas preventivas específicas</td></tr></table></div>';
HTML_DESARROLLO2 = '<div style="background-color:#FFFFD2; padding:5px"><table border="1" width="400" style="font-family:Arial, Helvetica, sans-serif; font-size:9px"><tr><td colspan="2" style="text-align:center; font-size:12px"><b>DESARROLLO NORMAL CON FACTORES DE RIESGO</b></td></tr><tr><td width="190" style="text-align:center">SIGNOS</td><td width="190" style="text-align:center">TRATAMIENTO</td></tr><tr><td style="padding:5px">• El niño cumple todas las condiciones para su grupo de edad pero existen factores de riesgo</td><td style="padding:5px">• Aconseje a la madre sobre estimulación de su hijo de acuerdo a la edad<br />• Realice consulta de seguimiento a los 30 días<br />• Enseñe a la madre signos de alarma para regresar de inmediato<br />• Medidas preventivas dirigidas específicamente a los factores de riesgo modificables</td></tr></table></div>';
HTML_DESARROLLO3 = '<div style="background-color:#D5FFEA; padding:5px"><table border="1" width="400" style="font-family:Arial, Helvetica, sans-serif; font-size:9px"><tr><td colspan="2" style="text-align:center; font-size:12px"><b>DESARROLLO NORMAL</b></td></tr><tr><td width="190" style="text-align:center">SIGNOS</td><td width="190" style="text-align:center">TRATAMIENTO</td></tr><tr><td style="padding:5px">• Cumple todas las condiciones para el grupo de edad al que pertenece el niño y no hay factores de riesgo</td><td style="padding:5px">• Felicite a la madre<br />• Aconseje a la madre para que continúe estimulando a su hijo de acuerdo a su edad<br />• Enseñe a la madre los signos de alarma para regresar de inmediato</td></tr></table></div>';

winHCAIEPI001Ui = Ext.extend(Ext.Window, {
    title: 'eOfiClinic ©  .:: Plantilla HC - AIEPI 0 a 2 Meses ::.',
    width: 990,
    height: 600,
    closable: false,
    resizable: false,
    draggable: false,
    modal: true,
    id: 'winHC',
    initComponent: function() {
        tmpmx = objMX;
        tmpmxadd = objMXADD;
        tmpexa = objEXA;
        tmprem = objREM;
        myPaciente = 0;
        myCAS = 0;
        
        try {
            var campo = Ext.getCmp('sysPacientePlantillaHC');
            if ( campo != null ) {
                myPaciente = Ext.getCmp('sysPacientePlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myPaciente == 0){
            try {
                var campo1 = Ext.getCmp('sysIdPacienteHC');
                if ( campo1 != null ) {
                    myPaciente = Ext.getCmp('sysIdPacienteHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myPaciente == 0){
            try {
                var campo5 = Ext.getCmp('sysPacienteRefHC');
                if ( campo5 != null ) {
                    myPaciente = Ext.getCmp('sysPacienteRefHC').getValue();
                }
            }catch(ex){
            }
        }
        try {
            var campo2 = Ext.getCmp('sysCASPlantillaHC');
            if ( campo2 != null ) {
                myCAS = Ext.getCmp('sysCASPlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myCAS == 0){
            try {
                var campo3 = Ext.getCmp('sysCASHC');
                if ( campo3 != null ) {
                    myCAS = Ext.getCmp('sysCASHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myCAS == 0){
            try {
                var campo4 = Ext.getCmp('sysCASRefHC');
                if ( campo4 != null ) {
                    myCAS = Ext.getCmp('sysCASRefHC').getValue();
                }
            }catch(ex){
            }
        }

        if (objMX != "NA"){
            var xSolMX = eval(objMX);
            Ext.getCmp('gridMedicamentosHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: myPaciente,
                    pCAS: myCAS
                }
            });
        }
        else{
            var xSolMX = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        if (objEXA != "NA"){
            var xSolEXA = eval(objEXA);
            Ext.getCmp('gridExamenesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: myPaciente,
                    pCAS: myCAS
                }
            });
        }else{
            var xSolEXA = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }    
        if (objREM != "NA"){
            var xSolREM = eval(objREM);
            Ext.getCmp('gridRemisionesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: myPaciente,
                    pCAS: myCAS
                }
            });
        }else{
            var xSolREM = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }

        var dataAIEPIServicio = [
            ['CONSULTA EXTERNA'],
            ['UERGENCIAS']
        ];
        var stAIEPIServicio = new Ext.data.ArrayStore({
            fields: [
               {name: 'Descripcion'}
            ]
        });
        stAIEPIServicio.loadData(dataAIEPIServicio);

        var dataAIEPITipoConsulta = [
            ['1ra VEZ'],
            ['CONTROL']
        ];
        var stAIEPITipoConsulta = new Ext.data.ArrayStore({
            fields: [
               {name: 'Descripcion'}
            ]
        });
        stAIEPITipoConsulta.loadData(dataAIEPITipoConsulta);
        
        var dataAIEPITomaLiquido = [
            ['TOMA NORMALMENTE'],
            ['RECHAZA'],
            ['BEBE ÁVIDAMENTE'],
            ['NO PUEDE BEBER']
        ];
        var stAIEPITomaLiquido = new Ext.data.ArrayStore({
            fields: [
               {name: 'Descripcion'}
            ]
        });
        stAIEPITomaLiquido.loadData(dataAIEPITomaLiquido);
        
        var dataAIEPIPliegePiel = [
            ['NORMAL'],
            ['LENTAMENTE'],
            ['MUY LENTAMENTE']
        ];
        var stAIEPIPliegePiel = new Ext.data.ArrayStore({
            fields: [
               {name: 'Descripcion'}
            ]
        });
        stAIEPIPliegePiel.loadData(dataAIEPIPliegePiel);
        
        var dataAIEPIPustulasPiel = [
            ['NO'],
            ['MUCHAS O EXTENSAS'],
            ['POCAS Y LOCALIZADAS']
        ];
        var stAIEPIPustulasPiel = new Ext.data.ArrayStore({
            fields: [
               {name: 'Descripcion'}
            ]
        });
        stAIEPIPustulasPiel.loadData(dataAIEPIPustulasPiel);
        
        var dataAIEPIUtilizaTomarAlimento = [
            ['BIBERON'],
            ['TAZA']
        ];
        var stAIEPIUtiliaTomarAlimento = new Ext.data.ArrayStore({
            fields: [
               {name: 'Descripcion'}
            ]
        });
        stAIEPIUtiliaTomarAlimento.loadData(dataAIEPIUtilizaTomarAlimento);
        
        var dataAIEPITendenciaPeso = [
            ['ASCENDENTE'],
            ['DESCENDENTE'],
            ['HORIZONTAL']
        ];
        var stAIEPITendenciaPeso = new Ext.data.ArrayStore({
            fields: [
               {name: 'Descripcion'}
            ]
        });
        stAIEPITendenciaPeso.loadData(dataAIEPITendenciaPeso);
        
        var dataAIEPITipoSuccion = [
            ['BUENA'],
            ['DEFICIENTE'],
            ['MALA']
        ];
        var stAIEPITipoSuccion = new Ext.data.ArrayStore({
            fields: [
               {name: 'Descripcion'}
            ]
        });
        stAIEPITipoSuccion.loadData(dataAIEPITipoSuccion);
        
        this.items = [
            {
                xtype: 'panel',
                frame: true,
                anchor: '100%',
                id: 'panelHC',
                padding: 10,
                border: false,
                height: 560,
                autoScroll: true,
                layout: 'form',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysIdCodPlantillaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        value: 1,
                        id: 'sysUsaGridSalida'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        value: 0,
                        id: 'sysYaGuardoHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysPlantillaHC',
                        name: 'PLANTILLA'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptMx'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptExa'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptRem'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Actividad',
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        id: 'sysActividadHC',
                        name: 'PLANTILLA'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Empresa',
                        id: 'sysEmpresaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'IPS',
                        id: 'sysIPSHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Usuario',
                        id: 'sysUsuarioHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Profesional',
                        id: 'sysProfesionalHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Paciente',
                        id: 'sysIdPacienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Apertura',
                        id: 'sysAperturaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdClienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdPlanHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdSubPlanHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdContratoHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Edad',
                        id: 'sysEdadPacHC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Profesional',
                        id: 'sysProfesionalAgendaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'ConsecutivoDetalle',
                        id: 'sysConsecutivoDetalleHC'
                    },
                    {
                        xtype: 'hidden',
                        allowBlank: true,
                        readOnly: true,
                        width: 100,
                        id: 'sysLegalizaHC'
                    },
                    {
                        html: '<hr>',
                        style: 'background:transparent;',
                        border: false
                    },
                    {
                        xtype: 'tabpanel',
                        width: 930,
                        autoHeight: true,
                        border: false,
                        ref: 'fTabPanel',
                        id: 'fTabPanel',
                        activeTab: 0,
                        items: [
                            {
                                xtype: 'panel',
                                title: 'AIEPI 0 a 2 Meses',
                                autoHeight: true,
                                autoScroll: true,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaEvolucion',
                                layout: 'form',
                                items: [
                                    {
                                        xtype: 'form',
                                        frame: true,
                                        anchor: '100%',
                                        id: 'frmHC',
                                        padding: 10,
                                        border: false,
                                        autoScroll: true,
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'fieldset',
                                                title: 'DATOS DE IDENTIFICACION',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 500,
                                                                allowBlank: true,
                                                                readOnly: true,
                                                                fieldLabel: 'Paciente',
                                                                value: 'CC 792558261  - JORGE GALEANO RUIZ - (Masculino) FechaNac: 1973-01-30, Edad 38 Años',
                                                                id: 'sysPacienteHC'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysAIEPI_0z',
                                                                value: 'Edad (Meses): '
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 40,
                                                                minValue: 0,
                                                                maxValue: 60,
                                                                decimalPrecision: 0,
                                                                allowBlank: false,
                                                                value: 0,
                                                                id: 'intEdadPacHC'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysAIEPI_0xdz',
                                                                value: 'Genero: '
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 40,
                                                                allowBlank: true,
                                                                readOnly: true,
                                                                fieldLabel: 'Genero',
                                                                id: 'sysGeneroPacHC',
                                                                value: "M" // quitar
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        allowBlank: true,
                                                        readOnly: true,
                                                        fieldLabel: 'Cliente',
                                                        id: 'sysClienteHC'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                allowBlank: true,
                                                                readOnly: true,
                                                                fieldLabel: 'CAS',
                                                                id: 'sysCASHC'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysAIEPI_0',
                                                                value: 'Fecha: '
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                allowBlank: true,
                                                                readOnly: true,
                                                                width: 100,
                                                                id: 'sysFechaHC'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysAIEPI_1',
                                                                value: 'Hora: '
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                allowBlank: true,
                                                                readOnly: true,
                                                                width: 90,
                                                                id: 'sysHoraHC'
                                                            },
                                                            
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysAIEPI_2',
                                                                value: 'Nro Autorización: '
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 110,
                                                                allowBlank: true,
                                                                style: 'color:brown;',
                                                                readOnly: true,
                                                                id: 'sysNroAutorizacionHC'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                width: 200,
                                                                fieldLabel: 'Servicio',
                                                                name: 'Servicio',
                                                                allowBlank: false,
                                                                store: stAIEPIServicio,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strAIEPIServicio'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysAIEPI_3',
                                                                value: 'Tipo Consulta:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Tipo Consulta:',
                                                                width: 200,
                                                                allowBlank: false,
                                                                store: stAIEPITipoConsulta,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strAIEPITipoConsulta'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysAIEPI_3a',
                                                                value: 'El niño(a) está registrado?:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 100,
                                                                name: 'El niño(a) está registrado?',
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "SI",
                                                                id: 'strAIEPIEstaRegistrado'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 350,
                                                                fieldLabel: 'Acompañante',
                                                                name: 'Acompañante',
                                                                allowBlank: false,
                                                                id: 'strAIEPIAcompanante'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysAIEPI_4',
                                                                value: 'Parentesco:'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 320,
                                                                name: 'Parentesco',
                                                                allowBlank: false,
                                                                id: 'strAIEPIParentesco'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 350,
                                                                fieldLabel: 'Dirección',
                                                                name: 'Dirección',
                                                                allowBlank: false,
                                                                id: 'strAIEPIDireccion'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysAIEPI_6',
                                                                value: 'Teléfono:'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 332,
                                                                name: 'Teléfono',
                                                                allowBlank: false,
                                                                id: 'strAIEPITelefono'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 320,
                                                                fieldLabel: 'Ocupación Padre',
                                                                name: 'Ocupación Padre',
                                                                allowBlank: false,
                                                                id: 'strAIEPIOcupacionPadre'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysAIEPI_7',
                                                                value: 'Ocupación Madre:'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 315,
                                                                name: 'Ocupación Madre',
                                                                allowBlank: false,
                                                                id: 'strAIEPIOcupacionMadre'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'MOTIVO CONSULTA',
                                                layout: 'table',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        width: 835,
                                                        fieldLabel: 'MOTIVO CONSULTA Y ENFERMEDAD ACTUAL',
                                                        name: 'MOTIVO CONSULTA Y ENFERMEDAD ACTUAL',
                                                        height: 30,
                                                        grow: true,
                                                        minGrow: 30,
                                                        allowBlank: false,
                                                        id: 'memAIEPIMotivoConsulta'
                                                    },
                                                    {
                                                        xtype: 'button',
                                                        iconCls: 'btnAyuda',
                                                        tooltip: 'Consultar Instructivo',
                                                        listeners:{
                                                            click : function(){
                                                                var html = '<span>Ayuda AIEPI 001</span>';
                                                                Sexy.info(html);
                                                            }
                                                        }
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'ANTECEDENTES DE EMBARAZO PARTO DE IMPORTANCIA',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        fieldLabel: '¿Antecedentes?',
                                                        name: '¿Antecedentes?',
                                                        allowBlank: false,
                                                        id: 'strAIEPIAntPatoEmb'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 70,
                                                                minValue: 0,
                                                                decimalPrecision: 0,
                                                                emptyText: 'Semanas',
                                                                fieldLabel: '¿Edad Gestacional?',
                                                                name: '¿Edad Gestacional?',
                                                                allowBlank: false,
                                                                id: 'strAIEPIAntPatoEmbEdadGestacion'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysAIEPI_8',
                                                                value: 'Hemocalsificación:'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 70,
                                                                name: 'Hemocalsificación?',
                                                                allowBlank: false,
                                                                id: 'strAIEPIAntPatoEmbHemoclasifica'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'displayfield',
                                                anchor: '100%',
                                                id: 'sysAIEPI_11',
                                                style: 'text-transform:uppercase; color: #610B0B; font-size: 15px; font-weight: bold;',
                                                value: '<center>EVALUAR Y CLASIFICAR AL LACTANTE MENOR DE 2 MESES DE EDAD<center>'
                                            },
                                            {
                                                xtype: 'panel',
                                                title: 'VERIFICAR SI TIENE UNA ENFERMEDAD MUY GRAVE O INFECCION LOCAL',
                                                anchor: '100%',
                                                //height: 210,
                                                autoHeight: true,
                                                border: false,
                                                layout: {
                                                    columns: 2,
                                                    type: 'table'
                                                },
                                                items: [
                                                    {
                                                        xtype: 'panel',
                                                        autoHeight: true,
                                                        width: 450,
                                                        labelWidth: 300,
                                                        padding: 10,
                                                        layout: 'form',
                                                        items: [
                                                            {
                                                                xtype: 'fieldset',
                                                                title: 'PREGUNTAR:',
                                                                collapsible: true,
                                                                titleCollapse: true,
                                                                anchor: '100%',
                                                                autoHeight: true,
                                                                items:[
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 80,
                                                                        fieldLabel: '¿Puede tomar el pecho o beber?',
                                                                        name: '¿Puede tomar el pecho o beber?',
                                                                        labelStyle: 'color: #640000;',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        //value: "SI",
                                                                        id: 'strAIEPISIGNOPELIGROBeberPecho',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                ClasificarEnfermedadGraveInfeccionLocal(); 
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 80,
                                                                        fieldLabel: '¿Ha tenido vómito?',
                                                                        name: '¿Ha tenido vómito?',
                                                                        labelStyle: 'color: #640000;',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        //value: "NO",
                                                                        id: 'strAIEPISIGNOPELIGROVomita',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                ClasificarEnfermedadGraveInfeccionLocal(); 
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 80,
                                                                        fieldLabel: '¿Tiene dificultad para respirar?',
                                                                        name: '¿Tiene dificultad para respirar?',
                                                                        labelStyle: 'color: #640000;',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        //value: "NO",
                                                                        id: 'strAIEPISIGNOPELIGRODificRespira',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                ClasificarEnfermedadGraveInfeccionLocal(); 
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        width: 80,
                                                                        minValue: 0,
                                                                        maxValue: 250,
                                                                        decimalPrecision: 0,
                                                                        fieldLabel: 'CUENTE las respiraciones en un minuto',
                                                                        name: 'CUENTE las respiraciones en un minuto',
                                                                        emptyText: '/min',
                                                                        allowBlank: false,
                                                                        id: 'intAIEPITS_FR',
                                                                        listeners:{
                                                                            blur : function(f){
                                                                                ClasificarEnfermedadGraveInfeccionLocal(); 
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 80,
                                                                        fieldLabel: '¿Ha tenido fiebre?',
                                                                        name: '¿Ha tenido fiebre?',
                                                                        labelStyle: 'color: #640000;',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        //value: "NO",
                                                                        id: 'strAIEPISIGNOPELIGROFiebre',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                ClasificarEnfermedadGraveInfeccionLocal(); 
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 80,
                                                                        fieldLabel: '¿Ha tenido hipotermia?',
                                                                        name: '¿Ha tenido hipotermia?',
                                                                        labelStyle: 'color: #640000;',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        //value: "NO",
                                                                        id: 'strAIEPISIGNOPELIGROHipotermia',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                ClasificarEnfermedadGraveInfeccionLocal(); 
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        width: 80,
                                                                        minValue: 0,
                                                                        maxValue: 250,
                                                                        decimalPrecision: 0,
                                                                        fieldLabel: 'Temperatura Axilar',
                                                                        name: 'Temperatura Axilar',
                                                                        emptyText: '°C',
                                                                        allowBlank: false,
                                                                        id: 'intAIEPITS_Temperatura',
                                                                        listeners:{
                                                                            blur : function(f){
                                                                                ClasificarEnfermedadGraveInfeccionLocal(); 
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 80,
                                                                        fieldLabel: '¿Ha tenido convulsiones?',
                                                                        name: '¿Ha tenido convulsiones?',
                                                                        labelStyle: 'color: #640000;',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        //value: "NO",
                                                                        id: 'strAIEPISIGNOPELIGROConvulsiones',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                ClasificarEnfermedadGraveInfeccionLocal(); 
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        width: 80,
                                                                        minValue: 0,
                                                                        maxValue: 250,
                                                                        decimalPrecision: 0,
                                                                        labelStyle: 'color: #640000;',
                                                                        fieldLabel: '¿Cuántos pañales ha orinado en las ultimas 24 horas?',
                                                                        name: '¿Cuántos pañales ha orinado en las ultimas 24 horas?',
                                                                        allowBlank: false,
                                                                        id: 'intAIEPISIGNOPELIGRODiuresisNormal',
                                                                        listeners:{
                                                                            blur : function(f){
                                                                                ClasificarEnfermedadGraveInfeccionLocal(); 
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                height: 635,
                                                                width: 450,
                                                                title: '<center>Clasificación</center>',
                                                                padding: 10,
                                                                layout: 'form',
                                                                items: [
                                                                    {
                                                                        xtype: 'hidden',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        value: 'NA',
                                                                        id: 'strAIEPISIGNOPELIGROClasifica'
                                                                    },
                                                                    {
                                                                        id: 'sysAIEPISIGNOPELIGROClasifica1',
                                                                        html: HTML_SIGNO_PELIGRO1
                                                                    },
                                                                    {
                                                                        id: 'sysAIEPISIGNOPELIGROClasifica2',
                                                                        html: HTML_SIGNO_PELIGRO2
                                                                    },
                                                                    {
                                                                        id: 'sysAIEPISIGNOPELIGROClasifica3',
                                                                        html: HTML_SIGNO_PELIGRO3
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        autoHeight: true,
                                                        width: 430,
                                                        labelWidth: 250,
                                                        padding: 10,
                                                        layout: 'form',
                                                        items: [
                                                            {
                                                                xtype: 'fieldset',
                                                                title: 'OBSERVAR:',
                                                                collapsible: true,
                                                                titleCollapse: true,
                                                                anchor: '100%',
                                                                autoHeight: true,
                                                                items:[
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 120,
                                                                        fieldLabel: '¿Se mueve solo al estimulo?',
                                                                        name: '¿Se mueve solo al estimulo?',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        //value: "NO",
                                                                        id: 'strAIEPISIGNOPELIGROSeMueveSolo',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                ClasificarEnfermedadGraveInfeccionLocal(); 
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 120,
                                                                        fieldLabel: '¿Esta letárgico?',
                                                                        name: '¿Esta letárgico?',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        //value: "NO",
                                                                        id: 'strAIEPISIGNOPELIGRO_OBSLetargico',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                ClasificarEnfermedadGraveInfeccionLocal(); 
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 120,
                                                                        fieldLabel: '¿Se ve o luce mal?',
                                                                        name: '¿Se ve o luce mal?',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        //value: "NO",
                                                                        id: 'strAIEPISIGNOPELIGRO_OBSSeVeMal',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                ClasificarEnfermedadGraveInfeccionLocal(); 
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 120,
                                                                        fieldLabel: '¿Esta irritable?',
                                                                        name: '¿Esta irritable?',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        //value: "NO",
                                                                        id: 'strAIEPISIGNOPELIGRO_OBSIrritable',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                ClasificarEnfermedadGraveInfeccionLocal(); 
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 120,
                                                                        fieldLabel: '¿Tiene tiraje subcostal grave?',
                                                                        name: '¿Tiene tiraje subcostal grave?',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        //value: "NO",
                                                                        id: 'strAIEPISIGNOPELIGRO_OBSTirajeSubcostalGrave',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                ClasificarEnfermedadGraveInfeccionLocal(); 
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 120,
                                                                        fieldLabel: '¿Tiene apnea?',
                                                                        name: '¿Tiene apnea?',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        //value: "NO",
                                                                        id: 'strAIEPISIGNOPELIGRO_OBSApnea',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                ClasificarEnfermedadGraveInfeccionLocal(); 
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 120,
                                                                        fieldLabel: '¿Tiene aleteo nasal?',
                                                                        name: '¿Tiene aleteo nasal?',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        //value: "NO",
                                                                        id: 'strAIEPISIGNOPELIGRO_OBSAleteoNasal',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                ClasificarEnfermedadGraveInfeccionLocal(); 
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 120,
                                                                        fieldLabel: '¿Escuche si hay quejido?',
                                                                        name: '¿Escuche si hay quejido?',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        //value: "NO",
                                                                        id: 'strAIEPISIGNOPELIGRO_OBSQuejido',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                ClasificarEnfermedadGraveInfeccionLocal(); 
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 120,
                                                                        fieldLabel: '¿Escuche si hay estridor?',
                                                                        name: '¿Escuche si hay estridor?',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        //value: "NO",
                                                                        id: 'strAIEPISIGNOPELIGRO_OBSEstridor',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                ClasificarEnfermedadGraveInfeccionLocal(); 
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 120,
                                                                        fieldLabel: '¿Escuche si hay sibilancias?',
                                                                        name: '¿Escuche si hay sibilancias?',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        //value: "NO",
                                                                        id: 'strAIEPISIGNOPELIGRO_OBSSibilancia',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                ClasificarEnfermedadGraveInfeccionLocal(); 
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 120,
                                                                        fieldLabel: '¿Tiene la fontanela abombada?',
                                                                        name: '¿Tiene la fontanela abombada?',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        //value: "NO",
                                                                        id: 'strAIEPISIGNOPELIGRO_OBSFontanelaAbombada',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                ClasificarEnfermedadGraveInfeccionLocal(); 
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 120,
                                                                        fieldLabel: '¿Tiene la piel cianótica?',
                                                                        name: '¿Tiene la piel cianótica?',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        //value: "NO",
                                                                        id: 'strAIEPISIGNOPELIGRO_OBSPielCianotica',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                ClasificarEnfermedadGraveInfeccionLocal(); 
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 120,
                                                                        fieldLabel: '¿Tiene la piel pálida?',
                                                                        name: '¿Tiene la piel pálida?',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        //value: "NO",
                                                                        id: 'strAIEPISIGNOPELIGRO_OBSPielPalida',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                ClasificarEnfermedadGraveInfeccionLocal(); 
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 120,
                                                                        fieldLabel: '¿Presenta ictericia?',
                                                                        name: '¿Presenta ictericia?',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        //value: "NO",
                                                                        id: 'strAIEPISIGNOPELIGRO_OBSPresentaIctericia',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                ClasificarEnfermedadGraveInfeccionLocal(); 
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 120,
                                                                        fieldLabel: '¿Tiene pústulas o vesículas en la piel?',
                                                                        name: '¿Tiene pústulas o vesículas en la piel?',
                                                                        allowBlank: false,
                                                                        store: stAIEPIPustulasPiel,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        //value: "NO",
                                                                        id: 'strAIEPISIGNOPELIGRO_OBSPustulasVesiculasPiel',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                ClasificarEnfermedadGraveInfeccionLocal(); 
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 120,
                                                                        fieldLabel: '¿Tiene equimosis?',
                                                                        name: '¿Tiene equimosis?',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        //value: "NO",
                                                                        id: 'strAIEPISIGNOPELIGRO_OBSEquimosis',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                ClasificarEnfermedadGraveInfeccionLocal(); 
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 120,
                                                                        fieldLabel: '¿Tiene petequias?',
                                                                        name: '¿Tiene petequias?',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        //value: "NO",
                                                                        id: 'strAIEPISIGNOPELIGRO_OBSPetequias',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                ClasificarEnfermedadGraveInfeccionLocal(); 
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 120,
                                                                        fieldLabel: '¿Tiene hemorragia?',
                                                                        name: '¿Tiene hemorragia?',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        //value: "NO",
                                                                        id: 'strAIEPISIGNOPELIGRO_OBSHemorragia',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                ClasificarEnfermedadGraveInfeccionLocal(); 
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 120,
                                                                        fieldLabel: '¿Tiene sangre en heces?',
                                                                        name: '¿Tiene sangre en heces?',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        //value: "NO",
                                                                        id: 'strAIEPISIGNOPELIGRO_OBSSangreHeces',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                ClasificarEnfermedadGraveInfeccionLocal(); 
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 120,
                                                                        fieldLabel: '¿Existe eritema periumbilical?',
                                                                        name: '¿Existe eritema periumbilical?',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        //value: "NO",
                                                                        id: 'strAIEPISIGNOPELIGRO_OBSEritemaPeriumbilical',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                ClasificarEnfermedadGraveInfeccionLocal(); 
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 120,
                                                                        fieldLabel: '¿Tiene secreción purulenta en ombligo?',
                                                                        name: '¿Tiene secreción purulenta en ombligo?',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        //value: "NO",
                                                                        id: 'strAIEPISIGNOPELIGRO_OBSSecrecionOmbligo',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                ClasificarEnfermedadGraveInfeccionLocal(); 
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 120,
                                                                        fieldLabel: '¿Tiene edema palpebral?',
                                                                        name: '¿Tiene edema palpebral?',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        //value: "NO",
                                                                        id: 'strAIEPISIGNOPELIGRO_OBSEdemaPalpebral',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                ClasificarEnfermedadGraveInfeccionLocal(); 
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 120,
                                                                        fieldLabel: '¿Tiene eritema conjuntival?',
                                                                        name: '¿Tiene eritema conjuntival?',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        //value: "NO",
                                                                        id: 'strAIEPISIGNOPELIGRO_OBSEritemaConjuntival',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                ClasificarEnfermedadGraveInfeccionLocal(); 
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 120,
                                                                        fieldLabel: '¿Tiene secreción purulenta en ojos?',
                                                                        name: '¿Tiene secreción purulenta en ojos?',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        //value: "NO",
                                                                        id: 'strAIEPISIGNOPELIGRO_OBSSecrecionOjos',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                ClasificarEnfermedadGraveInfeccionLocal(); 
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 120,
                                                                        fieldLabel: '¿Tiene secreción purulenta en oídos?',
                                                                        name: '¿Tiene secreción purulenta en oídos?',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        //value: "NO",
                                                                        id: 'strAIEPISIGNOPELIGRO_OBSSecrecionOido',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                ClasificarEnfermedadGraveInfeccionLocal(); 
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 120,
                                                                        fieldLabel: '¿Presenta distensión abdominal?',
                                                                        name: '¿Presenta distensión abdominal?',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        //value: "NO",
                                                                        id: 'strAIEPISIGNOPELIGRO_OBSDestensionAbdominal',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                ClasificarEnfermedadGraveInfeccionLocal(); 
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'fieldset',
                                                                title: 'DETERMINAR:',
                                                                collapsible: true,
                                                                titleCollapse: true,
                                                                anchor: '100%',
                                                                autoHeight: true,
                                                                items:[
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        width: 120,
                                                                        minValue: 0,
                                                                        maxValue: 250,
                                                                        decimalPrecision: 2,
                                                                        allowBlank: false,
                                                                        fieldLabel: '¿Peso?',
                                                                        name: '¿Peso?',
                                                                        emptyText: '(Kg)',
                                                                        id: 'intAIEPITS_Peso',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null || pNew == 0){
                                                                                    Ext.getCmp('intAIEPITS_Peso').setValue(null);
                                                                                    Ext.getCmp('intAIEPITS_IMC').setValue(0);
                                                                                }else{
                                                                                    //peso [kg]/ estatura [m2]
                                                                                    if(Ext.getCmp('intAIEPITS_Talla').getValue() > 0){
                                                                                        var pTalla = Ext.getCmp('intAIEPITS_Talla').getValue() / 100;
                                                                                        Ext.getCmp('intAIEPITS_IMC').setValue(Ext.getCmp('intAIEPITS_Peso').getValue()/(pTalla*pTalla));
                                                                                    }else{
                                                                                        Ext.getCmp('intAIEPITS_IMC').setValue(0);
                                                                                    }
                                                                                }
                                                                                if(Ext.getCmp('intAIEPITS_IMC').getValue()<1){
                                                                                   Ext.getCmp('strAIEPITS_IMCClasificacon').setValue(null);
                                                                                }else{
                                                                                    if(Ext.getCmp('intAIEPITS_IMC').getValue()<24.9){
                                                                                       Ext.getCmp('strAIEPITS_IMCClasificacon').setValue("ACEPTABLE");
                                                                                    }else{
                                                                                        if(Ext.getCmp('intAIEPITS_IMC').getValue()<29.9){
                                                                                           Ext.getCmp('strAIEPITS_IMCClasificacon').setValue("SOBREPESO");
                                                                                        }else{
                                                                                            Ext.getCmp('strAIEPITS_IMCClasificacon').setValue("OBESIDAD");
                                                                                        }
                                                                                    }
                                                                                }
                                                                                Ext.getCmp('sysAIEPITS_Peso').setValue(Ext.getCmp('intAIEPITS_Peso').getValue());
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        width: 120,
                                                                        minValue: 0,
                                                                        maxValue: 250,
                                                                        decimalPrecision: 0,
                                                                        fieldLabel: '¿Frecuencia cardíaca?',
                                                                        name: '¿Frecuencia cardíaca?',
                                                                        allowBlank: false,
                                                                        emptyText: '/min',
                                                                        id: 'intAIEPITS_FC',
                                                                        listeners:{
                                                                            blur : function(f){
                                                                                ClasificarEnfermedadGraveInfeccionLocal(); 
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        width: 120,
                                                                        minValue: 0,
                                                                        maxValue: 250,
                                                                        decimalPrecision: 0,
                                                                        fieldLabel: '¿Frecuencia respiratoria?',
                                                                        name: '¿Frecuencia respiratoria?',
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        emptyText: '/min',
                                                                        id: 'sysAIEPITS_FR'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        width: 120,
                                                                        minValue: 0,
                                                                        maxValue: 250,
                                                                        decimalPrecision: 0,
                                                                        fieldLabel: '¿Temperatura axilar?',
                                                                        name: '¿Temperatura axilar?',
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        emptyText: '/min',
                                                                        id: 'sysAIEPITS_Temperatura'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 120,
                                                                        fieldLabel: '¿Tiene placas blanquecinas en la boca?',
                                                                        name: '¿Tiene placas blanquecinas en la boca?',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        //value: "NO",
                                                                        id: 'strAIEPISIGNOPELIGRO_OBSPlacasBlanquesinasBoca',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                ClasificarEnfermedadGraveInfeccionLocal(); 
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 120,
                                                                        fieldLabel: '¿El llenado capilar es lento?',
                                                                        name: '¿El llenado capilar es lento?',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strAIEPISIGNOPELIGRO_OBSLlenadoCapilar',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                ClasificarEnfermedadGraveInfeccionLocal(); 
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '¿TIENE EL LACTANTE DIARREA?',
                                                anchor: '100%',
                                                //height: 210,
                                                autoHeight: true,
                                                border: false,
                                                layout: {
                                                    columns: 2,
                                                    type: 'table'
                                                },
                                                items: [
                                                    {
                                                        xtype: 'panel',
                                                        autoHeight: true,
                                                        width: 450,
                                                        labelWidth: 300,
                                                        padding: 10,
                                                        layout: 'form',
                                                        items: [
                                                            {
                                                                xtype: 'fieldset',
                                                                title: 'PREGUNTAR:',
                                                                collapsible: true,
                                                                titleCollapse: true,
                                                                anchor: '100%',
                                                                autoHeight: true,
                                                                items:[
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 80,
                                                                        fieldLabel: '¿Tiene el niño diarrea?',
                                                                        name: '¿Tiene el niño diarrea?',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strAIEPIDIARREA_TieneDiarrea',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                ClasificarTieneDiarrea(); 
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        width: 80,
                                                                        minValue: 0,
                                                                        maxValue: 250,
                                                                        decimalPrecision: 0,
                                                                        fieldLabel: '¿Desde cuándo?',
                                                                        name: '¿Desde cuándo?',
                                                                        allowBlank: true,
                                                                        emptyText: 'Dias',
                                                                        id: 'intAIEPIDIARREA_DesdeCuando',
                                                                        listeners:{
                                                                            blur : function(f){
                                                                                ClasificarTieneDiarrea(); 
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 80,
                                                                        fieldLabel: '¿Hay sangre en heces?',
                                                                        name: '¿Hay sangre en heces?',
                                                                        allowBlank: true,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        //value: "NO",
                                                                        id: 'strAIEPIDIARREA_SangreHeces',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                ClasificarTieneDiarrea(); 
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                height: 300,
                                                                width: 450,
                                                                title: '<center>Clasificación</center>',
                                                                padding: 10,
                                                                layout: 'form',
                                                                id: 'pnAIEPIDIARREA_Clasifica',
                                                                items: [
                                                                    {
                                                                        xtype: 'hidden',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        value: 'NA',
                                                                        id: 'strAIEPIDIARREAClasifica'
                                                                    },
                                                                    {
                                                                        id: 'sysAIEPIDIARREAClasifica1',
                                                                        html: HTML_SIGNO_PRINCIPAL_DIARREA1
                                                                    },
                                                                    {
                                                                        id: 'sysAIEPIDIARREAClasifica2',
                                                                        html: HTML_SIGNO_PRINCIPAL_DIARREA2
                                                                    },
                                                                    {
                                                                        id: 'sysAIEPIDIARREAClasifica3',
                                                                        html: HTML_SIGNO_PRINCIPAL_DIARREA3
                                                                    },
                                                                    {
                                                                        id: 'sysAIEPIDIARREAClasifica4',
                                                                        html: HTML_SIGNO_PRINCIPAL_DIARREA4
                                                                    }
,                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        height: 430,
                                                        width: 430,
                                                        labelWidth: 250,
                                                        padding: 10,
                                                        layout: 'form',
                                                        id: 'fsAIEPIDIARREA_Observar',
                                                        items: [
                                                            {
                                                                xtype: 'fieldset',
                                                                title: 'OBSERVAR Y PALPAR:',
                                                                collapsible: true,
                                                                titleCollapse: true,
                                                                anchor: '100%',
                                                                autoHeight: true,
                                                                items:[
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 120,
                                                                        fieldLabel: '¿Está letárgico o inconsciente?',
                                                                        name: '¿Está letárgico o inconsciente?',
                                                                        allowBlank: true,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strAIEPIDIARREA_OBSLetargicoIncionciente',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                ClasificarTieneDiarrea(); 
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 120,
                                                                        fieldLabel: '¿Intranquilo o irritable?',
                                                                        name: '¿Intranquilo o irritable?',
                                                                        allowBlank: true,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        //value: "NO",
                                                                        id: 'strAIEPIDIARREA_OBSIntranquiloIrritable',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                ClasificarTieneDiarrea(); 
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 120,
                                                                        fieldLabel: '¿Los ojos están hundidos?',
                                                                        name: '¿Los ojos están hundidos?',
                                                                        allowBlank: true,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        //value: "NO",
                                                                        id: 'strAIEPIDIARREA_OBSOjosHundidos',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                ClasificarTieneDiarrea(); 
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 120,
                                                                        fieldLabel: '¿Los ojos están hundidos?',
                                                                        name: '¿Los ojos están hundidos?',
                                                                        allowBlank: true,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strAIEPIDIARREA_OBSOjosHundidos',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                ClasificarTieneDiarrea(); 
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 120,
                                                                        fieldLabel: '¿Signo del pliegue?',
                                                                        name: '¿Signo del pliegue?',
                                                                        allowBlank: true,
                                                                        store: stAIEPIPliegePiel,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        listWidth: 150,
                                                                        id: 'strAIEPIDIARREA_OBSSignoPliegue',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                ClasificarTieneDiarrea();
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: 'VERIFICAR EL CRECIMIENTO Y VERIFICAR LAS PRÁCTICAS APROPIADAS DE ALIMENTACIÓN',
                                                anchor: '100%',
                                                //height: 210,
                                                autoHeight: true,
                                                border: false,
                                                layout: {
                                                    columns: 2,
                                                    type: 'table',
                                                    cellCls : 'verticalAlignTop'
                                                },
                                                items: [
                                                    {
                                                        xtype: 'panel',
                                                        autoHeight: true,
                                                        //height: 1230,
                                                        width: 450,
                                                        labelWidth: 300,
                                                        padding: 10,
                                                        layout: 'form',
                                                        items: [
                                                            {
                                                                xtype: 'fieldset',
                                                                title: 'PREGUNTAR:',
                                                                collapsible: true,
                                                                titleCollapse: true,
                                                                anchor: '100%',
                                                                autoHeight: true,
                                                                items:[
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 80,
                                                                        fieldLabel: '¿Tiene alguna dificultad para alimentarlo?',
                                                                        name: '¿Tiene alguna dificultad para alimentarlo?',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        listWidth: 150,
                                                                        id: 'strAIEPICRECIMIENTO_DificultadAlimentarlo',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                ClasificarCrecimientoPracticasAlimentacion();
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'panel',
                                                                        labelWidth: '30',
                                                                        anchor: '100%',
                                                                        items: [
                                                                            {
                                                                                xtype: 'displayfield',
                                                                                id: 'sysAIEPI_0x',
                                                                                value: 'Cual: '
                                                                            },
                                                                            {
                                                                                xtype: 'textfield',
                                                                                width: 390,
                                                                                name: '¿Cual?',
                                                                                allowBlank: true,
                                                                                disabled: true,
                                                                                id: 'strAIEPICRECIMIENTO_DificultadAlimentarloCual'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 80,
                                                                        fieldLabel: '¿Ha dejado de comer?',
                                                                        name: '¿Ha dejado de comer?',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        listWidth: 150,
                                                                        id: 'strAIEPICRECIMIENTO_HaDejadoComer',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                ClasificarCrecimientoPracticasAlimentacion();
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        width: 80,
                                                                        minValue: 0,
                                                                        maxValue: 250,
                                                                        decimalPrecision: 0,
                                                                        fieldLabel: '¿Desde cuándo?',
                                                                        name: '¿Desde cuándo?',
                                                                        allowBlank: true,
                                                                        emptyText: 'Dias',
                                                                        id: 'intAIEPICRECIMIENTO_HaDejadoComerDesdeCuando',
                                                                        listeners:{
                                                                            blur : function(f){
                                                                                ClasificarTieneDiarrea(); 
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 80,
                                                                        fieldLabel: '¿Se alimenta con leche materna?',
                                                                        name: '¿Se alimenta con leche materna?',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        listWidth: 150,
                                                                        id: 'strAIEPICRECIMIENTO_SeAlimentaLecheMaterna',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                ClasificarCrecimientoPracticasAlimentacion();
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 80,
                                                                        fieldLabel: '¿Le ofrece leche materna en forma exclusiva?',
                                                                        name: '¿Le ofrece leche materna en forma exclusiva?',
                                                                        allowBlank: true,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        listWidth: 150,
                                                                        id: 'strAIEPICRECIMIENTO_LecheMaternaExclusiva',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                ClasificarCrecimientoPracticasAlimentacion();
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        width: 80,
                                                                        minValue: 0,
                                                                        maxValue: 250,
                                                                        decimalPrecision: 0,
                                                                        fieldLabel: '¿cuántas veces en 24 horas?',
                                                                        name: '¿cuántas veces en 24 horas?',
                                                                        allowBlank: true,
                                                                        emptyText: 'Dias',
                                                                        id: 'intAIEPICRECIMIENTO_LecheMaternaExclusivaCuantas',
                                                                        listeners:{
                                                                            blur : function(f){
                                                                                ClasificarTieneDiarrea(); 
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 80,
                                                                        fieldLabel: '¿Recibe otra leche, otro alimento o bebida?',
                                                                        name: '¿Recibe otra leche, otro alimento o bebida?',
                                                                        allowBlank: true,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        listWidth: 150,
                                                                        id: 'strAIEPICRECIMIENTO_RecibeOtraLeche',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                ClasificarCrecimientoPracticasAlimentacion();
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'panel',
                                                                        labelWidth: '30',
                                                                        anchor: '100%',
                                                                        items: [
                                                                            {
                                                                                xtype: 'displayfield',
                                                                                id: 'sysAIEPI_0w',
                                                                                value: '¿Cuales?: '
                                                                            },
                                                                            {
                                                                                xtype: 'textfield',
                                                                                width: 390,
                                                                                name: '¿Cual?',
                                                                                allowBlank: true,
                                                                                disabled: true,
                                                                                id: 'strAIEPICRECIMIENTO_RecibeOtraLecheCual'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        width: 80,
                                                                        minValue: 0,
                                                                        maxValue: 250,
                                                                        decimalPrecision: 0,
                                                                        fieldLabel: '¿Con qué frecuencia?',
                                                                        name: '¿Con qué frecuencia?',
                                                                        allowBlank: true,
                                                                        emptyText: 'Dias',
                                                                        id: 'intAIEPICRECIMIENTO_RecibeOtraLecheFrecuencia',
                                                                        listeners:{
                                                                            blur : function(f){
                                                                                ClasificarTieneDiarrea(); 
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'panel',
                                                                        labelWidth: '30',
                                                                        anchor: '100%',
                                                                        items: [
                                                                            {
                                                                                xtype: 'displayfield',
                                                                                id: 'sysAIEPI_0y',
                                                                                value: '¿Cuales?: '
                                                                            },
                                                                            {
                                                                                xtype: 'textfield',
                                                                                width: 390,
                                                                                name: '¿Cual?',
                                                                                allowBlank: true,
                                                                                disabled: true,
                                                                                id: 'strAIEPICRECIMIENTO_RecibeOtraLecheComoPrepara'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 80,
                                                                        fieldLabel: '¿Qué utiliza para alimentar al lactante?',
                                                                        name: '¿Qué utiliza para alimentar al lactante?',
                                                                        allowBlank: true,
                                                                        store: stAIEPIUtiliaTomarAlimento,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        listWidth: 150,
                                                                        id: 'strAIEPICRECIMIENTO_QueUtilizaParaTomarAlimento',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                ClasificarCrecimientoPracticasAlimentacion();
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 80,
                                                                        fieldLabel: '¿Utiliza chupo?',
                                                                        name: '¿Utiliza chupo?',
                                                                        allowBlank: true,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        listWidth: 150,
                                                                        id: 'strAIEPICRECIMIENTO_UtilizaChupo',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                ClasificarCrecimientoPracticasAlimentacion();
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                autoHeight: true,
                                                                width: 450,
                                                                title: '<center>Clasificación</center>',
                                                                padding: 10,
                                                                layout: 'form',
                                                                items: [
                                                                    {
                                                                        xtype: 'hidden',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        value: 'NA',
                                                                        id: 'strAIEPICRECIMIENTOClasifica'
                                                                    },
                                                                    {
                                                                        id: 'sysAIEPICRECIMIENTOClasifica1',
                                                                        html: HTML_CRECIMIENTO_ALIMENTA1
                                                                    },
                                                                    {
                                                                        id: 'sysAIEPICRECIMIENTOClasifica2',
                                                                        html: HTML_CRECIMIENTO_ALIMENTA2
                                                                    },
                                                                    {
                                                                        id: 'sysAIEPICRECIMIENTOClasifica3',
                                                                        html: HTML_CRECIMIENTO_ALIMENTA3
                                                                    },
                                                                    {
                                                                        id: 'sysAIEPICRECIMIENTOClasifica4',
                                                                        html: HTML_CRECIMIENTO_ALIMENTA4
                                                                    },
                                                                    {
                                                                        id: 'sysAIEPICRECIMIENTOClasifica5',
                                                                        html: HTML_CRECIMIENTO_ALIMENTA5
                                                                    },
                                                                    {
                                                                        id: 'sysAIEPICRECIMIENTOClasifica6',
                                                                        html: HTML_CRECIMIENTO_ALIMENTA6
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        autoHeight: true,
                                                        //height: 1230,
                                                        autoScroll: true,
                                                        width: 430,
                                                        labelWidth: 250,
                                                        padding: 10,
                                                        layout: 'form',
                                                        items: [
                                                            {
                                                                xtype: 'fieldset',
                                                                title: 'OBSERVAR Y DETERMINAR:',
                                                                collapsible: true,
                                                                titleCollapse: true,
                                                                anchor: '100%',
                                                                autoHeight: true,
                                                                items:[
                                                                    {
                                                                        xtype: 'panel',
                                                                        layout: 'form',
                                                                        anchor: '100%',
                                                                        items: [
                                                                            {
                                                                                xtype: 'numberfield',
                                                                                width: 120,
                                                                                minValue: 0,
                                                                                maxValue: 250,
                                                                                decimalPrecision: 2,
                                                                                allowBlank: true,
                                                                                readOnly: true,
                                                                                fieldLabel: '¿Peso?',
                                                                                name: '¿Peso?',
                                                                                emptyText: '(Kg)',
                                                                                id: 'sysAIEPITS_Peso'
                                                                            },
                                                                            {
                                                                                xtype: 'numberfield',
                                                                                width: 120,
                                                                                minValue: 0,
                                                                                maxValue: 250,
                                                                                decimalPrecision: 2,
                                                                                allowBlank: true,
                                                                                fieldLabel: '¿Talla?',
                                                                                name: "Talla",
                                                                                emptyText: '(cms)',
                                                                                id: 'intAIEPITS_Talla',
                                                                                listeners:{
                                                                                    change : function(f,pNew, pOld){
                                                                                        if(pNew == null || pNew == 0){
                                                                                            Ext.getCmp('intAIEPITS_Talla').setValue(null);
                                                                                            Ext.getCmp('intAIEPITS_IMC').setValue(0);
                                                                                        }else{
                                                                                            //peso [kg]/ estatura [m2]
                                                                                            if(Ext.getCmp('intAIEPITS_Peso').getValue() > 0){
                                                                                                var pTalla = Ext.getCmp('intAIEPITS_Talla').getValue() / 100;
                                                                                                Ext.getCmp('intAIEPITS_IMC').setValue(Ext.getCmp('intAIEPITS_Peso').getValue()/(pTalla*pTalla));
                                                                                            }else{
                                                                                                Ext.getCmp('intAIEPITS_IMC').setValue(0);
                                                                                            }
                                                                                        }
                                                                                        if(Ext.getCmp('intAIEPITS_IMC').getValue()<1){
                                                                                           Ext.getCmp('strAIEPITS_IMCClasificacon').setValue(null);
                                                                                        }else{
                                                                                            if(Ext.getCmp('intAIEPITS_IMC').getValue()<24.9){
                                                                                               Ext.getCmp('strAIEPITS_IMCClasificacon').setValue("ACEPTABLE");
                                                                                            }else{
                                                                                                if(Ext.getCmp('intAIEPITSF_IMC').getValue()<29.9){
                                                                                                   Ext.getCmp('strAIEPITS_IMCClasificacon').setValue("SOBREPESO");
                                                                                                }else{
                                                                                                    Ext.getCmp('strAIEPITS_IMCClasificacon').setValue("OBESIDAD");
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            },
                                                                            {
                                                                                xtype: 'compositefield',
                                                                                style: 'background:transparent;',
                                                                                items: [
                                                                                    {
                                                                                        xtype: 'numberfield',
                                                                                        width: 40,
                                                                                        minValue: 0,
                                                                                        decimalPrecision: 2,
                                                                                        allowBlank: true,
                                                                                        readOnly: true,
                                                                                        fieldLabel: 'IMC',
                                                                                        name: "IMC",
                                                                                        id: 'intAIEPITS_IMC'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        width: 80,
                                                                                        allowBlank: true,
                                                                                        readOnly: true,
                                                                                        name: "IMC - CLASIFICACION",
                                                                                        id: 'strAIEPITS_IMCClasificacon'
                                                                                    }
                                                                                ]
                                                                            },
                                                                            {
                                                                                xtype: 'numberfield',
                                                                                width: 120,
                                                                                minValue: -50,
                                                                                decimalPrecision: 2,
                                                                                allowBlank: false,
                                                                                fieldLabel: 'Peso/Edad',
                                                                                name: "Peso/Edad",
                                                                                id: 'intAIEPICRECIMIENTO_PesoEdad',
                                                                                listeners:{
                                                                                    blur : function(f){
                                                                                        ClasificarTieneDiarrea(); 
                                                                                    }
                                                                                }
                                                                            },
                                                                            {
                                                                                xtype: 'numberfield',
                                                                                width: 120,
                                                                                minValue: -50,
                                                                                decimalPrecision: 2,
                                                                                allowBlank: false,
                                                                                fieldLabel: 'Peso/Talla',
                                                                                name: "Peso/Talla",
                                                                                id: 'intAIEPICRECIMIENTO_PesoTalla',
                                                                                listeners:{
                                                                                    blur : function(f){
                                                                                        ClasificarTieneDiarrea(); 
                                                                                    }
                                                                                }
                                                                            },
                                                                            {
                                                                                xtype: 'numberfield',
                                                                                width: 120,
                                                                                minValue: 0,
                                                                                decimalPrecision: 2,
                                                                                allowBlank: false,
                                                                                fieldLabel: 'Si es menor 7 dias, Perdida Peso%',
                                                                                name: "Si es menor 7 dias, Perdida Peso%",
                                                                                id: 'intAIEPICRECIMIENTO_PerdidaPesoMenor7Dias',
                                                                                listeners:{
                                                                                    blur : function(f){
                                                                                        ClasificarTieneDiarrea(); 
                                                                                    }
                                                                                }
                                                                            },
                                                                            {
                                                                                xtype: 'combo',
                                                                                width: 120,
                                                                                fieldLabel: '¿Tendencia Peso?',
                                                                                name: '¿Tendencia Peso?',
                                                                                allowBlank: true,
                                                                                store: stAIEPITendenciaPeso,
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                mode: 'local',
                                                                                forceSelection: true,
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 10,
                                                                                triggerAction: 'all',
                                                                                listWidth: 150,
                                                                                id: 'strAIEPICRECIMIENTO_TendenciaPeso',
                                                                                listeners:{
                                                                                    select : function(cmb, rec, idx){
                                                                                        ClasificarCrecimientoPracticasAlimentacion();
                                                                                    }
                                                                                }
                                                                            }
                                                                        ],
                                                                        bbar:{
                                                                            items: [
                                                                                {
                                                                                    xtype: 'button',
                                                                                    text: 'Peso para Edad',
                                                                                    iconCls: 'btnGraficar',
                                                                                    listeners:{
                                                                                        click : function(){
                                                                                            window.open("../../../app/frm/pyp/frmchartscyd.php?pPaciente=" + Ext.getCmp('sysIdPacienteHC').getValue() + "&pGrafica=CYD001&pGenero=" + Ext.getCmp('sysGeneroPacHC').getValue(),"Grafica Peso para la Edad");
                                                                                        }
                                                                                    }
                                                                                },
                                                                                {
                                                                                    xtype: 'tbseparator'
                                                                                },
                                                                                {
                                                                                    xtype: 'button',
                                                                                    text: 'Talla para Edad',
                                                                                    iconCls: 'btnGraficar',
                                                                                    listeners:{
                                                                                        click : function(){
                                                                                            window.open("../../../app/frm/pyp/frmchartscyd.php?pPaciente=" + Ext.getCmp('sysIdPacienteHC').getValue() + "&pGrafica=CYD002&pGenero=" + Ext.getCmp('sysGeneroPacHC').getValue(),"Grafica Peso para la Talla");
                                                                                        }
                                                                                    }
                                                                                },
                                                                                {
                                                                                    xtype: 'tbseparator'
                                                                                },
                                                                                {
                                                                                    xtype: 'button',
                                                                                    text: 'Peso para Talla',
                                                                                    iconCls: 'btnGraficar',
                                                                                    listeners:{
                                                                                        click : function(){
                                                                                            window.open("../../../app/frm/pyp/frmchartscyd.php?pPaciente=" + Ext.getCmp('sysIdPacienteHC').getValue() + "&pGrafica=CYD003&pGenero=" + Ext.getCmp('sysGeneroPacHC').getValue(),"Grafica Peso para la Talla");
                                                                                        }
                                                                                    }
                                                                                },
                                                                                {
                                                                                    xtype: 'tbseparator'
                                                                                },
                                                                                {
                                                                                    xtype: 'button',
                                                                                    text: 'IMC',
                                                                                    iconCls: 'btnGraficar',
                                                                                    listeners:{
                                                                                        click : function(){
                                                                                            window.open("../../../app/frm/pyp/frmchartscyd.php?pPaciente=" + Ext.getCmp('sysIdPacienteHC').getValue() + "&pGrafica=CYD004&pGenero=" + Ext.getCmp('sysGeneroPacHC').getValue(),"Grafica Peso para la Talla");
                                                                                        }
                                                                                    }
                                                                                }
                                                                            ]
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'fieldset',
                                                                title: 'EVALUAR EL AGARRE:',
                                                                collapsible: true,
                                                                titleCollapse: true,
                                                                anchor: '100%',
                                                                autoHeight: true,
                                                                items:[
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 120,
                                                                        fieldLabel: '¿Se observa más areola por encima del labio superior del lactante que por debajo del labio inferior?',
                                                                        name: '¿Se observa más areola por encima del labio superior del lactante que por debajo del labio inferior?',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        listWidth: 150,
                                                                        id: 'strAIEPICRECIMIENTO_SeObservaMasAreola',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                ClasificarCrecimientoPracticasAlimentacion();
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 120,
                                                                        fieldLabel: '¿La boca del lactante está muy abierta?',
                                                                        name: '¿La boca del lactante está muy abierta?',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        listWidth: 150,
                                                                        id: 'strAIEPICRECIMIENTO_BocaAbierta',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                ClasificarCrecimientoPracticasAlimentacion();
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 120,
                                                                        fieldLabel: '¿El labio inferior del lactante está evertido (hacia afuera)?',
                                                                        name: '¿El labio inferior del lactante está evertido (hacia afuera)?',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        listWidth: 150,
                                                                        id: 'strAIEPICRECIMIENTO_LabioInferiorEvertido',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                ClasificarCrecimientoPracticasAlimentacion();
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 120,
                                                                        fieldLabel: '¿El mentón del lactante está tocando o casi tocando el pecho?',
                                                                        name: '¿El mentón del lactante está tocando o casi tocando el pecho?',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        listWidth: 150,
                                                                        id: 'strAIEPICRECIMIENTO_MentonTocaPecho',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                ClasificarCrecimientoPracticasAlimentacion();
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 120,
                                                                        fieldLabel: '¿Efectividad de la succión?',
                                                                        name: '¿Efectividad de la succión?',
                                                                        allowBlank: false,
                                                                        store: stAIEPITipoSuccion,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        listWidth: 150,
                                                                        id: 'strAIEPICRECIMIENTO_TipoSuccion',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                ClasificarCrecimientoPracticasAlimentacion();
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: 'VERIFICAR SI EXISTE PROBLEMA EN EL DESARROLLO',
                                                anchor: '100%',
                                                //height: 210,
                                                autoHeight: true,
                                                border: false,
                                                layout: {
                                                    columns: 2,
                                                    type: 'table'
                                                },
                                                items: [
                                                    {
                                                        xtype: 'panel',
                                                        autoHeight: true,
                                                        width: 450,
                                                        labelWidth: 300,
                                                        padding: 10,
                                                        layout: 'form',
                                                        items: [
                                                            {
                                                                xtype: 'fieldset',
                                                                title: 'PREGUNTAR:',
                                                                collapsible: true,
                                                                titleCollapse: true,
                                                                anchor: '100%',
                                                                autoHeight: true,
                                                                items:[
                                                                    {
                                                                        xtype: 'panel',
                                                                        labelWidth: '30',
                                                                        anchor: '100%',
                                                                        items: [
                                                                            {
                                                                                xtype: 'displayfield',
                                                                                id: 'sysAIEPI_Desa0',
                                                                                value: '¿Cómo fue el embarazo de su hijo?'
                                                                            },
                                                                            {
                                                                                xtype: 'textarea',
                                                                                width: 385,
                                                                                fieldLabel: '¿Cómo fue el embarazo de su hijo?',
                                                                                name: '¿Cómo fue el embarazo de su hijo?',
                                                                                allowBlank: false,
                                                                                id: 'strAIEPIDESARROLLOComoFueEmbarazo'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'panel',
                                                                        labelWidth: '30',
                                                                        anchor: '100%',
                                                                        items: [
                                                                            {
                                                                                xtype: 'displayfield',
                                                                                id: 'sysAIEPI_Desa1',
                                                                                value: '¿Cuánto tiempo duró?'
                                                                            },
                                                                            {
                                                                                xtype: 'textfield',
                                                                                width: 385,
                                                                                fieldLabel: '¿Cuánto tiempo duró?',
                                                                                name: '¿Cuánto tiempo duró?',
                                                                                allowBlank: false,
                                                                                id: 'strAIEPIDESARROLLOCuantoDuro'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'panel',
                                                                        labelWidth: '30',
                                                                        anchor: '100%',
                                                                        items: [
                                                                            {
                                                                                xtype: 'displayfield',
                                                                                id: 'sysAIEPI_Desa1',
                                                                                value: '¿Cómo fue el parto de su hijo?'
                                                                            },
                                                                            {
                                                                                xtype: 'textfield',
                                                                                width: 385,
                                                                                fieldLabel: '¿Cómo fue el parto de su hijo?',
                                                                                name: '¿Cómo fue el parto de su hijo?',
                                                                                allowBlank: false,
                                                                                id: 'strAIEPIDESARROLLOComoFueParto'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        width: 80,
                                                                        minValue: 0,
                                                                        decimalPrecision: 2,
                                                                        fieldLabel: 'Peso al nacer?',
                                                                        name: 'Peso al nacer?',
                                                                        emptyText: 'gr',
                                                                        allowBlank: false,
                                                                        id: 'intAIEPIDESARROLLOCuantoPeso'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        width: 80,
                                                                        minValue: 0,
                                                                        decimalPrecision: 0,
                                                                        emptyText: 'cm',
                                                                        fieldLabel: 'Talla al nacer?',
                                                                        name: 'Talla al nacer?',
                                                                        allowBlank: false,
                                                                        id: 'intAIEPIDESARROLLOCuantoMidio'
                                                                    },
                                                                    {
                                                                        xtype: 'panel',
                                                                        labelWidth: '30',
                                                                        anchor: '100%',
                                                                        items: [
                                                                            {
                                                                                xtype: 'displayfield',
                                                                                id: 'sysAIEPI_Desa2',
                                                                                value: '¿Presentó algún problema después del nacimiento?'
                                                                            },
                                                                            {
                                                                                xtype: 'textfield',
                                                                                width: 385,
                                                                                fieldLabel: '¿Presentó algún problema después del nacimiento?',
                                                                                name: '¿Presentó algún problema después del nacimiento?',
                                                                                allowBlank: false,
                                                                                id: 'strAIEPIDESARROLLOProblemaDespuesNacer'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'panel',
                                                                        labelWidth: '30',
                                                                        anchor: '100%',
                                                                        items: [
                                                                            {
                                                                                xtype: 'displayfield',
                                                                                id: 'sysAIEPI_Desa3',
                                                                                value: '¿Ha presentado el niño algún problema serio de salud más serio hasta el día de hoy?'
                                                                            },
                                                                            {
                                                                                xtype: 'textfield',
                                                                                width: 385,
                                                                                fieldLabel: '¿Ha presentado el niño algún problema serio de salud más serio hasta el día de hoy?',
                                                                                name: '¿Ha presentado el niño algún problema serio de salud más serio hasta el día de hoy?',
                                                                                allowBlank: false,
                                                                                id: 'strAIEPIDESARROLLOProblemaSerioHastaHoy'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 80,
                                                                        fieldLabel: '¿Usted y el padre son parientes?',
                                                                        name: '¿Usted y el padre son parientes?',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        listWidth: 150,
                                                                        id: 'strAIEPIDESARROLLOPadrePariente',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                ClasificarProblemasDesarrollo();
                                                                            }
                                                                        }
                                                                    },	
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 80,
                                                                        fieldLabel: '¿Existe alguna persona en la familia que tenga un problema mental o físico?',
                                                                        name: '¿Existe alguna persona en la familia que tenga un problema mental o físico?',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        listWidth: 150,
                                                                        id: 'strAIEPIDESARROLLOFamiliaProblemaFisico',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                ClasificarProblemasDesarrollo();
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'panel',
                                                                        labelWidth: '30',
                                                                        anchor: '100%',
                                                                        items: [
                                                                            {
                                                                                xtype: 'displayfield',
                                                                                id: 'sysAIEPI_Desa4',
                                                                                value: '¿Quién cuida al niño, con quién juega?'
                                                                            },
                                                                            {
                                                                                xtype: 'textfield',
                                                                                width: 385,
                                                                                fieldLabel: '¿Quién cuida al niño, con quién juega?',
                                                                                name: '¿Quién cuida al niño, con quién juega?',
                                                                                allowBlank: false,
                                                                                id: 'strAIEPIDESARROLLOQuienCuidaJuegaNino'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'panel',
                                                                        labelWidth: '30',
                                                                        anchor: '100%',
                                                                        items: [
                                                                            {
                                                                                xtype: 'displayfield',
                                                                                id: 'sysAIEPI_Desa5',
                                                                                value: '¿Con quién pasa la mayor parte del día?'
                                                                            },
                                                                            {
                                                                                xtype: 'textfield',
                                                                                width: 385,
                                                                                fieldLabel: '¿Con quién pasa la mayor parte del día?',
                                                                                name: '¿Con quién pasa la mayor parte del día?',
                                                                                allowBlank: false,
                                                                                id: 'strAIEPIDESARROLLOConQuienPasaDia'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'panel',
                                                                        labelWidth: '30',
                                                                        anchor: '100%',
                                                                        items: [
                                                                            {
                                                                                xtype: 'displayfield',
                                                                                id: 'sysAIEPI_Desa6',
                                                                                value: '¿Cómo ve el desarrollo de su hijo?'
                                                                            },
                                                                            {
                                                                                xtype: 'textfield',
                                                                                width: 385,
                                                                                fieldLabel: '¿Cómo ve el desarrollo de su hijo?',
                                                                                name: '¿Cómo ve el desarrollo de su hijo?',
                                                                                allowBlank: false,
                                                                                id: 'strAIEPIDESARROLLOComoVeDesarrollo'
                                                                            }
                                                                        ]
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                autoHeight: true,
                                                                width: 450,
                                                                title: '<center>Clasificación</center>',
                                                                padding: 10,
                                                                layout: 'form',
                                                                items: [
                                                                    {
                                                                        xtype: 'hidden',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        value: 'NA',
                                                                        id: 'strAIEPIDESARROLLOClasifica'
                                                                    },
                                                                    {
                                                                        id: 'sysAIEPIDESARROLLOClasifica1',
                                                                        html: HTML_DESARROLLO1
                                                                    },
                                                                    {
                                                                        id: 'sysAIEPIDESARROLLOClasifica2',
                                                                        html: HTML_DESARROLLO2
                                                                    },
                                                                    {
                                                                        id: 'sysAIEPIDESARROLLOClasifica3',
                                                                        html: HTML_DESARROLLO3
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        autoHeight: true,
                                                        width: 430,
                                                        labelWidth: 250,
                                                        padding: 10,
                                                        layout: 'form',
                                                        items: [
                                                            {
                                                                xtype: 'fieldset',
                                                                title: 'OBSERVE Y EXAMINE el desarrollo:',
                                                                collapsible: true,
                                                                titleCollapse: true,
                                                                anchor: '100%',
                                                                autoHeight: true,
                                                                items:[
                                                                    {
                                                                        xtype: 'fieldset',
                                                                        title: 'MENOR DE UN MES',
                                                                        collapsible: true,
                                                                        titleCollapse: true,
                                                                        anchor: '100%',
                                                                        autoHeight: true,
                                                                        items:[
                                                                            {
                                                                                xtype: 'combo',
                                                                                width: 100,
                                                                                fieldLabel: '¿Reflejo de Moro?',
                                                                                name: '¿Reflejo de Moro?',
                                                                                allowBlank: true,
                                                                                store: 'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                mode: 'local',
                                                                                forceSelection: true,
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 10,
                                                                                triggerAction: 'all',
                                                                                listWidth: 150,
                                                                                id: 'strAIEPIDESARROLLO_MENOR1MESReflejoMoro',
                                                                                listeners:{
                                                                                    select : function(cmb, rec, idx){
                                                                                        ClasificarProblemasDesarrollo();
                                                                                    }
                                                                                }
                                                                            },
                                                                            {
                                                                                xtype: 'combo',
                                                                                width: 100,
                                                                                fieldLabel: '¿Reflejo Cócleo-palpebral?',
                                                                                name: '¿Reflejo Cócleo-palpebral?',
                                                                                allowBlank: true,
                                                                                store: 'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                mode: 'local',
                                                                                forceSelection: true,
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 10,
                                                                                triggerAction: 'all',
                                                                                listWidth: 150,
                                                                                id: 'strAIEPIDESARROLLO_MENOR1MESReflejoCocleo',
                                                                                listeners:{
                                                                                    select : function(cmb, rec, idx){
                                                                                        ClasificarProblemasDesarrollo();
                                                                                    }
                                                                                }
                                                                            },
                                                                            {
                                                                                xtype: 'combo',
                                                                                width: 100,
                                                                                fieldLabel: '¿Reflejo de succión?',
                                                                                name: '¿Reflejo de succión?',
                                                                                allowBlank: true,
                                                                                store: 'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                mode: 'local',
                                                                                forceSelection: true,
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 10,
                                                                                triggerAction: 'all',
                                                                                listWidth: 150,
                                                                                id: 'strAIEPIDESARROLLO_MENOR1MESReflejoSuccion',
                                                                                listeners:{
                                                                                    select : function(cmb, rec, idx){
                                                                                        ClasificarProblemasDesarrollo();
                                                                                    }
                                                                                }
                                                                            },
                                                                            {
                                                                                xtype: 'combo',
                                                                                width: 100,
                                                                                fieldLabel: '¿Brazos y piernas flexionadas?',
                                                                                name: '¿Brazos y piernas flexionadas?',
                                                                                allowBlank: true,
                                                                                store: 'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                mode: 'local',
                                                                                forceSelection: true,
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 10,
                                                                                triggerAction: 'all',
                                                                                listWidth: 150,
                                                                                id: 'strAIEPIDESARROLLO_MENOR1MESBrazosPiernasFlexionadas',
                                                                                listeners:{
                                                                                    select : function(cmb, rec, idx){
                                                                                        ClasificarProblemasDesarrollo();
                                                                                    }
                                                                                }
                                                                            },
                                                                            {
                                                                                xtype: 'combo',
                                                                                width: 100,
                                                                                fieldLabel: '¿Manos cerradas?',
                                                                                name: '¿Manos cerradas?',
                                                                                allowBlank: true,
                                                                                store: 'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                mode: 'local',
                                                                                forceSelection: true,
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 10,
                                                                                triggerAction: 'all',
                                                                                listWidth: 150,
                                                                                id: 'strAIEPIDESARROLLO_MENOR1MESManosCerradas',
                                                                                listeners:{
                                                                                    select : function(cmb, rec, idx){
                                                                                        ClasificarProblemasDesarrollo();
                                                                                    }
                                                                                }
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'fieldset',
                                                                        title: 'UN MES A MENOS DE 2 MESES DE EDAD',
                                                                        collapsible: true,
                                                                        titleCollapse: true,
                                                                        anchor: '100%',
                                                                        autoHeight: true,
                                                                        items:[
                                                                            {
                                                                                xtype: 'combo',
                                                                                width: 100,
                                                                                fieldLabel: '¿Vocaliza?',
                                                                                name: '¿Vocaliza?',
                                                                                allowBlank: true,
                                                                                store: 'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                mode: 'local',
                                                                                forceSelection: true,
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 10,
                                                                                triggerAction: 'all',
                                                                                listWidth: 150,
                                                                                id: 'strAIEPIDESARROLLO_1A2MESESVocaliza',
                                                                                listeners:{
                                                                                    select : function(cmb, rec, idx){
                                                                                        ClasificarProblemasDesarrollo();
                                                                                    }
                                                                                }
                                                                            },
                                                                            {
                                                                                xtype: 'combo',
                                                                                width: 100,
                                                                                fieldLabel: '¿Movimiento de piernas alternado?',
                                                                                name: '¿Movimiento de piernas alternado?',
                                                                                allowBlank: true,
                                                                                store: 'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                mode: 'local',
                                                                                forceSelection: true,
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 10,
                                                                                triggerAction: 'all',
                                                                                listWidth: 150,
                                                                                id: 'strAIEPIDESARROLLO_1A2MESESMovimientoPiernasAlterado',
                                                                                listeners:{
                                                                                    select : function(cmb, rec, idx){
                                                                                        ClasificarProblemasDesarrollo();
                                                                                    }
                                                                                }
                                                                            },
                                                                            {
                                                                                xtype: 'combo',
                                                                                width: 100,
                                                                                fieldLabel: '¿Sonrisa social?',
                                                                                name: '¿Sonrisa social?',
                                                                                allowBlank: true,
                                                                                store: 'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                mode: 'local',
                                                                                forceSelection: true,
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 10,
                                                                                triggerAction: 'all',
                                                                                listWidth: 150,
                                                                                id: 'strAIEPIDESARROLLO_1A2MESESSonrisaSocial',
                                                                                listeners:{
                                                                                    select : function(cmb, rec, idx){
                                                                                        ClasificarProblemasDesarrollo();
                                                                                    }
                                                                                }
                                                                            },
                                                                            {
                                                                                xtype: 'combo',
                                                                                width: 100,
                                                                                fieldLabel: '¿Sigue los objetos en la línea media?',
                                                                                name: '¿Sigue los objetos en la línea media?',
                                                                                allowBlank: true,
                                                                                store: 'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                mode: 'local',
                                                                                forceSelection: true,
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 10,
                                                                                triggerAction: 'all',
                                                                                listWidth: 150,
                                                                                id: 'strAIEPIDESARROLLO_1A2MESESSigueObjetosLineaMedia',
                                                                                listeners:{
                                                                                    select : function(cmb, rec, idx){
                                                                                        ClasificarProblemasDesarrollo();
                                                                                    }
                                                                                }
                                                                            }
                                                                        ]
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 100,
                                                                fieldLabel: '¿Presencia de 3 o más alteraciones fenotípicas?',
                                                                name: '¿Presencia de 3 o más alteraciones fenotípicas?',
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                listWidth: 150,
                                                                id: 'strAIEPIDESARROLLO_AlteracionesFonotipicas',
                                                                listeners:{
                                                                    select : function(cmb, rec, idx){
                                                                        ClasificarProblemasDesarrollo();
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 100,
                                                                fieldLabel: '¿Presenta Factores de Riesgo?',
                                                                name: '¿Presenta Factores de Riesgo?',
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                listWidth: 150,
                                                                id: 'strAIEPIDESARROLLO_FactoresRiesgo',
                                                                listeners:{
                                                                    select : function(cmb, rec, idx){
                                                                        ClasificarProblemasDesarrollo();
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'fieldset',
                                                                title: 'DETERMINE:',
                                                                collapsible: true,
                                                                titleCollapse: true,
                                                                anchor: '100%',
                                                                autoHeight: true,
                                                                items:[
                                                                    {
                                                                        xtype: 'panel',
                                                                        layout: 'form',
                                                                        anchor: '100%',
                                                                        items: [
                                                                            {
                                                                                xtype: 'numberfield',
                                                                                minValue: 0,
                                                                                decimalPrecision: 0,
                                                                                width: 100,
                                                                                emptyText: '(cms)',
                                                                                name: 'PC',
                                                                                fieldLabel: 'Perímetro Cefálico',
                                                                                allowBlank: true,
                                                                                id: 'strAIEPITS_PC'
                                                                            },
                                                                            {
                                                                                xtype: 'numberfield',
                                                                                minValue: -20,
                                                                                decimalPrecision: 0,
                                                                                width: 100,
                                                                                name: 'PC/E',
                                                                                fieldLabel: 'PC/E',
                                                                                allowBlank: true,
                                                                                id: 'intAIEPITS_PC'
                                                                            }
                                                                        ],
                                                                        bbar:{
                                                                            items: [
                                                                                {
                                                                                    xtype: 'button',
                                                                                    text: 'Perímetro Cefálico',
                                                                                    iconCls: 'btnGraficar',
                                                                                    listeners:{
                                                                                        click : function(){
                                                                                            window.open("../../../app/frm/pyp/frmchartscyd.php?pPaciente=" + Ext.getCmp('sysIdPacienteHC').getValue() + "&pGrafica=CYD005&pGenero=" + Ext.getCmp('sysGeneroPacHC').getValue(),"Grafica Peso para la Edad");
                                                                                        }
                                                                                    }
                                                                                },
                                                                                {
                                                                                    xtype: 'tbseparator'
                                                                                }
                                                                            ]
                                                                        }
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            //***
                                            {
                                                xtype: 'fieldset',
                                                title: 'COMPLETAR EXAMEN FISICO Y EVALUAR OTROS PROBLEMAS',
                                                layout: 'table',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        width: 835,
                                                        fieldLabel: 'COMPLETAR EXAMEN FISICO Y EVALUAR OTROS PROBLEMAS',
                                                        name: 'COMPLETAR EXAMEN FISICO Y EVALUAR OTROS PROBLEMAS',
                                                        height: 30,
                                                        grow: true,
                                                        minGrow: 30,
                                                        allowBlank: false,
                                                        id: 'memAIEPICompletarExamenFisicoOtrosProblemas'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'CUANDO DEBE VOVER DE INMEDIATO AL SERVICIO (Signos de Alarma)',
                                                layout: 'table',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        width: 835,
                                                        fieldLabel: 'CUANDO DEBE VOVER DE INMEDIATO AL SERVICIO (Signos de Alarma)',
                                                        name: 'CUANDO DEBE VOVER DE INMEDIATO AL SERVICIO (Signos de Alarma)',
                                                        height: 30,
                                                        grow: true,
                                                        minGrow: 30,
                                                        allowBlank: false,
                                                        id: 'memAIEPISignosAlarma'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'CUANDO DEBE VOVER CONSULTA DE CONTROL',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                items: [
                                                    {
                                                        xtype: 'datefield',
                                                        fieldLabel: 'Recien Nacido',
                                                        name: 'Recien Nacido',
                                                        anchor: '100%',
                                                        allowBlank: true,
                                                        disabledDates: '',
                                                        emptyText: '(dia/mes/año) ',
                                                        style: 'text-align:center;',
                                                        id: 'fecAIEPIControlRecienNacido'
                                                    },
                                                    {
                                                        xtype: 'datefield',
                                                        fieldLabel: 'Madre',
                                                        name: 'Madre',
                                                        anchor: '100%',
                                                        allowBlank: true,
                                                        disabledDates: '',
                                                        emptyText: '(dia/mes/año) ',
                                                        style: 'text-align:center;',
                                                        id: 'fecAIEPIControlMadre'
                                                    },
                                                    {
                                                        xtype: 'datefield',
                                                        fieldLabel: 'Niño Sano',
                                                        name: 'Niño Sano',
                                                        anchor: '100%',
                                                        allowBlank: true,
                                                        disabledDates: '',
                                                        emptyText: '(dia/mes/año) ',
                                                        style: 'text-align:center;',
                                                        id: 'fecAIEPIControlninoSano'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'REFERIDO A CONSULTA DE:',
                                                layout: 'table',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        width: 835,
                                                        fieldLabel: 'REFERIDO A CONSULTA DE',
                                                        name: 'REFERIDO A CONSULTA DE',
                                                        height: 30,
                                                        allowBlank: true,
                                                        id: 'memAIEPIReferidoConsulta'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'MEDIDAS ESPECIFICAS PREVENTIVAS',
                                                layout: 'table',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        width: 835,
                                                        fieldLabel: 'MEDIDAS ESPECIFICAS PREVENTIVAS',
                                                        name: 'MEDIDAS ESPECIFICAS PREVENTIVAS',
                                                        height: 30,
                                                        grow: true,
                                                        minGrow: 30,
                                                        allowBlank: false,
                                                        id: 'memAIEPIMedidasEspecificas'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'RECOMENDACIONES BUEN TRATO',
                                                layout: 'table',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        width: 835,
                                                        fieldLabel: 'RECOMENDACIONES BUEN TRATO',
                                                        name: 'RECOMENDACIONES BUEN TRATO',
                                                        height: 30,
                                                        grow: true,
                                                        minGrow: 30,
                                                        allowBlank: false,
                                                        id: 'memAIEPIRecomendacionesBuenTrato'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'OTRAS RECOMENDACIONES',
                                                layout: 'table',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        width: 835,
                                                        fieldLabel: 'OTRAS RECOMENDACIONES',
                                                        name: 'OTRAS RECOMENDACIONES',
                                                        height: 30,
                                                        allowBlank: true,
                                                        id: 'memAIEPIOtrasRecomendaciones'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'CONSUCTA',
                                                layout: 'table',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        width: 835,
                                                        fieldLabel: 'CONDUCTA',
                                                        name: 'CONDUCTA',
                                                        height: 30,
                                                        allowBlank: true,
                                                        id: 'memAIEPIConducta'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'RIPS',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                id: 'fsRips',
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: false,
                                                                fieldLabel: 'Diagnostico Principal',
                                                                id: 'sysDiagPpalHC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request({
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                        Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagPpalHCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Principal',
                                                                id: 'btnSearchDiagPpalHC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagPpalHC','sysDiagPpalHCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.1',
                                                                id: 'sysDiagRel1HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel1HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado1',
                                                                id: 'btnSearchDiagRel1HC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel1HC','sysDiagRel1HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.2',
                                                                id: 'sysDiagRel2HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel2HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado2',
                                                                id: 'btnSearchDiagRel2HC1',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel2HC','sysDiagRel2HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.3',
                                                                id: 'sysDiagRel3HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel3HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado3',
                                                                id: 'btnSearchDiagRel3HC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel3HC','sysDiagRel3HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Tipo de Diagnostico',
                                                        width:750,
                                                        name: 'Tipo de Diagnostico',
                                                        allowBlank: false,
                                                        store: 'StoreTipoDiagnostico',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        id: 'sysTipoDiagosticoHC'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Finalidad Consulta',
                                                        width:750,
                                                        name: 'Finalidad Consulta',
                                                        allowBlank: false,
                                                        store: 'StoreFinalidadConsulta',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 10,
                                                        id: 'sysFinalidadConsultaHC'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Causa Externa',
                                                        width:750,
                                                        name: 'Causa Externa',
                                                        allowBlank: false,
                                                        store: 'StoreCausaExterna',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 13,
                                                        id: 'sysCausaExternaHC'
                                                    }                            
                                                ]
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Medicamentos',
                                height: 352,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaMedicamentos',
                                items: [
                                    xSolMX
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Servicios',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaServicios',
                                items: [
                                    xSolEXA
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Remisiones',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaRemisiones',
                                items: [
                                    xSolREM
                                ]
                            }
                            /*,
                            {
                                xtype: 'panel',
                                title: 'Solicitud CTC',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaCTC',
                                items: [
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Consentimientos Informados',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaConsentimientos',
                                items: [
                                ]
                            },*/
                        ]
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btnSalirEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 1) 
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    if (Ext.getCmp('sysUsaGridSalida').getValue() == 1){
                                                        Ext.getCmp('gridFormulario').store.reload();
                                                    }
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Usted No ha Guardado la Evolución del Paciente y Se Perdera la Información, Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                },
                tbar:{
                    items: [
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Ver Historia Clínica',
                            iconCls: 'btnVerHC',
                            id: 'btnVerHC',
                            listeners:{
                                click : function(){
                                    var cmpResumenHC = new winFrmVerHistorialHC({
                                        renderTo: Ext.getBody()
                                    });
                                    Ext.getCmp('winViewEvolucionHC').title = "PACIENTE: " + Ext.getCmp('sysPacienteHC').getValue();
                                    Ext.getCmp('gridHistorialEvoluciones').store.load({
                                        params: {
                                            pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                                            pPaciente: Ext.getCmp('sysIdPacienteHC').getValue()
                                        }
                                    });
                                    cmpResumenHC.show();
                                }
                            }
                        },
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar Evolución',
                            iconCls: 'btnGuardar',
                            id: 'btnGuardarEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 0) 
                                    {
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Guardar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnGuardarRegistros();
                                                }
                                            }
                                        });
                                    }else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Modificar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnModificarRegistros();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                }
            }
        ];
        this.on({
            afterlayout:{scope:this, single:true, fn:function() {
                Ext.Msg.hide();
                if(paramOpcion == "Nuevo"){
                    Ext.getCmp('sysAIEPISIGNOPELIGROClasifica1').setVisible(false);
                    Ext.getCmp('sysAIEPISIGNOPELIGROClasifica2').setVisible(false);
                    Ext.getCmp('sysAIEPISIGNOPELIGROClasifica3').setVisible(false);
                    Ext.getCmp('sysAIEPIDIARREAClasifica1').setVisible(false);
                    Ext.getCmp('sysAIEPIDIARREAClasifica2').setVisible(false);
                    Ext.getCmp('sysAIEPIDIARREAClasifica3').setVisible(false);
                    Ext.getCmp('sysAIEPIDIARREAClasifica4').setVisible(false);
                    Ext.getCmp('pnAIEPIDIARREA_Clasifica').setVisible(false);
                    Ext.getCmp('fsAIEPIDIARREA_Observar').setVisible(false);
                    Ext.getCmp('intAIEPIDIARREA_DesdeCuando').setVisible(false);
                    Ext.getCmp('strAIEPIDIARREA_SangreHeces').setVisible(false);
                    Ext.getCmp('sysAIEPICRECIMIENTOClasifica1').setVisible(false);
                    Ext.getCmp('sysAIEPICRECIMIENTOClasifica2').setVisible(false);
                    Ext.getCmp('sysAIEPICRECIMIENTOClasifica3').setVisible(false);
                    Ext.getCmp('sysAIEPICRECIMIENTOClasifica4').setVisible(false);
                    Ext.getCmp('sysAIEPICRECIMIENTOClasifica5').setVisible(false);
                    Ext.getCmp('sysAIEPICRECIMIENTOClasifica6').setVisible(false);
                    Ext.getCmp('strAIEPIDESARROLLOClasifica').setValue("NA");
                    Ext.getCmp('sysAIEPIDESARROLLOClasifica1').setVisible(false);
                    Ext.getCmp('sysAIEPIDESARROLLOClasifica2').setVisible(false);
                    Ext.getCmp('sysAIEPIDESARROLLOClasifica3').setVisible(false);
                    ClasificarProblemasDesarrollo();
                    
                    //Ext.getCmp('sysAIEPISIGNOPPALRespiraClasifica1').setVisible(false);
                    
                }
            }}
        });
        winHCAIEPI001Ui.superclass.initComponent.call(this);
    }
});

function fnGuardarRegistros(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc2013.php',
            params:{
                task: 'guardar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pidPlantillaHC : Ext.getCmp('sysIdCodPlantillaHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue(),
                pFormulacion: 1
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1); 
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function fnModificarRegistros(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc2013.php',
            params:{
                task: 'modificar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue(),
                pFormulacion: 1
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function ClasificarEnfermedadGraveInfeccionLocal(){
    Ext.getCmp('sysAIEPISIGNOPELIGROClasifica1').setVisible(false);
    Ext.getCmp('sysAIEPISIGNOPELIGROClasifica2').setVisible(false);
    Ext.getCmp('sysAIEPISIGNOPELIGROClasifica3').setVisible(false);
    Ext.getCmp('strAIEPISIGNOPELIGROClasifica').setValue("NA");

    var YaClasifico = 0;
    
    if(Ext.getCmp('strAIEPISIGNOPELIGROBeberPecho').getValue() == "NO"){
        YaClasifico = 1;
    }
    if(YaClasifico == 0 && Ext.getCmp('strAIEPISIGNOPELIGROVomita').getValue() == "SI"){
        YaClasifico = 1;
    }
    if(YaClasifico == 0 && Ext.getCmp('strAIEPISIGNOPELIGROConvulsiones').getValue() == "SI"){
        YaClasifico = 1;
    }
    if(YaClasifico == 0 && (Ext.getCmp('intAIEPITS_FR').getValue() >= 60 || Ext.getCmp('intAIEPITS_FR').getValue() < 30)){
        YaClasifico = 1;
    }
    if(YaClasifico == 0 && (Ext.getCmp('intAIEPITS_FC').getValue() > 180 || Ext.getCmp('intAIEPITS_FC').getValue() < 100)){
        YaClasifico = 1;
    }
    if(YaClasifico == 0 && (Ext.getCmp('intAIEPISIGNOPELIGRODiuresisNormal').getValue() < 4)){
        YaClasifico = 1;
    }
    if(YaClasifico == 0 && Ext.getCmp('strAIEPISIGNOPELIGROSeMueveSolo').getValue() == "SI"){
        YaClasifico = 1;
    }
    if(YaClasifico == 0 && Ext.getCmp('strAIEPISIGNOPELIGRO_OBSLetargico').getValue() == "SI"){
        YaClasifico = 1;
    }
    if(YaClasifico == 0 && Ext.getCmp('strAIEPISIGNOPELIGRO_OBSSeVeMal').getValue() == "SI"){
        YaClasifico = 1;
    }
    if(YaClasifico == 0 && Ext.getCmp('strAIEPISIGNOPELIGRO_OBSIrritable').getValue() == "SI"){
        YaClasifico = 1;
    }
    if(YaClasifico == 0 && Ext.getCmp('strAIEPISIGNOPELIGRO_OBSPielCianotica').getValue() == "SI"){
        YaClasifico = 1;
    }
    if(YaClasifico == 0 && Ext.getCmp('strAIEPISIGNOPELIGRO_OBSPielPalida').getValue() == "SI"){
        YaClasifico = 1;
    }
    if(YaClasifico == 0 && Ext.getCmp('strAIEPISIGNOPELIGRO_OBSLlenadoCapilar').getValue() == "SI"){
        YaClasifico = 1;
    }
    if(YaClasifico == 0 && Ext.getCmp('strAIEPISIGNOPELIGRO_OBSPresentaIctericia').getValue() == "SI"){
        YaClasifico = 1;
    }
    if(YaClasifico == 0 && (Ext.getCmp('intAIEPITS_Temperatura').getValue() < 35.5 || Ext.getCmp('intAIEPITS_Temperatura').getValue() > 38)){
        YaClasifico = 1;
    }
    if(YaClasifico == 0 && Ext.getCmp('strAIEPISIGNOPELIGRO_OBSFontanelaAbombada').getValue() == "SI"){
        YaClasifico = 1;
    }
    if(YaClasifico == 0 && Ext.getCmp('strAIEPISIGNOPELIGRO_OBSApnea').getValue() == "SI"){
        YaClasifico = 1;
    }
    if(YaClasifico == 0 && Ext.getCmp('strAIEPISIGNOPELIGRO_OBSTirajeSubcostalGrave').getValue() == "SI"){
        YaClasifico = 1;
    }
    if(YaClasifico == 0 && Ext.getCmp('strAIEPISIGNOPELIGRO_OBSAleteoNasal').getValue() == "SI"){
        YaClasifico = 1;
    }
    if(YaClasifico == 0 && Ext.getCmp('strAIEPISIGNOPELIGRO_OBSQuejido').getValue() == "SI"){
        YaClasifico = 1;
    }
    if(YaClasifico == 0 && Ext.getCmp('strAIEPISIGNOPELIGRO_OBSEstridor').getValue() == "SI"){
        YaClasifico = 1;
    }
    if(YaClasifico == 0 && Ext.getCmp('strAIEPISIGNOPELIGRO_OBSSibilancia').getValue() == "SI"){
        YaClasifico = 1;
    }
    if(YaClasifico == 0 && Ext.getCmp('strAIEPISIGNOPELIGRO_OBSSecrecionOido').getValue() == "SI"){
        YaClasifico = 1;
    }
    if(YaClasifico == 0 && Ext.getCmp('strAIEPISIGNOPELIGRO_OBSEdemaPalpebral').getValue() == "SI" && Ext.getCmp('strAIEPISIGNOPELIGRO_OBSSecrecionOjos').getValue() == "SI"){
        YaClasifico = 1;
    }
    if(YaClasifico == 0 && Ext.getCmp('strAIEPISIGNOPELIGRO_OBSEritemaPeriumbilical').getValue() == "SI"){
        YaClasifico = 1;
    }
    if(YaClasifico == 0 && Ext.getCmp('strAIEPISIGNOPELIGRO_OBSPustulasVesiculasPiel').getValue() == "MUCHAS O EXTENSAS"){
        YaClasifico = 1;
    }
    if(YaClasifico == 0 && Ext.getCmp('strAIEPISIGNOPELIGRO_OBSEquimosis').getValue() == "SI"){
        YaClasifico = 1;
    }
    if(YaClasifico == 0 && Ext.getCmp('strAIEPISIGNOPELIGRO_OBSPetequias').getValue() == "SI"){
        YaClasifico = 1;
    }
    if(YaClasifico == 0 && Ext.getCmp('strAIEPISIGNOPELIGRO_OBSHemorragia').getValue() == "SI"){
        YaClasifico = 1;
    }
    if(YaClasifico == 0 && Ext.getCmp('strAIEPISIGNOPELIGRO_OBSSangreHeces').getValue() == "SI"){
        YaClasifico = 1;
    }
    if(YaClasifico == 0 && Ext.getCmp('strAIEPISIGNOPELIGRO_OBSDestensionAbdominal').getValue() == "SI"){
        YaClasifico = 1;
    }
    
    /*
    	VIH positivo(materna o neonatal)
    */
   
    if(YaClasifico == 1){
        Ext.getCmp('sysAIEPISIGNOPELIGROClasifica1').setVisible(true);
        Ext.getCmp('sysAIEPISIGNOPELIGROClasifica2').setVisible(false);
        Ext.getCmp('sysAIEPISIGNOPELIGROClasifica3').setVisible(false);
        Ext.getCmp('strAIEPISIGNOPELIGROClasifica').setValue(HTML_SIGNO_PELIGRO1);
    }else{
        if(YaClasifico == 0 && Ext.getCmp('strAIEPISIGNOPELIGRO_OBSEritemaConjuntival').getValue() == "SI" && Ext.getCmp('strAIEPISIGNOPELIGRO_OBSSecrecionOjos').getValue() == "SI"){
            YaClasifico = 1;
        }
        if(YaClasifico == 0 && Ext.getCmp('strAIEPISIGNOPELIGRO_OBSSecrecionOmbligo').getValue() == "SI" && Ext.getCmp('strAIEPISIGNOPELIGRO_OBSEritemaPeriumbilical').getValue() == "NO"){
            YaClasifico = 1;
        }
        if(YaClasifico == 0 && Ext.getCmp('strAIEPISIGNOPELIGRO_OBSPustulasVesiculasPiel').getValue() == "POCAS Y LOCALIZADAS"){
            YaClasifico = 1;
        }
        if(YaClasifico == 0 && Ext.getCmp('strAIEPISIGNOPELIGRO_OBSPlacasBlanquesinasBoca').getValue() == "SI"){
            YaClasifico = 1;
        }
        if(YaClasifico == 1){
            Ext.getCmp('sysAIEPISIGNOPELIGROClasifica1').setVisible(false);
            Ext.getCmp('sysAIEPISIGNOPELIGROClasifica2').setVisible(true);
            Ext.getCmp('sysAIEPISIGNOPELIGROClasifica3').setVisible(false);
            Ext.getCmp('strAIEPISIGNOPELIGROClasifica').setValue(HTML_SIGNO_PELIGRO2);
        }else{
            Ext.getCmp('sysAIEPISIGNOPELIGROClasifica1').setVisible(false);
            Ext.getCmp('sysAIEPISIGNOPELIGROClasifica2').setVisible(false);
            Ext.getCmp('sysAIEPISIGNOPELIGROClasifica3').setVisible(true);
            Ext.getCmp('strAIEPISIGNOPELIGROClasifica').setValue(HTML_SIGNO_PELIGRO3);
        }
    }
    Ext.getCmp('sysAIEPITS_FR').setValue(Ext.getCmp('intAIEPITS_FR').getValue());
    Ext.getCmp('sysAIEPITS_Temperatura').setValue(Ext.getCmp('intAIEPITS_Temperatura').getValue());
    Ext.getCmp('sysAIEPITS_Peso').setValue(Ext.getCmp('intAIEPITS_Peso').getValue());
}

function ClasificarTieneDiarrea(){
    var YaClasifico = 0;
    var NroSintomas = 0;

    Ext.getCmp('strAIEPIDIARREAClasifica').setValue("NA");
    Ext.getCmp('sysAIEPIDIARREAClasifica1').setVisible(false);
    Ext.getCmp('sysAIEPIDIARREAClasifica2').setVisible(false);
    Ext.getCmp('sysAIEPIDIARREAClasifica3').setVisible(false);
    Ext.getCmp('sysAIEPIDIARREAClasifica4').setVisible(false);
    if(Ext.getCmp('strAIEPIDIARREA_TieneDiarrea').getValue()=="SI"){
        Ext.getCmp('pnAIEPIDIARREA_Clasifica').setVisible(true);
        Ext.getCmp('fsAIEPIDIARREA_Observar').setVisible(true);
        Ext.getCmp('intAIEPIDIARREA_DesdeCuando').setVisible(true);
        Ext.getCmp('strAIEPIDIARREA_SangreHeces').setVisible(true);
        Ext.getCmp('intAIEPIDIARREA_DesdeCuando').allowBlank = false;
        Ext.getCmp('strAIEPIDIARREA_SangreHeces').allowBlank = false;
        Ext.getCmp('strAIEPIDIARREA_OBSLetargicoIncionciente').allowBlank = false;
        Ext.getCmp('strAIEPIDIARREA_OBSIntranquiloIrritable').allowBlank = false;
        Ext.getCmp('strAIEPIDIARREA_OBSOjosHundidos').allowBlank = false;
        Ext.getCmp('strAIEPIDIARREA_OBSSignoPliegue').allowBlank = false;
        
        if(Ext.getCmp('strAIEPIDIARREA_SangreHeces').getValue() == "SI"){
            YaClasifico = 1;
            Ext.getCmp('strAIEPIDIARREAClasifica').setValue(HTML_SIGNO_PRINCIPAL_DIARREA4),
            Ext.getCmp('sysAIEPIDIARREAClasifica1').setVisible(false);
            Ext.getCmp('sysAIEPIDIARREAClasifica2').setVisible(false);
            Ext.getCmp('sysAIEPIDIARREAClasifica3').setVisible(false);
            Ext.getCmp('sysAIEPIDIARREAClasifica4').setVisible(true);
        }else{
            if(Ext.getCmp('intAIEPIDIARREA_DesdeCuando').getValue() >= 7){
                YaClasifico = 1;
                Ext.getCmp('strAIEPIDIARREAClasifica').setValue(HTML_SIGNO_PRINCIPAL_DIARREA3),
                Ext.getCmp('sysAIEPIDIARREAClasifica1').setVisible(false);
                Ext.getCmp('sysAIEPIDIARREAClasifica2').setVisible(false);
                Ext.getCmp('sysAIEPIDIARREAClasifica3').setVisible(true);
                Ext.getCmp('sysAIEPIDIARREAClasifica4').setVisible(false);
            }else{
                if(Ext.getCmp('strAIEPIDIARREA_OBSSignoPliegue').getValue() != "NORMAL"){
                     NroSintomas ++;
                }    
                if(Ext.getCmp('strAIEPIDIARREA_OBSOjosHundidos').getValue() == "SI"){
                     NroSintomas ++;
                }
                if(Ext.getCmp('strAIEPIDIARREA_OBSIntranquiloIrritable').getValue() == "SI"){
                     NroSintomas ++;
                }
                if(Ext.getCmp('strAIEPIDIARREA_OBSLetargicoIncionciente').getValue() == "SI"){
                     NroSintomas ++;
                }
                if(NroSintomas > 1){
                    YaClasifico = 1;
                    Ext.getCmp('strAIEPIDIARREAClasifica').setValue(HTML_SIGNO_PRINCIPAL_DIARREA2),
                    Ext.getCmp('sysAIEPIDIARREAClasifica1').setVisible(true);
                    Ext.getCmp('sysAIEPIDIARREAClasifica2').setVisible(false);
                    Ext.getCmp('sysAIEPIDIARREAClasifica3').setVisible(false);
                    Ext.getCmp('sysAIEPIDIARREAClasifica4').setVisible(false);
                }else{
                    YaClasifico = 1;
                    Ext.getCmp('strAIEPIDIARREAClasifica').setValue(HTML_SIGNO_PRINCIPAL_DIARREA1),
                    Ext.getCmp('sysAIEPIDIARREAClasifica1').setVisible(false);
                    Ext.getCmp('sysAIEPIDIARREAClasifica2').setVisible(true);
                    Ext.getCmp('sysAIEPIDIARREAClasifica3').setVisible(false);
                    Ext.getCmp('sysAIEPIDIARREAClasifica4').setVisible(false);
                }
            }
        }
    }else{
        Ext.getCmp('pnAIEPIDIARREA_Clasifica').setVisible(false);
        Ext.getCmp('fsAIEPIDIARREA_Observar').setVisible(false);
        Ext.getCmp('intAIEPIDIARREA_DesdeCuando').setVisible(false);
        Ext.getCmp('strAIEPIDIARREA_SangreHeces').setVisible(false);
        Ext.getCmp('intAIEPIDIARREA_DesdeCuando').allowBlank = true;
        Ext.getCmp('strAIEPIDIARREA_SangreHeces').allowBlank = true;
        Ext.getCmp('strAIEPIDIARREA_OBSLetargicoIncionciente').allowBlank = true;
        Ext.getCmp('strAIEPIDIARREA_OBSIntranquiloIrritable').allowBlank = true;
        Ext.getCmp('strAIEPIDIARREA_OBSOjosHundidos').allowBlank = true;
        Ext.getCmp('strAIEPIDIARREA_OBSSignoPliegue').allowBlank = true;
        Ext.getCmp('intAIEPIDIARREA_DesdeCuando').setValue(null);
        Ext.getCmp('strAIEPIDIARREA_SangreHeces').setValue(null);
        Ext.getCmp('strAIEPIDIARREA_OBSLetargicoIncionciente').setValue(null);
        Ext.getCmp('strAIEPIDIARREA_OBSIntranquiloIrritable').setValue(null);
        Ext.getCmp('strAIEPIDIARREA_OBSOjosHundidos').setValue(null);
        Ext.getCmp('strAIEPIDIARREA_OBSSignoPliegue').setValue(null);
    }
}

function ClasificarCrecimientoPracticasAlimentacion(){
    var YaClasifico = 0;
    var NroSintomas = 0;
    Ext.getCmp('strAIEPICRECIMIENTOClasifica').setValue("NA");
    Ext.getCmp('sysAIEPICRECIMIENTOClasifica1').setVisible(false);
    Ext.getCmp('sysAIEPICRECIMIENTOClasifica2').setVisible(false);
    Ext.getCmp('sysAIEPICRECIMIENTOClasifica3').setVisible(false);
    Ext.getCmp('sysAIEPICRECIMIENTOClasifica4').setVisible(false);
    Ext.getCmp('sysAIEPICRECIMIENTOClasifica5').setVisible(false);
    Ext.getCmp('sysAIEPICRECIMIENTOClasifica6').setVisible(false);
    if(Ext.getCmp('strAIEPICRECIMIENTO_DificultadAlimentarlo').getValue() == "SI"){
        Ext.getCmp('strAIEPICRECIMIENTO_DificultadAlimentarloCual').allowBlank = false;
        Ext.getCmp('strAIEPICRECIMIENTO_DificultadAlimentarloCual').enable();
        
    }else{
        Ext.getCmp('strAIEPICRECIMIENTO_DificultadAlimentarloCual').allowBlank = true;
        Ext.getCmp('strAIEPICRECIMIENTO_DificultadAlimentarloCual').disable();
        Ext.getCmp('strAIEPICRECIMIENTO_DificultadAlimentarloCual').setValue(null);
    }
    if(Ext.getCmp('strAIEPICRECIMIENTO_HaDejadoComer').getValue() == "SI"){
        Ext.getCmp('intAIEPICRECIMIENTO_HaDejadoComerDesdeCuando').allowBlank = false;
        Ext.getCmp('intAIEPICRECIMIENTO_HaDejadoComerDesdeCuando').enable();
    }else{
        Ext.getCmp('intAIEPICRECIMIENTO_HaDejadoComerDesdeCuando').allowBlank = true;
        Ext.getCmp('intAIEPICRECIMIENTO_HaDejadoComerDesdeCuando').disable();
        Ext.getCmp('intAIEPICRECIMIENTO_HaDejadoComerDesdeCuando').setValue(null);
    }
    if(Ext.getCmp('strAIEPICRECIMIENTO_SeAlimentaLecheMaterna').getValue() == "SI"){
        Ext.getCmp('strAIEPICRECIMIENTO_LecheMaternaExclusiva').allowBlank = false;
        Ext.getCmp('strAIEPICRECIMIENTO_LecheMaternaExclusiva').enable();
        Ext.getCmp('intAIEPICRECIMIENTO_LecheMaternaExclusivaCuantas').allowBlank = false;
        Ext.getCmp('intAIEPICRECIMIENTO_LecheMaternaExclusivaCuantas').enable();
    }else{
        Ext.getCmp('strAIEPICRECIMIENTO_LecheMaternaExclusiva').allowBlank = true;
        Ext.getCmp('intAIEPICRECIMIENTO_LecheMaternaExclusivaCuantas').allowBlank = true;
        Ext.getCmp('strAIEPICRECIMIENTO_LecheMaternaExclusiva').disable();
        Ext.getCmp('strAIEPICRECIMIENTO_LecheMaternaExclusiva').setValue(null);
        Ext.getCmp('intAIEPICRECIMIENTO_LecheMaternaExclusivaCuantas').disable();
        Ext.getCmp('intAIEPICRECIMIENTO_LecheMaternaExclusivaCuantas').setValue(null);
    }
    if(Ext.getCmp('strAIEPICRECIMIENTO_RecibeOtraLeche').getValue() == "SI"){
        Ext.getCmp('strAIEPICRECIMIENTO_RecibeOtraLecheCual').allowBlank = false;
        Ext.getCmp('strAIEPICRECIMIENTO_RecibeOtraLecheCual').enable();
        Ext.getCmp('intAIEPICRECIMIENTO_RecibeOtraLecheFrecuencia').allowBlank = false;
        Ext.getCmp('intAIEPICRECIMIENTO_RecibeOtraLecheFrecuencia').enable();
        Ext.getCmp('strAIEPICRECIMIENTO_RecibeOtraLecheComoPrepara').allowBlank = false;
        Ext.getCmp('strAIEPICRECIMIENTO_RecibeOtraLecheComoPrepara').enable();
    }else{
        Ext.getCmp('strAIEPICRECIMIENTO_RecibeOtraLecheCual').allowBlank = true;
        Ext.getCmp('strAIEPICRECIMIENTO_RecibeOtraLecheCual').disable();
        Ext.getCmp('strAIEPICRECIMIENTO_RecibeOtraLecheCual').setValue(null);
        Ext.getCmp('intAIEPICRECIMIENTO_RecibeOtraLecheFrecuencia').allowBlank = true;
        Ext.getCmp('intAIEPICRECIMIENTO_RecibeOtraLecheFrecuencia').disable();
        Ext.getCmp('intAIEPICRECIMIENTO_RecibeOtraLecheFrecuencia').setValue(null);
        Ext.getCmp('strAIEPICRECIMIENTO_RecibeOtraLecheComoPrepara').allowBlank = true;
        Ext.getCmp('strAIEPICRECIMIENTO_RecibeOtraLecheComoPrepara').disable();
        Ext.getCmp('strAIEPICRECIMIENTO_RecibeOtraLecheComoPrepara').setValue(null);
    }
    if(Ext.getCmp('intAIEPICRECIMIENTO_PesoEdad').getValue() <-3){
        YaClasifico = 1;
    }
    if(YaClasifico == 0 && Ext.getCmp('intAIEPICRECIMIENTO_PesoTalla').getValue() <-3){
        YaClasifico = 1;
    }
    if(YaClasifico == 0 && (Ext.getCmp('intAIEPITS_Peso').getValue()*1000) < 2000){
        YaClasifico = 1;
    }
    if(YaClasifico == 1){
        Ext.getCmp('strAIEPICRECIMIENTOClasifica').setValue(HTML_CRECIMIENTO_ALIMENTA1),
        Ext.getCmp('sysAIEPICRECIMIENTOClasifica1').setVisible(true);
        Ext.getCmp('sysAIEPICRECIMIENTOClasifica2').setVisible(false);
        Ext.getCmp('sysAIEPICRECIMIENTOClasifica3').setVisible(false);
        Ext.getCmp('sysAIEPICRECIMIENTOClasifica4').setVisible(false);
        Ext.getCmp('sysAIEPICRECIMIENTOClasifica5').setVisible(false);
        Ext.getCmp('sysAIEPICRECIMIENTOClasifica6').setVisible(false);
    }else{
        if(Ext.getCmp('strAIEPICRECIMIENTO_TipoSuccion').getValue() == "MALA"){
            YaClasifico = 1;
        }
        if(YaClasifico == 0 && Ext.getCmp('strAIEPICRECIMIENTO_SeObservaMasAreola').getValue() == "NO" && Ext.getCmp('strAIEPICRECIMIENTO_BocaAbierta').getValue() == "NO" && Ext.getCmp('strAIEPICRECIMIENTO_LabioInferiorEvertido').getValue() == "NO" && Ext.getCmp('strAIEPICRECIMIENTO_MentonTocaPecho').getValue() == "NO"){
            YaClasifico = 1;
        }
        if(YaClasifico == 0 && Ext.getCmp('intAIEPICRECIMIENTO_PerdidaPesoMenor7Dias').getValue() >= 10){
            YaClasifico = 1;
        }
        if(YaClasifico == 0 && Ext.getCmp('strAIEPICRECIMIENTO_TendenciaPeso').getValue() == "DESCENDENTE"){
            YaClasifico = 1;
        }
        if(YaClasifico == 1){
            Ext.getCmp('strAIEPICRECIMIENTOClasifica').setValue(HTML_CRECIMIENTO_ALIMENTA2),
            Ext.getCmp('sysAIEPICRECIMIENTOClasifica1').setVisible(false);
            Ext.getCmp('sysAIEPICRECIMIENTOClasifica2').setVisible(true);
            Ext.getCmp('sysAIEPICRECIMIENTOClasifica3').setVisible(false);
            Ext.getCmp('sysAIEPICRECIMIENTOClasifica4').setVisible(false);
            Ext.getCmp('sysAIEPICRECIMIENTOClasifica5').setVisible(false);
            Ext.getCmp('sysAIEPICRECIMIENTOClasifica6').setVisible(false);
        }else{
            if(YaClasifico == 0 && Ext.getCmp('intAIEPICRECIMIENTO_PesoEdad').getValue() >=-3 && Ext.getCmp('intAIEPICRECIMIENTO_PesoEdad').getValue() <-2){
                YaClasifico = 1;
            }
            if(YaClasifico == 0 && Ext.getCmp('intAIEPICRECIMIENTO_PesoTalla').getValue() >=-3 && Ext.getCmp('intAIEPICRECIMIENTO_PesoTalla').getValue() <-2){
                YaClasifico = 1;
            }
            if(YaClasifico == 0 && Ext.getCmp('intAIEPICRECIMIENTO_PesoEdad').getValue() >=-2 && Ext.getCmp('intAIEPICRECIMIENTO_PesoEdad').getValue() <-1){
                YaClasifico = 1;
            }
            if(YaClasifico == 0 && Ext.getCmp('intAIEPICRECIMIENTO_PesoTalla').getValue() >=-2 && Ext.getCmp('intAIEPICRECIMIENTO_PesoTalla').getValue() <-1){
                YaClasifico = 1;
            }
            if(YaClasifico == 1){
                Ext.getCmp('strAIEPICRECIMIENTOClasifica').setValue(HTML_CRECIMIENTO_ALIMENTA3),
                Ext.getCmp('sysAIEPICRECIMIENTOClasifica1').setVisible(false);
                Ext.getCmp('sysAIEPICRECIMIENTOClasifica2').setVisible(false);
                Ext.getCmp('sysAIEPICRECIMIENTOClasifica3').setVisible(true);
                Ext.getCmp('sysAIEPICRECIMIENTOClasifica4').setVisible(false);
                Ext.getCmp('sysAIEPICRECIMIENTOClasifica5').setVisible(false);
                Ext.getCmp('sysAIEPICRECIMIENTOClasifica6').setVisible(false);
            }else{
                if(Ext.getCmp('strAIEPICRECIMIENTO_TendenciaPeso').getValue() == "HORIZONTAL"){
                    YaClasifico = 1;
                }
                if(YaClasifico == 0 && Ext.getCmp('intAIEPICRECIMIENTO_PerdidaPesoMenor7Dias').getValue() < 10){
                    YaClasifico = 1;
                }
                if(YaClasifico == 0 && (Ext.getCmp('strAIEPICRECIMIENTO_SeObservaMasAreola').getValue() == "NO" || Ext.getCmp('strAIEPICRECIMIENTO_BocaAbierta').getValue() == "NO" || Ext.getCmp('strAIEPICRECIMIENTO_LabioInferiorEvertido').getValue() == "NO" || Ext.getCmp('strAIEPICRECIMIENTO_MentonTocaPecho').getValue() == "NO")){
                    YaClasifico = 1;
                }
                if(YaClasifico == 0 && Ext.getCmp('strAIEPICRECIMIENTO_TipoSuccion').getValue() == "DEFICIENTE"){
                    YaClasifico = 1;
                }
                if(YaClasifico == 0 && Ext.getCmp('intAIEPICRECIMIENTO_LecheMaternaExclusivaCuantas').getValue() < 8){
                    YaClasifico = 1;
                }
                if(YaClasifico == 0 && Ext.getCmp('strAIEPICRECIMIENTO_RecibeOtraLeche').getValue() == "SI"){
                    YaClasifico = 1;
                }
                if(YaClasifico == 1){
                    Ext.getCmp('strAIEPICRECIMIENTOClasifica').setValue(HTML_CRECIMIENTO_ALIMENTA4),
                    Ext.getCmp('sysAIEPICRECIMIENTOClasifica1').setVisible(false);
                    Ext.getCmp('sysAIEPICRECIMIENTOClasifica2').setVisible(false);
                    Ext.getCmp('sysAIEPICRECIMIENTOClasifica3').setVisible(false);
                    Ext.getCmp('sysAIEPICRECIMIENTOClasifica4').setVisible(true);
                    Ext.getCmp('sysAIEPICRECIMIENTOClasifica5').setVisible(false);
                    Ext.getCmp('sysAIEPICRECIMIENTOClasifica6').setVisible(false);
                }else{
                    if(Ext.getCmp('strAIEPICRECIMIENTO_TendenciaPeso').getValue() == "ASCENDENTE" && Ext.getCmp('strAIEPICRECIMIENTO_DificultadAlimentarlo').getValue() == "NO" && Ext.getCmp('intAIEPICRECIMIENTO_PesoEdad').getValue() > -1){
                        YaClasifico = 1;
                    }
                    if(YaClasifico == 1){
                        Ext.getCmp('strAIEPICRECIMIENTOClasifica').setValue(HTML_CRECIMIENTO_ALIMENTA5),
                        Ext.getCmp('sysAIEPICRECIMIENTOClasifica1').setVisible(false);
                        Ext.getCmp('sysAIEPICRECIMIENTOClasifica2').setVisible(false);
                        Ext.getCmp('sysAIEPICRECIMIENTOClasifica3').setVisible(false);
                        Ext.getCmp('sysAIEPICRECIMIENTOClasifica4').setVisible(false);
                        Ext.getCmp('sysAIEPICRECIMIENTOClasifica5').setVisible(true);
                        Ext.getCmp('sysAIEPICRECIMIENTOClasifica6').setVisible(false);
                    }else{
                        Ext.getCmp('strAIEPICRECIMIENTOClasifica').setValue(HTML_CRECIMIENTO_ALIMENTA6),
                        Ext.getCmp('sysAIEPICRECIMIENTOClasifica1').setVisible(false);
                        Ext.getCmp('sysAIEPICRECIMIENTOClasifica2').setVisible(false);
                        Ext.getCmp('sysAIEPICRECIMIENTOClasifica3').setVisible(false);
                        Ext.getCmp('sysAIEPICRECIMIENTOClasifica4').setVisible(false);
                        Ext.getCmp('sysAIEPICRECIMIENTOClasifica5').setVisible(false);
                        Ext.getCmp('sysAIEPICRECIMIENTOClasifica6').setVisible(true);
                    }
                }
            }
        }
    }
}

function ClasificarProblemasDesarrollo(){
    var YaClasifico = 0;
    var NroSintomas = 0;
    Ext.getCmp('strAIEPIDESARROLLOClasifica').setValue("NA");
    Ext.getCmp('sysAIEPIDESARROLLOClasifica1').setVisible(false);
    Ext.getCmp('sysAIEPIDESARROLLOClasifica2').setVisible(false);
    Ext.getCmp('sysAIEPIDESARROLLOClasifica3').setVisible(false);

    if(Ext.getCmp('intEdadPacHC').getValue() <= 1){
        Ext.getCmp('strAIEPIDESARROLLO_MENOR1MESReflejoMoro').allowBlank = false;
        Ext.getCmp('strAIEPIDESARROLLO_MENOR1MESReflejoCocleo').allowBlank = false;
        Ext.getCmp('strAIEPIDESARROLLO_MENOR1MESReflejoSuccion').allowBlank = false;
        Ext.getCmp('strAIEPIDESARROLLO_MENOR1MESBrazosPiernasFlexionadas').allowBlank = false;
        Ext.getCmp('strAIEPIDESARROLLO_MENOR1MESManosCerradas').allowBlank = false;
        Ext.getCmp('strAIEPIDESARROLLO_1A2MESESVocaliza').setValue(null);
        Ext.getCmp('strAIEPIDESARROLLO_1A2MESESVocaliza').allowBlank = true;
        Ext.getCmp('strAIEPIDESARROLLO_1A2MESESMovimientoPiernasAlterado').setValue(null);
        Ext.getCmp('strAIEPIDESARROLLO_1A2MESESMovimientoPiernasAlterado').allowBlank = true;
        Ext.getCmp('strAIEPIDESARROLLO_1A2MESESSonrisaSocial').setValue(null);
        Ext.getCmp('strAIEPIDESARROLLO_1A2MESESSonrisaSocial').allowBlank = true;
        Ext.getCmp('strAIEPIDESARROLLO_1A2MESESSigueObjetosLineaMedia').setValue(null);
        Ext.getCmp('strAIEPIDESARROLLO_1A2MESESSigueObjetosLineaMedia').allowBlank = true;
        if(Ext.getCmp('strAIEPIDESARROLLO_MENOR1MESReflejoMoro').getValue() == "NO"){
            NroSintomas = 1;
        }
        if(Ext.getCmp('strAIEPIDESARROLLO_MENOR1MESReflejoCocleo').getValue() == "NO"){
            NroSintomas = 1;
        }
        if(Ext.getCmp('strAIEPIDESARROLLO_MENOR1MESReflejoSuccion').getValue() == "NO"){
            NroSintomas = 1;
        }
        if(Ext.getCmp('strAIEPIDESARROLLO_MENOR1MESBrazosPiernasFlexionadas').getValue() == "NO"){
            NroSintomas = 1;
        }
        if(Ext.getCmp('strAIEPIDESARROLLO_MENOR1MESManosCerradas').getValue() == "NO"){
            NroSintomas = 1;
        }
    }else{
        Ext.getCmp('strAIEPIDESARROLLO_MENOR1MESReflejoMoro').setValue(null);
        Ext.getCmp('strAIEPIDESARROLLO_MENOR1MESReflejoMoro').allowBlank = true;
        Ext.getCmp('strAIEPIDESARROLLO_MENOR1MESReflejoCocleo').setValue(null);
        Ext.getCmp('strAIEPIDESARROLLO_MENOR1MESReflejoCocleo').allowBlank = true;
        Ext.getCmp('strAIEPIDESARROLLO_MENOR1MESReflejoSuccion').setValue(null);
        Ext.getCmp('strAIEPIDESARROLLO_MENOR1MESReflejoSuccion').allowBlank = true;
        Ext.getCmp('strAIEPIDESARROLLO_MENOR1MESBrazosPiernasFlexionadas').setValue(null);
        Ext.getCmp('strAIEPIDESARROLLO_MENOR1MESBrazosPiernasFlexionadas').allowBlank = true;
        Ext.getCmp('strAIEPIDESARROLLO_MENOR1MESManosCerradas').setValue(null);
        Ext.getCmp('strAIEPIDESARROLLO_MENOR1MESManosCerradas').allowBlank = true;
        Ext.getCmp('strAIEPIDESARROLLO_1A2MESESVocaliza').allowBlank = false;
        Ext.getCmp('strAIEPIDESARROLLO_1A2MESESMovimientoPiernasAlterado').allowBlank = false;
        Ext.getCmp('strAIEPIDESARROLLO_1A2MESESSonrisaSocial').allowBlank = false;
        Ext.getCmp('strAIEPIDESARROLLO_1A2MESESSigueObjetosLineaMedia').allowBlank = false;
        if(Ext.getCmp('strAIEPIDESARROLLO_1A2MESESVocaliza').getValue() == "NO"){
            NroSintomas = 1;
        }
        if(Ext.getCmp('strAIEPIDESARROLLO_1A2MESESMovimientoPiernasAlterado').getValue() == "NO"){
            NroSintomas = 1;
        }
        if(Ext.getCmp('strAIEPIDESARROLLO_1A2MESESSonrisaSocial').getValue() == "NO"){
            NroSintomas = 1;
        }
        if(Ext.getCmp('strAIEPIDESARROLLO_1A2MESESSigueObjetosLineaMedia').getValue() == "NO"){
            NroSintomas = 1;
        }
    }
    if(Ext.getCmp('intAIEPITS_PC').getValue() < -2 && Ext.getCmp('intAIEPITS_PC').getValue() > 2){
        NroSintomas = 1;
    }
    if(Ext.getCmp('strAIEPIDESARROLLO_AlteracionesFonotipicas').getValue() == "SI"){
        NroSintomas = 1;
    }
    if(NroSintomas == 1){
        YaClasifico = 1;
        Ext.getCmp('strAIEPIDESARROLLOClasifica').setValue(HTML_DESARROLLO1),
        Ext.getCmp('sysAIEPIDESARROLLOClasifica1').setVisible(true);
        Ext.getCmp('sysAIEPIDESARROLLOClasifica2').setVisible(false);
        Ext.getCmp('sysAIEPIDESARROLLOClasifica3').setVisible(false);
    }else{
        if(Ext.getCmp('strAIEPIDESARROLLO_FactoresRiesgo').getValue() == "SI"){
            YaClasifico = 1;
            Ext.getCmp('strAIEPIDESARROLLOClasifica').setValue(HTML_DESARROLLO2),
            Ext.getCmp('sysAIEPIDESARROLLOClasifica1').setVisible(false);
            Ext.getCmp('sysAIEPIDESARROLLOClasifica2').setVisible(true);
            Ext.getCmp('sysAIEPIDESARROLLOClasifica3').setVisible(false);

        }else{
            YaClasifico = 1;
            Ext.getCmp('strAIEPIDESARROLLOClasifica').setValue(HTML_DESARROLLO3),
            Ext.getCmp('sysAIEPIDESARROLLOClasifica1').setVisible(false);
            Ext.getCmp('sysAIEPIDESARROLLOClasifica2').setVisible(false);
            Ext.getCmp('sysAIEPIDESARROLLOClasifica3').setVisible(true);
        }
    }
}