/*
* @category    Fieldset Asignar Proxima Cita con el Mismo Profesional
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


fsAsignarProximaCita001Ui = Ext.extend(Ext.form.FieldSet, {
    anchor: '100%',
    autoHeight: true,
    layout: 'form',
    title: 'Asignar Proxima Cita',
    collapseFirst: false,
    collapsible: false,
    animCollapse: false,
    titleCollapse: false,
    padding: 0,
    id: 'fsAsignarProximaCita001',
    initComponent: function() {
        
        var stGridAgendasDisponiblesCitas = new StoreGridAgendasDisponiblesCitas();
        var stGridHoarariosxAgendaDisponiblesCitas = new StoreGridHoarariosxAgendaDisponiblesCitas();
        
        ID_PROFESIONAL_SELECCIONADO = 0;
        NOM_PROFESIONAL_SELECCIONADO = "";
        ID_CONSULTORIO_SELECCIONADO = 0;
        NOM_CONSULTORIO_SELECCIONADO = "";
        CODBLOQUEOAGENDA = "";
        FECHA_SELECCIONADA = "";
        AGENDA_SELECCIONADA = 0;
                                                    
        function renderFechaAgenda(value, p, record){
            return String.format(
                value + ' - ' + FormatoFechaLarga(value),
                value);
        }
        
        function renderCitaObservacionesPlantilla(value, p, record){
            return String.format(
                '<table border="0"><tr><td><b>{0}</b></td></tr><tr><td>{1}</td></tr></table>',
                value, record.data.citaObservacionesPlantilla);
        }
        
        var xg = Ext.grid;
               
        var chkColumnSeleccionarHorario = new xg.CheckColumn({
           header: ' ',
           dataIndex: 'Seleccionar',
           id: 'chkColumnSeleccionarHorario',
           value: false,
           width: 10
        });
        
        var strcitaInfoAdd = new Ext.form.TextField();
        
        var dataNoAsignar = [
            ['NO HAY AGENDA DISPONIBLE PARA EL PROFESIONAL'],
            ['PACIENTE QUE FINALIZA ATENCION POR EL PROGRAMA'],
            ['PACIENTE VALORADO Y REMITIDO A URGENCIAS']
        ];
        var stNoAsignar = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stNoAsignar.loadData(dataNoAsignar);   
        
        this.items = [
            {
                html: '<br><br>'
            },
            {
                xtype: 'form',
                frame: true,
                anchor: '98%',
                id: 'frmProximaCita',
                border: false,
                autoScroll: true,
                labelWidth: 270, 
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'hidden',
                        id: 'sysClienteProxCita'
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysPlanProxCita'
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysSubPlanProxCita'
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysNomClienteProxCita'
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysNomPlanProxCita'
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysNomSubPlanProxCita'
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysContratoProxCita'
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysIdConceptoProxCita'
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysCodConceptoProxCita'
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysNomConceptoProxCita'
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysTarConceptoProxCita'
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysProfesionalProxCita'
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysUbicacionProxCita'
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysNomUbicacionProxCita'
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysTipoAfiliacionProxCita'
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysTipoAfiliadoProxCita'
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysParentescoProxCita'
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysRangoSalarialProxCita'
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysEstadoListadoProxCita'
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysEdadPacProxCita'
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysDeptoMuniProxCita'
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysProgramaProxCita'
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysFinalidadProxCita'
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysFacturarParticularProxCita'
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysFacturarCopagosProxCita'
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysCopagoDigitadoProxCita'
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysPorCopagosProxCita'
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysMaxCopagoProxCita'
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysvlrCuotaModeradoraIndicadaProxCita'
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysExentoProxCita'
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysTutelaProxCita'
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysProfeSolProxCita'
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysProfeSolProxCita'
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysMarcaExentoProxCita'
                    },
                    {
                        xtype: 'combo',
                        width: 70,
                        fieldLabel: 'Va a Realizar la Asignacion de la Proxima Cita?',
                        name: 'Va a Realizar la Asignacion de la Proxima Cita?',
                        allowBlank: false,
                        store: 'StoreSiNo',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        value: "SI",
                        id: 'sysAsignarProximaCita',
                        listeners:{
                            select : function(cmb, rec, idx){
                                if(cmb.getValue() === "SI"){
                                    Ext.getCmp('gridDiasAgendaCitas').store.load();
                                    Ext.getCmp('gridHorariosAgendasCitas').store.load();
                                    Ext.Ajax.request({
                                        waitMsg: 'Por favor Espere...',
                                        url: '../../controlador/agendas/controlador_asignarcitas.php',
                                        params:{
                                            task: "AGENDAS_DESBLOQUEAR",
                                            pUsuario: ID_USUARIO,
                                            pIPS: ID_IPS
                                        },
                                        scope:this
                                    });
                                    Ext.getCmp('fsNoAsignaCita').setVisible(false); 
                                    Ext.getCmp('gridDiasAgendaCitas').setVisible(true); 
                                    Ext.getCmp('gridHorariosAgendasCitas').setVisible(true); 
                                    Ext.getCmp('sysMotivoNoAsignaCita').setVisible(false);
                                    Ext.getCmp('sysMotivoNoAsignaCita').clearInvalid();
                                    Ext.getCmp('sysMotivoNoAsignaCita').allowBlank = true;
                                    Ext.getCmp('sysMotivoNoAsignaCita').setValue(null);
                                }else{
                                    Ext.getCmp('fsNoAsignaCita').setVisible(true); 
                                    Ext.getCmp('sysMotivoNoAsignaCita').setVisible(true); 
                                    Ext.getCmp('gridDiasAgendaCitas').setVisible(false); 
                                    Ext.getCmp('gridHorariosAgendasCitas').setVisible(false); 
                                    Ext.getCmp('sysMotivoNoAsignaCita').setVisible(true);
                                    Ext.getCmp('sysMotivoNoAsignaCita').allowBlank = false;
                                }
                            }
                        }
                    },
                    {
                        xtype: 'fieldset',
                        title: 'Motivo No Asignacion Proxima Cita',
                        layout: 'table',
                        collapsible: true,
                        titleCollapse: true,
                        anchor: '98%',
                        autoHeight: true,
                        padding: 5,
                        id: 'fsNoAsignaCita',
                        tbar: [
                            {
                                xtype: 'button',
                                text: 'No Asignar Cita',
                                iconCls: 'btnAsignarCita',
                                id: 'btnNoAsignarCita',
                                listeners: {
                                    click: function(){
                                        if(parseInt(Ext.getCmp('sysYaGuardoHC').getValue()) === 1){
                                            if(parseInt(Ext.getCmp('sysYaAsignoCitaHC').getValue()) === 0){
                                                if(Ext.getCmp('sysMotivoNoAsignaCita').getValue() !== "" && Ext.getCmp('sysMotivoNoAsignaCita').getValue() !== null){
                                                    Ext.Msg.show({
                                                        title: 'eOfiClinic',
                                                        msg: 'Esta seguro que desea NO asignar la cita?',
                                                        buttons: Ext.Msg.YESNO,
                                                        icon: Ext.Msg.QUESTION,
                                                        fn: function(btn){
                                                            if(btn=="yes"){
                                                                Ext.Ajax.request({
                                                                    waitMsg: 'Por favor Espere...',
                                                                    url: "../../controlador/asistencial/ipsbasica/evolucionhc201601.php",
                                                                    params: {
                                                                        task: "NO_ASIGNAR_CITAS",
                                                                        pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue(),
                                                                        pMotivoNoCita: Ext.getCmp('sysMotivoNoAsignaCita').getValue()
                                                                    },
                                                                    success: function(response){
                                                                        var result = response.responseText;
                                                                        if (result > 0){
                                                                            Ext.MessageBox.show({
                                                                                title: 'OfiClinic',
                                                                                msg: 'Se marco la No Asignacion de la proxima cita, ya puede cerrar la evolucion',
                                                                                buttons: Ext.MessageBox.OK,
                                                                                icon: Ext.MessageBox.INFO
                                                                            });
                                                                            Ext.getCmp('sysYaAsignoCitaHC').setValue(1);
                                                                        }else{
                                                                            Ext.MessageBox.show({
                                                                                title: 'Error',
                                                                                msg: 'ERROR DE COMUNICACION, La Cita quedo mal asignada por favor limpie el formulario y vuelva a intentarlo.',
                                                                                buttons: Ext.MessageBox.OK,
                                                                                icon: Ext.MessageBox.ERROR
                                                                            });
                                                                        }
                                                                    },
                                                                    failure: function(response){
                                                                        var result = response.responseText;
                                                                        Ext.MessageBox.show({
                                                                            title: 'Error Base Datos',
                                                                            msg: 'No podemos asignar las citas en estos momentos',
                                                                            buttons: Ext.MessageBox.OK,
                                                                            icon: Ext.MessageBox.ERROR
                                                                        });
                                                                    }
                                                                });
                                                            }
                                                        }
                                                    });
                                                }else{
                                                    Ext.MessageBox.show({
                                                        title: 'NO Asignar Proxima Cita',
                                                        msg: 'El campo de motivo de no asignacion de la cita es requerido.',
                                                        buttons: Ext.MessageBox.OK,
                                                        icon: Ext.MessageBox.ERROR
                                                    });
                                                }
                                            }else{
                                                Ext.MessageBox.show({
                                                    title: 'Asignar Proxima Cita',
                                                    msg: 'Ya se realizo la asignacion de la cita y no se puede repetir este proceso.',
                                                    buttons: Ext.MessageBox.OK,
                                                    icon: Ext.MessageBox.ERROR
                                                }); 
                                            }
                                        }else{
                                            Ext.MessageBox.show({
                                                title: 'Asignar Proxima Cita',
                                                msg: 'Debe guardar primero la evolucion de la historia clinica.',
                                                buttons: Ext.MessageBox.OK,
                                                icon: Ext.MessageBox.ERROR
                                            });
                                        }
                                    }
                                }
                            }
                        ],
                        items: [
                            {
                                xtype: 'combo',
                                width: 870,
                                fieldLabel: 'Motivo No Asignacion?',
                                name: 'Motivo No Asignacion?',
                                allowBlank: true,
                                visible: false,
                                store: stNoAsignar,
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'sysMotivoNoAsignaCita'
                            }
                        ]
                    }
                ]
            },
            {
                xtype: 'container',
                width: 965,
                height: 550,
                layout: 'border',
                items: [
                    {
                        xtype: 'panel',
                        region: 'west',
                        border: true,
                        width: 390,
                        height: 180,
                        items:[
                            {
                                xtype: 'grid',
                                id: 'gridDiasAgendaCitas',
                                store: stGridAgendasDisponiblesCitas,
                                anchor: "100%",
                                height: 250,
                                border: false,
                                frame: true,
                                loadMask: true,
                                title: 'Agendas Programadas',
                                stripeRows: true,
                                listeners: {
                                    rowclick: function(grid, fila, e){
                                        var selections = grid.selModel.getSelections();
                                        FECHA_SELECCIONADA = selections[0].json.agendaFecha;
                                        AGENDA_SELECCIONADA = selections[0].json.agendaID;
                                        Ext.getCmp('gridHorariosAgendasCitas').store.load({
                                           params: {
                                               pAgenda: selections[0].json.agendaID,
                                               pCodBloqueo: CODBLOQUEOAGENDA,
                                               pUsuario: ID_USUARIO,
                                               pNroHoras: 1
                                           },
                                           callback: function(){
                                                Ext.getCmp('gridHorariosAgendasCitas').store.filterBy(function(record,id){
                                                    return record.get('MostrarGrupoCita') == true;
                                                });
                                            }
                                       });
                                    }
                                },
                                columns: [
                                    {
                                        header: 'agendaID',
                                        readOnly: true,
                                        sortable: false,
                                        dataIndex: 'agendaID',
                                        width: 1,
                                        hidden: true,
                                        hideable: false
                                    },
                                    {
                                        header: 'Fecha Disponible',
                                        readOnly: true,
                                        sortable: true,
                                        dataIndex: 'agendaFecha',
                                        renderer: renderFechaAgenda,
                                        width: 270
                                    },
                                    {
                                        header: 'Citas Disponibles',
                                        readOnly: true,
                                        sortable: true,
                                        dataIndex: 'Disponibles'
                                    }
                                ],
                                selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                                iconCls:'icon-fechas',
                                viewConfig: {
                                    forceFit:true
                                },
                                columnLines: true,
                                bbar:{
                                    items: [
                                        {
                                            xtype: 'button',
                                            iconCls: 'btnActualizarGrid',
                                            text: 'Actualizar',
                                            tooltip: 'Actualizar Agenda',
                                            id: 'btnActualizarAgenda',
                                            listeners: {
                                                click: function(){
                                                    //Ext.getCmp('gridDiasAgendaCitas').store.load();
                                                    Ext.getCmp('gridDiasAgendaCitas').store.load({
                                                        params: {
                                                            pIPS: ID_IPS,
                                                            pProfesional: ID_PROFESIONAL_SELECCIONADO,
                                                            pConsultorio: ID_CONSULTORIO_SELECCIONADO,
                                                            pCodBloqueo: CODBLOQUEOAGENDA
                                                        }
                                                    });
                                                    Ext.getCmp('gridHorariosAgendasCitas').store.load();
                                                }
                                            }
                                        },
                                        '->',
                                        {
                                            xtype: 'button',
                                            iconCls: 'btnAgendasBloqueada',
                                            text: 'Ver Agendas Bloqueadas',
                                            tooltip: 'Verificar las Agendas Bloqueadas por Usuario',
                                            id: 'btnVarAgendaBloqueada_citas',
                                            listeners: {
                                                click: function(){
                                                    var winAgendaBloquadaxProfe = new winAgendaBloquadaxProfeUi();
                                                    Ext.getCmp('gridAgendasBloqueadas').store.load({
                                                        params: {
                                                            pIPS: ID_IPS,
                                                            pProfesional: ID_PROFESIONAL_SELECCIONADO,
                                                            pConsultorio: ID_CONSULTORIO_SELECCIONADO
                                                        }
                                                    });
                                                    Ext.getCmp('nomProfesionalAgenda').setValue(NOM_PROFESIONAL_SELECCIONADO);
                                                    Ext.getCmp('nomConsultorioAgenda').setValue(NOM_CONSULTORIO_SELECCIONADO);
                                                    winAgendaBloquadaxProfe.show();
                                                }
                                            }
                                        }
                                    ]
                                }
                            }
                        ]
                    },
                    {
                        xtype: 'panel',
                        region: 'center',
                        border: true,
                        width: 551,
                        height: 300,
                        items:[
                            {
                                xtype: 'editorgrid',
                                id: 'gridHorariosAgendasCitas',
                                store: stGridHoarariosxAgendaDisponiblesCitas,
                                anchor: "100%",
                                height: 250,
                                border: false,
                                frame: true,
                                loadMask: true,
                                stripeRows: true,
                                clicksToEdit: 1,
                                title: 'Horarios Disponibles por Agenda',
                                cm: new xg.ColumnModel([
                                    chkColumnSeleccionarHorario,
                                    {
                                        header: 'Codigo',
                                        readOnly: true,
                                        sortable: false,
                                        dataIndex: 'citaID',
                                        width: 1,
                                        hidden: true,
                                        hideable: false
                                    },
                                    {
                                        header: 'Descripción del Horario',
                                        readOnly: true,
                                        sortable: false,
                                        dataIndex: 'citaDescripcion',
                                        renderer: renderCitaObservacionesPlantilla,
                                        width: 200
                                    },
                                    {
                                        header: 'Información Adicional de la Cita',
                                        readOnly: false,
                                        sortable: false,
                                        dataIndex: 'citaInfoAdd',
                                        editor: strcitaInfoAdd,
                                        width: 200
                                    }
                                ]),
                                plugins: [chkColumnSeleccionarHorario],
                                selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                                iconCls:'icon-horarios',
                                viewConfig: {
                                    forceFit:true
                                },
                                columnLines: true,
                                tbar:{
                                    items: [
                                        {
                                            html:'<b style="color: #ff3333;">A Solicitud del Usuario:</b>&nbsp;&nbsp;&nbsp;',
                                            border: false
                                        },
                                        {
                                            xtype: 'checkbox',
                                            anchor: '100%',
                                            value: 'true',
                                            id: 'bolAsignaCitasSolicitudUsuario'
                                        },
                                        {
                                            xtype: 'hidden',
                                            id: 'bolMarcaExento'
                                        },
                                        {
                                            xtype: 'tbfill'
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Asignar Cita',
                                            iconCls: 'btnAsignarCita',
                                            id: 'btnCitasAsignarCita',
                                            listeners: {
                                                click: function(){
                                                    var parametrosCitasSeleccionadas = "";
                                                    var SolicitudUsuaio = (Ext.getCmp('bolAsignaCitasSolicitudUsuario').getValue()==true)?'1':'0';
                                                    var grupoCita = 0;
                                                    if(parseInt(Ext.getCmp('sysYaGuardoHC').getValue()) === 1){
                                                        if(parseInt(Ext.getCmp('sysYaAsignoCitaHC').getValue()) === 0){
                                                            Ext.Msg.show({
                                                                title: 'eOfiClinic',
                                                                msg: 'Esta seguro que desea asignar la cita?',
                                                                buttons: Ext.Msg.YESNO,
                                                                icon: Ext.Msg.QUESTION,
                                                                fn: function(btn){
                                                                    if(btn=="yes"){
                                                                        var citasseleccionadas = false;
                                                                        Ext.getCmp('gridHorariosAgendasCitas').store.filterBy(function(record,id){
                                                                            return record.get('Seleccionar') == true;
                                                                        });
                                                                        Ext.getCmp('gridHorariosAgendasCitas').store.each(function(record){
                                                                            grupoCita = record.get('GrupoCita');
                                                                        });
                                                                        Ext.getCmp('gridHorariosAgendasCitas').store.clearFilter();
                                                                        if(grupoCita != 0){
                                                                            Ext.getCmp('gridHorariosAgendasCitas').store.filterBy(function(record,id){
                                                                                return record.get('GrupoCita') == grupoCita;
                                                                            });
                                                                            Ext.getCmp('gridHorariosAgendasCitas').store.each(function(record){
                                                                                citasseleccionadas = true;
                                                                                parametrosCitasSeleccionadas = parametrosCitasSeleccionadas + record.get('citaID') + "^" + record.get('citaInfoAdd') + "^" + record.get('TipoHorario') + "¬";
                                                                            });
                                                                        }
                                                                        if (citasseleccionadas == false){
                                                                            Ext.MessageBox.show({
                                                                                title: 'Error',
                                                                                msg: 'Debe seleccionar al menos una cita para poder realizar la asignación',
                                                                                buttons: Ext.MessageBox.OK,
                                                                                icon: Ext.MessageBox.ERROR
                                                                            });
                                                                        }else{
                                                                            var citasseleccionadas = false;
                                                                            Ext.getCmp('gridHorariosAgendasCitas').store.filterBy(function(record,id){
                                                                                return record.get('Seleccionar') == true;
                                                                            });
                                                                            Ext.getCmp('gridHorariosAgendasCitas').store.each(function(record){
                                                                                grupoCita = record.get('GrupoCita');
                                                                            });
                                                                            Ext.getCmp('gridHorariosAgendasCitas').store.clearFilter();
                                                                            if(grupoCita != 0){
                                                                                Ext.getCmp('gridHorariosAgendasCitas').store.filterBy(function(record,id){
                                                                                    return record.get('GrupoCita') == grupoCita;
                                                                                });
                                                                                Ext.getCmp('gridHorariosAgendasCitas').store.each(function(record){
                                                                                    citasseleccionadas = true;
                                                                                    parametrosCitasSeleccionadas = parametrosCitasSeleccionadas + record.get('citaID') + "^" + record.get('citaInfoAdd') + "^" + record.get('TipoHorario') + "¬";
                                                                                });
                                                                            }
                                                                            if (citasseleccionadas == false){
                                                                                Ext.MessageBox.show({
                                                                                    title: 'Error',
                                                                                    msg: 'Debe seleccionar al menos una cita para poder realizar la asignación',
                                                                                    buttons: Ext.MessageBox.OK,
                                                                                    icon: Ext.MessageBox.ERROR
                                                                                });
                                                                            }else{
                                                                                Ext.Ajax.request({
                                                                                    waitMsg: 'Por favor Espere...',
                                                                                    url: "../../controlador/agendas/controlador_asignarcitas.php",
                                                                                    params: {
                                                                                        task: "ASIGNAR_CITAS",
                                                                                        pEmpresa: ID_EMPRESA,
                                                                                        pSede: ID_SEDE, 
                                                                                        pIPS: ID_IPS, 
                                                                                        pConsultorio: ID_CONSULTORIO_SELECCIONADO,
                                                                                        pProfesionalCita: ID_PROFESIONAL_SELECCIONADO,
                                                                                        pUsuario: ID_USUARIO,
                                                                                        pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                                                                                        pIdProced: Ext.getCmp('sysIdConceptoProxCita').getValue(),
                                                                                        pCodProced: Ext.getCmp('sysCodConceptoProxCita').getValue(),
                                                                                        pDesProced: QuitarAcentosTxtMayusculas(Ext.getCmp('sysNomConceptoProxCita').getValue()),
                                                                                        pTarifaProced: Ext.getCmp('sysTarConceptoProxCita').getValue(),
                                                                                        pCodCliente: Ext.getCmp('sysClienteProxCita').getValue(),
                                                                                        pDesCliente: QuitarAcentosTxtMayusculas(Ext.getCmp('sysNomClienteProxCita').getValue()),
                                                                                        pCodPlan: Ext.getCmp('sysPlanProxCita').getValue(),
                                                                                        pDesPlan: QuitarAcentosTxtMayusculas(Ext.getCmp('sysNomPlanProxCita').getValue()),
                                                                                        pCodSubPlan: Ext.getCmp('sysSubPlanProxCita').getValue(),
                                                                                        pDesSubPlan: QuitarAcentosTxtMayusculas(Ext.getCmp('sysNomSubPlanProxCita').getValue()),
                                                                                        pContrato: Ext.getCmp('sysContratoProxCita').getValue(),
                                                                                        pUsuarioAsigna: ID_USUARIO,
                                                                                        pObservaciones: QuitarAcentosTxtMayusculas(Ext.getCmp('strObservacionesCita').getValue()),
                                                                                        pSolicitudUsuario: SolicitudUsuaio,
                                                                                        pFechaCita: FECHA_SELECCIONADA,
                                                                                        pTipoAfiliacion: Ext.getCmp('sysTipoAfiliacionProxCita').getValue(),
                                                                                        pTipoAfiliado: Ext.getCmp('sysTipoAfiliadoProxCita').getValue(),
                                                                                        pParentesco: Ext.getCmp('sysParentescoProxCita').getValue(),
                                                                                        pRangoSalarial: Ext.getCmp('sysRangoSalarialProxCita').getValue(),
                                                                                        pEstadoListado: Ext.getCmp('sysEstadoListadoProxCita').getValue(),
                                                                                        pEdadPaciente: QuitarAcentosTxtMayusculas(Ext.getCmp('sysEdadPacProxCita').getValue()),
                                                                                        pDeptoMuniciPaciente: Ext.getCmp('sysDeptoMuniProxCita').getValue(),
                                                                                        pPrograma: Ext.getCmp('sysProgramaProxCita').getValue(),
                                                                                        pFinalidad: Ext.getCmp('sysFinalidadProxCita').getValue(),
                                                                                        pFacturarParticular: Ext.getCmp('sysFacturarParticularProxCita').getValue(),
                                                                                        pFacturarCopagos: Ext.getCmp('sysFacturarCopagosProxCita').getValue(),
                                                                                        pCopagoDigitado: Ext.getCmp('sysCopagoDigitadoProxCita').getValue(),
                                                                                        pPorCopagos: Ext.getCmp('sysPorCopagosProxCita').getValue(),
                                                                                        pMaxCopago: Ext.getCmp('sysMaxCopagoProxCita').getValue(),
                                                                                        pvlrCuotaModeradoraIndicada: Ext.getCmp('sysvlrCuotaModeradoraIndicadaProxCita').getValue(),
                                                                                        pExento: Ext.getCmp('sysExentoProxCita').getValue(),
                                                                                        pTutela: Ext.getCmp('sysTutelaProxCita').getValue(),
                                                                                        pProfeSol: Ext.getCmp('sysProfeSolProxCita').getValue(),
                                                                                        pAutorizacion: null,
                                                                                        pFechaSol: Ext.getCmp('sysProfeSolProxCita').getValue(),
                                                                                        pMarcaExento: Ext.getCmp('sysMarcaExentoProxCita').getValue(),
                                                                                        pInfoCita: parametrosCitasSeleccionadas
                                                                                    },
                                                                                    success: function(response){
                                                                                        var result = response.responseText;
                                                                                        if (result > 0){
                                                                                            Ext.getCmp('gridDiasAgendaCitas').store.load();
                                                                                            Ext.getCmp('gridHorariosAgendasCitas').store.load();
                                                                                            Ext.Ajax.request({
                                                                                                waitMsg: 'Por favor Espere...',
                                                                                                url: '../../controlador/agendas/controlador_asignarcitas.php',
                                                                                                params:{
                                                                                                    task: "AGENDAS_DESBLOQUEAR",
                                                                                                    pUsuario: ID_USUARIO,
                                                                                                    pIPS: ID_IPS
                                                                                                },
                                                                                                scope:this
                                                                                            });
                                                                                            var html = '<table><tr><td width="50"><img src="../../../resources/varios/citas.png" alt=""/></td><td width="10">&nbsp</td><td style="padding 10px;"><h1 style="color: #2E2EFE; font-size: 14px;">Asignación de Citas:</h1><br/><p style="color: #003333;font-weight: bold;">Se Asigno la Cita Nro. ' + result  + '</p></br>';
                                                                                            html += '<br/><p style="color: #003333;font-weight: bold;">Profesional: ' + NOM_PROFESIONAL_SELECCIONADO +'</p>';
                                                                                            html += '<p style="color: #003333;font-weight: bold;">Ubicación: ' + NOM_CONSULTORIO_SELECCIONADO +'</p>';
                                                                                            html += '<p style="color: #003333;font-weight: bold;">Fecha: ' + FECHA_SELECCIONADA +'</p>';
                                                                                            html += '</td><td width="70">&nbsp</td></tr></table>';
                                                                                            Ext.Ajax.request({
                                                                                                waitMsg: 'Por favor Espere...',
                                                                                                url: "../../controlador/asistencial/ipsbasica/evolucionhc201601.php",
                                                                                                params: {
                                                                                                    task: "MARCAR_ASIGNAR_CITAS",
                                                                                                    pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue()
                                                                                                }
                                                                                            });
                                                                                            Sexy.info(html);
                                                                                            Ext.getCmp('sysYaAsignoCitaHC').setValue(1);
                                                                                        }else{
                                                                                            Ext.MessageBox.show({
                                                                                                title: 'Error',
                                                                                                msg: 'ERROR DE COMUNICACION, La Cita quedo mal asignada por favor limpie el formulario y vuelva a intentarlo.',
                                                                                                buttons: Ext.MessageBox.OK,
                                                                                                icon: Ext.MessageBox.ERROR
                                                                                            });
                                                                                        }
                                                                                    },
                                                                                    failure: function(response){
                                                                                        var result = response.responseText;
                                                                                        Ext.MessageBox.show({
                                                                                            title: 'Error Base Datos',
                                                                                            msg: 'No podemos asignar las citas en estos momentos',
                                                                                            buttons: Ext.MessageBox.OK,
                                                                                            icon: Ext.MessageBox.ERROR
                                                                                        });
                                                                                    }
                                                                                });
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            });
                                                        }else{
                                                            Ext.MessageBox.show({
                                                                title: 'Asignar Proxima Cita',
                                                                msg: 'Ya se realizo la asignacion de la cita y no se puede repetir este proceso.',
                                                                buttons: Ext.MessageBox.OK,
                                                                icon: Ext.MessageBox.ERROR
                                                            }); 
                                                        }
                                                    }else{
                                                        Ext.MessageBox.show({
                                                            title: 'Asignar Proxima Cita',
                                                            msg: 'Debe guardar primero la evolucion de la historia clinica.',
                                                            buttons: Ext.MessageBox.OK,
                                                            icon: Ext.MessageBox.ERROR
                                                        });
                                                    }
                                                }
                                            }
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        }
                                    ]
                                },
                                bbar:{
                                    items: [
                                        {
                                            html:'Observaciones:&nbsp;&nbsp;&nbsp;',
                                            border: false
                                        },
                                        {
                                            xtype: 'textfield',
                                            width: 435,
                                            maxLength: 150,
                                            allowBlank: true,
                                            emptyText: 'Observaciones',
                                            id: 'strObservacionesCita'
                                        }
                                    ]
                                }
                            }
                        ]
                    }
                ]
            }
        ];
        this.on({
            afterlayout:{scope:this, single:true, fn:function() {
                Ext.Msg.hide();
                var frm = Ext.getCmp('frmProximaCita').getForm();
                frm.doAction('load', {
                    url: '../../controlador/asistencial/asignar_proximacita.php',
                    waitMsg: 'Cargando Información...',
                    params:{
                        pCAS: Ext.getCmp('sysCASHC').getValue(),
                        pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue(),
                        task: 'CARGAR_PARAMETROS'
                    },
                    success:function(form, action) {
                        ID_PROFESIONAL_SELECCIONADO = 0;
                        ID_PROFESIONAL_SELECCIONADO = Ext.getCmp('sysProfesionalProxCita').getValue();
                        NOM_PROFESIONAL_SELECCIONADO = "";
                        NOM_PROFESIONAL_SELECCIONADO = Ext.getCmp('sysProfesionalAgendaHC').getValue();
                        ID_CONSULTORIO_SELECCIONADO = Ext.getCmp('sysUbicacionProxCita').getValue();
                        NOM_CONSULTORIO_SELECCIONADO = Ext.getCmp('sysNomUbicacionProxCita').getValue();
                        CODBLOQUEOAGENDA = "USR:"+ID_USUARIO + ID_EMPRESA + ID_IPS + ID_SEDE + Math.round(Math.random()*100000000);
                    }
                });
                Ext.getCmp('fsNoAsignaCita').setVisible(false);
            }}
        });
        fsAsignarProximaCita001Ui.superclass.initComponent.call(this);
    }
});