/*
* @category    Formulario Modelo Evolucion Historia Clinica
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winHCMedicinaBasica001Ui = Ext.extend(Ext.Window, {
    title: 'eOfiClinic ©  .:: Plantilla HC ::.',
    width: 990,
    height: 636,
    closable: false,
    resizable: false,
    draggable: false,
    modal: true,
    id: 'winHC',
    initComponent: function() {
        
        var fsDiagnosticosConsulta = new fsDiagnosticosConsultaUi();
        
        tmpmx = objMX;
        tmpmxadd = objMXADD;
        tmpexa = objEXA;
        tmprem = objREM;
        myPaciente = 0;
        myCAS = 0;

        try {
            var campo = Ext.getCmp('sysPacientePlantillaHC');
            if ( campo != null ) {
                myPaciente = Ext.getCmp('sysPacientePlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myPaciente == 0){
            try {
                var campo1 = Ext.getCmp('sysIdPacienteHC');
                if ( campo1 != null ) {
                    myPaciente = Ext.getCmp('sysIdPacienteHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myPaciente == 0){
            try {
                var campo5 = Ext.getCmp('sysPacienteRefHC');
                if ( campo5 != null ) {
                    myPaciente = Ext.getCmp('sysPacienteRefHC').getValue();
                }
            }catch(ex){
            }
        }
        try {
            var campo2 = Ext.getCmp('sysCASPlantillaHC');
            if ( campo2 != null ) {
                myCAS = Ext.getCmp('sysCASPlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myCAS == 0){
            try {
                var campo3 = Ext.getCmp('sysCASHC');
                if ( campo3 != null ) {
                    myCAS = Ext.getCmp('sysCASHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myCAS == 0){
            try {
                var campo4 = Ext.getCmp('sysCASRefHC');
                if ( campo4 != null ) {
                    myCAS = Ext.getCmp('sysCASRefHC').getValue();
                }
            }catch(ex){
            }
        }
        if (objMX != "NA"){
            var xSolMX = eval(objMX);
            Ext.getCmp('gridMedicamentosHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }
        else{
            var xSolMX = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        if (objEXA != "NA"){
            var xSolEXA = eval(objEXA);
            Ext.getCmp('gridExamenesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }else{
            var xSolEXA = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        if (objREM != "NA"){
            var xSolREM = eval(objREM);
            Ext.getCmp('gridRemisionesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }else{
            var xSolREM = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }

        //
        this.items = [
            {
                xtype: 'panel',
                frame: true,
                anchor: '100%',
                id: 'panelHC',
                border: false,
                height: 570,
                autoScroll: true,
                layout: 'form',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'tabpanel',
                        anchor: '99%',
                        autoHeight: true,
                        border: false,
                        enableTabScroll: true,
                        ref: 'fTabPanel',
                        id: 'fTabPanel',
                        activeTab: 0,
                        items: [
                            {
                                xtype: 'panel',
                                title: 'INFORMACION',
                                autoHeight: true,
                                autoScroll: true,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaIdentifica',
                                layout: 'form',
                                items:[
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysIdCodPlantillaHC'
                                    },
                                     {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        value: 1,
                                        id: 'sysUsaGridSalida'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                                        value: 0,
                                        id: 'sysYaGuardoHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Plantilla',
                                        id: 'sysPlantillaHC',
                                        name: 'PLANTILLA'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysRutaRptHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysRutaRptMx'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysRutaRptExa'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysRutaRptRem'
                                    },
                                    {
                                        xtype: 'textfield',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Actividad',
                                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                                        id: 'sysActividadHC',
                                        name: 'PLANTILLA'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Empresa',
                                        id: 'sysEmpresaHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'IPS',
                                        id: 'sysIPSHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Usuario',
                                        id: 'sysUsuarioHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Profesional',
                                        id: 'sysProfesionalHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Paciente',
                                        id: 'sysIdPacienteHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Apertura',
                                        id: 'sysAperturaHC'
                                    },
                                    {
                                        xtype: 'textfield',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Cliente',
                                        id: 'sysClienteHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Plantilla',
                                        id: 'sysIdClienteHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Plantilla',
                                        id: 'sysIdPlanHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Plantilla',
                                        id: 'sysIdSubPlanHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Plantilla',
                                        id: 'sysIdContratoHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Genero',
                                        id: 'sysGeneroPacHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Edad',
                                        id: 'sysEdadPacHC'
                                    },
                                    {
                                        xtype: 'textfield',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Profesional',
                                        id: 'sysProfesionalAgendaHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'ConsecutivoDetalle',
                                        id: 'sysConsecutivoDetalleHC'
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'CAS',
                                                id: 'sysCASHC'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysFechaHC',
                                                value: 'Fecha: '
                                            },
                                            {
                                                xtype: 'textfield',
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysFechaHC'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysHoraHC',
                                                value: 'Hora: '
                                            },
                                            {
                                                xtype: 'textfield',
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysHoraHC'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysLegalizacionHC',
                                                value: 'Legalización: '
                                            },
                                            {
                                                xtype: 'textfield',
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysLegalizaHC'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'textfield',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Paciente',
                                        value: 'CC 792558261  - JORGE GALEANO RUIZ - (Masculino) FechaNac: 1973-01-30, Edad 38 Años',
                                        id: 'sysPacienteHC'
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 100,
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Genero',
                                                id: 'sysGeneroHC'
                                            },
                                            {
                                                html: 'Fecha Nac:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 100,
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysFechaNac'
                                            },
                                            {
                                                html: 'Edad:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 350,
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysEdadHC'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 370,
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Ocupación',
                                                id: 'sysOcupacionHC'
                                            },
                                            {
                                                html: 'Discapacidad:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 370,
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysDiscapacidadHC'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 370,
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Estado Civil',
                                                id: 'sysEstadoCivilHC'
                                            },
                                            {
                                                html: 'Escolaridad:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 380,
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysEscolaridadHC'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 370,
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Dirección',
                                                id: 'sysDireccionHC'
                                            },
                                            {
                                                html: 'Telefono:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 390,
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysTelefonoHC'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 380,
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Etnia',
                                                id: 'sysEtniaHC'
                                            },
                                            {
                                                html: 'Estrato:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 390,
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysEstratoHC'
                                            }
                                        ]
                                    },
                                    {
                                        html: '<hr>',
                                        style: 'background:transparent;',
                                        border: false
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Evolución',
                                autoHeight: true,
                                autoScroll: true,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaEvolucion',
                                layout: 'form',
                                items: [
                                    {
                                        xtype: 'form',
                                        frame: true,
                                        anchor: '100%',
                                        id: 'frmHC',
                                        padding: 10,
                                        border: false,
                                        autoScroll: true,
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'fieldset',
                                                title: 'MOTIVO DE CONSULTA',
                                                layout: 'table',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'MOTIVO DE CONSULTA',
                                                        name: 'MOTIVO DE CONSULTA',
                                                        height: 100,
                                                        allowBlank: false,
                                                        id: 'memMotivoConsulta'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'ENFERMEDAD ACTUAL',
                                                layout: 'table',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'ENFERMEDAD ACTUAL',
                                                        name: 'ENFERMEDAD ACTUAL',
                                                        height: 100,
                                                        allowBlank: false,
                                                        id: 'memEnfermedadActual'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'ANTECEDENTES FAMILIARES',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'ANTECEDENTES FAMILIARES',
                                                        name: 'ANTECEDENTES FAMILIARES',
                                                        height: 100,
                                                        allowBlank: false,
                                                        id: 'memAntecedentesFamiliares'
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        autoHeight: true,
                                                        anchor: '100%',
                                                        layout: {
                                                            columns: 2,
                                                            type: 'table'
                                                        },
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                autoHeight: true,
                                                                width: 280,
                                                                layout: {
                                                                    type: 'form'
                                                                },
                                                                items: [
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'HTA',
                                                                        name: 'HTA',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolANTFAMSOHTA'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'Diabetes',
                                                                        name: 'Diabetes',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolANTFAMSODiabetes'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'Cancer',
                                                                        name: 'Cancer',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolANTFAMSOCancer'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                autoHeight: true,
                                                                width: 280,
                                                                layout: {
                                                                    type: 'form'
                                                                },
                                                                items: [
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'Coronariopatias',
                                                                        name: 'Coronariopatias',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolANTFAMSOCoronariopatias'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'Enf. Psiquiatricas',
                                                                        name: 'Enf. Psiquiatricas',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolANTFAMSOPsiquiatricas'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'Asma',
                                                                        name: 'Asma',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolANTFAMSOAsma'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            
                                            {
                                                xtype: 'fieldset',
                                                title: 'ANTECEDENTES PERSONALES',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Patologicos',
                                                        name: 'Patologicos',
                                                        allowBlank: false,
                                                        id: 'strANTPERSOPatologicos',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strANTPERSOPatologicos').setValue("No Refiere");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Traumatologicos',
                                                        name: 'Traumatologicos',
                                                        allowBlank: false,
                                                        id: 'strANTPERSOTraumatologicos',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strANTPERSOTraumatologicos').setValue("No Refiere");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Quirurgicos',
                                                        name: 'Quirurgicos',
                                                        allowBlank: false,
                                                        id: 'strANTPERSOQuirurgicos',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strANTPERSOQuirurgicos').setValue("No Refiere");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Farmacologicos',
                                                        name: 'Farmacologicos',
                                                        allowBlank: false,
                                                        id: 'strANTPERSOFarmacologicos',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strANTPERSOFarmacologicos').setValue("No Refiere");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Toxicologicos',
                                                        name: 'Toxicologicos',
                                                        allowBlank: false,
                                                        id: 'strANTPERSOToxicologicos',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strANTPERSOToxicologicos').setValue("No Refiere");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Alergicos',
                                                        name: 'Alergicos',
                                                        allowBlank: false,
                                                        id: 'strANTPERSOAlergicos',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strANTPERSOAlergicos').setValue("No Refiere");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Transfusionales',
                                                        name: 'Transfusionales',
                                                        allowBlank: false,
                                                        id: 'strANTPERSOTransfusionales',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strANTPERSOTransfusionales').setValue("No Refiere");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Ocupacionales',
                                                        name: 'Ocupacionales',
                                                        allowBlank: false,
                                                        id: 'strANTPERSOOcupacionales',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strANTPERSOOcupacionales').setValue("No Refiere");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'Inmunologicos',
                                                        layout: 'form',
                                                        collapseFirst: false,
                                                        collapsible: true,
                                                        animCollapse: true,
                                                        titleCollapse: true,
                                                        anchor: '100%',
                                                        autoHeight: true,
                                                        padding: 7,
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                fieldLabel: 'Polio',
                                                                name: 'Polio',
                                                                allowBlank: false,
                                                                id: 'strANTPERSOInmunologicosPolio',
                                                                listeners: {
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strANTPERSOInmunologicosPolio').setValue("No Refiere");
                                                                        });
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                fieldLabel: 'Sarampion',
                                                                name: 'Sarampion',
                                                                allowBlank: false,
                                                                id: 'strANTPERSOInmunologicosSarampion',
                                                                listeners: {
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strANTPERSOInmunologicosSarampion').setValue("No Refiere");
                                                                        });
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                fieldLabel: 'D.P.T',
                                                                name: 'D.P.T',
                                                                allowBlank: false,
                                                                id: 'strANTPERSOInmunologicosDPT',
                                                                listeners: {
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strANTPERSOInmunologicosDPT').setValue("No Refiere");
                                                                        });
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                fieldLabel: 'B.C.G',
                                                                name: 'B.C.G',
                                                                allowBlank: false,
                                                                id: 'strANTPERSOInmunologicosBCG',
                                                                listeners: {
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strANTPERSOInmunologicosBCG').setValue("No Refiere");
                                                                        });
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                fieldLabel: 'Hemofilus',
                                                                name: 'Hemofilus',
                                                                allowBlank: false,
                                                                id: 'strANTPERSOInmunologicosHemofilus',
                                                                listeners: {
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strANTPERSOInmunologicosHemofilus').setValue("No Refiere");
                                                                        });
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                fieldLabel: 'M.M.R',
                                                                name: 'M.M.R',
                                                                allowBlank: false,
                                                                id: 'strANTPERSOInmunologicosMMR',
                                                                listeners: {
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strANTPERSOInmunologicosMMR').setValue("No Refiere");
                                                                        });
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                fieldLabel: 'T.T',
                                                                name: 'T.T',
                                                                allowBlank: false,
                                                                id: 'strANTPERSOInmunologicosTT',
                                                                listeners: {
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strANTPERSOInmunologicosTT').setValue("No Refiere");
                                                                        });
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                fieldLabel: 'Malaria',
                                                                name: 'Malaria',
                                                                allowBlank: false,
                                                                id: 'strANTPERSOInmunologicosMalaria',
                                                                listeners: {
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strANTPERSOInmunologicosMalaria').setValue("No Refiere");
                                                                        });
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                fieldLabel: 'Otra',
                                                                name: 'Otra',
                                                                allowBlank: false,
                                                                id: 'strANTPERSOInmunologicosOtra',
                                                                listeners: {
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strANTPERSOInmunologicosOtra').setValue("No Refiere");
                                                                        });
                                                                    }
                                                                }
                                                            },
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'Gineco - Obstetricos',
                                                        layout: 'form',
                                                        collapseFirst: false,
                                                        collapsible: true,
                                                        animCollapse: true,
                                                        titleCollapse: true,
                                                        anchor: '100%',
                                                        autoHeight: true,
                                                        padding: 7,
                                                        id: 'fsANTPERSOGineco',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                fieldLabel: 'Venereos',
                                                                name: 'Venereos',
                                                                allowBlank: false,
                                                                id: 'strANTPERSOGinecoVenereos',
                                                                listeners: {
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strANTPERSOGinecoVenereos').setValue("No Refiere");
                                                                        });
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html: '<br>'
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 150,
                                                                        fieldLabel: 'Ciclos',
                                                                        name: 'Ciclos',
                                                                        allowBlank: true,
                                                                        id: 'strANTPERSOGinecoCiclos'
                                                                    },
                                                                    {
                                                                        html: 'FUM'
                                                                    },
                                                                    {
                                                                        xtype: 'datefield',
                                                                        width: 120,
                                                                        name: 'FUM',
                                                                        allowBlank: true,
                                                                        disabledDates: '',
                                                                        emptyText: '(dia/mes/año) ',
                                                                        style: 'text-align:center;',
                                                                        id: 'fecANTPERSOGinecoFum'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                html: '<br>'
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'datefield',
                                                                        width: 120,
                                                                        name: 'FUP',
                                                                        fieldLabel: 'FUP',
                                                                        allowBlank: true,
                                                                        disabledDates: '',
                                                                        emptyText: '(dia/mes/año) ',
                                                                        style: 'text-align:center;',
                                                                        id: 'fecANTPERSOGinecoFup'
                                                                    },
                                                                    {
                                                                        html: 'G:'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        name: 'Gestaciones',
                                                                        emptyText: 'Gest.',
                                                                        width: 70,
                                                                        minValue: 0,
                                                                        maxValue: 20,
                                                                        decimalPrecision: 0,
                                                                        allowBlank: true,
                                                                        id: 'intANTPERSOGinecoG'
                                                                    },
                                                                    {
                                                                        html: 'P:'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        name: 'Partos',
                                                                        emptyText: 'Partos',
                                                                        width: 70,
                                                                        minValue: 0,
                                                                        maxValue: 20,
                                                                        decimalPrecision: 0,
                                                                        allowBlank: true,
                                                                        id: 'intANTPERSOGinecoP'
                                                                    },
                                                                    {
                                                                        html: 'A:'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        name: 'Abortos',
                                                                        emptyText: 'Abortos',
                                                                        width: 70,
                                                                        minValue: 0,
                                                                        maxValue: 20,
                                                                        decimalPrecision: 0,
                                                                        allowBlank: true,
                                                                        id: 'intANTPERSOGinecoA'
                                                                    },
                                                                    {
                                                                        html: 'V:'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        name: 'Vaginales',
                                                                        emptyText: 'P. Vag.',
                                                                        width: 70,
                                                                        minValue: 0,
                                                                        maxValue: 20,
                                                                        decimalPrecision: 0,
                                                                        allowBlank: true,
                                                                        id: 'intANTPERSOGinecoV'
                                                                    },
                                                                    {
                                                                        html: 'C:'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        name: 'Cesarea',
                                                                        emptyText: 'P. Ces.',
                                                                        width: 70,
                                                                        minValue: 0,
                                                                        maxValue: 20,
                                                                        decimalPrecision: 0,
                                                                        allowBlank: true,
                                                                        id: 'intANTPERSOGinecoC'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                html: '<br>'
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Planificacion',
                                                                        name: 'Planificacion',
                                                                        width: 60,
                                                                        allowBlank: true,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strANTPERSOGinecoPlanifica',
                                                                        listeners:{
                                                                            change : function( t, newValue, oldValue){
                                                                                if(newValue == "NO"){
                                                                                    Ext.getCmp('strANTPERSOGinecoMetodo').disable();
                                                                                    Ext.getCmp('strANTPERSOGinecoMetodo').allowBlank = true;
                                                                                    Ext.getCmp('strANTPERSOGinecoMetodo').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('strANTPERSOGinecoMetodo').enable();
                                                                                    Ext.getCmp('strANTPERSOGinecoMetodo').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        html: 'Metodo'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 150,
                                                                        name: 'Metodo',
                                                                        allowBlank: true,
                                                                        disabled: true,
                                                                        id: 'strANTPERSOGinecoMetodo'
                                                                    },
                                                                    {
                                                                        html: 'Ultima Citologia:'
                                                                    },
                                                                    {
                                                                        xtype: 'datefield',
                                                                        width: 120,
                                                                        name: 'Ultima Citologia',
                                                                        allowBlank: true,
                                                                        disabledDates: '',
                                                                        emptyText: '(dia/mes/año) ',
                                                                        style: 'text-align:center;',
                                                                        id: 'fecANTPERSOGinecoFUC'
                                                                    },
                                                                    {
                                                                        html: 'Resultado:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Resultado',
                                                                        width: 150,
                                                                        allowBlank: true,
                                                                        store: stResultadoCitologia,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strANTPERSOGinecoFUCRes'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'EXAMEN FISICO',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                fieldLabel: 'T.A.',
                                                                name: 'T.A. Sistolica',
                                                                width: 70,
                                                                minValue: 0,
                                                                maxValue: 300,
                                                                decimalPrecision: 0,
                                                                allowBlank: false,
                                                                id: 'intEXAFISTASistolica'
                                                            },
                                                            {
                                                                html: '/'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'T.A. Diastolica',
                                                                width: 70,
                                                                minValue: 0,
                                                                maxValue: 300,
                                                                decimalPrecision: 0,
                                                                allowBlank: false,
                                                                id: 'intEXAFISTADiastolica'
                                                            },
                                                            {
                                                                html: 'F.C.'
                                                            },                                                            
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                decimalPrecision: 2,
                                                                name: 'FC',
                                                                allowBlank: false,
                                                                id: 'intEXAFISFC'
                                                            },
                                                            {
                                                                html: 'F.R.'
                                                            },                                                            
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                decimalPrecision: 2,
                                                                name: 'FR',
                                                                allowBlank: false,
                                                                id: 'intEXAFISFR'
                                                            },
                                                            {
                                                                html: 'Talla'
                                                            },   
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                decimalPrecision: 2,
                                                                allowBlank: false,
                                                                name:"TALLA (cm)",
                                                                emptyText: '(cm)',
                                                                id: 'intEXAFISTalla'
                                                            },
                                                            {
                                                                html: 'Peso'
                                                            },   
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                decimalPrecision: 2,
                                                                allowBlank: false,
                                                                emptyText: '(Kg)',
                                                                name:"PESO (Kg)",
                                                                id: 'intEXAFISPeso'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        html: '<br>'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Aspecto General',
                                                        name: 'Aspecto General',
                                                        allowBlank: false,
                                                        id: 'strEXAFISAspectoGeneral',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strEXAFISAspectoGeneral').setValue("No Evaluado");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                html: 'Estado de Animo'
                                                            },   
                                                            {
                                                                xtype: 'textfield',
                                                                width: 150,
                                                                name: 'Estado de Animo',
                                                                allowBlank: false,
                                                                id: 'strEXAFISAspectoGeneralEstadoAnimo',
                                                                listeners: {
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strEXAFISAspectoGeneralEstadoAnimo').setValue("No Evaluado");
                                                                        });
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html: 'Estado de Conciencia'
                                                            },   
                                                            {
                                                                xtype: 'textfield',
                                                                width: 150,
                                                                name: 'Estado de Conciencia',
                                                                allowBlank: false,
                                                                id: 'strEXAFISAspectoGeneralEstadoConciencia',
                                                                listeners: {
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strEXAFISAspectoGeneralEstadoConciencia').setValue("No Evaluado");
                                                                        });
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        html: '<br>'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Piel y Faneras',
                                                        name: 'Aspecto General',
                                                        allowBlank: false,
                                                        id: 'strEXAFISPiel',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strEXAFISPiel').setValue("No Evaluado");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                html: 'Color'
                                                            },   
                                                            {
                                                                xtype: 'textfield',
                                                                width: 150,
                                                                name: 'Color',
                                                                allowBlank: false,
                                                                id: 'strEXAFISPielColor',
                                                                listeners: {
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strEXAFISPielColor').setValue("No Evaluado");
                                                                        });
                                                                    }
                                                                }
                                                            }, 
                                                            {
                                                                html: 'Textura'
                                                            },  
                                                            {
                                                                xtype: 'textfield',
                                                                width: 150,
                                                                name: 'Textura',
                                                                allowBlank: false,
                                                                id: 'strEXAFISPielTextura',
                                                                listeners: {
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strEXAFISPielTextura').setValue("No Evaluado");
                                                                        });
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                html: 'Uñas'
                                                            },   
                                                            {
                                                                xtype: 'textfield',
                                                                width: 150,
                                                                name: 'Uñas',
                                                                allowBlank: false,
                                                                id: 'strEXAFISPielUnas',
                                                                listeners: {
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strEXAFISPielUnas').setValue("No Evaluado");
                                                                        });
                                                                    }
                                                                }
                                                            }, 
                                                            {
                                                                html: 'Trofismo'
                                                            },  
                                                            {
                                                                xtype: 'textfield',
                                                                width: 150,
                                                                name: 'Trofismo',
                                                                allowBlank: false,
                                                                id: 'strEXAFISPielTrofismo',
                                                                listeners: {
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strEXAFISPielTrofismo').setValue("No Evaluado");
                                                                        });
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        html: '<br>'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Cabeza y Craneo',
                                                        name: 'Cabeza y Craneo',
                                                        allowBlank: false,
                                                        id: 'strEXAFISCabezayCraneo',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strEXAFISCabezayCraneo').setValue("No Evaluado");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                html: 'Masas'
                                                            },   
                                                            {
                                                                xtype: 'textfield',
                                                                width: 150,
                                                                name: 'Masas',
                                                                allowBlank: false,
                                                                id: 'strEXAFISCabezaMasas',
                                                                listeners: {
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strEXAFISCabezaMasas').setValue("No Evaluado");
                                                                        });
                                                                    }
                                                                }
                                                            }, 
                                                            {
                                                                html: 'Cuero Cabelludo'
                                                            },  
                                                            {
                                                                xtype: 'textfield',
                                                                width: 150,
                                                                name: 'Cuero Cabelludo',
                                                                allowBlank: false,
                                                                id: 'strEXAFISCabezaCueroCabelludo',
                                                                listeners: {
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strEXAFISCabezaCueroCabelludo').setValue("No Evaluado");
                                                                        });
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        html: '<br>'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Ojos',
                                                        name: 'Ojos',
                                                        allowBlank: false,
                                                        id: 'strEXAFISOjos',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strEXAFISOjos').setValue("No Evaluado");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                html: 'Agudeza'
                                                            },   
                                                            {
                                                                xtype: 'textfield',
                                                                width: 150,
                                                                name: 'Agudeza',
                                                                allowBlank: false,
                                                                id: 'strEXAFISOjosAgudeza',
                                                                listeners: {
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strEXAFISOjosAgudeza').setValue("No Evaluado");
                                                                        });
                                                                    }
                                                                }
                                                            }, 
                                                            {
                                                                html: 'Fondo de Ojo'
                                                            },  
                                                            {
                                                                xtype: 'textfield',
                                                                width: 150,
                                                                name: 'Fondo de Ojo',
                                                                allowBlank: false,
                                                                id: 'strEXAFISOjosFondo',
                                                                listeners: {
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strEXAFISOjosFondo').setValue("No Evaluado");
                                                                        });
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        html: '<br>'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Oidos',
                                                        name: 'Oidos',
                                                        allowBlank: false,
                                                        id: 'strEXAFISOidos',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strEXAFISOidos').setValue("No Evaluado");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                html: 'Agudeza Auditiva'
                                                            },   
                                                            {
                                                                xtype: 'textfield',
                                                                width: 150,
                                                                name: 'Agudeza Auditiva',
                                                                allowBlank: false,
                                                                id: 'strEXAFISOidosAgudeza',
                                                                listeners: {
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strEXAFISOidosAgudeza').setValue("No Evaluado");
                                                                        });
                                                                    }
                                                                }
                                                            }, 
                                                            {
                                                                html: 'Otoscopia'
                                                            },  
                                                            {
                                                                xtype: 'textfield',
                                                                width: 150,
                                                                name: 'Otoscopia',
                                                                allowBlank: false,
                                                                id: 'strEXAFISOidosOtoscopia',
                                                                listeners: {
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strEXAFISOidosOtoscopia').setValue("No Evaluado");
                                                                        });
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        html: '<br>'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Nariz',
                                                        name: 'Nariz',
                                                        allowBlank: false,
                                                        id: 'strEXAFISNariz',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strEXAFISNariz').setValue("No Evaluado");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                html: 'Epistaxis'
                                                            },   
                                                            {
                                                                xtype: 'textfield',
                                                                width: 150,
                                                                name: 'Epistaxis',
                                                                allowBlank: false,
                                                                id: 'strEXAFISNarizEpistaxis',
                                                                listeners: {
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strEXAFISNarizEpistaxis').setValue("No Evaluado");
                                                                        });
                                                                    }
                                                                }
                                                            }, 
                                                            {
                                                                html: 'Olfacion'
                                                            },  
                                                            {
                                                                xtype: 'textfield',
                                                                width: 150,
                                                                name: 'Olfacion',
                                                                allowBlank: false,
                                                                id: 'strEXAFISNarizOlfacion',
                                                                listeners: {
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strEXAFISNarizOlfacion').setValue("No Evaluado");
                                                                        });
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                html: 'Tabique'
                                                            },   
                                                            {
                                                                xtype: 'textfield',
                                                                width: 150,
                                                                name: 'Tabique',
                                                                allowBlank: false,
                                                                id: 'strEXAFISNarizTabique',
                                                                listeners: {
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strEXAFISNarizTabique').setValue("No Evaluado");
                                                                        });
                                                                    }
                                                                }
                                                            }, 
                                                            {
                                                                html: 'Rinoscopia'
                                                            },  
                                                            {
                                                                xtype: 'textfield',
                                                                width: 150,
                                                                name: 'Rinoscopia',
                                                                allowBlank: false,
                                                                id: 'strEXAFISNarizRinoscopia',
                                                                listeners: {
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strEXAFISNarizRinoscopia').setValue("No Evaluado");
                                                                        });
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        html: '<br>'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Boca',
                                                        name: 'Boca',
                                                        allowBlank: false,
                                                        id: 'strEXAFISBoca',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strEXAFISBoca').setValue("No Evaluado");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                html: 'Labios'
                                                            },   
                                                            {
                                                                xtype: 'textfield',
                                                                width: 150,
                                                                name: 'Labios',
                                                                allowBlank: false,
                                                                id: 'strEXAFISBocaLabios',
                                                                listeners: {
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strEXAFISBocaLabios').setValue("No Evaluado");
                                                                        });
                                                                    }
                                                                }
                                                            }, 
                                                            {
                                                                html: 'Dientes'
                                                            },  
                                                            {
                                                                xtype: 'textfield',
                                                                width: 150,
                                                                name: 'Dientes',
                                                                allowBlank: false,
                                                                id: 'strEXAFISBocaDientes',
                                                                listeners: {
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strEXAFISBocaDientes').setValue("No Evaluado");
                                                                        });
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                html: 'Encias'
                                                            },   
                                                            {
                                                                xtype: 'textfield',
                                                                width: 150,
                                                                name: 'Encias',
                                                                allowBlank: false,
                                                                id: 'strEXAFISBocaEncias',
                                                                listeners: {
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strEXAFISBocaEncias').setValue("No Evaluado");
                                                                        });
                                                                    }
                                                                }
                                                            }, 
                                                            {
                                                                html: 'Lengua'
                                                            },  
                                                            {
                                                                xtype: 'textfield',
                                                                width: 150,
                                                                name: 'Lengua',
                                                                allowBlank: false,
                                                                id: 'strEXAFISBocaLengua',
                                                                listeners: {
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strEXAFISBocaLengua').setValue("No Evaluado");
                                                                        });
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        html: '<br>'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Garganta',
                                                        name: 'Garganta',
                                                        allowBlank: false,
                                                        id: 'strEXAFISGarganta',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strEXAFISGarganta').setValue("No Evaluado");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                html: 'Orofaringe'
                                                            },   
                                                            {
                                                                xtype: 'textfield',
                                                                width: 150,
                                                                name: 'Orofaringe',
                                                                allowBlank: false,
                                                                id: 'strEXAFISGargantaOrofaringe',
                                                                listeners: {
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strEXAFISGargantaOrofaringe').setValue("No Evaluado");
                                                                        });
                                                                    }
                                                                }
                                                            }, 
                                                            {
                                                                html: 'Amigdalas'
                                                            },  
                                                            {
                                                                xtype: 'textfield',
                                                                width: 150,
                                                                name: 'Amigdalas',
                                                                allowBlank: false,
                                                                id: 'strEXAFISGargantaAmigdalas',
                                                                listeners: {
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strEXAFISGargantaAmigdalas').setValue("No Evaluado");
                                                                        });
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        html: '<br>'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Cuello',
                                                        name: 'Cuello',
                                                        allowBlank: false,
                                                        id: 'strEXAFISCuello',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strEXAFISCuello').setValue("No Evaluado");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                html: 'Ingurgitacion'
                                                            },   
                                                            {
                                                                xtype: 'textfield',
                                                                width: 150,
                                                                name: 'Ingurgitacion',
                                                                allowBlank: false,
                                                                id: 'strEXAFISCuelloIngurgitacion',
                                                                listeners: {
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strEXAFISCuelloIngurgitacion').setValue("No Evaluado");
                                                                        });
                                                                    }
                                                                }
                                                            }, 
                                                            {
                                                                html: 'Tiroides'
                                                            },  
                                                            {
                                                                xtype: 'textfield',
                                                                width: 150,
                                                                name: 'Tiroides',
                                                                allowBlank: false,
                                                                id: 'strEXAFISCuelloTiroides',
                                                                listeners: {
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strEXAFISCuelloTiroides').setValue("No Evaluado");
                                                                        });
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                html: 'Traquea'
                                                            },   
                                                            {
                                                                xtype: 'textfield',
                                                                width: 150,
                                                                name: 'Traquea',
                                                                allowBlank: false,
                                                                id: 'strEXAFISCuelloTraquea',
                                                                listeners: {
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strEXAFISCuelloTraquea').setValue("No Evaluado");
                                                                        });
                                                                    }
                                                                }
                                                            }, 
                                                            {
                                                                html: 'Ganglio'
                                                            },  
                                                            {
                                                                xtype: 'textfield',
                                                                width: 150,
                                                                name: 'Ganglio',
                                                                allowBlank: false,
                                                                id: 'strEXAFISCuelloGanglio',
                                                                listeners: {
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strEXAFISCuelloGanglio').setValue("No Evaluado");
                                                                        });
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        html: '<br>'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Torax',
                                                        name: 'Torax',
                                                        allowBlank: false,
                                                        id: 'strEXAFISTorax',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strEXAFISTorax').setValue("No Evaluado");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                html: 'Pulmones'
                                                            },   
                                                            {
                                                                xtype: 'textfield',
                                                                width: 150,
                                                                name: 'Pulmones',
                                                                allowBlank: false,
                                                                id: 'strEXAFISToraxPulmones',
                                                                listeners: {
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strEXAFISToraxPulmones').setValue("No Evaluado");
                                                                        });
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        html: '<br>'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Corazon',
                                                        name: 'Corazon',
                                                        allowBlank: false,
                                                        id: 'strEXAFISCorazon',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strEXAFISCorazon').setValue("No Evaluado");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                html: 'Frecuencia Cardiaca'
                                                            },   
                                                            {
                                                                xtype: 'textfield',
                                                                width: 150,
                                                                name: 'Frecuencia Cardiaca',
                                                                allowBlank: false,
                                                                id: 'strEXAFISCorazonFrecuenciaCardiaca',
                                                                listeners: {
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strEXAFISCorazonFrecuenciaCardiaca').setValue("No Evaluado");
                                                                        });
                                                                    }
                                                                }
                                                            }, 
                                                            {
                                                                html: 'Ruidos Cardiacos'
                                                            },  
                                                            {
                                                                xtype: 'textfield',
                                                                width: 150,
                                                                name: 'Ruidos Cardiacos',
                                                                allowBlank: false,
                                                                id: 'strEXAFISCorazonRuidosCardiacos',
                                                                listeners: {
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strEXAFISCorazonRuidosCardiacos').setValue("No Evaluado");
                                                                        });
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                html: 'Frotes'
                                                            },   
                                                            {
                                                                xtype: 'textfield',
                                                                width: 150,
                                                                name: 'Frotes',
                                                                allowBlank: false,
                                                                id: 'strEXAFISCorazonFrotes',
                                                                listeners: {
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strEXAFISCorazonFrotes').setValue("No Evaluado");
                                                                        });
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        html: '<br>'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Mamas',
                                                        name: 'Mamas',
                                                        allowBlank: false,
                                                        id: 'strEXAFISMamas',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strEXAFISMamas').setValue("No Evaluado");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                html: 'Ganglios'
                                                            },   
                                                            {
                                                                xtype: 'textfield',
                                                                width: 150,
                                                                name: 'Ganglios',
                                                                allowBlank: false,
                                                                id: 'strEXAFISMamasGanglios',
                                                                listeners: {
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strEXAFISMamasGanglios').setValue("No Evaluado");
                                                                        });
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        html: '<br>'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Abdomen',
                                                        name: 'Abdomen',
                                                        allowBlank: false,
                                                        id: 'strEXAFISAbdomen',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strEXAFISAbdomen').setValue("No Evaluado");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                html: 'Higado'
                                                            },   
                                                            {
                                                                xtype: 'textfield',
                                                                width: 150,
                                                                name: 'Higado',
                                                                allowBlank: false,
                                                                id: 'strEXAFISAbdomenHigado',
                                                                listeners: {
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strEXAFISAbdomenHigado').setValue("No Evaluado");
                                                                        });
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html: 'Bazo'
                                                            },   
                                                            {
                                                                xtype: 'textfield',
                                                                width: 150,
                                                                name: 'Bazo',
                                                                allowBlank: false,
                                                                id: 'strEXAFISAbdomenBazo',
                                                                listeners: {
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strEXAFISAbdomenBazo').setValue("No Evaluado");
                                                                        });
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                html: 'Masas'
                                                            },   
                                                            {
                                                                xtype: 'textfield',
                                                                width: 150,
                                                                name: 'Masas',
                                                                allowBlank: false,
                                                                id: 'strEXAFISAbdomenMasas',
                                                                listeners: {
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strEXAFISAbdomenMasas').setValue("No Evaluado");
                                                                        });
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html: 'Hernias'
                                                            },   
                                                            {
                                                                xtype: 'textfield',
                                                                width: 150,
                                                                name: 'Hernias',
                                                                allowBlank: false,
                                                                id: 'strEXAFISAbdomenHernias',
                                                                listeners: {
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strEXAFISAbdomenHernias').setValue("No Evaluado");
                                                                        });
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                html: 'Eventraciones'
                                                            },   
                                                            {
                                                                xtype: 'textfield',
                                                                width: 150,
                                                                name: 'Eventraciones',
                                                                allowBlank: false,
                                                                id: 'strEXAFISAbdomenEventraciones',
                                                                listeners: {
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strEXAFISAbdomenEventraciones').setValue("No Evaluado");
                                                                        });
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html: 'Ganglios Inguinales'
                                                            },   
                                                            {
                                                                xtype: 'textfield',
                                                                width: 150,
                                                                name: 'Ganglios Inguinales',
                                                                allowBlank: false,
                                                                id: 'strEXAFISAbdomenGangliosInguinales',
                                                                listeners: {
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strEXAFISAbdomenGangliosInguinales').setValue("No Evaluado");
                                                                        });
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        html: '<br>'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Genitales',
                                                        name: 'Genitales',
                                                        allowBlank: false,
                                                        id: 'strEXAFISGenitales',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strEXAFISGenitales').setValue("No Evaluado");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                html: 'TV'
                                                            },   
                                                            {
                                                                xtype: 'textfield',
                                                                width: 150,
                                                                name: 'TV',
                                                                allowBlank: false,
                                                                id: 'strEXAFISGenitalesTV',
                                                                listeners: {
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strEXAFISGenitalesTV').setValue("No Evaluado");
                                                                        });
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html: 'TR'
                                                            },   
                                                            {
                                                                xtype: 'textfield',
                                                                width: 150,
                                                                name: 'TR',
                                                                allowBlank: false,
                                                                id: 'strEXAFISGenitalesTR',
                                                                listeners: {
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strEXAFISGenitalesTR').setValue("No Evaluado");
                                                                        });
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        html: '<br>'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Extremidades',
                                                        name: 'Extremidades',
                                                        allowBlank: false,
                                                        id: 'strEXAFISExtremidades',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strEXAFISExtremidades').setValue("No Evaluado");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                html: 'Edemas'
                                                            },   
                                                            {
                                                                xtype: 'textfield',
                                                                width: 150,
                                                                name: 'Edemas',
                                                                allowBlank: false,
                                                                id: 'strEXAFISExtremidadesEdemas',
                                                                listeners: {
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strEXAFISExtremidadesEdemas').setValue("No Evaluado");
                                                                        });
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html: 'Pulsos'
                                                            },   
                                                            {
                                                                xtype: 'textfield',
                                                                width: 150,
                                                                name: 'Pulsos',
                                                                allowBlank: false,
                                                                id: 'strEXAFISExtremidadesPulsos',
                                                                listeners: {
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strEXAFISExtremidadesPulsos').setValue("No Evaluado");
                                                                        });
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                html: 'Hipocratismo'
                                                            },   
                                                            {
                                                                xtype: 'textfield',
                                                                width: 150,
                                                                name: 'Hipocratismo',
                                                                allowBlank: false,
                                                                id: 'strEXAFISExtremidadesHipocratismo',
                                                                listeners: {
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strEXAFISExtremidadesHipocratismo').setValue("No Evaluado");
                                                                        });
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html: 'Varices'
                                                            },   
                                                            {
                                                                xtype: 'textfield',
                                                                width: 150,
                                                                name: 'Varices',
                                                                allowBlank: false,
                                                                id: 'strEXAFISExtremidadesVarices',
                                                                listeners: {
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strEXAFISExtremidadesVarices').setValue("No Evaluado");
                                                                        });
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        html: '<br>'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Neuromuscular',
                                                        name: 'Neuromuscular',
                                                        allowBlank: false,
                                                        id: 'strEXAFISNeuromuscular',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strEXAFISNeuromuscular').setValue("No Evaluado");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                html: 'Estado Mental'
                                                            },   
                                                            {
                                                                xtype: 'textfield',
                                                                width: 150,
                                                                name: 'Estado Mental',
                                                                allowBlank: false,
                                                                id: 'strEXAFISNeuromuscularEstadoMental',
                                                                listeners: {
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strEXAFISNeuromuscularEstadoMental').setValue("No Evaluado");
                                                                        });
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html: 'Signos Meningeos'
                                                            },   
                                                            {
                                                                xtype: 'textfield',
                                                                width: 150,
                                                                name: 'Signos Meningeos',
                                                                allowBlank: false,
                                                                id: 'strEXAFISNeuromuscularSignosMeningeos',
                                                                listeners: {
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strEXAFISNeuromuscularSignosMeningeos').setValue("No Evaluado");
                                                                        });
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                html: 'Motilidad'
                                                            },   
                                                            {
                                                                xtype: 'textfield',
                                                                width: 150,
                                                                name: 'Motilidad',
                                                                allowBlank: false,
                                                                id: 'strEXAFISNeuromuscularMotilidad',
                                                                listeners: {
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strEXAFISNeuromuscularMotilidad').setValue("No Evaluado");
                                                                        });
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html: 'Reflejos'
                                                            },   
                                                            {
                                                                xtype: 'textfield',
                                                                width: 150,
                                                                name: 'Reflejos',
                                                                allowBlank: false,
                                                                id: 'strEXAFISNeuromuscularReflejos',
                                                                listeners: {
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strEXAFISNeuromuscularReflejos').setValue("No Evaluado");
                                                                        });
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                html: 'Taxia'
                                                            },   
                                                            {
                                                                xtype: 'textfield',
                                                                width: 150,
                                                                name: 'Taxia',
                                                                allowBlank: false,
                                                                id: 'strEXAFISNeuromuscularTaxia',
                                                                listeners: {
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strEXAFISNeuromuscularTaxia').setValue("No Evaluado");
                                                                        });
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        html: '<br>'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Osteo Articular',
                                                        name: 'Osteo Articular',
                                                        allowBlank: false,
                                                        id: 'strEXAFISOsteoArticular',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strEXAFISOsteoArticular').setValue("No Evaluado");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                html: 'Deformidades'
                                                            },   
                                                            {
                                                                xtype: 'textfield',
                                                                width: 150,
                                                                name: 'Deformidades',
                                                                allowBlank: false,
                                                                id: 'strEXAFISOsteoArticularDeformidades',
                                                                listeners: {
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strEXAFISOsteoArticularDeformidades').setValue("No Evaluado");
                                                                        });
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html: 'Escoliosis'
                                                            },   
                                                            {
                                                                xtype: 'textfield',
                                                                width: 150,
                                                                name: 'Escoliosis',
                                                                allowBlank: false,
                                                                id: 'strEXAFISOsteoArticularEscoliosis',
                                                                listeners: {
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strEXAFISOsteoArticularEscoliosis').setValue("No Evaluado");
                                                                        });
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                html: 'Lordosis'
                                                            },   
                                                            {
                                                                xtype: 'textfield',
                                                                width: 150,
                                                                name: 'Lordosis',
                                                                allowBlank: false,
                                                                id: 'strEXAFISOsteoArticularLordosis',
                                                                listeners: {
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strEXAFISOsteoArticularLordosis').setValue("No Evaluado");
                                                                        });
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'IMPRESION DIAGNOSTICA',
                                                layout: 'table',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'IMPRESION DIAGNOSTICA',
                                                        name: 'IMPRESION DIAGNOSTICA',
                                                        height: 100,
                                                        allowBlank: false,
                                                        id: 'memImpresionDiagnostica'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'AYUDAS DIAGNOSTICAS',
                                                layout: 'table',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'AYUDAS DIAGNOSTICAS',
                                                        name: 'AYUDAS DIAGNOSTICAS',
                                                        height: 100,
                                                        allowBlank: false,
                                                        id: 'memAyudasDiagnosticas'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'CONDUCTA',
                                                layout: 'table',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'CONDUCTA',
                                                        name: 'CONDUCTA',
                                                        height: 100,
                                                        allowBlank: false,
                                                        id: 'memConducta'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'INCAPACIDAD',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        fieldLabel: 'Dias',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 50,
                                                                name: 'INCAPACIDAD DIAS',
                                                                minValue: 0,
                                                                allowBlank: true,
                                                                style: 'text-align:center;',
                                                                id: 'intDiasIncapacidad',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        //new Date(año,mes,dia) 01/05/2010
                                                                        if(Ext.getCmp('fecDesdeIncapacidad').getValue() == null || Ext.getCmp('fecDesdeIncapacidad').getValue() == ""){
                                                                            Ext.getCmp('fecDesdeIncapacidad').setValue(new Date().format('d/m/Y'))
                                                                        }
                                                                        var xFecha = Ext.getCmp('fecDesdeIncapacidad').getValue().format('d/m/Y')
                                                                        var xMes = xFecha.substr(3,2);
                                                                        var NewFecha = new Date(xFecha.substr(6,10),(xMes-1),xFecha.substr(0,2));
                                                                        if(pNew > 0)
                                                                            DiasIncapacidad = pNew - 1;
                                                                        else
                                                                            DiasIncapacidad = pNew;
                                                                        NewFecha.setDate(NewFecha.getDate()+DiasIncapacidad);
                                                                        Ext.getCmp('fecHastaIncapacidad').setValue(NewFecha.format('d/m/Y'));
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysIncDsd',
                                                                value: 'Desde:'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 120,
                                                                name: 'INCAPACIDAD DESDE',
                                                                allowBlank: true,
                                                                disabledDates: '',
                                                                emptyText: '(dia/mes/año) ',
                                                                style: 'text-align:center;',
                                                                id: 'fecDesdeIncapacidad',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        Ext.getCmp('fecHastaIncapacidad').setValue(null);
                                                                        Ext.getCmp('fecHastaIncapacidad').setMinValue(pNew.format("d/m/Y"));
                                                                        Ext.getCmp('fecHastaIncapacidad').clearInvalid();
                                                                        var xFecha = pNew.format('d/m/Y')
                                                                        var xMes = xFecha.substr(3,2);
                                                                        var NewFecha = new Date(xFecha.substr(6,10),(xMes-1),xFecha.substr(0,2));
                                                                        if(Ext.getCmp('intDiasIncapacidad').getValue() > 0){
                                                                            DiasIncapacidad = Ext.getCmp('intDiasIncapacidad').getValue() - 1;
                                                                        }else{
                                                                            DiasIncapacidad = Ext.getCmp('intDiasIncapacidad').getValue();
                                                                        }
                                                                        NewFecha.setDate(NewFecha.getDate()+DiasIncapacidad);
                                                                        Ext.getCmp('fecHastaIncapacidad').setValue(NewFecha.format('d/m/Y'));
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysIncHst',
                                                                value: 'Hasta:'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 120,
                                                                name: 'INCAPACIDAD HASTA',
                                                                allowBlank: true,
                                                                disabledDates: '',
                                                                emptyText: '(dia/mes/año) ',
                                                                style: 'text-align:center;',
                                                                id: 'fecHastaIncapacidad'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        fieldLabel: 'Observaciones',
                                                        items: [
                                                            {
                                                                xtype: 'textarea',
                                                                anchor: '100%',
                                                                width: 615,
                                                                name: 'INCAPACIDAD OBSERVACIONES',
                                                                height: 50,
                                                                allowBlank: true,
                                                                id: 'memIncapacidadObserva'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnImprimir',
                                                                text: 'Imprimir Incapacidad',
                                                                tooltip: 'Imprimir Incapacidad',
                                                                id: 'btnPrintIncapacidadHC',
                                                                listeners:{
                                                                    click : function(){
                                                                        if (Ext.getCmp('sysYaGuardoHC').getValue() == 1)
                                                                            window.open ("../../controlador/asistencial/printincapacidad0.php?pEmpresa=" + ID_EMPRESA + "&pIPS=" + ID_IPS + "&pPaciente=" + Ext.getCmp('sysIdPacienteHC').getValue() + "&pCAS=" + Ext.getCmp('sysCASHC').getValue() + "&pConsecutivo=" + Ext.getCmp('sysConsecutivoDetalleHC').getValue(),"Incapacidad");
                                                                        else{
                                                                            Ext.Msg.show({
                                                                                title: 'eOfiClinic',
                                                                                msg: 'Usted No ha Guardado la Evolución',
                                                                                buttons: Ext.Msg.OK,
                                                                                icon: Ext.Msg.ERROR
                                                                            });
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            fsDiagnosticosConsulta
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Medicamentos',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaMedicamentos',
                                items: [
                                    xSolMX
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Servicios',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaServicios',
                                items: [
                                    xSolEXA
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Remisiones',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaRemisiones',
                                items: [
                                    xSolREM
                                ]
                            }
                            /*,
                            {
                                xtype: 'panel',
                                title: 'Solicitud CTC',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaCTC',
                                items: [
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Consentimientos Informados',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaConsentimientos',
                                items: [
                                ]
                            },*/
                        ]
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btnSalirEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 1)
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Usted No ha Guardado la Evolución del Paciente y Se Perdera la Información, Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                },
                tbar:{
                    items: [
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Ver Historia Clínica',
                            iconCls: 'btnVerHC',
                            id: 'btnVerHC',
                            listeners:{
                                click : function(){
                                    var cmpResumenHC = new winFrmVerHistorialHC({
                                        renderTo: Ext.getBody()
                                    });
                                    Ext.getCmp('winViewEvolucionHC').title = "PACIENTE: " + Ext.getCmp('sysPacienteHC').getValue();
                                    Ext.getCmp('gridHistorialEvoluciones').store.load({
                                        params: {
                                            pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                                            pPaciente: Ext.getCmp('sysIdPacienteHC').getValue()
                                        }
                                    });
                                    cmpResumenHC.show();
                                }
                            }
                        },
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar Evolución',
                            iconCls: 'btnGuardar',
                            id: 'btnGuardarEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 0)
                                    {
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Guardar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnGuardarRegistrosMedicinaGeneral();
                                                }
                                            }
                                        });
                                    }else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Modificar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnModificarRegistrosMedicinaGeneral();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                }
            }
        ];
        this.on({
            afterlayout:{
                scope:this, 
                single:true, 
                fn:function() {
                    Ext.Msg.hide();
                    //Predefinir Comportamiento Campos

                    //EVALUA ANTECEDENTES GINOECO-OBSTETrICOS
                    if(Ext.getCmp('sysGeneroHC').getValue()=="MASCULINO"){
                        Ext.getCmp('fsANTPERSOGineco').setVisible(false);                        
                        Ext.getCmp('strANTPERSOGinecoVenereos').allowBlank = true;
                        Ext.getCmp('strANTPERSOGinecoCiclos').allowBlank = true;
                        Ext.getCmp('fecANTPERSOGinecoFum').allowBlank = true;
                        Ext.getCmp('fecANTPERSOGinecoFup').allowBlank = true;
                        Ext.getCmp('intANTPERSOGinecoG').allowBlank = true;
                        Ext.getCmp('intANTPERSOGinecoP').allowBlank = true;
                        Ext.getCmp('intANTPERSOGinecoA').allowBlank = true;
                        Ext.getCmp('intANTPERSOGinecoV').allowBlank = true;
                        Ext.getCmp('intANTPERSOGinecoC').allowBlank = true;
                        Ext.getCmp('strANTPERSOGinecoPlanifica').allowBlank = true;
                        Ext.getCmp('strANTPERSOGinecoMetodo').allowBlank = true;
                        Ext.getCmp('fecANTPERSOGinecoFUC').allowBlank = true;
                        Ext.getCmp('strANTPERSOGinecoFUCRes').allowBlank = true;

                    }else{
                        Ext.getCmp('fsANTPERSOGineco').setVisible(true);                        
                        Ext.getCmp('strANTPERSOGinecoVenereos').allowBlank = false;
                        Ext.getCmp('strANTPERSOGinecoCiclos').allowBlank = false;
                        Ext.getCmp('fecANTPERSOGinecoFum').allowBlank = false;
                        Ext.getCmp('fecANTPERSOGinecoFup').allowBlank = false;
                        Ext.getCmp('intANTPERSOGinecoG').allowBlank = false;
                        Ext.getCmp('intANTPERSOGinecoP').allowBlank = false;
                        Ext.getCmp('intANTPERSOGinecoA').allowBlank = false;
                        Ext.getCmp('intANTPERSOGinecoV').allowBlank = false;
                        Ext.getCmp('intANTPERSOGinecoC').allowBlank = false;
                        Ext.getCmp('strANTPERSOGinecoPlanifica').allowBlank = false;
                        Ext.getCmp('strANTPERSOGinecoMetodo').allowBlank = false;
                        Ext.getCmp('fecANTPERSOGinecoFUC').allowBlank = false;
                        Ext.getCmp('strANTPERSOGinecoFUCRes').allowBlank = false;

                    }
                }
            }
        });
        winHCMedicinaBasica001Ui.superclass.initComponent.call(this);
    }
});

function fnGuardarRegistrosMedicinaGeneral(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc.php',
            params:{
                task: 'guardar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pidPlantillaHC : Ext.getCmp('sysIdCodPlantillaHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function fnModificarRegistrosMedicinaGeneral(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc.php',
            params:{
                task: 'modificar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}
