/*
* @category    Formulario Modelo Historia Clinica Odontologia Primera Vez
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winHCOdontologia001Ui = Ext.extend(Ext.Window, {
    title: 'eOfiClinic ©  .:: Historia Clinica Odontologia Primera Vez ::.',
    width: 1010,
    height: 636,
    closable: false,
    resizable: false,
    draggable: false,
    modal: true,
    id: 'winHCOdontologia001',
    initComponent: function() {
        
        tmpmx = objMX;
        tmpmxadd = objMXADD;
        tmpexa = objEXA;
        tmprem = objREM;
        myPaciente = 0;
        myCAS = 0;
        
        try {
            var campo = Ext.getCmp('sysPacientePlantillaHC');
            if ( campo != null ) {
                myPaciente = Ext.getCmp('sysPacientePlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myPaciente == 0){
            try {
                var campo1 = Ext.getCmp('sysIdPacienteHC');
                if ( campo1 != null ) {
                    myPaciente = Ext.getCmp('sysIdPacienteHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myPaciente == 0){
            try {
                var campo5 = Ext.getCmp('sysPacienteRefHC');
                if ( campo5 != null ) {
                    myPaciente = Ext.getCmp('sysPacienteRefHC').getValue();
                }
            }catch(ex){
            }
        }
        try {
            var campo2 = Ext.getCmp('sysCASPlantillaHC');
            if ( campo2 != null ) {
                myCAS = Ext.getCmp('sysCASPlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myCAS == 0){
            try {
                var campo3 = Ext.getCmp('sysCASHC');
                if ( campo3 != null ) {
                    myCAS = Ext.getCmp('sysCASHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myCAS == 0){
            try {
                var campo4 = Ext.getCmp('sysCASRefHC');
                if ( campo4 != null ) {
                    myCAS = Ext.getCmp('sysCASRefHC').getValue();
                }
            }catch(ex){
            }
        }
        if (objMX != "NA"){
            var xSolMX = eval(objMX);
            Ext.getCmp('gridMedicamentosHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }
        else{
            var xSolMX = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        if (objEXA != "NA"){
            var xSolEXA = eval(objEXA);
            Ext.getCmp('gridExamenesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }else{
            var xSolEXA = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }    
        if (objREM != "NA"){
            var xSolREM = eval(objREM);
            Ext.getCmp('gridRemisionesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }else{
            var xSolREM = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        
        function DescripcionGrid(val, x, store){
            mostrarHC = '<table><tr><td style="padding: 1px;">';
            mostrarHC += val;
            mostrarHC += '</td></tr></table>';
            return mostrarHC;
        }
        
        //Store
        
        var stGridDienteActividadesRealizadas = new StoreGridDienteActividadesRealizadas();
        stGridDienteActividadesRealizadas.load({
            params: {
                pPaciente: wPaciente
            }
        });
        
        var stGridDienteActividadesProxCita = new StoreGridDienteActividadesProxCita();
        stGridDienteActividadesProxCita.load({
            params: {
                pPaciente: wPaciente
            }
        });
        
        var stGridOdontogramasxPaciente = new StoreGridOdontogramasxPaciente();
        stGridOdontogramasxPaciente.load({
            params: {
                pPaciente: wPaciente
            }
        });
        
        function VerInfoOdontograma(value, metaData, record, rowIndex, colIndex, store){  
            metaData.attr = 'style="white-space:normal"';  
            return value + '</br>' + record.get('Profesional') + '</br>Tipo Odontograma:' + record.get('TipoOdontograma') + '</br>Tipo Denticion:' + record.get('TipoDenticion');
        }
        
        var OdontogramaInical = new Ext.Panel({ 
            autoLoad:{
                url:'../../../app/frm/odontograma/odontograma001.php?pPaciente=' + wPaciente + '&pCAS=' + wCAS,
                scripts:true,
                scope:this
            },
            id:'OdontogramaInical',
            height: 480,
            autoScroll:true,
            closable:false
        });
        
        //Store Locales
        var dataTipoDenticion = [
            ['TEMPORAL'],
            ['PERMANENTE'],
            ['MIXTA']
        ];
        var stTipoDenticion = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stTipoDenticion.loadData(dataTipoDenticion);
        
        
        var dataHigiene = [
            ['BUENO'],
            ['REGULAR'],
            ['MALO']
        ];
        var stHigiene = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stHigiene.loadData(dataHigiene);
        
        
        var dataRiesgo = [
            ['ALTO'],
            ['MEDIO'],
            ['BAJO']
        ];
        var stRiesgo = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stRiesgo.loadData(dataRiesgo);        


        var dataEstadoExamen = [
            ['NORMAL'],
            ['ANORMAL']
        ];
        var stEstadoExamen = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stEstadoExamen.loadData(dataEstadoExamen);

        
        
        var dataFrecuencia = [
            ['NINGUNA'],
            ['UNA VEZ AL DIA'],
            ['DOS VECES AL DIA'],
            ['TRES VECES AL DIA']
        ];
        var stFrecuencia = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stFrecuencia.loadData(dataFrecuencia);  

        
        var dataVitalidad = [
            ['POSITIVA'],
            ['NEGATIVA']
        ];
        var stVitalidad = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stVitalidad.loadData(dataVitalidad);   
        
        
        var dataOclusion = [
            ['CLASE I'],
            ['CLASE II'],
            ['CLASE III'],
            ['NO APLICA']
        ];
        var stOclusion = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stOclusion.loadData(dataOclusion);   
        
     

        //
        this.items = [
            {
                xtype: 'panel',
                frame: true,
                anchor: '100%',
                id: 'panelHC',
                border: false,
                height: 570,
                autoScroll: true,
                layout: 'form',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'tabpanel',
                        anchor: '100%',
                        autoHeight: true,
                        border: false,
                        enableTabScroll: true,
                        ref: 'fTabPanel',
                        id: 'fTabPanel',
                        activeTab: 0,
                        items: [
                            {
                                xtype: 'panel',
                                title: 'Datos Basicos',
                                autoHeight: true,
                                autoScroll: true,
                                width: 1005,
                                frame: true,
                                border: false,
                                id: 'fichaIdentifica',
                                layout: 'form',
                                items:[
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysIdCodPlantillaHC'
                                    },
                                     {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        value: 1,
                                        id: 'sysUsaGridSalida'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                                        value: 0,
                                        id: 'sysYaGuardoHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Plantilla',
                                        id: 'sysPlantillaHC',
                                        name: 'PLANTILLA'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysRutaRptHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysRutaRptMx'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysRutaRptExa'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysRutaRptRem'
                                    },
                                    {
                                        xtype: 'textfield',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Actividad',
                                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                                        id: 'sysActividadHC',
                                        name: 'PLANTILLA'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Empresa',
                                        id: 'sysEmpresaHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'IPS',
                                        id: 'sysIPSHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Usuario',
                                        id: 'sysUsuarioHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Profesional',
                                        id: 'sysProfesionalHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Paciente',
                                        id: 'sysIdPacienteHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Apertura',
                                        id: 'sysAperturaHC'
                                    },
                                    {
                                        xtype: 'textfield',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Cliente',
                                        id: 'sysClienteHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Plantilla',
                                        id: 'sysIdClienteHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Plantilla',
                                        id: 'sysIdPlanHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Plantilla',
                                        id: 'sysIdSubPlanHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Plantilla',
                                        id: 'sysIdContratoHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Genero',
                                        id: 'sysGeneroPacHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Edad',
                                        id: 'sysEdadPacHC'
                                    },
                                    {
                                        xtype: 'textfield',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Profesional',
                                        id: 'sysProfesionalAgendaHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'ConsecutivoDetalle',
                                        id: 'sysConsecutivoDetalleHC'
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'CAS',
                                                id: 'sysCASHC'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysFechaHC',
                                                value: 'Fecha: '
                                            },
                                            {
                                                xtype: 'textfield',
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysFechaHC'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysHoraHC',
                                                value: 'Hora: '
                                            },
                                            {
                                                xtype: 'textfield',
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysHoraHC'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysLegalizacionHC',
                                                value: 'Legalización: '
                                            },
                                            {
                                                xtype: 'textfield',
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysLegalizaHC'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'textfield',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Paciente',
                                        value: 'CC 792558261  - JORGE GALEANO RUIZ - (Masculino) FechaNac: 1973-01-30, Edad 38 Años',
                                        id: 'sysPacienteHC'
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 100,
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Genero',
                                                id: 'sysGeneroHC'
                                            },
                                            {
                                                html: 'Fecha Nac:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 100,
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysFechaNac'
                                            },
                                            {
                                                html: 'Edad:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 350,
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysEdadHC'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 370,
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Ocupación',
                                                id: 'sysOcupacionHC'
                                            },
                                            {
                                                html: 'Discapacidad:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 370,
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysDiscapacidadHC'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 370,
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Estado Civil',
                                                id: 'sysEstadoCivilHC'
                                            },
                                            {
                                                html: 'Escolaridad:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 380,
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysEscolaridadHC'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 370,
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Dirección',
                                                id: 'sysDireccionHC'
                                            },
                                            {
                                                html: 'Telefono:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 390,
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysTelefonoHC'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 380,
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Etnia',
                                                id: 'sysEtniaHC'
                                            },
                                            {
                                                html: 'Estrato:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 390,
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysEstratoHC'
                                            }
                                        ]
                                    },
                                    {
                                        html: '<hr>',
                                        style: 'background:transparent;',
                                        border: false
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Evolucion',
                                autoHeight: true,
                                autoScroll: true,
                                width: 1005,
                                frame: true,
                                border: false,
                                id: 'fichaEvolucion',
                                layout: 'form',
                                items: [
                                    {
                                        xtype: 'form',
                                        frame: true,
                                        anchor: '100%',
                                        id: 'frmHC',
                                        padding: 10,
                                        border: false,
                                        autoScroll: true,
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'fieldset',
                                                title: 'MOTIVO CONSULTA',
                                                layout: 'table',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'MOTIVO CONSULTA',
                                                        name: 'MOTIVO CONSULTA',
                                                        height: 100,            
                                                        allowBlank: true,
                                                        id: 'memMotivoConsulta'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'ANTECEDENTES MEDICOS FAMILIARES',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Antecedentes Familiares',
                                                                name: 'Antecedentes Familiares',
                                                                width: 70,
                                                                allowBlank: true,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strANTFamiliares',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO"){
                                                                            Ext.getCmp('strANTFamiliaresDescripcion').allowBlank = true;
                                                                            Ext.getCmp('strANTFamiliaresDescripcion').setValue(null);
                                                                            Ext.getCmp('strANTFamiliaresDescripcion').disable();
                                                                            Ext.getCmp('strANTFamiliaresDescripcion').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strANTFamiliaresDescripcion').enable();
                                                                            Ext.getCmp('strANTFamiliaresDescripcion').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 700,
                                                                name: 'Antecedentes Medicos Familiares Descripcion',
                                                                allowBlank: false,
                                                                disabled: true,
                                                                id: 'strANTFamiliaresDescripcion'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'ANTECEDENTES MEDICOS GENERALES',
                                                layout: 'form',
                                                labelSeparator: "",
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        name: 'Alergias',
                                                        fieldLabel: 'Alergias<br>&nbsp;',
                                                        allowBlank: false,
                                                        id: 'strANTAlergias',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strANTAlergias').setValue("No Refiere");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        name: 'Discracias Sanguineas',
                                                        fieldLabel: 'Discracias Sanguineas',
                                                        allowBlank: false,
                                                        id: 'strANTDiscraciasSanguineas',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strANTDiscraciasSanguineas').setValue("No Refiere");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        name: 'Cardiopatias',
                                                        fieldLabel: 'Cardiopatias<br>&nbsp;',
                                                        allowBlank: false,
                                                        id: 'strANTCardiopatias',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strANTCardiopatias').setValue("No Refiere");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        name: 'Embarazo',
                                                        fieldLabel: 'Embarazo<br>&nbsp;',
                                                        allowBlank: false,
                                                        id: 'strANTEmbarazo',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strANTEmbarazo').setValue("No Refiere");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        name: 'Presion Arterial',
                                                        fieldLabel: 'Presion Arterial<br>&nbsp;',
                                                        allowBlank: false,
                                                        id: 'strANTPresionArterial',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strANTPresionArterial').setValue("No Refiere");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        name: 'Tratamiento Medico',
                                                        fieldLabel: 'Tratamiento Medico',
                                                        allowBlank: false,
                                                        id: 'strANTTratamientoMedico',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strANTTratamientoMedico').setValue("No Refiere");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        name: 'Medicamentos',
                                                        fieldLabel: 'Medicamentos<br>&nbsp;',
                                                        allowBlank: false,
                                                        id: 'strANTMedicamentos',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strANTMedicamentos').setValue("No Refiere");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        name: 'Hepatitis',
                                                        fieldLabel: 'Hepatitis<br>&nbsp;',
                                                        allowBlank: false,
                                                        id: 'strANTHepatitis',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strANTHepatitis').setValue("No Refiere");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        name: 'Diabetes',
                                                        fieldLabel: 'Diabetes<br>&nbsp;',
                                                        allowBlank: false,
                                                        id: 'strANTDiabetes',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strANTDiabetes').setValue("No Refiere");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        name: 'HIV - SIDA',
                                                        fieldLabel: 'HIV - SIDA<br>&nbsp;',
                                                        allowBlank: false,
                                                        id: 'strANTHIV',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strANTHIV').setValue("No Refiere");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        name: 'Patologias Respiratorias',
                                                        fieldLabel: 'Patologias Respiratorias',
                                                        allowBlank: false,
                                                        id: 'strANTPatologiasRespiratorias',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strANTPatologiasRespiratorias').setValue("No Refiere");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        name: 'Patologias Renales',
                                                        fieldLabel: 'Patologias Renales<br>&nbsp;',
                                                        allowBlank: false,
                                                        id: 'strANTPatologiasRenales',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strANTPatologiasRenales').setValue("No Refiere");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        name: 'Traastornos Gastricos',
                                                        fieldLabel: 'Traastornos Gastricos',
                                                        allowBlank: false,
                                                        id: 'strANTTraastornosGastricos',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strANTTraastornosGastricos').setValue("No Refiere");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        name: 'Traastornos Emocionales',
                                                        fieldLabel: 'Traastornos Emocionales',
                                                        allowBlank: false,
                                                        id: 'strANTTraastornosEmocionales',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strANTTraastornosEmocionales').setValue("No Refiere");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        name: 'Habitos',
                                                        fieldLabel: 'Habitos<br>&nbsp;',
                                                        allowBlank: false,
                                                        id: 'strANTHabitos',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strANTHabitos').setValue("No Refiere");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        name: 'Otros',
                                                        fieldLabel: 'Otros',
                                                        allowBlank: false,
                                                        id: 'strANTOtros',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strANTOtros').setValue("No Refiere");
                                                                });
                                                            }
                                                        }
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'Examen Estomatologico',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'panel',
                                                        autoHeight: true,
                                                        anchor: '100%',
                                                        layout: {
                                                            columns: 2,
                                                            type: 'table'
                                                        },
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                width: 440,
                                                                autoHeight: true,
                                                                labelSeparator: ' ',
                                                                layout: {
                                                                    type: 'form'
                                                                },
                                                                items: [
                                                                    {
                                                                        xtype: 'compositefield',
                                                                        style: 'background:transparent;',
                                                                        items: [
                                                                            {
                                                                                xtype: 'combo',
                                                                                fieldLabel: 'Labios',
                                                                                name: 'Labios',
                                                                                width: 70,
                                                                                allowBlank: false,
                                                                                store: stEstadoExamen,
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                mode: 'local',
                                                                                forceSelection: true,
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 10,
                                                                                triggerAction: 'all',
                                                                                id: 'strESTOMALabios'
                                                                            },
                                                                            {
                                                                                xtype: 'textfield',
                                                                                width: 250,
                                                                                name: 'Labios',
                                                                                allowBlank: true,
                                                                                id: 'strESTOMALabiosDesCripcion'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'compositefield',
                                                                        style: 'background:transparent;',
                                                                        items: [
                                                                            {
                                                                                xtype: 'combo',
                                                                                fieldLabel: 'Mucosa Oral',
                                                                                name: 'Mucosa Oral',
                                                                                width: 70,
                                                                                allowBlank: false,
                                                                                store: stEstadoExamen,
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                mode: 'local',
                                                                                forceSelection: true,
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 10,
                                                                                triggerAction: 'all',
                                                                                id: 'strESTOMAMucosaoral'
                                                                            },
                                                                            {
                                                                                xtype: 'textfield',
                                                                                width: 250,
                                                                                name: 'Mucosa Oral',
                                                                                allowBlank: true,
                                                                                id: 'strESTOMAMucosaoralDesCripcion'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'compositefield',
                                                                        style: 'background:transparent;',
                                                                        items: [
                                                                            {
                                                                                xtype: 'combo',
                                                                                fieldLabel: 'Frenillos',
                                                                                name: 'Frenillos',
                                                                                width: 70,
                                                                                allowBlank: false,
                                                                                store: stEstadoExamen,
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                mode: 'local',
                                                                                forceSelection: true,
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 10,
                                                                                triggerAction: 'all',
                                                                                id: 'strESTOMAFrenillos'
                                                                            },
                                                                            {
                                                                                xtype: 'textfield',
                                                                                width: 250,
                                                                                name: 'Frenillos',
                                                                                allowBlank: true,
                                                                                id: 'strESTOMAFrenillosDesCripcion'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'compositefield',
                                                                        style: 'background:transparent;',
                                                                        items: [
                                                                            {
                                                                                xtype: 'combo',
                                                                                fieldLabel: 'Paladar',
                                                                                name: 'Paladar',
                                                                                width: 70,
                                                                                allowBlank: false,
                                                                                store: stEstadoExamen,
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                mode: 'local',
                                                                                forceSelection: true,
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 10,
                                                                                triggerAction: 'all',
                                                                                id: 'strESTOMAPaladar'
                                                                            },
                                                                            {
                                                                                xtype: 'textfield',
                                                                                width: 250,
                                                                                name: 'Paladar',
                                                                                allowBlank: true,
                                                                                id: 'strESTOMAPaladarDesCripcion'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'compositefield',
                                                                        style: 'background:transparent;',
                                                                        items: [
                                                                            {
                                                                                xtype: 'combo',
                                                                                fieldLabel: 'Piso Boca',
                                                                                name: 'Piso Boca',
                                                                                width: 70,
                                                                                allowBlank: false,
                                                                                store: stEstadoExamen,
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                mode: 'local',
                                                                                forceSelection: true,
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 10,
                                                                                triggerAction: 'all',
                                                                                id: 'strESTOMAPisoBoca'
                                                                            },
                                                                            {
                                                                                xtype: 'textfield',
                                                                                width: 250,
                                                                                name: 'Piso Boca',
                                                                                allowBlank: true,
                                                                                id: 'strESTOMAPisoBocaDesCripcion'
                                                                            }
                                                                        ]
                                                                    },
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 440,
                                                                autoHeight: true,
                                                                labelSeparator: ' ',
                                                                layout: {
                                                                    type: 'form'
                                                                },
                                                                items: [
                                                                    {
                                                                        xtype: 'compositefield',
                                                                        style: 'background:transparent;',
                                                                        items: [
                                                                            {
                                                                                xtype: 'combo',
                                                                                fieldLabel: 'Lengua',
                                                                                name: 'Lengua',
                                                                                width: 70,
                                                                                allowBlank: false,
                                                                                store: stEstadoExamen,
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                mode: 'local',
                                                                                forceSelection: true,
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 10,
                                                                                triggerAction: 'all',
                                                                                id: 'strESTOMALengua'
                                                                            },
                                                                            {
                                                                                xtype: 'textfield',
                                                                                width: 250,
                                                                                name: 'Lengua',
                                                                                allowBlank: true,
                                                                                id: 'strESTOMALenguaDesCripcion'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'compositefield',
                                                                        style: 'background:transparent;',
                                                                        items: [
                                                                            {
                                                                                xtype: 'combo',
                                                                                fieldLabel: 'ATM',
                                                                                name: 'ATM',
                                                                                width: 70,
                                                                                allowBlank: false,
                                                                                store: stEstadoExamen,
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                mode: 'local',
                                                                                forceSelection: true,
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 10,
                                                                                triggerAction: 'all',
                                                                                id: 'strESTOMAATM'
                                                                            },
                                                                            {
                                                                                xtype: 'textfield',
                                                                                width: 250,
                                                                                name: 'ATM',
                                                                                allowBlank: true,
                                                                                id: 'strESTOMAATMDescripcion'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'compositefield',
                                                                        style: 'background:transparent;',
                                                                        items: [
                                                                            {
                                                                                xtype: 'combo',
                                                                                fieldLabel: 'Orofaringe',
                                                                                name: 'Orofaringe',
                                                                                width: 70,
                                                                                allowBlank: false,
                                                                                store: stEstadoExamen,
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                mode: 'local',
                                                                                forceSelection: true,
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 10,
                                                                                triggerAction: 'all',
                                                                                id: 'strESTOMAOrofaringe'
                                                                            },
                                                                            {
                                                                                xtype: 'textfield',
                                                                                width: 250,
                                                                                name: 'Orofaringe',
                                                                                allowBlank: true,
                                                                                id: 'strESTOMAOrofaringeDescripcion'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'compositefield',
                                                                        style: 'background:transparent;',
                                                                        items: [
                                                                            {
                                                                                xtype: 'combo',
                                                                                fieldLabel: 'Glandulas Salivares',
                                                                                name: 'Glandulas Salivares',
                                                                                width: 70,
                                                                                allowBlank: false,
                                                                                store: stEstadoExamen,
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                mode: 'local',
                                                                                forceSelection: true,
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 10,
                                                                                triggerAction: 'all',
                                                                                id: 'strESTOMAGlandulasSalivares'
                                                                            },
                                                                            {
                                                                                xtype: 'textfield',
                                                                                width: 250,
                                                                                name: 'Glandulas Salivares',
                                                                                allowBlank: true,
                                                                                id: 'strESTOMAGlandulasSalivaresDescripcion'
                                                                            }
                                                                        ]
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'Indice COPS',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'Dientes Cariados',
                                                                fieldLabel: 'Dientes Cariados',
                                                                width: 70,
                                                                minValue: 0,
                                                                maxValue: 100,
                                                                decimalPrecision: 0,
                                                                allowBlank: false,
                                                                value: 0,
                                                                id: 'intIndice_1'
                                                            },
                                                            {
                                                                html: 'Dientes Obturados'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'Dientes Obturados',
                                                                width: 70,
                                                                minValue: 0,
                                                                maxValue: 100,
                                                                decimalPrecision: 0,
                                                                allowBlank: false,
                                                                value: 0,
                                                                id: 'intIndice_2'
                                                            },
                                                            {
                                                                html: 'Dientes Exfoliados'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'Dientes Exfoliados',
                                                                width: 70,
                                                                minValue: 0,
                                                                maxValue: 100,
                                                                decimalPrecision: 0,
                                                                allowBlank: false,
                                                                value: 0,
                                                                id: 'intIndice_3'
                                                            },
                                                            {
                                                                html: 'Dientes Sanos'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'Dientes Sanos',
                                                                width: 70,
                                                                minValue: 0,
                                                                maxValue: 100,
                                                                decimalPrecision: 0,
                                                                allowBlank: false,
                                                                value: 0,
                                                                id: 'intIndice_4'
                                                            },
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'Higiene Oral',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'panel',
                                                        autoHeight: true,
                                                        anchor: '100%',
                                                        layout: {
                                                            columns: 2,
                                                            type: 'table'
                                                        },
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                autoHeight: true,
                                                                labelSeparator: "",
                                                                width: 280,
                                                                layout: {
                                                                    type: 'form'
                                                                },
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Higiene Oral',
                                                                        fieldLabel: 'Higiene Oral<br>&nbsp;',
                                                                        width: 150,
                                                                        allowBlank: true,
                                                                        store: stHigiene,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strHigieneOral_1'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Frecuencia Cepillado',
                                                                        fieldLabel: 'Frecuencia Cepillado',
                                                                        width: 150,
                                                                        allowBlank: true,
                                                                        store: stFrecuencia,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'intHigieneOral_2'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Grado de Riesgo',
                                                                        fieldLabel: 'Grado de Riesgo',
                                                                        width: 150,
                                                                        allowBlank: true,
                                                                        store: stRiesgo,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strHigieneOral_3'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        name: 'Usa Ceda Dental',
                                                                        fieldLabel: 'Usa Ceda Dental',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolHigieneOral_4'
                                                                    },
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                autoHeight: true,
                                                                labelSeparator: "",
                                                                width: 600,
                                                                layout: {
                                                                    type: 'form'
                                                                },
                                                                items: [
                                                                    {
                                                                        xtype: 'compositefield',
                                                                        style: 'background:transparent;',
                                                                        items: [
                                                                            {
                                                                                xtype: 'numberfield',
                                                                                name: 'Superficies con Placa',
                                                                                fieldLabel: 'Superficies con Placa',
                                                                                width: 100,
                                                                                minValue: 0,
                                                                                decimalPrecision: 0,
                                                                                allowBlank: false,
                                                                                value: 0,
                                                                                id: 'intHigieneOral_6'
                                                                            },
                                                                            {
                                                                                html: 'Porcentaje Placa'
                                                                            },
                                                                            {
                                                                                xtype: 'numberfield',
                                                                                name: 'Porcentaje Placa',
                                                                                width: 100,
                                                                                minValue: 0,
                                                                                decimalPrecision: 0,
                                                                                allowBlank: false,
                                                                                value: 0,
                                                                                id: 'intHigieneOral_7'
                                                                            },
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'textarea',
                                                                        width: 300,
                                                                        fieldLabel: 'Observaciones',
                                                                        name: 'Observaciones',
                                                                        height: 80,            
                                                                        allowBlank: true,
                                                                        id: 'memHigieneOral_8'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'Examen Pulpar',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Cuellos Sensibles',
                                                                fieldLabel: 'Cuellos Sensibles',
                                                                width: 70,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strEXAPULCuellosSensibles',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO"){
                                                                            Ext.getCmp('strEXAPULCuellosSensiblesDescripcion').allowBlank = true;
                                                                            Ext.getCmp('strEXAPULCuellosSensiblesDescripcion').setValue(null);
                                                                            Ext.getCmp('strEXAPULCuellosSensiblesDescripcion').disable();
                                                                            Ext.getCmp('strEXAPULCuellosSensiblesDescripcion').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strEXAPULCuellosSensiblesDescripcion').enable();
                                                                            Ext.getCmp('strEXAPULCuellosSensiblesDescripcion').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 700,
                                                                name: 'Cuellos Sensibles',
                                                                disabled: true,
                                                                allowBlank: true,
                                                                id: 'strEXAPULCuellosSensiblesDescripcion'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Abscesos',
                                                                fieldLabel: 'Abscesos',
                                                                width: 70,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strEXAPULAbscesos',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO"){
                                                                            Ext.getCmp('strEXAPULAbscesosDescripcion').allowBlank = true;
                                                                            Ext.getCmp('strEXAPULAbscesosDescripcion').setValue(null);
                                                                            Ext.getCmp('strEXAPULAbscesosDescripcion').disable();
                                                                            Ext.getCmp('strEXAPULAbscesosDescripcion').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strEXAPULAbscesosDescripcion').enable();
                                                                            Ext.getCmp('strEXAPULAbscesosDescripcion').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 700,
                                                                name: 'Abscesos',
                                                                disabled: true,
                                                                allowBlank: true,
                                                                id: 'strEXAPULAbscesosDescripcion'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Exposicion Pulpar',
                                                                fieldLabel: 'Exposicion Pulpar',
                                                                width: 70,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strEXAPULExposicionPulpar',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO"){
                                                                            Ext.getCmp('strEXAPULExposicionPulparDescripcion').allowBlank = true;
                                                                            Ext.getCmp('strEXAPULExposicionPulparDescripcion').setValue(null);
                                                                            Ext.getCmp('strEXAPULExposicionPulparDescripcion').disable();
                                                                            Ext.getCmp('strEXAPULExposicionPulparDescripcion').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strEXAPULExposicionPulparDescripcion').enable();
                                                                            Ext.getCmp('strEXAPULExposicionPulparDescripcion').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 700,
                                                                name: 'Exposicion Pulpar',
                                                                disabled: true,
                                                                allowBlank: true,
                                                                id: 'strEXAPULExposicionPulparDescripcion'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Cambio Color',
                                                                fieldLabel: 'Cambio Color',
                                                                width: 70,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strEXAPULCambioColor',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO"){
                                                                            Ext.getCmp('strEXAPULCambioColorDescripcion').allowBlank = true;
                                                                            Ext.getCmp('strEXAPULCambioColorDescripcion').setValue(null);
                                                                            Ext.getCmp('strEXAPULCambioColorDescripcion').disable();
                                                                            Ext.getCmp('strEXAPULCambioColorDescripcion').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strEXAPULCambioColorDescripcion').enable();
                                                                            Ext.getCmp('strEXAPULCambioColorDescripcion').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 700,
                                                                name: 'Cambio Color',
                                                                disabled: true,
                                                                allowBlank: true,
                                                                id: 'strEXAPULCambioColorDescripcion'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: 'Vitalidad',
                                                        fieldLabel: 'Vitalidad',
                                                        width: 150,
                                                        allowBlank: false,
                                                        store: stVitalidad,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strEXAPULVitalidad'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'Tejidos Dentarios',
                                                layout: 'form',
                                                labelSeparator: "",
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Supernumerario',
                                                                fieldLabel: 'Supernumerario<br>&nbsp;',
                                                                width: 70,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strTEJIDOSupernumerario',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO"){
                                                                            Ext.getCmp('strTEJIDOSupernumerarioDescripcion').allowBlank = true;
                                                                            Ext.getCmp('strTEJIDOSupernumerarioDescripcion').setValue(null);
                                                                            Ext.getCmp('strTEJIDOSupernumerarioDescripcion').disable();
                                                                            Ext.getCmp('strTEJIDOSupernumerarioDescripcion').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strTEJIDOSupernumerarioDescripcion').enable();
                                                                            Ext.getCmp('strTEJIDOSupernumerarioDescripcion').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 700,
                                                                name: 'Supernumerario',
                                                                disabled: true,
                                                                allowBlank: true,
                                                                id: 'strTEJIDOSupernumerarioDescripcion'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Decoloracion',
                                                                fieldLabel: 'Decoloracion<br>&nbsp;',
                                                                width: 70,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strTEJIDODecoloracion',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO"){
                                                                            Ext.getCmp('strTEJIDODecoloracionDescripcion').allowBlank = true;
                                                                            Ext.getCmp('strTEJIDODecoloracionDescripcion').setValue(null);
                                                                            Ext.getCmp('strTEJIDODecoloracionDescripcion').disable();
                                                                            Ext.getCmp('strTEJIDODecoloracionDescripcion').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strTEJIDODecoloracionDescripcion').enable();
                                                                            Ext.getCmp('strTEJIDODecoloracionDescripcion').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 700,
                                                                name: 'Decoloracion',
                                                                disabled: true,
                                                                allowBlank: true,
                                                                id: 'strTEJIDODecoloracionDescripcion'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Descalsificacion',
                                                                fieldLabel: 'Descalsificacion<br>&nbsp;',
                                                                width: 70,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strTEJIDODescalsificacion',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO"){
                                                                            Ext.getCmp('strTEJIDODescalsificacionDescripcion').allowBlank = true;
                                                                            Ext.getCmp('strTEJIDODescalsificacionDescripcion').setValue(null);
                                                                            Ext.getCmp('strTEJIDODescalsificacionDescripcion').disable();
                                                                            Ext.getCmp('strTEJIDODescalsificacionDescripcion').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strTEJIDODescalsificacionDescripcion').enable();
                                                                            Ext.getCmp('strTEJIDODescalsificacionDescripcion').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 700,
                                                                name: 'Descalsificacion',
                                                                disabled: true,
                                                                allowBlank: true,
                                                                id: 'strTEJIDODescalsificacionDescripcion'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Faceta de Desgaste',
                                                                fieldLabel: 'Faceta de Desgaste',
                                                                width: 70,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strTEJIDOFacetaDesgaste',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO"){
                                                                            Ext.getCmp('strTEJIDOFacetaDesgasteDescripcion').allowBlank = true;
                                                                            Ext.getCmp('strTEJIDOFacetaDesgasteDescripcion').setValue(null);
                                                                            Ext.getCmp('strTEJIDOFacetaDesgasteDescripcion').disable();
                                                                            Ext.getCmp('strTEJIDOFacetaDesgasteDescripcion').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strTEJIDOFacetaDesgasteDescripcion').enable();
                                                                            Ext.getCmp('strTEJIDOFacetaDesgasteDescripcion').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 700,
                                                                name: 'Faceta de Desgaste',
                                                                disabled: true,
                                                                allowBlank: true,
                                                                id: 'strTEJIDOFacetaDesgasteDescripcion'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Atricion Erocion Abrasion',
                                                                fieldLabel: 'Atricion Erocion Abrasion',
                                                                width: 70,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strTEJIDOAtricionErocionAbrasion',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO"){
                                                                            Ext.getCmp('strTEJIDOAtricionErocionAbrasionDescripcion').allowBlank = true;
                                                                            Ext.getCmp('strTEJIDOAtricionErocionAbrasionDescripcion').setValue(null);
                                                                            Ext.getCmp('strTEJIDOAtricionErocionAbrasionDescripcion').disable();
                                                                            Ext.getCmp('strTEJIDOAtricionErocionAbrasionDescripcion').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strTEJIDOAtricionErocionAbrasionDescripcion').enable();
                                                                            Ext.getCmp('strTEJIDOAtricionErocionAbrasionDescripcion').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 700,
                                                                name: 'Atricion Erocion Abrasion',
                                                                disabled: true,
                                                                allowBlank: true,
                                                                id: 'strTEJIDOAtricionErocionAbrasionDescripcion'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'Examen Periodontal',
                                                layout: 'form',
                                                labelSeparator: "",
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Sagrado',
                                                                fieldLabel: 'Sagrado<br>&nbsp;',
                                                                width: 70,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strPERIOSagrado',
                                                                value: "NO",
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO"){
                                                                            Ext.getCmp('strPERIOSagradoDescripcion').allowBlank = true;
                                                                            Ext.getCmp('strPERIOSagradoDescripcion').setValue(null);
                                                                            Ext.getCmp('strPERIOSagradoDescripcion').disable();
                                                                            Ext.getCmp('strPERIOSagradoDescripcion').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strPERIOSagradoDescripcion').enable();
                                                                            Ext.getCmp('strPERIOSagradoDescripcion').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 700,
                                                                name: 'Sagrado',
                                                                disabled: true,
                                                                allowBlank: true,
                                                                id: 'strPERIOSagradoDescripcion'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Exudado y/o Supuracion',
                                                                fieldLabel: 'Exudado y/o Supuracion',
                                                                width: 70,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strPERIOExudado',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO"){
                                                                            Ext.getCmp('strPERIOExudadoDescripcion').allowBlank = true;
                                                                            Ext.getCmp('strPERIOExudadoDescripcion').setValue(null);
                                                                            Ext.getCmp('strPERIOExudadoDescripcion').disable();
                                                                            Ext.getCmp('strPERIOExudadoDescripcion').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strPERIOExudadoDescripcion').enable();
                                                                            Ext.getCmp('strPERIOExudadoDescripcion').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 700,
                                                                name: 'Exudado y/o Supuracion',
                                                                disabled: true,
                                                                allowBlank: true,
                                                                id: 'strPERIOExudadoDescripcion'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Calculos',
                                                                fieldLabel: 'Calculos<br>&nbsp;',
                                                                width: 70,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strPERIOCalculos',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO"){
                                                                            Ext.getCmp('strPERIOCalculosDescripcion').allowBlank = true;
                                                                            Ext.getCmp('strPERIOCalculosDescripcion').setValue(null);
                                                                            Ext.getCmp('strPERIOCalculosDescripcion').disable();
                                                                            Ext.getCmp('strPERIOCalculosDescripcion').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strPERIOCalculosDescripcion').enable();
                                                                            Ext.getCmp('strPERIOCalculosDescripcion').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 700,
                                                                name: 'Calculos',
                                                                disabled: true,
                                                                allowBlank: true,
                                                                id: 'strPERIOCalculosDescripcion'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Inflamacion',
                                                                fieldLabel: 'Inflamacion<br>&nbsp;',
                                                                width: 70,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strPERIOInflamacion',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO"){
                                                                            Ext.getCmp('strPERIOInflamacionDescripcion').allowBlank = true;
                                                                            Ext.getCmp('strPERIOInflamacionDescripcion').setValue(null);
                                                                            Ext.getCmp('strPERIOInflamacionDescripcion').disable();
                                                                            Ext.getCmp('strPERIOInflamacionDescripcion').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strPERIOInflamacionDescripcion').enable();
                                                                            Ext.getCmp('strPERIOInflamacionDescripcion').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 700,
                                                                name: 'Inflamacion',
                                                                disabled: true,
                                                                allowBlank: true,
                                                                id: 'strPERIOInflamacionDescripcion'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Retraccion',
                                                                fieldLabel: 'Retraccion<br>&nbsp;',
                                                                width: 70,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strPERIORefraccion',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO"){
                                                                            Ext.getCmp('strPERIORetraccionDescripcion').allowBlank = true;
                                                                            Ext.getCmp('strPERIORetraccionDescripcion').setValue(null);
                                                                            Ext.getCmp('strPERIORetraccionDescripcion').disable();
                                                                            Ext.getCmp('strPERIORetraccionDescripcion').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strPERIORetraccionDescripcion').enable();
                                                                            Ext.getCmp('strPERIORetraccionDescripcion').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 700,
                                                                name: 'Retraccion',
                                                                disabled: true,
                                                                allowBlank: true,
                                                                id: 'strPERIORetraccionDescripcion'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Bolsas',
                                                                fieldLabel: 'Bolsas<br>&nbsp;',
                                                                width: 70,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strPERIOBolsas',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO"){
                                                                            Ext.getCmp('strPERIOBolsasDescripcion').allowBlank = true;
                                                                            Ext.getCmp('strPERIOBolsasDescripcion').setValue(null);
                                                                            Ext.getCmp('strPERIOBolsasDescripcion').disable();
                                                                            Ext.getCmp('strPERIOBolsasDescripcion').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strPERIOBolsasDescripcion').enable();
                                                                            Ext.getCmp('strPERIOBolsasDescripcion').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 700,
                                                                name: 'Bolsas',
                                                                disabled: true,
                                                                allowBlank: true,
                                                                id: 'strPERIOBolsasDescripcion'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Movilidad',
                                                                fieldLabel: 'Movilidad<br>&nbsp;',
                                                                width: 70,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strPERIOMovilidad',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO"){
                                                                            Ext.getCmp('strPERIOMovilidadDescripcion').allowBlank = true;
                                                                            Ext.getCmp('strPERIOMovilidadDescripcion').setValue(null);
                                                                            Ext.getCmp('strPERIOMovilidadDescripcion').disable();
                                                                            Ext.getCmp('strPERIOMovilidadDescripcion').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strPERIOMovilidadDescripcion').enable();
                                                                            Ext.getCmp('strPERIOMovilidadDescripcion').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 700,
                                                                name: 'Movilidad',
                                                                disabled: true,
                                                                allowBlank: true,
                                                                id: 'strPERIOMovilidadDescripcion'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'combo',
                                                name: 'Tipo Oclusion',
                                                fieldLabel: 'Tipo Oclusion',
                                                width: 150,
                                                allowBlank: false,
                                                store: stOclusion,
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                id: 'strTipoOclusion'
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Lectura Radiografica',
                                                        name: 'Lectura Radiografica',
                                                        width: 70,
                                                        allowBlank: false,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: "NO",
                                                        id: 'strLecturaRx',
                                                        listeners:{
                                                            change : function( t, newValue, oldValue){
                                                                if(newValue == "NO"){
                                                                    Ext.getCmp('strLecturaRxDescripcion').allowBlank = true;
                                                                    Ext.getCmp('strLecturaRxDescripcion').setValue(null);
                                                                    Ext.getCmp('strLecturaRxDescripcion').disable();
                                                                    Ext.getCmp('strLecturaRxDescripcion').clearInvalid();
                                                                }else{
                                                                    Ext.getCmp('strLecturaRxDescripcion').enable();
                                                                    Ext.getCmp('strLecturaRxDescripcion').allowBlank = false;
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        width: 700,
                                                        name: 'Lectura Radiografica Descripcion',
                                                        disabled: true,
                                                        allowBlank: true,
                                                        id: 'strLecturaRxDescripcion'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'Diagnosticos',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'Diagnostico - Articular',
                                                        name: 'Diagnostico - Articular',
                                                        height: 100,            
                                                        allowBlank: true,
                                                        id: 'memDiagnosticoArticular'
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'Diagnostico - Pulpar',
                                                        name: 'Diagnostico - Pulpar',
                                                        height: 100,            
                                                        allowBlank: true,
                                                        id: 'memDiagnosticoPulpar'
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'Diagnostico - Periodontal',
                                                        name: 'Diagnostico - Periodontal',
                                                        height: 100,            
                                                        allowBlank: true,
                                                        id: 'memDiagnosticoPeriodontal'
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'Diagnostico - Dental',
                                                        name: 'Diagnostico - Dental',
                                                        height: 100,            
                                                        allowBlank: true,
                                                        id: 'memDiagnosticoDental'
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'Diagnostico - CyD',
                                                        name: 'Diagnostico - CyD',
                                                        height: 100,            
                                                        allowBlank: true,
                                                        id: 'memDiagnosticoCyD'
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'Diagnostico - Tejidos Blandos',
                                                        name: 'Diagnostico - Tejidos Blandos',
                                                        height: 100,            
                                                        allowBlank: true,
                                                        id: 'memDiagnosticoTejidosBlandos'
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'Diagnostico - Otros',
                                                        name: 'Diagnostico - Otros',
                                                        height: 100,            
                                                        allowBlank: true,
                                                        id: 'memDiagnosticoOtros'
                                                    },
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'CONDUCTA',
                                                layout: 'table',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'CONDUCTA',
                                                        name: 'CONDUCTA',
                                                        height: 100,            
                                                        allowBlank: true,
                                                        id: 'memConducta'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'RIPS',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                id: 'fsRips',
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: false,
                                                                fieldLabel: 'Diagnostico Principal',
                                                                id: 'sysDiagPpalHC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request({
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                        Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagPpalHCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Principal',
                                                                id: 'btnSearchDiagPpalHC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagPpalHC','sysDiagPpalHCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.1',
                                                                id: 'sysDiagRel1HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel1HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado1',
                                                                id: 'btnSearchDiagRel1HC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel1HC','sysDiagRel1HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.2',
                                                                id: 'sysDiagRel2HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel2HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado2',
                                                                id: 'btnSearchDiagRel2HC1',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel2HC','sysDiagRel2HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.3',
                                                                id: 'sysDiagRel3HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel3HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado3',
                                                                id: 'btnSearchDiagRel3HC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel3HC','sysDiagRel3HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Tipo de Diagnostico',
                                                        width:750,
                                                        name: 'Tipo de Diagnostico',
                                                        allowBlank: false,
                                                        store: 'StoreTipoDiagnostico',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        id: 'sysTipoDiagosticoHC'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Finalidad Consulta',
                                                        width:750,
                                                        name: 'Finalidad Consulta',
                                                        allowBlank: false,
                                                        store: 'StoreFinalidadConsulta',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 10,
                                                        id: 'sysFinalidadConsultaHC'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Causa Externa',
                                                        width:750,
                                                        name: 'Causa Externa',
                                                        allowBlank: false,
                                                        store: 'StoreCausaExterna',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 13,
                                                        id: 'sysCausaExternaHC'
                                                    }                            
                                                ]
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Carta Dental Inicial (LEY 38/93)',
                                autoHeight: true,
                                autoScroll: true,
                                frame: true,
                                border: false,
                                width: 1005,
                                id: 'fichaCartaDentalInicial',
                                tbar:{
                                    items: [
                                        {
                                            html: 'Tipo Denticion:'
                                        },
                                        {
                                            xtype: 'combo',
                                            width: 110,
                                            allowBlank: true,
                                            store: stTipoDenticion,
                                            valueField: 'Descripcion',
                                            displayField: 'Descripcion',
                                            mode: 'local',
                                            forceSelection: true,
                                            typeAhead: true,
                                            typeAheadDelay: 10,
                                            triggerAction: 'all',
                                            id: 'sysBtnTipoDenticion'
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Crear Odontograma',
                                            iconCls: 'btnDiente',
                                            id: 'btnCrearOdontograma',
                                            listeners:{
                                                click : function(){
                                                    if (Ext.getCmp('sysYaGuardoHC').getValue() === 0){
                                                        Ext.Msg.show({
                                                            title: 'eOfiClinic',
                                                            msg: 'Debe guardar la evolucion antes de gererar el odontograma',
                                                            buttons: Ext.Msg.OK,
                                                            icon: Ext.Msg.ERROR
                                                        });
                                                    }else{
                                                        if(Ext.getCmp('sysBtnTipoDenticion').getValue() === "" || Ext.getCmp('sysBtnTipoDenticion').getValue() === null){
                                                            Ext.Msg.show({
                                                                title: 'eOfiClinic',
                                                                msg: 'Debe seleccionar el tipo de denticion',
                                                                buttons: Ext.Msg.OK,
                                                                icon: Ext.Msg.ERROR
                                                            });
                                                        }else{
                                                            Ext.Ajax.request({
                                                                url: '../../controlador/odontograma/controlador_odontograma.php',
                                                                params:{
                                                                    task: 'OBTENER_ULTIMO_ODONTOGRAMA',
                                                                    pPaciente: wPaciente
                                                                },
                                                                success: function(response,options)
                                                                {
                                                                    var Respuesta = response.responseText;
                                                                    var Contenido = Respuesta.split('^');
                                                                    if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                                        Ext.MessageBox.show({
                                                                            title: 'eOfiClinic',
                                                                            msg: 'Ocurrio un error al validar el odontograma del paciente.',
                                                                            buttons: Ext.MessageBox.OK,
                                                                            icon: Ext.MessageBox.ERROR
                                                                        });
                                                                    } else {
                                                                        var idOdontograma = parseInt(Contenido[0]);
                                                                        var tipoOdontograma = "Inicial";
                                                                        if(idOdontograma !== 0){
                                                                            tipoOdontograma = "Control";
                                                                        }
                                                                        Ext.Ajax.request({
                                                                            url: '../../controlador/odontograma/controlador_odontograma.php',
                                                                            params:{
                                                                                task: 'CREAR_ODONTOGRAMA',
                                                                                pPaciente: wPaciente,
                                                                                pIdOdontograma: idOdontograma,
                                                                                pTipoOdontograma: tipoOdontograma,
                                                                                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                                                                                pProfesional:  Ext.getCmp('sysProfesionalHC').getValue(),
                                                                                pCAS: wCAS,
                                                                                pCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                                                                                pTipoDenticion: Ext.getCmp('sysBtnTipoDenticion').getValue(),
                                                                                pUsuario: ID_USUARIO
                                                                            },
                                                                            success: function(response,options)
                                                                            {
                                                                                var Respuesta = response.responseText;
                                                                                var Contenido = Respuesta.split('^');
                                                                                if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                                                    Ext.MessageBox.show({
                                                                                        title: 'eOfiClinic',
                                                                                        msg: 'Ocurrio un error al crear el odontograma del paciente.',
                                                                                        buttons: Ext.MessageBox.OK,
                                                                                        icon: Ext.MessageBox.ERROR
                                                                                    });
                                                                                } else {
                                                                                    Ext.getCmp('gridOdontogramasxPaciente').store.reload();
                                                                                    var updater = Ext.getCmp('OdontogramaInical').getUpdater();
                                                                                    updater.setDefaultUrl('../../../app/frm/odontograma/odontograma001.php?pPaciente=' + wPaciente + '&pCAS=' + wCAS);
                                                                                    updater.refresh();
                                                                                }
                                                                            },
                                                                            failure: function(response,options){
                                                                                Ext.MessageBox.show({
                                                                                    title: 'eOfiClinic',
                                                                                    msg: 'No podemos crear el odontograma y/o No se pudo establecer conexión con el servidor',
                                                                                    buttons: Ext.MessageBox.OK,
                                                                                    icon: Ext.MessageBox.ERROR
                                                                                });
                                                                            },
                                                                            scope:this 
                                                                        });
                                                                    }
                                                                },
                                                                failure: function(response,options){
                                                                    Ext.MessageBox.show({
                                                                        title: 'Error Conexión',
                                                                        msg: 'No podemos crear el odontograma y/o No se pudo establecer conexión con el servidor',
                                                                        buttons: Ext.MessageBox.OK,
                                                                        icon: Ext.MessageBox.ERROR
                                                                    });
                                                                },
                                                                scope:this 
                                                            });
                                                        }
                                                    }
                                                }
                                            }
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            html: '&nbsp;&nbsp;&nbsp;'
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Actualizar Odontograma',
                                            iconCls: 'btnActualizarGrid',
                                            id: 'btnUpdate',
                                            listeners:{
                                                click : function(){
                                                    var updater = Ext.getCmp('OdontogramaInical').getUpdater();
                                                    updater.setDefaultUrl('../../../app/frm/odontograma/odontograma001.php?pPaciente=' + wPaciente + '&pCAS=' + wCAS);
                                                    updater.refresh();
                                                }
                                            }
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        }
                                    ]
                                },
                                items: [
                                    {
                                        xtype: 'panel',
                                        border: false, 
                                        autoHeight: true,
                                        layout: {
                                            columns: 2,
                                            type: 'table'
                                        },
                                        items:[
                                            {
                                                xtype: 'panel',
                                                //title: 'Odontogramas',
                                                //autoHeight: true,
                                                autoScroll: true,
                                                width: 250,
                                                height: 470,
                                                frame: true,
                                                border: false,
                                                items: [
                                                    {
                                                        xtype: 'grid',
                                                        layout: 'fit',
                                                        id: 'gridOdontogramasxPaciente',
                                                        store: stGridOdontogramasxPaciente,
                                                        anchor: "100%",
                                                        height: 390,
                                                        border: false,
                                                        frame: true,
                                                        loadMask: true,
                                                        colModel: new Ext.ux.grid.LockingColumnModel([
                                                            {
                                                                xtype: 'gridcolumn',
                                                                header: 'Id',
                                                                sortable: false,
                                                                width: 100,
                                                                hidden: true,
                                                                hideable: false,
                                                                dataIndex: 'CAS',
                                                                id: 'CAS'
                                                            },
                                                            {
                                                                xtype: 'gridcolumn',
                                                                header: 'Fecha',
                                                                sortable: true,
                                                                width: 205,
                                                                dataIndex: 'FecReporte',
                                                                renderer: VerInfoOdontograma,
                                                                id: 'FecReporte'
                                                            }
                                                        ]),
                                                        selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                                                        listeners:{
                                                            rowclick : function(grid, fila, e){
                                                                var selections = grid.selModel.getSelections();
                                                                var updater = Ext.getCmp('OdontogramaInical').getUpdater();
                                                                updater.setDefaultUrl('../../../app/frm/odontograma/odontograma001.php?pPaciente=' + wPaciente + '&pCAS=' + selections[0].json.CAS);
                                                                updater.refresh();
                                                            }
                                                        }
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                layout: 'form',
                                                width: 700,
                                                height: 470,
                                                items: [
                                                    OdontogramaInical
                                                ]
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'panel',
                                        layout: 'form',
                                        items: [
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        fieldLabel: 'Tipo Denticíon',
                                                        name: 'Tipo Denticíon',
                                                        width: 200,
                                                        allowBlank: true,
                                                        readOnly: true,
                                                        id: 'strTipoDenticionOdontograma'
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'sysCOP',
                                                        value: 'COP: '
                                                    },
                                                    {
                                                        xtype: 'numberfield',
                                                        width: 100,
                                                        decimalPrecision: 0,
                                                        readOnly: true,
                                                        allowBlank: true,
                                                        name: 'COP',
                                                        id: 'intCOPOdontograma'
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'sysceo',
                                                        value: 'ceo: '
                                                    },
                                                    {
                                                        xtype: 'numberfield',
                                                        width: 100,
                                                        decimalPrecision: 0,
                                                        readOnly: true,
                                                        allowBlank: true,
                                                        name: 'ceo',
                                                        id: 'intCEOOdontograma'
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'syscopceo',
                                                        value: 'COP/ceo: '
                                                    },
                                                    {
                                                        xtype: 'numberfield',
                                                        width: 100,
                                                        decimalPrecision: 2,
                                                        readOnly: true,
                                                        allowBlank: true,
                                                        name: 'COP/ceo',
                                                        id: 'intCOPCEOOdontograma'
                                                    }
                                                ]
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Actividades Realizadas',
                                autoHeight: true,
                                autoScroll: true,
                                width: 1005,
                                frame: true,
                                border: false,
                                id: 'fichaActividades',
                                items: [
                                    {
                                        xtype: 'grid',
                                        layout: 'fit',
                                        id: 'gridDientesActividadesRealizadas',
                                        store: stGridDienteActividadesRealizadas,
                                        anchor: "100%",
                                        height: 470,
                                        border: false,
                                        frame: true,
                                        loadMask: true,
                                        colModel: new Ext.ux.grid.LockingColumnModel([
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Id',
                                                sortable: false,
                                                width: 1,
                                                hidden: true,
                                                hideable: false,
                                                dataIndex: 'IdConsecutivoDientesActividad',
                                                id: 'IdConsecutivoDientesActividad'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Fecha',
                                                sortable: true,
                                                width: 110,
                                                dataIndex: 'FechaAtencion',
                                                id: 'FechaAtencion'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Profesional',
                                                sortable: true,
                                                width: 170,
                                                dataIndex: 'Profesional',
                                                id: 'Profesional'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Diente',
                                                sortable: true,
                                                width: 60,
                                                dataIndex: 'Diente',
                                                id: 'Diente'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Superficie',
                                                sortable: true,
                                                width: 60,
                                                dataIndex: 'Superficie',
                                                id: 'Superficie'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Procedimiento/Actividad',
                                                sortable: true,
                                                width: 170,
                                                dataIndex: 'DesProced',
                                                renderer: DescripcionGrid,
                                                id: 'DesProced'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Notas Evolución',
                                                sortable: false,
                                                width: 270,
                                                dataIndex: 'NotasEvolucion',
                                                renderer: DescripcionGrid,
                                                id: 'NotasEvolucion'
                                            }
                                        ]),
                                        selModel: new Ext.grid.RowSelectionModel({singleSelect:false}),
                                        iconCls:'icon-grid',
                                        //view: new Ext.grid.GroupingView(),
                                        tbar:
                                        {
                                            xtype: 'toolbar',
                                            items: [
                                                {
                                                    xtype: 'button',
                                                    text: 'Adicionar Registro',
                                                    iconCls: 'btnAddRow',
                                                    id: 'btnAddActividadDiente',
                                                    listeners: {
                                                        click : function() {
                                                            if (Ext.getCmp('sysYaGuardoHC').getValue() == 1){
                                                                var winAddDienteActividadRealizada = new winAddDienteActividadRealizadaUi();
                                                                Ext.getCmp('intPacienteDienteActividad').setValue(Ext.getCmp('sysIdPacienteHC').getValue());
                                                                Ext.getCmp('intCASDienteActividad').setValue(Ext.getCmp('sysCASHC').getValue());
                                                                //Ext.getCmp('intProfesionalDienteActividad').setValue(Ext.getCmp('sysProfesionalHC').getValue());
                                                                Ext.getCmp('intIdProcedDienteActividad').store.load({
                                                                    params: {
                                                                        pServicio: "%ODONTOLO%"
                                                                    }
                                                                });
                                                                winAddDienteActividadRealizada.show();
                                                            }else{
                                                                Ext.Msg.show({
                                                                    title: 'eOfiClinic',
                                                                    msg: 'Usted No ha Guardado la Historia',
                                                                    buttons: Ext.Msg.OK,
                                                                    icon: Ext.Msg.ERROR
                                                                });
                                                            }
                                                        }
                                                    }
                                                },
                                                {
                                                    xtype: 'tbseparator'
                                                },
                                                {
                                                    xtype: 'button',
                                                    text: 'Eliminar Registro',
                                                    iconCls: 'btnDelRow',
                                                    id: 'btnDelActividadDiente',
                                                    listeners: {
                                                        click : function() {
                                                            if(Ext.getCmp('gridDientesActividadesRealizadas').selModel.getCount() == 1)
                                                            {
                                                                var selections = Ext.getCmp('gridDientesActividadesRealizadas').selModel.getSelections();
                                                                if(selections[0].json.CAS == Ext.getCmp('sysCASHC').getValue()){
                                                                    Ext.Msg.show({
                                                                        title: 'Actividades Realizadas en el Diente: ' + selections[0].json.Diente,
                                                                        msg: 'Esta Seguro que Desea Eliminar el Registro ' + selections[0].json.DesProced + '?',
                                                                        buttons: Ext.Msg.YESNO,
                                                                        icon: Ext.Msg.QUESTION,
                                                                        fn: function(btn)
                                                                        {
                                                                            if(btn=="yes")
                                                                            {
                                                                                fnEliminarRegistros("../../controlador/asistencial/controlador_odontologia.php",{task: "ELIMINAR_DIENTE_ACTIVIDAD", pIdRegistroActividadDiente: selections[0].json.IdConsecutivoDientesActividad}, 'gridDientesActividadesRealizadas');
                                                                            }
                                                                        }
                                                                    });
                                                                }else{
                                                                    Ext.MessageBox.show({
                                                                        title: 'Error',
                                                                        msg: 'Este Registro No Fue Creado por Usted y No Se Puede Eliminar',
                                                                        buttons: Ext.MessageBox.OK,
                                                                        icon: Ext.MessageBox.ERROR
                                                                    });
                                                                }
                                                            }else{
                                                                Ext.MessageBox.show({
                                                                    title: 'Error',
                                                                    msg: 'No podemos eliminar los registros en estos momentos, verifique que solo haya seleccionado un registro',
                                                                    buttons: Ext.MessageBox.OK,
                                                                    icon: Ext.MessageBox.ERROR
                                                                });
                                                            }
                                                        }
                                                    }
                                                },
                                                {
                                                    xtype: 'tbseparator'
                                                }
                                            ]
                                        }
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Actividades Proxima Cita',
                                autoHeight: true,
                                autoScroll: true,
                                width: 1005,
                                frame: true,
                                border: false,
                                id: 'fichaActividadesProximaCita',
                                items: [
                                    {
                                        xtype: 'panel',
                                        border: false, 
                                        autoHeight: true,
                                        layout: {
                                            columns: 2,
                                            type: 'table'
                                        },
                                        items:[
                                            {
                                                xtype: 'panel',
                                                title: 'Atenciones',
                                                //autoHeight: true,
                                                autoScroll: true,
                                                width: 250,
                                                height: 460,
                                                frame: true,
                                                border: false,
                                                items: [
                                                    {
                                                        xtype: 'grid',
                                                        layout: 'fit',
                                                        id: 'gridAtencionesProximaCitaxPaciente',
                                                        store: stGridOdontogramasxPaciente,
                                                        anchor: "100%",
                                                        height: 405,
                                                        border: false,
                                                        frame: true,
                                                        loadMask: true,
                                                        colModel: new Ext.ux.grid.LockingColumnModel([
                                                            {
                                                                xtype: 'gridcolumn',
                                                                header: 'Id',
                                                                sortable: false,
                                                                width: 100,
                                                                hidden: true,
                                                                hideable: false,
                                                                dataIndex: 'CAS',
                                                                id: 'CASProxCita'
                                                            },
                                                            {
                                                                xtype: 'gridcolumn',
                                                                header: 'Fecha',
                                                                sortable: true,
                                                                width: 205,
                                                                dataIndex: 'FecReporte',
                                                                renderer: VerInfoOdontograma,
                                                                id: 'FecReporteProxCita'
                                                            }
                                                        ]),
                                                        selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                                                        listeners:{
                                                            rowclick : function(grid, fila, e){
                                                                alert("Ver Items Proxima Cita");
                                                            }
                                                        }
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                layout: 'form',
                                                width: 700,
                                                height: 460,
                                                items: [
                                                    {
                                                        xtype: 'grid',
                                                        layout: 'fit',
                                                        id: 'gridDientesActividadesProximaCita',
                                                        store: stGridDienteActividadesProxCita,
                                                        anchor: "100%",
                                                        height: 460,
                                                        border: false,
                                                        frame: true,
                                                        loadMask: true,
                                                        colModel: new Ext.ux.grid.LockingColumnModel([
                                                            {
                                                                xtype: 'gridcolumn',
                                                                header: 'Id',
                                                                sortable: false,
                                                                width: 1,
                                                                hidden: true,
                                                                hideable: false,
                                                                dataIndex: 'IdConsecutivoDientesProxCita',
                                                                id: 'IdConsecutivoDientesProxCita'
                                                            },
                                                            {
                                                                xtype: 'gridcolumn',
                                                                header: 'Diente',
                                                                sortable: true,
                                                                width: 60,
                                                                dataIndex: 'Diente',
                                                                id: 'DienteProxCita'
                                                            },
                                                            {
                                                                xtype: 'gridcolumn',
                                                                header: 'Superficie',
                                                                sortable: true,
                                                                width: 60,
                                                                dataIndex: 'Superficie',
                                                                id: 'SuperficieProxCita'
                                                            },
                                                            {
                                                                xtype: 'gridcolumn',
                                                                header: 'Procedimiento/Actividad',
                                                                sortable: true,
                                                                width: 270,
                                                                dataIndex: 'DesProced',
                                                                renderer: DescripcionGrid,
                                                                id: 'DesProcedProxCita'
                                                            },
                                                            {
                                                                xtype: 'gridcolumn',
                                                                header: 'Copago',
                                                                sortable: false,
                                                                width: 120,
                                                                dataIndex: 'VlrCopago',
                                                                id: 'VlrCopagoProxCita'
                                                            }
                                                        ]),
                                                        selModel: new Ext.grid.RowSelectionModel({singleSelect:false}),
                                                        iconCls:'icon-grid',
                                                        //view: new Ext.grid.GroupingView(),
                                                        tbar:
                                                        {
                                                            xtype: 'toolbar',
                                                            items: [
                                                                {
                                                                    xtype: 'button',
                                                                    text: 'Adicionar Registro',
                                                                    iconCls: 'btnAddRow',
                                                                    id: 'btnAddProxCitaDiente',
                                                                    listeners: {
                                                                        click : function() {
                                                                            if (Ext.getCmp('sysYaGuardoHC').getValue() == 1){
                                                                                var winAddDienteActividadRealizada = new winAddDienteActividadRealizadaUi();
                                                                                Ext.getCmp('intPacienteDienteActividad').setValue(Ext.getCmp('sysIdPacienteHC').getValue());
                                                                                Ext.getCmp('intCASDienteActividad').setValue(Ext.getCmp('sysCASHC').getValue());
                                                                                //Ext.getCmp('intProfesionalDienteActividad').setValue(Ext.getCmp('sysProfesionalHC').getValue());
                                                                                Ext.getCmp('intIdProcedDienteActividad').store.load({
                                                                                    params: {
                                                                                        pServicio: "%ODONTOLO%"
                                                                                    }
                                                                                });
                                                                                winAddDienteActividadRealizada.show();
                                                                            }else{
                                                                                Ext.Msg.show({
                                                                                    title: 'eOfiClinic',
                                                                                    msg: 'Usted No ha Guardado la Historia',
                                                                                    buttons: Ext.Msg.OK,
                                                                                    icon: Ext.Msg.ERROR
                                                                                });
                                                                            }
                                                                        }
                                                                    }
                                                                },
                                                                {
                                                                    xtype: 'tbseparator'
                                                                },
                                                                {
                                                                    xtype: 'button',
                                                                    text: 'Eliminar Registro',
                                                                    iconCls: 'btnDelRow',
                                                                    id: 'btnDelProxCitaDiente',
                                                                    listeners: {
                                                                        click : function() {
                                                                            if(Ext.getCmp('gridDientesActividadesRealizadas').selModel.getCount() == 1)
                                                                            {
                                                                                var selections = Ext.getCmp('gridDientesActividadesRealizadas').selModel.getSelections();
                                                                                if(selections[0].json.CAS == Ext.getCmp('sysCASHC').getValue()){
                                                                                    Ext.Msg.show({
                                                                                        title: 'Actividades Realizadas en el Diente: ' + selections[0].json.Diente,
                                                                                        msg: 'Esta Seguro que Desea Eliminar el Registro ' + selections[0].json.DesProced + '?',
                                                                                        buttons: Ext.Msg.YESNO,
                                                                                        icon: Ext.Msg.QUESTION,
                                                                                        fn: function(btn)
                                                                                        {
                                                                                            if(btn=="yes")
                                                                                            {
                                                                                                fnEliminarRegistros("../../controlador/asistencial/controlador_odontologia.php",{task: "ELIMINAR_DIENTE_ACTIVIDAD", pIdRegistroActividadDiente: selections[0].json.IdConsecutivoDientesActividad}, 'gridDientesActividadesRealizadas');
                                                                                            }
                                                                                        }
                                                                                    });
                                                                                }else{
                                                                                    Ext.MessageBox.show({
                                                                                        title: 'Error',
                                                                                        msg: 'Este Registro No Fue Creado por Usted y No Se Puede Eliminar',
                                                                                        buttons: Ext.MessageBox.OK,
                                                                                        icon: Ext.MessageBox.ERROR
                                                                                    });
                                                                                }
                                                                            }else{
                                                                                Ext.MessageBox.show({
                                                                                    title: 'Error',
                                                                                    msg: 'No podemos eliminar los registros en estos momentos, verifique que solo haya seleccionado un registro',
                                                                                    buttons: Ext.MessageBox.OK,
                                                                                    icon: Ext.MessageBox.ERROR
                                                                                });
                                                                            }
                                                                        }
                                                                    }
                                                                },
                                                                {
                                                                    xtype: 'tbseparator'
                                                                }
                                                            ]
                                                        }
                                                    }
                                                ]
                                            }
                                        ]
                                    }
                                ]
                            }
                        ]
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btnSalirEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 1) 
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHCOdontologia001').close();
                                                }
                                            }
                                        });
                                    else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Usted No ha Guardado la Evolución del Paciente y Se Perdera la Información, Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHCOdontologia001').close();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                },
                tbar:{
                    items: [
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Ver Historia Clínica',
                            iconCls: 'btnVerHC',
                            id: 'btnVerHC',
                            listeners:{
                                click : function(){
                                    var cmpResumenHC = new winFrmVerHistorialHC({
                                        renderTo: Ext.getBody()
                                    });
                                    Ext.getCmp('winViewEvolucionHC').title = "PACIENTE: " + Ext.getCmp('sysPacienteHC').getValue();
                                    Ext.getCmp('gridHistorialEvoluciones').store.load({
                                        params: {
                                            pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                                            pPaciente: Ext.getCmp('sysIdPacienteHC').getValue()
                                        }
                                    });
                                    cmpResumenHC.show();
                                }
                            }
                        },
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar Evolución',
                            iconCls: 'btnGuardar',
                            id: 'btnGuardarEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 0) 
                                    {
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Guardar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnGuardarRegistrosMedicinaGeneral();
                                                }
                                            }
                                        });
                                    }else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Modificar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnModificarRegistrosMedicinaGeneral();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                }
            }
        ];
        winHCOdontologia001Ui.superclass.initComponent.call(this);
    }
});

function fnGuardarRegistrosMedicinaGeneral(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc.php',
            params:{
                task: 'guardar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pidPlantillaHC : Ext.getCmp('sysIdCodPlantillaHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1); 
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function fnModificarRegistrosMedicinaGeneral(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc.php',
            params:{
                task: 'modificar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}
