/*
* @category    Formulario Modelo Entrevista Aptitud Mental
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winEntrevistaAptitudMental001Ui = Ext.extend(Ext.Window, {
    title: 'eOfiClinic ©  .:: Plantilla Ficha tecnica de Entrevista Aptitud Mental ::.',
    width: 990,
    height: 636,
    closable: false,
    resizable: false,
    draggable: false,
    modal: true,
    id: 'winHC',
    initComponent: function() {

        tmpmx = objMX;
        tmpmxadd = objMXADD;
        tmpexa = objEXA;
        tmprem = objREM;
        myPaciente = 0;
        myCAS = 0;
        
        try {
            var campo = Ext.getCmp('sysPacientePlantillaHC');
            if ( campo != null ) {
                myPaciente = Ext.getCmp('sysPacientePlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myPaciente == 0){
            try {
                var campo1 = Ext.getCmp('sysIdPacienteHC');
                if ( campo1 != null ) {
                    myPaciente = Ext.getCmp('sysIdPacienteHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myPaciente == 0){
            try {
                var campo5 = Ext.getCmp('sysPacienteRefHC');
                if ( campo5 != null ) {
                    myPaciente = Ext.getCmp('sysPacienteRefHC').getValue();
                }
            }catch(ex){
            }
        }
        try {
            var campo2 = Ext.getCmp('sysCASPlantillaHC');
            if ( campo2 != null ) {
                myCAS = Ext.getCmp('sysCASPlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myCAS == 0){
            try {
                var campo3 = Ext.getCmp('sysCASHC');
                if ( campo3 != null ) {
                    myCAS = Ext.getCmp('sysCASHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myCAS == 0){
            try {
                var campo4 = Ext.getCmp('sysCASRefHC');
                if ( campo4 != null ) {
                    myCAS = Ext.getCmp('sysCASRefHC').getValue();
                }
            }catch(ex){
            }
        }
        
        if (objMX != "NA"){
            var xSolMX = eval(objMX);
            Ext.getCmp('gridMedicamentosHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }
        else{
            var xSolMX = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        if (objEXA != "NA"){
            var xSolEXA = eval(objEXA);
            Ext.getCmp('gridExamenesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }else{
            var xSolEXA = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }    
        if (objREM != "NA"){
            var xSolREM = eval(objREM);
            Ext.getCmp('gridRemisionesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }else{
            var xSolREM = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        
        
        var dataEstadoCivil = [
            ['SOLTERO(A)'],
            ['CASADO(A)'],
            ['UNION LIBRE'],
            ['SEPARADO'],
            ['VIUDO (A)'],
            ['OTRO']
        ];
        var stEstadoCivil = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stEstadoCivil.loadData(dataEstadoCivil);
        
        
        var dataVivienda = [
            ['PROPIA'],
            ['FAMILIAR'],
            ['ALQUILADA']
        ];
        var stVivienda = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stVivienda.loadData(dataVivienda);
        
        var dataConsumos = [
            ['SI'],
            ['NO'],
            ['OCACIONAL']
        ];
        var stConsumos = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stConsumos.loadData(dataConsumos);
        
        var dataEvaluacion = [
            ['EXCELENTE (E)'],
            ['BUENO (B)'],
            ['REGULAR (R)'],
            ['DEFICIENTE (D)']
        ];
        var stEvaluacion = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stEvaluacion.loadData(dataEvaluacion);
            
        this.items = [
            {
                xtype: 'panel',
                frame: true,
                anchor: '100%',
                id: 'panelHC',
                padding: 10,
                border: false,
                height: 610,
                autoScroll: true,
                layout: 'form',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysIdCodPlantillaHC'
                    },
                     {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        value: 1,
                        id: 'sysUsaGridSalida'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        value: 0,
                        id: 'sysYaGuardoHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysPlantillaHC',
                        name: 'PLANTILLA'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptMx'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptExa'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptRem'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Actividad',
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        id: 'sysActividadHC',
                        name: 'PLANTILLA'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Empresa',
                        id: 'sysEmpresaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'IPS',
                        id: 'sysIPSHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Usuario',
                        id: 'sysUsuarioHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Profesional',
                        id: 'sysProfesionalHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Paciente',
                        id: 'sysIdPacienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Apertura',
                        id: 'sysAperturaHC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Cliente',
                        id: 'sysClienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdClienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdPlanHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdSubPlanHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdContratoHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Genero',
                        id: 'sysGeneroPacHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Edad',
                        id: 'sysEdadPacHC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Profesional',
                        id: 'sysProfesionalAgendaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'ConsecutivoDetalle',
                        id: 'sysConsecutivoDetalleHC'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'CAS',
                                id: 'sysCASHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysFechaHC',
                                value: 'Fecha: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysFechaHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysHoraHC',
                                value: 'Hora: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysHoraHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysLegalizacionHC',
                                value: 'Legalización: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysLegalizaHC'
                            }
                        ]
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                width: 100,
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'Genero',
                                id: 'sysGeneroHC'
                            },
                            {
                                html: 'Fecha Nac:'
                            },
                            {
                                xtype: 'textfield',
                                width: 100,
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysFechaNac'
                            },
                            {
                                html: 'Edad:'
                            },
                            {
                                xtype: 'textfield',
                                width: 350,
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysEdadHC'
                            }
                        ]
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Paciente',
                        value: 'CC 792558261  - JORGE GALEANO RUIZ - (Masculino) FechaNac: 1973-01-30, Edad 38 Años',
                        id: 'sysPacienteHC'
                    },
                    {
                        html: '<hr>',
                        style: 'background:transparent;',
                        border: false
                    },
                    {
                        xtype: 'tabpanel',
                        width: 930,
                        autoHeight: true,
                        border: false,
                        ref: 'fTabPanel',
                        id: 'fTabPanel',
                        activeTab: 0,
                        items: [
                            {
                                xtype: 'panel',
                                title: 'Evolución',
                                autoHeight: true,
                                autoScroll: true,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaEvolucion',
                                layout: 'form',
                                items: [
                                    {
                                        xtype: 'form',
                                        frame: true,
                                        anchor: '100%',
                                        id: 'frmHC',
                                        padding: 10,
                                        border: false,
                                        autoScroll: true,
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        fieldLabel: 'Acompañante',
                                                        name: 'Acompañante',
                                                        width: 350,
                                                        allowBlank: true,
                                                        id: 'strDATINGPROGAcompanante'
                                                    },
                                                    {
                                                        html: '   Parentesco:'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: 'Parentezco',
                                                        width: 350,
                                                        allowBlank: true,
                                                        store: stParentesco,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strDATINGPROGParentesco'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'COMPOSICION FAMILIAR',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Estado Civil',
                                                                fieldLabel: 'Estado Civil',
                                                                width: 150,
                                                                allowBlank: false,
                                                                store: stEstadoCivil,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strEstadoCivil'
                                                            },
                                                            {
                                                                html: 'Tiempo:'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Tiempo',
                                                                width: 250,
                                                                allowBlank: true,
                                                                id: 'strTiempoEstadoCivil'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        autoHeight: true,
                                                        anchor: '100%',
                                                        layout: {
                                                            columns: 5,
                                                            type: 'table'
                                                        },
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                autoHeight: true,
                                                                title: '<center>PARENTESCO<br>&nbsp;</center>',
                                                                width: 110,
                                                                labelWidth: 1,
                                                                layout: {
                                                                    type: 'form'
                                                                },
                                                                items: [
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Parentesco',
                                                                        width: 100,
                                                                        allowBlank: true,
                                                                        id: 'strParentesco_1'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Parentesco',
                                                                        width: 100,
                                                                        allowBlank: true,
                                                                        id: 'strParentesco_2'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Parentesco',
                                                                        width: 100,
                                                                        allowBlank: true,
                                                                        id: 'strParentesco_3'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Parentesco',
                                                                        width: 100,
                                                                        allowBlank: true,
                                                                        id: 'strParentesco_4'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Parentesco',
                                                                        width: 100,
                                                                        allowBlank: true,
                                                                        id: 'strParentesco_5'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                autoHeight: true,
                                                                title: '<center>NOMBRE<br>&nbsp;</center>',
                                                                width: 310,
                                                                labelWidth: 1,
                                                                layout: {
                                                                    type: 'form'
                                                                },
                                                                items: [
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Nombre',
                                                                        width: 300,
                                                                        allowBlank: true,
                                                                        id: 'strNombre_1'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Nombre',
                                                                        width: 300,
                                                                        allowBlank: true,
                                                                        id: 'strNombre_2'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Nombre',
                                                                        width: 300,
                                                                        allowBlank: true,
                                                                        id: 'strNombre_3'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Nombre',
                                                                        width: 300,
                                                                        allowBlank: true,
                                                                        id: 'strNombre_4'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Nombre',
                                                                        width: 300,
                                                                        allowBlank: true,
                                                                        id: 'strNombre_5'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                autoHeight: true,
                                                                title: '<center>EDAD<br>&nbsp;</center>',
                                                                width: 80,
                                                                labelWidth: 1,
                                                                layout: {
                                                                    type: 'form'
                                                                },
                                                                items: [
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        name: 'Edad',
                                                                        width: 70,
                                                                        decimalPrecision: 0,
                                                                        allowBlank: true,
                                                                        id: 'intEdad_1'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        name: 'Edad',
                                                                        width: 70,
                                                                        decimalPrecision: 0,
                                                                        allowBlank: true,
                                                                        id: 'intEdad_2'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        name: 'Edad',
                                                                        width: 70,
                                                                        decimalPrecision: 0,
                                                                        allowBlank: true,
                                                                        id: 'intEdad_3'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        name: 'Edad',
                                                                        width: 70,
                                                                        decimalPrecision: 0,
                                                                        allowBlank: true,
                                                                        id: 'intEdad_4'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        name: 'Edad',
                                                                        width: 70,
                                                                        decimalPrecision: 0,
                                                                        allowBlank: true,
                                                                        id: 'intEdad_5'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                autoHeight: true,
                                                                title: '<center>OCUPACION<br>&nbsp;</center>',
                                                                width: 210,
                                                                labelWidth: 1,
                                                                layout: {
                                                                    type: 'form'
                                                                },
                                                                items: [
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Ocupacion',
                                                                        width: 200,
                                                                        allowBlank: true,
                                                                        id: 'strOcupacion_1'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Ocupacion',
                                                                        width: 200,
                                                                        allowBlank: true,
                                                                        id: 'strOcupacion_2'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Ocupacion',
                                                                        width: 200,
                                                                        allowBlank: true,
                                                                        id: 'strOcupacion_3'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Ocupacion',
                                                                        width: 200,
                                                                        allowBlank: true,
                                                                        id: 'strOcupacion_4'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Ocupacion',
                                                                        width: 200,
                                                                        allowBlank: true,
                                                                        id: 'strOcupacion_5'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                autoHeight: true,
                                                                title: '<center>VIVE CON EL ENTREVISTADO</center>',
                                                                width: 120,
                                                                labelWidth: 1,
                                                                layout: {
                                                                    type: 'form'
                                                                },
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Vive con Entrevistado',
                                                                        width: 110,
                                                                        allowBlank: true,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strViveEntrevistado_1'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Vive con Entrevistado',
                                                                        width: 110,
                                                                        allowBlank: true,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strViveEntrevistado_2'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Vive con Entrevistado',
                                                                        width: 110,
                                                                        allowBlank: true,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strViveEntrevistado_3'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Vive con Entrevistado',
                                                                        width: 110,
                                                                        allowBlank: true,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strViveEntrevistado_4'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Vive con Entrevistado',
                                                                        width: 110,
                                                                        allowBlank: true,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strViveEntrevistado_5'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Personas a Cargo',
                                                                fieldLabel: 'Personas a Cargo',
                                                                width: 110,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strPersonasaCargo',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO"){
                                                                            Ext.getCmp('intPersonasaCargoCuantos').disable();
                                                                            Ext.getCmp('intPersonasaCargoCuantos').allowBlank = true;
                                                                            Ext.getCmp('intPersonasaCargoCuantos').clearInvalid();
                                                                            Ext.getCmp('strPersonasaCargoParentesco').disable();
                                                                            Ext.getCmp('strPersonasaCargoParentesco').allowBlank = true;
                                                                            Ext.getCmp('strPersonasaCargoParentesco').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('intPersonasaCargoCuantos').enable();
                                                                            Ext.getCmp('intPersonasaCargoCuantos').allowBlank = false;
                                                                            Ext.getCmp('strPersonasaCargoParentesco').enable();
                                                                            Ext.getCmp('strPersonasaCargoParentesco').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html: 'Cuantos'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'Cuantos',
                                                                width: 70,
                                                                decimalPrecision: 0,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                id: 'intPersonasaCargoCuantos'
                                                            },
                                                            {
                                                                html: 'Parentesco'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Parentesco',
                                                                width: 100,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                id: 'strPersonasaCargoParentesco'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: 'Vivienda',
                                                        fieldLabel: 'Vivienda',
                                                        width: 150,
                                                        allowBlank: false,
                                                        store: stVivienda,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strVivienda'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'FORMACION ACADEMICA',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'panel',
                                                        autoHeight: true,
                                                        anchor: '100%',
                                                        layout: {
                                                            columns: 4,
                                                            type: 'table'
                                                        },
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                autoHeight: true,
                                                                title: '<center>TITULO OBTENIDO<br>&nbsp;</center>',
                                                                width: 310,
                                                                labelWidth: 1,
                                                                layout: {
                                                                    type: 'form'
                                                                },
                                                                items: [
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Titulo',
                                                                        width: 300,
                                                                        allowBlank: true,
                                                                        id: 'strTitulo_1'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Titulo',
                                                                        width: 300,
                                                                        allowBlank: true,
                                                                        id: 'strTitulo_2'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Titulo',
                                                                        width: 300,
                                                                        allowBlank: true,
                                                                        id: 'strTitulo_3'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                autoHeight: true,
                                                                title: '<center>AÑO GRADUCACION</center>',
                                                                width: 100,
                                                                labelWidth: 1,
                                                                layout: {
                                                                    type: 'form'
                                                                },
                                                                items: [
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        name: 'Año Graducacion',
                                                                        width: 90,
                                                                        decimalPrecision: 0,
                                                                        allowBlank: true,
                                                                        id: 'intAnoGraducacion_1'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        name: 'Año Graducacion',
                                                                        width: 90,
                                                                        decimalPrecision: 0,
                                                                        allowBlank: true,
                                                                        id: 'intAnoGraducacion_2'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        name: 'Año Graducacion',
                                                                        width: 90,
                                                                        decimalPrecision: 0,
                                                                        allowBlank: true,
                                                                        id: 'intAnoGraducacion_3'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                autoHeight: true,
                                                                title: '<center>NOMBRE INSTITUCION<br>&nbsp;</center>',
                                                                width: 210,
                                                                labelWidth: 1,
                                                                layout: {
                                                                    type: 'form'
                                                                },
                                                                items: [
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Nombre Institucion',
                                                                        width: 200,
                                                                        allowBlank: true,
                                                                        id: 'strNombreInstitucion_1'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Nombre Institucion',
                                                                        width: 200,
                                                                        allowBlank: true,
                                                                        id: 'strNombreInstitucion_2'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Nombre Institucion',
                                                                        width: 200,
                                                                        allowBlank: true,
                                                                        id: 'strNombreInstitucion_3'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                autoHeight: true,
                                                                title: '<center>CIUDAD<br>&nbsp;</center>',
                                                                width: 210,
                                                                labelWidth: 1,
                                                                layout: {
                                                                    type: 'form'
                                                                },
                                                                items: [
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Ciudad',
                                                                        width: 200,
                                                                        allowBlank: true,
                                                                        id: 'strCiudad_1'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Ciudad',
                                                                        width: 200,
                                                                        allowBlank: true,
                                                                        id: 'strCiudad_2'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Ciudad',
                                                                        width: 200,
                                                                        allowBlank: true,
                                                                        id: 'strCiudad_3'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: 'Estudia Actualmente',
                                                        fieldLabel: 'Estudia Actualmente',
                                                        width: 110,
                                                        allowBlank: false,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strEstudiaActualmente'
                                                    },
                                                    {
                                                        xtype: 'radiogroup',
                                                        fieldLabel: 'Cual fue el mas alto nivel educativo que tuvo?',
                                                        name: 'Cual fue el mas alto nivel educativo que tuvo?',
                                                        columns: 3,
                                                        vertical: true,
                                                        id: 'strNivelEducativo',
                                                        items: [
                                                            {
                                                                boxLabel: 'Analfabeta',
                                                                name: 'strNivelEducativo',
                                                                inputValue: 'Analfabeta'
                                                            },
                                                            {
                                                                boxLabel: 'Solamente Apendio a Leer y Escribir',
                                                                name: 'strNivelEducativo',
                                                                inputValue: 'Solamente Apendio a Leer y Escribir'
                                                            },
                                                            {
                                                                boxLabel: 'Menos que Primaria',
                                                                name: 'strNivelEducativo',
                                                                inputValue: 'Menos que Primaria'
                                                            },
                                                            {
                                                                boxLabel: 'Primaria',
                                                                name: 'strNivelEducativo',
                                                                inputValue: 'Primaria'
                                                            },
                                                            {
                                                                boxLabel: 'Menos que Secundaria',
                                                                name: 'strNivelEducativo',
                                                                inputValue: 'Menos que Secundaria'
                                                            },
                                                            {
                                                                boxLabel: 'Secundaria',
                                                                name: 'strNivelEducativo',
                                                                inputValue: 'Secundaria'
                                                            },
                                                            {
                                                                boxLabel: 'Universidad o Equivalente',
                                                                name: 'strNivelEducativo',
                                                                inputValue: 'Universidad o Equivalente'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'textfield',
                                                anchor: '100%',
                                                fieldLabel: 'EXPERENCIA DEL CONDUCTOR EN CONDUCCION EN TRANSPORTE URBANO?',
                                                name: 'EXPERENCIA DEL CONDUCTOR EN CONDUCCION EN TRANSPORTE URBANO?',
                                                height: 100,
                                                allowBlank: false,
                                                id: 'strExperienciaConductor'
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'DESCRIPCION PERSONAL',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        fieldLabel: 'Aspectos Positivos (5)',
                                                        name: 'Aspectos Positivos (5)',
                                                        height: 100,
                                                        allowBlank: false,
                                                        id: 'memAspectosPositivos'
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        fieldLabel: 'Aspectos por Mejorar (3)',
                                                        name: 'Aspectos por Mejorar (3)',
                                                        height: 100,
                                                        allowBlank: false,
                                                        id: 'memAspectosMejorar'
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        fieldLabel: 'Mayor Limitante Personalidad',
                                                        name: 'Mayor Limitante Personalidad',
                                                        height: 100,
                                                        allowBlank: false,
                                                        id: 'memLimitantePersonalidad'
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        fieldLabel: 'Describa como se ven en 5 años',
                                                        name: 'Describa como se ven en 5 años',
                                                        height: 100,
                                                        allowBlank: false,
                                                        id: 'memDescripcion5anos'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'ASPECTO MEDICO',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Padece alguna Enfermedad',
                                                                fieldLabel: 'Padece alguna Enfermedad',
                                                                width: 110,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strPadeceEnfermedad',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO"){
                                                                            Ext.getCmp('strPadeceEnfermedadCual').disable();
                                                                            Ext.getCmp('strPadeceEnfermedadCual').allowBlank = true;
                                                                            Ext.getCmp('strPadeceEnfermedadCual').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strPadeceEnfermedadCual').enable();
                                                                            Ext.getCmp('strPadeceEnfermedadCual').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html: 'Cual'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Cual',
                                                                width: 260,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                id: 'strPadeceEnfermedadCual'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Toma algun Medicamento',
                                                                fieldLabel: 'Toma algun Medicamento',
                                                                width: 110,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strTomaMedicamento',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO"){
                                                                            Ext.getCmp('strTomaMedicamentoCual').disable();
                                                                            Ext.getCmp('strTomaMedicamentoCual').allowBlank = true;
                                                                            Ext.getCmp('strTomaMedicamentoCual').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strTomaMedicamentoCual').enable();
                                                                            Ext.getCmp('strTomaMedicamentoCual').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html: 'Cual'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Cual',
                                                                width: 260,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                id: 'strTomaMedicamentoCual'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Fuma',
                                                                fieldLabel: 'Fuma',
                                                                width: 110,
                                                                allowBlank: false,
                                                                store: stConsumos,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strFuma'
                                                            },
                                                            {
                                                                html: 'Alcohol'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Alcohol',
                                                                width: 110,
                                                                allowBlank: false,
                                                                store: stConsumos,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strAlcohol'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            /*{
                                                xtype: 'fieldset',
                                                title: 'ASPECTO EVALUADO',
                                                layout: 'form',
                                                labelSeparator: ' ',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Puntualidad',
                                                                fieldLabel: 'Puntualidad<br>&nbsp;',
                                                                width: 150,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strPuntualidad',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO"){
                                                                            Ext.getCmp('strPuntualidadObservaciones').allowBlank = true;
                                                                            Ext.getCmp('strPuntualidadObservaciones').setValue(null);
                                                                            Ext.getCmp('strPuntualidadObservaciones').disable();
                                                                            Ext.getCmp('strPuntualidadObservaciones').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strPuntualidadObservaciones').enable();
                                                                            Ext.getCmp('strPuntualidadObservaciones').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html: 'Observaciones'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Observaciones',
                                                                width: 500,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                id: 'strPuntualidadObservaciones'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Presentacion Personal',
                                                                fieldLabel: 'Presentacion Personal',
                                                                width: 150,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strPresentacionPersonal',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO"){
                                                                            Ext.getCmp('strPresentacionPersonalObservaciones').allowBlank = true;
                                                                            Ext.getCmp('strPresentacionPersonalObservaciones').setValue(null);
                                                                            Ext.getCmp('strPresentacionPersonalObservaciones').disable();
                                                                            Ext.getCmp('strPresentacionPersonalObservaciones').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strPresentacionPersonalObservaciones').enable();
                                                                            Ext.getCmp('strPresentacionPersonalObservaciones').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html: 'Observaciones'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Observaciones',
                                                                width: 500,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                id: 'strPresentacionPersonalObservaciones'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Facilidad de Expresion',
                                                                fieldLabel: 'Facilidad de Expresion',
                                                                width: 150,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strFacilidadExpresion',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO"){
                                                                            Ext.getCmp('strFacilidadExpresionObservaciones').allowBlank = true;
                                                                            Ext.getCmp('strFacilidadExpresionObservaciones').setValue(null);
                                                                            Ext.getCmp('strFacilidadExpresionObservaciones').disable();
                                                                            Ext.getCmp('strFacilidadExpresionObservaciones').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strFacilidadExpresionObservaciones').enable();
                                                                            Ext.getCmp('strFacilidadExpresionObservaciones').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html: 'Observaciones'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Observaciones',
                                                                width: 500,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                id: 'strFacilidadExpresionObservaciones'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Actitud General',
                                                                fieldLabel: 'Actitud General<br>&nbsp;',
                                                                width: 150,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strActitudGeneral',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO"){
                                                                            Ext.getCmp('strActitudGeneralObservaciones').allowBlank = true;
                                                                            Ext.getCmp('strActitudGeneralObservaciones').setValue(null);
                                                                            Ext.getCmp('strActitudGeneralObservaciones').disable();
                                                                            Ext.getCmp('strActitudGeneralObservaciones').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strActitudGeneralObservaciones').enable();
                                                                            Ext.getCmp('strActitudGeneralObservaciones').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html: 'Observaciones'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Observaciones',
                                                                width: 500,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                id: 'strActitudGeneralObservaciones'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Interes hacia el Trabajo',
                                                                fieldLabel: 'Interes hacia el Trabajo',
                                                                width: 150,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strInteresTrabajo',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO"){
                                                                            Ext.getCmp('strInteresTrabajoObservaciones').allowBlank = true;
                                                                            Ext.getCmp('strInteresTrabajoObservaciones').setValue(null);
                                                                            Ext.getCmp('strInteresTrabajoObservaciones').disable();
                                                                            Ext.getCmp('strInteresTrabajoObservaciones').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strInteresTrabajoObservaciones').enable();
                                                                            Ext.getCmp('strInteresTrabajoObservaciones').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html: 'Observaciones'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Observaciones',
                                                                width: 500,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                id: 'strInteresTrabajoObservaciones'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Manejo Ansiedad',
                                                                fieldLabel: 'Manejo Ansiedad',
                                                                width: 150,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strManejoAnsiedad',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO"){
                                                                            Ext.getCmp('strManejoAnsiedadObservaciones').allowBlank = true;
                                                                            Ext.getCmp('strManejoAnsiedadObservaciones').setValue(null);
                                                                            Ext.getCmp('strManejoAnsiedadObservaciones').disable();
                                                                            Ext.getCmp('strManejoAnsiedadObservaciones').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strManejoAnsiedadObservaciones').enable();
                                                                            Ext.getCmp('strManejoAnsiedadObservaciones').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html: 'Observaciones'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Observaciones',
                                                                width: 500,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                id: 'strManejoAnsiedadObservaciones'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            */
                                            {
                                                xtype: 'fieldset',
                                                title: 'ASPECTO EVALUADO',
                                                layout: 'form',
                                                labelSeparator: ' ',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                labelWidth: 200,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'Puntualidad',
                                                                fieldLabel: 'Puntualidad',
                                                                width: 60,
                                                                allowBlank: true,
                                                                value: 0,
                                                                id: 'intPuntualidad',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB){
                                                                            if (f.getValue() === "" && f.getValue() === null){
                                                                                Ext.getCmp('intPuntualidad').setValue(0);
                                                                            }
                                                                        }
                                                                        clasificaAspectoEvaluado();
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html: 'Observaciones'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Observaciones',
                                                                width: 500,
                                                                allowBlank: true,
                                                                id: 'strPuntualidadObservaciones'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'Presentacion Personal',
                                                                fieldLabel: 'Presentacion Personal',
                                                                width: 60,
                                                                allowBlank: true,
                                                                value: 0,
                                                                id: 'intPresentacionPersonal',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB){
                                                                            if (f.getValue() === "" && f.getValue() === null){
                                                                                Ext.getCmp('intPresentacionPersonal').setValue(0);
                                                                            }
                                                                        }
                                                                        clasificaAspectoEvaluado();
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html: 'Observaciones'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Observaciones',
                                                                width: 500,
                                                                allowBlank: true,
                                                                id: 'strPresentacionPersonalObservaciones'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'Facilidad de Expresion',
                                                                fieldLabel: 'Facilidad de Expresion',
                                                                width: 60,
                                                                allowBlank: true,
                                                                value: 0,
                                                                id: 'intFacilidadExpresion',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB){
                                                                            if (f.getValue() === "" && f.getValue() === null){
                                                                                Ext.getCmp('intFacilidadExpresion').setValue(0);
                                                                            }
                                                                        }
                                                                        clasificaAspectoEvaluado();
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html: 'Observaciones'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Observaciones',
                                                                width: 500,
                                                                allowBlank: true,
                                                                id: 'strFacilidadExpresionObservaciones'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'Actitud General',
                                                                fieldLabel: 'Actitud General',
                                                                width: 60,
                                                                allowBlank: true,
                                                                value: 0,
                                                                id: 'intActitudGeneral',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB){
                                                                            if (f.getValue() === "" && f.getValue() === null){
                                                                                Ext.getCmp('intActitudGeneral').setValue(0);
                                                                            }
                                                                        }
                                                                        clasificaAspectoEvaluado();
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html: 'Observaciones'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Observaciones',
                                                                width: 500,
                                                                allowBlank: true,
                                                                id: 'strActitudGeneralObservaciones'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'Interes hacia el Trabajo',
                                                                fieldLabel: 'Interes hacia el Trabajo',
                                                                width: 60,
                                                                allowBlank: true,
                                                                value: 0,
                                                                id: 'intInteresTrabajo',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB){
                                                                            if (f.getValue() === "" && f.getValue() === null){
                                                                                Ext.getCmp('intInteresTrabajo').setValue(0);
                                                                            }
                                                                        }
                                                                        clasificaAspectoEvaluado();
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html: 'Observaciones'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Observaciones',
                                                                width: 500,
                                                                allowBlank: true,
                                                                id: 'strInteresTrabajoObservaciones'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'Manejo Ansiedad',
                                                                fieldLabel: 'Manejo Ansiedad',
                                                                width: 60,
                                                                allowBlank: true,
                                                                value: 0,
                                                                id: 'intManejoAnsiedad',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB){
                                                                            if (f.getValue() === "" && f.getValue() === null){
                                                                                Ext.getCmp('intManejoAnsiedad').setValue(0);
                                                                            }
                                                                        }
                                                                        clasificaAspectoEvaluado();
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html: 'Observaciones'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Observaciones',
                                                                width: 500,
                                                                allowBlank: true,
                                                                id: 'strManejoAnsiedadObservaciones'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'Manejo Stress',
                                                                fieldLabel: 'Manejo Stress',
                                                                width: 60,
                                                                allowBlank: true,
                                                                value: 0,
                                                                id: 'intManejoStress',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB){
                                                                            if (f.getValue() === "" && f.getValue() === null){
                                                                                Ext.getCmp('intManejoStress').setValue(0);
                                                                            }
                                                                        }
                                                                        clasificaAspectoEvaluado();
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html: 'Observaciones'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Observaciones',
                                                                width: 500,
                                                                allowBlank: true,
                                                                id: 'strManejoStressObservaciones'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'Manejo Confilctos',
                                                                fieldLabel: 'Manejo Confilctos',
                                                                width: 60,
                                                                allowBlank: true,
                                                                value: 0,
                                                                id: 'intManejoConfilctos',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB){
                                                                            if (f.getValue() === "" && f.getValue() === null){
                                                                                Ext.getCmp('intManejoConfilctos').setValue(0);
                                                                            }
                                                                        }
                                                                        clasificaAspectoEvaluado();
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html: 'Observaciones'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Observaciones',
                                                                width: 500,
                                                                allowBlank: true,
                                                                id: 'strManejoConfilctosObservaciones'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'Calificacion - Aspecto Evaludado',
                                                                fieldLabel: 'Calificacion - Aspecto Evaludado',
                                                                width: 60,
                                                                readOnly: true,
                                                                allowBlank: true,
                                                                value: 0,
                                                                id: 'intCalificacionAspectoEvaluado'
                                                            },
                                                            {
                                                                html: ' - '
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Clasificacion - Aspecto Evaludado',
                                                                width: 300,
                                                                allowBlank: true,
                                                                readOnly: true,
                                                                id: 'strClasificacionAspectoEvaluado'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'EXAMEN MENTAL',
                                                layout: 'form',
                                                labelWidth: 500,
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        name: 'Presentacion',
                                                        fieldLabel: 'Presentacion',
                                                        width: 150,
                                                        allowBlank: false,
                                                        store: stEvaluacion,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strExaMentalPresentacion'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: 'Ajuste Postural (Relajada, Tensa, Ansiosa)',
                                                        fieldLabel: 'Ajuste Postural (Relajada, Tensa, Ansiosa)',
                                                        width: 150,
                                                        allowBlank: false,
                                                        store: stEvaluacion,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strExaMentalAjustePostural'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: 'Expresion Fascial (angustia, timidez, ansiedad, temor, alegria)',
                                                        fieldLabel: 'Expresion Fascial (angustia, timidez, ansiedad, temor, alegria)',
                                                        width: 150,
                                                        allowBlank: false,
                                                        store: stEvaluacion,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strExaMentalExpresionFascial'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: 'Kinesia (bruscos, lentos, hiper, hipotonia)',
                                                        fieldLabel: 'Kinesia (bruscos, lentos, hiper, hipotonia)',
                                                        width: 150,
                                                        allowBlank: false,
                                                        store: stEvaluacion,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strExaMentalKinesia'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: 'Comunicacion (interpretativa, clara, congruente, fluida, ambigua)',
                                                        fieldLabel: 'Comunicacion (interpretativa, clara, congruente, fluida, ambigua)',
                                                        width: 150,
                                                        allowBlank: false,
                                                        store: stEvaluacion,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strExaMentalComunicacion'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: 'Proceso Pensamiento (logico, concreto, fantasioso, principio de realidad)',
                                                        fieldLabel: 'Proceso Pensamiento (logico, concreto, fantasioso, principio de realidad)',
                                                        width: 150,
                                                        allowBlank: false,
                                                        store: stEvaluacion,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strExaMentalProcesoPensamiento'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: 'Estado Emocional(alegre, tranquilo, deprimido, labil, variable)',
                                                        fieldLabel: 'Estado Emocional(alegre, tranquilo, deprimido, labil, variable)',
                                                        width: 150,
                                                        allowBlank: false,
                                                        store: stEvaluacion,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strExaMentalEstadoEmocional'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: 'Memoria (inmediata, reciente, remota, precaria)',
                                                        fieldLabel: 'Memoria (inmediata, reciente, remota, precaria)',
                                                        width: 150,
                                                        allowBlank: false,
                                                        store: stEvaluacion,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strExaMentalMemoria'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: 'Desarrollo Cognitivo (atencion, ubicacion, temporo-espacial, insigth, analisis, abstraccion)',
                                                        fieldLabel: 'Desarrollo Cognitivo (atencion, ubicacion, temporo-espacial, insigth, analisis, abstraccion)',
                                                        width: 150,
                                                        allowBlank: false,
                                                        store: stEvaluacion,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strExaMentalDesarrolloCognitivo'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: 'Contenido del Pensamiento (delirio fantasia, real, perverso)',
                                                        fieldLabel: 'Contenido del Pensamiento (delirio fantasia, real, perverso)',
                                                        width: 150,
                                                        allowBlank: false,
                                                        store: stEvaluacion,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strExaMentalContenidoPensamiento'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                anchor: '100%',
                                                autoHeight: true,
                                                layout: 'form',
                                                labelWidth: 260,
                                                padding: 5,
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Certificado de Aptitud Mental',
                                                        name: 'Certificado de Aptitud Mental',
                                                        width: 60,
                                                        allowBlank: true,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: "NO",
                                                        id: 'sysCertificadoAptitudMental',
                                                        listeners:{
                                                            change : function( t, newValue, oldValue){
                                                                if(newValue == "NO"){
                                                                    Ext.getCmp('fsCertificadoAptitudMental').setVisible(false);
                                                                    Ext.getCmp('memCertificadoAptitudMental').setValue(null);
                                                                    Ext.getCmp('memCertificadoAptitudMental').clearInvalid();
                                                                }else{
                                                                    Ext.getCmp('fsCertificadoAptitudMental').setVisible(true);
                                                                    Ext.getCmp('memCertificadoAptitudMental').setValue("Certifico que el señor " + Ext.getCmp('sysPacienteHC').getValue() + ", con" + Ext.getCmp('sysEdadHC').getValue() + " de edad y de la ciudad de Manizales, de acuerdo a las pruebas y el examen mental directo es: XXXXXXXXXXX  para desempeñar sus funciones como conductor.\n\ \n\OOBSERVACIONES: " );
                                                                }
                                                            }
                                                        }
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'CERTIFICADO APTITUD MENTAL',
                                                layout: 'table',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                id: 'fsCertificadoAptitudMental',
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        width: 750,
                                                        fieldLabel: 'CERTIFICADO MEDICO',
                                                        name: 'CERTIFICADO MEDICO',
                                                        height: 30,
                                                        grow: true,
                                                        minGrow: 30,
                                                        allowBlank: true,
                                                        id: 'memCertificadoAptitudMental'
                                                    },
                                                    {
                                                        xtype: 'button',
                                                        iconCls: 'btnImprimir',
                                                        text: 'Imprimir Certificado',
                                                        tooltip: 'Imprimir Certificado',
                                                        id: 'btnPrintCertificadoHC',
                                                        listeners:{
                                                            click : function(){
                                                                if (Ext.getCmp('sysYaGuardoHC').getValue() == 1)
                                                                    window.open ("../../controlador/asistencial/printcertificacion0.php?pEmpresa=" + ID_EMPRESA + "&pIPS=" + ID_IPS + "&pPaciente=" + Ext.getCmp('sysIdPacienteHC').getValue() + "&pCAS=" + Ext.getCmp('sysCASHC').getValue() + "&pConsecutivo=" + Ext.getCmp('sysConsecutivoDetalleHC').getValue(),"Incapacidad");
                                                                else{
                                                                    Ext.Msg.show({
                                                                        title: 'eOfiClinic',
                                                                        msg: 'Usted No ha Guardado la Evolución',
                                                                        buttons: Ext.Msg.OK,
                                                                        icon: Ext.Msg.ERROR
                                                                    });
                                                                }
                                                            }
                                                        }
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'RIPS',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                id: 'fsRips',
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: false,
                                                                fieldLabel: 'Diagnostico Principal',
                                                                id: 'sysDiagPpalHC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request({
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                        Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagPpalHCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Principal',
                                                                id: 'btnSearchDiagPpalHC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagPpalHC','sysDiagPpalHCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.1',
                                                                id: 'sysDiagRel1HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel1HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado1',
                                                                id: 'btnSearchDiagRel1HC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel1HC','sysDiagRel1HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.2',
                                                                id: 'sysDiagRel2HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel2HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado2',
                                                                id: 'btnSearchDiagRel2HC1',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel2HC','sysDiagRel2HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.3',
                                                                id: 'sysDiagRel3HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel3HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado3',
                                                                id: 'btnSearchDiagRel3HC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel3HC','sysDiagRel3HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Tipo de Diagnostico',
                                                        width:750,
                                                        name: 'Tipo de Diagnostico',
                                                        allowBlank: false,
                                                        store: 'StoreTipoDiagnostico',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        id: 'sysTipoDiagosticoHC'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Finalidad Consulta',
                                                        width:750,
                                                        name: 'Finalidad Consulta',
                                                        allowBlank: false,
                                                        store: 'StoreFinalidadConsulta',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 10,
                                                        id: 'sysFinalidadConsultaHC'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Causa Externa',
                                                        width:750,
                                                        name: 'Causa Externa',
                                                        allowBlank: false,
                                                        store: 'StoreCausaExterna',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 13,
                                                        id: 'sysCausaExternaHC'
                                                    }                            
                                                ]
                                            }
                                        ]
                                    }
                                ]
                            }
                            /*,
                            {
                                xtype: 'panel',
                                title: 'Solicitud CTC',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaCTC',
                                items: [
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Consentimientos Informados',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaConsentimientos',
                                items: [
                                ]
                            },*/
                        ]
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btnSalirEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 1) 
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    if (Ext.getCmp('sysUsaGridSalida').getValue() == 1){
                                                        Ext.getCmp('gridFormulario').store.reload();
                                                    }
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Usted No ha Guardado la Evolución del Paciente y Se Perdera la Información, Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                },
                tbar:{
                    items: [
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Ver Historia Clínica',
                            iconCls: 'btnVerHC',
                            id: 'btnVerHC',
                            listeners:{
                                click : function(){
                                    var cmpResumenHC = new winFrmVerHistorialHC({
                                        renderTo: Ext.getBody()
                                    });
                                    Ext.getCmp('winViewEvolucionHC').title = "PACIENTE: " + Ext.getCmp('sysPacienteHC').getValue();
                                    Ext.getCmp('gridHistorialEvoluciones').store.load({
                                        params: {
                                            pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                                            pPaciente: Ext.getCmp('sysIdPacienteHC').getValue()
                                        }
                                    });
                                    cmpResumenHC.show();
                                }
                            }
                        },
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar Evolución',
                            iconCls: 'btnGuardar',
                            id: 'btnGuardarEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 0) 
                                    {
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Guardar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnGuardarRegistros();
                                                }
                                            }
                                        });
                                    }else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Modificar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnModificarRegistros();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                }
            }
        ];
        winEntrevistaAptitudMental001Ui.superclass.initComponent.call(this);
    }
});

function fnGuardarRegistros(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc.php',
            params:{
                task: 'guardar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pidPlantillaHC : Ext.getCmp('sysIdCodPlantillaHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1); 
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function fnModificarRegistros(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc.php',
            params:{
                task: 'modificar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function clasificaAspectoEvaluado(){
    Ext.getCmp('intCalificacionAspectoEvaluado').setValue(parseInt(Ext.getCmp('intPuntualidad').getValue()) + parseInt(Ext.getCmp('intPresentacionPersonal').getValue()) + parseInt(Ext.getCmp('intFacilidadExpresion').getValue()) + parseInt(Ext.getCmp('intActitudGeneral').getValue()) + parseInt(Ext.getCmp('intInteresTrabajo').getValue()) + parseInt(Ext.getCmp('intManejoAnsiedad').getValue()) + parseInt(Ext.getCmp('intManejoStress').getValue()) + parseInt(Ext.getCmp('intManejoConfilctos').getValue()));
    if(parseInt(Ext.getCmp('intCalificacionAspectoEvaluado').getValue()) < 70){
        Ext.getCmp('strClasificacionAspectoEvaluado').setValue("NO SE AJUSTA AL PERFIL")
    }else{
        if(parseInt(Ext.getCmp('intCalificacionAspectoEvaluado').getValue()) < 80){
            Ext.getCmp('strClasificacionAspectoEvaluado').setValue("AJUSTE MEDIO AL PERFIL Y REQUIERE AMPLIAR VALORACIÓN")
        }else{
            if(parseInt(Ext.getCmp('intCalificacionAspectoEvaluado').getValue()) < 90){
                Ext.getCmp('strClasificacionAspectoEvaluado').setValue("BUEN AJUSTE AL PERFIL DEL CARGO")
            }else{
                Ext.getCmp('strClasificacionAspectoEvaluado').setValue("EXCELENTE AJUSTE AL PERFIL")
            }
        }
    }
}