/*
* @category    Formulario Modelo Evolucion Historia Clinica Cardiologia 001
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winHCjsandoval002Ui = Ext.extend(Ext.Window, {
    title: 'eOfiClinic ©  .:: Plantilla HC - Toma Signos ::.',
    width: 990,
    height: 600,
    closable: false,
    resizable: false,
    draggable: false,
    modal: true,
    id: 'winHC',
    initComponent: function() {
        
        this.items = [
            {
                xtype: 'panel',
                frame: true,
                anchor: '100%',
                id: 'panelHC',
                padding: 10,
                border: false,
                height: 570,
                autoScroll: true,
                layout: 'form',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysIdCodPlantillaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        value: 1,
                        id: 'sysUsaGridSalida'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        value: 0,
                        id: 'sysYaGuardoHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysPlantillaHC',
                        name: 'PLANTILLA'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptMx'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptExa'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptRem'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Actividad',
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        id: 'sysActividadHC',
                        name: 'PLANTILLA'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Empresa',
                        id: 'sysEmpresaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'IPS',
                        id: 'sysIPSHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Usuario',
                        id: 'sysUsuarioHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Profesional',
                        id: 'sysProfesionalHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Paciente',
                        id: 'sysIdPacienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Apertura',
                        id: 'sysAperturaHC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Cliente',
                        id: 'sysClienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdClienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdPlanHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdSubPlanHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdContratoHC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Profesional',
                        id: 'sysProfesionalAgendaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'ConsecutivoDetalle',
                        id: 'sysConsecutivoDetalleHC'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'CAS',
                                id: 'sysCASHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysFechaHC',
                                value: 'Fecha: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                width: 100,
                                id: 'sysFechaHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysHoraHC',
                                value: 'Hora: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                width: 90,
                                id: 'sysHoraHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysLegalizacionHC',
                                value: 'Legalización: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                width: 100,
                                id: 'sysLegalizaHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysAutorizacionHC',
                                value: 'Nro Autorización: '
                            },
                            {
                                xtype: 'textfield',
                                width: 210,
                                allowBlank: true,
                                style: 'color:brown;',
                                readOnly: true,
                                id: 'sysNroAutorizacionHC'
                            }
                        ]
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Paciente',
                        value: 'CC 792558261  - JORGE GALEANO RUIZ - (Masculino) FechaNac: 1973-01-30, Edad 38 Años',
                        id: 'sysPacienteHC'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                width: 120,
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'Genero',
                                id: 'sysGeneroPacHC'
                            },
                            {
                                html: 'Fecha Nacimiento'
                            },
                            {
                                xtype: 'textfield',
                                width: 120,
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysFecNacPacHC'
                            },
                            {
                                html: 'Edad'
                            },
                            {
                                xtype: 'textfield',
                                width: 250,
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysEdadPacHC'
                            }
                        ]
                    },
                    {
                        html: '<hr>',
                        style: 'background:transparent;',
                        border: false
                    },
                    {
                        xtype: 'tabpanel',
                        width: 930,
                        autoHeight: true,
                        border: false,
                        ref: 'fTabPanel',
                        id: 'fTabPanel',
                        activeTab: 0,
                        items: [
                            {
                                xtype: 'panel',
                                title: 'Evolución',
                                autoHeight: true,
                                autoScroll: true,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaEvolucion',
                                layout: 'form',
                                items: [
                                    {
                                        xtype: 'form',
                                        frame: true,
                                        anchor: '100%',
                                        id: 'frmHC',
                                        padding: 10,
                                        border: false,
                                        autoScroll: true,
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'fieldset',
                                                title: 'DIAGNOSTICOS',
                                                layout: 'table',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        width: 850,
                                                        fieldLabel: 'DIAGNOSTICOS',
                                                        name: 'DIAGNOSTICOS',
                                                        height: 30,
                                                        grow: true,
                                                        minGrow: 30,
                                                        allowBlank: false,
                                                        id: 'memDiagnosticos'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'FARMACOLOGICOS',
                                                layout: 'table',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 850,
                                                        fieldLabel: 'FARMACOLOGICOS',
                                                        name: 'FARMACOLOGICOS',
                                                        height: 30,
                                                        grow: true,
                                                        minGrow: 30,
                                                        //value: 'Ninguno',
                                                        allowBlank: true,
                                                        id: 'memAP_Farmacologicos'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'SUBJETIVO',
                                                layout: 'table',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        width: 850,
                                                        fieldLabel: 'SUBJETIVO',
                                                        name: 'SUBJETIVO',
                                                        height: 30,
                                                        grow: true,
                                                        minGrow: 30,
                                                        allowBlank: true,
                                                        id: 'memSubjetivo'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'OBJETIVO',
                                                layout: 'table',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        width: 850,
                                                        fieldLabel: 'OBJETIVO',
                                                        name: 'OBJETIVO',
                                                        height: 30,
                                                        grow: true,
                                                        minGrow: 30,
                                                        allowBlank: true,
                                                        id: 'memObjetivo'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'ANTECEDENTES PERSONALES',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 850,
                                                        fieldLabel: 'TOXICO-ALERGICOS',
                                                        name: 'TOXICO-ALERGICOS',
                                                        height: 30,
                                                        grow: true,
                                                        minGrow: 30,
                                                        allowBlank: true,
                                                        //value: 'NINGUNO',
                                                        id: 'memAP_Toxico'
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 850,
                                                        fieldLabel: 'QUIRURGICOS',
                                                        name: 'QUIRURGICOS',
                                                        height: 30,
                                                        grow: true,
                                                        minGrow: 30,
                                                        //value: 'NINGUNO',
                                                        allowBlank: true,
                                                        id: 'memAP_Quirurgico'
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 850,
                                                        fieldLabel: 'HOSPITALIZACION',
                                                        name: 'HOSPITALIZACION',
                                                        height: 30,
                                                        grow: true,
                                                        minGrow: 30,
                                                        //value: 'Ninguno',
                                                        allowBlank: true,
                                                        id: 'memAP_Hospitalizacion'
                                                    }
                                                    
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'ANTECEDENTES FAMILIARES',
                                                layout: 'table',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 850,
                                                        fieldLabel: 'ANTECEDENTES FAMILIARES',
                                                        name: 'ANTECEDENTES FAMILIARES',
                                                        height: 30,
                                                        grow: true,
                                                        minGrow: 30,
                                                        allowBlank: true,
                                                        id: 'memAntecedentesFamiliares'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'SIGNOS VITALES',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                fieldLabel: 'TA',
                                                                name: 'TA',
                                                                allowBlank: true,
                                                                id: 'strEF_TA'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysEF_FC',
                                                                value: 'FC: '
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                name: 'FC',
                                                                allowBlank: true,
                                                                id: 'strEF_FC'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysEF_FR',
                                                                value: 'FR: '
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                name: 'FR',
                                                                allowBlank: true,
                                                                id: 'strEF_FR'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysEF_SAT',
                                                                value: 'SAT: '
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                name: 'SAT',
                                                                allowBlank: true,
                                                                id: 'strEF_SAT'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                fieldLabel: 'TALLA (cm)',
                                                                name:"TALLA (cm)",
                                                                emptyText: '(cm)',
                                                                id: 'intEF_Talla',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        if(pNew == null || pNew == 0){
                                                                            Ext.getCmp('intEF_Talla').setValue(null);
                                                                            Ext.getCmp('intEF_IMC').setValue(0);
                                                                        }else{
                                                                            //peso [kg]/ estatura [m2]
                                                                            if(Ext.getCmp('intEF_Peso').getValue() > 0){
                                                                                var pTalla = Ext.getCmp('intEF_Talla').getValue() / 100;
                                                                                Ext.getCmp('intEF_IMC').setValue(Ext.getCmp('intEF_Peso').getValue()/(pTalla*pTalla));
                                                                            }else{
                                                                                Ext.getCmp('intEF_IMC').setValue(0);
                                                                            }
                                                                        }
                                                                        if(Ext.getCmp('intEF_IMC').getValue()<1){
                                                                           Ext.getCmp('strEF_IMCClasificacon').setValue(null);
                                                                        }else{
                                                                            if(Ext.getCmp('intEF_IMC').getValue()<24.9){
                                                                               Ext.getCmp('strEF_IMCClasificacon').setValue("ACEPTABLE");
                                                                            }else{
                                                                                if(Ext.getCmp('intEF_IMC').getValue()<29.9){
                                                                                   Ext.getCmp('strEF_IMCClasificacon').setValue("SOBREPESO");
                                                                                }else{
                                                                                    Ext.getCmp('strEF_IMCClasificacon').setValue("OBESIDAD");
                                                                                }

                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysEF_Peso',
                                                                value: 'PESO (Kg): '
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                emptyText: '(Kg)',
                                                                name:"PESO (Kg)",
                                                                id: 'intEF_Peso',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        if(pNew == null || pNew == 0){
                                                                            Ext.getCmp('intEF_Peso').setValue(null);
                                                                            Ext.getCmp('intEF_IMC').setValue(0);
                                                                        }else{
                                                                            //peso [kg]/ estatura [m2]
                                                                            if(Ext.getCmp('intEF_Talla').getValue() > 0){
                                                                                var pTalla = Ext.getCmp('intEF_Talla').getValue() / 100;
                                                                                Ext.getCmp('intEF_IMC').setValue(Ext.getCmp('intEF_Peso').getValue()/(pTalla*pTalla));
                                                                            }else{
                                                                                Ext.getCmp('intEF_IMC').setValue(0);
                                                                            }
                                                                        }
                                                                        if(Ext.getCmp('intEF_IMC').getValue()<1){
                                                                           Ext.getCmp('strEF_IMCClasificacon').setValue(null);
                                                                        }else{
                                                                            if(Ext.getCmp('intEF_IMC').getValue()<24.9){
                                                                               Ext.getCmp('strEF_IMCClasificacon').setValue("ACEPTABLE");
                                                                            }else{
                                                                                if(Ext.getCmp('intEF_IMC').getValue()<29.9){
                                                                                   Ext.getCmp('strEF_IMCClasificacon').setValue("SOBREPESO");
                                                                                }else{
                                                                                    Ext.getCmp('strEF_IMCClasificacon').setValue("OBESIDAD");
                                                                                }

                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysEF_IMC',
                                                                value: 'IMC: '
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                readOnly: true,
                                                                name: "IMC",
                                                                id: 'intEF_IMC'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                allowBlank: true,
                                                                readOnly: true,
                                                                name: "IMC - CLASIFICACION",
                                                                id: 'strEF_IMCClasificacon'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysEF_PA',
                                                                value: 'P. Abd: '
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                decimalPrecision: 2,
                                                                name: 'PA',
                                                                allowBlank: true,
                                                                id: 'strEF_PA'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'EXAMEN FISICO',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 850,
                                                        fieldLabel: 'CABEZA Y CUELLO',
                                                        name: 'CABEZA Y CUELLO',
                                                        height: 30,
                                                        grow: true,
                                                        minGrow: 30,
                                                        allowBlank: true,
                                                        value: 'Pulsos carotideos simétricos sin soplos. Tiroides no palpable. No masas',
                                                        id: 'memEF_CabezaCuello'
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 850,
                                                        fieldLabel: 'TORAX',
                                                        name: 'TORAX',
                                                        height: 30,
                                                        grow: true,
                                                        minGrow: 30,
                                                        allowBlank: true,
                                                        value: 'Normal. RSCSRS sin soplos y sin agregados S1 y S2 de intensidad tono y timbre normales. Pulmones bien ventilados sin agregados.',
                                                        id: 'memEF_Torax'
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 850,
                                                        fieldLabel: 'ABDOMEN',
                                                        name: 'ABDOMEN',
                                                        height: 30,
                                                        grow: true,
                                                        minGrow: 30,
                                                        allowBlank: true,
                                                        value: 'Sin masas ni megalias. Sin soplos',
                                                        id: 'memEF_Abdomen'
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 850,
                                                        fieldLabel: 'EXTREMIDADES',
                                                        name: 'EXTREMIDADES',
                                                        height: 30,
                                                        grow: true,
                                                        minGrow: 30,
                                                        allowBlank: true,
                                                        value: 'Pulsos proximales y distales normales. Adecuada perfusión.',
                                                        id: 'memEF_Extremidades'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'PARACLINICOS',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 850,
                                                        fieldLabel: 'ECO',
                                                        name: 'ECO',
                                                        height: 30,
                                                        grow: true,
                                                        minGrow: 30,
                                                        allowBlank: true,
                                                        //value: 'NO TRAE',
                                                        id: 'memPARACLINICO_ECO'
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 850,
                                                        fieldLabel: 'P DE ESF',
                                                        name: 'P DE ESF',
                                                        height: 30,
                                                        grow: true,
                                                        minGrow: 30,
                                                        allowBlank: true,
                                                        //value: 'NO TRAE',
                                                        id: 'memPARACLINICO_PESF'
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 850,
                                                        fieldLabel: 'CATETERISMO',
                                                        name: 'CATETERISMO',
                                                        height: 30,
                                                        grow: true,
                                                        minGrow: 30,
                                                        allowBlank: true,
                                                        //value: 'NO TRAE',
                                                        id: 'memPARACLINICO_CATETERISMO'
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 850,
                                                        fieldLabel: 'HOLTER',
                                                        name: 'HOLTER',
                                                        height: 30,
                                                        grow: true,
                                                        minGrow: 30,
                                                        allowBlank: true,
                                                        //value: 'NO TRAE',
                                                        id: 'memPARACLINICO_HOLTER'
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 850,
                                                        fieldLabel: 'EKG',
                                                        name: 'EKG',
                                                        height: 30,
                                                        grow: true,
                                                        minGrow: 30,
                                                        allowBlank: true,
                                                        //value: 'NO TRAE',
                                                        id: 'memPARACLINICO_EKG'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'LABORATORIOS',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                labelWidth: 175,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 150,
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                fieldLabel: 'COLESTEROL TOTAL (mg/dl)',
                                                                name:"COLESTEROL TOTAL (mg/dl)",
                                                                emptyText: '(mg/dl)',
                                                                id: 'intLAB_COLEST',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        if(pNew == null || pNew == 0){
                                                                            Ext.getCmp('intLAB_COLEST').setValue(null);
                                                                            Ext.getCmp('intLAB_COLESTOTAL_HDL').setValue(0);
                                                                            Ext.getCmp('intLAB_COLESNoHDL').setValue(0);
                                                                        }else{
                                                                            if(Ext.getCmp('intLAB_COLESHDL').getValue() > 0){
                                                                                Ext.getCmp('intLAB_COLESTOTAL_HDL').setValue(Ext.getCmp('intLAB_COLEST').getValue()/Ext.getCmp('intLAB_COLESHDL').getValue());
                                                                                Ext.getCmp('intLAB_COLESNoHDL').setValue(Ext.getCmp('intLAB_COLEST').getValue()-Ext.getCmp('intLAB_COLESHDL').getValue());
                                                                            }else{
                                                                                Ext.getCmp('intLAB_COLESTOTAL_HDL').setValue(0);
                                                                                Ext.getCmp('intLAB_COLESNoHDL').setValue(0);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 130,
                                                                name: 'fecLAB_COLEST',
                                                                allowBlank: true,
                                                                style: 'text-align:center;',
                                                                emptyText: '(dia/mes/año) ',
                                                                id: 'fecLAB_COLEST'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 150,
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                fieldLabel:"COLESTEROL HDL (mg/dl)",
                                                                name:"COLESTEROL HDL (mg/dl)",
                                                                emptyText: '(mg/dl)',
                                                                id: 'intLAB_COLESHDL',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        if(pNew == null || pNew == 0){
                                                                            Ext.getCmp('intLAB_COLESHDL').setValue(null);
                                                                            Ext.getCmp('intLAB_COLESTOTAL_HDL').setValue(0);
                                                                            Ext.getCmp('intLAB_COLESNoHDL').setValue(0);
                                                                        }else{
                                                                            if(Ext.getCmp('intLAB_COLESHDL').getValue() > 0){
                                                                                Ext.getCmp('intLAB_COLESTOTAL_HDL').setValue(Ext.getCmp('intLAB_COLEST').getValue()/Ext.getCmp('intLAB_COLESHDL').getValue());
                                                                                Ext.getCmp('intLAB_COLESNoHDL').setValue(Ext.getCmp('intLAB_COLEST').getValue()-Ext.getCmp('intLAB_COLESHDL').getValue());
                                                                            }else{
                                                                                Ext.getCmp('intLAB_COLESTOTAL_HDL').setValue(0);
                                                                                Ext.getCmp('intLAB_COLESNoHDL').setValue(0);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 130,
                                                                name: 'fecLAB_COLESHDL',
                                                                allowBlank: true,
                                                                style: 'text-align:center;',
                                                                emptyText: '(dia/mes/año) ',
                                                                id: 'fecLAB_COLESHDL'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 150,
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                fieldLabel:"COLESTEROL NO HDL (mg/dl)",
                                                                name:"COLESTEROL NO HDL (mg/dl)",
                                                                emptyText: '(mg/dl)',
                                                                id: 'intLAB_COLESNoHDL'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 130,
                                                                name: 'fecLAB_COLESHDL',
                                                                allowBlank: true,
                                                                style: 'text-align:center;',
                                                                emptyText: '(dia/mes/año) ',
                                                                id: 'fecLAB_COLESNoHDL'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 150,
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                fieldLabel:"COLESTEROL LDL (mg/dl)",
                                                                name:"COLESTEROL LDL (mg/dl)",
                                                                emptyText: '(mg/dl)',
                                                                id: 'intLAB_COLESLDL'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 130,
                                                                name: 'fecLAB_COLESLDL',
                                                                allowBlank: true,
                                                                style: 'text-align:center;',
                                                                emptyText: '(dia/mes/año) ',
                                                                id: 'fecLAB_COLESLDL'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 150,
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                readOnly: true,
                                                                value: 0,
                                                                fieldLabel:"COLESTEROL TOTAL/HDL (mg/dl)",
                                                                name:"COLESTEROL TOTAL/HDL (mg/dl)",
                                                                emptyText: '(mg/dl)',
                                                                id: 'intLAB_COLESTOTAL_HDL'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 130,
                                                                name: 'fecLAB_COLESTOTAL_HDL',
                                                                allowBlank: true,
                                                                style: 'text-align:center;',
                                                                emptyText: '(dia/mes/año) ',
                                                                id: 'fecLAB_COLESTOTAL_HDL'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 150,
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                fieldLabel:"TRIGLICERIDOS (mg/dl)",
                                                                name:"TRIGLICERIDOS (mg/dl)",
                                                                emptyText: '(mg/dl)',
                                                                id: 'intLAB_TRIGLICERIDOS'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 130,
                                                                name: 'fecLAB_TRIGLICERIDOS',
                                                                allowBlank: true,
                                                                style: 'text-align:center;',
                                                                emptyText: '(dia/mes/año) ',
                                                                id: 'fecLAB_TRIGLICERIDOS'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 150,
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                fieldLabel: 'GlICEMIA (mg/dl)',
                                                                name:"GLICEMIA (mg/dl)",
                                                                emptyText: '(mg/dl)',
                                                                id: 'intLAB_GLICEMIA'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 130,
                                                                name: 'fecLAB_GLICEMIA',
                                                                allowBlank: true,
                                                                style: 'text-align:center;',
                                                                emptyText: '(dia/mes/año) ',
                                                                id: 'fecLAB_GLICEMIA'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 150,
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                fieldLabel:"CREATININA (mg/dl)",
                                                                name:"CREATININA (mg/dl)",
                                                                emptyText: '(mg/dl)',
                                                                id: 'intLAB_CREATININA'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 130,
                                                                name: 'fecLAB_CREATININA',
                                                                allowBlank: true,
                                                                style: 'text-align:center;',
                                                                emptyText: '(dia/mes/año) ',
                                                                id: 'fecLAB_CREATININA'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 150,
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                fieldLabel:"HB",
                                                                name:"HB",
                                                                id: 'intLAB_HB'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 130,
                                                                name: 'fecLAB_HB',
                                                                allowBlank: true,
                                                                style: 'text-align:center;',
                                                                emptyText: '(dia/mes/año) ',
                                                                id: 'fecLAB_HB'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 150,
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                fieldLabel:"HBGlic",
                                                                name:"HBGlic",
                                                                id: 'intLAB_HBGlic'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 130,
                                                                name: 'fecLAB_HBGlic',
                                                                allowBlank: true,
                                                                style: 'text-align:center;',
                                                                emptyText: '(dia/mes/año) ',
                                                                id: 'fecLAB_HBGlic'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 150,
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                fieldLabel: 'TSH',
                                                                name:"TSH",
                                                                id: 'intLAB_TSH'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 130,
                                                                name: 'fecLAB_TSH',
                                                                allowBlank: true,
                                                                style: 'text-align:center;',
                                                                emptyText: '(dia/mes/año) ',
                                                                id: 'fecLAB_TSH'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 150,
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                fieldLabel:"INR",
                                                                name:"INR",
                                                                id: 'intLAB_INR'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 130,
                                                                name: 'fecLAB_INR',
                                                                allowBlank: true,
                                                                style: 'text-align:center;',
                                                                emptyText: '(dia/mes/año) ',
                                                                id: 'fecLAB_INR'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        fieldLabel: 'OTROS LABORATORIOS',
                                                        name: 'OTROS LABORATORIOS',
                                                        allowBlank: true,
                                                        id: 'memLAB_OBS'
                                                    }
                                                ]
                                            }
                                        ]
                                    }
                                ]
                            }
                        ]
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btnSalirEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 1) 
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    if (Ext.getCmp('sysUsaGridSalida').getValue() == 1){
                                                        Ext.getCmp('gridFormulario').store.reload();
                                                    }
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Usted No ha Guardado la Evolución del Paciente y Se Perdera la Información, Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                },
                tbar:{
                    items: [
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Ver Historia Clínica',
                            iconCls: 'btnVerHC',
                            id: 'btnVerHC',
                            listeners:{
                                click : function(){
                                    var cmpResumenHC = new winFrmVerHistorialHC({
                                        renderTo: Ext.getBody()
                                    });
                                    Ext.getCmp('winViewEvolucionHC').title = "PACIENTE: " + Ext.getCmp('sysPacienteHC').getValue();
                                    Ext.getCmp('gridHistorialEvoluciones').store.load({
                                        params: {
                                            pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                                            pPaciente: Ext.getCmp('sysIdPacienteHC').getValue()
                                        }
                                    });
                                    cmpResumenHC.show();
                                }
                            }
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Imagenes Asociadas',
                            iconCls: 'btnCargarFoto',
                            listeners:{
                                click : function(){
                                    if(!winImgxPac){
                                        winImgxPac = new winImagenAsocxPac({
                                            url:'../../controlador/pacientes/controlador_filesasoc.php',
                                            width:515,
                                            height:350
                                        });
                                    }
                                    winImgxPac.show();
                                }
                            }
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Documentos Asociados',
                            iconCls: 'btnCargarFile',
                            listeners:{
                                click : function(){
                                    if(!winDocxPac){
                                        winDocxPac = new winDocumentoAsocxPac({
                                            url:'../../controlador/pacientes/controlador_docsasoc.php',
                                            width:515,
                                            height:350
                                        });
                                    }
                                    winDocxPac.show();
                                }
                            }
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar Evolución',
                            iconCls: 'btnGuardar',
                            id: 'btnGuardarEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 0) 
                                    {
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Guardar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnGuardarRegistrosjsandoval002();
                                                }
                                            }
                                        });
                                    }else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Modificar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnModificarRegistrosjsandoval002();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                }
            }
        ];
        this.on({
            afterlayout:{scope:this, single:true, fn:function() {
                Ext.Msg.hide();
                if(paramOpcion != "Nuevo"){
                    var frm = Ext.getCmp('frmHC').getForm();
                    frm.doAction('load', {
                        url: '../../controlador/asistencial/controlador_cardiologia.php',
                        waitMsg: 'Cargando Información...',
                        params:{
                            pCAS: Ext.getCmp('sysCASHC').getValue(),
                            pConsecutivo: Ext.getCmp('sysConsecutivoDetalleHC').getValue(),
                            task: 'CARGAR_DATOS_HC'
                        },
                        success:function(form, action) {
                            CargarDataHC(action.result.data.sysEvolucion);
                        }
                    });
                }
            }}
        }); 
        winHCjsandoval002Ui.superclass.initComponent.call(this);
    }
});

function fnGuardarRegistrosjsandoval002(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/controlador_cardiologia.php',
            params:{
                task: 'guardar_tomasignos',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pidPlantillaHC : Ext.getCmp('sysIdCodPlantillaHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue(),
                pEF_TA: Ext.getCmp('strEF_TA').getValue(),
                pEF_FC: Ext.getCmp('strEF_FC').getValue(),
                pEF_FR: Ext.getCmp('strEF_FR').getValue(),
                pEF_SAT: Ext.getCmp('strEF_SAT').getValue(),
                pEF_Talla: Ext.getCmp('intEF_Talla').getValue(),
                pEF_Peso: Ext.getCmp('intEF_Peso').getValue(),
                pEF_IMC: Ext.getCmp('intEF_IMC').getValue(),
                pIMCClasificacon: Ext.getCmp('strEF_IMCClasificacon').getValue(),
                pEF_PA: Ext.getCmp('strEF_PA').getValue(),
                pLAB_COLEST: Ext.getCmp('intLAB_COLEST').getValue(),
                pLAB_COLESHDL: Ext.getCmp('intLAB_COLESHDL').getValue(),
                pLAB_COLESNoHDL: Ext.getCmp('intLAB_COLESNoHDL').getValue(),
                pLAB_COLESLDL: Ext.getCmp('intLAB_COLESLDL').getValue(),
                pLAB_COLESTOTAL_HDL: Ext.getCmp('intLAB_COLESTOTAL_HDL').getValue(),
                pLAB_TRIGLICERIDOS: Ext.getCmp('intLAB_TRIGLICERIDOS').getValue(),
                pLAB_GLICEMIA: Ext.getCmp('intLAB_GLICEMIA').getValue(),
                pLAB_CREATININA: Ext.getCmp('intLAB_CREATININA').getValue(),
                pLAB_HB: Ext.getCmp('intLAB_HB').getValue(),
                pLAB_HBGlic: Ext.getCmp('intLAB_HBGlic').getValue(),
                pLAB_TSH: Ext.getCmp('intLAB_TSH').getValue(),
                pLAB_INR: Ext.getCmp('intLAB_INR').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1); 
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function fnModificarRegistrosjsandoval002(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/controlador_cardiologia.php',
            params:{
                task: 'modificar_tomasignos',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue(),
                pEF_TA: Ext.getCmp('strEF_TA').getValue(),
                pEF_FC: Ext.getCmp('strEF_FC').getValue(),
                pEF_FR: Ext.getCmp('strEF_FR').getValue(),
                pEF_SAT: Ext.getCmp('strEF_SAT').getValue(),
                pEF_Talla: Ext.getCmp('intEF_Talla').getValue(),
                pEF_Peso: Ext.getCmp('intEF_Peso').getValue(),
                pEF_IMC: Ext.getCmp('intEF_IMC').getValue(),
                pIMCClasificacon: Ext.getCmp('strEF_IMCClasificacon').getValue(),
                pEF_PA: Ext.getCmp('strEF_PA').getValue(),
                pLAB_COLEST: Ext.getCmp('intLAB_COLEST').getValue(),
                pLAB_COLESHDL: Ext.getCmp('intLAB_COLESHDL').getValue(),
                pLAB_COLESNoHDL: Ext.getCmp('intLAB_COLESNoHDL').getValue(),
                pLAB_COLESLDL: Ext.getCmp('intLAB_COLESLDL').getValue(),
                pLAB_COLESTOTAL_HDL: Ext.getCmp('intLAB_COLESTOTAL_HDL').getValue(),
                pLAB_TRIGLICERIDOS: Ext.getCmp('intLAB_TRIGLICERIDOS').getValue(),
                pLAB_GLICEMIA: Ext.getCmp('intLAB_GLICEMIA').getValue(),
                pLAB_CREATININA: Ext.getCmp('intLAB_CREATININA').getValue(),
                pLAB_HB: Ext.getCmp('intLAB_HB').getValue(),
                pLAB_HBGlic: Ext.getCmp('intLAB_HBGlic').getValue(),
                pLAB_TSH: Ext.getCmp('intLAB_TSH').getValue(),
                pLAB_INR: Ext.getCmp('intLAB_INR').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}
