/*
* @category    Programacion Eventos Formulario Profesionales
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winFrmVerAgenda = Ext.extend(winFrmVerAgendaUi, {
    initComponent: function() {
        winFrmVerAgenda.superclass.initComponent.call(this);
        el = Ext.get('idempresa');
        ID_EMPRESA = el.getValue();
        el = Ext.get('idsede');
        ID_SEDE = el.getValue();
        el = Ext.get('idips');
        ID_IPS = el.getValue();
        el = Ext.get('idusuario');
        ID_USUARIO = el.getValue();
        el = Ext.get('idperfil');
        ID_PERFIL = el.getValue();
        stOpcionesSistema = new StoreOpcionesSistema();
        stOpcionesSistema.load({
            params: { 'pPerfil': ID_PERFIL }
        });
        paramIdPaciente = 0;
        paramOpcion = "Nuevo";
        wPaciente = 0;
        wCAS = 0;
        myPaciente = 0;
        myCAS = 0;
        wConsecutivoHC = 0;
        objREMADD = "new winSolRem002Ui();";
        objEXAADD = "new winSolExa002Ui();";
        objMXADD = "new winSolMx002Ui();";
        
        
        /*Ext.getCmp('sysProfeAgenda').store.load({
            params: {
                pIPS: ID_IPS, 
                pUsuario: ID_USUARIO
            }
        });*/ 
        Ext.getCmp('fNomEmpresa').setValue("EMPRESA: " + Ext.get('nomempresa').getValue());
        Ext.getCmp('fNomSede').setValue("");
        Ext.getCmp('fNomIPS').setValue("");
        Ext.getCmp('fNomUSR').setValue("");
        
        Ext.getCmp('sysFechaAgenda').setValue(new Date().format("d/m/Y"));
        
        var sysProfesionalAgenda = Ext.getCmp('sysProfeAgenda').on("select",this.CargaUbicacionAgenda,this);
        var sysUbicacionAgenda = Ext.getCmp('sysUbicacionAgenda').on("select",this.CargaFechasAgenda,this);
        var sysFechaAgenda = Ext.getCmp('sysFechaAgenda').on("select",this.CargaDetalleAgenda,this);
        var btnActualizarAgenda = Ext.getCmp('btnActualizarAgenda').on("click",this.ActualizarAgenda,this);
        var btnPuestoEnfermeria = Ext.getCmp('btnPuestoEnfermeria').on("click",this.PuestoEnfermeria,this);
        var btnPuestoMedicina = Ext.getCmp('btnPuestoMedicina').on("click",this.PuestoMedicina,this);
        var btnPuestoTerapiaFisica = Ext.getCmp('btnPuestoTerapiaFisica').on("click",this.PuestoTerapiaFisica,this);
        var btnPuestoTrabajoSocial = Ext.getCmp('btnPuestoTrabajoSocial').on("click",this.PuestoTrabajoSocial,this);
        var btnGrouping1 = Ext.getCmp('btnGrouping1').on("click",this.GroupingUbicacionActual,this);
        var btnGrouping2 = Ext.getCmp('btnGrouping2').on("click",this.GroupingProcesoActual,this);

        var btnSalir = Ext.getCmp('btnSalirOpcion').on("click",this.SalirOpcion, this);
    },
    GroupingUbicacionActual: function(){
        Ext.getCmp('gridFormulario').store.clearGrouping();
        Ext.getCmp('gridFormulario').store.groupBy("UbicacionActual");
    },
    GroupingProcesoActual: function(){
        Ext.getCmp('gridFormulario').store.clearGrouping();
        Ext.getCmp('gridFormulario').store.groupBy("ProcesoActual");
    },
    PuestoTerapiaFisica: function(){
        if(Ext.getCmp('gridFormulario').selModel.getCount() == 1){
            var selections = Ext.getCmp('gridFormulario').selModel.getSelections();
            if (selections[0].json.ConceptoFinal == 'SIN FINALIZAR' && selections[0].json.UbicacionActual == "RECEPCION"){
                Ext.Ajax.request(
                {
                    waitMsg: 'Por favor Espere...',
                    url: "../../controlador/clinicacaidas/controlador_clinicacaidas.php",
                    params:{
                        task: "CAMBIAR_UBICACION_TERAPIAFISICA",
                        pUbicacion: "TERAPIA FISICA",
                        pProceso: "TERAPIA FISICA",
                        pConsecutivoHC: selections[0].json.ConsecutivoHC
                    },
                    success: function(response,options)
                    {
                        var el = Ext.get('response'); 
                        var Respuesta = response.responseText;
                        var Contenido = Respuesta.split('^');
                        var NroCAS = Contenido[0];
                        paramIdPaciente = selections[0].json.Paciente;
                        if(NroCAS > 0){
                            Ext.getCmp('gridFormulario').store.reload();
                            //Ext.Msg.wait('Cargando Formulario... por favor espere!');
                            var winFrmPuestoTabajo003 = new winFrmPuestoTabajo003Ui();
                            Ext.getCmp('sysPacienteW003').setValue(selections[0].json.TipDoc + " " + selections[0].json.Documento + ' - ' + selections[0].json.PrimerNombre + " " + selections[0].json.SegundoNombre + " " + selections[0].json.PrimerApellido + " " + selections[0].json.SegundoApellido);
                            Ext.getCmp('sysCASW003').setValue(selections[0].json.CAS);
                            Ext.getCmp('sysConsecutivoDetalleW003').setValue(selections[0].json.ConsecutivoHC);
                            wConsecutivoHC = selections[0].json.ConsecutivoHC;
                            Ext.getCmp('sysIdCodPlantillaW003').setValue(1);
                            Ext.getCmp('sysYaGuardoW003').setValue(1);
                            Ext.getCmp('sysActividadW003').setValue("CLINICA INESTABILIDAD, VERTIGO Y CAIDAS");
                            Ext.getCmp('sysEmpresaW003').setValue(ID_EMPRESA);
                            Ext.getCmp('sysIPSW003').setValue(ID_IPS);
                            Ext.getCmp('sysUsuarioW003').setValue(ID_USUARIO);
                            //Ext.getCmp('sysProfesionalW003').setValue(1);
                            Ext.getCmp('sysAperturaW003').setValue(new Date().format("h:i:s"));
                            
                            Ext.getCmp('sysIdPacienteW003').setValue(selections[0].json.Paciente);
                            Ext.getCmp('sysIdClienteW003').setValue(1);
                            Ext.getCmp('sysIdPlanW003').setValue(1);
                            Ext.getCmp('sysIdSubPlanW003').setValue(1);
                            Ext.getCmp('sysIdContratoW003').setValue(1);
                            Ext.getCmp('sysGeneroPacW003').setValue(selections[0].json.GeneroPaciente);
                            Ext.getCmp('sysDatBasGeneroW003').setValue(selections[0].json.GeneroPaciente);
                            if(selections[0].json.GeneroPaciente === "M"){
                                Ext.getCmp('sysDatBasEdadW003').setValue("MASCULINO");
                            }else{
                                Ext.getCmp('sysDatBasEdadW003').setValue("FEMENINO");
                            }
                            Ext.getCmp('sysFechaW003').setValue(selections[0].json.FechaAtencion);
                            Ext.getCmp('sysProfesionalAgendaW003').setValue("PUESTO TRABAJO DE TERAPIA FISICA");
                            
                            winFrmPuestoTabajo003.show();
                        } else {
                            Ext.Msg.hide();
                            Ext.MessageBox.show({
                                title: 'eOfiClinic',
                                msg: 'Ocurrio un error al guardar la información o no se pudo establecer conexión con el servidor.',
                                buttons: Ext.MessageBox.OK,
                                icon: Ext.MessageBox.ERROR
                            });
                        }
                    },
                    failure: function(response,options)
                    {
                        Ext.MessageBox.hide();
                        Ext.MessageBox.show({
                            title: 'eOfiClinic',
                            msg: 'Ocurrio un error al guardar la información o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                    }
                });
            }else{
                Ext.MessageBox.show({
                    title: 'eOfiClinic',
                    msg: 'Ya se paso por el puesto de terapia fisica o el paciente no esta ubicado en la recepción',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        }else{
            Ext.MessageBox.show({
                title: 'eOfiClinic',
                msg: 'Debe seleccionar un Paciente',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    },
    PuestoTrabajoSocial: function(){
        if(Ext.getCmp('gridFormulario').selModel.getCount() == 1){
            var selections = Ext.getCmp('gridFormulario').selModel.getSelections();
            //if (selections[0].json.PasoTomaSignos == '0' && selections[0].json.UbicacionActual == "RECEPCION"){
            if (selections[0].json.ConceptoFinal == 'SIN FINALIZAR' && selections[0].json.UbicacionActual == "RECEPCION"){ // && selections[0].json.UbicacionActual == "RECEPCION"
                Ext.Ajax.request(
                {
                    waitMsg: 'Por favor Espere...',
                    url: "../../controlador/clinicacaidas/controlador_clinicacaidas.php",
                    params:{
                        task: "CAMBIAR_UBICACION_TRABAJOSOCIAL",
                        pUbicacion: "TRABAJO SOCIAL",
                        pProceso: "TRABAJO SOCIAL",
                        pConsecutivoHC: selections[0].json.ConsecutivoHC
                    },
                    success: function(response,options)
                    {
                        var el = Ext.get('response'); 
                        var Respuesta = response.responseText;
                        var Contenido = Respuesta.split('^');
                        var NroCAS = Contenido[0];
                        paramIdPaciente = selections[0].json.Paciente;
                        if(NroCAS > 0){
                            Ext.getCmp('gridFormulario').store.reload();
                            //Ext.Msg.wait('Cargando Formulario... por favor espere!');
                            var winFrmPuestoTabajo004 = new winFrmPuestoTabajo004Ui();
                            Ext.getCmp('sysPacienteW004').setValue(selections[0].json.TipDoc + " " + selections[0].json.Documento + ' - ' + selections[0].json.PrimerNombre + " " + selections[0].json.SegundoNombre + " " + selections[0].json.PrimerApellido + " " + selections[0].json.SegundoApellido);
                            Ext.getCmp('sysCASW004').setValue(selections[0].json.CAS);
                            Ext.getCmp('sysConsecutivoDetalleW004').setValue(selections[0].json.ConsecutivoHC);
                            wConsecutivoHC = selections[0].json.ConsecutivoHC;
                            Ext.getCmp('sysIdCodPlantillaW004').setValue(1);
                            Ext.getCmp('sysYaGuardoW004').setValue(1);
                            Ext.getCmp('sysActividadW004').setValue("CLINICA INESTABILIDAD, VERTIGO Y CAIDAS");
                            Ext.getCmp('sysEmpresaW004').setValue(ID_EMPRESA);
                            Ext.getCmp('sysIPSW004').setValue(ID_IPS);
                            Ext.getCmp('sysUsuarioW004').setValue(ID_USUARIO);
                            //Ext.getCmp('sysProfesionalW004').setValue(1);
                            Ext.getCmp('sysAperturaW004').setValue(new Date().format("h:i:s"));
                            
                            Ext.getCmp('sysIdPacienteW004').setValue(selections[0].json.Paciente);
                            Ext.getCmp('sysIdClienteW004').setValue(1);
                            Ext.getCmp('sysIdPlanW004').setValue(1);
                            Ext.getCmp('sysIdSubPlanW004').setValue(1);
                            Ext.getCmp('sysIdContratoW004').setValue(1);
                            Ext.getCmp('sysGeneroPacW004').setValue(selections[0].json.GeneroPaciente);
                            Ext.getCmp('sysDatBasGeneroW004').setValue(selections[0].json.GeneroPaciente);
                            if(selections[0].json.GeneroPaciente === "M"){
                                Ext.getCmp('sysDatBasEdadW004').setValue("MASCULINO");
                            }else{
                                Ext.getCmp('sysDatBasEdadW004').setValue("FEMENINO");
                            }
                            Ext.getCmp('sysFechaW004').setValue(selections[0].json.FechaAtencion);
                            Ext.getCmp('sysProfesionalAgendaW004').setValue("PUESTO DE TRABAJO SOCIAL");
                            
                            winFrmPuestoTabajo004.show();
                        } else {
                            Ext.Msg.hide();
                            Ext.MessageBox.show({
                                title: 'eOfiClinic',
                                msg: 'Ocurrio un error al guardar la información o no se pudo establecer conexión con el servidor.',
                                buttons: Ext.MessageBox.OK,
                                icon: Ext.MessageBox.ERROR
                            });
                        }
                    },
                    failure: function(response,options)
                    {
                        Ext.MessageBox.hide();
                        Ext.MessageBox.show({
                            title: 'eOfiClinic',
                            msg: 'Ocurrio un error al guardar la información o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                    }
                });
            }else{
                Ext.MessageBox.show({
                    title: 'eOfiClinic',
                    msg: 'Ya se paso por el puesto de terapia fisica o el paciente no esta ubicado en la recepción',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        }else{
            Ext.MessageBox.show({
                title: 'eOfiClinic',
                msg: 'Debe seleccionar un Paciente',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    },
    PuestoMedicina: function(){
        if(Ext.getCmp('gridFormulario').selModel.getCount() == 1){
            var selections = Ext.getCmp('gridFormulario').selModel.getSelections();
            //if (selections[0].json.PasoTomaSignos == '0' && selections[0].json.UbicacionActual == "RECEPCION"){
            if (selections[0].json.ConceptoFinal == 'SIN FINALIZAR'){ // && selections[0].json.UbicacionActual == "RECEPCION"
            // OJO
            //if (selections[0].json.ConceptoFinal == 'SIN FINALIZAR' && selections[0].json.UbicacionActual == "RECEPCION"){ // && selections[0].json.UbicacionActual == "RECEPCION"
                Ext.Ajax.request(
                {
                    waitMsg: 'Por favor Espere...',
                    url: "../../controlador/clinicacaidas/controlador_clinicacaidas.php",
                    params:{
                        task: "CAMBIAR_UBICACION_MEDICINA",
                        pUbicacion: "MEDICINA",
                        pProceso: "MEDICINA",
                        pConsecutivoHC: selections[0].json.ConsecutivoHC
                    },
                    success: function(response,options)
                    {
                        var el = Ext.get('response'); 
                        var Respuesta = response.responseText;
                        var Contenido = Respuesta.split('^');
                        var NroCAS = Contenido[0];
                        paramIdPaciente = selections[0].json.Paciente;
                        if(NroCAS > 0){
                            Ext.getCmp('gridFormulario').store.reload();
                            //Ext.Msg.wait('Cargando Formulario... por favor espere!');
                            var winFrmPuestoTabajo002 = new winFrmPuestoTabajo002Ui();
                            Ext.getCmp('sysPacienteW002').setValue(selections[0].json.TipDoc + " " + selections[0].json.Documento + ' - ' + selections[0].json.PrimerNombre + " " + selections[0].json.SegundoNombre + " " + selections[0].json.PrimerApellido + " " + selections[0].json.SegundoApellido);
                            Ext.getCmp('sysCASW002').setValue(selections[0].json.CAS);
                            Ext.getCmp('sysCASHC').setValue(selections[0].json.CAS);
                            Ext.getCmp('sysConsecutivoDetalleW002').setValue(selections[0].json.ConsecutivoHC);
                            Ext.getCmp('sysConsecutivoDetalleHC').setValue(selections[0].json.ConsecutivoHC);
                            wConsecutivoHC = selections[0].json.ConsecutivoHC;
                            Ext.getCmp('sysIdCodPlantillaW002').setValue(1);
                            Ext.getCmp('sysYaGuardoW002').setValue(1);
                            Ext.getCmp('sysActividadW002').setValue("CLINICA INESTABILIDAD, VERTIGO Y CAIDAS");
                            Ext.getCmp('sysEmpresaW002').setValue(ID_EMPRESA);
                            Ext.getCmp('sysIPSW002').setValue(ID_IPS);
                            Ext.getCmp('sysUsuarioW002').setValue(ID_USUARIO);
                            //Ext.getCmp('sysProfesionalW002').setValue(1);
                            Ext.getCmp('sysAperturaW002').setValue(new Date().format("h:i:s"));
                            
                            Ext.getCmp('sysIdPacienteHC').setValue(selections[0].json.Paciente);
                            Ext.getCmp('sysIdPacienteW002').setValue(selections[0].json.Paciente);
                            Ext.getCmp('sysIdClienteW002').setValue(1);
                            Ext.getCmp('sysIdPlanW002').setValue(1);
                            Ext.getCmp('sysIdSubPlanW002').setValue(1);
                            Ext.getCmp('sysIdContratoW002').setValue(1);
                            Ext.getCmp('sysGeneroPacW002').setValue(selections[0].json.GeneroPaciente);
                            Ext.getCmp('sysDatBasGeneroW002').setValue(selections[0].json.GeneroPaciente);
                            if(selections[0].json.GeneroPaciente === "M"){
                                Ext.getCmp('sysDatBasEdadW002').setValue("MASCULINO");
                            }else{
                                Ext.getCmp('sysDatBasEdadW002').setValue("FEMENINO");
                            }
                            Ext.getCmp('sysFechaW002').setValue(selections[0].json.FechaAtencion);
                            Ext.getCmp('sysProfesionalAgendaW002').setValue("PUESTO TRABAJO DE MEDICINA");
                            Ext.getCmp('sysPasoMedicinaW002').setValue(selections[0].json.PasoMedicina);
                            myPaciente = selections[0].json.Paciente;
                            myCAS = selections[0].json.CAS;
                            wPaciente = selections[0].json.Paciente;
                            wCAS = selections[0].json.CAS;
                            winFrmPuestoTabajo002.show();
                        } else {
                            Ext.Msg.hide();
                            Ext.MessageBox.show({
                                title: 'eOfiClinic',
                                msg: 'Ocurrio un error al guardar la información o no se pudo establecer conexión con el servidor.',
                                buttons: Ext.MessageBox.OK,
                                icon: Ext.MessageBox.ERROR
                            });
                        }
                    },
                    failure: function(response,options)
                    {
                        Ext.MessageBox.hide();
                        Ext.MessageBox.show({
                            title: 'eOfiClinic',
                            msg: 'Ocurrio un error al guardar la información o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                    }
                });
            }else{
                Ext.MessageBox.show({
                    title: 'eOfiClinic',
                    msg: 'Ya se paso por el puesto de medicina o el paciente no esta ubicado en la recepción',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        }else{
            Ext.MessageBox.show({
                title: 'eOfiClinic',
                msg: 'Debe seleccionar un Paciente',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    },
    PuestoEnfermeria: function(){
        if(Ext.getCmp('gridFormulario').selModel.getCount() == 1){
            var selections = Ext.getCmp('gridFormulario').selModel.getSelections();
            if (selections[0].json.ConceptoFinal == 'SIN FINALIZAR' && selections[0].json.UbicacionActual == "RECEPCION"){
                Ext.Ajax.request(
                {
                    waitMsg: 'Por favor Espere...',
                    url: "../../controlador/clinicacaidas/controlador_clinicacaidas.php",
                    params:{
                        task: "CAMBIAR_UBICACION_ENFERMERIA",
                        pUbicacion: "ENFERMERIA",
                        pProceso: "ENFERMERIA",
                        pConsecutivoHC: selections[0].json.ConsecutivoHC
                    },
                    success: function(response,options)
                    {
                        var el = Ext.get('response'); 
                        var Respuesta = response.responseText;
                        var Contenido = Respuesta.split('^');
                        var NroCAS = Contenido[0];
                        paramIdPaciente = selections[0].json.Paciente;
                        if(NroCAS > 0){
                            Ext.getCmp('gridFormulario').store.reload();
                            //Ext.Msg.wait('Cargando Formulario... por favor espere!');
                            var winFrmPuestoTabajo001 = new winFrmPuestoTabajo001Ui();
                            Ext.getCmp('sysPacienteW001').setValue(selections[0].json.TipDoc + " " + selections[0].json.Documento + ' - ' + selections[0].json.PrimerNombre + " " + selections[0].json.SegundoNombre + " " + selections[0].json.PrimerApellido + " " + selections[0].json.SegundoApellido);
                            Ext.getCmp('sysCASW001').setValue(selections[0].json.CAS);
                            Ext.getCmp('sysConsecutivoDetalleW001').setValue(selections[0].json.ConsecutivoHC);
                            wConsecutivoHC = selections[0].json.ConsecutivoHC;
                            Ext.getCmp('sysIdCodPlantillaW001').setValue(1);
                            Ext.getCmp('sysYaGuardoW001').setValue(1);
                            Ext.getCmp('sysActividadW001').setValue("CLINICA INESTABILIDAD, VERTIGO Y CAIDAS");
                            Ext.getCmp('sysEmpresaW001').setValue(ID_EMPRESA);
                            Ext.getCmp('sysIPSW001').setValue(ID_IPS);
                            Ext.getCmp('sysUsuarioW001').setValue(ID_USUARIO);
                            //Ext.getCmp('sysProfesionalW001').setValue(1);
                            Ext.getCmp('sysAperturaW001').setValue(new Date().format("h:i:s"));
                            
                            Ext.getCmp('sysIdPacienteW001').setValue(selections[0].json.Paciente);
                            Ext.getCmp('sysIdClienteW001').setValue(1);
                            Ext.getCmp('sysIdPlanW001').setValue(1);
                            Ext.getCmp('sysIdSubPlanW001').setValue(1);
                            Ext.getCmp('sysIdContratoW001').setValue(1);
                            Ext.getCmp('sysGeneroPacW001').setValue(selections[0].json.GeneroPaciente);
                            Ext.getCmp('sysDatBasGeneroW001').setValue(selections[0].json.GeneroPaciente);
                            if(selections[0].json.GeneroPaciente === "M"){
                                Ext.getCmp('sysDatBasEdadW001').setValue("MASCULINO");
                            }else{
                                Ext.getCmp('sysDatBasEdadW001').setValue("FEMENINO");
                            }
                            Ext.getCmp('sysFechaW001').setValue(selections[0].json.FechaAtencion);
                            Ext.getCmp('sysProfesionalAgendaW001').setValue("PUESTO TRABAJO DE ENFERMERIA");
                            
                            winFrmPuestoTabajo001.show();
                        } else {
                            Ext.Msg.hide();
                            Ext.MessageBox.show({
                                title: 'eOfiClinic',
                                msg: 'Ocurrio un error al guardar la información o no se pudo establecer conexión con el servidor.',
                                buttons: Ext.MessageBox.OK,
                                icon: Ext.MessageBox.ERROR
                            });
                        }
                    },
                    failure: function(response,options)
                    {
                        Ext.MessageBox.hide();
                        Ext.MessageBox.show({
                            title: 'eOfiClinic',
                            msg: 'Ocurrio un error al guardar la información o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                    }
                });
            }else{
                Ext.MessageBox.show({
                    title: 'eOfiClinic',
                    msg: 'Ya se paso por el puesto de enfermeria o el paciente no esta ubicado en la recepción',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        }else{
            Ext.MessageBox.show({
                title: 'eOfiClinic',
                msg: 'Debe seleccionar un Paciente',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    },
    PrintHistoriaOcupacionalSO: function(){
        if(Ext.getCmp('gridFormulario').selModel.getCount() == 1)
        {
            var selections = Ext.getCmp('gridFormulario').selModel.getSelections();
            window.open ("../../controlador/asistencial/printsaludocupa.php?pEmpresa=" + ID_EMPRESA + "&pIPS=" + ID_IPS + "&pPaciente=" + selections[0].json.Paciente + "&pEvolucion=" + selections[0].json.CAS,"Historia Ocupacional");
        }
    },
    HistoriaOcupacionalSO: function(){
        if(Ext.getCmp('gridFormulario').selModel.getCount() == 1)
        {
            var selections = Ext.getCmp('gridFormulario').selModel.getSelections();
            if (selections[0].json.ConceptoFinal == 'SIN DEFINIR' && selections[0].json.PasoTomaSignos == '1' && selections[0].json.UbicacionActual == "RECEPCION"){
                wPaciente = selections[0].json.Paciente;
                wCAS = selections[0].json.CAS;
                Ext.Ajax.request(
                {
                    waitMsg: 'Por favor Espere...',
                    url: "../../controlador/asistencial/saludocupacional.php",
                    params:{
                        task: "CAMBIAR_UBICACION_VALMEDICA",
                        pUbicacion: "VALORACION MEDICA",
                        pProceso: "VALORACION MEDICA",
                        pConsecutivoHC: selections[0].json.ConsecutivoHC
                    },
                    success: function(response,options)
                    {
                        var el = Ext.get('response'); 
                        var Respuesta = response.responseText;
                        var Contenido = Respuesta.split('^');
                        var NroCAS = Contenido[0];
                        if(NroCAS > 0){
                            Ext.getCmp('gridFormulario').store.reload();
                            paramIdPaciente = selections[0].json.Paciente;
                            if(selections[0].json.PasoMedicoOcupacional == "0"){
                                paramOpcion = "Nuevo";
                            }else{
                                if(selections[0].json.ConceptoMedicoOcupacional == "SIN DEFINIR"){
                                    paramOpcion = "Nuevo";
                                }else{
                                    paramOpcion = "Modificar";
                                }
                            }
                            var winTomaSignos = new winHCPartisalud001ValoracionMedicaUi();
                            if(selections[0].json.TipoExamen != null){
                                Ext.getCmp('memMotivoConsulta').setValue("EXAMEN DE " + selections[0].json.TipoExamen.toUpperCase());
                            }
                            Ext.getCmp('memEnfermedadActual').setValue("ASINTOMATICO");
                            Ext.getCmp('sysPacienteHC').setValue(selections[0].json.TipDoc + " " + selections[0].json.Documento + ' - ' + selections[0].json.PrimerNombre + " " + selections[0].json.SegundoNombre + " " + selections[0].json.PrimerApellido + " " + selections[0].json.SegundoApellido);
                            Ext.getCmp('sysCASHC').setValue(selections[0].json.CAS);
                            Ext.getCmp('sysConsecutivoDetalleHC').setValue(selections[0].json.ConsecutivoHC);
                            Ext.getCmp('sysIdPacienteHC').setValue(selections[0].json.Paciente);
                            if(selections[0].json.GeneroPaciente == "M"){
                                Ext.getCmp('fsAPGINECO').setVisible(false);
                            }else{
                                Ext.getCmp('fsAPGINECO').setVisible(true);
                            }
                            winTomaSignos.show();
                            
                        } else {
                            Ext.Msg.hide();
                            Ext.MessageBox.show({
                                title: 'eOfiClinic',
                                msg: 'Ocurrio un error al guardar la información o no se pudo establecer conexión con el servidor.',
                                buttons: Ext.MessageBox.OK,
                                icon: Ext.MessageBox.ERROR
                            });
                        }
                    },
                    failure: function(response,options)
                    {
                        Ext.MessageBox.hide();
                        Ext.MessageBox.show({
                            title: 'eOfiClinic',
                            msg: 'Ocurrio un error al guardar la información o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                    }
                });
            }else{
                Ext.MessageBox.show({
                    title: 'eOfiClinic',
                    msg: 'Ya se realizo el proceso de valoración medica y/o no se ha registrado la toma de signos o el paciente no esta ubicado en la recepción',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        }else{
            Ext.MessageBox.show({
                title: 'eOfiClinic',
                msg: 'Debe seleccionar un Paciente',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    },
    FonoaudiologiaSO: function(){
        if(Ext.getCmp('gridFormulario').selModel.getCount() == 1)
        {
            var selections = Ext.getCmp('gridFormulario').selModel.getSelections();
            if (selections[0].json.ConceptoFinal == 'SIN DEFINIR' && selections[0].json.UbicacionActual == "RECEPCION"){ //&& selections[0].json.UbicacionActual == "RECEPCION"
                Ext.Ajax.request(
                {
                    waitMsg: 'Por favor Espere...',
                    url: "../../controlador/asistencial/saludocupacional.php",
                    params:{
                        task: "CAMBIAR_UBICACION_FONOAUDIOLOGIA",
                        pUbicacion: "FONOAUDIOLOGIA",
                        pProceso: "FONOAUDIOLOGIA",
                        pConsecutivoHC: selections[0].json.ConsecutivoHC
                    },
                    success: function(response,options)
                    {
                        var el = Ext.get('response');
                        var Respuesta = response.responseText;
                        var Contenido = Respuesta.split('^');
                        var NroCAS = Contenido[0];
                        paramIdPaciente = selections[0].json.Paciente;
                        wPaciente = selections[0].json.Paciente;
                        wCAS = selections[0].json.CAS;
                        if(NroCAS > 0){
                            Ext.getCmp('gridFormulario').store.reload();
                            if(selections[0].json.PasoFonoaudiologia == "0"){
                                paramOpcion = "Nuevo";
                            }else{
                                paramOpcion = "Modificar";
                            }
                            Ext.Msg.wait('Cargando Formulario... por favor espere!');
                            var winFono = new winHCPartisalud001FonoaudiologiaUi();
                            Ext.getCmp('sysPacienteHC').setValue(selections[0].json.TipDoc + " " + selections[0].json.Documento + ' - ' + selections[0].json.PrimerNombre + " " + selections[0].json.SegundoNombre + " " + selections[0].json.PrimerApellido + " " + selections[0].json.SegundoApellido);
                            Ext.getCmp('sysCASHC').setValue(selections[0].json.CAS);
                            Ext.getCmp('sysConsecutivoDetalleHC').setValue(selections[0].json.ConsecutivoHC);
                            Ext.getCmp('sysIdPacienteHC').setValue(selections[0].json.Paciente);
                            winFono.show();
                        } else {
                            Ext.Msg.hide();
                            Ext.MessageBox.show({
                                title: 'eOfiClinic',
                                msg: 'Ocurrio un error al guardar la información o no se pudo establecer conexión con el servidor.',
                                buttons: Ext.MessageBox.OK,
                                icon: Ext.MessageBox.ERROR
                            });
                        }
                    },
                    failure: function(response,options)
                    {
                        Ext.MessageBox.hide();
                        Ext.MessageBox.show({
                            title: 'eOfiClinic',
                            msg: 'Ocurrio un error al guardar la información o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                    }
                });
            }else{
                Ext.MessageBox.show({
                    title: 'eOfiClinic',
                    msg: 'Ya se realizo el proceso de fonoaudiologia o el paciente no esta ubicado en la recepción',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        }else{
            Ext.MessageBox.show({
                title: 'eOfiClinic',
                msg: 'Debe seleccionar un Paciente',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    },
    LaboratorioSO: function(){
        if(Ext.getCmp('gridFormulario').selModel.getCount() == 1)
        {
            var selections = Ext.getCmp('gridFormulario').selModel.getSelections();
            if (selections[0].json.ConceptoFinal == 'SIN DEFINIR' && selections[0].json.UbicacionActual == "RECEPCION"){
                Ext.Ajax.request(
                {
                    waitMsg: 'Por favor Espere...',
                    url: "../../controlador/asistencial/saludocupacional.php",
                    params:{
                        task: "CAMBIAR_UBICACION_TOMALABO",
                        pUbicacion: "TOMA DE MUESTRAS",
                        pProceso: "TOMA DE MUESTRAS",
                        pConsecutivoHC: selections[0].json.ConsecutivoHC
                    },
                    success: function(response,options)
                    {
                        var el = Ext.get('response');
                        var Respuesta = response.responseText;
                        var Contenido = Respuesta.split('^');
                        var NroCAS = Contenido[0];
                        if(NroCAS > 0){
                            Ext.getCmp('gridFormulario').store.reload();
                            Ext.Msg.wait('Cargando Formulario... por favor espere!');
                            var winResultLabo = new winHCPartisalud001ResultLaboUi();
                            Ext.getCmp('sysPacienteHC').setValue(selections[0].json.TipDoc + " " + selections[0].json.Documento + ' - ' + selections[0].json.PrimerNombre + " " + selections[0].json.SegundoNombre + " " + selections[0].json.PrimerApellido + " " + selections[0].json.SegundoApellido);
                            Ext.getCmp('sysCASHC').setValue(selections[0].json.CAS);
                            Ext.getCmp('sysConsecutivoDetalleHC').setValue(selections[0].json.ConsecutivoHC);
                            Ext.getCmp('sysIdPacienteHC').setValue(selections[0].json.Paciente);
                            winResultLabo.show();
                        } else {
                            Ext.Msg.hide();
                            Ext.MessageBox.show({
                                title: 'eOfiClinic',
                                msg: 'Ocurrio un error al guardar la información o no se pudo establecer conexión con el servidor.',
                                buttons: Ext.MessageBox.OK,
                                icon: Ext.MessageBox.ERROR
                            });
                        }
                    },
                    failure: function(response,options)
                    {
                        Ext.MessageBox.hide();
                        Ext.MessageBox.show({
                            title: 'eOfiClinic',
                            msg: 'Ocurrio un error al guardar la información o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                    }
                });
            }else{
                Ext.MessageBox.show({
                    title: 'eOfiClinic',
                    msg: 'Ya se realizo el proceso de laboratorio o el paciente no esta ubicado en la recepción',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        }else{
            Ext.MessageBox.show({
                title: 'eOfiClinic',
                msg: 'Debe seleccionar un Paciente',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    },
    TomaMuestrasSO: function(){
        if(Ext.getCmp('gridFormulario').selModel.getCount() == 1)
        {
            var selections = Ext.getCmp('gridFormulario').selModel.getSelections();
            //if (selections[0].json.PasoTomaSignos == '0' && selections[0].json.UbicacionActual == "RECEPCION"){
            if (selections[0].json.ConceptoFinal == 'SIN DEFINIR' && selections[0].json.UbicacionActual == "RECEPCION"){ // && selections[0].json.UbicacionActual == "RECEPCION"
                Ext.Ajax.request(
                {
                    waitMsg: 'Por favor Espere...',
                    url: "../../controlador/asistencial/saludocupacional.php",
                    params:{
                        task: "CAMBIAR_UBICACION_TOMAMUESTRAS",
                        pUbicacion: "TOMA DE SIGNOS",
                        pProceso: "TOMA DE SIGNOS",
                        pConsecutivoHC: selections[0].json.ConsecutivoHC
                    },
                    success: function(response,options)
                    {
                        var el = Ext.get('response'); 
                        var Respuesta = response.responseText;
                        var Contenido = Respuesta.split('^');
                        var NroCAS = Contenido[0];
                        paramIdPaciente = selections[0].json.Paciente;
                        if(NroCAS > 0){
                            Ext.getCmp('gridFormulario').store.reload();
                            Ext.Msg.wait('Cargando Formulario... por favor espere!');
                            var winTomaSignos = new winHCPartisalud001TomaMuestrasUi();
                            Ext.getCmp('sysPacienteHC').setValue(selections[0].json.TipDoc + " " + selections[0].json.Documento + ' - ' + selections[0].json.PrimerNombre + " " + selections[0].json.SegundoNombre + " " + selections[0].json.PrimerApellido + " " + selections[0].json.SegundoApellido);
                            Ext.getCmp('sysCASHC').setValue(selections[0].json.CAS);
                            Ext.getCmp('sysConsecutivoDetalleHC').setValue(selections[0].json.ConsecutivoHC);
                            Ext.getCmp('sysIdPacienteHC').setValue(selections[0].json.Paciente);
                            winTomaSignos.show();
                        } else {
                            Ext.Msg.hide();
                            Ext.MessageBox.show({
                                title: 'eOfiClinic',
                                msg: 'Ocurrio un error al guardar la información o no se pudo establecer conexión con el servidor.',
                                buttons: Ext.MessageBox.OK,
                                icon: Ext.MessageBox.ERROR
                            });
                        }
                    },
                    failure: function(response,options)
                    {
                        Ext.MessageBox.hide();
                        Ext.MessageBox.show({
                            title: 'eOfiClinic',
                            msg: 'Ocurrio un error al guardar la información o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                    }
                });
            }else{
                Ext.MessageBox.show({
                    title: 'eOfiClinic',
                    msg: 'Ya se realizo la toma de signos o el paciente no esta ubicado en la recepción',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        }else{
            Ext.MessageBox.show({
                title: 'eOfiClinic',
                msg: 'Debe seleccionar un Paciente',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    },
    ActualizarAgenda: function(){
        Ext.getCmp('gridFormulario').store.reload();
    },
    CargaDetalleAgenda: function(f, d) {
        Ext.getCmp('gridFormulario').store.load({
            params: {
                pAgenda: d.format("Y-m-d")
            }
        }); 
    },
    SalirOpcion: function(){
        Ext.Msg.show({
            title: 'eOfiClinic',
            msg: 'Esta seguro que desea cerrar la ventana?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    window.close();
                }
            }
        });
    },
    CerrarVentana: function(){
        Ext.Msg.show({
            title: 'eOfiClinic',
            msg: 'Esta seguro que desea cerrar la ventana?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                   Ext.getCmp('winProfesionalesUi').close();
                }
            }
        });
    }
});

