/*
* @category    Solicitud Consentimientos Informados
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

GridConsentimientosInformadosUi = Ext.extend(Ext.Panel, {
    anchor: '100%',
    autoHeight: true,
    initComponent: function() {
        
        function renderObservaConsentimiento(value, metaData, record, rowIndex, colIndex, store){  
            metaData.attr = 'style="white-space:normal"';  
            return value;  
        }
        
        function renderFirmaConsentimiento(value, metaData, record, rowIndex, colIndex, store){  
            metaData.attr = 'style="white-space:normal"'; 
            //alert("DATO: " + value + " - " + ImageExist('../../../empresas/' + ID_EMPRESA + '/pacientes/' + record.get('Paciente') + '/consentimiento/sing' + value + '.png'));
            //if(isValidUrl('../../../empresas/' + ID_EMPRESA + '/pacientes/' + record.get('Paciente') + '/consentimiento/sing' + value + '.png') === "SI"){
                return '<table border="0"><tr><td align="center"><img src="../../../empresas/' + ID_EMPRESA + '/consentimientos/' + record.get('IdConsecutivoConsentimiento') + '_firma.png" height="60" width="130"/></td></tr></table>';
            //}
            /*if(record.get('ReporteVal') !== "" && record.get('ReporteVal') !== null){
                return value + "<br><hr>Valor: " + record.get('ReporteVal');  
            }else{
                return value;  
            }*/
        }
        
        function renderFotoConsentimiento(value, metaData, record, rowIndex, colIndex, store){  
            metaData.attr = 'style="white-space:normal"'; 
            //if(isValidUrl('../../../empresas/' + ID_EMPRESA + '/pacientes/' + record.get('Paciente') + '/consentimiento/pic' + value + '.png') === "SI"){
                return '<table border="0"><tr><td align="center"><img src="../../../empresas/' + ID_EMPRESA + '/consentimientos/' + record.get('IdConsecutivoConsentimiento') + '_foto.jpg" height="72" width="96"/></td></tr></table>';
            //}else{
                //return '<table border="0"><tr><td align="center"><img src="../../../resources/varios/nofoto.png" height="72" width="96"/></td></tr></table>';
            //}
            /*if(record.get('ReporteVal') !== "" && record.get('ReporteVal') !== null){
                return value + "<br><hr>Valor: " + record.get('ReporteVal');  
            }else{
                return value;  
            }*/
        }
        var stConsentimientosInformados = new StoreGridConsentimientosInformadosxPac();
        stConsentimientosInformados.load({
            params: {
                pPaciente: wPaciente
            }
        });
        
        this.items = [
            {
                xtype: 'grid',
                title: ' ',
                id: 'gridConsentimientosInformadosxPac',
                store: stConsentimientosInformados,
                anchor: "100%",
                height: 290,
                border: false,
                frame: true,
                loadMask: true,
                colModel: new Ext.ux.grid.LockingColumnModel([                    
                    {
                        xtype: 'gridcolumn',
                        header: 'Id',
                        sortable: false,
                        width: 1,
                        hidden: true,
                        hideable: false,
                        dataIndex: 'IdConsecutivoConsentimiento'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Consentimiento',
                        sortable: false,
                        width: 300,
                        dataIndex: 'NomConsentimiento'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Fecha Solicitud',
                        sortable: false,
                        width: 90,
                        dataIndex: 'FechaRegistro'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Fecha Aceptacion',
                        sortable: false,
                        width: 120,
                        dataIndex: 'FechaAceptacion'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Observaciones',
                        sortable: false,
                        width: 150,
                        renderer: renderObservaConsentimiento,
                        dataIndex: 'Observaciones'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Responsable',
                        sortable: false,
                        width: 150,
                        dataIndex: 'Responsable'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Frima',
                        sortable: false,
                        width: 150,
                        dataIndex: 'IdConsecutivoConsentimiento',
                        renderer: renderFirmaConsentimiento
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Foto',
                        sortable: false,
                        width: 150,
                        dataIndex: 'IdConsecutivoConsentimiento',
                        renderer: renderFotoConsentimiento
                    }
                    
                ]),
                selModel: new Ext.grid.RowSelectionModel({singleSelect:false}),
                viewConfig: {
                    getRowClass: function(record, index) {
                        switch (record.get('FirmaAceptacion')){
                            case "N":
                                return 'Negado';
                                break;
                            case "X":
                                return 'Amarillo';
                                break;
                            case "S":
                                return 'Apto';
                                break;
                            default:
                                return;
                                break;
                        }
                    }
                },
                iconCls:'icon-grid',
                bbar: {
                    xtype: 'toolbar',
                    items: [
                        {
                            xtype: 'button',
                            text: 'Actualizar',
                            iconCls: 'btnActualizarGrid',
                            listeners: {
                                click: function(){
                                    try {
                                        var campoIdPaciente = Ext.getCmp('intIdPaciente');
                                        if ( campoIdPaciente !== null ) {
                                            Ext.getCmp('gridConsentimientosInformadosxPac').store.load({
                                                params: {
                                                    pPaciente: Ext.getCmp('intIdPaciente').getValue()
                                                }
                                            });
                                        }
                                    }catch(ex) {
                                        Ext.getCmp('gridConsentimientosInformadosxPac').store.reload();
                                    }
                                }
                            }
                        }
                    ]
                },
                    
                tbar:
                    {
                        xtype: 'toolbar',
                        items: [
                            {
                                xtype: 'button',
                                text: 'Adicionar',
                                iconCls: 'btnAddRow',
                                id: 'btnAddConsentiomientoInf',
                                listeners: {
                                    click : function() {
                                        try {
                                            var campoIdPaciente = Ext.getCmp('intIdPaciente');
                                            if ( campoIdPaciente !== null ) {
                                                wPaciente = Ext.getCmp('intIdPaciente').getValue();
                                            }
                                        }catch(ex) {
                                            //Ext.getCmp('gridConsentimientosInformadosxPac').store.reload();
                                        }    
                                        if(parseInt(wPaciente) !== 0){
                                            var winAddSolicitudConsentimiento = new winAddSolConentimientoInformado001Ui();
                                            Ext.getCmp('intPacienteSolConsentimento').setValue(wPaciente);
                                            Ext.getCmp('intUsuarioSolConsentimento').setValue(ID_USUARIO);
                                            Ext.getCmp('intIdConsecutivoSolConsentimento').setValue(0);
                                            Ext.getCmp('strResponsableSolConsentimento').setValue(NOM_USUARIO);
                                            winAddSolicitudConsentimiento.show();
                                        }
                                    }
                                }
                            },
                            {
                                xtype: 'tbseparator'
                            },
                            {
                                xtype: 'button',
                                text: 'Eliminar',
                                iconCls: 'btnDelRow',
                                id: 'btnDelConsentiomientoInf',
                                listeners: {
                                    click : function() {
                                        wUSUARIO = 0;
                                        try {
                                            var campoIdPaciente = Ext.getCmp('sysUsuarioHC');
                                            if ( campoIdPaciente !== null ) {
                                                wUSUARIO = Ext.getCmp('sysUsuarioHC').getValue();
                                            }
                                        }catch(ex) {
                                            wUSUARIO = ID_USUARIO;
                                        }    
                                        if(Ext.getCmp('gridConsentimientosInformadosxPac').selModel.getCount() === 1){
                                            var selections = Ext.getCmp('gridConsentimientosInformadosxPac').selModel.getSelections();
                                            if(selections[0].json.FirmaAceptacion === "N" && parseInt(selections[0].json.Usuario) === parseInt(wUSUARIO)){
                                                Ext.Msg.show({
                                                    title: 'Consentimiento Informado',
                                                    msg: 'Esta Seguro que Desea Eliminar el Registro ' + selections[0].json.NomConsentimiento + '?',
                                                    buttons: Ext.Msg.YESNO,
                                                    icon: Ext.Msg.QUESTION,
                                                    fn: function(btn){
                                                        if(btn ==="yes"){
                                                            fnEliminarRegistrosConsentimientoInformado("../../controlador/consentimientoinformado/controlador_consentimiento.php",{task: "ELIMINAR_CONSENTIMIENTO", pIdConsentimiento: selections[0].json.IdConsecutivoConsentimiento}, 'gridConsentimientosInformadosxPac');
                                                        }
                                                    }
                                                });
                                            }else{
                                                Ext.MessageBox.show({
                                                    title: 'Error',
                                                    msg: 'No podemos eliminar los registro en estos momentos',
                                                    buttons: Ext.MessageBox.OK,
                                                    icon: Ext.MessageBox.ERROR
                                                });
                                            }
                                        }else{
                                            Ext.MessageBox.show({
                                                title: 'Error',
                                                msg: 'No podemos eliminar los registros en estos momentos, verifique que solo haya seleccionado un registro',
                                                buttons: Ext.MessageBox.OK,
                                                icon: Ext.MessageBox.ERROR
                                            });
                                        }
                                    }
                                }
                            },
                            {
                                xtype: 'tbseparator'
                            },
                            {
                                xtype: 'button',
                                text: 'Registro Consentimiento',
                                iconCls: 'btnAceptar',
                                listeners: {
                                    click : function() {
                                        if(Ext.getCmp('gridConsentimientosInformadosxPac').selModel.getCount() === 1){
                                            var selections = Ext.getCmp('gridConsentimientosInformadosxPac').selModel.getSelections();
                                            if(selections[0].json.FirmaAceptacion === "X"){
                                                //window.open (selections[0].json.RutaConsentimiento + "?pPaciente=" + selections[0].json.Paciente + "&p0=" + selections[0].json.TipDoc + "-" + selections[0].json.Documento + "&p1=" +  PonerAcentosMayusculas(selections[0].json.nomPaciente) + "&p2=" + selections[0].json.Edad + "&p4=" + selections[0].json.Responsable + "&p5=" + selections[0].json.Titulo + "&p6=" + selections[0].json.IdCodigo + "&p7=" + selections[0].json.IdVersion + "&p8=" + selections[0].json.FechaPublica + "&pK=" + selections[0].json.IdConsecutivoConsentimiento,"Registro Firma Consentimiento");
                                                var ruta = selections[0].json.RutaConsentimiento.substr(6, 200);
                                                var myURL = "https://www.medicareips.com.co/oficlinic/app/" + ruta;
                                                window.open (myURL + "?pPaciente=" + selections[0].json.Paciente + "&p0=" + selections[0].json.TipDoc + "-" + selections[0].json.Documento + "&p1=" +  PonerAcentosMayusculas(selections[0].json.nomPaciente) + "&p2=" + selections[0].json.Edad + "&p4=" + selections[0].json.Responsable + "&p5=" + selections[0].json.Titulo + "&p6=" + selections[0].json.IdCodigo + "&p7=" + selections[0].json.IdVersion + "&p8=" + selections[0].json.FechaPublica + "&pK=" + selections[0].json.IdConsecutivoConsentimiento,"Registro Firma Consentimiento");
                                            }else{
                                                Ext.MessageBox.show({
                                                    title: 'Error',
                                                    msg: 'El registro no esta disponible para realizar el registro',
                                                    buttons: Ext.MessageBox.OK,
                                                    icon: Ext.MessageBox.ERROR
                                                });
                                            }
                                        }
                                    }
                                }
                            },
                            {
                                xtype: 'tbseparator'
                            },
                            /*{
                                xtype: 'button',
                                text: 'Adjuntar Foto Anexo',
                                iconCls: 'btnCargarFoto',
                                listeners: {
                                    click : function() {
                                        if(Ext.getCmp('gridConsentimientosInformadosxPac').selModel.getCount() === 1){
                                            var selections = Ext.getCmp('gridConsentimientosInformadosxPac').selModel.getSelections();
                                            if(selections[0].json.FotoAnexo === "0"){
                                                window.open ("../consentimientoinformado/medicare/capturafotoanexo.php?pPaciente=" + selections[0].json.Paciente + "&p0=" + selections[0].json.TipDoc + "-" + selections[0].json.Documento + "&p1=" + selections[0].json.nomPaciente + "&p2=" + selections[0].json.Edad + "&p4=" + selections[0].json.Responsable + "&p5=" + selections[0].json.Titulo + "&p6=" + selections[0].json.IdCodigo + "&p7=" + selections[0].json.IdVersion + "&p8=" + selections[0].json.FechaPublica + "&pK=" + selections[0].json.IdConsecutivoConsentimiento,"Registro Anexos Consentimiento");
                                            }else{
                                                Ext.MessageBox.show({
                                                    title: 'Error',
                                                    msg: 'El registro no esta disponible para realizar el anexo',
                                                    buttons: Ext.MessageBox.OK,
                                                    icon: Ext.MessageBox.ERROR
                                                });
                                            }
                                        }
                                    }
                                }
                            },
                            {
                                xtype: 'tbseparator'
                            },*/
                            {
                                xtype: 'button',
                                text: 'Imprimir Consentimiento',
                                iconCls: 'btnImprimir',
                                listeners: {
                                    click : function() {
                                        if(Ext.getCmp('gridConsentimientosInformadosxPac').selModel.getCount() === 1){
                                            var selections = Ext.getCmp('gridConsentimientosInformadosxPac').selModel.getSelections();
                                            if(selections[0].json.FirmaAceptacion !== "X"){
                                                window.open ("../consentimientoinformado/medicare/imprimirconsentimiento.php?pPaciente=" + selections[0].json.Paciente + "&p0=" + selections[0].json.TipDoc + "-" + selections[0].json.Documento + "&p1=" + PonerAcentosMayusculas(selections[0].json.nomPaciente) + "&p2=" + selections[0].json.Edad + "&p4=" + selections[0].json.Responsable + "&p5=" + selections[0].json.Titulo + "&p6=" + selections[0].json.IdCodigo + "&p7=" + selections[0].json.IdVersion + "&p8=" + selections[0].json.FechaPublica + "&pK=" + selections[0].json.IdConsecutivoConsentimiento,"Imprimir Consentimiento");
                                            }else{
                                                Ext.MessageBox.show({
                                                    title: 'Error',
                                                    msg: 'El registro no esta disponible para imprimir',
                                                    buttons: Ext.MessageBox.OK,
                                                    icon: Ext.MessageBox.ERROR
                                                });
                                            }
                                        }
                                    }
                                }
                            },
                            {
                                xtype: 'tbseparator'
                            },
                            '->',
                            new Ext.app.SearchField({
                                id: 'qryConsentimientoInformado',
                                store: stConsentimientosInformados,
                                ValparamP1: wPaciente,
                                emptyText: 'Escriba el criterio que desea buscar',
                                width: 120,
                                pLoadGrid: false,
                                pGrid: 'gridConsentimientosInformadosxPac',
                                parrParam: {params:{pPaciente: wPaciente}}
                            })
                        ]
                    }
            }
        ];
        GridConsentimientosInformadosUi.superclass.initComponent.call(this);
    }
});

function fnEliminarRegistrosConsentimientoInformado(URL,arrParam, pGrid, arrParamStore){
    Ext.Ajax.request({
        waitMsg: 'Por favor Espere...',
        url: URL,
        params: arrParam,
        success: function(response){
            var result=eval(response.responseText);
            switch(result){
                case 1:
                    if (typeof pGrid !== 'undefined'){
                        Ext.getCmp(pGrid).store.reload(arrParamStore);
                        ID_PLANTILLA_CITAS = 0;
                    }
                    break;

                case 3:
                    if (typeof pGrid !== 'undefined'){
                        Ext.getCmp(pGrid).store.reload(arrParamStore);
                        ID_PLANTILLA_CITAS = 0;
                        Ext.MessageBox.show({
                            title: 'eOfiClinic',
                            msg: 'Alguno de los registros no se pudieron eliminar',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.WARNING
                        });
                    }
                    break;

                default:
                    Ext.MessageBox.show({
                        title: 'Error',
                        msg: 'No podemos eliminar el registro en estos momentos o existen datos relacionados en otras tablas',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                    break;
            }
        },
        failure: function(response){
            var result = response.responseText;
            Ext.MessageBox.show({
                title: 'Error Base Datos',
                msg: 'No podemos eliminar los registros en estos momentos',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    });
}

function ImageExist(url){
   var img = new Image();
   img.src = url;
   return img.height != 0;
}