/*
* @category    Grid Diagrama Control de Placa
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

GridEditControlPlacaUi = Ext.extend(Ext.Window, {
    title: 'Editar Diagrama Control de Placa',
    anchor: '100%',
    autoHeight: true,
    closable: true,
    modal: true,
    initComponent: function() {
        function DescripcionSuperficieCP(val, x, store){
            var superficie = val.replace(/-N/g,"");
            return superficie;
        }
        
        this.items = [
            {
                xtype: 'hidden',
                anchor: '100%',
                allowBlank: true,
                readOnly: true,
                id: 'sysIdControlPlacaItem'
            },
            {
                xtype: 'hidden',
                anchor: '100%',
                allowBlank: true,
                readOnly: true,
                id: 'sysTipoDenticionItemControlPlaca'
            },
            {
                xtype: 'grid',
                title: ' ',
                id: 'gridEditControlPlacaHC',
                store: 'StoreGridEditControlPlacaHC',
                anchor: "100%",
                height: 470,
                border: false,
                frame: true,
                loadMask: true,
                colModel: new Ext.ux.grid.LockingColumnModel([
                    {
                        xtype: 'gridcolumn',
                        header: 'Id',
                        sortable: false,
                        width: 1,
                        hidden: true,
                        hideable: false,
                        dataIndex: 'IdOdontogramaDetalle'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Diente',
                        sortable: true,
                        width: 50,
                        dataIndex: 'Diente'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Diagnostico',
                        sortable: false,
                        width: 250,
                        dataIndex: 'descDiagnostico'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Superficie',
                        sortable: false,
                        width: 100,
                        dataIndex: 'Superficies',
                        renderer: DescripcionSuperficieCP
                    }
                ]),
                selModel: new Ext.grid.RowSelectionModel({singleSelect:false}),
                iconCls:'icon-grid',
                //view: new Ext.grid.GroupingView(),
                bbar: {
                    xtype: 'toolbar',
                    items: [
                        {
                            xtype: 'button',
                            text: 'Pintar Diagrama Control Placa',
                            iconCls: 'btnDiente',
                            listeners: {
                                click : function() {
                                    var updater = Ext.getCmp('ControlPlacaInical').getUpdater();
                                    updater.setDefaultUrl('../../../app/frm/controlplaca/controlplaca001.php?pPaciente=' + wPaciente + '&pCAS=' + wCAS + '&pOdontograma=' + Ext.getCmp('sysIdControlPlacaItem').getValue());
                                    updater.refresh();
                                }
                            }
                        },
                        {
                            xtype: 'tbseparator'
                        }
                    ]
                },
                tbar:
                    {
                        xtype: 'toolbar',
                        items: [
                            {
                                xtype: 'button',
                                text: 'Adicionar',
                                iconCls: 'btnAddRow',
                                listeners: {
                                    click : function() {
                                        var winAddItemDetelleControlPlaca = new winAddItemDetelleControlPlacaUi();
                                        Ext.getCmp('intIdDetalleControlPlaca').setValue(Ext.getCmp('sysIdControlPlacaItem').getValue());
                                        Ext.getCmp('intNroDienteDetalleControlPlaca').store.load({
                                            params: {
                                                pTipo: Ext.getCmp('sysTipoDenticionItemControlPlaca').getValue()
                                            }
                                        });
                                        winAddItemDetelleControlPlaca.show();
                                    }
                                }
                            },
                            {
                                xtype: 'tbseparator'
                            },
                            {
                                xtype: 'button',
                                text: 'Eliminar',
                                iconCls: 'btnDelRow',
                                listeners: {
                                    click : function() {
                                        if(Ext.getCmp('gridEditControlPlacaHC').selModel.getCount() === 1){
                                            var selections = Ext.getCmp('gridEditControlPlacaHC').selModel.getSelections();
                                            Ext.Msg.show({
                                                title: 'Diagnostico',
                                                msg: 'Esta Seguro que Desea Eliminar el Registro Diente: ' + selections[0].json.Diente + ' - Dx: ' + selections[0].json.descDiagnostico + ' -Sup: ' + selections[0].json.Superficies + '?',
                                                buttons: Ext.Msg.YESNO,
                                                icon: Ext.Msg.QUESTION,
                                                fn: function(btn){
                                                    if(btn==="yes"){
                                                        fnEliminarRegistrosControlPlaca("../../controlador/odontograma/controlador_odontograma.php",{task: "ELIMINAR_ITEM_DETALLECONTROLPLACA", pIdItem: selections[0].json.IdOdontogramaDetalle}, 'gridEditControlPlacaHC')
                                                    }
                                                }
                                            });
                                        }else{
                                            Ext.MessageBox.show({
                                                title: 'Error',
                                                msg: 'No podemos eliminar los registros en estos momentos, verifique que solo haya seleccionado un registro',
                                                buttons: Ext.MessageBox.OK,
                                                icon: Ext.MessageBox.ERROR
                                            });
                                        }
                                    }
                                }
                            },
                            {
                                xtype: 'tbseparator'
                            }
                        ]
                    }
            }
        ];
        GridEditControlPlacaUi.superclass.initComponent.call(this);
    }
});


function fnEliminarRegistrosControlPlaca(URL,arrParam, pGrid, arrParamStore){
    Ext.Ajax.request({
        waitMsg: 'Por favor Espere...',
        url: URL,
        params: arrParam,
        success: function(response){
            var result=eval(response.responseText);
            switch(result){
                case 1:
                    if (typeof pGrid != 'undefined')
                    {
                        Ext.getCmp(pGrid).store.reload(arrParamStore);
                        ID_PLANTILLA_CITAS = 0;
                    }
                    break;

                case 3:
                    if (typeof pGrid != 'undefined')
                    {
                        Ext.getCmp(pGrid).store.reload(arrParamStore);
                        ID_PLANTILLA_CITAS = 0;
                        Ext.MessageBox.show({
                            title: 'eOfiClinic',
                            msg: 'Alguno de los registros no se pudieron eliminar',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.WARNING
                        });
                    }
                    break;

                default:
                    Ext.MessageBox.show({
                        title: 'Error',
                        msg: 'No podemos eliminar el registro en estos momentos o existen datos relacionados en otras tablas',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                    break;
            }
        },
        failure: function(response){
            var result = response.responseText;
            Ext.MessageBox.show({
                title: 'Error Base Datos',
                msg: 'No podemos eliminar los registros en estos momentos',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    });
}