/*
* @category    Diagrama Placa Bacteriana
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

                                    
ControlPlaca001Ui = Ext.extend(Ext.Panel, {
    anchor: '100%',
    autoHeight: true,
    initComponent: function() {
        var stGridPlacaBacterianaxPaciente = new StoreGridPlacaBacterianaxPaciente();
        stGridPlacaBacterianaxPaciente.load({
            params: {
                pPaciente: wPaciente
            }
        });
        
        function VerInfoDiagrama(value, metaData, record, rowIndex, colIndex, store){  
            metaData.attr = 'style="white-space:normal"';  
            return value + '</br>' + record.get('Profesional') + '</br>Tipo Registro:' + record.get('TipoOdontograma') + '</br>Tipo Denticion:' + record.get('TipoDenticion');
        }
        
        var ControlPlacaInical = new Ext.Panel({ 
            autoLoad:{
                url:'../../../app/frm/controlplaca/controlplaca001.php?pPaciente=' + wPaciente + '&pCAS=' + wCAS,
                scripts:true,
                scope:this
            },
            id:'ControlPlacaInical',
            height: 480,
            autoScroll:true,
            closable:false
        });
        
        //Store Locales
        var dataTipoDenticionCP = [
            ['TEMPORAL'],
            ['PERMANENTE'],
            ['MIXTA']
        ];
        var stTipoDenticionCP = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stTipoDenticionCP.loadData(dataTipoDenticionCP);
        
        this.tbar = [
            {
                html: 'Tipo Denticion:'
            },
            {
                xtype: 'combo',
                width: 110,
                allowBlank: true,
                store: stTipoDenticionCP,
                valueField: 'Descripcion',
                displayField: 'Descripcion',
                mode: 'local',
                forceSelection: true,
                typeAhead: true,
                typeAheadDelay: 10,
                triggerAction: 'all',
                id: 'sysBtnTipoDenticionCP'
            },
            {
                xtype: 'tbseparator'
            },
            {
                xtype: 'button',
                text: 'Crear Diagrama',
                iconCls: 'btnDiente',
                listeners:{
                    click : function(){
                        if (parseInt(Ext.getCmp('sysYaGuardoHC').getValue()) === 0){
                            Ext.Msg.show({
                                title: 'eOfiClinic',
                                msg: 'Debe guardar la evolucion antes de gererar el diagrama de placa bacteriana',
                                buttons: Ext.Msg.OK,
                                icon: Ext.Msg.ERROR
                            });
                        }else{
                            if(Ext.getCmp('sysBtnTipoDenticionCP').getValue() === "" || Ext.getCmp('sysBtnTipoDenticionCP').getValue() === null){
                                Ext.Msg.show({
                                    title: 'eOfiClinic',
                                    msg: 'Debe seleccionar el tipo de denticion',
                                    buttons: Ext.Msg.OK,
                                    icon: Ext.Msg.ERROR
                                });
                            }else{
                                var idOdontograma = 0;
                                var tipoOdontograma = "Inicial";
                                if(idOdontograma !== 0){
                                    tipoOdontograma = "Control";
                                }
                                Ext.Ajax.request({
                                    url: '../../controlador/odontograma/controlador_odontograma.php',
                                    params:{
                                        task: 'CREAR_CONTROLPLACA',
                                        pPaciente: wPaciente,
                                        pIdOdontograma: idOdontograma,
                                        pTipoOdontograma: tipoOdontograma,
                                        pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                                        pProfesional:  Ext.getCmp('sysProfesionalHC').getValue(),
                                        pCAS: wCAS,
                                        pCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                                        pTipoDenticion: Ext.getCmp('sysBtnTipoDenticionCP').getValue(),
                                        pUsuario: ID_USUARIO
                                    },
                                    success: function(response,options)
                                    {
                                        var Respuesta = response.responseText;
                                        var Contenido = Respuesta.split('^');
                                        if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                            Ext.MessageBox.show({
                                                title: 'eOfiClinic',
                                                msg: 'Ocurrio un error al crear el diagrama de placa bacteriana del paciente.',
                                                buttons: Ext.MessageBox.OK,
                                                icon: Ext.MessageBox.ERROR
                                            });
                                        } else {
                                            Ext.getCmp('gridControlPlacaxPaciente').store.reload();
                                            var updater = Ext.getCmp('ControlPlacaInical').getUpdater();
                                            updater.setDefaultUrl('../../../app/frm/controlplaca/controlplaca001.php?pPaciente=' + wPaciente + '&pCAS=' + wCAS + '&pOdontograma=0');
                                            updater.refresh();
                                        }
                                    },
                                    failure: function(response,options){
                                        Ext.MessageBox.show({
                                            title: 'eOfiClinic',
                                            msg: 'No podemos crear el diagrama de placa bacteriana y/o No se pudo establecer conexión con el servidor',
                                            buttons: Ext.MessageBox.OK,
                                            icon: Ext.MessageBox.ERROR
                                        });
                                    },
                                    scope:this 
                                });
                            }
                        }
                    }
                }
            },
            {
                xtype: 'tbseparator'
            }
        ];
        this.items = [
            {
                xtype: 'panel',
                border: false, 
                autoHeight: true,
                layout: {
                    columns: 2,
                    type: 'table'
                },
                items:[
                    {
                        xtype: 'panel',
                        autoScroll: true,
                        width: 215,
                        height: 470,
                        frame: true,
                        border: false,
                        tbar:{
                            items: [
                                {
                                    xtype: 'button',
                                    text: 'Editar',
                                    iconCls: 'btnEditRow',
                                    listeners:{
                                        click : function(){
                                            if(Ext.getCmp('gridControlPlacaxPaciente').selModel.getCount() === 1){
                                                var selections = Ext.getCmp('gridControlPlacaxPaciente').selModel.getSelections();
                                                if(selections[0].json.CAS === wCAS){
                                                    var oGridControlPlaca = new GridEditControlPlacaUi();
                                                    Ext.getCmp('gridEditControlPlacaHC').title = "CAS: " + selections[0].json.CAS + " Fecha: " + selections[0].json.FecReporte + " -Denticion: " + selections[0].json.TipoDenticion;
                                                    Ext.getCmp('sysIdControlPlacaItem').setValue(selections[0].json.IdConsecutivoOdontograma);
                                                    Ext.getCmp('sysTipoDenticionItemControlPlaca').setValue(selections[0].json.TipoDenticion);
                                                    Ext.getCmp('gridEditControlPlacaHC').store.load({
                                                        params: {
                                                            task: 'LOAD_DETALLECONTROLPLACA',
                                                            pOdontograma: Ext.getCmp('sysIdControlPlacaItem').getValue()
                                                        }
                                                    });
                                                    oGridControlPlaca.show();
                                                }else{
                                                    Ext.MessageBox.show({
                                                    title: 'Diagrama',
                                                    msg: 'Este diagrama de placa bacteriana no se puede editar en estos momentos, porque pertenece a otra atencion ya realizada',
                                                    buttons: Ext.MessageBox.OK,
                                                    icon: Ext.MessageBox.ERROR
                                                });
                                                }
                                            }else{
                                                Ext.MessageBox.show({
                                                    title: 'Error',
                                                    msg: 'Debe seleccionar un registro',
                                                    buttons: Ext.MessageBox.OK,
                                                    icon: Ext.MessageBox.ERROR
                                                });
                                            }
                                        }
                                    }
                                },
                                {
                                    xtype: 'tbseparator'
                                },
                                {
                                    xtype: 'button',
                                    text: 'Borrar',
                                    iconCls: 'btnDelRow',
                                    listeners:{
                                        click : function(){
                                            if(Ext.getCmp('gridControlPlacaxPaciente').selModel.getCount() === 1){
                                                var selections = Ext.getCmp('gridControlPlacaxPaciente').selModel.getSelections();
                                                if(selections[0].json.CAS === wCAS){
                                                    Ext.Msg.show({
                                                        title: 'eOfiClinic',
                                                        msg: 'Esta seguro que eliminar el diagrama de placa bacteriana seleccionado?',
                                                        buttons: Ext.Msg.YESNO,
                                                        icon: Ext.Msg.QUESTION,
                                                        fn: function(btn){
                                                            if(btn === "yes"){
                                                                fnEliminarControlPlaca("../../controlador/odontograma/controlador_odontograma.php",{task: "ELIMINAR_CONTROLPLACA", pIdOdontograma: selections[0].json.IdConsecutivoOdontograma}, 'gridControlPlacaxPaciente');
                                                            }
                                                        }
                                                    });
                                                }else{
                                                    Ext.MessageBox.show({
                                                    title: 'Diagrama',
                                                    msg: 'Este diagrama de placa bacteriana no se puede borrar en estos momentos, porque pertenece a otra atencion ya realizada',
                                                    buttons: Ext.MessageBox.OK,
                                                    icon: Ext.MessageBox.ERROR
                                                });
                                                }
                                            }else{
                                                Ext.MessageBox.show({
                                                    title: 'Error',
                                                    msg: 'Debe seleccionar un registro',
                                                    buttons: Ext.MessageBox.OK,
                                                    icon: Ext.MessageBox.ERROR
                                                });
                                            }
                                        }
                                    }
                                },
                                {
                                    xtype: 'tbseparator'
                                }
                            ]
                        },
                        items: [
                            {
                                xtype: 'grid',
                                layout: 'fit',
                                id: 'gridControlPlacaxPaciente',
                                store: stGridPlacaBacterianaxPaciente,
                                anchor: "98%",
                                height: 390,
                                border: false,
                                frame: true,
                                loadMask: true,
                                colModel: new Ext.ux.grid.LockingColumnModel([
                                    {
                                        xtype: 'gridcolumn',
                                        header: 'Id',
                                        sortable: false,
                                        width: 100,
                                        hidden: true,
                                        hideable: false,
                                        dataIndex: 'CAS',
                                        id: 'CAS'
                                    },
                                    {
                                        xtype: 'gridcolumn',
                                        header: 'Fecha',
                                        sortable: true,
                                        width: 205,
                                        dataIndex: 'FecReporte',
                                        renderer: VerInfoDiagrama,
                                        id: 'FecReporte'
                                    }
                                ]),
                                selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                                listeners:{
                                    rowclick : function(grid, fila, e){
                                        var selections = grid.selModel.getSelections();
                                        try {
                                            var updater = Ext.getCmp('ControlPlacaInical').getUpdater();
                                            updater.setDefaultUrl('../../../app/frm/controlplaca/controlplaca001.php?pPaciente=' + wPaciente + '&pCAS=' + wCAS + '&pOdontograma=' + selections[0].json.IdConsecutivoOdontograma);
                                            updater.refresh();
                                        }catch(ex){
                                        }
                                        CalcularIndicePlaca(selections[0].json.IdConsecutivoOdontograma);
                                    }
                                }
                            }
                        ]
                    },
                    {
                        xtype: 'panel',
                        layout: 'form',
                        width: 745,
                        height: 470,
                        items: [
                            ControlPlacaInical
                        ]
                    }
                ]
            },
            {
                xtype: 'panel',
                layout: 'form',
                title: 'Calculo Indice Placa Bacteriana',
                frame: true,
                anchor: '100%',
                autoHeight: true,
                id: 'pnIndicePlacaOrely',
                padding: 10,
                border: true,
                autoScroll: true,
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'numberfield',
                                width: 60,
                                decimalPrecision: 0,
                                readOnly: true,
                                allowBlank: true,
                                name: 'COP - Sanos',
                                fieldLabel: 'Total Superficies',
                                id: 'sysTotalSuperficiesCP'
                            },
                            {
                                html: 'Nro. Superficies con Placa:'
                            },
                            {
                                xtype: 'numberfield',
                                width: 60,
                                decimalPrecision: 0,
                                readOnly: true,
                                allowBlank: true,
                                name: 'Nro. Superficies con Placa',
                                id: 'sysSuperficiesPlacaCP'
                            },
                            {
                                html: 'Indicie de Placa %:'
                            },
                            {
                                xtype: 'numberfield',
                                width: 60,
                                decimalPrecision: 2,
                                readOnly: true,
                                allowBlank: true,
                                name: 'Indicie de Placa %',
                                id: 'sysIndicePlacaCP'
                            }
                        ]
                    }
                ]
            }
        ];
        ControlPlaca001Ui.superclass.initComponent.call(this);
    }
});

function fnEliminarControlPlaca(URL,arrParam, pGrid, arrParamStore){
    Ext.Ajax.request({
        waitMsg: 'Por favor Espere...',
        url: URL,
        params: arrParam,
        success: function(response){
            var result=eval(response.responseText);
            switch(result){
                case 1:
                    if (typeof pGrid !== 'undefined'){
                        Ext.getCmp(pGrid).store.reload(arrParamStore);
                        ID_PLANTILLA_CITAS = 0;
                    }
                    break;

                case 3:
                    if (typeof pGrid !== 'undefined'){
                        Ext.getCmp(pGrid).store.reload(arrParamStore);
                        ID_PLANTILLA_CITAS = 0;
                        Ext.MessageBox.show({
                            title: 'eOfiClinic',
                            msg: 'Alguno de los registros no se pudieron eliminar',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.WARNING
                        });
                    }
                    break;

                default:
                    Ext.MessageBox.show({
                        title: 'Error',
                        msg: 'No podemos eliminar el registro en estos momentos o existen datos relacionados en otras tablas',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                    break;
            }
        },
        failure: function(response){
            var result = response.responseText;
            Ext.MessageBox.show({
                title: 'Error Base Datos',
                msg: 'No podemos eliminar los registros en estos momentos',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    });
}