/*
* @category    Formulario Modelo Evolucion Historia Clinica Covisalud 001
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winHCcovisalud001Ui = Ext.extend(Ext.Window, {
    title: 'eOfiClinic ©  .:: Plantilla HC ::.',
    width: 990,
    height: 636,
    closable: false,
    resizable: false,
    draggable: false,
    modal: true,
    id: 'winHC',
    initComponent: function() {
        
        tmpmx = objMX;
        tmpmxadd = objMXADD;
        tmpexa = objEXA;
        tmprem = objREM;
        myPaciente = 0;
        myCAS = 0;
        
        try {
            var campo = Ext.getCmp('sysPacientePlantillaHC');
            if ( campo !== null ) {
                myPaciente = Ext.getCmp('sysPacientePlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myPaciente === 0){
            try {
                var campo1 = Ext.getCmp('sysIdPacienteHC');
                if ( campo1 !== null ) {
                    myPaciente = Ext.getCmp('sysIdPacienteHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myPaciente === 0){
            try {
                var campo5 = Ext.getCmp('sysPacienteRefHC');
                if ( campo5 !== null ) {
                    myPaciente = Ext.getCmp('sysPacienteRefHC').getValue();
                }
            }catch(ex){
            }
        }
        try {
            var campo2 = Ext.getCmp('sysCASPlantillaHC');
            if ( campo2 !== null ) {
                myCAS = Ext.getCmp('sysCASPlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myCAS === 0){
            try {
                var campo3 = Ext.getCmp('sysCASHC');
                if ( campo3 !== null ) {
                    myCAS = Ext.getCmp('sysCASHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myCAS === 0){
            try {
                var campo4 = Ext.getCmp('sysCASRefHC');
                if ( campo4 !== null ) {
                    myCAS = Ext.getCmp('sysCASRefHC').getValue();
                }
            }catch(ex){
            }
        }
        
        if (objMX !== "NA"){
            var xSolMX = eval(objMX);
            Ext.getCmp('gridMedicamentosHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: myPaciente,
                    pCAS: myCAS
                }
            });
        }
        else{
            var xSolMX = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        if (objEXA !== "NA"){
            var xSolEXA = eval(objEXA);
            Ext.getCmp('gridExamenesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: myPaciente,
                    pCAS: myCAS
                }
            });
        }else{
            var xSolEXA = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }    
        if (objREM !== "NA"){
            var xSolREM = eval(objREM);
            Ext.getCmp('gridRemisionesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: myPaciente,
                    pCAS: myCAS
                }
            });
        }else{
            var xSolREM = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        
        var dataNormalPatologico = [
            ['NORMAL'],
            ['PATOLOGICO']
        ];
        var stNormalPatologico = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stNormalPatologico.loadData(dataNormalPatologico);
        
        var dataDeptoMuni50 = [
            //['50006','ACACIAS'],
            //['50110','BARRANCA DE UPIA'],
            //['50124','CABUYARO'],
            //['50150','CASTILLA LA NUEVA'],
            //['50223','CUBARRAL'],
            ['50226','CUMARAL'],
            //['50245','EL CALVARIO'],
            //['50251','EL CASTILLO'],
            //['50270','EL DORADO'],
            //['50287','FUENTE DE ORO'],
            //['50313','GRANADA'],
            //['50318','GUAMAL'],
            ['50350','LA MACARENA'],
            //['50370','LA URIBE'],
            //['50400','LEJANIAS'],
            //['50325','MAPIRIPAN'],
            //['50330','MESETAS'],
            //['50450','PUERTO CONCORDIA'],
            ['50568','PUERTO GAITAN'],
            //['50577','PUERTO LLERAS'],
            ['50573','PUERTO LOPEZ'],
            //['50590','PUERTO RICO'],
            ['50606','RESTREPO']
            //['50680','SAN CARLOS GUAROA'],
            //['50683','SAN JUAN DE ARAMA'],
            //['50686','SAN JUANITO'],
            //['50689','SAN MARTIN'],
            //['50001','VILLAVICENCIO'],
            //['50711','VISTA HERMOSA']
        ];
        var stDeptoMunicipio50 = new Ext.data.ArrayStore({
            fields: [
                {name: 'Codigo'},
                {name: 'Descripcion'}
            ]
        });
        stDeptoMunicipio50.loadData(dataDeptoMuni50);
                                                                        
        var dataEspecialidadTratante = [
            ['PEDIATRIA'],
            ['CARIOLOGICA PEDIATRICA'],
            ['MEDICINA INTERNA'],
            ['GINECOLOGIA'],
            ['OBSTETRICIA'],
            ['ORTOPEDIA Y TRAUMATOLOGIA'],
            ['PSIQUIATRIA'],
            ['PSICOLOGIA'],
            ['NUTRICION']
        ];
        var stEspecialidadTratante = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stEspecialidadTratante.loadData(dataEspecialidadTratante);
        
        //*******************************************************************
        // Configuracion Pregunta Encuesta
        //*******************************************************************
        
        var Q1 = new Ext.form.RadioGroup({
            id: 'Q1',
            allowBlank: false,
            anchor: '100%',
            columns: 2,
            vertical: true,
            labelStyle: 'font-weight: bold;',
            fieldLabel: '1. COMO CONSIDERA SU ESTADO DE SALUD?',
            name: '1. COMO CONSIDERA SU ESTADO DE SALUD?',
            items: [
                {boxLabel: 'MUY BUENO', name: 'Question1', inputValue: 'MUY BUENO'},
                {boxLabel: 'BUENO', name: 'Question1', inputValue: 'BUENO'},
                {boxLabel: 'REGULAR', name: 'Question1', inputValue: 'REGULAR'},
                {boxLabel: 'MALA', name: 'Question1', inputValue: 'MALA'},
                {boxLabel: 'MUY MALA', name: 'Question1', inputValue: 'MUY MALA'},
                {boxLabel: 'NO RESPONDE', name: 'Question1', inputValue: 'NO RESPONDE'}
            ]
        });
        var Q2 = new Ext.form.RadioGroup({
            id: 'Q2',
            allowBlank: false,
            anchor: '100%',
            columns: 2,
            vertical: true,
            //labelStyle: 'width: 450px; font-family: Arial,Helvetica,sans-serif; font-size: 12px;font-weight: bold;',
            labelStyle: 'font-weight: bold;',
            fieldLabel: '2. USTED SE CONSIDERA FELIZ?',
            name: '2. USTED SE CONSIDERA FELIZ?',
            items: [
                {boxLabel: 'SI', name: 'Question2', inputValue: 'SI'},
                {boxLabel: 'NO', name: 'Question2', inputValue: 'NO'},
                {boxLabel: 'NO RESPONDE', name: 'Question2', inputValue: 'NO RESPONDE'}
            ]
        });
        var Q3 = new Ext.form.RadioGroup({
            id: 'Q3',
            allowBlank: false,
            anchor: '100%',
            columns: 2,
            vertical: true,
            //labelStyle: 'width: 450px; font-family: Arial,Helvetica,sans-serif; font-size: 12px;font-weight: bold;',
            labelStyle: 'font-weight: bold;',
            fieldLabel: '3. CUANDO FUE LA ULTIMA VEZ QUE  CONSULTO AL MEDICO?',
            name: '3. CUANDO FUE LA ULTIMA VEZ QUE  CONSULTO AL MEDICO?',
            items: [
                {boxLabel: '1 A 3 MESES', name: 'Question3', inputValue: '1 A 3 MESES'},
                {boxLabel: '4 A 6 MESES', name: 'Question3', inputValue: '4 A 6 MESES'},
                {boxLabel: '7 A 12 MESES', name: 'Question3', inputValue: '7 A 12 MESES'},
                {boxLabel: 'MAS DE 1 AÑO', name: 'Question3', inputValue: 'MAS DE 1 AÑO'},
                {boxLabel: 'NO RESPONDE', name: 'Question3', inputValue: 'NO RESPONDE'},
            ]
        });
        var Q4 = new Ext.form.RadioGroup({
            id: 'Q4',
            allowBlank: false,
            anchor: '100%',
            columns: 2,
            vertical: true,
            //labelStyle: 'width: 450px; font-family: Arial,Helvetica,sans-serif; font-size: 12px;font-weight: bold;',
            labelStyle: 'font-weight: bold;',
            fieldLabel: '4. HACE CUANTO ASISTIO A UNA CONSULTA ESPECIALIZADA?',
            name: '4. HACE CUANTO ASISTIO A UNA CONSULTA ESPECIALIZADA?',
            items: [
                {boxLabel: 'MENOS DE 1 AÑO', name: 'Question4', inputValue: 'MENOS DE 1 AÑO'},
                {boxLabel: '1 A 2 AÑOS', name: 'Question4', inputValue: '1 A 2 AÑOS'},
                {boxLabel: 'MAS DE 2 AÑOS', name: 'Question4', inputValue: 'MAS DE 2 AÑOS'},
                {boxLabel: 'NUNCA', name: 'Question4', inputValue: 'NUNCA'},
                {boxLabel: 'NO RESPONDE', name: 'Question4', inputValue: 'NO RESPONDE'}
            ]
        });
        var Q5 = new Ext.form.RadioGroup({
            id: 'Q5',
            allowBlank: false,
            anchor: '100%',
            columns: 2,
            vertical: true,
            //labelStyle: 'width: 450px; font-family: Arial,Helvetica,sans-serif; font-size: 12px;font-weight: bold;',
            labelStyle: 'font-weight: bold;',
            fieldLabel: '5. CUANDO USTED ESTA ENFERMO?',
            name: '5. CUANDO USTED ESTA ENFERMO?',
            items: [
                {boxLabel: 'VA AL MEDICO', name: 'Question5', inputValue: 'VA AL MEDICO'},
                {boxLabel: 'VA A LA FARMACIA', name: 'Question5', inputValue: 'VA A LA FARMACIA'},
                {boxLabel: 'SE HACE REMEDIOS CASEROS', name: 'Question5', inputValue: 'SE HACE REMEDIOS CASEROS'},
                {boxLabel: 'NO RESPONDE', name: 'Question5', inputValue: 'NO RESPONDE'}
            ]
        });
        this.items = [
            {
                xtype: 'panel',
                frame: true,
                anchor: '100%',
                id: 'panelHC',
                padding: 10,
                border: false,
                height: 610,
                autoScroll: true,
                layout: 'form',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysIdCodPlantillaHC'
                    },
                     {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        value: 1,
                        id: 'sysUsaGridSalida'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        value: 0,
                        id: 'sysYaGuardoHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysPlantillaHC',
                        name: 'PLANTILLA'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptMx'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptExa'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptRem'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Actividad',
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        id: 'sysActividadHC',
                        name: 'PLANTILLA'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Empresa',
                        id: 'sysEmpresaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'IPS',
                        id: 'sysIPSHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Usuario',
                        id: 'sysUsuarioHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Profesional',
                        id: 'sysProfesionalHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Paciente',
                        id: 'sysIdPacienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Apertura',
                        id: 'sysAperturaHC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Cliente',
                        id: 'sysClienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdClienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdPlanHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdSubPlanHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdContratoHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Genero',
                        id: 'sysGeneroPacHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Edad',
                        id: 'sysEdadPacHC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Profesional',
                        id: 'sysProfesionalAgendaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'ConsecutivoDetalle',
                        id: 'sysConsecutivoDetalleHC'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'CAS',
                                id: 'sysCASHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysFechaHC',
                                value: 'Fecha: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                width: 100,
                                id: 'sysFechaHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysHoraHC',
                                value: 'Hora: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                width: 90,
                                id: 'sysHoraHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysLegalizacionHC',
                                value: 'Legalización: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                width: 100,
                                id: 'sysLegalizaHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysAutorizacionHC',
                                value: 'Nro Autorización: '
                            },
                            {
                                xtype: 'textfield',
                                width: 210,
                                allowBlank: true,
                                style: 'color:brown;',
                                readOnly: true,
                                id: 'sysNroAutorizacionHC'
                            }
                        ]
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Paciente',
                        value: 'CC 792558261  - JORGE GALEANO RUIZ - (Masculino) FechaNac: 1973-01-30, Edad 38 Años',
                        id: 'sysPacienteHC'
                    },
                    {
                        html: '<hr>',
                        style: 'background:transparent;',
                        border: false
                    },
                    {
                        xtype: 'tabpanel',
                        width: 930,
                        autoHeight: true,
                        border: false,
                        ref: 'fTabPanel',
                        id: 'fTabPanel',
                        activeTab: 0,
                        items: [
                            {
                                xtype: 'panel',
                                title: 'Evolución',
                                autoHeight: true,
                                autoScroll: true,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaEvolucion',
                                layout: 'form',
                                items: [
                                    {
                                        xtype: 'form',
                                        frame: true,
                                        anchor: '100%',
                                        id: 'frmHC',
                                        padding: 10,
                                        border: false,
                                        autoScroll: true,
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'combo',
                                                fieldLabel: 'Municipio',
                                                anchor: '100%',
                                                name: 'Municipio',
                                                allowBlank: false,
                                                store:stDeptoMunicipio50,
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                emptyText: 'Seleccione Municipio ....',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                id: 'strDeptoMuniHC'
                                            },
                                            {
                                                xtype: 'combo',
                                                fieldLabel: 'Especialidad Tratante',
                                                anchor: '100%',
                                                name: 'Especialidad Tratante',
                                                allowBlank: false,
                                                store:stEspecialidadTratante,
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                emptyText: 'Seleccione Municipio ....',
                                                mode: 'local',
                                                triggerAction: 'all',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                id: 'strEspecialidadTratanteHC'
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'SIGNOS VITALES',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 50,
                                                                fieldLabel: 'F.C',
                                                                name: 'F.C',
                                                                allowBlank: true,
                                                                id: 'strEF_FC'
                                                            },
                                                            {
                                                                html: 'x min&nbsp;&nbsp;&nbsp;&nbsp;- F.R:'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 50,
                                                                name: 'FR',
                                                                allowBlank: true,
                                                                id: 'strEF_FR'
                                                            },
                                                            {
                                                                html: 'x min&nbsp;&nbsp;&nbsp;&nbsp;- Temp:'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 50,
                                                                name: 'TEMPERATURA',
                                                                allowBlank: true,
                                                                id: 'strEF_TE'
                                                            },
                                                            {
                                                                html: 'Cº&nbsp;&nbsp;&nbsp;&nbsp;- T/A:'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 50,
                                                                name: 'TA SISTOLICA',
                                                                allowBlank: true,
                                                                id: 'strEF_TASIS'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 50,
                                                                name: 'TA DIASTOLICA',
                                                                allowBlank: true,
                                                                id: 'strEF_TADIAS'
                                                            },
                                                            {
                                                                html: 'mmHg&nbsp;&nbsp;&nbsp;&nbsp;- SpO2:'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 50,
                                                                name: 'SpO2',
                                                                allowBlank: true,
                                                                id: 'strEF_SPO2'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                fieldLabel: 'TALLA (cm)',
                                                                name:"TALLA (cm)",
                                                                emptyText: '(cm)',
                                                                id: 'intEF_Talla',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        if(pNew === null || pNew === 0){
                                                                            Ext.getCmp('intEF_Talla').setValue(null);
                                                                            Ext.getCmp('intEF_IMC').setValue(null);
                                                                        }else{
                                                                            //peso [kg]/ estatura [m2]
                                                                            if(Ext.getCmp('intEF_Peso').getValue() > 0){
                                                                                var pTalla = Ext.getCmp('intEF_Talla').getValue() / 100;
                                                                                Ext.getCmp('intEF_IMC').setValue(Ext.getCmp('intEF_Peso').getValue()/(pTalla*pTalla));
                                                                            }else{
                                                                                Ext.getCmp('intEF_IMC').setValue(null);
                                                                            }
                                                                        }
                                                                        if(Ext.getCmp('intEF_IMC').getValue()<1){
                                                                           Ext.getCmp('strEF_IMCClasificacon').setValue(null);
                                                                        }else{
                                                                            if(Ext.getCmp('intEF_IMC').getValue()<24.9){
                                                                               Ext.getCmp('strEF_IMCClasificacon').setValue("ACEPTABLE");
                                                                            }else{
                                                                                if(Ext.getCmp('intEF_IMC').getValue()<29.9){
                                                                                   Ext.getCmp('strEF_IMCClasificacon').setValue("SOBREPESO");
                                                                                }else{
                                                                                    Ext.getCmp('strEF_IMCClasificacon').setValue("OBESIDAD");
                                                                                }

                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html: '&nbsp;&nbsp;&nbsp;PESO (Kg): '
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                emptyText: '(Kg)',
                                                                name:"PESO (Kg)",
                                                                id: 'intEF_Peso',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        if(pNew == null || pNew == 0){
                                                                            Ext.getCmp('intEF_Peso').setValue(null);
                                                                            Ext.getCmp('intEF_IMC').setValue(null);
                                                                        }else{
                                                                            //peso [kg]/ estatura [m2]
                                                                            if(Ext.getCmp('intEF_Talla').getValue() > 0){
                                                                                var pTalla = Ext.getCmp('intEF_Talla').getValue() / 100;
                                                                                Ext.getCmp('intEF_IMC').setValue(Ext.getCmp('intEF_Peso').getValue()/(pTalla*pTalla));
                                                                            }else{
                                                                                Ext.getCmp('intEF_IMC').setValue(null);
                                                                            }
                                                                        }
                                                                        if(Ext.getCmp('intEF_IMC').getValue()<1){
                                                                           Ext.getCmp('strEF_IMCClasificacon').setValue(null);
                                                                        }else{
                                                                            if(Ext.getCmp('intEF_IMC').getValue()<24.9){
                                                                               Ext.getCmp('strEF_IMCClasificacon').setValue("ACEPTABLE");
                                                                            }else{
                                                                                if(Ext.getCmp('intEF_IMC').getValue()<29.9){
                                                                                   Ext.getCmp('strEF_IMCClasificacon').setValue("SOBREPESO");
                                                                                }else{
                                                                                    Ext.getCmp('strEF_IMCClasificacon').setValue("OBESIDAD");
                                                                                }

                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html: 'IMC: '
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                //minValue: 0,
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                readOnly: true,
                                                                name: "IMC",
                                                                id: 'intEF_IMC'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 100,
                                                                allowBlank: true,
                                                                readOnly: true,
                                                                name: "IMC - CLASIFICACION",
                                                                id: 'strEF_IMCClasificacon'
                                                            },
                                                                    {
                                                                html: 'P. Abdomen: '
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                //minValue: 0,
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name: "PERIMETRO ADOMINAL",
                                                                id: 'intEF_PAbdomen'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'MOTIVO DE CONSULTA/ ESTADO ACTUAL',
                                                layout: 'table',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        width: 850,
                                                        fieldLabel: 'MOTIVO DE CONSULTA/ ESTADO ACTUAL',
                                                        name: 'MOTIVO DE CONSULTA/ ESTADO ACTUAL',
                                                        height: 30,
                                                        grow: true,
                                                        minGrow: 30,
                                                        allowBlank: false,
                                                        id: 'memMotivoConsulta'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'EXAMEN FISICO',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                layout: 'table',
                                                layoutConfig: {
                                                    columns: 2
                                                },
                                                items: [
                                                    {
                                                        xtype: 'panel',
                                                        width: 210,
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        border: false,
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'combo', // col 2.1
                                                                fieldLabel: 'OTR',
                                                                name: 'OTR',
                                                                width: 200,
                                                                allowBlank: false,
                                                                store: stNormalPatologico,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NORMAL",
                                                                id: 'strEXAFI_OTR',
                                                                listeners:{
                                                                    select : function(cmb, rec, idx){
                                                                        if(cmb.getValue() === "NORMAL"){
                                                                            Ext.getCmp('memEXAFI_OTRH').allowBlank = true;
                                                                            Ext.getCmp('memEXAFI_OTRH').setValue(null);
                                                                            Ext.getCmp('memEXAFI_OTRH').disable();
                                                                            Ext.getCmp('memEXAFI_OTRH').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('memEXAFI_OTRH').enable();
                                                                            Ext.getCmp('memEXAFI_OTRH').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel', // col 2.2-5
                                                        width: 600,
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        border: false,
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'textarea',
                                                                emptyText: 'HALLAZGOS',
                                                                name:"OTR HALLAZGOS",
                                                                disabled: true,
                                                                height: 20,
                                                                anchor: '99%',
                                                                grow: true,
                                                                growMin: 20,
                                                                growMax: 400,
                                                                allowBlank: true,
                                                                id: 'memEXAFI_OTRH'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        width: 210,
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        border: false,
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'combo', // col 2.1
                                                                fieldLabel: 'CARDIOPULMONAR',
                                                                name: 'CARDIOPULMONAR',
                                                                width: 200,
                                                                allowBlank: false,
                                                                store: stNormalPatologico,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NORMAL",
                                                                id: 'strEXAFI_CARDIOPULMONAR',
                                                                listeners:{
                                                                    select : function(cmb, rec, idx){
                                                                        if(cmb.getValue() === "NORMAL"){
                                                                            Ext.getCmp('memEXAFI_CARDIOPULMONARH').allowBlank = true;
                                                                            Ext.getCmp('memEXAFI_CARDIOPULMONARH').setValue(null);
                                                                            Ext.getCmp('memEXAFI_CARDIOPULMONARH').disable();
                                                                            Ext.getCmp('memEXAFI_CARDIOPULMONARH').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('memEXAFI_CARDIOPULMONARH').enable();
                                                                            Ext.getCmp('memEXAFI_CARDIOPULMONARH').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel', // col 2.2-5
                                                        width: 600,
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        border: false,
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'textarea',
                                                                emptyText: 'HALLAZGOS',
                                                                name:"CARDIOPULMONAR HALLAZGOS",
                                                                disabled: true,
                                                                height: 20,
                                                                anchor: '99%',
                                                                grow: true,
                                                                growMin: 20,
                                                                growMax: 400,
                                                                allowBlank: true,
                                                                id: 'memEXAFI_CARDIOPULMONARH'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        width: 210,
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        border: false,
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'combo', // col 2.1
                                                                fieldLabel: 'COLUMNA',
                                                                name: 'COLUMNA',
                                                                width: 200,
                                                                allowBlank: false,
                                                                store: stNormalPatologico,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NORMAL",
                                                                id: 'strEXAFI_COLUMNA',
                                                                listeners:{
                                                                    select : function(cmb, rec, idx){
                                                                        if(cmb.getValue() === "NORMAL"){
                                                                            Ext.getCmp('memEXAFI_COLUMNAH').allowBlank = true;
                                                                            Ext.getCmp('memEXAFI_COLUMNAH').setValue(null);
                                                                            Ext.getCmp('memEXAFI_COLUMNAH').disable();
                                                                            Ext.getCmp('memEXAFI_COLUMNAH').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('memEXAFI_COLUMNAH').enable();
                                                                            Ext.getCmp('memEXAFI_COLUMNAH').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel', // col 2.2-5
                                                        width: 600,
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        border: false,
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'textarea',
                                                                emptyText: 'HALLAZGOS',
                                                                name:"COLUMNA HALLAZGOS",
                                                                disabled: true,
                                                                height: 20,
                                                                anchor: '99%',
                                                                grow: true,
                                                                growMin: 20,
                                                                growMax: 400,
                                                                allowBlank: true,
                                                                id: 'memEXAFI_COLUMNAH'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        width: 210,
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        border: false,
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'combo', // col 2.1
                                                                fieldLabel: 'ABDOMEN',
                                                                name: 'ABDOMEN',
                                                                width: 200,
                                                                allowBlank: false,
                                                                store: stNormalPatologico,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NORMAL",
                                                                id: 'strEXAFI_ABDOMEN',
                                                                listeners:{
                                                                    select : function(cmb, rec, idx){
                                                                        if(cmb.getValue() === "NORMAL"){
                                                                            Ext.getCmp('memEXAFI_ABDOMENH').allowBlank = true;
                                                                            Ext.getCmp('memEXAFI_ABDOMENH').setValue(null);
                                                                            Ext.getCmp('memEXAFI_ABDOMENH').disable();
                                                                            Ext.getCmp('memEXAFI_ABDOMENH').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('memEXAFI_ABDOMENH').enable();
                                                                            Ext.getCmp('memEXAFI_ABDOMENH').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel', // col 2.2-5
                                                        width: 600,
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        border: false,
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'textarea',
                                                                emptyText: 'HALLAZGOS',
                                                                name:"ABDOMEN HALLAZGOS",
                                                                disabled: true,
                                                                height: 20,
                                                                anchor: '99%',
                                                                grow: true,
                                                                growMin: 20,
                                                                growMax: 400,
                                                                allowBlank: true,
                                                                id: 'memEXAFI_ABDOMENH'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        width: 210,
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        border: false,
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'combo', // col 2.1
                                                                fieldLabel: 'GENITO-URINARIO',
                                                                name: 'GENITO-URINARIO',
                                                                width: 200,
                                                                allowBlank: false,
                                                                store: stNormalPatologico,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NORMAL",
                                                                id: 'strEXAFI_GURINARIO',
                                                                listeners:{
                                                                    select : function(cmb, rec, idx){
                                                                        if(cmb.getValue() === "NORMAL"){
                                                                            Ext.getCmp('memEXAFI_GURINARIOH').allowBlank = true;
                                                                            Ext.getCmp('memEXAFI_GURINARIOH').setValue(null);
                                                                            Ext.getCmp('memEXAFI_GURINARIOH').disable();
                                                                            Ext.getCmp('memEXAFI_GURINARIOH').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('memEXAFI_GURINARIOH').enable();
                                                                            Ext.getCmp('memEXAFI_GURINARIOH').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel', // col 2.2-5
                                                        width: 600,
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        border: false,
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'textarea',
                                                                emptyText: 'HALLAZGOS',
                                                                name:"GENITO-URINARIO HALLAZGOS",
                                                                disabled: true,
                                                                height: 20,
                                                                anchor: '99%',
                                                                grow: true,
                                                                growMin: 20,
                                                                growMax: 400,
                                                                allowBlank: true,
                                                                id: 'memEXAFI_GURINARIOH'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        width: 210,
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        border: false,
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'combo', // col 2.1
                                                                fieldLabel: 'EXTREMIDADES',
                                                                name: 'EXTREMIDADES',
                                                                width: 200,
                                                                allowBlank: false,
                                                                store: stNormalPatologico,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NORMAL",
                                                                id: 'strEXAFI_EXTREMIDADES',
                                                                listeners:{
                                                                    select : function(cmb, rec, idx){
                                                                        if(cmb.getValue() === "NORMAL"){
                                                                            Ext.getCmp('memEXAFI_EXTREMIDADESH').allowBlank = true;
                                                                            Ext.getCmp('memEXAFI_EXTREMIDADESH').setValue(null);
                                                                            Ext.getCmp('memEXAFI_EXTREMIDADESH').disable();
                                                                            Ext.getCmp('memEXAFI_EXTREMIDADESH').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('memEXAFI_EXTREMIDADESH').enable();
                                                                            Ext.getCmp('memEXAFI_EXTREMIDADESH').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel', // col 2.2-5
                                                        width: 600,
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        border: false,
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'textarea',
                                                                emptyText: 'HALLAZGOS',
                                                                name:"EXTREMIDADES HALLAZGOS",
                                                                disabled: true,
                                                                height: 20,
                                                                anchor: '99%',
                                                                grow: true,
                                                                growMin: 20,
                                                                growMax: 400,
                                                                allowBlank: true,
                                                                id: 'memEXAFI_EXTREMIDADESH'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        width: 210,
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        border: false,
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'combo', // col 2.1
                                                                fieldLabel: 'PIEL',
                                                                name: 'PIEL',
                                                                width: 200,
                                                                allowBlank: false,
                                                                store: stNormalPatologico,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NORMAL",
                                                                id: 'strEXAFI_PIEL',
                                                                listeners:{
                                                                    select : function(cmb, rec, idx){
                                                                        if(cmb.getValue() === "NORMAL"){
                                                                            Ext.getCmp('memEXAFI_PIELH').allowBlank = true;
                                                                            Ext.getCmp('memEXAFI_PIELH').setValue(null);
                                                                            Ext.getCmp('memEXAFI_PIELH').disable();
                                                                            Ext.getCmp('memEXAFI_PIELH').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('memEXAFI_PIELH').enable();
                                                                            Ext.getCmp('memEXAFI_PIELH').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel', // col 2.2-5
                                                        width: 600,
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        border: false,
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'textarea',
                                                                emptyText: 'HALLAZGOS',
                                                                name:"PIEL HALLAZGOS",
                                                                disabled: true,
                                                                height: 20,
                                                                anchor: '99%',
                                                                grow: true,
                                                                growMin: 20,
                                                                growMax: 400,
                                                                allowBlank: true,
                                                                id: 'memEXAFI_PIELH'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        width: 210,
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        border: false,
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'combo', // col 2.1
                                                                fieldLabel: 'SNC',
                                                                name: 'SNC',
                                                                width: 200,
                                                                allowBlank: false,
                                                                store: stNormalPatologico,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NORMAL",
                                                                id: 'strEXAFI_SNC',
                                                                listeners:{
                                                                    select : function(cmb, rec, idx){
                                                                        if(cmb.getValue() === "NORMAL"){
                                                                            Ext.getCmp('memEXAFI_SNCH').allowBlank = true;
                                                                            Ext.getCmp('memEXAFI_SNCH').setValue(null);
                                                                            Ext.getCmp('memEXAFI_SNCH').disable();
                                                                            Ext.getCmp('memEXAFI_SNCH').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('memEXAFI_SNCH').enable();
                                                                            Ext.getCmp('memEXAFI_SNCH').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel', // col 2.2-5
                                                        width: 600,
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        border: false,
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'textarea',
                                                                emptyText: 'HALLAZGOS',
                                                                name:"SNC HALLAZGOS",
                                                                disabled: true,
                                                                height: 20,
                                                                anchor: '99%',
                                                                grow: true,
                                                                growMin: 20,
                                                                growMax: 400,
                                                                allowBlank: true,
                                                                id: 'memEXAFI_SNCH'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'AYUDAS DIAGNOSTICAS SOLICITADAS',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'panel',
                                                        layout: 'table',
                                                        columns: 2,
                                                        border: false,
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                width: 440,
                                                                layout: 'form',
                                                                labelWidth: 250,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'HEMOGRAMA',
                                                                        name: 'AYUDAS DX HEMOGRAMA',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolAYUDASDX_HEMOGRAMA'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'UROANALISIS',
                                                                        name: 'AYUDAS DX UROANALISIS',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolAYUDASDX_UROANALISIS'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'GLUCOMETRIA',
                                                                        name: 'AYUDAS DX GLUCOMETRIA',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolAYUDASDX_GLUCOMETRIA'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'DENSIMETRIA OSEA',
                                                                        name: 'AYUDAS DX DENSIMETRIA OSEA',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolAYUDASDX_DENSIMETRIAOSEA'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'PULSIOXIMETRIA',
                                                                        name: 'AYUDAS DX PULSIOXIMETRIA',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolAYUDASDX_PULSIOXIMETRIA'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 440,
                                                                layout: 'form',
                                                                labelWidth: 250,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'ECOGRAFIA OBSTETRICA',
                                                                        name: 'AYUDAS DX ECOGRAFIA OBSTETRICA',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolAYUDASDX_ECOGRAFIAOBSTETRICA'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'ECOGRAFIA GINECOLOGICA',
                                                                        name: 'AYUDAS DX ECOGRAFIA GINECOLOGICA',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolAYUDASDX_ECOGRAFIAGINECOLOGICA'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'ELECTROCARDIOGRAMA',
                                                                        name: 'AYUDAS DX ELECTROCARDIOGRAMA',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolAYUDASDX_ELECTROCARDIOGRAMA'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'ECO DOPPLER COLOR',
                                                                        name: 'AYUDAS DX ECO DOPPLER COLOR',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolAYUDASDX_ECODOPLER'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'OTROS',
                                                        name: 'AYUDAS DX OTROS',
                                                        allowBlank: true,
                                                        id: 'strAYUDASDX_OTROS'
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        fieldLabel: 'REPORTE DE PARACLINICOS',
                                                        name: 'AYUDAS DX REPORTE DE PARACLINICOS',
                                                        height: 30,
                                                        grow: true,
                                                        minGrow: 30,
                                                        allowBlank: true,
                                                        id: 'memAYUDASDX_REPORTEPARACLINICOS'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'INTERCONSULTA',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                layout: 'table',
                                                layoutConfig: {
                                                    columns: 2
                                                },
                                                items: [
                                                    {
                                                        xtype: 'panel',
                                                        width: 210,
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        border: false,
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'checkbox',
                                                                fieldLabel: 'PEDIATRIA',
                                                                name: 'INTERCONSULTA PEDIATRIA',
                                                                width: 200,
                                                                value: 'false',
                                                                id: 'bolINTERCONSULTA_PEDIATRIA',
                                                                listeners: {
                                                                    check: function(f,c){
                                                                        if (c){
                                                                            Ext.getCmp('memINTERCONSULTA_PEDIATRIAH').enable();
                                                                            Ext.getCmp('memINTERCONSULTA_PEDIATRIAH').allowBlank = false;
                                                                        }else{
                                                                            Ext.getCmp('memINTERCONSULTA_PEDIATRIAH').allowBlank = true;
                                                                            Ext.getCmp('memINTERCONSULTA_PEDIATRIAH').setValue(null);
                                                                            Ext.getCmp('memINTERCONSULTA_PEDIATRIAH').disable();
                                                                            Ext.getCmp('memINTERCONSULTA_PEDIATRIAH').clearInvalid();
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel', 
                                                        width: 600,
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        border: false,
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'textarea',
                                                                emptyText: 'HALLAZGOS',
                                                                name:"INTERCONSULTA PEDIATRIA HALLAZGOS",
                                                                disabled: true,
                                                                height: 20,
                                                                anchor: '99%',
                                                                grow: true,
                                                                growMin: 20,
                                                                growMax: 400,
                                                                allowBlank: true,
                                                                id: 'memINTERCONSULTA_PEDIATRIAH'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        width: 210,
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        border: false,
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'checkbox',
                                                                fieldLabel: 'MEDICINA INTERNA',
                                                                name: 'INTERCONSULTA MEDICINA INTERNA',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolINTERCONSULTA_MEDICINAINTERNA',
                                                                listeners: {
                                                                    check: function(f,c){
                                                                        if (c){
                                                                            Ext.getCmp('memINTERCONSULTA_MEDICINAINTERNAH').enable();
                                                                            Ext.getCmp('memINTERCONSULTA_MEDICINAINTERNAH').allowBlank = false;
                                                                        }else{
                                                                            Ext.getCmp('memINTERCONSULTA_MEDICINAINTERNAH').allowBlank = true;
                                                                            Ext.getCmp('memINTERCONSULTA_MEDICINAINTERNAH').setValue(null);
                                                                            Ext.getCmp('memINTERCONSULTA_MEDICINAINTERNAH').disable();
                                                                            Ext.getCmp('memINTERCONSULTA_MEDICINAINTERNAH').clearInvalid();
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel', 
                                                        width: 600,
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        border: false,
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'textarea',
                                                                emptyText: 'HALLAZGOS',
                                                                name:"INTERCONSULTA MEDICINA INTERNA HALLAZGOS",
                                                                disabled: true,
                                                                height: 20,
                                                                anchor: '99%',
                                                                grow: true,
                                                                growMin: 20,
                                                                growMax: 400,
                                                                allowBlank: true,
                                                                id: 'memINTERCONSULTA_MEDICINAINTERNAH'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        width: 210,
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        border: false,
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'checkbox',
                                                                fieldLabel: 'PSIQUIATRIA',
                                                                name: 'INTERCONSULTA PSIQUIATRIA',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolINTERCONSULTA_PSIQUIATRIA',
                                                                listeners: {
                                                                    check: function(f,c){
                                                                        if (c){
                                                                            Ext.getCmp('memINTERCONSULTA_PSIQUIATRIAH').enable();
                                                                            Ext.getCmp('memINTERCONSULTA_PSIQUIATRIAH').allowBlank = false;
                                                                        }else{
                                                                            Ext.getCmp('memINTERCONSULTA_PSIQUIATRIAH').allowBlank = true;
                                                                            Ext.getCmp('memINTERCONSULTA_PSIQUIATRIAH').setValue(null);
                                                                            Ext.getCmp('memINTERCONSULTA_PSIQUIATRIAH').disable();
                                                                            Ext.getCmp('memINTERCONSULTA_PSIQUIATRIAH').clearInvalid();
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel', 
                                                        width: 600,
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        border: false,
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'textarea',
                                                                emptyText: 'HALLAZGOS',
                                                                name:"INTERCONSULTA PSIQUIATRIA HALLAZGOS",
                                                                disabled: true,
                                                                height: 20,
                                                                anchor: '99%',
                                                                grow: true,
                                                                growMin: 20,
                                                                growMax: 400,
                                                                allowBlank: true,
                                                                id: 'memINTERCONSULTA_PSIQUIATRIAH'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        width: 210,
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        border: false,
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'checkbox',
                                                                fieldLabel: 'GINECOLOGIA',
                                                                name: 'INTERCONSULTA GINECOLOGIA',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolINTERCONSULTA_GINECOLOGIA',
                                                                listeners: {
                                                                    check: function(f,c){
                                                                        if (c){
                                                                            Ext.getCmp('memINTERCONSULTA_GINECOLOGIAH').enable();
                                                                            Ext.getCmp('memINTERCONSULTA_GINECOLOGIAH').allowBlank = false;
                                                                        }else{
                                                                            Ext.getCmp('memINTERCONSULTA_GINECOLOGIAH').allowBlank = true;
                                                                            Ext.getCmp('memINTERCONSULTA_GINECOLOGIAH').setValue(null);
                                                                            Ext.getCmp('memINTERCONSULTA_GINECOLOGIAH').disable();
                                                                            Ext.getCmp('memINTERCONSULTA_GINECOLOGIAH').clearInvalid();
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel', 
                                                        width: 600,
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        border: false,
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'textarea',
                                                                emptyText: 'HALLAZGOS',
                                                                name:"INTERCONSULTA GINECOLOGIA HALLAZGOS",
                                                                disabled: true,
                                                                height: 20,
                                                                anchor: '99%',
                                                                grow: true,
                                                                growMin: 20,
                                                                growMax: 400,
                                                                allowBlank: true,
                                                                id: 'memINTERCONSULTA_GINECOLOGIAH'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        width: 210,
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        border: false,
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'checkbox',
                                                                fieldLabel: 'OBSTETRICIA',
                                                                name: 'INTERCONSULTA OBSTETRICIA',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolINTERCONSULTA_OBSTETRICIA',
                                                                listeners: {
                                                                    check: function(f,c){
                                                                        if (c){
                                                                            Ext.getCmp('memINTERCONSULTA_OBSTETRICIAH').enable();
                                                                            Ext.getCmp('memINTERCONSULTA_OBSTETRICIAH').allowBlank = false;
                                                                        }else{
                                                                            Ext.getCmp('memINTERCONSULTA_OBSTETRICIAH').allowBlank = true;
                                                                            Ext.getCmp('memINTERCONSULTA_OBSTETRICIAH').setValue(null);
                                                                            Ext.getCmp('memINTERCONSULTA_OBSTETRICIAH').disable();
                                                                            Ext.getCmp('memINTERCONSULTA_OBSTETRICIAH').clearInvalid();
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel', 
                                                        width: 600,
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        border: false,
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'textarea',
                                                                emptyText: 'HALLAZGOS',
                                                                name:"INTERCONSULTA OBSTETRICIA HALLAZGOS",
                                                                disabled: true,
                                                                height: 20,
                                                                anchor: '99%',
                                                                grow: true,
                                                                growMin: 20,
                                                                growMax: 400,
                                                                allowBlank: true,
                                                                id: 'memINTERCONSULTA_OBSTETRICIAH'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        width: 210,
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        border: false,
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'checkbox',
                                                                fieldLabel: 'ORTOPEDIA Y TRAUMATOLOGIA',
                                                                name: 'INTERCONSULTA ORTOPEDIA Y TRAUMATOLOGIA',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolINTERCONSULTA_ORTOPEDIA',
                                                                listeners: {
                                                                    check: function(f,c){
                                                                        if (c){
                                                                            Ext.getCmp('memINTERCONSULTA_ORTOPEDIAH').enable();
                                                                            Ext.getCmp('memINTERCONSULTA_ORTOPEDIAH').allowBlank = false;
                                                                        }else{
                                                                            Ext.getCmp('memINTERCONSULTA_ORTOPEDIAH').allowBlank = true;
                                                                            Ext.getCmp('memINTERCONSULTA_ORTOPEDIAH').setValue(null);
                                                                            Ext.getCmp('memINTERCONSULTA_ORTOPEDIAH').disable();
                                                                            Ext.getCmp('memINTERCONSULTA_ORTOPEDIAH').clearInvalid();
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel', 
                                                        width: 600,
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        border: false,
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'textarea',
                                                                emptyText: 'HALLAZGOS',
                                                                name:"INTERCONSULTA ORTOPEDIA Y TRAUMATOLOGIA HALLAZGOS",
                                                                disabled: true,
                                                                height: 20,
                                                                anchor: '99%',
                                                                grow: true,
                                                                growMin: 20,
                                                                growMax: 400,
                                                                allowBlank: true,
                                                                id: 'memINTERCONSULTA_ORTOPEDIAH'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        width: 210,
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        border: false,
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'checkbox',
                                                                fieldLabel: 'NUTRICION',
                                                                name: 'INTERCONSULTA NUTRICION',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolINTERCONSULTA_NUTRICION',
                                                                listeners: {
                                                                    check: function(f,c){
                                                                        if (c){
                                                                            Ext.getCmp('memINTERCONSULTA_NUTRICIONH').enable();
                                                                            Ext.getCmp('memINTERCONSULTA_NUTRICIONH').allowBlank = false;
                                                                        }else{
                                                                            Ext.getCmp('memINTERCONSULTA_NUTRICIONH').allowBlank = true;
                                                                            Ext.getCmp('memINTERCONSULTA_NUTRICIONH').setValue(null);
                                                                            Ext.getCmp('memINTERCONSULTA_NUTRICIONH').disable();
                                                                            Ext.getCmp('memINTERCONSULTA_NUTRICIONH').clearInvalid();
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel', 
                                                        width: 600,
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        border: false,
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'textarea',
                                                                emptyText: 'HALLAZGOS',
                                                                name:"INTERCONSULTA NUTRICION HALLAZGOS",
                                                                disabled: true,
                                                                height: 20,
                                                                anchor: '99%',
                                                                grow: true,
                                                                growMin: 20,
                                                                growMax: 400,
                                                                allowBlank: true,
                                                                id: 'memINTERCONSULTA_NUTRICIONH'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        width: 210,
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        border: false,
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'checkbox',
                                                                fieldLabel: 'PSICOLOGIA',
                                                                name: 'INTERCONSULTA PSICOLOGIA',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolINTERCONSULTA_PSICOLOGIA',
                                                                listeners: {
                                                                    check: function(f,c){
                                                                        if (c){
                                                                            Ext.getCmp('memINTERCONSULTA_PSICOLOGIAH').enable();
                                                                            Ext.getCmp('memINTERCONSULTA_PSICOLOGIAH').allowBlank = false;
                                                                        }else{
                                                                            Ext.getCmp('memINTERCONSULTA_PSICOLOGIAH').allowBlank = true;
                                                                            Ext.getCmp('memINTERCONSULTA_PSICOLOGIAH').setValue(null);
                                                                            Ext.getCmp('memINTERCONSULTA_PSICOLOGIAH').disable();
                                                                            Ext.getCmp('memINTERCONSULTA_PSICOLOGIAH').clearInvalid();
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel', 
                                                        width: 600,
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        border: false,
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'textarea',
                                                                emptyText: 'HALLAZGOS',
                                                                name:"INTERCONSULTA PSICOLOGIA HALLAZGOS",
                                                                disabled: true,
                                                                height: 20,
                                                                anchor: '99%',
                                                                grow: true,
                                                                growMin: 20,
                                                                growMax: 400,
                                                                allowBlank: true,
                                                                id: 'memINTERCONSULTA_PSICOLOGIAH'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        width: 210,
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        border: false,
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'checkbox',
                                                                fieldLabel: 'CARIOLOGICA PEDIATRICA',
                                                                name: 'INTERCONSULTA CARIOLOGICA PEDIATRICA',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolINTERCONSULTA_CARIOLOGICAPEDIATRICA',
                                                                listeners: {
                                                                    check: function(f,c){
                                                                        if (c){
                                                                            Ext.getCmp('memINTERCONSULTA_CARIOLOGICAPEDIATRICAH').enable();
                                                                            Ext.getCmp('memINTERCONSULTA_CARIOLOGICAPEDIATRICAH').allowBlank = false;
                                                                        }else{
                                                                            Ext.getCmp('memINTERCONSULTA_CARIOLOGICAPEDIATRICAH').allowBlank = true;
                                                                            Ext.getCmp('memINTERCONSULTA_CARIOLOGICAPEDIATRICAH').setValue(null);
                                                                            Ext.getCmp('memINTERCONSULTA_CARIOLOGICAPEDIATRICAH').disable();
                                                                            Ext.getCmp('memINTERCONSULTA_CARIOLOGICAPEDIATRICAH').clearInvalid();
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel', 
                                                        width: 600,
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        border: false,
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'textarea',
                                                                emptyText: 'HALLAZGOS',
                                                                name:"INTERCONSULTA CARIOLOGICA PEDIATRICA HALLAZGOS",
                                                                disabled: true,
                                                                height: 20,
                                                                anchor: '99%',
                                                                grow: true,
                                                                growMin: 20,
                                                                growMax: 400,
                                                                allowBlank: true,
                                                                id: 'memINTERCONSULTA_CARIOLOGICAPEDIATRICAH'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'DIAGNOSTICO',
                                                layout: 'table',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 850,
                                                        fieldLabel: 'DIAGNOSTICO',
                                                        name: 'DIAGNOSTICO',
                                                        height: 30,
                                                        grow: true,
                                                        minGrow: 30,            
                                                        allowBlank: false,
                                                        id: 'memResumenDx'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'PLAN',
                                                layout: 'table',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 850,
                                                        fieldLabel: 'PLAN',
                                                        name: 'PLAN',
                                                        height: 30,
                                                        grow: true,
                                                        minGrow: 30,           
                                                        allowBlank: false,
                                                        id: 'memConducta'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'RIPS',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                id: 'fsRips',
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: false,
                                                                fieldLabel: 'Diagnostico Principal',
                                                                id: 'sysDiagPpalHC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() === e.ENTER || e.getKey() === e.TAB)
                                                                        {
                                                                            if (f.getValue() !== "" && f.getValue() !== null && f.getValue().toUpperCase() !== Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request({
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                        Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                allowBlank: false,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagPpalHCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Principal',
                                                                id: 'btnSearchDiagPpalHC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagPpalHC','sysDiagPpalHCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.1',
                                                                id: 'sysDiagRel1HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel1HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado1',
                                                                id: 'btnSearchDiagRel1HC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel1HC','sysDiagRel1HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.2',
                                                                id: 'sysDiagRel2HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel2HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado2',
                                                                id: 'btnSearchDiagRel2HC1',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel2HC','sysDiagRel2HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.3',
                                                                id: 'sysDiagRel3HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel3HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado3',
                                                                id: 'btnSearchDiagRel3HC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel3HC','sysDiagRel3HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Tipo de Diagnostico',
                                                        width:750,
                                                        name: 'Tipo de Diagnostico',
                                                        allowBlank: false,
                                                        store: 'StoreTipoDiagnostico',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        id: 'sysTipoDiagosticoHC'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Finalidad Consulta',
                                                        width:750,
                                                        name: 'Finalidad Consulta',
                                                        allowBlank: false,
                                                        store: 'StoreFinalidadConsulta',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 10,
                                                        id: 'sysFinalidadConsultaHC'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Causa Externa',
                                                        width:750,
                                                        name: 'Causa Externa',
                                                        allowBlank: false,
                                                        store: 'StoreCausaExterna',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 13,
                                                        id: 'sysCausaExternaHC'
                                                    }                            
                                                ]
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Encuesta',
                                autoHeight: true,
                                //height: 352,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaEncuesta',
                                tbar: {
                                    xtype: 'toolbar',
                                    items: [
                                        '->',
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Guardar Encuesta',
                                            iconCls: 'btnGuardar',
                                            id: 'btnGuardarEncuesta',
                                            listeners:{
                                                click : function(){
                                                    Ext.Msg.show({
                                                        title: 'eOfiClinic',
                                                        msg: 'Esta seguro que desea guardar la encuesta?',
                                                        buttons: Ext.Msg.YESNO,
                                                        icon: Ext.Msg.QUESTION,
                                                        fn: function(btn){
                                                            if(btn === "yes"){
                                                                fnGuardarPoll();
                                                            }
                                                        }
                                                    });
                                                }
                                            }
                                        }
                                    ]
                                },
                                items: [
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        value: 0,
                                        id: 'sysidEncuestaPoll'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        value: 0,
                                        id: 'sysYaGuardoPoll'
                                    },
                                    {
                                        xtype: 'fieldset',
                                        title: 'PREGUNTAS',
                                        layout: 'form',
                                        collapsible: true,
                                        titleCollapse: true,
                                        anchor: '99%',
                                        autoHeight: true,
                                        labelWidth: 350,
                                        items: [
                                            Q1,
                                            {
                                                html: '<hr>'
                                            },
                                            Q2,
                                            {
                                                html: '<hr>'
                                            },
                                            Q3,
                                            {
                                                html: '<hr>'
                                            },
                                            Q4,
                                            {
                                                html: '<hr>'
                                            },
                                            Q5
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Medicamentos',
                                height: 352,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaMedicamentos',
                                items: [
                                    xSolMX
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Servicios',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaServicios',
                                items: [
                                    xSolEXA
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Remisiones',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaRemisiones',
                                items: [
                                    xSolREM
                                ]
                            }
                            /*,
                            {
                                xtype: 'panel',
                                title: 'Solicitud CTC',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaCTC',
                                items: [
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Consentimientos Informados',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaConsentimientos',
                                items: [
                                ]
                            },*/
                        ]
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btnSalirEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 1) 
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    if (Ext.getCmp('sysUsaGridSalida').getValue() == 1){
                                                        Ext.getCmp('gridFormulario').store.reload();
                                                    }
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Usted No ha Guardado la Evolución del Paciente y Se Perdera la Información, Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                },
                tbar:{
                    items: [
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Ver Historia Clínica',
                            iconCls: 'btnVerHC',
                            id: 'btnVerHC',
                            listeners:{
                                click : function(){
                                    var cmpResumenHC = new winFrmVerHistorialHC({
                                        renderTo: Ext.getBody()
                                    });
                                    Ext.getCmp('winViewEvolucionHC').title = "PACIENTE: " + Ext.getCmp('sysPacienteHC').getValue();
                                    Ext.getCmp('gridHistorialEvoluciones').store.load({
                                        params: {
                                            pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                                            pPaciente: Ext.getCmp('sysIdPacienteHC').getValue()
                                        }
                                    });
                                    cmpResumenHC.show();
                                }
                            }
                        },
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar Evolución',
                            iconCls: 'btnGuardar',
                            id: 'btnGuardarEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 0) 
                                    {
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Guardar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnGuardarRegistros();
                                                }
                                            }
                                        });
                                    }else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Modificar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnModificarRegistros();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                }
            }
        ];
        this.on({
            afterlayout:{scope:this, single:true, fn:function() {
                Ext.Msg.hide();
                if(paramOpcion === "Nuevo"){ 
                    var frm = Ext.getCmp('frmHC').getForm();
                    frm.doAction('load', {
                        url: '../../controlador/asistencial/evolucionhc.php',
                        waitMsg: 'Cargando Información...',
                        params:{
                            pCAS: myCAS,
                            pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                            task: 'ImportarAntecedentesFamiliares'
                        },
                        success:function(form, action) {
                            CargarDataHCAntecedentes(action.result.data.sysEvolucion);
                            frm.doAction('load', {
                                url: '../../controlador/asistencial/evolucionhc.php',
                                waitMsg: 'Cargando Información...',
                                params:{
                                    pCAS: myCAS,
                                    pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                                    task: 'ImportarAntecedentesPersonales'
                                },
                                success:function(form, action) {
                                    CargarDataHCAntecedentes(action.result.data.sysEvolucion);
                                }
                            });
                        }
                    });
                }
            }}
        });
        winHCcovisalud001Ui.superclass.initComponent.call(this);
    }
});

function fnGuardarRegistros(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid()){
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc.php',
            params:{
                task: 'guardar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pidPlantillaHC : Ext.getCmp('sysIdCodPlantillaHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1); 
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function fnModificarRegistros(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid()){
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc.php',
            params:{
                task: 'modificar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function fnGuardarPoll(){ 
    if(Ext.getCmp('Q1').getValue() !== "" && Ext.getCmp('Q1').getValue() !== null && Ext.getCmp('Q2').getValue() !== "" && Ext.getCmp('Q2').getValue() !== null && Ext.getCmp('Q3').getValue() !== "" && Ext.getCmp('Q3').getValue() !== null && Ext.getCmp('Q4').getValue() !== "" && Ext.getCmp('Q4').getValue() !== null && Ext.getCmp('Q5').getValue() !== "" && Ext.getCmp('Q5').getValue() !== null && Ext.getCmp('strDeptoMuniHC').getValue() !== null && Ext.getCmp('strDeptoMuniHC').getValue() !== ""){
        var Answer1 =  QuitarAcentosTxt(Ext.getCmp('Q1').items.get(0).getGroupValue());
        var Answer2 =  QuitarAcentosTxt(Ext.getCmp('Q2').items.get(0).getGroupValue());
        var Answer3 =  QuitarAcentosTxt(Ext.getCmp('Q3').items.get(0).getGroupValue());
        var Answer4 =  QuitarAcentosTxt(Ext.getCmp('Q4').items.get(0).getGroupValue());
        var Answer5 =  QuitarAcentosTxt(Ext.getCmp('Q5').items.get(0).getGroupValue());
        Ext.Ajax.request({
            url: '../../controlador/encuestas/controlador_encuestas.php',
            params:{
                task: 'GUARDAR_DESDE_HC',
                pNomEncuesta: 'CONTRATO 0189/2013 - MEJORAMIENTO EN LA PRESTACION DE SERVICIOS DE SALUD DIFERENTES AL PRIMER NIVEL DE ATENCION  A POBLACION POBRE EN LO NO CUBIERTO POR EL POS SUBSIDIADODEL DEPARTAMENTO DEL META, A TRAVES DE JORNADAS DE ATENCION EN MEDICINA ESPECIALIZADA.',
                pEncuesta: Ext.getCmp('sysidEncuestaPoll').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pMunicipio: Ext.getCmp('strDeptoMuniHC').getValue(),
                pFecha: Ext.getCmp('sysFechaHC').getValue(),
                pAnswer1: Answer1,
                pQuestion1: QuitarAcentosTxt(Ext.getCmp('Q1').getName()),
                pAnswer2: Answer2,
                pQuestion2: QuitarAcentosTxt(Ext.getCmp('Q2').getName()),
                pAnswer3: Answer3,
                pQuestion3: QuitarAcentosTxt(Ext.getCmp('Q3').getName()),
                pAnswer4: Answer4,
                pQuestion4: QuitarAcentosTxt(Ext.getCmp('Q4').getName()),
                pAnswer5: Answer5,
                pQuestion5: QuitarAcentosTxt(Ext.getCmp('Q5').getName())
            },
            success: function(response,options)
            {
                var Respuesta = response.responseText;
                var Contenido = Respuesta.split('^');
                if(Contenido[0] === "{success:false}"){
                    Ext.MessageBox.show({
                        title: 'Encuestas',
                        msg: 'Ocurrio un error al guardar la encuesta.',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                } else {
                    if(Contenido[0] === "0" || Contenido[0] === 0){
                        Ext.MessageBox.show({
                            title: 'Encuestas',
                            msg: 'Ocurrio un error al guardar la encuesta.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                    } else {
                        Ext.getCmp('sysidEncuestaPoll').setValue(Contenido[0]);
                        Ext.getCmp('sysYaGuardoPoll').setValue(1); 
                        Ext.MessageBox.show({
                            title: 'Encuestas',
                            msg: 'La encuesta se guardo con exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                    }
                }
            },
            failure: function(response,options){
                Ext.MessageBox.show({
                    title: 'Error Conexión',
                    msg: 'No podemos guardar la encuesta y/o No se pudo establecer conexión con el servidor',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            },
            scope:this 
        });
    }else{
        Ext.MessageBox.show({
            title: 'Error Encuesta',
            msg: 'Las respuestas de la encuesta son requeridas',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}
