/*
* @category    Formulario Modelo Nota de Enfermeria
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winHCNotaEnfermeriaUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic ©  .:: Nota de Enfermeria ::.',
    width: 990,
    height: 636,
    closable: false,
    resizable: false,
    draggable: false,
    modal: true,
    id: 'winHCDescripcionQuirurgica',
    initComponent: function() {
        
        tmpmx = objMX;
        tmpmxadd = objMXADD;
        tmpexa = objEXA;
        tmprem = objREM;
        myPaciente = 0;
        myCAS = 0;
        
        try {
            var campo = Ext.getCmp('sysPacientePlantillaHC');
            if ( campo != null ) {
                myPaciente = Ext.getCmp('sysPacientePlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myPaciente == 0){
            try {
                var campo1 = Ext.getCmp('sysIdPacienteHC');
                if ( campo1 != null ) {
                    myPaciente = Ext.getCmp('sysIdPacienteHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myPaciente == 0){
            try {
                var campo5 = Ext.getCmp('sysPacienteRefHC');
                if ( campo5 != null ) {
                    myPaciente = Ext.getCmp('sysPacienteRefHC').getValue();
                }
            }catch(ex){
            }
        }
        try {
            var campo2 = Ext.getCmp('sysCASPlantillaHC');
            if ( campo2 != null ) {
                myCAS = Ext.getCmp('sysCASPlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myCAS == 0){
            try {
                var campo3 = Ext.getCmp('sysCASHC');
                if ( campo3 != null ) {
                    myCAS = Ext.getCmp('sysCASHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myCAS == 0){
            try {
                var campo4 = Ext.getCmp('sysCASRefHC');
                if ( campo4 != null ) {
                    myCAS = Ext.getCmp('sysCASRefHC').getValue();
                }
            }catch(ex){
            }
        }
        if (objMX != "NA"){
            var xSolMX = eval(objMX);
            Ext.getCmp('gridMedicamentosHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }
        else{
            var xSolMX = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        if (objEXA != "NA"){
            var xSolEXA = eval(objEXA);
            Ext.getCmp('gridExamenesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }else{
            var xSolEXA = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }    
        if (objREM != "NA"){
            var xSolREM = eval(objREM);
            Ext.getCmp('gridRemisionesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }else{
            var xSolREM = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        
        //Store Locales
        var dataOjo = [
            ['Ojo Derecho'],
            ['Ojo Izquierdo'],
            ['Ambos Ojos']
        ];
        var stOjo = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stOjo.loadData(dataOjo);
               
        var dataNomCirugia = [
            ['EXTRACCION EXTRACAPSULAR DE CATARATA + LIO'],
            ['FACOEMULCIFICACION CATARATA + LIO'],
            ['ARGON LASER'],
            ['YAG LASER'],
            ['AVANTIN O LUCENTIS']
        ];
        var stNomCirugia = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stNomCirugia.loadData(dataNomCirugia);

        var dataGotas = [
            ['TP'],
            ['MYDRIACYL'],
            ['OQSEINA'],
            ['OQSEPTIC'],
            ['ISOPTOCARPINA'],
            ['ALCAINE'],
            ['LIDOCAINA GEL']
        ];
        var stGotas = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stGotas.loadData(dataGotas);

        var dataAgujas = [
            ['COMPLETO'],
            ['INCOMPLETO']
        ];
        var stAgujas = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stAgujas.loadData(dataAgujas);

        //
        this.items = [
            {
                xtype: 'panel',
                frame: true,
                anchor: '100%',
                id: 'panelHC',
                border: false,
                height: 570,
                autoScroll: true,
                layout: 'form',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'tabpanel',
                        anchor: '99%',
                        autoHeight: true,
                        border: false,
                        enableTabScroll: true,
                        ref: 'fTabPanel',
                        id: 'fTabPanel',
                        activeTab: 0,
                        items: [
                            {
                                xtype: 'panel',
                                title: 'EVOLUCION',
                                autoHeight: true,
                                autoScroll: true,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaEvolucion',
                                layout: 'form',
                                items: [
                                    {
                                        xtype: 'form',
                                        frame: true,
                                        anchor: '100%',
                                        id: 'frmHC',
                                        padding: 10,
                                        border: false,
                                        autoScroll: true,
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                allowBlank: true,
                                                value: 'SI',
                                                readOnly: true,
                                                id: 'sysINGRESOPROGRAMA'
                                            },
                                            {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysIdCodPlantillaHC'
                                            },
                                             {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                value: 1,
                                                id: 'sysUsaGridSalida'
                                            },
                                            {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                                                value: 0,
                                                id: 'sysYaGuardoHC'
                                            },
                                            {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Plantilla',
                                                id: 'sysPlantillaHC',
                                                name: 'PLANTILLA'
                                            },
                                            {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysRutaRptHC'
                                            },
                                            {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysRutaRptMx'
                                            },
                                            {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysRutaRptExa'
                                            },
                                            {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysRutaRptRem'
                                            },
                                            {
                                                xtype: 'textfield',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Actividad',
                                                style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                                                id: 'sysActividadHC',
                                                name: 'PLANTILLA'
                                            },
                                            {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Empresa',
                                                id: 'sysEmpresaHC'
                                            },
                                            {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'IPS',
                                                id: 'sysIPSHC'
                                            },
                                            {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Usuario',
                                                id: 'sysUsuarioHC'
                                            },
                                            {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Profesional',
                                                id: 'sysProfesionalHC'
                                            },
                                            {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Paciente',
                                                id: 'sysIdPacienteHC'
                                            },
                                            {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Apertura',
                                                id: 'sysAperturaHC'
                                            },
                                            {
                                                xtype: 'textfield',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Cliente',
                                                id: 'sysClienteHC'
                                            },
                                            {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Plantilla',
                                                id: 'sysIdClienteHC'
                                            },
                                            {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Plantilla',
                                                id: 'sysIdPlanHC'
                                            },
                                            {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Plantilla',
                                                id: 'sysIdSubPlanHC'
                                            },
                                            {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Plantilla',
                                                id: 'sysIdContratoHC'
                                            },
                                            {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Genero',
                                                id: 'sysGeneroPacHC'
                                            },
                                            {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Edad',
                                                id: 'sysEdadPacHC'
                                            },
                                            {
                                                xtype: 'textfield',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Profesional',
                                                id: 'sysProfesionalAgendaHC'
                                            },
                                            {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'ConsecutivoDetalle',
                                                id: 'sysConsecutivoDetalleHC'
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        allowBlank: true,
                                                        readOnly: true,
                                                        fieldLabel: 'CAS',
                                                        id: 'sysCASHC'
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'sysFechaHC',
                                                        value: 'Fecha: '
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        allowBlank: true,
                                                        readOnly: true,
                                                        id: 'sysFechaHC'
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'sysHoraHC',
                                                        value: 'Hora: '
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        allowBlank: true,
                                                        readOnly: true,
                                                        id: 'sysHoraHC'
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'sysLegalizacionHC',
                                                        value: 'Legalización: '
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        allowBlank: true,
                                                        readOnly: true,
                                                        id: 'sysLegalizaHC'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'textfield',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Paciente',
                                                value: 'CC 792558261  - JORGE GALEANO RUIZ - (Masculino) FechaNac: 1973-01-30, Edad 38 Años',
                                                id: 'sysPacienteHC'
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        width: 100,
                                                        allowBlank: true,
                                                        readOnly: true,
                                                        fieldLabel: 'Genero',
                                                        id: 'sysGeneroHC'
                                                    },
                                                    {
                                                        html: 'Fecha Nac:'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        width: 100,
                                                        allowBlank: true,
                                                        readOnly: true,
                                                        id: 'sysFechaNac'
                                                    },
                                                    {
                                                        html: 'Edad:'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        width: 350,
                                                        allowBlank: true,
                                                        readOnly: true,
                                                        id: 'sysEdadHC'
                                                    }
                                                ]
                                            },
                                            /*
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        width: 370,
                                                        allowBlank: true,
                                                        readOnly: true,
                                                        fieldLabel: 'Ocupación',
                                                        id: 'sysOcupacionHC'
                                                    },
                                                    {
                                                        html: 'Discapacidad:'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        width: 370,
                                                        allowBlank: true,
                                                        readOnly: true,
                                                        id: 'sysDiscapacidadHC'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        width: 370,
                                                        allowBlank: true,
                                                        readOnly: true,
                                                        fieldLabel: 'Estado Civil',
                                                        id: 'sysEstadoCivilHC'
                                                    },
                                                    {
                                                        html: 'Escolaridad:'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        width: 380,
                                                        allowBlank: true,
                                                        readOnly: true,
                                                        id: 'sysEscolaridadHC'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        width: 370,
                                                        allowBlank: true,
                                                        readOnly: true,
                                                        fieldLabel: 'Direccion',
                                                        id: 'sysDireccionHC'
                                                    },
                                                    {
                                                        html: 'Telefono:'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        width: 390,
                                                        allowBlank: true,
                                                        readOnly: true,
                                                        id: 'sysTelefonoHC'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        width: 380,
                                                        allowBlank: true,
                                                        readOnly: true,
                                                        fieldLabel: 'Etnia',
                                                        id: 'sysEtniaHC'
                                                    },
                                                    {
                                                        html: 'Estrato:'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        width: 390,
                                                        allowBlank: true,
                                                        readOnly: true,
                                                        id: 'sysEstratoHC'
                                                    }
                                                ]
                                            },
                                            */
                                            {
                                                html: '<hr>',
                                                style: 'background:transparent;',
                                                border: false
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'CONDICION DE INGRESO',
                                                layout: 'form',
                                                labelWidth: 250,
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        name: 'Ingresa Paciente a area de Cirugia Conciente, orientado, Alerta, Desplazandose',
                                                        fieldLabel: 'Ingresa Paciente a area de Cirugia Conciente, orientado, Alerta, Desplazandose',
                                                        width: 300,
                                                        allowBlank: true,
                                                        id: 'strNotaEnf_1'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        name: 'Acompanante',
                                                        fieldLabel: 'Acompañante',
                                                        width: 300,
                                                        allowBlank: true,
                                                        id: 'strNotaEnf_2'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: 'Procedimiento a Realizar',
                                                        fieldLabel: 'Procedimiento a Realizar',
                                                        width: 300,
                                                        allowBlank: true,
                                                        store: stNomCirugia,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strNotaEnf_3'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: 'Se Semaforiza Ojo a Operar',
                                                        fieldLabel: 'Se Semaforiza Ojo a Operar',
                                                        width: 300,
                                                        allowBlank: true,
                                                        store: stOjo,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strNotaEnf_4'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: 'Se Realiza Toma de Signos Vitales',
                                                        fieldLabel: 'Se Realiza Toma de Signos Vitales',
                                                        width: 60,
                                                        allowBlank: true,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        value: "NO",
                                                        triggerAction: 'all',
                                                        id: 'strNotaEnf_5'
                                                    },
                                                    {
                                                        html: '<br>'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                html: 'FC'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'FC',
                                                                emptyText: '/min',
                                                                width: 60,
                                                                allowBlank: true,
                                                                value: 0,
                                                                id: 'intNotaEnf_6'
                                                            },
                                                            {
                                                                html: 'FR'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'FR',
                                                                emptyText: '/min',
                                                                width: 60,
                                                                allowBlank: true,
                                                                value: 0,
                                                                id: 'intNotaEnf_7'
                                                            },
                                                            {
                                                                html: 'TA'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'TA-Sistolica',
                                                                width: 60,
                                                                allowBlank: true,
                                                                value: 0,
                                                                id: 'intNotaEnf_8'
                                                            },
                                                            {
                                                                html: '/'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'TA-Diastolica',
                                                                width: 60,
                                                                allowBlank: true,
                                                                value: 0,
                                                                id: 'intNotaEnf_9'
                                                            },
                                                            {
                                                                html: 'SPO2'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'SP02 %',
                                                                emptyText: '%',
                                                                width: 60,
                                                                allowBlank: true,
                                                                value: 0,
                                                                id: 'intNotaEnf_10'
                                                            },
                                                            {
                                                                html: 'Glucometria'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'Glucometria',
                                                                width: 60,
                                                                allowBlank: true,
                                                                value: 0,
                                                                id: 'intNotaEnf_11'
                                                            },
                                                        ]
                                                    },
                                                    {
                                                        html: '<br>'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'checkbox',
                                                                fieldLabel: 'Se Aplican Gotas en Ojo a Operar Previo a Cirugia',
                                                                name: 'Se Aplican Gotas en Ojo a Operar Previo a Cirugia',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolNotaEnf_12'
                                                            },
                                                            {
                                                                html: ' Cual:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Cual',
                                                                width: 200,
                                                                allowBlank: true,
                                                                store: stGotas,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strNotaEnf_13'
                                                            },
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Se Administra Premedicacion',
                                                                fieldLabel: 'Se Administra Premedicacion',
                                                                width: 60,
                                                                allowBlank: true,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                value: "NO",
                                                                triggerAction: 'all',
                                                                id: 'strNotaEnf_14'
                                                            },
                                                            {
                                                                html: 'Cual'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Cual',
                                                                width: 300,
                                                                allowBlank: true,
                                                                id: 'strNotaEnf_14A'
                                                            },
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Se administra Anti-Hipertensivo?',
                                                                fieldLabel: 'Se administra Anti-Hipertensivo?',
                                                                width: 60,
                                                                allowBlank: true,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strNotaEnf_15',
                                                                listeners:{
                                                                    select : function(cmb, rec, idx){
                                                                        if(cmb.getValue() == "NO"){
                                                                            Ext.getCmp('strNotaEnf_16').allowBlank = true;
                                                                            Ext.getCmp('strNotaEnf_16').setValue(null);
                                                                            Ext.getCmp('strNotaEnf_16').disable();
                                                                            Ext.getCmp('strNotaEnf_16').clearInvalid();
                                                                            Ext.getCmp('strNotaEnf_16A').allowBlank = true;
                                                                            Ext.getCmp('strNotaEnf_16A').setValue(null);
                                                                            Ext.getCmp('strNotaEnf_16A').disable();
                                                                            Ext.getCmp('strNotaEnf_16A').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strNotaEnf_16').enable();
                                                                            Ext.getCmp('strNotaEnf_16').allowBlank = false;
                                                                            Ext.getCmp('strNotaEnf_16A').enable();
                                                                            Ext.getCmp('strNotaEnf_16A').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                              html: 'Hora'  
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Hora',
                                                                width: 70,
                                                                emptyText: 'hh:mm',
                                                                allowBlank: true,
                                                                disabled: true,
                                                                id: 'strNotaEnf_16'
                                                            },
                                                            {
                                                                html: 'Cual'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Cual',
                                                                width: 150,
                                                                allowBlank: true,
                                                                id: 'strNotaEnf_16A'
                                                            },
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                html: 'Hora'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Hora',
                                                                width: 70,
                                                                emptyText: 'hh:mm',
                                                                allowBlank: true,
                                                                id: 'strNotaEnf_17'
                                                            },
                                                            {
                                                                html: 'TA'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'TA-Sistolica',
                                                                width: 60,
                                                                allowBlank: true,
                                                                value: 0,
                                                                id: 'intNotaEnf_18_1'
                                                            },
                                                            {
                                                                html: '/'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'TA-Diastolica',
                                                                width: 60,
                                                                allowBlank: true,
                                                                value: 0,
                                                                id: 'intNotaEnf_18_2'
                                                            },
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                html: 'Hora'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Hora',
                                                                width: 70,
                                                                emptyText: 'hh:mm',
                                                                allowBlank: true,
                                                                id: 'strNotaEnf_19'
                                                            },
                                                            {
                                                                html: 'TA'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'TA-Sistolica',
                                                                width: 60,
                                                                allowBlank: true,
                                                                value: 0,
                                                                id: 'intNotaEnf_20_1'
                                                            },
                                                            {
                                                                html: '/'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'TA-Diastolica',
                                                                width: 60,
                                                                allowBlank: true,
                                                                value: 0,
                                                                id: 'intNotaEnf_20_2'
                                                            },
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                html: 'Hora'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Hora',
                                                                width: 70,
                                                                emptyText: 'hh:mm',
                                                                allowBlank: true,
                                                                id: 'strNotaEnf_21'
                                                            },
                                                            {
                                                                html: 'TA'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'TA-Sistolica',
                                                                width: 60,
                                                                allowBlank: true,
                                                                value: 0,
                                                                id: 'intNotaEnf_22_1'
                                                            },
                                                            {
                                                                html: '/'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'TA-Diastolica',
                                                                width: 60,
                                                                allowBlank: true,
                                                                value: 0,
                                                                id: 'intNotaEnf_22_2'
                                                            },
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'PROCEDIMIENTOS QUIRURGICOS',
                                                layout: 'form',
                                                labelWidth: 250,
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        name: 'Hora de Ingreso Paciente a Quirofonos',
                                                        fieldLabel: 'Hora de Ingreso Paciente a Quirofonos',
                                                        width: 70,
                                                        emptyText: 'hh:mm',
                                                        allowBlank: true,
                                                        id: 'strNotaEnf_23'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        name: 'HORA DE INICIO PROCEDIMIENTO',
                                                        fieldLabel: 'HORA DE INICIO PROCEDIMIENTO',
                                                        width: 70,
                                                        emptyText: 'hh:mm',
                                                        allowBlank: true,
                                                        id: 'strNotaEnf_25'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        name: 'HORA CULMINACION PROCEDIMIENTO',
                                                        fieldLabel: 'HORA CULMINACION PROCEDIMIENTO',
                                                        width: 70,
                                                        emptyText: 'hh:mm',
                                                        allowBlank: true,
                                                        id: 'strNotaEnf_26'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'COMPLICACION',
                                                                fieldLabel: 'COMPLICACION',
                                                                width: 60,
                                                                allowBlank: true,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strNotaEnf_27',
                                                                listeners:{
                                                                    select : function(cmb, rec, idx){
                                                                        if(cmb.getValue() == "NO"){
                                                                            Ext.getCmp('strNotaEnf_28').allowBlank = true;
                                                                            Ext.getCmp('strNotaEnf_28').setValue(null);
                                                                            Ext.getCmp('strNotaEnf_28').disable();
                                                                            Ext.getCmp('strNotaEnf_28').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strNotaEnf_28').enable();
                                                                            Ext.getCmp('strNotaEnf_28').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html: 'Cual'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Cual',
                                                                width: 500,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                id: 'strNotaEnf_28'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'MUESTRA PATOLOGICA',
                                                                fieldLabel: 'MUESTRA PATOLOGICA',
                                                                width: 60,
                                                                allowBlank: true,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strNotaEnf_29',
                                                                listeners:{
                                                                    select : function(cmb, rec, idx){
                                                                        if(cmb.getValue() == "NO"){
                                                                            Ext.getCmp('strNotaEnf_30').allowBlank = true;
                                                                            Ext.getCmp('strNotaEnf_30').setValue(null);
                                                                            Ext.getCmp('strNotaEnf_30').disable();
                                                                            Ext.getCmp('strNotaEnf_30').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strNotaEnf_30').enable();
                                                                            Ext.getCmp('strNotaEnf_30').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html: 'Cual'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Cual',
                                                                width: 500,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                id: 'strNotaEnf_30'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: 'RECUENTO DE AGUJAS',
                                                        fieldLabel: 'RECUENTO DE AGUJAS',
                                                        width: 150,
                                                        allowBlank: true,
                                                        store: stAgujas,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strNotaEnf_31'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        name: 'Auxiliar en Quirofano',
                                                        fieldLabel: 'Auxiliar en Quirofano',
                                                        width: 300,
                                                        allowBlank: true,
                                                        id: 'strNotaEnf_32'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'POST-QUIRURGICOS',
                                                layout: 'form',
                                                labelWidth: 250,
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        name: 'Se Entrego Formato de Recomendaciones Post-Quirurgicas, Formula Medicamentos, Fecha Control Postoperatorio',
                                                        fieldLabel: 'Se Entrego Formato de Recomendaciones Post-Quirurgicas, Formula Medicamentos, Fecha Control Postoperatorio',
                                                        width: 60,
                                                        allowBlank: true,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: "NO",
                                                        id: 'strNotaEnf_33',
                                                        listeners:{
                                                            select : function(cmb, rec, idx){
                                                                if(cmb.getValue() == "NO"){
                                                                    Ext.getCmp('fecNotaEnf_34').allowBlank = true;
                                                                    Ext.getCmp('fecNotaEnf_34').setValue(null);
                                                                    Ext.getCmp('fecNotaEnf_34').disable();
                                                                    Ext.getCmp('fecNotaEnf_34').clearInvalid();
                                                                    Ext.getCmp('strNotaEnf_35').allowBlank = true;
                                                                    Ext.getCmp('strNotaEnf_35').setValue(null);
                                                                    Ext.getCmp('strNotaEnf_35').disable();
                                                                    Ext.getCmp('strNotaEnf_35').clearInvalid();
                                                                }else{
                                                                    Ext.getCmp('fecNotaEnf_34').enable();
                                                                    Ext.getCmp('fecNotaEnf_34').allowBlank = false;
                                                                    Ext.getCmp('strNotaEnf_35').enable();
                                                                    Ext.getCmp('strNotaEnf_35').allowBlank = false;
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'datefield',
                                                                width: 120,
                                                                fieldLabel: 'Fecha',
                                                                name: 'Fecha',
                                                                allowBlank: true,
                                                                disabled: true,
                                                                disabledDates: '',
                                                                emptyText: '(dia/mes/ano) ',
                                                                style: 'text-align:center;',
                                                                id: 'fecNotaEnf_34'
                                                            },
                                                            {
                                                                html: 'Hora:'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Hora',
                                                                width: 150,
                                                                emptyText: 'hh:mm',
                                                                allowBlank: true,
                                                                disabled: true,
                                                                id: 'strNotaEnf_35'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 650,
                                                        fieldLabel: 'OBSERVACIONES',
                                                        name: 'OBSERVACIONES',
                                                        height: 88,            
                                                        allowBlank: true,
                                                        id: 'memNotaEnf_36'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        name: 'Auxiliar en el Egreso del Paciente',
                                                        fieldLabel: 'Auxiliar en el Egreso del Paciente',
                                                        width: 300,
                                                        allowBlank: true,
                                                        id: 'strNotaEnf_37'
                                                    }
                                                ]
                                            }
                                        ]
                                    }
                                ]
                            }
                        ]
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btnSalirEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 1) 
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHCDescripcionQuirurgica').close();
                                                }
                                            }
                                        });
                                    else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Usted No ha Guardado la Evolución del Paciente y Se Perdera la Información, Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHCDescripcionQuirurgica').close();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                },
                tbar:{
                    items: [
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Ver Historia Clínica',
                            iconCls: 'btnVerHC',
                            id: 'btnVerHC',
                            listeners:{
                                click : function(){
                                    var cmpResumenHC = new winFrmVerHistorialHC({
                                        renderTo: Ext.getBody()
                                    });
                                    Ext.getCmp('winViewEvolucionHC').title = "PACIENTE: " + Ext.getCmp('sysPacienteHC').getValue();
                                    Ext.getCmp('gridHistorialEvoluciones').store.load({
                                        params: {
                                            pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                                            pPaciente: Ext.getCmp('sysIdPacienteHC').getValue()
                                        }
                                    });
                                    cmpResumenHC.show();
                                }
                            }
                        },
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar Evolución',
                            iconCls: 'btnGuardar',
                            id: 'btnGuardarEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 0) 
                                    {
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Guardar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnGuardarRegistrosMedicinaGeneral();
                                                }
                                            }
                                        });
                                    }else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Modificar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnModificarRegistrosMedicinaGeneral();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                }
            }
        ];
        winHCNotaEnfermeriaUi.superclass.initComponent.call(this);
    }
});

function fnGuardarRegistrosMedicinaGeneral(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc.php',
            params:{
                task: 'guardar_notaenf',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pidPlantillaHC : Ext.getCmp('sysIdCodPlantillaHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1); 
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function fnModificarRegistrosMedicinaGeneral(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc.php',
            params:{
                task: 'modificar_notaenf',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}
