/*
* @category    Formulario Reporte Examenes
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winReporteParaclinicos001Ui = Ext.extend(Ext.Window, {
    title: '.:: Reporte Examenes / Procedimientos ::.',
    width: 900,
    autoHeight: true,
    modal: true,
    closable: true,
    padding: 10,
    id: 'winReporteParaclinicos001',
    initComponent: function() {
        var dataClasificaReporte = [
            ['N','NORMAL'],
            ['A','ANORMAL']
        ];
        var stClasificaReporte = new Ext.data.ArrayStore({
            fields: [
                {name: 'Codigo'},
                {name: 'Descripcion'}
            ]
        });
        stClasificaReporte.loadData(dataClasificaReporte);
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmAddReporteExamenes',
                padding: 10,
                items: [
                    {
                        xtype: 'panel',
                        layout: 'form',
                        border: false,
                        labelWidth: 80,
                        items: [
                            {
                                xtype: 'hidden',
                                id: 'intPacienteReporteParaclin',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intCASReporteParaclin',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intUsuarioReporteParaclin',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intIdConsecutivoReporteParaclin',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'combo',
                                fieldLabel: 'Busqueda',
                                store: searchStoreExaIPS001,
                                displayField: 'Descripcion',
                                typeAhead: false,
                                loadingText: 'Buscando...',
                                anchor: '100%',
                                hideTrigger: true,
                                minChars: 4,
                                emptyText:'Escriba el nombre del servicio -- p.e: COLESTEROL',
                                id: 'sysSearchReporteParaclin',
                                onSelect: function(record){ // override default onSelect to do redirect
                                    Ext.getCmp('intConceptoOfiMedicalReporteParaclin').setValue(null);
                                    Ext.getCmp('strNomConceptoOfiMedicalReporteParaclin').setValue(null);
                                    Ext.getCmp('intConceptoOfiMedicalReporteParaclin').setValue(record.data.Codigo);
                                    Ext.getCmp('strNomConceptoOfiMedicalReporteParaclin').setValue(record.data.Descripcion);
                                    Ext.getCmp('sysSearchReporteParaclin').clearValue();
                                    Ext.getCmp('sysSearchReporteParaclin').collapse();
                                }
                            },
                            {
                                html: '<hr>'
                            },        
                            {
                                xtype: 'hidden',
                                id: 'intConceptoOfiMedicalReporteParaclin'
                            },
                            {
                                xtype: 'textfield',
                                fieldLabel: 'Concepto',
                                anchor: '100%',
                                readOnly: true,
                                allowBlank: false,
                                id: 'strNomConceptoOfiMedicalReporteParaclin'
                            },
                            {
                                html: '<hr>'
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'textfield',
                                        fieldLabel: 'Quien Solicita',
                                        width: 533,
                                        allowBlank: false,
                                        id: 'strNomQuienSolicitaReporteParaclin'
                                    },    
                                    {
                                        html: 'Fecha Solicitud:'
                                    },
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        allowBlank: false,
                                        disabledDates: '',
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecFecSolicitudReporteParaclin'
                                    }
                                ]
                            },
                            {
                                html: '<hr>'
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'datefield',
                                        fieldLabel: 'Fecha Realizacion',
                                        width: 120,
                                        allowBlank: false,
                                        disabledDates: '',
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecFecRealizacionReporteParaclin'
                                    },
                                    {
                                        html: 'Reporte:'
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 355,
                                        allowBlank: false,
                                        id: 'strResultadoReporteParaclin'
                                    }, 
                                    {
                                        html: 'Valor:'
                                    },
                                    {
                                        xtype: 'numberfield',
                                        id: 'intValorReporteParaclin',
                                        width: 80,
                                        allowBlank: true
                                    },
                                    {
                                        xtype: 'combo',
                                        emptyText: 'Clasificacion',
                                        width: 90,
                                        allowBlank: false,
                                        store: stClasificaReporte,
                                        valueField: 'Codigo',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strClasificacionReporteParaclin'
                                    }
                                ]
                            },
                            {
                                xtype: 'textfield',
                                fieldLabel: 'Observaciones',
                                anchor: '100%',
                                allowBlank: true,
                                id: 'strObservacionesReporteParaclin'
                            }
                        ]
                    }
                ],
                tbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar',
                            iconCls: 'btnGuardar',
                            listeners:{
                                click : function(){
                                    fnGuardarRegItemReporte001("GUARDAR_REPORTE_PARACLINICOS","SI","winReporteParaclinicos001","frmAddReporteExamenes","../../controlador/asistencial/evolucionhc2013.php","gridReporteParaclinicos");
                                }
                            }
                        }
                    ]
                }
            }
        ];
        winReporteParaclinicos001Ui.superclass.initComponent.call(this);
    }
});

function fnGuardarRegItemReporte001(pAccion,pCerrar,pWin,pForm,URL,pGrid,arrParam,pCampoLlave,pCampoTextoLlave, pLimpiarForm, pCambiarBotones){
    var frm = Ext.getCmp(pForm).getForm();
    if (frm.isValid()){
        var listacampos = ExtraerCamposFrm(frm);
        frm.submit({
            url: URL,
            params:{
                task: pAccion,
                pPaciente: Ext.getCmp('intPacienteReporteParaclin').getValue(),
                pCAS: Ext.getCmp('intCASReporteParaclin').getValue(),
                pUsuario: Ext.getCmp('intUsuarioReporteParaclin').getValue(),
                pIdConsecutivo: Ext.getCmp('intIdConsecutivoReporteParaclin').getValue(),
                pConceptoOfiMedical: Ext.getCmp('intConceptoOfiMedicalReporteParaclin').getValue(),
                pNomConceptoOfiMedical: Ext.getCmp('strNomConceptoOfiMedicalReporteParaclin').getValue(),
                pNomQuienSolicita: Ext.getCmp('strNomQuienSolicitaReporteParaclin').getValue().toUpperCase(),
                pFecSolicitud: Ext.getCmp('fecFecSolicitudReporteParaclin').getValue().format('Y-m-d'),
                pFecRealizacion: Ext.getCmp('fecFecRealizacionReporteParaclin').getValue().format('Y-m-d'),
                pResultado: Ext.getCmp('strResultadoReporteParaclin').getValue().toUpperCase(),
                pValor: Ext.getCmp('intValorReporteParaclin').getValue(),
                pClasificacion: Ext.getCmp('strClasificacionReporteParaclin').getValue(),
                pObservaciones: Ext.getCmp('strObservacionesReporteParaclin').getValue().toUpperCase()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        if (typeof pLimpiarForm !== 'undefined'){
                            if (pLimpiarForm === "SI")
                                frm.reset();
                                Ext.getCmp('winReporteParaclinicos001').close();
                        }else{
                            frm.reset();
                        }
                        if (typeof pGrid !== 'undefined'){
                            if (pGrid !== 'NA'){
                                Ext.getCmp(pGrid).store.reload();
                                Ext.getCmp('winReporteParaclinicos001').close();
                            }
                        }
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}
