/*
* @category    Fieldset Revision x Sistemas
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

var dataConcepto = [
    ['APTO PARA TRABAJAR EN ALTURAS'],
    ['NO APTO PARA TRABAJAR EN ALTURAS']
];
var stConcepto = new Ext.data.ArrayStore({
    fields: [
        {name: 'Descripcion'}
    ]
});
stConcepto.loadData(dataConcepto);

var dataResultado = [
    ['Positivo'],
    ['Negativo']
];
var stResultado = new Ext.data.ArrayStore({
    fields: [
        {name: 'Descripcion'}
    ]
});
stResultado.loadData(dataResultado);


var dataResultado1 = [
    ['Derecha'],
    ['Izquierda'],
    ['Normal']
];
var stResultado1 = new Ext.data.ArrayStore({
    fields: [
        {name: 'Descripcion'}
    ]
});
stResultado1.loadData(dataResultado1);

var dataResultado2 = [
    ['Derecha'],
    ['Centrado'],
    ['Izquierda']
];
var stResultado2 = new Ext.data.ArrayStore({
    fields: [
        {name: 'Descripcion'}
    ]
});
stResultado2.loadData(dataResultado2);

var dataImpresionDx = [
    ['NEGATIVO PARA VERTIGO PERIFERICO'],
    ['POSITIVO PARA VERTIGO PERIFERICO'],
    ['POSITIVO PARA VERTIGO CENTRAL']
];
var stImpresionDx = new Ext.data.ArrayStore({
    fields: [
        {name: 'Descripcion'}
    ]
});
stImpresionDx.loadData(dataImpresionDx);

var dataNormal = [
    ['Normal'],
    ['ANormal']
];
var stNormal = new Ext.data.ArrayStore({
    fields: [
        {name: 'Descripcion'}
    ]
});
stNormal.loadData(dataNormal);


fsValoracionEquilibrioUi = Ext.extend(Ext.form.FieldSet, {
    anchor: '100%',
    autoHeight: true,
    layout: 'form',
    collapseFirst: false,
    collapsible: false,
    labelSeparator: '',
    padding: 0,
    id: 'fsValoracionEquilibrio',
    initComponent: function() {
        this.items = [
            {
                xtype: 'fieldset',
                title: 'ANTECEDENTES PATOLOGICOS',
                layout: 'form',
                collapseFirst: false,
                collapsible: true,
                animCollapse: true,
                titleCollapse: true,
                anchor: '100%',
                labelWidth: 210,
                labelSeparator: '',
                autoHeight: true,
                padding: 5,
                id: 'fsantecedentesPatologicos',
                items: [
                    {
                        xtype: 'panel',
                        layout: 'table',
                        layoutConfig: {
                            columns: 3
                        },
                        padding: 0,
                        items: [
                            {
                                xtype: 'panel',
                                layout: 'form',
                                width: 260,
                                height: 125,
                                labelWidth: 1,
                                labelSeparator: '',
                                labelStyle: 'color:blue;',
                                items: [
                                    {
                                        xtype: 'checkbox',
                                        boxLabel: 'VERTIGO',
                                        name: 'VERTIGO',
                                        anchor: '100%',
                                        value: 'false',
                                        id: 'bolVERTIGO'
                                    },
                                    {
                                        xtype: 'checkbox',
                                        boxLabel: 'EPILEPSIA',
                                        name: 'EPILEPSIA',
                                        anchor: '100%',
                                        value: 'false',
                                        id: 'bolEPILEPSIA'
                                    },
                                    {
                                        xtype: 'checkbox',
                                        boxLabel: 'OTITIS MEDIA ',
                                        name: 'OTITIS MEDIA ',
                                        anchor: '100%',
                                        value: 'false',
                                        id: 'bolOTITISMEDIA'
                                    },
                                    {
                                        xtype: 'checkbox',
                                        boxLabel: 'ENFERMEDAD DE MENIERE',
                                        name: 'ENFERMEDAD DE MENIERE',
                                        anchor: '100%',
                                        value: 'false',
                                        id: 'bolEnfermedadMeniere'
                                    },
                                    {
                                        xtype: 'checkbox',
                                        boxLabel: 'T. PSIQUIATRICO',
                                        name: 'T. PSIQUIATRICO',
                                        anchor: '100%',
                                        value: 'false',
                                        id: 'bolTPsiquiatrico'
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                layout: 'form',
                                width: 260,
                                height: 125,
                                labelWidth: 1,
                                labelSeparator: '',
                                labelStyle: 'color:blue;',
                                items: [
                                    {
                                        xtype: 'checkbox',
                                        boxLabel: 'TUMORES CEREBRALES',
                                        name: 'TUMORES CEREBRALES',
                                        anchor: '100%',
                                        value: 'false',
                                        id: 'bolTumoresCerebrales'
                                    },
                                    {
                                        xtype: 'checkbox',
                                        boxLabel: 'ECV',
                                        name: 'ECV',
                                        anchor: '100%',
                                        value: 'false',
                                        id: 'bolECV'
                                    },
                                    {
                                        xtype: 'checkbox',
                                        boxLabel: 'HTA',
                                        name: 'HTA',
                                        anchor: '100%',
                                        value: 'false',
                                        id: 'bolHTA'
                                    },
                                    {
                                        xtype: 'checkbox',
                                        boxLabel: 'SORDERA/HIPOACUSIA',
                                        name: 'SORDERA/HIPOACUSIA',
                                        anchor: '100%',
                                        value: 'false',
                                        id: 'bolSordera'
                                    },
                                    {
                                        xtype: 'checkbox',
                                        boxLabel: 'ARRITMIA CARDIACA',
                                        name: 'ARRITMIA CARDIACA',
                                        anchor: '100%',
                                        value: 'false',
                                        id: 'bolArritmiaCardiaca'
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                layout: 'form',
                                width: 260,
                                height: 125,
                                labelWidth: 1,
                                labelSeparator: '',
                                labelStyle: 'color:blue;',
                                items: [
                                    {
                                        xtype: 'checkbox',
                                        boxLabel: 'DIABETES',
                                        name: 'DIABETES',
                                        anchor: '100%',
                                        value: 'false',
                                        id: 'bolDiabetes'
                                    },
                                    {
                                        xtype: 'checkbox',
                                        boxLabel: 'HIPOGLICEMIA',
                                        name: 'HIPOGLICEMIA',
                                        anchor: '100%',
                                        value: 'false',
                                        id: 'bolHipoglicemia'
                                    },
                                    {
                                        xtype: 'checkbox',
                                        boxLabel: 'OTRA ENF. NEUROLOGICA',
                                        name: 'OTRA ENF. NEUROLOGICA',
                                        anchor: '100%',
                                        value: 'false',
                                        id: 'bolotraEnferNeurologica'
                                    },
                                    {
                                        xtype: 'checkbox',
                                        boxLabel: 'OTRA ENF. CARDIACA',
                                        name: 'OTRA ENF. CARDIACA',
                                        anchor: '100%',
                                        value: 'false',
                                        id: 'bolotraEnferCardiaca'
                                    },
                                    {
                                        xtype: 'checkbox',
                                        boxLabel: 'OTRA ENF. METABOLICA',
                                        name: 'OTRA ENF. METABOLICA',
                                        anchor: '100%',
                                        value: 'false',
                                        id: 'bolotraEnferMetabolica'
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: 'HABITOS',
                        layout: 'form',
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        anchor: '100%',
                        labelWidth: 210,
                        labelSeparator: '',
                        autoHeight: true,
                        padding: 5,
                        id: 'fsHabitos',
                        items: [
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        fieldLabel: 'Cigarrillo',
                                        name: 'Cigarrillo',
                                        width: 90,
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strHabitoCigarrillo'
                                    },
                                    {
                                        html:'Frecuencia'
                                    },
                                    {
                                        xtype: 'textfield',
                                        name: 'Frecuencia Cigarrillo',
                                        width: 400,
                                        allowBlank: true,
                                        id: 'strHabitoFrecuenciaCigarrillo'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        fieldLabel: 'DPSA',
                                        name: 'DPSA',
                                        width: 90,
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strHabitoDPSA'
                                    },
                                    {
                                        html:'Frecuencia'
                                    },
                                    {
                                        xtype: 'textfield',
                                        name: 'Frecuencia DPSA',
                                        width: 400,
                                        allowBlank: true,
                                        id: 'strHabitoFrecuenciaDPSA'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        fieldLabel: 'Licor',
                                        name: 'Licor',
                                        width: 90,
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strHabitoLicor'
                                    },
                                    {
                                        html:'Frecuencia'
                                    },
                                    {
                                        xtype: 'textfield',
                                        name: 'Frecuencia Licor',
                                        width: 400,
                                        allowBlank: true,
                                        id: 'strHabitoFrecuenciaLicor'
                                    }
                                ]
                            }
                        ]
                    }
                ]
            },
            {
                xtype: 'fieldset',
                title: 'VALORACION NEUROLOGICA BASICA O EXAMEN FISICO',
                layout: 'form',
                collapseFirst: false,
                collapsible: true,
                animCollapse: true,
                titleCollapse: true,
                anchor: '100%',
                labelWidth: 210,
                labelSeparator: '',
                autoHeight: true,
                padding: 5,
                id: 'fsValoracionNeurologicaBasica',
                items: [
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'combo',
                                name: 'Marcha',
                                fieldLabel: 'Marcha',
                                width: 90,
                                allowBlank: true,
                                store: stNormal,
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strValNeuroMarcha'
                            },
                            {
                                html:'Descripcion'
                            },
                            {
                                xtype: 'textfield',
                                name: 'Descripcion Marcha',
                                width: 400,
                                allowBlank: true,
                                id: 'strValNeuroDescripcionMarcha'
                            }
                        ]
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'combo',
                                name: 'Corazon',
                                fieldLabel: 'Corazon',
                                width: 90,
                                allowBlank: true,
                                store: stNormal,
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strValNeuroCorazon'
                            },
                            {
                                html:'Descripcion'
                            },
                            {
                                xtype: 'textfield',
                                name: 'Descripcion Corazon',
                                width: 400,
                                allowBlank: true,
                                id: 'strValNeuroDescripcionCorazon'
                            }
                        ]
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'combo',
                                name: 'Pares Craneales II III IV VI',
                                fieldLabel: 'Pares Craneales II III IV VI',
                                width: 90,
                                allowBlank: true,
                                store: stNormal,
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strValNeuroParesCraneales'
                            },
                            {
                                html:'Descripcion'
                            },
                            {
                                xtype: 'textfield',
                                name: 'Descripcion Pares Craneales',
                                width: 400,
                                allowBlank: true,
                                id: 'strValNeuroDescripcionParesxCraneales'
                            }
                        ]
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'combo',
                                name: 'R Vestibulo Coclear',
                                fieldLabel: 'R Vestibulo Coclear',
                                width: 90,
                                allowBlank: true,
                                store: stNormal,
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strValNeuroVestibuloCoclear'
                            },
                            {
                                html:'Descripcion'
                            },
                            {
                                xtype: 'textfield',
                                name: 'Descripcion R Vestibulo Coclear',
                                width: 400,
                                allowBlank: true,
                                id: 'strValNeuroDescripcionVestibuloCoclear'
                            }
                        ]
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'combo',
                                name: 'Coord Cerebelosa',
                                fieldLabel: 'Coord Cerebelosa',
                                width: 90,
                                allowBlank: true,
                                store: stNormal,
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strValNeuroCoordCerebelosa'
                            },
                            {
                                html:'Descripcion'
                            },
                            {
                                xtype: 'textfield',
                                name: 'Descripcion Coord Cerebelosa',
                                width: 400,
                                allowBlank: true,
                                id: 'strValNeuroDescripcionCoordCerebelosa'
                            }
                        ]
                    }
                ]
            },
            {
                xtype: 'fieldset',
                title: 'PRUEBAS DE EQUILIBRIO ESTATICO',
                layout: 'form',
                collapseFirst: false,
                collapsible: true,
                animCollapse: true,
                titleCollapse: true,
                anchor: '100%',
                labelWidth: 210,
                labelSeparator: '',
                autoHeight: true,
                padding: 5,
                id: 'fsPruebas',
                items: [
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'combo',
                                name: 'ROMBERG',
                                fieldLabel: 'ROMBERG',
                                width: 90,
                                allowBlank: true,
                                store: stResultado,
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strPruebaROMBERG'
                            },
                            
                            {
                                html:'Observacion'
                            },
                            {
                                xtype: 'textfield',
                                name: 'Observacion Prueba ROMBERG',
                                width: 400,
                                allowBlank: true,
                                id: 'strPruebaDescripcionROMBERG'
                            }
                        ]
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'combo',
                                name: 'BARANY',
                                fieldLabel: 'BARANY',
                                width: 90,
                                allowBlank: true,
                                store: stResultado,
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strPruebaBARANY'
                            },
                            
                            {
                                html:'Observacion'
                            },
                            {
                                xtype: 'textfield',
                                name: 'Observacion Prueba BARANY',
                                width: 400,
                                allowBlank: true,
                                id: 'strPruebaDescripcionBARANY'
                            }
                        ]
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'combo',
                                name: 'MANIOBRA DIX-HALLPIKE',
                                fieldLabel: 'MANIOBRA DIX-HALLPIKE',
                                width: 90,
                                allowBlank: true,
                                store: stResultado,
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strPruebaMANIOBRADIXHALLPIKE'
                            },
                            
                            {
                                html:'Observacion'
                            },
                            {
                                xtype: 'textfield',
                                name: 'Observacion Prueba MANIOBRA DIX-HALLPIKE',
                                width: 400,
                                allowBlank: true,
                                id: 'strPruebaDescripcionMANIOBRADIXHALLPIKE'
                            }
                        ]
                    }
                ]
            },
            {
                xtype: 'fieldset',
                title: 'PRUEBAS DE EQUILIBRIO DINAMICO',
                layout: 'form',
                collapseFirst: false,
                collapsible: true,
                animCollapse: true,
                titleCollapse: true,
                anchor: '100%',
                labelWidth: 210,
                labelSeparator: '',
                autoHeight: true,
                padding: 5,
                id: 'fsPruebasDinamicas',
                items: [
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'combo',
                                name: 'ROMBBABINSKI-WEILRG',
                                fieldLabel: 'BABINSKI-WEIL',
                                width: 90,
                                allowBlank: true,
                                store: stResultado1,
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strPruebaBABINSKIWEIL'
                            },
                            
                            {
                                html:'Observacion'
                            },
                            {
                                xtype: 'textfield',
                                name: 'Observacion Prueba BABINSKI-WEIL',
                                width: 400,
                                allowBlank: true,
                                id: 'strPruebaDescripcionBABINSKIWEIL'
                            }
                        ]
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'combo',
                                name: 'UNTERBERGER',
                                fieldLabel: 'UNTERBERGER',
                                width: 90,
                                allowBlank: true,
                                store: stResultado2,
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strPruebaUNTERBERGER'
                            },
                            {
                                html:'Observacion'
                            },
                            {
                                xtype: 'textfield',
                                name: 'Observacion Prueba UNTERBERGER',
                                width: 400,
                                allowBlank: true,
                                id: 'strPruebaDescripcionUNTERBERGER'
                            }
                        ]
                    }
                ]
            },
            {
                xtype: 'fieldset',
                title: 'PRUEBAS COMPLEMENTARIAS',
                layout: 'form',
                collapseFirst: false,
                collapsible: true,
                animCollapse: true,
                titleCollapse: true,
                anchor: '100%',
                labelWidth: 210,
                labelSeparator: '',
                autoHeight: true,
                padding: 5,
                id: 'fsPruebasComplementarias',
                items: [
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'combo',
                                name: 'CUADRO HEMATICO',
                                fieldLabel: 'CUADRO HEMATICO',
                                width: 90,
                                allowBlank: true,
                                store: stNormal,
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strPruebasCuadroHematico'
                            },
                            {
                                html:'Observacion'
                            },
                            {
                                xtype: 'textfield',
                                name: 'Observacion Cuadro Hematico',
                                width: 400,
                                allowBlank: true,
                                id: 'strPruebasCuadroHematicoH'
                            }
                        ]
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'combo',
                                name: 'PERFIL LIPIDICO',
                                fieldLabel: 'PERFIL LIPIDICO',
                                width: 90,
                                allowBlank: true,
                                store: stNormal,
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strPruebasPerfilLipidico'
                            },
                            {
                                html:'Observacion'
                            },
                            {
                                xtype: 'textfield',
                                name: 'Observacion Perfil Lipidico',
                                width: 400,
                                allowBlank: true,
                                id: 'strPruebasPerfilLipidicoH'
                            }
                        ]
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'combo',
                                name: 'AUDIOMETRIA',
                                fieldLabel: 'AUDIOMETRIA',
                                width: 90,
                                allowBlank: true,
                                store: stNormal,
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strPruebasAudiometria'
                            },
                            {
                                html:'Observacion'
                            },
                            {
                                xtype: 'textfield',
                                name: 'Observacion Audiometria',
                                width: 400,
                                allowBlank: true,
                                id: 'strPruebasAudiometriaH'
                            }
                        ]
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'combo',
                                name: 'VAL PSICOLOGICA',
                                fieldLabel: 'VAL PSICOLOGICA',
                                width: 90,
                                allowBlank: true,
                                store: stNormal,
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strPruebasValPsicologica'
                            },
                            {
                                html:'Observacion'
                            },
                            {
                                xtype: 'textfield',
                                name: 'Observacion Valoracion Psicologica',
                                width: 400,
                                allowBlank: true,
                                id: 'strPruebasValPsicologicaH'
                            }
                        ]
                    }
                ]
            },
            {
                xtype: 'fieldset',
                title: 'IMPRESION DIAGNOSTICA',
                layout: 'form',
                collapseFirst: false,
                collapsible: true,
                animCollapse: true,
                titleCollapse: true,
                anchor: '100%',
                labelWidth: 210,
                labelSeparator: '',
                autoHeight: true,
                padding: 5,
                id: 'fsImpresionDiagnostica',
                items: [
                    {
                        xtype: 'combo',
                        name: 'IMPRESION DIAGNOSTICA',
                        fieldLabel: 'IMPRESION DIAGNOSTICA',
                        anchor: '100%',
                        allowBlank: true,
                        store: stImpresionDx,
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        id: 'strImpresionDiagnostica'
                    }
                ]
            },
            {
                xtype: 'fieldset',
                title: 'CONCEPTO',
                layout: 'form',
                collapseFirst: false,
                collapsible: true,
                animCollapse: true,
                titleCollapse: true,
                anchor: '100%',
                labelWidth: 210,
                labelSeparator: '',
                autoHeight: true,
                padding: 5,
                id: 'fsConcepto',
                items: [
                    {
                        xtype: 'combo',
                        name: 'CONCEPTO',
                        fieldLabel: 'CONCEPTO',
                        anchor: '100%',
                        allowBlank: true,
                        store: stConcepto,
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        id: 'strConcepto'
                    }
                ]
            },
            {
                xtype: 'fieldset',
                title: 'RECOMENDACIONES',
                layout: 'table',
                collapseFirst: false,
                collapsible: true,
                animCollapse: true,
                titleCollapse: true,
                anchor: '100%',
                autoHeight: true,
                padding: 7,
                items: [
                    {
                        xtype: 'textarea',
                        anchor: '100%',
                        width: 880,
                        fieldLabel: 'RECOMENDACIONES',
                        name: 'RECOMENDACIONES',
                        height: 100,
                        allowBlank: false,
                        id: 'memRecomendaciones'
                    }
                ]
            }
        ];
        this.tbar = [
            '->',
            {
                xtype: 'tbseparator'
            },
            {
                xtype: 'button',
                text: 'Guardar Anexo',
                iconCls: 'btnGuardar',
                id: 'btnGuardarAnexoEquilibrio',
                listeners: {
                    click: function(){
                        alert("Se Guardara la Informacion, En estado de construccion");
                    }
                }
            },
            {
                xtype: 'tbseparator'
            }
        ];
        fsValoracionEquilibrioUi.superclass.initComponent.call(this);
    }
});

