/*
* @category    Formulario Modelo Evolucion Historia Clinica Evaluacion OsteoMuscular
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winHCEvaluacionOsteoMuscularUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic ©  .:: Plantilla Historia Clinica Evaluacion OsteoMuscular ::.',
    width: 990,
    height: 636,
    closable: false,
    resizable: false,
    draggable: false,
    modal: true,
    id: 'winHC',
    initComponent: function() {
        
        /*var fsDiagnosticosConsulta = new fsDiagnosticosConsultaUi();
        var fsRevisionxSistemas = new fsRevisionxSistemasUi();
        var fsAntecedentesPersonales = new fsAntecedentesPersonalesUi();
        var fsAntecedentesFamiliares = new fsAntecedentesFamiliaresUi();
        var fsExamenFisico = new fsExamenFisicoUi();*/
        
        tmpmx = objMX;
        tmpmxadd = objMXADD;
        tmpexa = objEXA;
        tmprem = objREM;
        myPaciente = 0;
        myCAS = 0;

        try {
            var campo = Ext.getCmp('sysPacientePlantillaHC');
            if ( campo !== null ) {
                myPaciente = Ext.getCmp('sysPacientePlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myPaciente === 0){
            try {
                var campo1 = Ext.getCmp('sysIdPacienteHC');
                if ( campo1 !== null ) {
                    myPaciente = Ext.getCmp('sysIdPacienteHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myPaciente === 0){
            try {
                var campo5 = Ext.getCmp('sysPacienteRefHC');
                if ( campo5 !== null ) {
                    myPaciente = Ext.getCmp('sysPacienteRefHC').getValue();
                }
            }catch(ex){
            }
        }
        try {
            var campo2 = Ext.getCmp('sysCASPlantillaHC');
            if ( campo2 !== null ) {
                myCAS = Ext.getCmp('sysCASPlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myCAS === 0){
            try {
                var campo3 = Ext.getCmp('sysCASHC');
                if ( campo3 !== null ) {
                    myCAS = Ext.getCmp('sysCASHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myCAS === 0){
            try {
                var campo4 = Ext.getCmp('sysCASRefHC');
                if ( campo4 !== null ) {
                    myCAS = Ext.getCmp('sysCASRefHC').getValue();
                }
            }catch(ex){
            }
        }
        if (objMX !== "NA"){
            var xSolMX = eval(objMX);
            Ext.getCmp('gridMedicamentosHC').store.load({
                params: {
                    task: 'MX_IPS_BASICA',
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }
        else{
            var xSolMX = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        if (objEXA !== "NA"){
            var xSolEXA = eval(objEXA);
            Ext.getCmp('gridExamenesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }else{
            var xSolEXA = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        if (objREM !== "NA"){
            var xSolREM = eval(objREM);
            Ext.getCmp('gridRemisionesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }else{
            var xSolREM = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        var xSolNOPOS = new SolNOPOS001Ui();
        Ext.getCmp('gridSolicitudesNOPOSxPaciente').store.load({
            params: {
                task: 'LISTAR_NOPOS',
                pPaciente: myPaciente
            }
        });
        //
        
        var dataTurno = [
            ['Diurno'],
            ['Nocturno'],
            ['Rotativo']
        ];
        var stTurno = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stTurno.loadData(dataTurno);


        var dataPosicionActividad = [
            ['Sentado'],
            ['De Pie'],
            ['Caminando'],
            ['Arrodillado'],
            ['Inclinado'],
            ['Otra']
        ];
        var stPosicionActividad = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stPosicionActividad.loadData(dataPosicionActividad);


        var dataAccionesRealiza = [
            ['Alcanzar'],
            ['Halar'],
            ['Empujar'],
            ['Levantar'],
            ['Arrastrar'],
            ['Otro']
        ];
        var stAccionesRealiza = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stAccionesRealiza.loadData(dataAccionesRealiza);

        var dataNormal = [
            ['Normal'],
            ['ANormal']
        ];
        var stNormal = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stNormal.loadData(dataNormal);
        
        
        this.items = [
            {
                xtype: 'panel',
                frame: true,
                anchor: '100%',
                id: 'panelHC',
                border: false,
                height: 570,
                autoScroll: true,
                layout: 'form',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysIdCodPlantillaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        value: 1,
                        id: 'sysUsaGridSalida'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        value: 0,
                        id: 'sysYaGuardoHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysPlantillaHC',
                        name: 'PLANTILLA'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptMx'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptExa'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptRem'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Actividad',
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        id: 'sysActividadHC',
                        name: 'PLANTILLA'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Empresa',
                        id: 'sysEmpresaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'IPS',
                        id: 'sysIPSHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Usuario',
                        id: 'sysUsuarioHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Profesional',
                        id: 'sysProfesionalHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Paciente',
                        id: 'sysIdPacienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Apertura',
                        id: 'sysAperturaHC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Cliente',
                        id: 'sysClienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdClienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdPlanHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdSubPlanHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdContratoHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Genero',
                        id: 'sysGeneroPacHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Edad',
                        id: 'sysEdadPacHC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Profesional',
                        id: 'sysProfesionalAgendaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'ConsecutivoDetalle',
                        id: 'sysConsecutivoDetalleHC'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'CAS',
                                id: 'sysCASHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysFechaHC',
                                value: 'Fecha: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysFechaHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysHoraHC',
                                value: 'Hora: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysHoraHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysLegalizacionHC',
                                value: 'Legalización: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysLegalizaHC'
                            }
                        ]
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Paciente',
                        value: 'CC 792558261  - JORGE GALEANO RUIZ - (Masculino) FechaNac: 1973-01-30, Edad 38 Años',
                        id: 'sysPacienteHC'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                width: 100,
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'Genero',
                                id: 'sysGeneroHC'
                            },
                            {
                                html: 'Fecha Nac:'
                            },
                            {
                                xtype: 'textfield',
                                width: 100,
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysFechaNac'
                            },
                            {
                                html: 'Edad:'
                            },
                            {
                                xtype: 'textfield',
                                width: 350,
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysEdadHC'
                            }
                        ]
                    },
                    /*{
                        xtype: 'button',
                        iconCls: 'btnImprimir',
                        text: 'Cargar Antecedentes',
                        tooltip: 'Cargar Antecedentes',
                        listeners:{
                            click : function(){
                                Ext.Ajax.request({
                                    url: '../../controlador/asistencial/evolucionhc.php',
                                    waitMsg: 'Cargando Información...',
                                    params:{
                                        pCAS: myCAS,
                                        pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                                        task: 'ImportarAntecedentesPersonalesOfiClinic001'
                                    },
                                    success: function(result, request)
                                    {
                                        var jsonAntPersonales = Ext.util.JSON.decode(result.responseText);
                                        UtilCargarAntecedentesOfiClinic001(jsonAntPersonales.data);
                                    },
                                    scope:this
                                });
                            }
                        }
                    },*/
                    {
                        html: '<hr>',
                        style: 'background:transparent;',
                        border: false
                    },
                    {
                        xtype: 'tabpanel',
                        anchor: '99%',
                        autoHeight: true,
                        border: false,
                        enableTabScroll: true,
                        ref: 'fTabPanel',
                        id: 'fTabPanel',
                        activeTab: 0,
                        items: [
                            {
                                xtype: 'panel',
                                title: 'Evolución',
                                autoHeight: true,
                                autoScroll: true,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaEvolucion',
                                layout: 'form',
                                items: [
                                    {
                                        xtype: 'form',
                                        frame: true,
                                        anchor: '100%',
                                        id: 'frmHC',
                                        labelSeparator: '',
                                        padding: 10,
                                        border: false,
                                        autoScroll: true,
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'numberfield',
                                                        name: 'Antiguedad Empresa',
                                                        fieldLabel: 'Antiguedad Empresa',
                                                        width: 70,
                                                        decimalPrecision: 0,
                                                        allowBlank: true,
                                                        id: 'intOSTEOAntiguedad'
                                                    },
                                                    {
                                                        html:'Nombre Cargo Actual:'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        name: 'Nombre Cargo Actual',
                                                        width: 120,
                                                        allowBlank: true,
                                                        id: 'strOSTEOCargoActual'
                                                    },
                                                    {
                                                        html:'Antiguedad Cargo'
                                                    },
                                                    {
                                                        xtype: 'numberfield',
                                                        name: 'Antiguedad Cargo',
                                                        width: 70,
                                                        decimalPrecision: 0,
                                                        allowBlank: true,
                                                        id: 'intOSTEOAntiguedadCargo'
                                                    },
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        name: 'Seccion',
                                                        fieldLabel: 'Seccion<br>&nbsp;',
                                                        width: 120,
                                                        allowBlank: true,
                                                        id: 'strOSTEOSeccion'
                                                    },
                                                    {
                                                        html:'Turno'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: 'Turno',
                                                        width: 120,
                                                        allowBlank: true,
                                                        store: stTurno,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strOSTEOTurno'
                                                    },
                                                ]
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Descripcion Cargo',
                                                fieldLabel: 'Descripcion Cargo<br>&nbsp;',
                                                anchor: '100%',
                                                allowBlank: true,
                                                id: 'strOSTEODescripcionCargo'
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        name: 'Las Actividades las Realiza',
                                                        fieldLabel: 'Las Actividades las Realiza',
                                                        width: 120,
                                                        allowBlank: true,
                                                        store: stPosicionActividad,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strOSTEOPocisionActividad'
                                                    },
                                                    {
                                                        html:'Equipo Utilizado'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        name: 'Equipo Utilizado',
                                                        width: 200,
                                                        allowBlank: true,
                                                        id: 'strOSTEOEquipoUtilizado'
                                                    },
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        name: 'Acciones que realiza',
                                                        fieldLabel: 'Acciones que realiza',
                                                        width: 120,
                                                        allowBlank: true,
                                                        store: stAccionesRealiza,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strOSTEOAccionesRealiza'
                                                    },
                                                    {
                                                        html:'Materias Primas o insumos Utilizados'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        name: 'Materias Primas o insumos Utilizados',
                                                        width: 200,
                                                        allowBlank: true,
                                                        id: 'strOSTEOInsumoUtilizado'
                                                    },
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'CONDICIONES DE TRABAJO',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                labelWidth: 600,
                                                labelSeparator: '',
                                                autoHeight: true,
                                                padding: 5,
                                                id: 'fsCondicionesTrabajo',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Trabaja en pantalla visual de datos mas del 75% del tiempo de la jornada laboral (6h/continuas)<br>&nbsp;',
                                                        name: 'Trabaja en pantalla visual de datos mas del 75% del tiempo de la jornada laboral (6h/continuas)',
                                                        width: 90,
                                                        allowBlank: true,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strCondicionesTrabajo_1'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Postura sedente mas del 75% del tiempo de la jornada laboral (6h/continuas)<br>&nbsp;',
                                                        name: 'Postura sedente mas del 75% del tiempo de la jornada laboral (6h/continuas)',
                                                        width: 90,
                                                        allowBlank: true,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strCondicionesTrabajo_2'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Postura de pie mas del 75% del tiempo de la jornada laboral (6h/continuas)<br>&nbsp;',
                                                        name: 'Postura de pie mas del 75% del tiempo de la jornada laboral (6h/continuas)',
                                                        width: 90,
                                                        allowBlank: true,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strCondicionesTrabajo_3'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'El trabajo exige movimientos repetitivos?<br>&nbsp;',
                                                        name: 'El trabajo exige movimientos repetitivos?',
                                                        width: 90,
                                                        allowBlank: true,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strCondicionesTrabajo_4'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'El trabajo exige ejecucion de fuerza con las manos?<br>&nbsp;',
                                                        name: 'El trabajo exige ejecucion de fuerza con las manos?',
                                                        width: 90,
                                                        allowBlank: true,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strCondicionesTrabajo_5'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'El trabajo exige agarre palmar o digital frecuente?<br>&nbsp;',
                                                        name: 'El trabajo exige agarre palmar o digital frecuente?',
                                                        width: 90,
                                                        allowBlank: true,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strCondicionesTrabajo_6'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'El trabajo exige grazos por encima del hombro?<br>&nbsp;',
                                                        name: 'El trabajo exige grazos por encima del hombro?',
                                                        width: 90,
                                                        allowBlank: true,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strCondicionesTrabajo_7'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'El trabajo exige manipulacion de carga? (levantar/depos)<br>&nbsp;',
                                                        name: 'El trabajo exige manipulacion de carga? (levantar/depos)',
                                                        width: 90,
                                                        allowBlank: true,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strCondicionesTrabajo_8'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'En mi actividad debo flexionar o girar con el tronco?<br>&nbsp;',
                                                        name: 'En mi actividad debo flexionar o girar con el tronco?',
                                                        width: 90,
                                                        allowBlank: true,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strCondicionesTrabajo_9'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'En mi actividad debo transportar carga (empujar o jalar)?<br>&nbsp;',
                                                        name: 'En mi actividad debo transportar carga (empujar o jalar)?',
                                                        width: 90,
                                                        allowBlank: true,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strCondicionesTrabajo_10'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                layout: 'table',
                                                title: '<center>ACCIDENTES DE TRABAJO A NIVEL OSTEONUSCULAR</center>',
                                                layoutConfig: {
                                                    columns: 7
                                                },
                                                padding: 0,
                                                items: [
                                                    {
                                                        xtype: 'panel',
                                                        layout: 'form',
                                                        width: 105,
                                                        height: 125,
                                                        labelWidth: 1,
                                                        labelSeparator: '',
                                                        labelStyle: 'color:blue;',
                                                        title: '<center>FECHA</center>',
                                                        items: [
                                                            {
                                                                xtype: 'datefield',
                                                                width: 95,
                                                                name: 'FechaAccidente1',
                                                                allowBlank: true,
                                                                style: 'text-align:center;',
                                                                id: 'fecOSTEOAccidenteFecha_1'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 95,
                                                                name: 'FechaAccidente2',
                                                                allowBlank: true,
                                                                style: 'text-align:center;',
                                                                id: 'fecOSTEOAccidenteFecha_2'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 95,
                                                                name: 'FechaAccidente3',
                                                                allowBlank: true,
                                                                style: 'text-align:center;',
                                                                id: 'fecOSTEOAccidenteFecha_3'
                                                            },
                                                       ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        layout: 'form',
                                                        width: 150,
                                                        height: 125,
                                                        labelWidth: 1,
                                                        labelSeparator: '',
                                                        labelStyle: 'color:blue;',
                                                        title: '<center>EMPRESA</center>',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Empresa1',
                                                                width: 140,
                                                                allowBlank: true,
                                                                id: 'strOSTEOAccidenteEmpresa_1'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Empresa2',
                                                                width: 140,
                                                                allowBlank: true,
                                                                id: 'strOSTEOAccidenteEmpresa_2'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Empresa3',
                                                                width: 140,
                                                                allowBlank: true,
                                                                id: 'strOSTEOAccidenteEmpresa_3'
                                                            },
                                                       ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        layout: 'form',
                                                        width: 140,
                                                        height: 125,
                                                        labelWidth: 1,
                                                        labelSeparator: '',
                                                        labelStyle: 'color:blue;',
                                                        title: '<center>CAUSA</center>',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Causa1',
                                                                width: 130,
                                                                allowBlank: true,
                                                                id: 'strOSTEOAccidenteCausa_1'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Causa2',
                                                                width: 130,
                                                                allowBlank: true,
                                                                id: 'strOSTEOAccidenteCausa_2'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Causa3',
                                                                width: 130,
                                                                allowBlank: true,
                                                                id: 'strOSTEOAccidenteCausa_3'
                                                            }
                                                       ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        layout: 'form',
                                                        width: 120,
                                                        height: 125,
                                                        labelWidth: 1,
                                                        labelSeparator: '',
                                                        labelStyle: 'color:blue;',
                                                        title: '<center>TIPO LESION</center>',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'TipoLesion1',
                                                                width: 110,
                                                                allowBlank: true,
                                                                id: 'strOSTEOTipoLesion_1'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'TipoLesion2',
                                                                width: 110,
                                                                allowBlank: true,
                                                                id: 'strOSTEOTipoLesion_2'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'TipoLesion3',
                                                                width: 110,
                                                                allowBlank: true,
                                                                id: 'strOSTEOTipoLesion_3'
                                                            }
                                                       ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        layout: 'form',
                                                        width: 150,
                                                        height: 125,
                                                        labelWidth: 1,
                                                        labelSeparator: '',
                                                        labelStyle: 'color:blue;',
                                                        title: '<center>PARTE DEL CUERPO</center>',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'ParteCuerpo1',
                                                                width: 140,
                                                                allowBlank: true,
                                                                id: 'strOSTEOParteCuerpo_1'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'ParteCuerpo2',
                                                                width: 140,
                                                                allowBlank: true,
                                                                id: 'strOSTEOParteCuerpo_2'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'ParteCuerpo3',
                                                                width: 140,
                                                                allowBlank: true,
                                                                id: 'strOSTEOParteCuerpo_3'
                                                            },
                                                       ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        layout: 'form',
                                                        width: 70,
                                                        height: 125,
                                                        labelWidth: 1,
                                                        labelSeparator: '',
                                                        labelStyle: 'color:blue;',
                                                        title: '<center>DIAS INC.</center>',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'DiasIncapacidad1',
                                                                width: 60,
                                                                decimalPrecision: 0,
                                                                allowBlank: true,
                                                                id: 'intOSTEODiasIncapacidad_1'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'DiasIncapacidad2',
                                                                width: 60,
                                                                decimalPrecision: 0,
                                                                allowBlank: true,
                                                                id: 'intOSTEODiasIncapacidad_2'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'DiasIncapacidad3',
                                                                width: 60,
                                                                decimalPrecision: 0,
                                                                allowBlank: true,
                                                                id: 'intOSTEODiasIncapacidad_3'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        layout: 'form',
                                                        width: 140,
                                                        height: 125,
                                                        labelWidth: 1,
                                                        labelSeparator: '',
                                                        labelStyle: 'color:blue;',
                                                        title: '<center>SECUELAS</center>',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Secuela1',
                                                                width: 130,
                                                                allowBlank: true,
                                                                id: 'strOSTEOSecuela_1'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Secuela2',
                                                                width: 130,
                                                                allowBlank: true,
                                                                id: 'strOSTEOSecuela_2'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Secuela3',
                                                                width: 130,
                                                                allowBlank: true,
                                                                id: 'strOSTEOSecuela_3'
                                                            },
                                                       ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                layout: 'table',
                                                title: '<center>ENFERMEDAD PROFESIONAL DEL TIPO OSTEONUSCULAR</center>',
                                                layoutConfig: {
                                                    columns: 5
                                                },
                                                padding: 0,
                                                items: [
                                                    {
                                                        xtype: 'panel',
                                                        layout: 'form',
                                                        width: 105,
                                                        height: 125,
                                                        labelWidth: 1,
                                                        labelSeparator: '',
                                                        labelStyle: 'color:blue;',
                                                        title: '<center>FECHA</center>',
                                                        items: [
                                                            {
                                                                xtype: 'datefield',
                                                                width: 95,
                                                                name: 'FechaAccidente1',
                                                                allowBlank: true,
                                                                style: 'text-align:center;',
                                                                id: 'fecOSTEOEnfermedadFecha_1'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 95,
                                                                name: 'FechaAccidente2',
                                                                allowBlank: true,
                                                                style: 'text-align:center;',
                                                                id: 'fecOSTEOEnfermedadFecha_2'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 95,
                                                                name: 'FechaAccidente3',
                                                                allowBlank: true,
                                                                style: 'text-align:center;',
                                                                id: 'fecOSTEOEnfermedadFecha_3'
                                                            },
                                                       ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        layout: 'form',
                                                        width: 150,
                                                        height: 125,
                                                        labelWidth: 1,
                                                        labelSeparator: '',
                                                        labelStyle: 'color:blue;',
                                                        title: '<center>EMPRESA</center>',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Empresa1',
                                                                width: 140,
                                                                allowBlank: true,
                                                                id: 'strOSTEOEnfermedadEmpresa_1'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Empresa2',
                                                                width: 140,
                                                                allowBlank: true,
                                                                id: 'strOSTEOEnfermedadEmpresa_2'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Empresa3',
                                                                width: 140,
                                                                allowBlank: true,
                                                                id: 'strOSTEOEnfermedadEmpresa_3'
                                                            },
                                                       ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        layout: 'form',
                                                        width: 250,
                                                        height: 125,
                                                        labelWidth: 1,
                                                        labelSeparator: '',
                                                        labelStyle: 'color:blue;',
                                                        title: '<center>DIAGNOSTICO</center>',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Diagnostico1',
                                                                width: 240,
                                                                allowBlank: true,
                                                                id: 'strOSTEODiagnostico_1'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Diagnostico2',
                                                                width: 240,
                                                                allowBlank: true,
                                                                id: 'strOSTEODiagnostico_2'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Diagnostico3',
                                                                width: 240,
                                                                allowBlank: true,
                                                                id: 'strOSTEODiagnostico_3'
                                                            },
                                                       ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        layout: 'form',
                                                        width: 220,
                                                        height: 125,
                                                        labelWidth: 1,
                                                        labelSeparator: '',
                                                        labelStyle: 'color:blue;',
                                                        title: '<center>INDEMNIZACION?</center>',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Indemnizacion1',
                                                                width: 210,
                                                                allowBlank: true,
                                                                id: 'strOSTEOIndemnizacion_1'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Indemnizacion2',
                                                                width: 210,
                                                                allowBlank: true,
                                                                id: 'strOSTEOIndemnizacion_2'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Indemnizacion3',
                                                                width: 210,
                                                                allowBlank: true,
                                                                id: 'strOSTEOIndemnizacion_3'
                                                            }
                                                       ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        layout: 'form',
                                                        width: 150,
                                                        height: 125,
                                                        labelWidth: 1,
                                                        labelSeparator: '',
                                                        labelStyle: 'color:blue;',
                                                        title: '<center>REUBICACION</center>',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Reubicacion1',
                                                                width: 140,
                                                                allowBlank: true,
                                                                id: 'strOSTEOReubicacion_1'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Reubicacion2',
                                                                width: 140,
                                                                allowBlank: true,
                                                                id: 'strOSTEOReubicacion_2'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Reubicacion3',
                                                                width: 140,
                                                                allowBlank: true,
                                                                id: 'strOSTEOReubicacion_3'
                                                            }
                                                       ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'ANTECEDENTES OSTEOMUSCULARES',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                labelWidth: 600,
                                                labelSeparator: '',
                                                autoHeight: true,
                                                padding: 5,
                                                id: 'fsAntecedentesOsteomusculares',
                                                items: [
                                                    {
                                                        xtype: 'panel',
                                                        layout: 'table',
                                                        layoutConfig: {
                                                            columns: 3
                                                        },
                                                        padding: 0,
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                width: 300,
                                                                height: 150,
                                                                labelWidth: 270,
                                                                labelSeparator: '',
                                                                labelStyle: 'color:blue;',
                                                                title: '<center>PATOLOGIA</center>',
                                                                items: [
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Fracturas',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaA'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Cirugias Osteomusculares',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaB'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Sintomas a Nivel de Columna Vertebral',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaC'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Sintomas a Nivel Osteomuscular',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaD'
                                                                    },
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                width: 70,
                                                                height: 150,
                                                                labelWidth: 1,
                                                                labelSeparator: '',
                                                                labelStyle: 'color:blue;',
                                                                title: '<center>SI/NO</center>',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Fractura',
                                                                        width: 60,
                                                                        allowBlank: true,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strANTOSTEOFractura'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Cirugias Osteomusculares',
                                                                        width: 60,
                                                                        allowBlank: true,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strANTOSTEOCirugiasOsteomusculares'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Sintomas a Nivel de Columna Vertebral',
                                                                        width: 60,
                                                                        allowBlank: true,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strANTOSTEOSintomasNivelColumnaVertebral'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Sintomas a Nivel Osteomuscular',
                                                                        width: 60,
                                                                        allowBlank: true,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strANTOSTEOSintomasNivelOsteomuscular'
                                                                    },
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                width: 150,
                                                                height: 150,
                                                                labelWidth: 1,
                                                                labelSeparator: '',
                                                                labelStyle: 'color:blue;',
                                                                title: '<center>HACE CUANTO</center>',
                                                                items: [
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'HaceCuanto1',
                                                                        width: 140,
                                                                        allowBlank: true,
                                                                        id: 'strANTOSTEOHaceCuanto_1'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'HaceCuanto2',
                                                                        width: 140,
                                                                        allowBlank: true,
                                                                        id: 'strANTOSTEOHaceCuanto_2'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'HaceCuanto3',
                                                                        width: 140,
                                                                        allowBlank: true,
                                                                        id: 'strANTOSTEOHaceCuanto_3'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'HaceCuanto4',
                                                                        width: 140,
                                                                        allowBlank: true,
                                                                        id: 'strANTOSTEOHaceCuanto_4'
                                                                    },
                                                                ]
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'textarea',
                                                anchor: '100%',
                                                width: 880,
                                                fieldLabel: 'Descripcion',
                                                name: 'Descripcion',
                                                height: 100,
                                                allowBlank: false,
                                                id: 'memANTOSTEODescripcion'
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'ANTECEDENTES QUIRURGICOS OSTEOMUSCULARES',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                labelSeparator: '',
                                                autoHeight: true,
                                                padding: 5,
                                                id: 'fsAntecedentesQuirurgicosOsteomusculares',
                                                items: [
                                                    {
                                                        xtype: 'panel',
                                                        layout: 'table',
                                                        layoutConfig: {
                                                            columns: 3
                                                        },
                                                        padding: 0,
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                width: 150,
                                                                height: 80,
                                                                labelWidth: 1,
                                                                labelSeparator: '',
                                                                labelStyle: 'color:blue;',
                                                                title: '<center>TIPO CIRUGIA</center>',
                                                                items: [
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'TipoCirugia1',
                                                                        width: 140,
                                                                        allowBlank: true,
                                                                        id: 'strANTOSTEOTipoCirugia_1'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'TipoCirugia2',
                                                                        width: 140,
                                                                        allowBlank: true,
                                                                        id: 'strANTOSTEOTipoCirugia_2'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                width: 105,
                                                                height: 80,
                                                                labelWidth: 1,
                                                                labelSeparator: '',
                                                                labelStyle: 'color:blue;',
                                                                title: '<center>FECHA</center>',
                                                                items: [
                                                                    {
                                                                        xtype: 'datefield',
                                                                        width: 95,
                                                                        name: 'FechaCirugia1',
                                                                        allowBlank: true,
                                                                        style: 'text-align:center;',
                                                                        id: 'fecCIROSTEOFechaCirugia_1'
                                                                    },
                                                                    {
                                                                        xtype: 'datefield',
                                                                        width: 95,
                                                                        name: 'FechaCirugia2',
                                                                        allowBlank: true,
                                                                        style: 'text-align:center;',
                                                                        id: 'fecCIROSTEOFechaCirugia_2'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'ANTECEDENTES TRAUMATICOS OSTEOMUSCULARES',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                labelSeparator: '',
                                                autoHeight: true,
                                                padding: 5,
                                                id: 'fsAntecedentesTraumaticosOsteomusculares',
                                                items: [
                                                    {
                                                        xtype: 'panel',
                                                        layout: 'table',
                                                        layoutConfig: {
                                                            columns: 3
                                                        },
                                                        padding: 0,
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                width: 150,
                                                                height: 80,
                                                                labelWidth: 1,
                                                                labelSeparator: '',
                                                                labelStyle: 'color:blue;',
                                                                title: '<center>LESION</center>',
                                                                items: [
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Lesion1',
                                                                        width: 140,
                                                                        allowBlank: true,
                                                                        id: 'strTRAUMAANTOSTEOLesion_1'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Lesion2',
                                                                        width: 140,
                                                                        allowBlank: true,
                                                                        id: 'strTRAUMAANTOSTEOLesion_2'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                width: 150,
                                                                height: 80,
                                                                labelWidth: 1,
                                                                labelSeparator: '',
                                                                labelStyle: 'color:blue;',
                                                                title: '<center>CAUSA</center>',
                                                                items: [
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Causa1',
                                                                        width: 140,
                                                                        allowBlank: true,
                                                                        id: 'strTRAUMAANTOSTEOCausa_1'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Causa2',
                                                                        width: 140,
                                                                        allowBlank: true,
                                                                        id: 'strTRAUMAANTOSTEOCausa_2'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'textarea',
                                                anchor: '100%',
                                                width: 880,
                                                fieldLabel: 'Secuelas',
                                                name: 'Secuelas',
                                                height: 100,
                                                allowBlank: false,
                                                id: 'memANTOSTEOSecuelas'
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'Describa los medicamentos que actualmente toma para patologia Osteomuscular',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                labelWidth: 1,
                                                labelSeparator: '',
                                                autoHeight: true,
                                                padding: 5,
                                                id: 'fsAntecedentesMedicamentosOsteomusculares',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        name: 'Medicamentos1',
                                                        anchor: '100%',
                                                        allowBlank: true,
                                                        id: 'strOSTEOMedicamentos_1'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        name: 'Medicamentos2',
                                                        anchor: '100%',
                                                        allowBlank: true,
                                                        id: 'strOSTEOMedicamentos_2'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        name: 'Medicamentos3',
                                                        anchor: '100%',
                                                        allowBlank: true,
                                                        id: 'strOSTEOMedicamentos_3'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        name: 'Medicamentos4',
                                                        anchor: '100%',
                                                        allowBlank: true,
                                                        id: 'strOSTEOMedicamentos_4'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'FACTORES PREDISPONIENTES PARA PATOLOGIA OSTEOMUSCULAR',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                labelWidth: 600,
                                                labelSeparator: '',
                                                autoHeight: true,
                                                padding: 5,
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Sedentarismo<br>&nbsp;',
                                                        name: 'Sedentarismo',
                                                        width: 90,
                                                        allowBlank: true,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strFactoresSedentarismo'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Sobrepeso<br>&nbsp;',
                                                        name: 'Sobrepesoo',
                                                        width: 90,
                                                        allowBlank: true,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strFactoresSobrepeso'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Deportes de Raqueta (Tenis/squash)<br>&nbsp;',
                                                        name: 'Deportes de Raqueta (Tenis/squash)',
                                                        width: 90,
                                                        allowBlank: true,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strFactoresDeportesRaqueta'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Manualidades (pintar, bordar, tejer, instrumento muscial, etc)<br>&nbsp;',
                                                        name: 'Manualidades (pintar, bordar, tejer, instrumento muscial, etc)',
                                                        width: 90,
                                                        allowBlank: true,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strFactoresManualidades'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Pasatiempos (jardineria, Coser, tejer, pintar, manualidades, oficios domesticos)<br>&nbsp;',
                                                        name: 'Pasatiempos (jardineria, Coser, tejer, pintar, manualidades, oficios domesticos)',
                                                        width: 90,
                                                        allowBlank: true,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strFactoresPasatiempos'
                                                    },
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'REVISION POR SISTEMAS Y ENFERMEDAD ACTUAL',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                labelSeparator: '',
                                                autoHeight: true,
                                                padding: 5,
                                                id: 'fsRevisionSistemasOsteomuscular',
                                                items: [
                                                    {
                                                        xtype: 'panel',
                                                        layout: 'table',
                                                        layoutConfig: {
                                                            columns: 3
                                                        },
                                                        padding: 0,
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                width: 250,
                                                                height: 520,
                                                                labelWidth: 220,
                                                                labelSeparator: '',
                                                                labelStyle: 'color:blue;',
                                                                title: '<center>SINTOMATOLOGIA</center>',
                                                                items: [
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Nuca, Cuello<br>&nbsp;',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExa1'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Hombro Derecho<br>&nbsp;',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExa2'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Hombro Izquierdo<br>&nbsp;',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExa3'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Codo Derecho<br>&nbsp;',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExa4'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Codo Izquierdo<br>&nbsp;',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExa5'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Mano, Muñeca Derecho<br>&nbsp;',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExa6'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Mano, Muñeca Izquierdo<br>&nbsp;',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExa7'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Columna Dorsal<br>&nbsp;',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExa8'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Columna Lumbar<br>&nbsp;',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExa9'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Rodillas<br>&nbsp;',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExa10'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Miembros Inferiores<br>&nbsp;',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExa11'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Varices<br>&nbsp;',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExa12'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                width: 100,
                                                                height: 520,
                                                                labelWidth: 1,
                                                                labelSeparator: '',
                                                                labelStyle: 'color:blue;',
                                                                title: '<center>SI/NO</center>',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Nuca, Cuello',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        width: 90,
                                                                        allowBlank: true,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strRevSistOsteo_1'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Hombro Derecho',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        width: 90,
                                                                        allowBlank: true,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strRevSistOsteo_2'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Hombro Izqueirdo',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        width: 90,
                                                                        allowBlank: true,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strRevSistOsteo_3'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Codo Derecho',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        width: 90,
                                                                        allowBlank: true,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strRevSistOsteo_4'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Codo Izquierdo',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        width: 90,
                                                                        allowBlank: true,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strRevSistOsteo_5'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Mano, Muneca Derecha',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        width: 90,
                                                                        allowBlank: true,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strRevSistOsteo_6'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Mano, Muneca Izquierda',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        width: 90,
                                                                        allowBlank: true,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strRevSistOsteo_7'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Columna Dorsal',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        width: 90,
                                                                        allowBlank: true,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strRevSistOsteo_8'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Columna Lumbar',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        width: 90,
                                                                        allowBlank: true,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strRevSistOsteo_9'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Rodillas',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        width: 90,
                                                                        allowBlank: true,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strRevSistOsteo_10'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Miembros Inferiores',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        width: 90,
                                                                        allowBlank: true,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strRevSistOsteo_11'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Varices',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        width: 90,
                                                                        allowBlank: true,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strRevSistOsteo_12'
                                                                    },
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                width: 450,
                                                                height: 520,
                                                                labelWidth: 1,
                                                                labelSeparator: '',
                                                                labelStyle: 'color:blue;',
                                                                title: '<center>DESCRIPCION</center>',
                                                                items: [
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Nuca, Cuello',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        id: 'strRevSistOsteoDescripcion_1'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Hombro Derecho',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        id: 'strRevSistOsteoDescripcion_2'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Hombro Izqueirdo',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        id: 'strRevSistOsteoDescripcion_3'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Codo Derecho',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        id: 'strRevSistOsteoDescripcion_4'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Codo Izquierdo',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        id: 'strRevSistOsteoDescripcion_5'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Mano, Muneca Derecha',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        id: 'strRevSistOsteoDescripcion_6'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Mano, Muneca Izquierda',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        id: 'strRevSistOsteoDescripcion_7'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Columna Dorsal',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        id: 'strRevSistOsteoDescripcion_8'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Columna Lumbar',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        id: 'strRevSistOsteoDescripcion_9'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Rodillas',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        id: 'strRevSistOsteoDescripcion_10'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Miembros Inferiores',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        id: 'strRevSistOsteoDescripcion_11'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Varices',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        id: 'strRevSistOsteoDescripcion_12'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'EXAMEN FISICO',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                labelSeparator: '',
                                                autoHeight: true,
                                                padding: 5,
                                                id: 'fsExamenFisicoOsteomuscular',
                                                items: [
                                                    {
                                                        xtype: 'panel',
                                                        layout: 'table',
                                                        layoutConfig: {
                                                            columns: 3
                                                        },
                                                        padding: 0,
                                                        title: '<center>COLUMNA VERTEBRAL</center>',
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                width: 250,
                                                                height: 220,
                                                                labelWidth: 220,
                                                                labelSeparator: '',
                                                                labelStyle: 'color:blue;',
                                                                title: '<center>INSPECCION</center>',
                                                                items: [
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Alineacio Vista Lateral<br>&nbsp;',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExa_A'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Cifosis<br>&nbsp;',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExa_B'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Lordosis<br>&nbsp;',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExa_C'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Escoliosis<br>&nbsp;',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExa_D'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Disbalance Muscular<br>&nbsp;',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExa_E'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                width: 100,
                                                                height: 220,
                                                                labelWidth: 1,
                                                                labelSeparator: '',
                                                                labelStyle: 'color:blue;',
                                                                title: '<center>N/AN</center>',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Alineacion en Vista Lateral',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        width: 90,
                                                                        allowBlank: true,
                                                                        store: stNormal,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strExaFisOsteo_1'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Cifosis',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        width: 90,
                                                                        allowBlank: true,
                                                                        store: stNormal,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strExaFisOsteo_2'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Lordosis',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        width: 90,
                                                                        allowBlank: true,
                                                                        store: stNormal,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strExaFisOsteo_3'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Escoliosis',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        width: 90,
                                                                        allowBlank: true,
                                                                        store: stNormal,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strExaFisOsteo_4'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Disbalance Muscular',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        width: 90,
                                                                        allowBlank: true,
                                                                        store: stNormal,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strExaFisOsteo_5'
                                                                    },
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                width: 500,
                                                                height: 220,
                                                                labelWidth: 1,
                                                                labelSeparator: '',
                                                                labelStyle: 'color:blue;',
                                                                title: '<center>HALLAZGO</center>',
                                                                items: [
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Alineacion en Vista Lateral',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        id: 'strExaFisOsteoHallazgo_1'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Cifosis',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        id: 'strExaFisOsteoHallazgo_2'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Lordosis',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        id: 'strExaFisOsteoHallazgo_3'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Escoliosis',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        id: 'strExaFisOsteoHallazgo_4'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Disbalance Muscular',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        id: 'strExaFisOsteoHallazgo_5'
                                                                    },
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        layout: 'table',
                                                        layoutConfig: {
                                                            columns: 3
                                                        },
                                                        padding: 0,
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                width: 250,
                                                                height: 220,
                                                                labelWidth: 220,
                                                                labelSeparator: '',
                                                                labelStyle: 'color:blue;',
                                                                title: '<center>PALPACION</center>',
                                                                items: [
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Espasmo Muscular<br>&nbsp;',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExa_F'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Dolor en Region Dorsal<br>&nbsp;',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExa_G'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Dolor en Region Lumbar<br>&nbsp;',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExa_H'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Dolor Irradiado a M. Inf.<br>&nbsp;',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExa_I'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Musculos Paravertebrales<br>&nbsp;',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExa_J'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                width: 100,
                                                                height: 220,
                                                                labelWidth: 1,
                                                                labelSeparator: '',
                                                                labelStyle: 'color:blue;',
                                                                title: '<center>N/AN</center>',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Espasmo Muscular',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        width: 90,
                                                                        allowBlank: true,
                                                                        store: stNormal,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strExaFisOsteo_6'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Dolor en Region Dorsal',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        width: 90,
                                                                        allowBlank: true,
                                                                        store: stNormal,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strExaFisOsteo_7'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Dolor en Region Lumbar',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        width: 90,
                                                                        allowBlank: true,
                                                                        store: stNormal,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strExaFisOsteo_8'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Dolor Irradiado a M. Inf',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        width: 90,
                                                                        allowBlank: true,
                                                                        store: stNormal,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strExaFisOsteo_9'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Musculos Paravertebrales',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        width: 90,
                                                                        allowBlank: true,
                                                                        store: stNormal,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strExaFisOsteo_10'
                                                                    },
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                width: 500,
                                                                height: 220,
                                                                labelWidth: 1,
                                                                labelSeparator: '',
                                                                labelStyle: 'color:blue;',
                                                                title: '<center>HALLAZGO</center>',
                                                                items: [
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Espasmo Muscular',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        id: 'strExaFisOsteoHallazgos_6'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Dolor en Region Dorsal',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        id: 'strExaFisOsteoHallazgos_7'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Dolor en Region Lumbar',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        id: 'strExaFisOsteoHallazgos_8'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Dolor Irradiado a M. Inf',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        id: 'strExaFisOsteoHallazgos_9'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Musculos Paravertebrales',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        id: 'strExaFisOsteoHallazgos_10'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        layout: 'table',
                                                        layoutConfig: {
                                                            columns: 3
                                                        },
                                                        padding: 0,
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                width: 250,
                                                                height: 280,
                                                                labelWidth: 220,
                                                                labelSeparator: '',
                                                                labelStyle: 'color:blue;',
                                                                title: '<center>MOVILIDAD</center>',
                                                                items: [
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Flexion<br>&nbsp;',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExa_K'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Extension<br>&nbsp;',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExa_L'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Inclinacion Lateral<br>&nbsp;',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExa_M'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Rotacion<br>&nbsp;',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExa_N'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Test de Wells<br>&nbsp;',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExa_O'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Test de Shober<br>&nbsp;',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExa_P'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                width: 100,
                                                                height: 280,
                                                                labelWidth: 1,
                                                                labelSeparator: '',
                                                                labelStyle: 'color:blue;',
                                                                title: '<center>N/AN</center>',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Flexion',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        width: 90,
                                                                        allowBlank: true,
                                                                        store: stNormal,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strExaFisOsteo_11'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Extension',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        width: 90,
                                                                        allowBlank: true,
                                                                        store: stNormal,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strExaFisOsteo_12'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Inclinaciones Laterales',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        width: 90,
                                                                        allowBlank: true,
                                                                        store: stNormal,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strExaFisOsteo_13'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Rotacion',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        width: 90,
                                                                        allowBlank: true,
                                                                        store: stNormal,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strExaFisOsteo_14'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Test de Wells',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        width: 90,
                                                                        allowBlank: true,
                                                                        store: stNormal,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strExaFisOsteo_15'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Test de Shober',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        width: 90,
                                                                        allowBlank: true,
                                                                        store: stNormal,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strExaFisOsteo_16'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                width: 500,
                                                                height: 280,
                                                                labelWidth: 1,
                                                                labelSeparator: '',
                                                                labelStyle: 'color:blue;',
                                                                title: '<center>HALLAZGO</center>',
                                                                items: [
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Flexion',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        id: 'strExaFisOsteoHallazgo_11'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Extension',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        id: 'strExaFisOsteoHallazgo_12'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Inclinaciones Laterales',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        id: 'strExaFisOsteoHallazgo_13'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Rotacion',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        id: 'strExaFisOsteoHallazgo_14'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Test de Wells',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        id: 'strExaFisOsteoHallazgo_15'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Test de Shober',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        id: 'strExaFisOsteoHallazgo_16'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        layout: 'table',
                                                        layoutConfig: {
                                                            columns: 3
                                                        },
                                                        padding: 0,
                                                        title: '<center>NUCA</center>',
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                width: 250,
                                                                height: 220,
                                                                labelWidth: 220,
                                                                labelSeparator: '',
                                                                labelStyle: 'color:blue;',
                                                                title: '<center>&nbsp;</center>',
                                                                items: [
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Desviacion (Cifosis)<br>&nbsp;',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaNuca_A'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Contraccion Muscular<br>&nbsp;',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaNuca_B'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Dolor Localizado<br>&nbsp;',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaNuca_C'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Dolor irradiado a M. Sup.<br>&nbsp;',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaNuca_D'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Limitacion de la Movilidad<br>&nbsp;',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaNuca_E'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                width: 100,
                                                                height: 220,
                                                                labelWidth: 1,
                                                                labelSeparator: '',
                                                                labelStyle: 'color:blue;',
                                                                title: '<center>N/AN</center>',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Desviacion (Cifosis)',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        width: 90,
                                                                        allowBlank: true,
                                                                        store: stNormal,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strExaFisOsteoNuca_1'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Contraccion Muscular',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        width: 90,
                                                                        allowBlank: true,
                                                                        store: stNormal,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strExaFisOsteoNuca_2'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Dolor Localizado',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        width: 90,
                                                                        allowBlank: true,
                                                                        store: stNormal,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strExaFisOsteoNuca_3'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Dolor irradiado a M. Sup.',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        width: 90,
                                                                        allowBlank: true,
                                                                        store: stNormal,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strExaFisOsteoNuca_4'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Limitacion de la Movilidad',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        width: 90,
                                                                        allowBlank: true,
                                                                        store: stNormal,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strExaFisOsteoNuca_5'
                                                                    },
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                width: 500,
                                                                height: 220,
                                                                labelWidth: 1,
                                                                labelSeparator: '',
                                                                labelStyle: 'color:blue;',
                                                                title: '<center>HALLAZGO</center>',
                                                                items: [
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Desviacion (Cifosis)',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        id: 'strExaFisOsteoNucaHallazgo_1'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Contraccion Muscular',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        id: 'strExaFisOsteoNucaHallazgo_2'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Dolor Localizado',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        id: 'strExaFisOsteoNucaHallazgo_3'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Dolor irradiado a M. Sup.',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        id: 'strExaFisOsteoNucaHallazgo_4'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Limitacion de la Movilidad',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        id: 'strExaFisOsteoNucaHallazgo_5'
                                                                    },
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        layout: 'table',
                                                        layoutConfig: {
                                                            columns: 3
                                                        },
                                                        padding: 0,
                                                        title: '<center>HOMBROS</center>',
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                width: 250,
                                                                height: 220,
                                                                labelWidth: 220,
                                                                labelSeparator: '',
                                                                labelStyle: 'color:blue;',
                                                                title: '<center>&nbsp;</center>',
                                                                items: [
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Hombros al Mismo Nivel<br>&nbsp;',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaHombro_A'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Dolor<br>&nbsp;',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaHombro_B'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Friccion del Manguito<br>&nbsp;',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaHombro_C'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Limitacion del Movimiento<br>&nbsp;',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaHombro_D'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Abduccion + Rotacion<br>&nbsp;',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaHombro_E'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                width: 100,
                                                                height: 220,
                                                                labelWidth: 1,
                                                                labelSeparator: '',
                                                                labelStyle: 'color:blue;',
                                                                title: '<center>N/AN</center>',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Desviacion (Cifosis)',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        width: 90,
                                                                        allowBlank: true,
                                                                        store: stNormal,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strExaFisOsteoHombro_1'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Contraccion Muscular',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        width: 90,
                                                                        allowBlank: true,
                                                                        store: stNormal,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strExaFisOsteoHombro_2'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Dolor Localizado',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        width: 90,
                                                                        allowBlank: true,
                                                                        store: stNormal,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strExaFisOsteoHombro_3'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Dolor irradiado a M. Sup.',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        width: 90,
                                                                        allowBlank: true,
                                                                        store: stNormal,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strExaFisOsteoHombro_4'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Limitacion de la Movilidad',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        width: 90,
                                                                        allowBlank: true,
                                                                        store: stNormal,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strExaFisOsteoHombro_5'
                                                                    },
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                width: 500,
                                                                height: 220,
                                                                labelWidth: 1,
                                                                labelSeparator: '',
                                                                labelStyle: 'color:blue;',
                                                                title: '<center>HALLAZGO</center>',
                                                                items: [
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Hombros al Mismo Nivel',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        id: 'strExaFisOsteoHombroHallazgo_1'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Dolor',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        id: 'strExaFisOsteoHombroHallazgo_2'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Friccion del Manguito',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        id: 'strExaFisOsteoHombroHallazgo_3'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Limitacion del Movimiento',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        id: 'strExaFisOsteoHombroHallazgo_4'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Abduccion + Rotacion',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        id: 'strExaFisOsteoHombroHallazgo_5'
                                                                    },
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        layout: 'table',
                                                        layoutConfig: {
                                                            columns: 3
                                                        },
                                                        padding: 0,
                                                        title: '<center>CODOS</center>',
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                width: 250,
                                                                height: 380,
                                                                labelWidth: 200,
                                                                labelSeparator: '',
                                                                labelStyle: 'color:blue;',
                                                                title: '<center>&nbsp;</center>',
                                                                items: [
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Edema<br>&nbsp;',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaCodo_A'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Quistes<br>&nbsp;',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaCodo_B'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Desviaciones<br>&nbsp;',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaCodo_C'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Codo de Golfista<br>&nbsp;',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaCodo_D'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Codo de Tenistas<br>&nbsp;',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaCodo_E'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Compresion del Cubital<br>&nbsp;',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaCodo_F'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Flexion/Extension del Codo<br>&nbsp;',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaCodo_G'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Resist ala ext de muñeca y dedos<br>&nbsp;',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaCodo_H'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Signo del Abanico o de pitre<br>&nbsp;',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaCodo_I'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                width: 100,
                                                                height: 380,
                                                                labelWidth: 1,
                                                                labelSeparator: '',
                                                                labelStyle: 'color:blue;',
                                                                title: '<center>N/AN</center>',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Edema',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        width: 90,
                                                                        allowBlank: true,
                                                                        store: stNormal,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strExaFisOsteoCodo_1'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Quistes',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        width: 90,
                                                                        allowBlank: true,
                                                                        store: stNormal,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strExaFisOsteoCodo_2'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Desviaciones',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        width: 90,
                                                                        allowBlank: true,
                                                                        store: stNormal,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strExaFisOsteoCodo_3'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Codo de Golfista',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        width: 90,
                                                                        allowBlank: true,
                                                                        store: stNormal,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strExaFisOsteoCodo_4'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Codo de Tenistas',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        width: 90,
                                                                        allowBlank: true,
                                                                        store: stNormal,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strExaFisOsteoCodo_5'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Compresion del Cubital',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        width: 90,
                                                                        allowBlank: true,
                                                                        store: stNormal,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strExaFisOsteoCodo_6'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Flexion/Extension del Codo',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        width: 90,
                                                                        allowBlank: true,
                                                                        store: stNormal,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strExaFisOsteoCodo_7'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Resist ala ext de muñeca y dedos',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        width: 90,
                                                                        allowBlank: true,
                                                                        store: stNormal,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strExaFisOsteoCodo_8'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Signo del Abanico o de pitre',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        width: 90,
                                                                        allowBlank: true,
                                                                        store: stNormal,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strExaFisOsteoCodo_9'
                                                                    },
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                width: 500,
                                                                height: 380,
                                                                labelWidth: 1,
                                                                labelSeparator: '',
                                                                labelStyle: 'color:blue;',
                                                                title: '<center>HALLAZGO</center>',
                                                                items: [
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Edema',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        id: 'strExaFisOsteoCodoHallazgo_1'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Quistes',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        id: 'strExaFisOsteoCodoHallazgo_2'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Desviaciones',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        id: 'strExaFisOsteoCodoHallazgo_3'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Codo de Golfista',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        id: 'strExaFisOsteoCodoHallazgo_4'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Codo de Tenistas',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        id: 'strExaFisOsteoCodoHallazgo_5'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Compresion del Cubital',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        id: 'strExaFisOsteoCodoHallazgo_6'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Flexion/Extension del Codo',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        id: 'strExaFisOsteoCodoHallazgo_7'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Resist ala ext de muñeca y dedos',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        id: 'strExaFisOsteoCodoHallazgo_8'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Signo del Abanico o de pitre',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        id: 'strExaFisOsteoCodoHallazgo_9'
                                                                    },
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        layout: 'table',
                                                        layoutConfig: {
                                                            columns: 3
                                                        },
                                                        padding: 0,
                                                        title: '<center>MANO / MUÑECA</center>',
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                width: 250,
                                                                height: 480,
                                                                labelWidth: 220,
                                                                labelSeparator: '',
                                                                labelStyle: 'color:blue;',
                                                                title: '<center>&nbsp;</center>',
                                                                items: [
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Cicatrices<br>&nbsp;',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaMano_A'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Atrofias<br>&nbsp;',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaMano_B'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Gangliones<br>&nbsp;',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaMano_C'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Callosidades<br>&nbsp;',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaMano_D'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Tumefaccion Local<br>&nbsp;',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaMano_E'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Nudosidades Palpables<br>&nbsp;',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaMano_F'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Dolores Localizados<br>&nbsp;',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaMano_G'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Movilidad<br>&nbsp;',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaMano_H'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Test de Phallen<br>&nbsp;',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaMano_I'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Test de Tinnel<br>&nbsp;',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaMano_J'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Oponente del Pulgar<br>&nbsp;',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaMano_K'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Test de Finkelstein<br>&nbsp;',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaMano_L'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                width: 100,
                                                                height: 480,
                                                                labelWidth: 1,
                                                                labelSeparator: '',
                                                                labelStyle: 'color:blue;',
                                                                title: '<center>N/AN</center>',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Cicatrices',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        width: 90,
                                                                        allowBlank: true,
                                                                        store: stNormal,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strExaFisOsteoMano_1'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Atrofias',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        width: 90,
                                                                        allowBlank: true,
                                                                        store: stNormal,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strExaFisOsteoMano_2'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Gangliones',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        width: 90,
                                                                        allowBlank: true,
                                                                        store: stNormal,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strExaFisOsteoMano_3'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Callosidades',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        width: 90,
                                                                        allowBlank: true,
                                                                        store: stNormal,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strExaFisOsteoMano_4'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Tumefaccion Local',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        width: 90,
                                                                        allowBlank: true,
                                                                        store: stNormal,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strExaFisOsteoMano_5'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Nudosidades Palpables',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        width: 90,
                                                                        allowBlank: true,
                                                                        store: stNormal,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strExaFisOsteoMano_6'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Dolores Localizados',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        width: 90,
                                                                        allowBlank: true,
                                                                        store: stNormal,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strExaFisOsteoMano_7'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Movilidad',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        width: 90,
                                                                        allowBlank: true,
                                                                        store: stNormal,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strExaFisOsteoMano_8'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Test de Phallen',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        width: 90,
                                                                        allowBlank: true,
                                                                        store: stNormal,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strExaFisOsteoMano_9'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Test de Tinnel',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        width: 90,
                                                                        allowBlank: true,
                                                                        store: stNormal,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strExaFisOsteoMano_10'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Oponente del Pulgar',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        width: 90,
                                                                        allowBlank: true,
                                                                        store: stNormal,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strExaFisOsteoMano_11'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Test de Finkelstein',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        width: 90,
                                                                        allowBlank: true,
                                                                        store: stNormal,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strExaFisOsteoMano_12'
                                                                    },
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                width: 500,
                                                                height: 480,
                                                                labelWidth: 1,
                                                                labelSeparator: '',
                                                                labelStyle: 'color:blue;',
                                                                title: '<center>HALLAZGO</center>',
                                                                items: [
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Cicatrices',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        id: 'strExaFisOsteoManoHallazgo_1'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Atrofias',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        id: 'strExaFisOsteoManoHallazgo_2'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Gangliones',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        id: 'strExaFisOsteoManoHallazgo_3'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Callosidades',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        id: 'strExaFisOsteoManoHallazgo_4'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Tumefaccion Local',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        id: 'strExaFisOsteoManoHallazgo_5'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Nudosidades Palpables',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        id: 'strExaFisOsteoManoHallazgo_6'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Dolores Localizados',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        id: 'strExaFisOsteoManoHallazgo_7'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Movilidad',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        id: 'strExaFisOsteoManoHallazgo_8'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Test de Phallen',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        id: 'strExaFisOsteoManoHallazgo_9'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Test de Tinnel',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        id: 'strExaFisOsteoManoHallazgo_10'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Oponente del Pulgar',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        id: 'strExaFisOsteoManoHallazgo_11'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Test de Finkelstein',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        id: 'strExaFisOsteoManoHallazgo_12'
                                                                    },
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        layout: 'table',
                                                        layoutConfig: {
                                                            columns: 3
                                                        },
                                                        padding: 0,
                                                        title: '<center>CADERA Y MUSLO</center>',
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                width: 250,
                                                                height: 300,
                                                                labelWidth: 220,
                                                                labelSeparator: '',
                                                                labelStyle: 'color:blue;',
                                                                title: '<center>&nbsp;</center>',
                                                                items: [
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Dolor<br>&nbsp;',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaCadera_A'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Cadera<br>&nbsp;',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaCadera_B'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Incapacidad Funcional<br>&nbsp;',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaCadera_C'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Flexion / Extension<br>&nbsp;',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaCadera_D'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Abduccion / Adduccion<br>&nbsp;',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaCadera_E'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Rotacion Interna / Rotacion Externa<br>&nbsp;',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaCadera_F'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Retraccion<br>&nbsp;',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaCadera_G'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                width: 100,
                                                                height: 300,
                                                                labelWidth: 1,
                                                                labelSeparator: '',
                                                                labelStyle: 'color:blue;',
                                                                title: '<center>N/AN</center>',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Dolor',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        width: 90,
                                                                        allowBlank: true,
                                                                        store: stNormal,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strExaFisOsteoCadera_1'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Cadera',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        width: 90,
                                                                        allowBlank: true,
                                                                        store: stNormal,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strExaFisOsteoCadera_2'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Incapacidad Funcional',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        width: 90,
                                                                        allowBlank: true,
                                                                        store: stNormal,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strExaFisOsteoCadera_3'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Flexion / Extension',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        width: 90,
                                                                        allowBlank: true,
                                                                        store: stNormal,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strExaFisOsteoCadera_4'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Abduccion / Adduccion',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        width: 90,
                                                                        allowBlank: true,
                                                                        store: stNormal,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strExaFisOsteoCadera_5'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Rotacion Interna / Rotacion Externa',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        width: 90,
                                                                        allowBlank: true,
                                                                        store: stNormal,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strExaFisOsteoCadera_6'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Retraccion',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        width: 90,
                                                                        allowBlank: true,
                                                                        store: stNormal,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strExaFisOsteoCadera_7'
                                                                    },
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                width: 500,
                                                                height: 300,
                                                                labelWidth: 1,
                                                                labelSeparator: '',
                                                                labelStyle: 'color:blue;',
                                                                title: '<center>HALLAZGO</center>',
                                                                items: [
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Dolor',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        id: 'strExaFisOsteoCaderaHallazgo_1'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Cadera',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        id: 'strExaFisOsteoCaderaHallazgo_2'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Incapacidad Funcional',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        id: 'strExaFisOsteoCaderaHallazgo_3'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Flexion / Extension',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        id: 'strExaFisOsteoCaderaHallazgo_4'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Abduccion / Adduccion',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        id: 'strExaFisOsteoCaderaHallazgo_5'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Rotacion Interna / Rotacion Externa',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        id: 'strExaFisOsteoCaderaHallazgo_6'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Retraccion',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        id: 'strExaFisOsteoCaderaHallazgo_7'
                                                                    },
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        layout: 'table',
                                                        layoutConfig: {
                                                            columns: 3
                                                        },
                                                        padding: 0,
                                                        title: '<center>RODILLA</center>',
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                width: 250,
                                                                height: 250,
                                                                labelWidth: 220,
                                                                labelSeparator: '',
                                                                labelStyle: 'color:blue;',
                                                                title: '<center>&nbsp;</center>',
                                                                items: [
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Dolor<br>&nbsp;',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaRodilla_A'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Edema<br>&nbsp;',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaRodilla_B'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Ruidos<br>&nbsp;',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaRodilla_C'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Deformidad<br>&nbsp;',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaRodilla_D'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Flexion / Extension<br>&nbsp;',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaRodilla_E'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Retraccion<br>&nbsp;',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaRodilla_F'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                width: 100,
                                                                height: 250,
                                                                labelWidth: 1,
                                                                labelSeparator: '',
                                                                labelStyle: 'color:blue;',
                                                                title: '<center>N/AN</center>',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Dolor',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        width: 90,
                                                                        allowBlank: true,
                                                                        store: stNormal,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strExaFisOsteoRodilla_1'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Edema',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        width: 90,
                                                                        allowBlank: true,
                                                                        store: stNormal,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strExaFisOsteoRodilla_2'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Ruidos',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        width: 90,
                                                                        allowBlank: true,
                                                                        store: stNormal,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strExaFisOsteoRodilla_3'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Deformidad',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        width: 90,
                                                                        allowBlank: true,
                                                                        store: stNormal,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strExaFisOsteoRodilla_4'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Flexion / Extension',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        width: 90,
                                                                        allowBlank: true,
                                                                        store: stNormal,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strExaFisOsteoRodilla_5'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Retraccion',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        width: 90,
                                                                        allowBlank: true,
                                                                        store: stNormal,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strExaFisOsteoRodilla_6'
                                                                    },
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                width: 500,
                                                                height: 250,
                                                                labelWidth: 1,
                                                                labelSeparator: '',
                                                                labelStyle: 'color:blue;',
                                                                title: '<center>HALLAZGO</center>',
                                                                items: [
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Dolor',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        id: 'strExaFisOsteoRodillaHallazgo_1'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Edema',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        id: 'strExaFisOsteoRodillaHallazgo_2'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Ruidos',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        id: 'strExaFisOsteoRodillaHallazgo_3'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Deformidad',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        id: 'strExaFisOsteoRodillaHallazgo_4'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Flexion / Extension',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        id: 'strExaFisOsteoRodillaHallazgo_5'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Retraccion',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        id: 'strExaFisOsteoRodillaHallazgo_6'
                                                                    },
                                                                ]
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'Descripción y ampliación de hallazgos',
                                                layout: 'table',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'Descripción y ampliación de hallazgos',
                                                        name: 'Descripción y ampliación de hallazgos',
                                                        height: 100,
                                                        allowBlank: false,
                                                        id: 'memDescripciónyHallazgos'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'DIAGNOSTICO EXAMEN OSTEOMUSCULAR',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                labelSeparator: '',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        fieldLabel: 'Diagnostico a Nivel Columna Vertebral',
                                                        name: 'Diagnostico a Nivel Columna Vertebral',
                                                        anchor: '100%',
                                                        allowBlank: true,
                                                        id: 'strDxColumnaVertebral'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        name: 'Diagnostico a Nivel de Nuca y Miembro Superior',
                                                        fieldLabel: 'Diagnostico a Nivel de Nuca y Miembro Superior',
                                                        anchor: '100%',
                                                        allowBlank: true,
                                                        id: 'strDxNucayMiembroSuperior'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        name: 'Diagnostico a Nivel Miembro Inferior',
                                                        fieldLabel: 'Diagnostico a Nivel Miembro Inferior',
                                                        anchor: '100%',
                                                        allowBlank: true,
                                                        id: 'strDxMiembroInferior'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'Diagnosticos de la Atencion',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: false,
                                                                fieldLabel: 'Diagnostico Principal',
                                                                id: 'sysDiagPpalHC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request({
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                        Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    },
                                                                    blur: function(t){
                                                                        if(Ext.getCmp('sysDiagPpalHCNom').getValue()==null || Ext.getCmp('sysDiagPpalHCNom').getValue()== "")
                                                                        {
                                                                            if (Ext.getCmp('sysDiagPpalHC').getValue() != "" && Ext.getCmp('sysDiagPpalHC').getValue() != null && Ext.getCmp('sysDiagPpalHC').getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && Ext.getCmp('sysDiagPpalHC').getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && Ext.getCmp('sysDiagPpalHC').getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request({
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: Ext.getCmp('sysDiagPpalHC').getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                        Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagPpalHCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Principal',
                                                                id: 'btnSearchDiagPpalHC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagPpalHC','sysDiagPpalHCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.1',
                                                                id: 'sysDiagRel1HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    },
                                                                    blur: function(t){
                                                                        if (Ext.getCmp('sysDiagRel1HCNom').getValue == null ||  Ext.getCmp('sysDiagRel1HCNom').getValue() == "")
                                                                        {
                                                                            if (Ext.getCmp('sysDiagRel1HC').getValue() != "" && Ext.getCmp('sysDiagRel1HC').getValue() != null && Ext.getCmp('sysDiagRel1HC').getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && Ext.getCmp('sysDiagRel1HC').getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && Ext.getCmp('sysDiagRel1HC').getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: Ext.getCmp('sysDiagRel1HC').getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel1HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado1',
                                                                id: 'btnSearchDiagRel1HC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel1HC','sysDiagRel1HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.2',
                                                                id: 'sysDiagRel2HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    },
                                                                    blur: function(t){
                                                                        if (Ext.getCmp('sysDiagRel2HCNom').getValue == null || Ext.getCmp('sysDiagRel2HCNom').getValue() == "")
                                                                        {
                                                                            if (Ext.getCmp('sysDiagRel2HC').getValue() != "" && Ext.getCmp('sysDiagRel2HC').getValue() != null && Ext.getCmp('sysDiagRel2HC').getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && Ext.getCmp('sysDiagRel2HC').getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && Ext.getCmp('sysDiagRel2HC').getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: Ext.getCmp('sysDiagRel2HC').getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel2HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado2',
                                                                id: 'btnSearchDiagRel2HC1',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel2HC','sysDiagRel2HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.3',
                                                                id: 'sysDiagRel3HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    },
                                                                    blur: function(t){
                                                                        if (Ext.getCmp('sysDiagRel3HCNom').getValue == null || Ext.getCmp('sysDiagRel3HCNom').getValue() == "")
                                                                        {
                                                                            if (Ext.getCmp('sysDiagRel3HC').getValue() != "" && Ext.getCmp('sysDiagRel3HC').getValue() != null && Ext.getCmp('sysDiagRel3HC').getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && Ext.getCmp('sysDiagRel3HC').getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && Ext.getCmp('sysDiagRel3HC').getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: Ext.getCmp('sysDiagRel3HC').getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel3HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado3',
                                                                id: 'btnSearchDiagRel3HC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel3HC','sysDiagRel3HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Tipo de Diagnostico',
                                                        width:750,
                                                        name: 'Tipo de Diagnostico',
                                                        allowBlank: false,
                                                        store: 'StoreTipoDiagnostico',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        id: 'sysTipoDiagosticoHC'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Finalidad Consulta',
                                                        width:750,
                                                        name: 'Finalidad Consulta',
                                                        allowBlank: false,
                                                        store: 'StoreFinalidadConsulta',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 10,
                                                        id: 'sysFinalidadConsultaHC'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Causa Externa',
                                                        width:750,
                                                        name: 'Causa Externa',
                                                        allowBlank: false,
                                                        store: 'StoreCausaExterna',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 13,
                                                        id: 'sysCausaExternaHC'
                                                    }
                                                ]
                                            }
                                            
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Medicamentos',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaMedicamentos',
                                items: [
                                    xSolMX
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Servicios',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaServicios',
                                items: [
                                    xSolEXA
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Remisiones',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaRemisiones',
                                items: [
                                    xSolREM
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud NO POS',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaNOPOS',
                                items: [
                                    xSolNOPOS
                                ]
                            }
                            /*,
                            {
                                xtype: 'panel',
                                title: 'Consentimientos Informados',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaConsentimientos',
                                items: [
                                ]
                            },*/
                        ]
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btnSalirEvolucion',
                            listeners:{
                                click : function(){
                                    if (parseInt(Ext.getCmp('sysYaGuardoHC').getValue()) === 1)
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn === "yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Usted No ha Guardado la Evolución del Paciente y Se Perdera la Información, Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn === "yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                },
                tbar:{
                    items: [
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Ver Historia Clínica',
                            iconCls: 'btnVerHC',
                            id: 'btnVerHC',
                            listeners:{
                                click : function(){
                                    var cmpResumenHC = new winFrmVerHistorialHC({
                                        renderTo: Ext.getBody()
                                    });
                                    Ext.getCmp('winViewEvolucionHC').title = "PACIENTE: " + Ext.getCmp('sysPacienteHC').getValue();
                                    Ext.getCmp('gridHistorialEvoluciones').store.load({
                                        params: {
                                            pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                                            pPaciente: Ext.getCmp('sysIdPacienteHC').getValue()
                                        }
                                    });
                                    cmpResumenHC.show();
                                }
                            }
                        },
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar Evolución',
                            iconCls: 'btnGuardar',
                            id: 'btnGuardarEvolucion',
                            listeners:{
                                click : function(){
                                    if (parseInt(Ext.getCmp('sysYaGuardoHC').getValue()) === 0)
                                    {
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Guardar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn === "yes")
                                                {
                                                    fnGuardarRegistrosMedicinaGeneral();
                                                }
                                            }
                                        });
                                    }else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Modificar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn === "yes")
                                                {
                                                    fnModificarRegistrosMedicinaGeneral();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                }
            }
        ];
        winHCEvaluacionOsteoMuscularUi.superclass.initComponent.call(this);
    }
});

function fnGuardarRegistrosMedicinaGeneral(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc2013.php',
            params:{
                task: 'guardar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pidPlantillaHC : Ext.getCmp('sysIdCodPlantillaHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue(),
                pGuardarSignos: "NO"
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function fnModificarRegistrosMedicinaGeneral(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc2013.php',
            params:{
                task: 'modificar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue(),
                pGuardarSignos: "NO"
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}
