/*
* @category    Formulario Salud Ocupacional 
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winHCSaludOcupacionalUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic ©  .:: Valoración Medica - Salud Ocupacional ::.',
    width: 990,
    height: 636,
    closable: false,
    resizable: false,
    draggable: false,
    modal: true,
    id: 'winHC',
    initComponent: function() {
        
        tmpmx = objMX;
        tmpmxadd = objMXADD;
        tmpexa = objEXA;
        tmprem = objREM;
        myPaciente = 0;
        myCAS = 0;

        try {
            var campo = Ext.getCmp('sysPacientePlantillaHC');
            if ( campo !== null ) {
                myPaciente = Ext.getCmp('sysPacientePlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myPaciente === 0){
            try {
                var campo1 = Ext.getCmp('sysIdPacienteHC');
                if ( campo1 !== null ) {
                    myPaciente = Ext.getCmp('sysIdPacienteHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myPaciente === 0){
            try {
                var campo5 = Ext.getCmp('sysPacienteRefHC');
                if ( campo5 !== null ) {
                    myPaciente = Ext.getCmp('sysPacienteRefHC').getValue();
                }
            }catch(ex){
            }
        }
        try {
            var campo2 = Ext.getCmp('sysCASPlantillaHC');
            if ( campo2 !== null ) {
                myCAS = Ext.getCmp('sysCASPlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myCAS === 0){
            try {
                var campo3 = Ext.getCmp('sysCASHC');
                if ( campo3 !== null ) {
                    myCAS = Ext.getCmp('sysCASHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myCAS === 0){
            try {
                var campo4 = Ext.getCmp('sysCASRefHC');
                if ( campo4 !== null ) {
                    myCAS = Ext.getCmp('sysCASRefHC').getValue();
                }
            }catch(ex){
            }
        }
        if (objMX !== "NA"){
            var xSolMX = eval(objMX);
            Ext.getCmp('gridMedicamentosHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }
        else{
            var xSolMX = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        if (objEXA !== "NA"){
            var xSolEXA = eval(objEXA);
            Ext.getCmp('gridExamenesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }else{
            var xSolEXA = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        if (objREM !== "NA"){
            var xSolREM = eval(objREM);
            Ext.getCmp('gridRemisionesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }else{
            var xSolREM = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
                
        function DescripcionGrid(val, x, store){
            mostrarHC = '<table><tr><td style="padding: 1px;">';
            mostrarHC += val;
            mostrarHC += '</td></tr></table>';
            return mostrarHC;
        }
        
        var stGridHistorialLaboral = new StoreGridHistorialLaboral();
        stGridHistorialLaboral.load({
            params: {
                pPaciente: wPaciente,
                IdNew: '-1'
            }
        });
        
        var dataEstratoSocioeconomico = [
            ['1'],
            ['2'],
            ['3'],
            ['4'],
            ['5'],
            ['6']
        ];
        var stEstratoSocioeconomico = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stEstratoSocioeconomico.loadData(dataEstratoSocioeconomico);
        
        var dataResLaboratorios = [
            ['NORMAL'],
            ['ANORMAL'],
            ['NO SE REALIZO']
        ];
        var stResLaboratorios = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stResLaboratorios.loadData(dataResLaboratorios);

        AnexoEquilibrio = new fsValoracionEquilibrioUi();
        
        this.items = [
            {
                xtype: 'panel',
                layout: 'form',
                frame: true,
                anchor: '100%',
                id: 'panelHC',
                padding: 0,
                border: false,
                height: 610,
                autoScroll: true,
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Actividad',
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        value: 0,
                        id: 'sysYaGuardoHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptMx'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptExa'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptRem'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Actividad',
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        id: 'sysActividadHC',
                        value: 'VALORACION MEDICA',
                        name: 'PLANTILLA'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Profesional',
                        id: 'sysProfesionalHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Usuario',
                        id: 'sysEmpresaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysIPSHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysFechaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysAperturaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysPlantillaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysIdClienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysIdPlanHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysIdSubPlanHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysIdContratoHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Usuario',
                        id: 'sysUsuarioHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Paciente',
                        id: 'sysIdPacienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'CAS',
                        id: 'sysCASHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'ConsecutivoDetalle',
                        id: 'sysConsecutivoDetalleHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Cliente',
                        id: 'sysClienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Profesional',
                        id: 'sysProfesionalAgendaHC'
                    },
                    {
                        xtype: 'hidden',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysHoraHC'
                    },
                    {
                        xtype: 'hidden',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysLegalizaHC'
                    },
                    {
                        xtype: 'hidden',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysIdCodPlantillaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Edad',
                        id: 'sysEdadPacHC'
                    },
                    {
                        xtype: 'tabpanel',
                        anchor: '99%',
                        //autoHeight: true,
                        height: 560,
                        border: false,
                        ref: 'fTabPanel',
                        id: 'fTabPanel',
                        activeTab: 0,
                        items: [
                            {
                                xtype: 'panel',
                                title: 'HISTORIA CLINICA OCUPACIONAL',
                                autoScroll: true,
                                frame: true,
                                border: false,
                                anchor: '100%',
                                id: 'fichaHCOcupacional',
                                layout: 'form',
                                tbar: {
                                    xtype: 'toolbar',
                                    items: [
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Ver Historia Clínica',
                                            iconCls: 'btnVerHC',
                                            id: 'btnVerHC',
                                            listeners:{
                                                click : function(){
                                                    var cmpResumenHC = new winFrmVerHistorialHC({
                                                        renderTo: Ext.getBody()
                                                    });
                                                    Ext.getCmp('winViewEvolucionHC').title = "PACIENTE: " + Ext.getCmp('sysPacienteHC').getValue();
                                                    Ext.getCmp('gridHistorialEvoluciones').store.load({
                                                        params: {
                                                            pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                                                            pPaciente: Ext.getCmp('sysIdPacienteHC').getValue()
                                                        }
                                                    });
                                                    cmpResumenHC.show();
                                                }
                                            }
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Imprimir Historia Clinica',
                                            iconCls: 'btnImprimir',
                                            listeners: {
                                                click: function(){
                                                    if (parseInt(Ext.getCmp('sysYaGuardoHC').getValue()) === 1){
                                                        window.open ("../../controlador/asistencial/imprimirhc.php?pEmpresa=" + ID_EMPRESA + "&pIPS=" + ID_IPS + "&pPaciente=" + Ext.getCmp('sysIdPacienteHC').getValue() + "&pConsecutivoDetalle=" + Ext.getCmp('sysConsecutivoDetalleHC').getValue(),"Historia Clinica");
                                                    }else{
                                                        Ext.MessageBox.show({
                                                            title: NOM_APLICACION,
                                                            msg: 'Debe Guardar Primero la Evolucion.',
                                                            buttons: Ext.MessageBox.OK,
                                                            icon: Ext.MessageBox.ERROR
                                                        });
                                                    }
                                                }
                                            }
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Certificado Medico Laboral',
                                            iconCls: 'btnImprimir',
                                            listeners: {
                                                click: function(){
                                                    if (parseInt(Ext.getCmp('sysYaGuardoHC').getValue()) === 1){
                                                        window.open ("../../controlador/asistencial/saludocupa001/printsaludocupa_certificado1.php?pEmpresa=" + ID_EMPRESA + "&pIPS=" + ID_IPS + "&pPaciente=" + Ext.getCmp('sysIdPacienteHC').getValue() + "&pConsecutivoDetalle=" + Ext.getCmp('sysConsecutivoDetalleHC').getValue(),"Certificado");
                                                    }else{
                                                        Ext.MessageBox.show({
                                                            title: NOM_APLICACION,
                                                            msg: 'Debe Guardar Primero la Evolucion.',
                                                            buttons: Ext.MessageBox.OK,
                                                            icon: Ext.MessageBox.ERROR
                                                        });
                                                    }
                                                }
                                            }
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'tbfill'
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Guardar Historia',
                                            iconCls: 'btnGuardar',
                                            id: 'btnGuardarEvolucion',
                                            listeners:{
                                                click : function(){
                                                    if (parseInt(Ext.getCmp('sysYaGuardoHC').getValue()) === 0){
                                                        Ext.Msg.show({
                                                            title: 'eOfiClinic',
                                                            msg: 'Esta seguro que desea Guardar la evolución?',
                                                            buttons: Ext.Msg.YESNO,
                                                            icon: Ext.Msg.QUESTION,
                                                            fn: function(btn)
                                                            {
                                                                if(btn === "yes")
                                                                {
                                                                    fnGuardarRegistrosMedicinaLaboral();
                                                                }
                                                            }
                                                        });
                                                    }else{
                                                        Ext.Msg.show({
                                                            title: 'eOfiClinic',
                                                            msg: 'Esta seguro que desea Modificar la evolución?',
                                                            buttons: Ext.Msg.YESNO,
                                                            icon: Ext.Msg.QUESTION,
                                                            fn: function(btn)
                                                            {
                                                                if(btn === "yes")
                                                                {
                                                                    fnModificarRegistrosMedicinaLaboral();
                                                                }
                                                            }
                                                        });
                                                    }
                                                }
                                            }
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        }
                                    ]
                                },
                                items: [
                                    {
                                        xtype: 'form',
                                        frame: true,
                                        anchor: '100%',
                                        id: 'frmHC',
                                        padding: 0,
                                        border: false,
                                        autoScroll: true,
                                        autoHeight: true,
                                        style: 'background:transparent;',
                                        items: [ // UNO
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        fieldLabel: 'Acompañante',
                                                        width: 230,
                                                        allowBlank: true,
                                                        value: 'ASISTE SOLO',
                                                        id: 'str001AcompananteNombrePacSO'
                                                    },
                                                    {
                                                        html: 'Parentesco'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        width: 200,
                                                        allowBlank: true,
                                                        id: 'str002AcompananteParentescoPacSO'
                                                    },
                                                    {
                                                        html: 'Telefono'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        width: 140,
                                                        allowBlank: true,
                                                        id: 'str003AcompanantePacTelefonoSO'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'IDENTIFICACION DEL TRABAJADOR',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '99%',
                                                autoHeight: true,
                                                id: 'fs0',
                                                labelWidth: 170,
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        allowBlank: true,
                                                        readOnly: true,
                                                        fieldLabel: 'Paciente',
                                                        id: 'sysPacienteHC'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 100,
                                                                allowBlank: true,
                                                                readOnly: true,
                                                                fieldLabel: 'Genero',
                                                                id: 'sysGeneroHC'
                                                            },
                                                            {
                                                                html: 'Fecha Nac:'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 100,
                                                                allowBlank: true,
                                                                readOnly: true,
                                                                id: 'sysFechaNac'
                                                            },
                                                            {
                                                                html: 'Edad:'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 390,
                                                                allowBlank: true,
                                                                readOnly: true,
                                                                id: 'sysEdadHC'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        fieldLabel: 'Estado Civil - Nivel Academico',
                                                        anchor: '100%',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                width: 340,
                                                                store: 'StoreEstadoCivil',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                emptyText: 'Estado Civil',
                                                                allowBlank: true,
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                triggerAction: 'all',
                                                                id: 'str004EstadoCivilSO'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 350,
                                                                store: 'StoreEscolaridad',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                emptyText: 'Nivel Academico',
                                                                allowBlank: true,
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                triggerAction: 'all',
                                                                id: 'str005NivelAcademicoSO'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        anchor: '100%',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                fieldLabel: 'Numero de Personas a Cargo',
                                                                allowBlank: true,
                                                                value: 0,
                                                                width: 100,
                                                                id: 'str006NroPersonasCargoSO'
                                                            },
                                                            {
                                                                html: 'Estrato Socioeconomico:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 120,
                                                                store: stEstratoSocioeconomico,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                emptyText: 'Seleccione...',
                                                                allowBlank: true,
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                triggerAction: 'all',
                                                                id: 'str007EstratoSocioeconomico'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        fieldLabel: 'Cargo que Aspira',
                                                        anchor: '100%',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                allowBlank: true,
                                                                width: 300,
                                                                id: 'str008CargoAspiraSO'
                                                            },
                                                            {
                                                                html: 'Empresa:'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 335,
                                                                allowBlank: true,
                                                                id: 'str009EmpresaAspiraSO'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        fieldLabel: 'Cargo Actual',
                                                        anchor: '100%',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                allowBlank: true,
                                                                width: 300,
                                                                id: 'str010CargoEmpresaActualSO'
                                                            },
                                                            {
                                                                html: 'Empresa:'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 175,
                                                                allowBlank: true,
                                                                id: 'str011EmpresaActualSO'
                                                            },
                                                            {
                                                                html: 'Sede:'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 110,
                                                                allowBlank: true,
                                                                id: 'str012NomSedeEmpresaActualSO'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        fieldLabel: 'Antigudad',
                                                        anchor: '100%',
                                                        items: [
                                                            {
                                                                html: 'En el Cargo Actual:'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                allowBlank: true,
                                                                width: 100,
                                                                emptyText: 'Años',
                                                                id: 'str013AntiguedadCargoActualSO'
                                                            },
                                                            {
                                                                html: 'En el Oficio:'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                allowBlank: true,
                                                                width: 100,
                                                                emptyText: 'Años',
                                                                id: 'str014AntiguedadOficioSO'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'hidden',
                                                        fieldLabel: 'Empresa',
                                                        name: 'EMPRESA',
                                                        anchor: "100%",
                                                        allowBlank: true,
                                                        id: 'str015EmpresaSaludOcupacional'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Tipo Examen',
                                                                width: 100,
                                                                listWidth: 150,
                                                                name: 'TIPO EXAMEN',
                                                                allowBlank: false,
                                                                store: 'StoreTipoExamenSaludOcupacional',
                                                                forceSelection: true,
                                                                triggerAction: 'all',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                mode: 'local',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                emptyText: 'Seleccione....',
                                                                submitValue: true,
                                                                id: 'str016TipoExamen',
                                                                listeners:{
                                                                    scope: this,
                                                                    select: function(cmb, rec, idx) {
                                                                        if(cmb.getValue() !== "Ingreso" || cmb.getValue() !== "Otro"){
                                                                            Ext.getCmp('str011EmpresaActualSO').allowBlank = false;
                                                                            Ext.getCmp('str008CargoAspiraSO').allowBlank = true;
                                                                            Ext.getCmp('str009EmpresaAspiraSO').allowBlank = true;
                                                                        }else{
                                                                            Ext.getCmp('str011EmpresaActualSO').allowBlank = true;
                                                                            Ext.getCmp('str008CargoAspiraSO').allowBlank = false;
                                                                            Ext.getCmp('str009EmpresaAspiraSO').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html: 'EPS:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 180,
                                                                listWidth: 500,
                                                                name: 'EPS',
                                                                allowBlank: false,
                                                                store: 'StoreSGSSEPS',
                                                                forceSelection: true,
                                                                triggerAction: 'all',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                mode: 'local',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                emptyText: 'Seleccione....',
                                                                value: 'NO APLICA',
                                                                id: 'str017EPS'
                                                            },
                                                            {
                                                                html: 'PENSION:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 145,
                                                                listWidth: 500,
                                                                name: 'PENSION',
                                                                allowBlank: false,
                                                                store: 'StoreSGSSPENSION',
                                                                forceSelection: true,
                                                                triggerAction: 'all',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                mode: 'local',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                emptyText: 'Seleccione....',
                                                                value: 'NO APLICA',
                                                                id: 'str018PENSION'
                                                            },
                                                            {
                                                                html: 'ARL:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 140,
                                                                listWidth: 500,
                                                                name: 'ARP',
                                                                allowBlank: false,
                                                                store: 'StoreSGSSARP',
                                                                forceSelection: true,
                                                                triggerAction: 'all',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                mode: 'local',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                emptyText: 'Seleccione....',
                                                                value: 'DESCONOCIDO',
                                                                id: 'str019ARP'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        fieldLabel: 'Tipo Vinculación',
                                                        anchor: '100%',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                width: 315,
                                                                allowBlank: false,
                                                                store: 'StoreTipoVinculacionContrato',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                emptyText: 'Seleccione....',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                id: 'str020TipoVinculacionContratoSO'
                                                            },
                                                            {
                                                                html: 'Turno:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 315,
                                                                allowBlank: false,
                                                                store: 'StoreTurnoLaboral',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                emptyText: 'Seleccione....',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                id: 'str021TurnoSO'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'MOTIVO DE CONSULTA',
                                                layout: 'table',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '99%',
                                                autoHeight: true,
                                                id: 'fs2',
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        width: 860,
                                                        name: 'MOTIVO DE CONSULTA',
                                                        height: 50,
                                                        grow: true,
                                                        minGrow: 50,
                                                        allowBlank: false,
                                                        id: 'mem022MotivoConsulta'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'ENFERMEDAD ACTUAL',
                                                layout: 'table',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '99%',
                                                autoHeight: true,
                                                id: 'fs2_1',
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        width: 850,
                                                        name: 'ENFERMEDAD ACTUAL',
                                                        height: 50,
                                                        grow: true,
                                                        minGrow: 50,
                                                        allowBlank: false,
                                                        id: 'mem023EnfermedadActual'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'ANTECEDENTES FAMILIARES',
                                                anchor: '100%',
                                                autoHeight: true,
                                                layout: 'form',
                                                collapsible: true,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        anchor: '100%',
                                                        fieldLabel: 'HTA',
                                                        items: [
                                                            {
                                                                html: 'Padre:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'str024AFHTAPadSO'
                                                            },
                                                            {
                                                                html: 'Madre:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'str025AFHTAMadSO'
                                                            },
                                                            {
                                                                html: 'Hnos:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'str026AFHTAHnoSO'
                                                            },
                                                            {
                                                                html: 'Tio(M):'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'str027AFHTATioMSO'
                                                            },
                                                            {
                                                                html: 'Tio(P):'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'str028AFHTATioPSO'
                                                            },
                                                            {
                                                                html: 'Abu(M):'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'str029AFHTAAbuMSO'
                                                            },
                                                            {
                                                                html: 'Abu(P):'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'str030AFHTAAbuPSO'
                                                            }
                                                        ]
                                                    }, 
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        anchor: '100%',
                                                        fieldLabel: 'Enf. Coronaria',
                                                        items: [
                                                            {
                                                                html: 'Padre:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'str031AFEnfCoronariaPadSO'
                                                            },
                                                            {
                                                                html: 'Madre:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'str032AFEnfCoronariaMadSO'
                                                            },
                                                            {
                                                                html: 'Hnos:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'str033AFEnfCoronariaHnoSO'
                                                            },
                                                            {
                                                                html: 'Tio(M):'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'str034AFEnfCoronariaTioMSO'
                                                            },
                                                            {
                                                                html: 'Tio(P):'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'str035AFEnfCoronariaTioPSO'
                                                            },
                                                            {
                                                                html: 'Abu(M):'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'str036AFEnfCoronariaAbuMSO'
                                                            },
                                                            {
                                                                html: 'Abu(P):'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'str037AFEnfCoronariaAbuPSO'
                                                            }
                                                        ]
                                                    }, 
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        anchor: '100%',
                                                        fieldLabel: 'ACV',
                                                        items: [
                                                            {
                                                                html: 'Padre:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'str038AFACVPadSO'
                                                            },
                                                            {
                                                                html: 'Madre:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'str039AFACVMadSO'
                                                            },
                                                            {
                                                                html: 'Hnos:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'str040AFACVHnoSO'
                                                            },
                                                            {
                                                                html: 'Tio(M):'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'str041AFACVTioMSO'
                                                            },
                                                            {
                                                                html: 'Tio(P):'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'str042AFACVTioPSO'
                                                            },
                                                            {
                                                                html: 'Abu(M):'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'str043AFACVAbuMSO'
                                                            },
                                                            {
                                                                html: 'Abu(P):'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'str044AFACVAbuPSO'
                                                            }
                                                        ]
                                                    }, 
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        anchor: '100%',
                                                        fieldLabel: 'Diabetes',
                                                        items: [
                                                            {
                                                                html: 'Padre:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'str045AFDiabetesPadSO'
                                                            },
                                                            {
                                                                html: 'Madre:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'str046AFDiabetesMadSO'
                                                            },
                                                            {
                                                                html: 'Hnos:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'str047AFDiabetesHnoSO'
                                                            },
                                                            {
                                                                html: 'Tio(M):'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'str048AFDiabetesTioMSO'
                                                            },
                                                            {
                                                                html: 'Tio(P):'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'str049AFDiabetesTioPSO'
                                                            },
                                                            {
                                                                html: 'Abu(M):'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'str050AFDiabetesAbuMSO'
                                                            },
                                                            {
                                                                html: 'Abu(P):'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'str051AFDiabetesAbuPSO'
                                                            }
                                                        ]
                                                    }, 
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        anchor: '100%',
                                                        fieldLabel: 'Enf. Mental',
                                                        items: [
                                                            {
                                                                html: 'Padre:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'str052AFEnfMentalPadSO'
                                                            },
                                                            {
                                                                html: 'Madre:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'str053AFEnfMentalMadSO'
                                                            },
                                                            {
                                                                html: 'Hnos:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'str054AFEnfMentalHnoSO'
                                                            },
                                                            {
                                                                html: 'Tio(M):'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'str055AFEnfMentalTioMSO'
                                                            },
                                                            {
                                                                html: 'Tio(P):'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'str056AFEnfMentalTioPSO'
                                                            },
                                                            {
                                                                html: 'Abu(M):'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'str057AFEnfMentalAbuMSO'
                                                            },
                                                            {
                                                                html: 'Abu(P):'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'str058AFEnfMentalAbuPSO'
                                                            }
                                                        ]
                                                    }, 
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        anchor: '100%',
                                                        fieldLabel: 'Síndrome Convulsivo',
                                                        items: [
                                                            {
                                                                html: 'Padre:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'str059AFSindromeConvulsivoPadSO'
                                                            },
                                                            {
                                                                html: 'Madre:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'str060AFSindromeConvulsivoMadSO'
                                                            },
                                                            {
                                                                html: 'Hnos:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'str061AFSindromeConvulsivoHnoSO'
                                                            },
                                                            {
                                                                html: 'Tio(M):'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'str062AFSindromeConvulsivoTioMSO'
                                                            },
                                                            {
                                                                html: 'Tio(P):'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'str063AFSindromeConvulsivoTioPSO'
                                                            },
                                                            {
                                                                html: 'Abu(M):'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'str064AFSindromeConvulsivoAbuMSO'
                                                            },
                                                            {
                                                                html: 'Abu(P):'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'str065AFSindromeConvulsivoAbuPSO'
                                                            }
                                                        ]
                                                    }, 
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        anchor: '100%',
                                                        fieldLabel: 'Alcoholismo Drogadicción',
                                                        items: [
                                                            {
                                                                html: 'Padre:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'str066AFAlcoholDrogaPadSO'
                                                            },
                                                            {
                                                                html: 'Madre:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'str067AFAlcoholDrogaMadSO'
                                                            },
                                                            {
                                                                html: 'Hnos:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'str068AFAlcoholDrogaHnoSO'
                                                            },
                                                            {
                                                                html: 'Tio(M):'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'str069AFAlcoholDrogaTioMSO'
                                                            },
                                                            {
                                                                html: 'Tio(P):'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'str070AFAlcoholDrogaTioPSO'
                                                            },
                                                            {
                                                                html: 'Abu(M):'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'str071AFAlcoholDrogaAbuMSO'
                                                            },
                                                            {
                                                                html: 'Abu(P):'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'str072AFAlcoholDrogaAbuPSO'
                                                            }
                                                        ]
                                                    }, 
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        anchor: '100%',
                                                        fieldLabel: 'Cáncer',
                                                        items: [
                                                            {
                                                                html: 'Padre:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'str073AFCAPadSO'
                                                            },
                                                            {
                                                                html: 'Madre:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'str074AFCAMadSO'
                                                            },
                                                            {
                                                                html: 'Hnos:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'str075AFCAHnoSO'
                                                            },
                                                            {
                                                                html: 'Tio(M):'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'str076AFCATioMSO'
                                                            },
                                                            {
                                                                html: 'Tio(P):'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'str077AFCATioPSO'
                                                            },
                                                            {
                                                                html: 'Abu(M):'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'str078AFCAAbuMSO'
                                                            },
                                                            {
                                                                html: 'Abu(P):'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'str079AFCAAbuPSO'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        fieldLabel: 'Observaciones',
                                                        name: 'Observaciones',
                                                        height: 50,     
                                                        grow: true,
                                                        minGrow: 50,
                                                        allowBlank: false,
                                                        value: 'NINGUNO',
                                                        id: 'mem080AntecedentesFamiliaresSO'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'ANTECEDENTES PERSONALES',
                                                anchor: '100%',
                                                autoHeight: true,
                                                layout: 'form',
                                                collapsible: true,
                                                items: [
                                                    {
                                                        xtype: 'panel',
                                                        anchor: '100%',
                                                        autoHeight: true,
                                                        layout: 'table',
                                                        layoutConfig: {
                                                            columns: 6
                                                        },
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                anchor: '50%',
                                                                height: 150,
                                                                layout: 'form',
                                                                padding: 10,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        fieldLabel: 'Infecciones',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str081APInfeccionesSO'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        fieldLabel: 'Patológicos',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str082APPatologicosSO'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        fieldLabel: 'Tóxicos',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str083APToxicosSO'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        fieldLabel: 'Alérgicos',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str084APAlergicosSO'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        fieldLabel: 'Traumáticos',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str085APTraumaticosSO'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                anchor: '50%',
                                                                height: 150,
                                                                layout: 'form',
                                                                padding: 10,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        fieldLabel: 'Quirúrgicos',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str086APQuirurgicosSO'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        fieldLabel: 'Inmunológicos',
                                                                        allowBlank: false,
                                                                        store: 'StoreCompletasIncompletas',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "COMPLETAS",
                                                                        id: 'str087APInmunologicosSO'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        fieldLabel: 'Hospitalarios',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str088APHospitalariosSO'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        fieldLabel: 'Enfermedades Psiquiátricas',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str089APEnfPsiquiatraSO'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 430,
                                                                height: 150,
                                                                colspan: 4,
                                                                layout: 'table',
                                                                items: [
                                                                    {
                                                                        xtype: 'panel',
                                                                        layout: 'form',
                                                                        labelAlign: 'top',
                                                                        items: [
                                                                            {
                                                                                xtype: 'textarea',
                                                                                width: 420,
                                                                                fieldLabel: 'OTROS',
                                                                                name: 'ANTECEDENTES PERSONALES',
                                                                                height: 60,         
                                                                                allowBlank: false,
                                                                                value: 'NINGUNO',
                                                                                id: 'mem090AntecedentesPersonales'
                                                                            }
                                                                        ]
                                                                    }
                                                                    
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'GINECO–OBSTÉTRICOS',
                                                        anchor: '100%',
                                                        autoHeight: true,
                                                        layout: 'form',
                                                        collapsible: true,
                                                        id: 'fsAPGINECO',
                                                        items: [
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                fieldLabel: 'Menarquia',
                                                                anchor: '100%',
                                                                items: [
                                                                    {
                                                                        xtype: 'textfield',
                                                                        allowBlank: true,
                                                                        width: 120,
                                                                        id: 'str091APGinecoMenarquiaSO'
                                                                    },
                                                                    {
                                                                        html: 'Ciclos:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 140,
                                                                        store: 'StoreCiclosMestruales',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        allowBlank: true,
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        triggerAction: 'all',
                                                                        id: 'str092APGinecoCiclosSO'
                                                                    },
                                                                    {
                                                                        html: 'FUM:'
                                                                    },
                                                                    {
                                                                        xtype: 'datefield',
                                                                        width: 120,
                                                                        allowBlank: true,
                                                                        style: 'text-align:center;',
                                                                        emptyText: '(dia/mes/año) ',
                                                                        id: 'fec093APGinecoFUMSO'
                                                                    },
                                                                    {
                                                                        html: 'FUP:'
                                                                    },
                                                                    {
                                                                        xtype: 'datefield',
                                                                        width: 120,
                                                                        allowBlank: true,
                                                                        style: 'text-align:center;',
                                                                        emptyText: '(dia/mes/año) ',
                                                                        id: 'fec094APGinecoFUPSO'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                fieldLabel: '',
                                                                anchor: '100%',
                                                                items: [
                                                                    {
                                                                        html: 'G:'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        allowBlank: true,
                                                                        width: 35,
                                                                        id: 'str095APGinecoNumGSO'
                                                                    },
                                                                    {
                                                                        html: 'P:'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        allowBlank: true,
                                                                        width: 35,
                                                                        id: 'str096APGinecoNumPSO'
                                                                    },
                                                                    {
                                                                        html: 'A:'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        allowBlank: true,
                                                                        width: 35,
                                                                        id: 'str097APGinecoNumASO'
                                                                    },
                                                                    {
                                                                        html: 'V:'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        allowBlank: true,
                                                                        width: 35,
                                                                        id: 'str098APGinecoNumVSO'
                                                                    },
                                                                    {
                                                                        html: 'C:'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        allowBlank: true,
                                                                        width: 35,
                                                                        id: 'str099APGinecoNumCSO'
                                                                    },
                                                                    {
                                                                        html: 'M:'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        allowBlank: true,
                                                                        width: 35,
                                                                        id: 'str100APGinecoNumMSO'
                                                                    },
                                                                    {
                                                                        html: 'E:'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        allowBlank: true,
                                                                        width: 35,
                                                                        id: 'str101APGinecoNumESO'
                                                                    },
                                                                    {
                                                                        html: 'FUC:'
                                                                    },
                                                                    {
                                                                        xtype: 'datefield',
                                                                        width: 120,
                                                                        allowBlank: true,
                                                                        style: 'text-align:center;',
                                                                        emptyText: '(dia/mes/año) ',
                                                                        id: 'fec102APGinecoFUCSO'
                                                                    },
                                                                    {
                                                                        html: 'Resultado:'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        allowBlank: true,
                                                                        width: 130,
                                                                        id: 'str103APGinecoFUCResultadoSO'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                fieldLabel: '',
                                                                anchor: '100%',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        fieldLabel: 'Planifica Actualente',
                                                                        allowBlank: true,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'str104APPlanificaActualmenteSO'
                                                                    },
                                                                    {
                                                                        html: 'Metodo:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 340,
                                                                        store: 'StoreMetodosPlanificacion',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        allowBlank: true,
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        triggerAction: 'all',
                                                                        id: 'str105APPlanificaMetodoSO'
                                                                    },
                                                                    {
                                                                        html: 'Tiempo:'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        allowBlank: true,
                                                                        width: 140,
                                                                        id: 'str106APPlanificaTiempoSO'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'ANTECEDENTES TÓXICOS',
                                                        anchor: '100%',
                                                        autoHeight: true,
                                                        layout: 'form',
                                                        collapsible: true,
                                                        items: [
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        fieldLabel: 'Fuma Actualente',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str107APToxicosFuamaActualmenteSO'
                                                                    },
                                                                    {
                                                                        html: 'Nro Cigarrillos Dia:'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        allowBlank: true,
                                                                        width: 140,
                                                                        id: 'str108APToxicosNroCigarrillosActualSO'
                                                                    },
                                                                    {
                                                                        html: 'Tiempo:'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        allowBlank: true,
                                                                        width: 140,
                                                                        emptyText: "Años",
                                                                        id: 'str109APToxicosFumaActualmenteTiempoSO'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        fieldLabel: 'Fumó Anteriormente',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str110APToxicosFuamoAnteriormenteSO'
                                                                    },
                                                                    {
                                                                        html: 'Nro Cigarrillos Dia:'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        allowBlank: true,
                                                                        width: 140,
                                                                        id: 'str111APToxicosNroCigarrillosAnteriorSO'
                                                                    },
                                                                    {
                                                                        html: 'Tiempo:'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        allowBlank: true,
                                                                        width: 140,
                                                                        emptyText: "Años",
                                                                        id: 'str112APToxicosFumaAnteriormenteTiempoSO'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        fieldLabel: 'Consumo de Alcohol',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str113APToxicosConsumoAlcoholSO'
                                                                    },
                                                                    {
                                                                        html: 'Freciencia:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 130,
                                                                        allowBlank: false,
                                                                        store: 'StoreFrecuenciaConsumo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NUNCA",
                                                                        id: 'str114APToxicosConsumoAlcoholTipoSO'
                                                                    },
                                                                    {
                                                                        html: 'Estado de Embriaguez:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str115APToxicosConsumoAlcoholEmbiaguezSO'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        fieldLabel: 'Consumé Drogas o Alguna Otra Sustancia?',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str116APToxicosConsumoDrograsSO'
                                                                    },
                                                                    {
                                                                        html: 'Cual:'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        allowBlank: true,
                                                                        width: 500,
                                                                        value: "NINGUNA",
                                                                        id: 'str117APToxicosConsumoDrograsCualSO'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'EN EL PUESTO DE TRABAJO ACTUAL O ANTERIOR ESTÁ (O ESTUVO) EXPUESTO A',
                                                        anchor: '100%',
                                                        autoHeight: true,
                                                        layout: 'form',
                                                        collapsible: true,
                                                        labelWidth: 200,
                                                        items: [
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Frio Intenso',
                                                                items: [
                                                                    {
                                                                        html: 'Empresa:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str118APExpuestoEmpresaFrioIntensoSO'
                                                                    },
                                                                    {
                                                                        html: 'Otro:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str119APExpuestoOtroFrioIntensoSO'
                                                                    }
                                                                ]
                                                            }, 
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Calor Intenso',
                                                                items: [
                                                                    {
                                                                        html: 'Empresa:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str120APExpuestoEmpresaCalorIntensoSO'
                                                                    },
                                                                    {
                                                                        html: 'Otro:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str121APExpuestoOtroCalorIntensoSO'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Ventilación Inadecuada',
                                                                items: [
                                                                    {
                                                                        html: 'Empresa:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str122APExpuestoEmpresaVentilacioninadecuadaSO'
                                                                    },
                                                                    {
                                                                        html: 'Otro:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str123APExpuestoOtroVentilacioninadecuadaSO'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Ruido',
                                                                items: [
                                                                    {
                                                                        html: 'Empresa:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str124APExpuestoEmpresaRuidoSO'
                                                                    },
                                                                    {
                                                                        html: 'Otro:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str125APExpuestoOtroRuidoSO'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Vibraciones',
                                                                items: [
                                                                    {
                                                                        html: 'Empresa:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str126APExpuestoEmpresaVibracionesSO'
                                                                    },
                                                                    {
                                                                        html: 'Otro:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str127APExpuestoOtroVibracionesSO'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Luz Excesiva',
                                                                items: [
                                                                    {
                                                                        html: 'Empresa:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str128APExpuestoEmpresaLuzexcesivaSO'
                                                                    },
                                                                    {
                                                                        html: 'Otro:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str129APExpuestoOtroLuzexcesivaSO'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Luz Deficiente',
                                                                items: [
                                                                    {
                                                                        html: 'Empresa:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str130APExpuestoEmpresaLuzdeficienteSO'
                                                                    },
                                                                    {
                                                                        html: 'Otro:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str131APExpuestoOtroLuzdeficienteSO'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Radiacion No Ionizante',
                                                                items: [
                                                                    {
                                                                        html: 'Empresa:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str132APExpuestoEmpresaRadiacionNoIonizanteSO'
                                                                    },
                                                                    {
                                                                        html: 'Otro:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str133APExpuestoOtroRadiacionNoIonizanteSO'
                                                                    }
                                                                ]
                                                            }, 
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Radiacion Ionizante',
                                                                items: [
                                                                    {
                                                                        html: 'Empresa:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str134APExpuestoEmpresaRadiacionIonizanteSO'
                                                                    },
                                                                    {
                                                                        html: 'Otro:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str135APExpuestoOtroRadiacionIonizanteSO'
                                                                    }
                                                                ]
                                                            }, 
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Humos',
                                                                items: [
                                                                    {
                                                                        html: 'Empresa:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str136APExpuestoEmpresaHumosSO'
                                                                    },
                                                                    {
                                                                        html: 'Otro:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str137APExpuestoOtroHumosSO'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Polvos',
                                                                items: [
                                                                    {
                                                                        html: 'Empresa:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str138APExpuestoEmpresaPolvosSO'
                                                                    },
                                                                    {
                                                                        html: 'Otro:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str139APExpuestoOtroPolvosSO'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Gases',
                                                                items: [
                                                                    {
                                                                        html: 'Empresa:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str140APExpuestoEmpresaGasesSO'
                                                                    },
                                                                    {
                                                                        html: 'Otro:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str141APExpuestoOtroGasesSO'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Vapores',
                                                                items: [
                                                                    {
                                                                        html: 'Empresa:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str142APExpuestoEmpresaVaporesSO'
                                                                    },
                                                                    {
                                                                        html: 'Otro:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str143APExpuestoOtroVaporesSO'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Contacto de Piel con Quimicos',
                                                                items: [
                                                                    {
                                                                        html: 'Empresa:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str144APExpuestoEmpresaContactodepielconquimicosSO'
                                                                    },
                                                                    {
                                                                        html: 'Otro:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str145APExpuestoOtroContactodepielconquimicosSO'
                                                                    }
                                                                ]
                                                            }, 
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Humos Metalicos',
                                                                items: [
                                                                    {
                                                                        html: 'Empresa:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str146APExpuestoEmpresaHumosmetalicosSO'
                                                                    },
                                                                    {
                                                                        html: 'Otro:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str147APExpuestoOtroHumosmetalicosSO'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Agentes Biologicos',
                                                                items: [
                                                                    {
                                                                        html: 'Empresa:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str148APExpuestoEmpresaAgentesBiologicosSO'
                                                                    },
                                                                    {
                                                                        html: 'Otro:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str149APExpuestoOtroAgentesBiologicosSO'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Diseño Inadecuado de Muebles',
                                                                items: [
                                                                    {
                                                                        html: 'Empresa:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str150APExpuestoEmpresaDisenoinadecuadodemueblesSO'
                                                                    },
                                                                    {
                                                                        html: 'Otro:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str151APExpuestoOtroDisenoinadecuadodemueblesSO'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Movimientos Repetitivos',
                                                                items: [
                                                                    {
                                                                        html: 'Empresa:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str152APExpuestoEmpresaMovimientosRepetitivosSO'
                                                                    },
                                                                    {
                                                                        html: 'Otro:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str153APExpuestoOtroMovimientosRepetitivosSO'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Posturas Inadecuadas',
                                                                items: [
                                                                    {
                                                                        html: 'Empresa:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str154APExpuestoEmpresaPosturasInadecuadasSO'
                                                                    },
                                                                    {
                                                                        html: 'Otro:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str155APExpuestoOtroPosturasInadecuadasSO'
                                                                    }
                                                                ]
                                                            }, 
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Levantamiento de Cargas',
                                                                items: [
                                                                    {
                                                                        html: 'Empresa:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str156APExpuestoEmpresaLevantamientodecargasSO'
                                                                    },
                                                                    {
                                                                        html: 'Otro:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str157APExpuestoOtroLevantamientodecargasSO'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Espacio Trabajo Inadecuado',
                                                                items: [
                                                                    {
                                                                        html: 'Empresa:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str158APExpuestoEmpresaEspacioTrabajoInadecuadoSO'
                                                                    },
                                                                    {
                                                                        html: 'Otro:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str159APExpuestoOtroEspacioTrabajoInadecuadoSO'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Estrés',
                                                                items: [
                                                                    {
                                                                        html: 'Empresa:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str160APExpuestoEmpresaEstrasSO'
                                                                    },
                                                                    {
                                                                        html: 'Otro:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str161APExpuestoOtroEstrasSO'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Trabajo Monotono',
                                                                items: [
                                                                    {
                                                                        html: 'Empresa:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str162APExpuestoEmpresaTrabajomonotonoSO'
                                                                    },
                                                                    {
                                                                        html: 'Otro:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str163APExpuestoOtroTrabajomonotonoSO'
                                                                    }
                                                                ]
                                                            }, 
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Sobrecarga de Trabajo',
                                                                items: [
                                                                    {
                                                                        html: 'Empresa:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str164APExpuestoEmpresaSobrecargadetrabajoSO'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys3_b24',
                                                                        value: 'Otro:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str165APExpuestoOtroSobrecargadetrabajoSO'
                                                                    }
                                                                ]
                                                            }, 
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Horas Extras Sobretiempo',
                                                                items: [
                                                                    {
                                                                        html: 'Empresa:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str166APExpuestoEmpresaHorasextrasSobretiempoSO'
                                                                    },
                                                                    {
                                                                        html: 'Otro:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str167APExpuestoOtroHorasextrasSobretiempoSO'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Manejo de Publico',
                                                                items: [
                                                                    {
                                                                        html: 'Empresa:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str168APExpuestoEmpresaManejodepublicoSO'
                                                                    },
                                                                    {
                                                                        html: 'Otro:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str169APExpuestoOtroManejodepublicoSO'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Conflicto de Autoridad',
                                                                items: [
                                                                    {
                                                                        html: 'Empresa:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str170APExpuestoEmpresaConflictodeAutoridadSO'
                                                                    },
                                                                    {
                                                                        html: 'Otro:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str171APExpuestoOtroConflictodeAutoridadSO'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Violencia Comun',
                                                                items: [
                                                                    {
                                                                        html: 'Empresa:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str172APExpuestoEmpresaViolenciacomunSO'
                                                                    },
                                                                    {
                                                                        html: 'Otro:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str173APExpuestoOtroViolenciacomunSO'
                                                                    }
                                                                ]
                                                            }, 
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Herramientas Manuales',
                                                                items: [
                                                                    {
                                                                        html: 'Empresa:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str174APExpuestoEmpresaHerramientasmanualesSO'
                                                                    },
                                                                    {
                                                                        html: 'Otro:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str175APExpuestoOtroHerramientasmanualesSO'
                                                                    }
                                                                ]
                                                            }, 
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Proyeccion de Particulas',
                                                                items: [
                                                                    {
                                                                        html: 'Empresa:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str176APExpuestoEmpresaProyecciondeparticulasSO'
                                                                    },
                                                                    {
                                                                        html: 'Otro:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str177APExpuestoOtroProyecciondeparticulasSO'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Mecanismos en Movimiento',
                                                                items: [
                                                                    {
                                                                        html: 'Empresa:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str178APExpuestoEmpresaMecanismosenmovimientoSO'
                                                                    },
                                                                    {
                                                                        html: 'Otro:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str179APExpuestoOtroMecanismosenmovimientoSO'
                                                                    }
                                                                ]
                                                            }, 
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Equipos a Presion',
                                                                items: [
                                                                    {
                                                                        html: 'Empresa:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str180APExpuestoEmpresaEquiposapresionSO'
                                                                    },
                                                                    {
                                                                        html: 'Otro:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str181APExpuestoOtroEquiposapresionSO'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Electricos',
                                                                items: [
                                                                    {
                                                                        html: 'Empresa:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str182APExpuestoEmpresaElectricosSO'
                                                                    },
                                                                    {
                                                                        html: 'Otro:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str183APExpuestoOtroElectricosSO'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                fieldLabel: 'Empresa',
                                                                name: 'Empresa',
                                                                anchor: '99%',
                                                                height: 25,
                                                                grow: true,
                                                                growMin: 25,
                                                                growMax: 400,
                                                                allowBlank: true,
                                                                id: 'str184ExpuestoEmpresaSO'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Cómo realiza sus tareas?',
                                                        width: 100,
                                                        allowBlank: false,
                                                        store: 'StoreComoRealizaTareas',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: 'NO APLICA',
                                                        id: 'str185APComoRealizaTareasSO'
                                                    },
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'ELEMENTOS DE PROTECCIÓN PERSONAL',
                                                        anchor: '100%',
                                                        autoHeight: true,
                                                        layout: 'form',
                                                        collapsible: true,
                                                        labelWidth: 200,
                                                        items: [
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Casco',
                                                                items: [
                                                                    {
                                                                        html: 'Necesita:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str186CascoNecesitaSO'
                                                                    },
                                                                    {
                                                                        html: 'Tiene:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str187CascoTieneSO'
                                                                    },
                                                                    {
                                                                        html: 'Utilizo:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str188CascoUtilizoSO'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Cofias',
                                                                items: [
                                                                    {
                                                                        html: 'Necesita:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str189CofiasNecesitaSO'
                                                                    },
                                                                    {
                                                                        html: 'Tiene:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str190CofiasTieneSO'
                                                                    },
                                                                    {
                                                                        html: 'Utilizo:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str191CofiasUtilizoSO'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Gorro',
                                                                items: [
                                                                    {
                                                                        html: 'Necesita:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str192GorroNecesitaSO'
                                                                    },
                                                                    {
                                                                        html: 'Tiene:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str193GorroTieneSO'
                                                                    },
                                                                    {
                                                                        html: 'Utilizo:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str194GorroUtilizoSO'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Careta de Acetato',
                                                                items: [
                                                                    {
                                                                        html: 'Necesita:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str195CaretadeacetatoNecesitaSO'
                                                                    },
                                                                    {
                                                                        html: 'Tiene:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str196CaretadeacetatoTieneSO'
                                                                    },
                                                                    {
                                                                        html: 'Utilizo:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str197CaretadeacetatoUtilizoSO'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Gafas de Seguridad',
                                                                items: [
                                                                    {
                                                                        html: 'Necesita:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str198GafasdeSeguridadNecesitaSO'
                                                                    },
                                                                    {
                                                                        html: 'Tiene:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str199GafasdeSeguridadTieneSO'
                                                                    },
                                                                    {
                                                                        html: 'Utilizo:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str200GafasdeSeguridadUtilizoSO'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Mascarilla Desechable',
                                                                items: [
                                                                    {
                                                                        html: 'Necesita:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str201MascarilladesechableNecesitaSO'
                                                                    },
                                                                    {
                                                                        html: 'Tiene:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str202MascarilladesechableTieneSO'
                                                                    },
                                                                    {
                                                                        html: 'Utilizo:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str203MascarilladesechableUtilizoSO'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Protectores Auriculares',
                                                                items: [
                                                                    {
                                                                        html: 'Necesita:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str204ProtectoresAuricularesNecesitaSO'
                                                                    },
                                                                    {
                                                                        html: 'Tiene:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str205ProtectoresAuricularesTieneSO'
                                                                    },
                                                                    {
                                                                        html: 'Utilizo:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str206ProtectoresAuricularesUtilizoSO'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Guantes',
                                                                items: [
                                                                    {
                                                                        html: 'Necesita:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str207GuantesNecesitaSO'
                                                                    },
                                                                    {
                                                                        html: 'Tiene:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str208GuantesTieneSO'
                                                                    },
                                                                    {
                                                                        html: 'Utilizo:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str209GuantesUtilizoSO'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Braceras',
                                                                items: [
                                                                    {
                                                                        html: 'Necesita:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str210BracerasNecesitaSO'
                                                                    },
                                                                    {
                                                                        html: 'Tiene:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str211BracerasTieneSO'
                                                                    },
                                                                    {
                                                                        html: 'Utilizo:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str212BracerasUtilizoSO'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Peto',
                                                                items: [
                                                                    {
                                                                        html: 'Necesita:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str213PetoNecesitaSO'
                                                                    },
                                                                    {
                                                                        html: 'Tiene:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str214PetoTieneSO'
                                                                    },
                                                                    {
                                                                        html: 'Utilizo:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str215PetoUtilizoSO'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Delantal',
                                                                items: [
                                                                    {
                                                                        html: 'Necesita:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str216DelantalNecesitaSO'
                                                                    },
                                                                    {
                                                                        html: 'Tiene:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str217DelantalTieneSO'
                                                                    },
                                                                    {
                                                                        html: 'Utilizo:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str218DelantalUtilizoSO'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Calzado de Seguridad',
                                                                items: [
                                                                    {
                                                                        html: 'Necesita:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str219CalzadodeSeguridadNecesitaSO'
                                                                    },
                                                                    {
                                                                        html: 'Tiene:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str220CalzadodeSeguridadTieneSO'
                                                                    },
                                                                    {
                                                                        html: 'Utilizo:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str221CalzadodeSeguridadUtilizoSO'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Bata',
                                                                items: [
                                                                    {
                                                                        html: 'Necesita:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str222BataNecesitaSO'
                                                                    },
                                                                    {
                                                                        html: 'Tiene:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str223BataTieneSO'
                                                                    },
                                                                    {
                                                                        html: 'Utilizo:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str224BataUtilizoSO'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Otros',
                                                                items: [
                                                                    {
                                                                        html: 'Necesita:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str225OtrosNecesitaSO'
                                                                    },
                                                                    {
                                                                        html: 'Tiene:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str226OtrosTieneSO'
                                                                    },
                                                                    {
                                                                        html: 'Utilizo:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str227OtrosUtilizoSO'
                                                                    },
                                                                    {
                                                                        xtype: 'textarea',
                                                                        width: 200,
                                                                        name: 'OTROS ELEMENTOS DE PROTECCION PERSONAL',
                                                                        allowBlank: true,
                                                                        id: 'mem228OtrosElementosProtecionPersonalSO'
                                                                    }
                                                                ]
                                                            } 
                                                        // FIN
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        layout: 'table',
                                                        title: '',
                                                        unstyled: true,
                                                        layoutConfig: {
                                                            columns: 4
                                                        },
                                                        border: false,
                                                        items: [
                                                            {
                                                                xtype: 'panel',// col6
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Realiza Deporte',
                                                                        name: 'HACE DEPORTE',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        forceSelection: false,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NO',
                                                                        id: 'str229APDeporte',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if (cmb.getValue() === "SI"){
                                                                                    Ext.getCmp('str230APDeporteOtros').enable();
                                                                                    Ext.getCmp('str230APDeporteOtros').allowBlank = false;
                                                                                }else{
                                                                                    Ext.getCmp('str230APDeporteOtros').setValue('');
                                                                                    Ext.getCmp('str230APDeporteOtros').disable();
                                                                                    Ext.getCmp('str230APDeporteOtros').allowBlank = true;
                                                                                    Ext.getCmp('str230APDeporteOtros').clearInvalid();
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',// col7
                                                                width: 750,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                colspan: 2,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        fieldLabel: 'Cuáles Practica?',
                                                                        name: 'CUALES PRACTICA',
                                                                        disabled: true,
                                                                        anchor: '99%',
                                                                        height: 25,
                                                                        grow: true,
                                                                        growMin: 25,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'str230APDeporteOtros'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'ACCIDENTE DE TRABAJO Nro 1',
                                                        anchor: '100%',
                                                        autoHeight: true,
                                                        layout: 'form',
                                                        collapsible: true,
                                                        labelWidth: 200,
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Ha tenido algún accidente de trabajo?',
                                                                name: 'Ha tenido algún accidente de trabajo?',
                                                                width: 100,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'str231SufrioAccidenteTrabajoSO'
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                fieldLabel: 'Diagnóstico',
                                                                name: 'Diagnóstico',
                                                                anchor: '99%',
                                                                height: 25,
                                                                grow: true,
                                                                growMin: 25,
                                                                growMax: 400,
                                                                allowBlank: true,
                                                                id: 'str232SufrioAccidenteTrabajoDxSO'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 140,
                                                                allowBlank: true,
                                                                fieldLabel: 'Fecha',
                                                                name: 'Fecha',
                                                                style: 'text-align:center;',
                                                                emptyText: '(dia/mes/año) ',
                                                                id: 'fec233SufrioAccidenteTrabajo'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '99%',
                                                                allowBlank: true,
                                                                fieldLabel: 'Incapacidad',
                                                                name: 'Incapacidad',
                                                                id: 'str234SufrioAccidenteTrabajoIncSO'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'ACCIDENTE DE TRABAJO Nro 2',
                                                        anchor: '100%',
                                                        autoHeight: true,
                                                        layout: 'form',
                                                        collapsible: true,
                                                        labelWidth: 200,
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Ha tenido algún accidente de trabajo?',
                                                                name: 'Ha tenido algún accidente de trabajo?',
                                                                width: 100,
                                                                allowBlank: true,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'str235SufrioAccidenteTrabajo2SO'
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                fieldLabel: 'Diagnóstico',
                                                                name: 'Diagnóstico',
                                                                anchor: '99%',
                                                                height: 25,
                                                                grow: true,
                                                                growMin: 25,
                                                                growMax: 400,
                                                                allowBlank: true,
                                                                id: 'str236SufrioAccidenteTrabajo2DxSO'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 140,
                                                                allowBlank: true,
                                                                fieldLabel: 'Fecha',
                                                                name: 'Fecha',
                                                                style: 'text-align:center;',
                                                                emptyText: '(dia/mes/año) ',
                                                                id: 'fec237SufrioAccidenteTrabajo2'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '99%',
                                                                allowBlank: true,
                                                                fieldLabel: 'Incapacidad',
                                                                name: 'Incapacidad',
                                                                id: 'str238SufrioAccidenteTrabajo2IncSO'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'ACCIDENTE DE TRABAJO Nro 3',
                                                        anchor: '100%',
                                                        autoHeight: true,
                                                        layout: 'form',
                                                        collapsible: true,
                                                        labelWidth: 200,
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Ha tenido algún accidente de trabajo?',
                                                                name: 'Ha tenido algún accidente de trabajo?',
                                                                width: 100,
                                                                allowBlank: true,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'str239SufrioAccidenteTrabajo3SO'
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                fieldLabel: 'Diagnóstico',
                                                                name: 'Diagnóstico',
                                                                anchor: '99%',
                                                                height: 25,
                                                                grow: true,
                                                                growMin: 25,
                                                                growMax: 400,
                                                                allowBlank: true,
                                                                id: 'str240SufrioAccidenteTrabajo3DxSO'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 140,
                                                                allowBlank: true,
                                                                fieldLabel: 'Fecha',
                                                                name: 'Fecha',
                                                                style: 'text-align:center;',
                                                                emptyText: '(dia/mes/año) ',
                                                                id: 'fec241SufrioAccidenteTrabajo3'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '99%',
                                                                allowBlank: true,
                                                                fieldLabel: 'Incapacidad',
                                                                name: 'Incapacidad',
                                                                id: 'str242SufrioAccidenteTrabajo3IncSO'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'ACCIDENTE DE TRABAJO Nro 4',
                                                        anchor: '100%',
                                                        autoHeight: true,
                                                        layout: 'form',
                                                        collapsible: true,
                                                        labelWidth: 200,
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Ha tenido algún accidente de trabajo?',
                                                                name: 'Ha tenido algún accidente de trabajo?',
                                                                width: 100,
                                                                allowBlank: true,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'str243SufrioAccidenteTrabajo4SO'
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                fieldLabel: 'Diagnóstico',
                                                                name: 'Diagnóstico',
                                                                anchor: '99%',
                                                                height: 25,
                                                                grow: true,
                                                                growMin: 25,
                                                                growMax: 400,
                                                                allowBlank: true,
                                                                id: 'str244SufrioAccidenteTrabajo4DxSO'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 140,
                                                                allowBlank: true,
                                                                fieldLabel: 'Fecha',
                                                                name: 'Fecha',
                                                                style: 'text-align:center;',
                                                                emptyText: '(dia/mes/año) ',
                                                                id: 'fec245SufrioAccidenteTrabajo4'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '99%',
                                                                allowBlank: true,
                                                                fieldLabel: 'Incapacidad',
                                                                name: 'Incapacidad',
                                                                id: 'str246SufrioAccidenteTrabajo4IncSO'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'ACCIDENTE DE TRABAJO Nro 5',
                                                        anchor: '100%',
                                                        autoHeight: true,
                                                        layout: 'form',
                                                        collapsible: true,
                                                        labelWidth: 200,
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Ha tenido algún accidente de trabajo?',
                                                                name: 'Ha tenido algún accidente de trabajo?',
                                                                width: 100,
                                                                allowBlank: true,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'str247SufrioAccidenteTrabajo5SO'
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                fieldLabel: 'Diagnóstico',
                                                                name: 'Diagnóstico',
                                                                anchor: '99%',
                                                                height: 25,
                                                                grow: true,
                                                                growMin: 25,
                                                                growMax: 400,
                                                                allowBlank: true,
                                                                id: 'str248SufrioAccidenteTrabajo5DxSO'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 140,
                                                                allowBlank: true,
                                                                fieldLabel: 'Fecha',
                                                                name: 'Fecha',
                                                                style: 'text-align:center;',
                                                                emptyText: '(dia/mes/año) ',
                                                                id: 'fec249SufrioAccidenteTrabajo5'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '99%',
                                                                allowBlank: true,
                                                                fieldLabel: 'Incapacidad',
                                                                name: 'Incapacidad',
                                                                id: 'str250SufrioAccidenteTrabajo5IncSO'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'ENFERMEDAD PROFESIONAL',
                                                        anchor: '100%',
                                                        autoHeight: true,
                                                        layout: 'form',
                                                        collapsible: true,
                                                        labelWidth: 200,
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Ha tenido alguna enfermedad profesional?',
                                                                name: 'Ha tenido alguna enfermedad profesional?',
                                                                width: 100,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'str251SufrioEnfProfesionalSO'
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                fieldLabel: 'Diagnóstico',
                                                                name: 'Diagnóstico',
                                                                anchor: '99%',
                                                                height: 25,
                                                                grow: true,
                                                                growMin: 25,
                                                                growMax: 400,
                                                                allowBlank: true,
                                                                id: 'str252SufrioEnfProfesionalDxSO'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 140,
                                                                allowBlank: true,
                                                                fieldLabel: 'Fecha',
                                                                name: 'Fecha',
                                                                style: 'text-align:center;',
                                                                emptyText: '(dia/mes/año) ',
                                                                id: 'fec253SufrioEnfProfesionalSO'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '99%',
                                                                allowBlank: true,
                                                                fieldLabel: 'Incapacidad',
                                                                name: 'Incapacidad',
                                                                id: 'str254SufrioEnfProfesionalIncSO'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'TAMIZAJE VISUAL',
                                                labelWidth: '150',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '98%',
                                                autoHeight: true,
                                                id: 'fsa',
                                                items: [
                                                    { // Tabla Examen Fisico
                                                        xtype: 'panel',
                                                        layout: 'table',
                                                        unstyled: true,
                                                        layoutConfig: {
                                                            columns: 2
                                                        },
                                                        border: false,
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 3.1
                                                                        fieldLabel: 'Ojos',
                                                                        name:"TAMIZAJE VISUAL - OJOS",
                                                                        width: 100,
                                                                        allowBlank: true,
                                                                        store: 'StoreNormalAnormal',
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NORMAL',
                                                                        id: 'str255TomaSignosOjos',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() === "NORMAL"){
                                                                                    Ext.getCmp('mem256TomaSignosOjosH').allowBlank = true;
                                                                                    Ext.getCmp('mem256TomaSignosOjosH').setValue(null);
                                                                                    Ext.getCmp('mem256TomaSignosOjosH').disable();
                                                                                    Ext.getCmp('mem256TomaSignosOjosH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('mem256TomaSignosOjosH').enable();
                                                                                    Ext.getCmp('mem256TomaSignosOjosH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 720,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"TAMIZAJE VISUAL - OJOS - HALLAZGOS",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '98%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'mem256TomaSignosOjosH'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                style: 'text-align:center;',
                                                                fieldLabel: 'AV.Lejana: OD',
                                                                name: 'AV.LEJANA:OD',
                                                                value: '20/',
                                                                width: 70,
                                                                allowBlank: true,
                                                                id: 'str257TomaSignosAVLejanaOD'
                                                            },
                                                            {
                                                                html: 'AV.Lejana: OI'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                style: 'text-align:center;',
                                                                name: 'AV.LEJANA:OI',
                                                                value: '20/',
                                                                width: 70,
                                                                allowBlank: true,
                                                                id: 'str258TomaSignosAVLejanaOI'
                                                            },
                                                            {
                                                                html: 'AV.Cercana: OD'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                style: 'text-align:center;',
                                                                nameLabel: 'AV.CERCANA: OD',
                                                                value: '20/',
                                                                width: 70,
                                                                allowBlank: true,
                                                                id: 'str259TomaSignosAVCercanaOD'
                                                            },
                                                            {
                                                                html: 'AV.Cercana: OI'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                style: 'text-align:center;',
                                                                name: 'AV.CERCANA: OI',
                                                                value: '20/',
                                                                width: 70,
                                                                allowBlank: true,
                                                                id: 'str260TomaSignosAVCercanaOI'
                                                            },
                                                            {
                                                                html: 'Se Hizo con Correción?'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 70,
                                                                allowBlank: true,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'str261TomaSignosAVCorrecion'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'REVISION POR SISTEMAS',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '99%',
                                                autoHeight: true,
                                                id: 'fs5',
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        fieldLabel: 'Oftalmológico',
                                                        name: 'Oftalmológico',
                                                        anchor: '100%',
                                                        height: 50,   
                                                        grow: true,
                                                        minGrow: 50,
                                                        allowBlank: true,
                                                        value: "NO REFIERE",
                                                        id: 'mem262RSOftalmologico'
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        fieldLabel: 'ORL',
                                                        name: 'ORL',
                                                        anchor: '100%',
                                                        height: 50,   
                                                        grow: true,
                                                        minGrow: 50,
                                                        allowBlank: true,
                                                        value: "NO REFIERE",
                                                        id: 'mem263RSORL'
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        fieldLabel: 'Respiratorio',
                                                        name: 'RESPIRATORIO',
                                                        anchor: '100%',
                                                        height: 50,   
                                                        grow: true,
                                                        minGrow: 50,
                                                        allowBlank: true,
                                                        value: "NO REFIERE",
                                                        id: 'mem264RSRespiratorio'
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        fieldLabel: 'Cardiovascular',
                                                        name: 'Cardiovascular',
                                                        anchor: '100%',
                                                        height: 50,   
                                                        grow: true,
                                                        minGrow: 50,
                                                        allowBlank: true,
                                                        value: "NO REFIERE",
                                                        id: 'mem265RSCardiovascular'
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        fieldLabel: 'Digestivo',
                                                        name: 'DIGESTIVO',
                                                        anchor: '100%',
                                                        height: 50,   
                                                        grow: true,
                                                        minGrow: 50,
                                                        allowBlank: true,
                                                        value: "NO REFIERE",
                                                        id: 'mem266RSDigestivo'
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        fieldLabel: 'Genito-Urinario',
                                                        name: 'Genito-Urinario',
                                                        anchor: '100%',
                                                        height: 50,   
                                                        grow: true,
                                                        minGrow: 50,
                                                        allowBlank: true,
                                                        value: "NO REFIERE",
                                                        id: 'mem267RSUrogenital'
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        fieldLabel: 'Osteo-muscular',
                                                        name: 'Osteo-muscular',
                                                        anchor: '100%',
                                                        height: 50,   
                                                        grow: true,
                                                        minGrow: 50,
                                                        allowBlank: true,
                                                        value: "NO REFIERE",
                                                        id: 'mem268RSLocomotor'
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        fieldLabel: 'Nervioso',
                                                        name: 'NERVIOSO',
                                                        anchor: '100%',
                                                        height: 50,   
                                                        grow: true,
                                                        minGrow: 50,
                                                        allowBlank: true,
                                                        value: "NO REFIERE",
                                                        id: 'mem269RSNervioso'
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        fieldLabel: 'Psico-emocional',
                                                        name: 'Psico-emocional',
                                                        anchor: '100%',
                                                        height: 50,   
                                                        grow: true,
                                                        minGrow: 50,
                                                        allowBlank: true,
                                                        value: "NO REFIERE",
                                                        id: 'mem270RSHematopoyetico'
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        fieldLabel: 'Observaciones',
                                                        name: 'Observaciones',
                                                        anchor: '100%',
                                                        height: 50,   
                                                        grow: true,
                                                        minGrow: 50,
                                                        allowBlank: true,
                                                        id: 'mem271RSOtros'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'TOMA DE SIGNOS',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '99%',
                                                autoHeight: true,
                                                id: 'fs6a',
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                fieldLabel: 'Talla',
                                                                name:"Talla (cm)",
                                                                emptyText: '(cm)',
                                                                id: 'int272TomaSignosTalla',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        if(pNew === null || pNew === 0){
                                                                            Ext.getCmp('int272TomaSignosTalla').setValue(null);
                                                                            Ext.getCmp('int274TomaSignosIMC').setValue(0);
                                                                        }else{
                                                                            //peso [kg]/ estatura [m2]
                                                                            if(Ext.getCmp('int273TomaSignosPeso').getValue() > 0){
                                                                                var pTalla = Ext.getCmp('int272TomaSignosTalla').getValue() / 100; 
                                                                                Ext.getCmp('int274TomaSignosIMC').setValue(Ext.getCmp('int273TomaSignosPeso').getValue()/(pTalla*pTalla));
                                                                            }else{
                                                                                Ext.getCmp('int274TomaSignosIMC').setValue(0);
                                                                            }
                                                                        }
                                                                        if(Ext.getCmp('int274TomaSignosIMC').getValue()<1){
                                                                           Ext.getCmp('str275omaSignosIMCClasificacon').setValue(null);
                                                                        }else{
                                                                            if(Ext.getCmp('int274TomaSignosIMC').getValue()<18.5){
                                                                               Ext.getCmp('str275omaSignosIMCClasificacon').setValue("BAJO PESO");
                                                                            }else{
                                                                                if(Ext.getCmp('int274TomaSignosIMC').getValue()<24.9){
                                                                                   Ext.getCmp('str275omaSignosIMCClasificacon').setValue("NORMAL");
                                                                                }else{
                                                                                    if(Ext.getCmp('int274TomaSignosIMC').getValue()<29.9){
                                                                                       Ext.getCmp('str275omaSignosIMCClasificacon').setValue("SOBREPESO");
                                                                                    }else{
                                                                                        if(Ext.getCmp('int274TomaSignosIMC').getValue()<34.9){
                                                                                            Ext.getCmp('str275omaSignosIMCClasificacon').setValue("OBESIDAD I");
                                                                                        }else{
                                                                                            if(Ext.getCmp('int274TomaSignosIMC').getValue()<39.9){
                                                                                                Ext.getCmp('str275omaSignosIMCClasificacon').setValue("OBESIDAD II");
                                                                                            }else{
                                                                                                Ext.getCmp('str275omaSignosIMCClasificacon').setValue("OBESIDAD III");
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html: 'Peso (Kg):'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                emptyText: '(Kg)',
                                                                name:"Peso Actual (Kg)",
                                                                id: 'int273TomaSignosPeso',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        if(pNew === null || pNew === 0){
                                                                            Ext.getCmp('int273TomaSignosPeso').setValue(null);
                                                                            Ext.getCmp('int274TomaSignosIMC').setValue(0);
                                                                        }else{
                                                                            //peso [kg]/ estatura [m2]
                                                                            if(Ext.getCmp('int272TomaSignosTalla').getValue() > 0){
                                                                                var pTalla = Ext.getCmp('int272TomaSignosTalla').getValue() / 100; 
                                                                                Ext.getCmp('int274TomaSignosIMC').setValue(Ext.getCmp('int273TomaSignosPeso').getValue()/(pTalla*pTalla));
                                                                            }else{
                                                                                Ext.getCmp('int274TomaSignosIMC').setValue(0);
                                                                            }
                                                                        }
                                                                        if(Ext.getCmp('int274TomaSignosIMC').getValue()<1){
                                                                           Ext.getCmp('str275omaSignosIMCClasificacon').setValue(null);
                                                                        }else{
                                                                            if(Ext.getCmp('int274TomaSignosIMC').getValue()<18.5){
                                                                               Ext.getCmp('str275omaSignosIMCClasificacon').setValue("BAJO PESO");
                                                                            }else{
                                                                                if(Ext.getCmp('int274TomaSignosIMC').getValue()<24.9){
                                                                                   Ext.getCmp('str275omaSignosIMCClasificacon').setValue("NORMAL");
                                                                                }else{
                                                                                    if(Ext.getCmp('int274TomaSignosIMC').getValue()<29.9){
                                                                                       Ext.getCmp('str275omaSignosIMCClasificacon').setValue("SOBREPESO");
                                                                                    }else{
                                                                                        if(Ext.getCmp('int274TomaSignosIMC').getValue()<34.9){
                                                                                            Ext.getCmp('str275omaSignosIMCClasificacon').setValue("OBESIDAD I");
                                                                                        }else{
                                                                                            if(Ext.getCmp('int274TomaSignosIMC').getValue()<39.9){
                                                                                                Ext.getCmp('str275omaSignosIMCClasificacon').setValue("OBESIDAD II");
                                                                                            }else{
                                                                                                Ext.getCmp('str275omaSignosIMCClasificacon').setValue("OBESIDAD III");
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html: 'IMC:'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                readOnly: true,
                                                                value: 0,
                                                                name: "IMC",
                                                                id: 'int274TomaSignosIMC'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 100,
                                                                allowBlank: true,
                                                                readOnly: true,
                                                                name: "IMC - CLASIFICACION",
                                                                id: 'str275omaSignosIMCClasificacon'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Lateralidad',
                                                        anchor: '98%',
                                                        name: 'LATERALIDAD',
                                                        allowBlank: true,
                                                        store: 'StoreLateralidad',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        id: 'str276TomaSignosLateralidad'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                decimalPrecision: 0,
                                                                allowBlank: true,
                                                                fieldLabel:"FC",
                                                                name: "FC",
                                                                id: 'str277TomaSignosFC'
                                                            },
                                                            {
                                                                html: 'Por Minuto'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 50,
                                                                minValue: 0,
                                                                decimalPrecision: 0,
                                                                allowBlank: true,
                                                                fieldLabel:"TA",
                                                                name: "TA SISTOLICA",
                                                                id: 'str278TomaSignosTASistolica'
                                                            },
                                                            {
                                                                html: '/'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 50,
                                                                minValue: 0,
                                                                decimalPrecision: 0,
                                                                allowBlank: true,
                                                                name: "TA DISTOLICA",
                                                                id: 'str279TomaSignosTADiatolica'
                                                            },
                                                            {
                                                                html: 'MmHg'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                decimalPrecision: 0,
                                                                allowBlank: true,
                                                                fieldLabel:"FR",
                                                                name: "FR",
                                                                id: 'str280TomaSignosFR'
                                                            },
                                                            {
                                                                html: 'Por Minuto'
                                                            },
                                                            {
                                                                html: '&nbsp;&nbsp;- TE:'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                decimalPrecision: 0,
                                                                allowBlank: true,
                                                                name: "TE",
                                                                id: 'str281TomaSignosTE'
                                                            },
                                                            {
                                                                html: 'ºC'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        fieldLabel: 'Observaciones',
                                                        name: 'OBSERVACIONES',
                                                        height: 30,
                                                        grow: true,
                                                        minGrow: 30,
                                                        allowBlank: true,
                                                        id: 'mem282TomaSignosObservaciones'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'EXAMEN FISICO',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '99%',
                                                autoHeight: true,
                                                id: 'fs6',
                                                items: [ 
                                                    { // Tabla Examen Fisico
                                                        xtype: 'panel',
                                                        layout: 'table',
                                                        unstyled: true,
                                                        layoutConfig: {
                                                            columns: 5
                                                        },
                                                        border: false,
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 5.1
                                                                        fieldLabel: 'Ojos',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NORMAL',
                                                                        name:"EXANEN FISICO - OJOS",
                                                                        id: 'str283EF_Ojos1',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() === "NORMAL"){
                                                                                    Ext.getCmp('mem284EF_Ojos1H').allowBlank = true;
                                                                                    Ext.getCmp('mem284EF_Ojos1H').setValue(null);
                                                                                    Ext.getCmp('mem284EF_Ojos1H').disable();
                                                                                    Ext.getCmp('mem284EF_Ojos1H').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('mem284EF_Ojos1H').enable();
                                                                                    Ext.getCmp('mem284EF_Ojos1H').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 5.2-5
                                                                width: 780,
                                                                colspan:4,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"EXANEN FISICO - OJOS - HALLAZGOS",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'mem284EF_Ojos1H'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 5.1
                                                                        fieldLabel: 'Oidos',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NORMAL',
                                                                        name:"EXANEN FISICO - OIDOS",
                                                                        id: 'str285EF_Oidos',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() === "NORMAL"){
                                                                                    Ext.getCmp('mem286EF_OidosH').allowBlank = true;
                                                                                    Ext.getCmp('mem286EF_OidosH').setValue(null);
                                                                                    Ext.getCmp('mem286EF_OidosH').disable();
                                                                                    Ext.getCmp('mem286EF_OidosH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('mem286EF_OidosH').enable();
                                                                                    Ext.getCmp('mem286EF_OidosH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 5.2-5
                                                                width: 780,
                                                                colspan:4,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"EXANEN FISICO - OIDOS - HALLAZGOS",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'mem286EF_OidosH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 5.1
                                                                        fieldLabel: 'Nariz',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NORMAL',
                                                                        name:"EXANEN FISICO - NARIZ",
                                                                        id: 'str287EF_Nariz',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() === "NORMAL"){
                                                                                    Ext.getCmp('mem288EF_NarizH').allowBlank = true;
                                                                                    Ext.getCmp('mem288EF_NarizH').setValue(null);
                                                                                    Ext.getCmp('mem288EF_NarizH').disable();
                                                                                    Ext.getCmp('mem288EF_NarizH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('mem288EF_NarizH').enable();
                                                                                    Ext.getCmp('mem288EF_NarizH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 5.2-5
                                                                width: 780,
                                                                colspan:4,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"EXANEN FISICO - NARIZ - HALLAZGOS",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'mem288EF_NarizH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 5.1
                                                                        fieldLabel: 'Boca',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NORMAL',
                                                                        name:"EXANEN FISICO - BOCA",
                                                                        id: 'str289EF_Boca',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() === "NORMAL"){
                                                                                    Ext.getCmp('mem290EF_BocaH').allowBlank = true;
                                                                                    Ext.getCmp('mem290EF_BocaH').setValue(null);
                                                                                    Ext.getCmp('mem290EF_BocaH').disable();
                                                                                    Ext.getCmp('mem290EF_BocaH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('mem290EF_BocaH').enable();
                                                                                    Ext.getCmp('mem290EF_BocaH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 5.2-5
                                                                width: 780,
                                                                colspan:4,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"EXANEN FISICO - BOCA - HALLAZGOS",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'mem290EF_BocaH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 5.1
                                                                        fieldLabel: 'Cuello',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NORMAL',
                                                                        name:"EXANEN FISICO - CUELLO",
                                                                        id: 'str291EF_Cuello',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() === "NORMAL"){
                                                                                    Ext.getCmp('mem292EF_CuelloH').allowBlank = true;
                                                                                    Ext.getCmp('mem292EF_CuelloH').setValue(null);
                                                                                    Ext.getCmp('mem292EF_CuelloH').disable();
                                                                                    Ext.getCmp('mem292EF_CuelloH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('mem292EF_CuelloH').enable();
                                                                                    Ext.getCmp('mem292EF_CuelloH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 5.2-5
                                                                width: 780,
                                                                colspan:4,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"EXANEN FISICO - CUELLO - HALLAZGOS",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'mem292EF_CuelloH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 5.1
                                                                        fieldLabel: 'Tórax',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NORMAL',
                                                                        name:"EXANEN FISICO - TORAX",
                                                                        id: 'str293EF_Torax',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() === "NORMAL"){
                                                                                    Ext.getCmp('mem294EF_ToraxH').allowBlank = true;
                                                                                    Ext.getCmp('mem294EF_ToraxH').setValue(null);
                                                                                    Ext.getCmp('mem294EF_ToraxH').disable();
                                                                                    Ext.getCmp('mem294EF_ToraxH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('mem294EF_ToraxH').enable();
                                                                                    Ext.getCmp('mem294EF_ToraxH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 5.2-5
                                                                width: 780,
                                                                colspan:4,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"EXANEN FISICO - TORAX - HALLAZGOS",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'mem294EF_ToraxH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 5.1
                                                                        fieldLabel: 'Abdomen',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NORMAL',
                                                                        name:"EXANEN FISICO - ABDOMEN",
                                                                        id: 'str295EF_Abdomen',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() === "NORMAL"){
                                                                                    Ext.getCmp('mem296EF_AbdomenH').setValue("RsIs: POSITIVOS NORMALES");
                                                                                }else{
                                                                                    Ext.getCmp('mem296EF_AbdomenH').setValue(null);
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 5.2-5
                                                                width: 780,
                                                                colspan:4,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"EXANEN FISICO - ABDOMEN - HALLAZGOS",
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: false,
                                                                        value: 'RsIs: POSITIVOS NORMALES',
                                                                        id: 'mem296EF_AbdomenH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', 
                                                                        fieldLabel: 'Sistema Genital',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NORMAL',
                                                                        name:"EXANEN FISICO - GENITALES",
                                                                        id: 'str297EF_Genitales',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() === "NORMAL"){
                                                                                    Ext.getCmp('mem298EF_GenitalesH').allowBlank = true;
                                                                                    Ext.getCmp('mem298EF_GenitalesH').setValue(null);
                                                                                    Ext.getCmp('mem298EF_GenitalesH').disable();
                                                                                    Ext.getCmp('mem298EF_GenitalesH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('mem298EF_GenitalesH').enable();
                                                                                    Ext.getCmp('mem298EF_GenitalesH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 5.2-5
                                                                width: 780,
                                                                colspan:4,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"EXANEN FISICO - GENITALES - HALLAZGOS",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        value: "NO SE EXPLORA",
                                                                        id: 'mem298EF_GenitalesH'
                                                                    }
                                                                ]
                                                            }, 
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', 
                                                                        fieldLabel: 'Aparato Músculo–Esquelético',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NORMAL',
                                                                        name:"EXANEN FISICO - MUSCULO ESQUELETICO",
                                                                        id: 'str299EF_Musculo',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() === "NORMAL"){
                                                                                    Ext.getCmp('mem300EF_MusculoH').allowBlank = true;
                                                                                    Ext.getCmp('mem300EF_MusculoH').setValue(null);
                                                                                    Ext.getCmp('mem300EF_MusculoH').disable();
                                                                                    Ext.getCmp('mem300EF_MusculoH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('mem300EF_MusculoH').enable();
                                                                                    Ext.getCmp('mem300EF_MusculoH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 5.2-5
                                                                width: 780,
                                                                colspan:4,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"EXANEN FISICO - MUSCULO ESQUELETICO - HALLAZGOS",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'mem300EF_MusculoH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', 
                                                                        fieldLabel: 'Sistema Vascular',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NORMAL',
                                                                        name:"EXANEN FISICO - SISTEMA VASCULAR",
                                                                        id: 'str301EF_Vascular',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() === "NORMAL"){
                                                                                    Ext.getCmp('mem302EF_VascularH').allowBlank = true;
                                                                                    Ext.getCmp('mem302EF_VascularH').setValue(null);
                                                                                    Ext.getCmp('mem302EF_VascularH').disable();
                                                                                    Ext.getCmp('mem302EF_VascularH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('mem302EF_VascularH').enable();
                                                                                    Ext.getCmp('mem302EF_VascularH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 5.2-5
                                                                width: 780,
                                                                colspan:4,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"EXANEN FISICO - SISTEMA VASCULAR",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'mem302EF_VascularH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', 
                                                                        fieldLabel: 'Sistema Nervioso',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NORMAL',
                                                                        name:"EXANEN FISICO - SISTEMA NERVIOSO",
                                                                        id: 'str303EF_Nervioso',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() === "NORMAL"){
                                                                                    Ext.getCmp('mem304EF_NerviosoH').allowBlank = true;
                                                                                    Ext.getCmp('mem304EF_NerviosoH').setValue(null);
                                                                                    Ext.getCmp('mem304EF_NerviosoH').disable();
                                                                                    Ext.getCmp('mem304EF_NerviosoH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('mem304EF_NerviosoH').enable();
                                                                                    Ext.getCmp('mem304EF_NerviosoH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 5.2-5
                                                                width: 780,
                                                                colspan:4,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"EXANEN FISICO - SISTEMA NERVIOSO",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'mem304EF_NerviosoH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 2.1
                                                                        fieldLabel: 'Piel',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NORMAL',
                                                                        name:"EXANEN FISICO - PIEL Y FANERAS",
                                                                        id: 'str305EF_PielFaneras',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() === "NORMAL"){
                                                                                    Ext.getCmp('mem306F_PielFanerasH').allowBlank = true;
                                                                                    Ext.getCmp('mem306F_PielFanerasH').setValue(null);
                                                                                    Ext.getCmp('mem306F_PielFanerasH').disable();
                                                                                    Ext.getCmp('mem306F_PielFanerasH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('mem306F_PielFanerasH').enable();
                                                                                    Ext.getCmp('mem306F_PielFanerasH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 2.2-5
                                                                width: 780,
                                                                colspan:4,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"EXANEN FISICO - PIEL Y FANERAS - HALLAZGOS",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'mem306F_PielFanerasH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', 
                                                                        fieldLabel: 'Estado Mental',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NORMAL',
                                                                        name:"EXANEN FISICO - GENITALES - ESFERA MENTAL",
                                                                        id: 'str307EF_EsfMental',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(Ext.getCmp('str307EF_EsfMental').getValue() === "NORMAL"){
                                                                                    Ext.getCmp('mem308EF_EsfMentalH').allowBlank = true;
                                                                                    Ext.getCmp('mem308EF_EsfMentalH').setValue(null);
                                                                                    Ext.getCmp('mem308EF_EsfMentalH').disable();
                                                                                    Ext.getCmp('mem308EF_EsfMentalH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('mem308EF_EsfMentalH').enable();
                                                                                    Ext.getCmp('mem308EF_EsfMentalH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 5.2-5
                                                                width: 780,
                                                                colspan:4,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"EXANEN FISICO - ESFERA MENTAL - HALLAZGOS",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'mem308EF_EsfMentalH'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'RESULTADO DE EXAMENES',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '99%',
                                                autoHeight: true,
                                                id: 'fs6r',
                                                items: [
                                                    {
                                                        xtype: 'panel',
                                                        layout: 'table',
                                                        unstyled: true,
                                                        layoutConfig: {
                                                            columns: 2
                                                        },
                                                        border: false,
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 5.1
                                                                        fieldLabel: 'Audiometria',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: stResLaboratorios,
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NO SE REALIZO',
                                                                        name:"RESULTADO EXAMENES - AUDIOMETRIA",
                                                                        id: 'str309RESEXA_Audiometria',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() !== "ANORMAL"){
                                                                                    Ext.getCmp('mem310RESEXA_AudiometriaH').allowBlank = true;
                                                                                    Ext.getCmp('mem310RESEXA_AudiometriaH').setValue(null);
                                                                                    Ext.getCmp('mem310RESEXA_AudiometriaH').disable();
                                                                                    Ext.getCmp('mem310RESEXA_AudiometriaH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('mem310RESEXA_AudiometriaH').enable();
                                                                                    Ext.getCmp('mem310RESEXA_AudiometriaH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 780,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"RESULTADO EXAMENES - AUDIOMETRIA - HALLAZGOS",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'mem310RESEXA_AudiometriaH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 5.1
                                                                        fieldLabel: 'Espirometria',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: stResLaboratorios,
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NO SE REALIZO',
                                                                        name:"RESULTADO EXAMENES - ESPIROMETRIA",
                                                                        id: 'str311RESEXA_Espirometria',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() !== "ANORMAL"){
                                                                                    Ext.getCmp('mem312RESEXA_EspirometriaH').allowBlank = true;
                                                                                    Ext.getCmp('mem312RESEXA_EspirometriaH').setValue(null);
                                                                                    Ext.getCmp('mem312RESEXA_EspirometriaH').disable();
                                                                                    Ext.getCmp('mem312RESEXA_EspirometriaH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('mem312RESEXA_EspirometriaH').enable();
                                                                                    Ext.getCmp('mem312RESEXA_EspirometriaH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 780,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name: "RESULTADO EXAMENES - ESPIROMETRIA - HALLAZGOS",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'mem312RESEXA_EspirometriaH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 5.1
                                                                        fieldLabel: 'Visiometria',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: stResLaboratorios,
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NO SE REALIZO',
                                                                        name:"RESULTADO EXAMENES - VISIOMETRIA",
                                                                        id: 'str313RESEXA_Visiometria',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() !== "ANORMAL"){
                                                                                    Ext.getCmp('mem314RESEXA_VisiometriaH').allowBlank = true;
                                                                                    Ext.getCmp('mem314RESEXA_VisiometriaH').setValue(null);
                                                                                    Ext.getCmp('mem314RESEXA_VisiometriaH').disable();
                                                                                    Ext.getCmp('mem314RESEXA_VisiometriaH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('mem314RESEXA_VisiometriaH').enable();
                                                                                    Ext.getCmp('mem314RESEXA_VisiometriaH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 780,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name: "RESULTADO EXAMENES - VISIOMETRIA - HALLAZGOS",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'mem314RESEXA_VisiometriaH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 5.1
                                                                        fieldLabel: 'Optometria',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: stResLaboratorios,
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NO SE REALIZO',
                                                                        name:"RESULTADO EXAMENES - OPTOMETRIA",
                                                                        id: 'str315RESEXA_Optometria',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() !== "ANORMAL"){
                                                                                    Ext.getCmp('mem316RESEXA_OptometriaH').allowBlank = true;
                                                                                    Ext.getCmp('mem316RESEXA_OptometriaH').setValue(null);
                                                                                    Ext.getCmp('mem316RESEXA_OptometriaH').disable();
                                                                                    Ext.getCmp('mem316RESEXA_OptometriaH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('mem316RESEXA_OptometriaH').enable();
                                                                                    Ext.getCmp('mem316RESEXA_OptometriaH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 780,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name: "RESULTADO EXAMENES - OPTOMETRIA - HALLAZGOS",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'mem316RESEXA_OptometriaH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 5.1
                                                                        fieldLabel: 'Hemograma',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: stResLaboratorios,
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NO SE REALIZO',
                                                                        name:"RESULTADO EXAMENES - HEMOGRAMA",
                                                                        id: 'str317RESEXA_Hemograma',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() !== "ANORMAL"){
                                                                                    Ext.getCmp('mem318RESEXA_HemogramaH').allowBlank = true;
                                                                                    Ext.getCmp('mem318RESEXA_HemogramaH').setValue(null);
                                                                                    Ext.getCmp('mem318RESEXA_HemogramaH').disable();
                                                                                    Ext.getCmp('mem318RESEXA_HemogramaH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('mem318RESEXA_HemogramaH').enable();
                                                                                    Ext.getCmp('mem318RESEXA_HemogramaH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 780,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name: "RESULTADO EXAMENES - HEMOGRAMA - HALLAZGOS",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'mem318RESEXA_HemogramaH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 5.1
                                                                        fieldLabel: 'Perfil Lipidico',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: stResLaboratorios,
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NO SE REALIZO',
                                                                        name:"RESULTADO EXAMENES - PERFIL LIPIDICO",
                                                                        id: 'str319RESEXA_PerfilLipidico',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() !== "ANORMAL"){
                                                                                    Ext.getCmp('mem320RESEXA_PerfilLipidicoH').allowBlank = true;
                                                                                    Ext.getCmp('mem320RESEXA_PerfilLipidicoH').setValue(null);
                                                                                    Ext.getCmp('mem320RESEXA_PerfilLipidicoH').disable();
                                                                                    Ext.getCmp('mem320RESEXA_PerfilLipidicoH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('mem320RESEXA_PerfilLipidicoH').enable();
                                                                                    Ext.getCmp('mem320RESEXA_PerfilLipidicoH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 780,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name: "RESULTADO EXAMENES - PERFIL LIPIDICO - HALLAZGOS",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'mem320RESEXA_PerfilLipidicoH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 5.1
                                                                        fieldLabel: 'Glicemia',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: stResLaboratorios,
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NO SE REALIZO',
                                                                        name:"RESULTADO EXAMENES - GLICEMIA",
                                                                        id: 'str321RESEXA_Glicemia',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() !== "ANORMAL"){
                                                                                    Ext.getCmp('mem322RESEXA_GlicemiaH').allowBlank = true;
                                                                                    Ext.getCmp('mem322RESEXA_GlicemiaH').setValue(null);
                                                                                    Ext.getCmp('mem322RESEXA_GlicemiaH').disable();
                                                                                    Ext.getCmp('mem322RESEXA_GlicemiaH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('mem322RESEXA_GlicemiaH').enable();
                                                                                    Ext.getCmp('mem322RESEXA_GlicemiaH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 780,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name: "RESULTADO EXAMENES - GLICEMIA - HALLAZGOS",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'mem322RESEXA_GlicemiaH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 5.1
                                                                        fieldLabel: 'Serologia',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: stResLaboratorios,
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NO SE REALIZO',
                                                                        name:"RESULTADO EXAMENES - SEROLOGIA",
                                                                        id: 'str323RESEXA_Serologia',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() !== "ANORMAL"){
                                                                                    Ext.getCmp('mem324RESEXA_SerologiaH').allowBlank = true;
                                                                                    Ext.getCmp('mem324RESEXA_SerologiaH').setValue(null);
                                                                                    Ext.getCmp('mem324RESEXA_SerologiaH').disable();
                                                                                    Ext.getCmp('mem324RESEXA_SerologiaH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('mem324RESEXA_SerologiaH').enable();
                                                                                    Ext.getCmp('mem324RESEXA_SerologiaH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 780,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name: "RESULTADO EXAMENES - SEROLOGIA - HALLAZGOS",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'mem324RESEXA_SerologiaH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 5.1
                                                                        fieldLabel: 'Serologia',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: stResLaboratorios,
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NO SE REALIZO',
                                                                        name:"RESULTADO EXAMENES - UROANALISIS",
                                                                        id: 'str325RESEXA_Uroanalisis',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() !== "ANORMAL"){
                                                                                    Ext.getCmp('mem326RESEXA_UroanalisisH').allowBlank = true;
                                                                                    Ext.getCmp('mem326RESEXA_UroanalisisH').setValue(null);
                                                                                    Ext.getCmp('mem326RESEXA_UroanalisisH').disable();
                                                                                    Ext.getCmp('mem326RESEXA_UroanalisisH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('mem326RESEXA_UroanalisisH').enable();
                                                                                    Ext.getCmp('mem326RESEXA_UroanalisisH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 780,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name: "RESULTADO EXAMENES - UROANALISIS - HALLAZGOS",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'mem326RESEXA_UroanalisisH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 5.1
                                                                        fieldLabel: 'Baciloscopia',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: stResLaboratorios,
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NO SE REALIZO',
                                                                        name:"RESULTADO EXAMENES - BACILOSCOPIA",
                                                                        id: 'str327RESEXA_Baciloscopia',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() !== "ANORMAL"){
                                                                                    Ext.getCmp('mem328RESEXA_BaciloscopiaH').allowBlank = true;
                                                                                    Ext.getCmp('mem328RESEXA_BaciloscopiaH').setValue(null);
                                                                                    Ext.getCmp('mem328RESEXA_BaciloscopiaH').disable();
                                                                                    Ext.getCmp('mem328RESEXA_BaciloscopiaH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('mem328RESEXA_BaciloscopiaH').enable();
                                                                                    Ext.getCmp('mem328RESEXA_BaciloscopiaH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 780,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name: "RESULTADO EXAMENES - BACILOSCOPIA - HALLAZGOS",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'mem328RESEXA_BaciloscopiaH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 5.1
                                                                        fieldLabel: 'Coprologico',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: stResLaboratorios,
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NO SE REALIZO',
                                                                        name:"RESULTADO EXAMENES - COPROLOGICO",
                                                                        id: 'str329RESEXA_Coprologico',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() !== "ANORMAL"){
                                                                                    Ext.getCmp('mem330RESEXA_CoprologicoH').allowBlank = true;
                                                                                    Ext.getCmp('mem330RESEXA_CoprologicoH').setValue(null);
                                                                                    Ext.getCmp('mem330RESEXA_CoprologicoH').disable();
                                                                                    Ext.getCmp('mem330RESEXA_CoprologicoH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('mem330RESEXA_CoprologicoH').enable();
                                                                                    Ext.getCmp('mem330RESEXA_CoprologicoH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 780,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name: "RESULTADO EXAMENES - COPROLOGICO - HALLAZGOS",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'mem330RESEXA_CoprologicoH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 5.1
                                                                        fieldLabel: 'Coprocultivo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: stResLaboratorios,
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NO SE REALIZO',
                                                                        name:"RESULTADO EXAMENES - COPROCULTIVO",
                                                                        id: 'str331RESEXA_Coprocultivo',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() !== "ANORMAL"){
                                                                                    Ext.getCmp('mem332RESEXA_CoprocultivoH').allowBlank = true;
                                                                                    Ext.getCmp('mem332RESEXA_CoprocultivoH').setValue(null);
                                                                                    Ext.getCmp('mem332RESEXA_CoprocultivoH').disable();
                                                                                    Ext.getCmp('mem332RESEXA_CoprocultivoH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('mem332RESEXA_CoprocultivoH').enable();
                                                                                    Ext.getCmp('mem332RESEXA_CoprocultivoH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 780,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name: "RESULTADO EXAMENES - FROTIS FARINGEO - HALLAZGOS",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'mem332RESEXA_CoprocultivoH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 5.1
                                                                        fieldLabel: 'Frotis Faringeo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: stResLaboratorios,
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NO SE REALIZO',
                                                                        name:"RESULTADO EXAMENES - FROTIS FARINGEO",
                                                                        id: 'str333RESEXA_FrotisFaringeo',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() !== "ANORMAL"){
                                                                                    Ext.getCmp('mem334RESEXA_FrotisFaringeoH').allowBlank = true;
                                                                                    Ext.getCmp('mem334RESEXA_FrotisFaringeoH').setValue(null);
                                                                                    Ext.getCmp('mem334RESEXA_FrotisFaringeoH').disable();
                                                                                    Ext.getCmp('mem334RESEXA_FrotisFaringeoH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('mem334RESEXA_FrotisFaringeoH').enable();
                                                                                    Ext.getCmp('mem334RESEXA_FrotisFaringeoH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 780,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name: "RESULTADO EXAMENES - FROTIS FARINGEO - HALLAZGOS",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'mem334RESEXA_FrotisFaringeoH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 5.1
                                                                        fieldLabel: 'Frotis Uñas',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: stResLaboratorios,
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NO SE REALIZO',
                                                                        name:"RESULTADO EXAMENES - FROTIS UÑAS",
                                                                        id: 'str335RESEXA_FrotisUnas',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() !== "ANORMAL"){
                                                                                    Ext.getCmp('mem336RESEXA_FrotisUnasH').allowBlank = true;
                                                                                    Ext.getCmp('mem336RESEXA_FrotisUnasH').setValue(null);
                                                                                    Ext.getCmp('mem336RESEXA_FrotisUnasH').disable();
                                                                                    Ext.getCmp('mem336RESEXA_FrotisUnasH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('mem336RESEXA_FrotisUnasH').enable();
                                                                                    Ext.getCmp('mem336RESEXA_FrotisUnasH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 780,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name: "RESULTADO EXAMENES - FROTIS UÑAS - HALLAZGOS",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'mem336RESEXA_FrotisUnasH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 5.1
                                                                        fieldLabel: 'Electrocardiograma',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: stResLaboratorios,
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NO SE REALIZO',
                                                                        name:"RESULTADO EXAMENES - ELECTROCARDIOGRAMA",
                                                                        id: 'str337RESEXA_Electrocardiograma',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() !== "ANORMAL"){
                                                                                    Ext.getCmp('mem338RESEXA_ElectrocardiogramaH').allowBlank = true;
                                                                                    Ext.getCmp('mem338RESEXA_ElectrocardiogramaH').setValue(null);
                                                                                    Ext.getCmp('mem338RESEXA_ElectrocardiogramaH').disable();
                                                                                    Ext.getCmp('mem338RESEXA_ElectrocardiogramaH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('mem338RESEXA_ElectrocardiogramaH').enable();
                                                                                    Ext.getCmp('mem338RESEXA_ElectrocardiogramaH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 780,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name: "RESULTADO EXAMENES - ELECTROCARDIOGRAMA - HALLAZGOS",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'mem338RESEXA_ElectrocardiogramaH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 5.1
                                                                        fieldLabel: 'Test Acrofobia',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: stResLaboratorios,
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NO SE REALIZO',
                                                                        name:"RESULTADO EXAMENES - TEST ACROFOBIA",
                                                                        id: 'str339RESEXA_TestAcrofobia',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() !== "ANORMAL"){
                                                                                    Ext.getCmp('mem340RESEXA_TestAcrofobiaH').allowBlank = true;
                                                                                    Ext.getCmp('mem340RESEXA_TestAcrofobiaH').setValue(null);
                                                                                    Ext.getCmp('mem340RESEXA_TestAcrofobiaH').disable();
                                                                                    Ext.getCmp('mem340RESEXA_TestAcrofobiaH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('mem340RESEXA_TestAcrofobiaH').enable();
                                                                                    Ext.getCmp('mem340RESEXA_TestAcrofobiaH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 780,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name: "RESULTADO EXAMENES - TEST ACROFOBIA - HALLAZGOS",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'mem340RESEXA_TestAcrofobiaH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 5.1
                                                                        fieldLabel: 'Pruebas Vestibulares',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: stResLaboratorios,
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NO SE REALIZO',
                                                                        name:"RESULTADO EXAMENES - PRUEBAS VESTIBULARES",
                                                                        id: 'str341RESEXA_PruebasVestibulares',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() !== "ANORMAL"){
                                                                                    Ext.getCmp('mem342RESEXA_PruebasVestibularesH').allowBlank = true;
                                                                                    Ext.getCmp('mem342RESEXA_PruebasVestibularesH').setValue(null);
                                                                                    Ext.getCmp('mem342RESEXA_PruebasVestibularesH').disable();
                                                                                    Ext.getCmp('mem342RESEXA_PruebasVestibularesH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('mem342RESEXA_PruebasVestibularesH').enable();
                                                                                    Ext.getCmp('mem342RESEXA_PruebasVestibularesH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 780,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name: "RESULTADO EXAMENES - PRUEBAS VESTIBULARES - HALLAZGOS",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'mem342RESEXA_PruebasVestibularesH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 5.1
                                                                        fieldLabel: 'Pruebas Atleticas',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: stResLaboratorios,
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NO SE REALIZO',
                                                                        name:"RESULTADO EXAMENES - PRUEBAS FISICO ATLETICAS",
                                                                        id: 'str343RESEXA_PruebasFisicoAtleticas',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() !== "ANORMAL"){
                                                                                    Ext.getCmp('mem344RESEXA_PruebasFisicoAtleticasH').allowBlank = true;
                                                                                    Ext.getCmp('mem344RESEXA_PruebasFisicoAtleticasH').setValue(null);
                                                                                    Ext.getCmp('mem344RESEXA_PruebasFisicoAtleticasH').disable();
                                                                                    Ext.getCmp('mem344RESEXA_PruebasFisicoAtleticasH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('mem344RESEXA_PruebasFisicoAtleticasH').enable();
                                                                                    Ext.getCmp('mem344RESEXA_PruebasFisicoAtleticasH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 780,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name: "RESULTADO EXAMENES - PRUEBAS FISICO ATLETICAS - HALLAZGOS",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'mem344RESEXA_PruebasFisicoAtleticasH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 890,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                colspan: 2,
                                                                autoHeight: true,
                                                                items: [
                                                                    {    
                                                                        xtype: 'compositefield',
                                                                        style: 'background:transparent;',
                                                                        items: [
                                                                            {
                                                                                xtype: 'textfield',
                                                                                anchor:'100%',
                                                                                fieldLabel:'Grupo Sanguineo',
                                                                                name:'RESULTADO EXAMENES - GRUPO SANGUINEO',
                                                                                width:50,
                                                                                allowBlank: true,
                                                                                id: 'str345GrupoSanguineo'   
                                                                            },
                                                                            {
                                                                                html: 'RH:'
                                                                            },
                                                                            {
                                                                                xtype: 'textfield',
                                                                                anchor:'100%',
                                                                                name:'RESULTADO EXAMENES - RH',
                                                                                width:50,
                                                                                allowBlank: true,
                                                                                id: 'str346RH'   
                                                                            }
                                                                        ]
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 890,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                colspan: 2,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel:'Otros',
                                                                        anchor:'100%',
                                                                        name:'RESULTADO EXAMENES - OTROS',
                                                                        allowBlank: true,
                                                                        id: 'str347Otros'   
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'DIAGNOSTICO',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '99%',
                                                autoHeight: true,
                                                id: 'fs11',
                                                items: [
                                                    {
                                                        xtype: 'combo', 
                                                        fieldLabel: 'Paciente Aparentemente Sano',
                                                        name: 'PACIENTE APARENTEMENTE SANO',
                                                        width: 100,
                                                        allowBlank: false,
                                                        store: 'StoreSiNo',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        value: 'SI',
                                                        id: 'str348Dx_PacienteSano'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: false,
                                                                fieldLabel: 'Diagnostico Principal',
                                                                id: 'sysDiagPpalHC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() === e.ENTER || e.getKey() === e.TAB)
                                                                        {
                                                                            if (f.getValue() !== "" && f.getValue() !== null && f.getValue().toUpperCase() !== Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() !== Ext.getCmp('sysDiagRel2HC').getValue() && f.getValue().toUpperCase() !== Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request({
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                        Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    },
                                                                    blur: function(t){
                                                                        if(Ext.getCmp('sysDiagPpalHCNom').getValue() === null || Ext.getCmp('sysDiagPpalHCNom').getValue() === "")
                                                                        {
                                                                            if (Ext.getCmp('sysDiagPpalHC').getValue() !== "" && Ext.getCmp('sysDiagPpalHC').getValue() !== null && Ext.getCmp('sysDiagPpalHC').getValue().toUpperCase() !== Ext.getCmp('sysDiagRel1HC').getValue() && Ext.getCmp('sysDiagPpalHC').getValue().toUpperCase() !== Ext.getCmp('sysDiagRel2HC').getValue() && Ext.getCmp('sysDiagPpalHC').getValue().toUpperCase() !== Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request({
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: Ext.getCmp('sysDiagPpalHC').getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                        Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagPpalHCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Principal',
                                                                id: 'btnSearchDiagPpalHC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagPpalHC','sysDiagPpalHCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.1',
                                                                id: 'sysDiagRel1HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() === e.ENTER || e.getKey() === e.TAB)
                                                                        {
                                                                            if (f.getValue() !== "" && f.getValue() !== null && f.getValue().toUpperCase() !== Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() !== Ext.getCmp('sysDiagRel2HC').getValue() && f.getValue().toUpperCase() !== Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    },
                                                                    blur: function(t){
                                                                        if (Ext.getCmp('sysDiagRel1HCNom').getValue === null ||  Ext.getCmp('sysDiagRel1HCNom').getValue() === "")
                                                                        {
                                                                            if (Ext.getCmp('sysDiagRel1HC').getValue() !== "" && Ext.getCmp('sysDiagRel1HC').getValue() !== null && Ext.getCmp('sysDiagRel1HC').getValue().toUpperCase() !== Ext.getCmp('sysDiagPpalHC').getValue() && Ext.getCmp('sysDiagRel1HC').getValue().toUpperCase() !== Ext.getCmp('sysDiagRel2HC').getValue() && Ext.getCmp('sysDiagRel1HC').getValue().toUpperCase() !== Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: Ext.getCmp('sysDiagRel1HC').getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel1HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado1',
                                                                id: 'btnSearchDiagRel1HC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel1HC','sysDiagRel1HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.2',
                                                                id: 'sysDiagRel2HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() === e.ENTER || e.getKey() === e.TAB)
                                                                        {
                                                                            if (f.getValue() !== "" && f.getValue() !== null && f.getValue().toUpperCase() !== Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() !== Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() !== Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    },
                                                                    blur: function(t){
                                                                        if (Ext.getCmp('sysDiagRel2HCNom').getValue === null || Ext.getCmp('sysDiagRel2HCNom').getValue() === "")
                                                                        {
                                                                            if (Ext.getCmp('sysDiagRel2HC').getValue() !== "" && Ext.getCmp('sysDiagRel2HC').getValue() !== null && Ext.getCmp('sysDiagRel2HC').getValue().toUpperCase() !== Ext.getCmp('sysDiagPpalHC').getValue() && Ext.getCmp('sysDiagRel2HC').getValue().toUpperCase() !== Ext.getCmp('sysDiagRel1HC').getValue() && Ext.getCmp('sysDiagRel2HC').getValue().toUpperCase() !== Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: Ext.getCmp('sysDiagRel2HC').getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel2HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado2',
                                                                id: 'btnSearchDiagRel2HC1',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel2HC','sysDiagRel2HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.3',
                                                                id: 'sysDiagRel3HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() === e.ENTER || e.getKey() === e.TAB)
                                                                        {
                                                                            if (f.getValue() !== "" && f.getValue() !== null && f.getValue().toUpperCase() !== Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() !== Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() !== Ext.getCmp('sysDiagRel2HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    },
                                                                    blur: function(t){
                                                                        if (Ext.getCmp('sysDiagRel3HCNom').getValue === null || Ext.getCmp('sysDiagRel3HCNom').getValue() === "")
                                                                        {
                                                                            if (Ext.getCmp('sysDiagRel3HC').getValue() !== "" && Ext.getCmp('sysDiagRel3HC').getValue() !== null && Ext.getCmp('sysDiagRel3HC').getValue().toUpperCase() !== Ext.getCmp('sysDiagPpalHC').getValue() && Ext.getCmp('sysDiagRel3HC').getValue().toUpperCase() !== Ext.getCmp('sysDiagRel1HC').getValue() && Ext.getCmp('sysDiagRel3HC').getValue().toUpperCase() !== Ext.getCmp('sysDiagRel2HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: Ext.getCmp('sysDiagRel3HC').getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel3HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado3',
                                                                id: 'btnSearchDiagRel3HC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel3HC','sysDiagRel3HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Tipo de Diagnostico',
                                                        width:750,
                                                        name: 'Tipo de Diagnostico',
                                                        allowBlank: false,
                                                        store: 'StoreTipoDiagnostico',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: '1',
                                                        id: 'sysTipoDiagosticoHC'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Finalidad Consulta',
                                                        width:750,
                                                        name: 'Finalidad Consulta',
                                                        allowBlank: false,
                                                        store: 'StoreFinalidadConsulta',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 10,
                                                        id: 'sysFinalidadConsultaHC'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Causa Externa',
                                                        width:750,
                                                        name: 'Causa Externa',
                                                        allowBlank: false,
                                                        store: 'StoreCausaExterna',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 15,
                                                        id: 'sysCausaExternaHC'
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        fieldLabel: 'Otros Diagnosticos Relacionados',
                                                        name: 'Otros Diagnosticos Relacionados',
                                                        height: 50, 
                                                        grow: true,
                                                        minGrow: 50,
                                                        allowBlank: true  ,
                                                        id: 'memResumenDx'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'CONCEPTO',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '99%',
                                                autoHeight: true,
                                                id: 'fs13',
                                                items: [
                                                     {
                                                        xtype: 'panel',
                                                        layout: 'table',
                                                        columns: 3,
                                                        border: false,
                                                        items: [
                                                            {
                                                                xtype: 'panel', // col 4.1
                                                                width: 105,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: []
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 400,
                                                                layout: 'form',
                                                                labelWidth: 250,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'APTO SIN RESTRICCIONES',
                                                                        name: 'APTO SIN RESTRICCIONES',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bol349CONCEPAptoSinRest'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'APTO CON RESTRICCIONES',
                                                                        name: 'APTO CON RESTRICCIONES',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bol350CONCEPAptoConRest'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'APTO CON CONDICIONES',
                                                                        name: 'APTO CON CONDICIONES',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bol351CONCEPAptoConCondi'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'APTO CON RECOMENDACION',
                                                                        name: 'APTO CON RECOMENDACION',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bol352CONCEPAptoConRecomenda'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'APTO PARA MANIPULAR ALIMENTOS',
                                                                        name: 'APTO PARA MANIPULAR ALIMENTOS',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bol353CONCEPAptoManipulaAlimen'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'APTO PARA MANIPULAR CARGAS',
                                                                        name: 'APTO PARA MANIPULAR CARGAS',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bol353_1CONCEPAptoManipulaCargas'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'APTO PARA TRABAJAR EN ESPACIOS CONFINADOS',
                                                                        name: 'APTO PARA TRABAJAR EN ESPACIOS CONFINADOS',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bol354CONCEPAptoTrabajoEspacios'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'APTO PARA TRABAJAR EN ALTURAS',
                                                                        name: 'APTO PARA TRABAJAR EN ALTURAS',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bol355CONCEPAptoTrabajoAlturas'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'PACIENTE APARENTEMENTE SANO',
                                                                        name: 'PACIENTE APARENTEMENTE SANO',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bol356CONCEPPacienteSano'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 400,
                                                                layout: 'form',
                                                                labelWidth: 250,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'NO APTO TEMPORALMENTE',
                                                                        name: 'NO APTO TEMPORALMENTE',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bol357CONCEPNoAptoTempo'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'NO APTO',
                                                                        name: 'NO APTO',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bol358CONCEPNoApto'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'POSIBLE PATOLOGIA ORIGEN LABORAL',
                                                                        name: 'POSIBLE PATOLOGIA ORIGEN LABORAL',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bol359CONCEPPatologiaLaboral'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'CON SECUELAS DE ACCIDENTE LABORAL',
                                                                        name: 'CON SECUELAS DE ACCIDENTE LABORAL',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bol360CONCEPSecuelasLaboral'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'EXAMEN PERIODICO NORMAL',
                                                                        name: 'EXAMEN PERIODICO NORMAL',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bol361CONCEPExamenPeriodicoNormal'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'EXAMEN RETIRO NORMAL',
                                                                        name: 'EXAMEN RETIRO NORMAL',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bol362CONCEPExamenRetiroNormal'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'PACIENTE CON PROBALE ENFERMEDAD PROFESIONAL',
                                                                        name: 'PACIENTE CON PROBALE ENFERMEDAD PROFESIONAL',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bol363CONCEPProbableEnfProfesional'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'PACIENTE CON SECUELAS DE ACCIDENTE DE TRABAJO',
                                                                        name: 'PACIENTE CON SECUELAS DE ACCIDENTE DE TRABAJO',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bol364CONCEPSecuelasAccidenteTrabajo'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                     },
                                                     {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        fieldLabel: 'Descripción',
                                                        height: 50,            
                                                        grow: true,
                                                        minGrow: true,
                                                        allowBlank: true,
                                                        id: 'mem365Concepto'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'TIPO DE RESTRICCIONES O CAUSA DE APLAZAMIENTO',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '99%',
                                                autoHeight: true,
                                                id: 'fs12',
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        fieldLabel: 'Descripción',
                                                        name: 'TIPO DE RESTRICCIONES O CAUSA DE APLAZAMIENTO',
                                                        height: 50,            
                                                        grow: true,
                                                        minGrow: true,
                                                        allowBlank: false,
                                                        value: 'NINGUNO',
                                                        id: 'mem366Restricciones'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'INGRESO A PROGRAMAS ESPECIALES',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '99%',
                                                autoHeight: true,
                                                id: 'fs19',
                                                items: [
                                                    {
                                                        xtype: 'panel',
                                                        layout: 'table',
                                                        columns: 3,
                                                        border: false,
                                                        items: [
                                                            {
                                                                xtype: 'panel', // col 4.1
                                                                width: 105,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: []
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 400,
                                                                layout: 'form',
                                                                labelWidth: 250,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'CARDIOVASCULAR',
                                                                        name: 'CARDIOVASCULAR',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bol367RECOMENCardiovascular'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'ERGONÓMICO',
                                                                        name: 'ERGONÓMICO',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bol368RECOMENErgonomico'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'VISUAL',
                                                                        name: 'VISUAL',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bol369RECOMENVisual'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'PSICOSOCIAL',
                                                                        name: 'PSICOSOCIAL',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bol370RECOMENPsicosocial'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'BIOLÓGICO',
                                                                        name: 'BIOLÓGICO',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bol371RECOMENBiologico'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'RUIDO',
                                                                        name: 'RUIDO',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bol372RECOMENRuido'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'RADIACIÓN IONIZANTE',
                                                                        name: 'RADIACIÓN IONIZANTE',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bol373RECOMENRadiacionIonizante'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'RADIACIÓN NO IONIZANTE',
                                                                        name: 'RADIACIÓN NO IONIZANTE',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bol374RECOMENRadiacionNoIonizante'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        fieldLabel: 'Seguimiento de Salud Ocupacional',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'str375RECOMENSegtoSaludOcupacSO'
                                                                    }                                                                    
                                                                ]
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'RECOMENDACIONES',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '99%',
                                                autoHeight: true,
                                                id: 'fs15',
                                                items: [
                                                    {
                                                        xtype: 'panel',
                                                        layout: 'table',
                                                        columns: 3,
                                                        border: false,
                                                        items: [
                                                            {
                                                                xtype: 'panel', // col 4.1
                                                                width: 105,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: []
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 400,
                                                                layout: 'form',
                                                                labelWidth: 250,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'USO ADECUADO DE ELEMENTOS DE PROTECCION',
                                                                        name: 'USO ADECUADO DE ELEMENTOS DE PROTECCION',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bol376RECOMENUsoAdecuadoElem'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'CONTROL ANUAL POR OPTOMETRIA EN LA EPS',
                                                                        name: 'CONTROL ANUAL POR OPTOMETRIA EN LA EPS',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bol377RECOMENControlAnualOptometria'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'REALIZAR PAUSAS ACTIVAS',
                                                                        name: 'REALIZAR PAUSAS ACTIVAS',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bol378RECOMENRealizaPausasActivas'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'DEBE CERTIFICARSE PARA TRABJAR EN ALTURAS',
                                                                        name: 'DEBE CERTIFICARSE PARA TRABJAR EN ALTURAS',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bol379RECOMENCertificarTrabajoAlturas'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'USAR MEDIAS DE SOPORTE ELASTICO PARA VARICES',
                                                                        name: 'USAR MEDIAS DE SOPORTE ELASTICO PARA VARICES',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bol380RECOMENUsarMediasVarices'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'REALIZAR CITOLOGIA ANUAL',
                                                                        name: 'REALIZAR CITOLOGIA ANUAL',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bol381RECOMENRealizarCitologia'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'REALIZAR DIETA, EJERCICIO Y REDUCIR PESO',
                                                                        name: 'REALIZAR DIETA, EJERCICIO Y REDUCIR PESO',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bol382RECOMENRealizarDietaEjercicio'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 400,
                                                                layout: 'form',
                                                                labelWidth: 250,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'EVALUAR POR NUTRICION EN LA EPS',
                                                                        name: 'EVALUAR POR NUTRICION EN LA EPS',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bol383RECOMENEvaluarxNutricion'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'DEJAR EL HABITO DE FUMAR',
                                                                        name: 'DEJAR EL HABITO DE FUMAR',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bol384RECOMENDejarFumar'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'DISMINUIR CONSUMO DE ALCOHOL',
                                                                        name: 'DISMINUIR CONSUMO DE ALCOHOL',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bol385RECOMENDisminuirConsumoAlcohol'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'INGRESAR AL SISTEMA DE VIGILANCIA EPIDEMIOLOGICA',
                                                                        name: 'INGRESAR AL SISTEMA DE VIGILANCIA EPIDEMIOLOGICA',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bol386RECOMENIngresarProgaEpidemio'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'REALIZAR PRUEBAS PARA MANIPULACION DE ALIMENTOS',
                                                                        name: 'REALIZAR PRUEBAS PARA MANIPULACION DE ALIMENTOS',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bol387RECOMENPruebasManipulaAlimentos'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'REALIZAR PRUEBAS COMPLEMENTARIAS',
                                                                        name: 'REALIZAR PRUEBAS COMPLEMENTARIAS',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bol388RECOMENPruebasComplementarias'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        fieldLabel: 'Otros',
                                                        name: 'OTROS',
                                                        height: 50,            
                                                        grow: true,
                                                        minGrow: true,
                                                        allowBlank: true,
                                                        id: 'mem389RECOMENOtros'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'OBSERVACIONES FINALES',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '99%',
                                                autoHeight: true,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        fieldLabel: 'OBSERVACIONES',
                                                        name: 'OBSERVACIONES',
                                                        height: 50,            
                                                        grow: true,
                                                        minGrow: true,
                                                        allowBlank: true,
                                                        id: 'mem391ObservacionesFin'
                                                    }
                                                ]
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'HISTORIAL LABORAL',
                                //autoHeight: true,
                                //height: 300,
                                autoScroll: true,
                                frame: true,
                                border: false,
                                id: 'fichaHistorialLaboral',
                                layout: 'form',
                                items: [
                                     {
                                        xtype: 'grid',
                                        title: ' ',
                                        id: 'gridHistorialLaboral',
                                        store: stGridHistorialLaboral,
                                        anchor: "100%",
                                        height: 320,
                                        border: false,
                                        frame: true,
                                        loadMask: true,
                                        colModel: new Ext.ux.grid.LockingColumnModel([
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Id',
                                                sortable: false,
                                                width: 1,
                                                hidden: true,
                                                hideable: false,
                                                dataIndex: 'idConsecutivo',
                                                id: 'idConsecutivo'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Paciente',
                                                sortable: false,
                                                width: 1,
                                                hidden: true,
                                                hideable: false,
                                                dataIndex: 'idPaciente',
                                                id: 'idPaciente'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Empresa',
                                                sortable: false,
                                                width: 250,
                                                dataIndex: 'descEmpresa',
                                                id: 'descEmpresa'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Cargo',
                                                sortable: false,
                                                width: 180,
                                                dataIndex: 'descCargo',
                                                id: 'descCargo'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Tiempo',
                                                sortable: false,
                                                width: 150,
                                                dataIndex: 'descTiempo',
                                                id: 'descTiempo'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Riesgo',
                                                sortable: false,
                                                width: 150,
                                                dataIndex: 'descRisego',
                                                renderer: DescripcionGrid,
                                                id: 'descRisego'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Elementos Protección',
                                                sortable: false,
                                                width: 150,
                                                dataIndex: 'descElementos',
                                                renderer: DescripcionGrid,
                                                id: 'descElementos'
                                            }
                                        ]),
                                        selModel: new Ext.grid.RowSelectionModel({singleSelect:false}),
                                        iconCls:'icon-grid',
                                        //view: new Ext.grid.GroupingView(),
                                        tbar:
                                            {
                                                xtype: 'toolbar',
                                                items: [
                                                    {
                                                        xtype: 'button',
                                                        text: 'Adicionar Registro',
                                                        iconCls: 'btnAddRow',
                                                        id: 'btnAddHistorialLaboral',
                                                        listeners: {
                                                            click : function() {
                                                                var winHistorialLobral = new winAddHistorialLaboralPartisaludUi();
                                                                Ext.getCmp('intPacienteHistoLaboral').setValue(Ext.getCmp('sysIdPacienteHC').getValue());
                                                                winHistorialLobral.show();
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'tbseparator'
                                                    },
                                                    {
                                                        xtype: 'button',
                                                        text: 'Eliminar Registro',
                                                        iconCls: 'btnDelRow',
                                                        id: 'btnDelHistorialLaboral',
                                                        listeners: {
                                                            click : function() {
                                                                 if(Ext.getCmp('gridHistorialLaboral').selModel.getCount() === 1)
                                                                {
                                                                    var selections = Ext.getCmp('gridHistorialLaboral').selModel.getSelections();
                                                                    Ext.Msg.show({
                                                                        title: 'Historial Laboral',
                                                                        msg: 'Esta Seguro que Desea Eliminar el Registro ' + selections[0].json.descEmpresa + ', ' + selections[0].json.descCargo + '?',
                                                                        buttons: Ext.Msg.YESNO,
                                                                        icon: Ext.Msg.QUESTION,
                                                                        fn: function(btn)
                                                                        {
                                                                            if(btn === "yes"){
                                                                                fnEliminarRegistros("../../controlador/asistencial/saludocupacional.php",{task: "ELIMINAR_HISTORIAL_LABORAL", pIdHistorial: selections[0].json.idConsecutivo}, 'gridHistorialLaboral');
                                                                            }
                                                                        }
                                                                    });
                                                                }else{
                                                                    Ext.MessageBox.show({
                                                                        title: 'Error',
                                                                        msg: 'No podemos eliminar los registros en estos momentos, verifique que solo haya seleccionado un registro',
                                                                        buttons: Ext.MessageBox.OK,
                                                                        icon: Ext.MessageBox.ERROR
                                                                    });
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'tbseparator'
                                                    }
                                                ]
                                            }
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'VALORACION DE EQUILIBRIO',
                                //autoHeight: true,
                                //height: 300,
                                autoScroll: true,
                                frame: true,
                                border: false,
                                id: 'fichaAnexoEquilibrio',
                                layout: 'form',
                                items: [
                                    AnexoEquilibrio
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Medicamentos',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaMedicamentos',
                                items: [
                                    xSolMX
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Servicios',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaServicios',
                                items: [
                                    xSolEXA
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Remisiones',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaRemisiones',
                                items: [
                                    xSolREM
                                ]
                            }
                        ]
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btnSalirEvolucion',
                            listeners:{
                                click : function(){
                                    if (parseInt(Ext.getCmp('sysYaGuardoHC').getValue()) === 1){ 
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn === "yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    }else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Usted no ha guardado la historia clinica y se perdera la informacion. Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn){
                                                if(btn === "yes"){
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                }
            }
        ];
        this.on({
            afterlayout:{scope:this, single:true, fn:function() {
                Ext.Msg.hide();
            }}
        }); 
        winHCSaludOcupacionalUi.superclass.initComponent.call(this);
    }
});

function fnGuardarRegistrosMedicinaLaboral(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc.php',
            params:{
                task: 'guardar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pidPlantillaHC : Ext.getCmp('sysIdCodPlantillaHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function fnModificarRegistrosMedicinaLaboral(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc.php',
            params:{
                task: 'modificar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}