/*
* @category    Formulario Modelo Evolucion Historia Clinica Colposcopia
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winHCColposcopia001Ui = Ext.extend(Ext.Window, {
    title: 'eOfiClinic ©  .:: Plantilla HC Colposcopia ::.',
    width: 990,
    height: 636,
    closable: false,
    resizable: false,
    draggable: false,
    modal: true,
    id: 'winHC',
    initComponent: function() {
           
        tmpmx = objMX;
        tmpmxadd = objMXADD;
        tmpexa = objEXA;
        tmprem = objREM;
        myPaciente = 0;
        myCAS = 0;

        try {
            var campo = Ext.getCmp('sysPacientePlantillaHC');
            if ( campo != null ) {
                myPaciente = Ext.getCmp('sysPacientePlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myPaciente == 0){
            try {
                var campo1 = Ext.getCmp('sysIdPacienteHC');
                if ( campo1 != null ) {
                    myPaciente = Ext.getCmp('sysIdPacienteHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myPaciente == 0){
            try {
                var campo5 = Ext.getCmp('sysPacienteRefHC');
                if ( campo5 != null ) {
                    myPaciente = Ext.getCmp('sysPacienteRefHC').getValue();
                }
            }catch(ex){
            }
        }
        try {
            var campo2 = Ext.getCmp('sysCASPlantillaHC');
            if ( campo2 != null ) {
                myCAS = Ext.getCmp('sysCASPlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myCAS == 0){
            try {
                var campo3 = Ext.getCmp('sysCASHC');
                if ( campo3 != null ) {
                    myCAS = Ext.getCmp('sysCASHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myCAS == 0){
            try {
                var campo4 = Ext.getCmp('sysCASRefHC');
                if ( campo4 != null ) {
                    myCAS = Ext.getCmp('sysCASRefHC').getValue();
                }
            }catch(ex){
            }
        }
        if (objMX != "NA"){
            var xSolMX = eval(objMX);
            Ext.getCmp('gridMedicamentosHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }
        else{
            var xSolMX = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        if (objEXA != "NA"){
            var xSolEXA = eval(objEXA);
            Ext.getCmp('gridExamenesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }else{
            var xSolEXA = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        if (objREM != "NA"){
            var xSolREM = eval(objREM);
            Ext.getCmp('gridRemisionesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }else{
            var xSolREM = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }

        var dataColposcopiaInsatisfactoria = [
            ['por no haber visto toda la UEC'],
            ['por no haber visto toda la lesion']
        ];
        var stColposcopiaInsatisfactoria = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stColposcopiaInsatisfactoria.loadData(dataColposcopiaInsatisfactoria);
        
        var dataDxColposcopia = [
            ['SATISFACTORIO'],
            ['INSATISFACTORIO']
        ];
        var stDxColposcopia = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stDxColposcopia.loadData(dataDxColposcopia);
        
        var dataClasificaColposcopia = [
            ['SATISFACTORIA ATIPICA'],
            ['SATISFACTORIA TIPICA'],
            ['INSATISFACTORIA ATIPICA'],
            ['INSATISFACTORIA TIPICA']
        ];
        var stClasificaColposcopia = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stClasificaColposcopia.loadData(dataClasificaColposcopia);
        
        var dataGestacion = [
    [0,'NO APLICA'],
    [1,'SI'],
    [2,'NO'],
    [21,'RIESGO NO EVALUADO']

];
var stGestacion = new Ext.data.ArrayStore({
    fields: [
        {name: 'Codigo'},
        {name: 'Descripcion'}
    ]
});
stGestacion.loadData(dataGestacion);

var dataSifilisGestacional = [
    [0,'NO APLICA'],
    [1,'MUJER CON SIFILIS GESTACIONAL'],
    [2,'RECIEN NACIDO CON SIFILIS CONGENITA'],
    [3,'NO'],
    [21,'RIESGO NO EVALUADO']

];
var stSifilisGestacional = new Ext.data.ArrayStore({
    fields: [
        {name: 'Codigo'},
        {name: 'Descripcion'}
    ]
});
stSifilisGestacional.loadData(dataSifilisGestacional);

var dataHipertencionGestacional = [
    [0,'NO APLICA'],
    [1,'SI'],
    [2,'NO'],
    [21,'RIESGO NO EVALUADO']

];
var stHipertencionGestacional = new Ext.data.ArrayStore({
    fields: [
        {name: 'Codigo'},
        {name: 'Descripcion'}
    ]
});
stHipertencionGestacional.loadData(dataHipertencionGestacional);


var dataHipotiroidismoCongenito = [
    [0,'NO APLICA'],
    [1,'SI'],
    [2,'NO'],
    [21,'RIESGO NO EVALUADO']

];
var stHipotiroidismoCongenito = new Ext.data.ArrayStore({
    fields: [
        {name: 'Codigo'},
        {name: 'Descripcion'}
    ]
});
stHipotiroidismoCongenito.loadData(dataHipotiroidismoCongenito);

        
var dataTuberculosisMultidrogoresistente = [
    [0,'NO APLICA'],
    [1,'SI'],
    [2,'NO'],
    [21,'RIESGO NO EVALUADO']

];
var stTuberculosisMultidrogoresistente = new Ext.data.ArrayStore({
    fields: [
        {name: 'Codigo'},
        {name: 'Descripcion'}
    ]
});
stTuberculosisMultidrogoresistente.loadData(dataTuberculosisMultidrogoresistente);


var dataLepra = [
    [1,'PAUCIBACILAR'],
    [2,'MULTIBACILAR'],
    [3,'NO'],
    [21,'RIESGO NO EVALUADO']

];
var stLepra = new Ext.data.ArrayStore({
    fields: [
        {name: 'Codigo'},
        {name: 'Descripcion'}
    ]
});
stLepra.loadData(dataLepra);

var dataFluorosisDental = [
    [1,'SI'],
    [2,'NO'],
    [21,'RIESGO NO EVALUADO']

];
var stFluorosisDental = new Ext.data.ArrayStore({
    fields: [
        {name: 'Codigo'},
        {name: 'Descripcion'}
    ]
});
stFluorosisDental.loadData(dataFluorosisDental);    

var dataViolenciaSexual = [
    [1,'SI'],
    [2,'NO'],
    [21,'RIESGO NO EVALUADO']

];
var stViolenciaSexual = new Ext.data.ArrayStore({
    fields: [
        {name: 'Codigo'},
        {name: 'Descripcion'}
    ]
});
stViolenciaSexual.loadData(dataViolenciaSexual);


var dataVictimaMaltrato = [
    [0,'NO APLICA'],
    [1,'MUJER VICTIMA MALTRATO'],
    [2,'MENOR VICTIMA MALTRATO'],
    [3,'NO'],
    [21,'RIESGO NO EVALUADO']

];
var stVictimaMaltrato = new Ext.data.ArrayStore({
    fields: [
        {name: 'Codigo'},
        {name: 'Descripcion'}
    ]
});
stVictimaMaltrato.loadData(dataVictimaMaltrato);

var dataMesesFormulacion = [
    [1,'1 Mes'],
    [2,'2 Meses'],
    [3,'3 Meses'],
    [4,'4 Meses'],
    [5,'5 Meses'],
    [6,'6 Meses']
];
var stMesesFormulacion = new Ext.data.ArrayStore({
    fields: [
        {name: 'Codigo'},
        {name: 'Descripcion'}
    ]
});
stMesesFormulacion.loadData(dataMesesFormulacion);

var dataRegistroFechasAdicional = [
            ['NO APLICA'],
            ['NO SE REALIZA POR TRADICIONES'],
            ['NO SE REALIZA POR CONDICIONES DE SALUD'],
            ['NO SE REALIZA POR NEGACION DEL USUARIO'],
            ['NO SE REALIZA POR DATOS DEL USUARIO DESACTUALIZADOS'],
            ['NO SE REALIZA POR OTRAS RAZONES'],
            ['SI'],
            ['SIN DATO']
        ];
        var stRegistroFechasAdicional = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stRegistroFechasAdicional.loadData(dataRegistroFechasAdicional);
        
        var dataRegistroFechas = [
            ['NO APLICA'],
            ['SI'],
            ['SIN DATO']
        ];
        var stRegistroFechas = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stRegistroFechas.loadData(dataRegistroFechas);
        
        var dataTratamientoLepra = [
            [0,'NO APLICA'],
            [1,'SI RECIBE TRATAMIENTO PERO NO HA TERMINADO'],
            [2,'SI RECIBE TRATAMIENTO Y YA LO TERMINO'],
            [16,'NO RECIBE TRATAMIENTO POR UNA TRADICION'],
            [17,'NO RECIBE TRATAMIENTO POR UNA CONDICION DE SALUD'],
            [18,'NO RECIBE TRATAMIENTO POR NEGACION DEL USUARIO'],
            [19,'NO RECIBE TRATAMIENTO POR DATOS DESACTUALIZADOS'],
            [20,'NO RECIBE TRATAMIENTO POR OTRAS RAZONES'],
            [22,'SIN DATO']
        ];
        var stTratamientoLepra = new Ext.data.ArrayStore({
            fields: [
                {name: 'Codigo'},
                {name: 'Descripcion'}
            ]
        });
        stTratamientoLepra.loadData(dataTratamientoLepra);
        
        var dataTratamientoSifilisCongenita = [
            [0,'NO APLICA'],
            [1,'SI RECIBE TRATAMIENTO PERO NO HA TERMINADO'],
            [2,'SI RECIBE TRATAMIENTO Y YA LO TERMINO'],
            [16,'NO RECIBE TRATAMIENTO POR UNA TRADICION'],
            [17,'NO RECIBE TRATAMIENTO POR UNA CONDICION DE SALUD'],
            [18,'NO RECIBE TRATAMIENTO POR NEGACION DEL USUARIO'],
            [19,'NO RECIBE TRATAMIENTO POR DATOS DESACTUALIZADOS'],
            [20,'NO RECIBE TRATAMIENTO POR OTRAS RAZONES'],
            [22,'SIN DATO']
        ];
        var stTratamientoSifilisCongenita = new Ext.data.ArrayStore({
            fields: [
                {name: 'Codigo'},
                {name: 'Descripcion'}
            ]
        });
        stTratamientoSifilisCongenita.loadData(dataTratamientoSifilisCongenita);
        
        var dataTratamientoSifilisGestacional = [
            [0,'NO APLICA'],
            [1,'SI RECIBE TRATAMIENTO PERO NO HA TERMINADO'],
            [2,'SI RECIBE TRATAMIENTO Y YA LO TERMINO'],
            [16,'NO RECIBE TRATAMIENTO POR UNA TRADICION'],
            [17,'NO RECIBE TRATAMIENTO POR UNA CONDICION DE SALUD'],
            [18,'NO RECIBE TRATAMIENTO POR NEGACION DEL USUARIO'],
            [19,'NO RECIBE TRATAMIENTO POR DATOS DESACTUALIZADOS'],
            [20,'NO RECIBE TRATAMIENTO POR OTRAS RAZONES'],
            [22,'SIN DATO']
        ];
        var stTratamientoSifilisGestacional = new Ext.data.ArrayStore({
            fields: [
                {name: 'Codigo'},
                {name: 'Descripcion'}
            ]
        });
        stTratamientoSifilisGestacional.loadData(dataTratamientoSifilisGestacional);
        
        var dataTratamientoHipotiroidismoCongenito = [
            [0,'NO APLICA'],
            [1,'SI RECIBE TRATAMIENTO PERO NO HA TERMINADO'],
            [2,'SI RECIBE TRATAMIENTO Y YA LO TERMINO'],
            [16,'NO RECIBE TRATAMIENTO POR UNA TRADICION'],
            [17,'NO RECIBE TRATAMIENTO POR UNA CONDICION DE SALUD'],
            [18,'NO RECIBE TRATAMIENTO POR NEGACION DEL USUARIO'],
            [19,'NO RECIBE TRATAMIENTO POR DATOS DESACTUALIZADOS'],
            [20,'NO RECIBE TRATAMIENTO POR OTRAS RAZONES'],
            [22,'SIN DATO']
        ];
        var stTratamientoHipotiroidismoCongenito = new Ext.data.ArrayStore({
            fields: [
                {name: 'Codigo'},
                {name: 'Descripcion'}
            ]
        });
        stTratamientoHipotiroidismoCongenito.loadData(dataTratamientoHipotiroidismoCongenito);
        
        //
        this.items = [
            {
                xtype: 'panel',
                frame: true,
                anchor: '100%',
                id: 'panelHC',
                border: false,
                height: 570,
                autoScroll: true,
                layout: 'form',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'tabpanel',
                        anchor: '99%',
                        autoHeight: true,
                        border: false,
                        enableTabScroll: true,
                        ref: 'fTabPanel',
                        id: 'fTabPanel',
                        activeTab: 0,
                        items: [
                            {
                                xtype: 'panel',
                                title: 'Evolución',
                                autoHeight: true,
                                autoScroll: true,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaEvolucion',
                                layout: 'form',
                                items: [
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysIdCodPlantillaHC'
                                    },
                                     {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        value: 1,
                                        id: 'sysUsaGridSalida'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                                        value: 0,
                                        id: 'sysYaGuardoHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Plantilla',
                                        id: 'sysPlantillaHC',
                                        name: 'PLANTILLA'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysRutaRptHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysRutaRptMx'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysRutaRptExa'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysRutaRptRem'
                                    },
                                    {
                                        xtype: 'textfield',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Actividad',
                                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                                        id: 'sysActividadHC',
                                        name: 'PLANTILLA'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Empresa',
                                        id: 'sysEmpresaHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'IPS',
                                        id: 'sysIPSHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Usuario',
                                        id: 'sysUsuarioHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Profesional',
                                        id: 'sysProfesionalHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Paciente',
                                        id: 'sysIdPacienteHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Apertura',
                                        id: 'sysAperturaHC'
                                    },
                                    {
                                        xtype: 'textfield',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Cliente',
                                        id: 'sysClienteHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Plantilla',
                                        id: 'sysIdClienteHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Plantilla',
                                        id: 'sysIdPlanHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Plantilla',
                                        id: 'sysIdSubPlanHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Plantilla',
                                        id: 'sysIdContratoHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Genero',
                                        id: 'sysGeneroPacHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Edad',
                                        id: 'sysEdadPacHC'
                                    },
                                    {
                                        xtype: 'textfield',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Profesional',
                                        id: 'sysProfesionalAgendaHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'ConsecutivoDetalle',
                                        id: 'sysConsecutivoDetalleHC'
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'CAS',
                                                id: 'sysCASHC'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysFechaHC',
                                                value: 'Fecha: '
                                            },
                                            {
                                                xtype: 'textfield',
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysFechaHC'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysHoraHC',
                                                value: 'Hora: '
                                            },
                                            {
                                                xtype: 'textfield',
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysHoraHC'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysLegalizacionHC',
                                                value: 'Legalización: '
                                            },
                                            {
                                                xtype: 'textfield',
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysLegalizaHC'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'textfield',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Paciente',
                                        value: 'CC 792558261  - JORGE GALEANO RUIZ - (Masculino) FechaNac: 1973-01-30, Edad 38 Años',
                                        id: 'sysPacienteHC'
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 100,
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Genero',
                                                id: 'sysGeneroHC'
                                            },
                                            {
                                                html: 'Fecha Nac:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 100,
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysFechaNac'
                                            },
                                            {
                                                html: 'Edad:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 350,
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysEdadHC'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysOcupacionHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysEtniaHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysEscolaridadHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysEstadoCivilHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysDiscapacidadHC'
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 370,
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Dirección',
                                                id: 'sysDireccionHC'
                                            },
                                            {
                                                html: 'Telefono:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 390,
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysTelefonoHC'
                                            }
                                        ]
                                    },
                                    {
                                        html: '<hr>',
                                        style: 'background:transparent;',
                                        border: false
                                    },
                                    {
                                        xtype: 'form',
                                        frame: true,
                                        anchor: '100%',
                                        id: 'frmHC',
                                        padding: 10,
                                        border: false,
                                        autoScroll: true,
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'fieldset',
                                                title: 'ANAMNESIS',
                                                layout: 'table',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        width: 850,
                                                        fieldLabel: 'ANAMNESIS',
                                                        name: 'ANAMNESIS',
                                                        height: 30,
                                                        grow: true,
                                                        minGrow: 30,
                                                        allowBlank: true,
                                                        id: 'memAnamnesis'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'IDENTIFICACION DEL RIESGO RES. 4505',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                labelSeparator: '',
                                                autoHeight: true,
                                                id: 'fsIdentificacionRiesgo',
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 86,
                                                                allowBlank: false,
                                                                fieldLabel: 'Ocupacion',
                                                                name: 'Ocupacion',
                                                                id: 'strOcupacionHC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() === e.ENTER || e.getKey() === e.TAB)
                                                                        {
                                                                            if (f.getValue() !== "" && f.getValue() !== null){
                                                                                Ext.Ajax.request({
                                                                                    url: '../../controlador/ciuo/controlador_ciuo.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                                                            Ext.getCmp('strOcupacionHC').setValue(null);
                                                                                            Ext.getCmp('sysOcupacionHCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('strOcupacionHC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysOcupacionHCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('strOcupacionHC').setValue(null);
                                                                                        Ext.getCmp('sysOcupacionHCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('strOcupacionHC').setValue(null);
                                                                                Ext.getCmp('sysOcupacionHCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    },
                                                                    blur: function(t){
                                                                        if(Ext.getCmp('sysOcupacionHCNom').getValue() === null || Ext.getCmp('sysOcupacionHCNom').getValue() === "")
                                                                        {
                                                                            if (Ext.getCmp('strOcupacionHC').getValue() !== "" && Ext.getCmp('strOcupacionHC').getValue() !== null){
                                                                                Ext.Ajax.request({
                                                                                    url: '../../controlador/ciuo/controlador_ciuo.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: Ext.getCmp('strOcupacionHC').getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                                                            Ext.getCmp('strOcupacionHC').setValue(null);
                                                                                            Ext.getCmp('sysOcupacionHCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('strOcupacionHC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysOcupacionHCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('strOcupacionHC').setValue(null);
                                                                                        Ext.getCmp('sysOcupacionHCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('strOcupacionHC').setValue(null);
                                                                                Ext.getCmp('sysOcupacionHCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 615,
                                                                height: 22,
                                                                id: 'sysOcupacionHCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Ocupacion',
                                                                id: 'btnSearchOcupacionHC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarciuo('strOcupacionHC','sysOcupacionHCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Etnia',
                                                                name: 'Etnia',
                                                                width: 330,
                                                                allowBlank: false,
                                                                store: 'StoreEtnia4505',
                                                                valueField: 'Codigo',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'intEtniaHC'
                                                            },
                                                            {
                                                                html: 'Escolaridad:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Escolaridad',
                                                                width: 330,
                                                                allowBlank: false,
                                                                store: 'StoreEscolaridad4505',
                                                                valueField: 'Codigo',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'intEscolaridadHC'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'ANTECEDENTES PERSONALES',
                                                layout: 'table',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        width: 850,
                                                        fieldLabel: 'ANTECEDENTES PERSONALES',
                                                        name: 'ANTECEDENTES PERSONALES',
                                                        height: 30,
                                                        grow: true,
                                                        minGrow: 30,
                                                        allowBlank: true,
                                                        id: 'memAntecedentesPersonales'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                layout: 'form',
                                                anchor: '100%',
                                                autoHeight: true,
                                                labelWidth: 300,
                                                labelSeparator: '',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: '¿Vio toda la union escamoso cilindrica (UEC)?',
                                                        name: '¿Vio toda la union escamoso cilndrica (UEC)?',
                                                        width: 100,
                                                        allowBlank: true,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: "SI",
                                                        id: 'strColposcopia_a'
                                                    },
                                                    {
                                                        html: '<br><br><br>'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: '¿Colposcopia insatisfactoria?',
                                                        name: '¿Colposcopia insatisfactoria?',
                                                        anchor: '100%',
                                                        allowBlank: true,
                                                        store: stColposcopiaInsatisfactoria,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strColposcopia_b'
                                                    },
                                                    {
                                                        html: '<br><br><br>'
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        layout: 'form',
                                                        title: 'Hallazgos colposcópicos dentro de la zona de transformación',
                                                        anchor: '100%',
                                                        autoHeight: true,
                                                        labelWidth: 250,
                                                        labelSeparator: '',
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'table',
                                                                anchor: '100%',
                                                                padding: 0,
                                                                layoutConfig: {
                                                                    columns: 2
                                                                },
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'panel',
                                                                        layout: 'form',
                                                                        width: 350,
                                                                        autoHeight: true,
                                                                        labelSeparator: '',
                                                                        items: [
                                                                            {
                                                                                xtype: 'checkbox',
                                                                                fieldLabel: 'Epitelio acetoblanco plano',
                                                                                name: 'Epitelio acetoblanco plano',
                                                                                anchor: '100%',
                                                                                value: 'false',
                                                                                id: 'bolColposcopia_c_1'
                                                                            },
                                                                            {
                                                                                xtype: 'checkbox',
                                                                                fieldLabel: 'Epitelio acetoblanco micropapilar o cerebroide',
                                                                                name: 'Epitelio acetoblanco micropapilar o cerebroide',
                                                                                anchor: '100%',
                                                                                value: 'false',
                                                                                id: 'bolColposcopia_c_2'
                                                                            },
                                                                            {
                                                                                xtype: 'checkbox',
                                                                                fieldLabel: 'Leucoplastia',
                                                                                name: 'Leucoplastia',
                                                                                anchor: '100%',
                                                                                value: 'false',
                                                                                id: 'bolColposcopia_c_3'
                                                                            },
                                                                            {
                                                                                xtype: 'checkbox',
                                                                                fieldLabel: 'Punteado',
                                                                                name: 'Punteado',
                                                                                anchor: '100%',
                                                                                value: 'false',
                                                                                id: 'bolColposcopia_c_4'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'panel',
                                                                        layout: 'form',
                                                                        width: 500,
                                                                        autoHeight: true,
                                                                        labelSeparator: '',
                                                                        items: [
                                                                            {
                                                                                xtype: 'checkbox',
                                                                                fieldLabel: 'Mosaico',
                                                                                name: 'Mosaico',
                                                                                anchor: '100%',
                                                                                value: 'false',
                                                                                id: 'bolColposcopia_c_5'
                                                                            },
                                                                            {
                                                                                xtype: 'checkbox',
                                                                                fieldLabel: 'Vasos Atípicos',
                                                                                name: 'Vasos Atípicos',
                                                                                anchor: '100%',
                                                                                value: 'false',
                                                                                id: 'bolColposcopia_c_6'
                                                                            },
                                                                            {
                                                                                xtype: 'checkbox',
                                                                                fieldLabel: 'Áreas yodonegativas',
                                                                                name: 'Áreas yodonegativas',
                                                                                anchor: '100%',
                                                                                value: 'false',
                                                                                id: 'bolColposcopia_c_7'
                                                                            },
                                                                            {
                                                                                xtype: 'compositefield',
                                                                                style: 'background:transparent;',
                                                                                items: [
                                                                                    {
                                                                                        xtype: 'checkbox',
                                                                                        fieldLabel: 'Otros',
                                                                                        name: 'Otros',
                                                                                        anchor: '100%',
                                                                                        value: 'false',
                                                                                        id: 'bolColposcopia_c_a8'
                                                                                    },
                                                                                    {
                                                                                        html: 'Cuales'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        width: 300,
                                                                                        name: 'Cuales',
                                                                                        allowBlank: true,
                                                                                        id: 'strColposcopia_c_b8'
                                                                                    }
                                                                                ]
                                                                            }
                                                                        ]
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        html: '<br><br><br>'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Hallazgos fuera de la zona de trasformación',
                                                        name: 'Hallazgos fuera de la zona de trasformación',
                                                        allowBlank: true,
                                                        id: 'strColposcopia_d'
                                                    },
                                                    {
                                                        html: '<br><br><br>'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Sospecha colposcópica de carcinoma invasor',
                                                        name: 'Sospecha colposcópica de carcinoma invasor',
                                                        anchor: '100%',
                                                        allowBlank: true,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: "NO",
                                                        id: 'strColposcopia_e'
                                                    },
                                                    {
                                                        html: '<br><br><br>'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Otros Hallazgos',
                                                        name: 'Otros Hallazgos',
                                                        allowBlank: true,
                                                        id: 'strColposcopia_f'
                                                    },
                                                    {
                                                        html: '<br><br><br>'
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        layout: 'form',
                                                        title: 'Diagnostico Colposcópico',
                                                        anchor: '100%',
                                                        autoHeight: true,
                                                        labelWidth: 250,
                                                        labelSeparator: '',
                                                        items: [
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Diagnostico',
                                                                        name: 'Diagnostico',
                                                                        width: 150,
                                                                        allowBlank: true,
                                                                        store: stDxColposcopia,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strColposcopia_g_a1'
                                                                    },
                                                                    {
                                                                        html: 'Especifique'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 300,
                                                                        name: 'Especifique',
                                                                        allowBlank: true,
                                                                        id: 'strColposcopia_g_b1'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                fieldLabel: 'Hallazgos colposcópicos normales',
                                                                name: 'Hallazgos colposcópicos normales',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolColposcopia_g_2'
                                                            },
                                                            /*{
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'Inflamación o infección',
                                                                        name: 'Inflamación o infección',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolColposcopia_g_a3'
                                                                    },
                                                                    {
                                                                        html: 'Especifique'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 300,
                                                                        name: 'Especifique',
                                                                        allowBlank: true,
                                                                        id: 'strColposcopia_g_b3'
                                                                    }
                                                                ]
                                                            },*/
                                                            /*{
                                                                xtype: 'checkbox',
                                                                fieldLabel: 'Leucoplasia',
                                                                name: 'Leucoplasia',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolColposcopia_g_4'
                                                            },*/
                                                            /*{
                                                                xtype: 'checkbox',
                                                                fieldLabel: 'Condiloma',
                                                                name: 'Condiloma',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolColposcopia_g_5'
                                                            },*/
                                                            {
                                                                xtype: 'checkbox',
                                                                fieldLabel: 'LEI de bajo grado',
                                                                name: 'LEI de bajo grado',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolColposcopia_g_6'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                fieldLabel: 'LEI de alto grado',
                                                                name: 'LEI de alto grado',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolColposcopia_g_7'
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'Carcinoma invasor',
                                                                        name: 'Carcinoma invasor',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolColposcopia_g_a8'
                                                                    },
                                                                    {
                                                                        html: 'Especifique'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 300,
                                                                        name: 'Especifique',
                                                                        allowBlank: true,
                                                                        id: 'strColposcopia_g_b8'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'Otros',
                                                                        name: 'Otros',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolColposcopia_g_a9'
                                                                    },
                                                                    {
                                                                        html: 'Especifique'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 300,
                                                                        name: 'Especifique',
                                                                        allowBlank: true,
                                                                        id: 'strColposcopia_g_b9'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 70,
                                                                name: 'Numero de Biopsias Tomadas',
                                                                fieldLabel: 'Numero de Biopsias Tomadas',
                                                                minValue: 0,
                                                                allowBlank: true,
                                                                style: 'text-align:center;',
                                                                id: 'intColposcopia_g_10'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                fieldLabel: 'Legrado cervical LEC',
                                                                name: 'Legrado cervical LEC',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolColposcopia_g_11'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        html: '<br><br><br>'
                                                    },
                                                    /*
                                                            {
                                                                xtype: 'checkbox',
                                                                fieldLabel: 'Cervicitis purulenta',
                                                                name: 'Cervicitis purulenta',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolColposcopia_h_4'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                fieldLabel: 'Flujo opaco',
                                                                name: 'Flujo opaco',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolColposcopia_h_5'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                fieldLabel: 'Flujo amarillo',
                                                                name: 'Flujo amarillo',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolColposcopia_h_6'
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'Otros',
                                                                        name: 'Otros',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolColposcopia_h_a7'
                                                                    },
                                                                    {
                                                                        html: 'Especifique'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 300,
                                                                        name: 'Especifique',
                                                                        allowBlank: true,
                                                                        id: 'strColposcopia_h_b7'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },*/ //se elimina por solicitud del laboratorio
                                                    {
                                                        html: '<br><br><br>'
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        layout: 'form',
                                                        title: 'Clasificacion de la Colposcopia',
                                                        anchor: '100%',
                                                        autoHeight: true,
                                                        labelWidth: 250,
                                                        labelSeparator: '',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Clasificacion',
                                                                name: 'Clasificacion',
                                                                anchor: '50%',
                                                                allowBlank: false,
                                                                store: stClasificaColposcopia,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strColposcopia_l_a1'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                fieldLabel: 'Observaciones',
                                                                name: 'Observaciones',
                                                                allowBlank: true,
                                                                id: 'strColposcopia_l_b1'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        html: '<br><br><br>'
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        layout: 'form',
                                                        title: 'Si durante la colposcopia se ha realizado un test, anote los resultados',
                                                        anchor: '100%',
                                                        autoHeight: true,
                                                        labelWidth: 180,
                                                        labelSeparator: '',
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'table',
                                                                anchor: '100%',
                                                                padding: 0,
                                                                layoutConfig: {
                                                                    columns: 3
                                                                },
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'panel',
                                                                        layout: 'form',
                                                                        title: '<Center>Citologia</Center>',
                                                                        width: 250,
                                                                        height: 300,
                                                                        labelSeparator: '',
                                                                        items: [
                                                                            {
                                                                                xtype: 'checkbox',
                                                                                fieldLabel: 'Negativa',
                                                                                name: 'Citologia - Negativa',
                                                                                anchor: '100%',
                                                                                value: 'false',
                                                                                id: 'bolColposcopia_i_1'
                                                                            },
                                                                            {
                                                                                xtype: 'checkbox',
                                                                                fieldLabel: 'Atipa o NIC I',
                                                                                name: 'Citologia - Atipa o NIC I',
                                                                                anchor: '100%',
                                                                                value: 'false',
                                                                                id: 'bolColposcopia_i_2'
                                                                            },
                                                                            {
                                                                                xtype: 'checkbox',
                                                                                fieldLabel: 'NIC II',
                                                                                name: 'NIC II',
                                                                                anchor: '100%',
                                                                                value: 'false',
                                                                                id: 'bolColposcopia_i_3'
                                                                            },
                                                                            {
                                                                                xtype: 'checkbox',
                                                                                fieldLabel: 'NIC III',
                                                                                name: 'Citologia - NIC III',
                                                                                anchor: '100%',
                                                                                value: 'false',
                                                                                id: 'bolColposcopia_i_4'
                                                                            },
                                                                            {
                                                                                xtype: 'checkbox',
                                                                                fieldLabel: 'Carcinoma invasor',
                                                                                name: 'Citologia - Carcinoma invasor',
                                                                                anchor: '100%',
                                                                                value: 'false',
                                                                                id: 'bolColposcopia_i_5'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'panel',
                                                                        layout: 'form',
                                                                        title: '<Center>LEC</Center>',
                                                                        width: 250,
                                                                        height: 300,
                                                                        labelSeparator: '',
                                                                        items: [
                                                                            {
                                                                                xtype: 'checkbox',
                                                                                fieldLabel: 'Negativa',
                                                                                name: 'LEC - Negativa',
                                                                                anchor: '100%',
                                                                                value: 'false',
                                                                                id: 'bolColposcopia_j_1'
                                                                            },
                                                                            {
                                                                                xtype: 'checkbox',
                                                                                fieldLabel: 'Atipa o NIC I',
                                                                                name: 'LEC - Atipa o NIC I',
                                                                                anchor: '100%',
                                                                                value: 'false',
                                                                                id: 'bolColposcopia_j_2'
                                                                            },
                                                                            {
                                                                                xtype: 'checkbox',
                                                                                fieldLabel: 'NIC II',
                                                                                name: 'LEC - NIC II',
                                                                                anchor: '100%',
                                                                                value: 'false',
                                                                                id: 'bolColposcopia_j_3'
                                                                            },
                                                                            {
                                                                                xtype: 'checkbox',
                                                                                fieldLabel: 'NIC III',
                                                                                name: 'LEC - NIC III',
                                                                                anchor: '100%',
                                                                                value: 'false',
                                                                                id: 'bolColposcopia_j_4'
                                                                            },
                                                                            {
                                                                                xtype: 'checkbox',
                                                                                fieldLabel: 'Carcinoma escamoso microinvasor',
                                                                                name: 'LEC - Carcinoma escamoso microinvasor',
                                                                                anchor: '100%',
                                                                                value: 'false',
                                                                                id: 'bolColposcopia_j_5'
                                                                            },
                                                                            {
                                                                                xtype: 'checkbox',
                                                                                fieldLabel: 'Carcinoma escamoso invasor',
                                                                                name: 'LEC - Carcinoma escamoso invasor',
                                                                                anchor: '100%',
                                                                                value: 'false',
                                                                                id: 'bolColposcopia_j_6'
                                                                            },
                                                                            {
                                                                                xtype: 'checkbox',
                                                                                fieldLabel: 'Adenocarcinoma',
                                                                                name: 'LEC - Adenocarcinoma',
                                                                                anchor: '100%',
                                                                                value: 'false',
                                                                                id: 'bolColposcopia_j_7'
                                                                            },
                                                                            {
                                                                                xtype: 'checkbox',
                                                                                fieldLabel: 'Displasia glandular',
                                                                                name: 'LEC - Displasia glandular',
                                                                                anchor: '100%',
                                                                                value: 'false',
                                                                                id: 'bolColposcopia_j_8'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'panel',
                                                                        layout: 'form',
                                                                        title: '<Center>BIOPSIA</Center>',
                                                                        width: 250,
                                                                        height: 300,
                                                                        labelSeparator: '',
                                                                        items: [
                                                                            {
                                                                                xtype: 'checkbox',
                                                                                fieldLabel: 'Negativa',
                                                                                name: 'BIOPSIA - Negativa',
                                                                                anchor: '100%',
                                                                                value: 'false',
                                                                                id: 'bolColposcopia_k_1'
                                                                            },
                                                                            {
                                                                                xtype: 'checkbox',
                                                                                fieldLabel: 'Atipa o NIC I',
                                                                                name: 'BIOPSIA - Atipa o NIC I',
                                                                                anchor: '100%',
                                                                                value: 'false',
                                                                                id: 'bolColposcopia_k_2'
                                                                            },
                                                                            {
                                                                                xtype: 'checkbox',
                                                                                fieldLabel: 'NIC II',
                                                                                name: 'BIOPSIA - NIC II',
                                                                                anchor: '100%',
                                                                                value: 'false',
                                                                                id: 'bolColposcopia_k_3'
                                                                            },
                                                                            {
                                                                                xtype: 'checkbox',
                                                                                fieldLabel: 'NIC III',
                                                                                name: 'BIOPSIA - NIC III',
                                                                                anchor: '100%',
                                                                                value: 'false',
                                                                                id: 'bolColposcopia_k_4'
                                                                            },
                                                                            {
                                                                                xtype: 'checkbox',
                                                                                fieldLabel: 'Carcinoma escamoso microinvasor',
                                                                                name: 'BIOPSIA - Carcinoma escamoso microinvasor',
                                                                                anchor: '100%',
                                                                                value: 'false',
                                                                                id: 'bolColposcopia_k_5'
                                                                            },
                                                                            {
                                                                                xtype: 'checkbox',
                                                                                fieldLabel: 'Carcinoma escamoso invasor',
                                                                                name: 'BIOPSIA - Carcinoma escamoso invasor',
                                                                                anchor: '100%',
                                                                                value: 'false',
                                                                                id: 'bolColposcopia_k_6'
                                                                            },
                                                                            {
                                                                                xtype: 'checkbox',
                                                                                fieldLabel: 'Adenocarcinoma in-situ',
                                                                                name: 'BIOPSIA - Adenocarcinoma in-situ',
                                                                                anchor: '100%',
                                                                                value: 'false',
                                                                                id: 'bolColposcopia_k_7'
                                                                            },
                                                                            {
                                                                                xtype: 'checkbox',
                                                                                fieldLabel: 'Adenocarcinoma',
                                                                                name: 'BIOPSIA - Adenocarcinoma',
                                                                                anchor: '100%',
                                                                                value: 'false',
                                                                                id: 'bolColposcopia_k_8'
                                                                            }
                                                                        ]
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'CONDUCTA',
                                                layout: 'table',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'CONDUCTA',
                                                        name: 'CONDUCTA',
                                                        height: 100,
                                                        allowBlank: false,
                                                        id: 'memConducta'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'RIPS',
                                                anchor: '100%',
                                                autoHeight: true,
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                layout: 'form',
                                                padding: 0,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: false,
                                                                fieldLabel: 'Diagnostico Principal',
                                                                id: 'sysDiagPpalProc',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1Proc').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2Proc').getValue()){
                                                                                Ext.Ajax.request({
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagPpalProc').setValue(null);
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagPpalProc').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagPpalProc').setValue(null);
                                                                                        Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagPpalProc').setValue(null);
                                                                                Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    },
                                                                    blur: function(t){
                                                                        if(Ext.getCmp('sysDiagPpalProcNom').getValue()==null || Ext.getCmp('sysDiagPpalProcNom').getValue()== "")
                                                                        {
                                                                            if (Ext.getCmp('sysDiagPpalProc').getValue() != "" && Ext.getCmp('sysDiagPpalProc').getValue() != null && Ext.getCmp('sysDiagPpalProc').getValue().toUpperCase() != Ext.getCmp('sysDiagRel1Proc').getValue() && Ext.getCmp('sysDiagPpalProc').getValue().toUpperCase() != Ext.getCmp('sysDiagRel2Proc').getValue()){
                                                                                Ext.Ajax.request({
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: Ext.getCmp('sysDiagPpalProc').getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagPpalProc').setValue(null);
                                                                                            Ext.getCmp('sysDiagPpalProcNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagPpalProc').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagPpalProcNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagPpalProc').setValue(null);
                                                                                        Ext.getCmp('sysDiagPpalProcNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagPpalProc').setValue(null);
                                                                                Ext.getCmp('sysDiagPpalProcNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 600,
                                                                height: 22,
                                                                id: 'sysDiagPpalProcNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Principal',
                                                                id: 'btnSearchDiagPpalProc',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagPpalProc','sysDiagPpalProcNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado',
                                                                id: 'sysDiagRel1Proc',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalProc').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2Proc').getValue()){
                                                                                Ext.Ajax.request({
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel1Proc').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel1ProcNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel1Proc').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagRel1ProcNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel1Proc').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel1ProcNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel1Proc').setValue(null);
                                                                                Ext.getCmp('sysDiagRel1ProcNom').setValue(null);
                                                                            }
                                                                        }
                                                                    },
                                                                    blur: function(t){
                                                                        if(Ext.getCmp('sysDiagRel1ProcNom').getValue()==null || Ext.getCmp('sysDiagRel1ProcNom').getValue()== "")
                                                                        {
                                                                            if (Ext.getCmp('sysDiagRel1Proc').getValue() != "" && Ext.getCmp('sysDiagRel1Proc').getValue() != null && Ext.getCmp('sysDiagRel1Proc').getValue().toUpperCase() != Ext.getCmp('sysDiagPpalProc').getValue() && Ext.getCmp('sysDiagRel1Proc').getValue().toUpperCase() != Ext.getCmp('sysDiagRel2Proc').getValue()){
                                                                                Ext.Ajax.request({
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: Ext.getCmp('sysDiagRel1Proc').getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel1Proc').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel1ProcNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel1Proc').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagRel1ProcNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel1Proc').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel1ProcNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel1Proc').setValue(null);
                                                                                Ext.getCmp('sysDiagRel1ProcNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 600,
                                                                height: 22,
                                                                id: 'sysDiagRel1ProcNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado',
                                                                id: 'btnSearchDiagRel1Proc',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel1Proc','sysDiagRel1ProcNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Complicación',
                                                                id: 'sysDiagRel2Proc',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalProc').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1Proc').getValue()){
                                                                                Ext.Ajax.request({
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel2Proc').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel2ProcNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel2Proc').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagRel2ProcNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel2Proc').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel2ProcNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel2Proc').setValue(null);
                                                                                Ext.getCmp('sysDiagRel2ProcNom').setValue(null);
                                                                            }
                                                                        }
                                                                    },
                                                                    blur: function(t){
                                                                        if(Ext.getCmp('sysDiagRel2ProcNom').getValue()==null || Ext.getCmp('sysDiagRel2ProcNom').getValue()== "")
                                                                        {
                                                                            if (Ext.getCmp('sysDiagRel2Proc').getValue() != "" && Ext.getCmp('sysDiagRel2Proc').getValue() != null && Ext.getCmp('sysDiagRel2Proc').getValue().toUpperCase() != Ext.getCmp('sysDiagPpalProc').getValue() && Ext.getCmp('sysDiagRel2Proc').getValue().toUpperCase() != Ext.getCmp('sysDiagRel1Proc').getValue()){
                                                                                Ext.Ajax.request({
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: Ext.getCmp('sysDiagRel2Proc').getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel2Proc').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel2ProcNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel2Proc').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagRel2ProcNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel2Proc').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel2ProcNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel2Proc').setValue(null);
                                                                                Ext.getCmp('sysDiagRel2ProcNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 600,
                                                                height: 22,
                                                                id: 'sysDiagRel2ProcNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Complicación',
                                                                id: 'btnSearchDiagRel2Proc',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel2Proc','sysDiagRel2ProcNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Ambito',
                                                        width:700,
                                                        name: 'Ambito',
                                                        allowBlank: false,
                                                        store: 'StoreAmbitoProcedimiento',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 1,
                                                        id: 'sysAmbitoProc'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Finalidad Procedimiento',
                                                        width:700,
                                                        name: 'Finalidad Procedimiento',
                                                        allowBlank: false,
                                                        store: 'StoreFinalidadProcedimiento',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 1,
                                                        id: 'sysFinalidadProcedimientoProc'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Personal Atiende',
                                                        width:700,
                                                        name: 'Personal Atiende',
                                                        allowBlank: false,
                                                        store: 'StorePersonalAtiendeProcedimiento',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 1,
                                                        id: 'sysPersonalAtiendeProcedimientoProc'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Forma Realización Acto Quirúrgico',
                                                        width:700,
                                                        name: 'Forma Realización Acto Quirúrgico',
                                                        allowBlank: false,
                                                        store: 'StoreFormaRealizacionProcedimiento',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 1,
                                                        id: 'sysFormaRealizaProcedimientoProc'
                                                    }
                                                ]
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Medicamentos',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaMedicamentos',
                                items: [
                                    xSolMX
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Servicios',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaServicios',
                                items: [
                                    xSolEXA
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Remisiones',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaRemisiones',
                                items: [
                                    xSolREM
                                ]
                            }
                        ]
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btnSalirEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 1)
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Usted No ha Guardado la Evolución del Paciente y Se Perdera la Información, Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                },
                tbar:{
                    items: [
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Ver Historia Clínica',
                            iconCls: 'btnVerHC',
                            id: 'btnVerHC',
                            listeners:{
                                click : function(){
                                    var cmpResumenHC = new winFrmVerHistorialHC({
                                        renderTo: Ext.getBody()
                                    });
                                    Ext.getCmp('winViewEvolucionHC').title = "PACIENTE: " + Ext.getCmp('sysPacienteHC').getValue();
                                    Ext.getCmp('gridHistorialEvoluciones').store.load({
                                        params: {
                                            pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                                            pPaciente: Ext.getCmp('sysIdPacienteHC').getValue()
                                        }
                                    });
                                    cmpResumenHC.show();
                                }
                            }
                        },
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar Evolución',
                            iconCls: 'btnGuardar',
                            id: 'btnGuardarEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 0)
                                    {
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Guardar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnGuardarRegistrosMedicinaGeneral();
                                                }
                                            }
                                        });
                                    }else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Modificar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnModificarRegistrosMedicinaGeneral();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                }
            }
        ];
        winHCColposcopia001Ui.superclass.initComponent.call(this);
    }
});

function fnGuardarRegistrosMedicinaGeneral(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc.php',
            params:{
                task: 'guardar_proc',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pidPlantillaHC : Ext.getCmp('sysIdCodPlantillaHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalProc').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1Proc').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2Proc').getValue(),
                pAmbito: Ext.getCmp('sysAmbitoProc').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadProcedimientoProc').getValue(),
                pPersona: Ext.getCmp('sysPersonalAtiendeProcedimientoProc').getValue(),
                pForma: Ext.getCmp('sysFormaRealizaProcedimientoProc').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function fnModificarRegistrosMedicinaGeneral(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc.php',
            params:{
                task: 'ModificarProc',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalProc').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1Proc').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2Proc').getValue(),
                pAmbito: Ext.getCmp('sysAmbitoProc').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadProcedimientoProc').getValue(),
                pPersona: Ext.getCmp('sysPersonalAtiendeProcedimientoProc').getValue(),
                pForma: Ext.getCmp('sysFormaRealizaProcedimientoProc').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}
