/*
* @category    Fieldset Diagnostico Consulta
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


fsDiagnosticosConsultaUi = Ext.extend(Ext.form.FieldSet, {
    anchor: '100%',
    autoHeight: true,
    collapseFirst: false,
    collapsible: true,
    animCollapse: true,
    titleCollapse: true,
    layout: 'form',
    title: 'Diagnosticos de la Atencion',
    padding: 0,
    id: 'fsDiagnosticosConsulta',
    initComponent: function() {
        this.items = [
            {
                xtype: 'compositefield',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'textfield',
                        width: 96,
                        allowBlank: true,
                        fieldLabel: 'Diagnostico Principal',
                        id: 'sysDiagPpalProc',
                        listeners:{
                            specialkey: function(f,e){
                                if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                {
                                    if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1Proc').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2Proc').getValue()){
                                        Ext.Ajax.request({
                                            url: '../../controlador/cie10/controlador_cie10.php',
                                            params:{
                                                task: 'BUSCAR',
                                                pCodigo: f.getValue().toUpperCase()
                                            },
                                            success: function(response,options)
                                            {
                                                var el = Ext.get('response'); // get the LOG
                                                var Respuesta = response.responseText;
                                                var Contenido = Respuesta.split('^');
                                                if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                    Ext.getCmp('sysDiagPpalProc').setValue(null);
                                                    Ext.getCmp('sysDiagPpalProcNom').setValue(null);
                                                } else {
                                                    Ext.getCmp('sysDiagPpalProc').setValue(Contenido[0].toUpperCase());
                                                    Ext.getCmp('sysDiagPpalProcNom').setValue(Contenido[1].toUpperCase());
                                                }
                                            },
                                            failure: function(response,options){
                                                var el = Ext.get('response');
                                                Ext.getCmp('sysDiagPpalProc').setValue(null);
                                                Ext.getCmp('sysDiagPpalProcNom').setValue(null);
                                            },
                                            scope:this //bind the callbacks
                                        });
                                    }else{
                                        Ext.getCmp('sysDiagPpalProc').setValue(null);
                                        Ext.getCmp('sysDiagPpalProcNom').setValue(null);
                                    }
                                }
                            },
                            blur: function(t){
                                if(Ext.getCmp('sysDiagPpalProcNom').getValue()==null || Ext.getCmp('sysDiagPpalProcNom').getValue()== "")
                                {
                                    if (Ext.getCmp('sysDiagPpalProc').getValue() != "" && Ext.getCmp('sysDiagPpalProc').getValue() != null && Ext.getCmp('sysDiagPpalProc').getValue().toUpperCase() != Ext.getCmp('sysDiagRel1Proc').getValue() && Ext.getCmp('sysDiagPpalProc').getValue().toUpperCase() != Ext.getCmp('sysDiagRel2Proc').getValue()){
                                        Ext.Ajax.request({
                                            url: '../../controlador/cie10/controlador_cie10.php',
                                            params:{
                                                task: 'BUSCAR',
                                                pCodigo: Ext.getCmp('sysDiagPpalProc').getValue().toUpperCase()
                                            },
                                            success: function(response,options)
                                            {
                                                var el = Ext.get('response'); // get the LOG
                                                var Respuesta = response.responseText;
                                                var Contenido = Respuesta.split('^');
                                                if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                    Ext.getCmp('sysDiagPpalProc').setValue(null);
                                                    Ext.getCmp('sysDiagPpalProcNom').setValue(null);
                                                } else {
                                                    Ext.getCmp('sysDiagPpalProc').setValue(Contenido[0].toUpperCase());
                                                    Ext.getCmp('sysDiagPpalProcNom').setValue(Contenido[1].toUpperCase());
                                                }
                                            },
                                            failure: function(response,options){
                                                var el = Ext.get('response');
                                                Ext.getCmp('sysDiagPpalProc').setValue(null);
                                                Ext.getCmp('sysDiagPpalProcNom').setValue(null);
                                            },
                                            scope:this //bind the callbacks
                                        });
                                    }else{
                                        Ext.getCmp('sysDiagPpalProc').setValue(null);
                                        Ext.getCmp('sysDiagPpalProcNom').setValue(null);
                                    }
                                }
                            }
                        }
                    },
                    {
                        xtype: 'textarea',
                        readOnly: true,
                        width: 600,
                        height: 22,
                        id: 'sysDiagPpalProcNom'
                    },
                    {
                        xtype: 'button',
                        iconCls: 'btnBuscar',
                        tooltip: 'Buscar Diagnostico Principal',
                        id: 'btnSearchDiagPpalProc',
                        listeners:{
                            click : function(){
                                buscarcie10('sysDiagPpalProc','sysDiagPpalProcNom');
                            }
                        }
                    }
                ]
            },
            {
                xtype: 'compositefield',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'textfield',
                        width: 96,
                        allowBlank: true,
                        fieldLabel: 'Diagnostico Relacionado',
                        id: 'sysDiagRel1Proc',
                        listeners:{
                            specialkey: function(f,e){
                                if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                {
                                    if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalProc').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2Proc').getValue()){
                                        Ext.Ajax.request({
                                            url: '../../controlador/cie10/controlador_cie10.php',
                                            params:{
                                                task: 'BUSCAR',
                                                pCodigo: f.getValue().toUpperCase()
                                            },
                                            success: function(response,options)
                                            {
                                                var el = Ext.get('response'); // get the LOG
                                                var Respuesta = response.responseText;
                                                var Contenido = Respuesta.split('^');
                                                if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                    Ext.getCmp('sysDiagRel1Proc').setValue(null);
                                                    Ext.getCmp('sysDiagRel1ProcNom').setValue(null);
                                                } else {
                                                    Ext.getCmp('sysDiagRel1Proc').setValue(Contenido[0].toUpperCase());
                                                    Ext.getCmp('sysDiagRel1ProcNom').setValue(Contenido[1].toUpperCase());
                                                }
                                            },
                                            failure: function(response,options){
                                                var el = Ext.get('response');
                                                Ext.getCmp('sysDiagRel1Proc').setValue(null);
                                                Ext.getCmp('sysDiagRel1ProcNom').setValue(null);
                                            },
                                            scope:this //bind the callbacks
                                        });
                                    }else{
                                        Ext.getCmp('sysDiagRel1Proc').setValue(null);
                                        Ext.getCmp('sysDiagRel1ProcNom').setValue(null);
                                    }
                                }
                            },
                            blur: function(t){
                                if(Ext.getCmp('sysDiagRel1ProcNom').getValue()==null || Ext.getCmp('sysDiagRel1ProcNom').getValue()== "")
                                {
                                    if (Ext.getCmp('sysDiagRel1Proc').getValue() != "" && Ext.getCmp('sysDiagRel1Proc').getValue() != null && Ext.getCmp('sysDiagRel1Proc').getValue().toUpperCase() != Ext.getCmp('sysDiagPpalProc').getValue() && Ext.getCmp('sysDiagRel1Proc').getValue().toUpperCase() != Ext.getCmp('sysDiagRel2Proc').getValue()){
                                        Ext.Ajax.request({
                                            url: '../../controlador/cie10/controlador_cie10.php',
                                            params:{
                                                task: 'BUSCAR',
                                                pCodigo: Ext.getCmp('sysDiagRel1Proc').getValue().toUpperCase()
                                            },
                                            success: function(response,options)
                                            {
                                                var el = Ext.get('response'); // get the LOG
                                                var Respuesta = response.responseText;
                                                var Contenido = Respuesta.split('^');
                                                if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                    Ext.getCmp('sysDiagRel1Proc').setValue(null);
                                                    Ext.getCmp('sysDiagRel1ProcNom').setValue(null);
                                                } else {
                                                    Ext.getCmp('sysDiagRel1Proc').setValue(Contenido[0].toUpperCase());
                                                    Ext.getCmp('sysDiagRel1ProcNom').setValue(Contenido[1].toUpperCase());
                                                }
                                            },
                                            failure: function(response,options){
                                                var el = Ext.get('response');
                                                Ext.getCmp('sysDiagRel1Proc').setValue(null);
                                                Ext.getCmp('sysDiagRel1ProcNom').setValue(null);
                                            },
                                            scope:this //bind the callbacks
                                        });
                                    }else{
                                        Ext.getCmp('sysDiagRel1Proc').setValue(null);
                                        Ext.getCmp('sysDiagRel1ProcNom').setValue(null);
                                    }
                                }
                            }
                        }
                    },
                    {
                        xtype: 'textarea',
                        readOnly: true,
                        width: 600,
                        height: 22,
                        id: 'sysDiagRel1ProcNom'
                    },
                    {
                        xtype: 'button',
                        iconCls: 'btnBuscar',
                        tooltip: 'Buscar Diagnostico Relacionado',
                        id: 'btnSearchDiagRel1Proc',
                        listeners:{
                            click : function(){
                                buscarcie10('sysDiagRel1Proc','sysDiagRel1ProcNom');
                            }
                        }
                    }
                ]
            },
            {
                xtype: 'compositefield',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'textfield',
                        width: 96,
                        allowBlank: true,
                        fieldLabel: 'Diagnostico Complicación',
                        id: 'sysDiagRel2Proc',
                        listeners:{
                            specialkey: function(f,e){
                                if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                {
                                    if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalProc').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1Proc').getValue()){
                                        Ext.Ajax.request({
                                            url: '../../controlador/cie10/controlador_cie10.php',
                                            params:{
                                                task: 'BUSCAR',
                                                pCodigo: f.getValue().toUpperCase()
                                            },
                                            success: function(response,options)
                                            {
                                                var el = Ext.get('response'); // get the LOG
                                                var Respuesta = response.responseText;
                                                var Contenido = Respuesta.split('^');
                                                if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                    Ext.getCmp('sysDiagRel2Proc').setValue(null);
                                                    Ext.getCmp('sysDiagRel2ProcNom').setValue(null);
                                                } else {
                                                    Ext.getCmp('sysDiagRel2Proc').setValue(Contenido[0].toUpperCase());
                                                    Ext.getCmp('sysDiagRel2ProcNom').setValue(Contenido[1].toUpperCase());
                                                }
                                            },
                                            failure: function(response,options){
                                                var el = Ext.get('response');
                                                Ext.getCmp('sysDiagRel2Proc').setValue(null);
                                                Ext.getCmp('sysDiagRel2ProcNom').setValue(null);
                                            },
                                            scope:this //bind the callbacks
                                        });
                                    }else{
                                        Ext.getCmp('sysDiagRel2Proc').setValue(null);
                                        Ext.getCmp('sysDiagRel2ProcNom').setValue(null);
                                    }
                                }
                            },
                            blur: function(t){
                                if(Ext.getCmp('sysDiagRel2ProcNom').getValue()==null || Ext.getCmp('sysDiagRel2ProcNom').getValue()== "")
                                {
                                    if (Ext.getCmp('sysDiagRel2Proc').getValue() != "" && Ext.getCmp('sysDiagRel2Proc').getValue() != null && Ext.getCmp('sysDiagRel2Proc').getValue().toUpperCase() != Ext.getCmp('sysDiagPpalProc').getValue() && Ext.getCmp('sysDiagRel2Proc').getValue().toUpperCase() != Ext.getCmp('sysDiagRel1Proc').getValue()){
                                        Ext.Ajax.request({
                                            url: '../../controlador/cie10/controlador_cie10.php',
                                            params:{
                                                task: 'BUSCAR',
                                                pCodigo: Ext.getCmp('sysDiagRel2Proc').getValue().toUpperCase()
                                            },
                                            success: function(response,options)
                                            {
                                                var el = Ext.get('response'); // get the LOG
                                                var Respuesta = response.responseText;
                                                var Contenido = Respuesta.split('^');
                                                if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                    Ext.getCmp('sysDiagRel2Proc').setValue(null);
                                                    Ext.getCmp('sysDiagRel2ProcNom').setValue(null);
                                                } else {
                                                    Ext.getCmp('sysDiagRel2Proc').setValue(Contenido[0].toUpperCase());
                                                    Ext.getCmp('sysDiagRel2ProcNom').setValue(Contenido[1].toUpperCase());
                                                }
                                            },
                                            failure: function(response,options){
                                                var el = Ext.get('response');
                                                Ext.getCmp('sysDiagRel2Proc').setValue(null);
                                                Ext.getCmp('sysDiagRel2ProcNom').setValue(null);
                                            },
                                            scope:this //bind the callbacks
                                        });
                                    }else{
                                        Ext.getCmp('sysDiagRel2Proc').setValue(null);
                                        Ext.getCmp('sysDiagRel2ProcNom').setValue(null);
                                    }
                                }
                            }
                        }
                    },
                    {
                        xtype: 'textarea',
                        readOnly: true,
                        width: 600,
                        height: 22,
                        id: 'sysDiagRel2ProcNom'
                    },
                    {
                        xtype: 'button',
                        iconCls: 'btnBuscar',
                        tooltip: 'Buscar Diagnostico Complicación',
                        id: 'btnSearchDiagRel2Proc',
                        listeners:{
                            click : function(){
                                buscarcie10('sysDiagRel2Proc','sysDiagRel2ProcNom');
                            }
                        }
                    }
                ]
            },
            {
                xtype: 'combo',
                fieldLabel: 'Ambito',
                width:700,
                name: 'Ambito',
                allowBlank: false,
                store: 'StoreAmbitoProcedimiento',
                forceSelection: true,
                triggerAction: 'all',
                typeAhead: true,
                typeAheadDelay: 50,
                mode: 'local',
                valueField: 'Codigo',
                displayField: 'Descripcion',
                emptyText: 'Seleccione....',
                submitValue: true,
                value: 1,
                id: 'sysAmbitoProc'
            },
            {
                xtype: 'combo',
                fieldLabel: 'Finalidad Procedimiento',
                width:700,
                name: 'Finalidad Procedimiento',
                allowBlank: false,
                store: 'StoreFinalidadProcedimiento',
                forceSelection: true,
                triggerAction: 'all',
                typeAhead: true,
                typeAheadDelay: 50,
                mode: 'local',
                valueField: 'Codigo',
                displayField: 'Descripcion',
                emptyText: 'Seleccione....',
                submitValue: true,
                value: 1,
                id: 'sysFinalidadProcedimientoProc'
            },
            {
                xtype: 'combo',
                fieldLabel: 'Personal Atiende',
                width:700,
                name: 'Personal Atiende',
                allowBlank: false,
                store: 'StorePersonalAtiendeProcedimiento',
                forceSelection: true,
                triggerAction: 'all',
                typeAhead: true,
                typeAheadDelay: 50,
                mode: 'local',
                valueField: 'Codigo',
                displayField: 'Descripcion',
                emptyText: 'Seleccione....',
                submitValue: true,
                value: 1,
                id: 'sysPersonalAtiendeProcedimientoProc'
            },
            {
                xtype: 'combo',
                fieldLabel: 'Forma Realización Acto Quirúrgico',
                width:700,
                name: 'Forma Realización Acto Quirúrgico',
                allowBlank: false,
                store: 'StoreFormaRealizacionProcedimiento',
                forceSelection: true,
                triggerAction: 'all',
                typeAhead: true,
                typeAheadDelay: 50,
                mode: 'local',
                valueField: 'Codigo',
                displayField: 'Descripcion',
                emptyText: 'Seleccione....',
                submitValue: true,
                value: 1,
                id: 'sysFormaRealizaProcedimientoProc'
            }
        ];
        fsDiagnosticosConsultaUi.superclass.initComponent.call(this);
    }
});
