/*
* @category    Panel Programas Especiales
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


pnProgramasEspecialesUi = Ext.extend(Ext.Panel, {
    anchor: '100%',
    autoHeight: true,
    layout: 'form',
    collapseFirst: false,
    collapsible: false,
    animCollapse: false,
    titleCollapse: false,
    border: false,
    padding: 0,
    id: 'pnProgramasEspeciales',
    initComponent: function() {
        this.items = [
            {
                xtype: 'fieldset',
                title: 'INFORMACION PROGRAMAS ESPECIALES (HTA - DM - NEFROPROTECCION)',
                layout: 'form',
                collapseFirst: false,
                collapsible: true,
                animCollapse: true,
                titleCollapse: true,
                anchor: '100%',
                autoHeight: true,
                padding: 5,
                id: 'fsProgramasEspeciales',
                items: [
                    {
                        xtype: 'panel',
                        anchor: '100%',
                        autoHeight: true,
                        labelWidth: 290,
                        layout: 'form',
                        items: [
                            {
                                xtype: 'combo',
                                fieldLabel: 'Esta Atencion corresponde a ingreso al programa?',
                                name: 'Esta Atencion corresponde a ingreso al programa?',
                                width: 90,
                                allowBlank: true,
                                store: 'StoreSiNo',
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strPROGESPEIngreso',
                                listeners:{
                                    change : function( t, newValue, oldValue){
                                        if(newValue == "NO"){
                                            Ext.getCmp('fecPROGESPEIngreso').allowBlank = true;
                                            Ext.getCmp('strPROGESPEViaCaptacion').allowBlank = true;
                                            Ext.getCmp('strPROGESPEDxHTA').allowBlank = false;
                                            Ext.getCmp('strPROGESPETipoDxHTA').allowBlank = false;
                                            Ext.getCmp('strPROGESPENivelRiesgoHTA').allowBlank = false;
                                            Ext.getCmp('intPROGESPEDxHTAMes').allowBlank = false;
                                            Ext.getCmp('intPROGESPEDxHTAAno').allowBlank = false;
                                            Ext.getCmp('strPROGESPEDxHTAEstadio').allowBlank = false;
                                            Ext.getCmp('strPROGESPEDxDM').allowBlank = false;
                                            Ext.getCmp('strPROGESPETipoDxDM').allowBlank = false;
                                            Ext.getCmp('strPROGESPENivelRiesgoDM').allowBlank = false;
                                            Ext.getCmp('intPROGESPEDxDMMes').allowBlank = false;
                                            Ext.getCmp('intPROGESPEDxDMAno').allowBlank = false;
                                            Ext.getCmp('strPROGESPETipoDM').allowBlank = false;
                                            Ext.getCmp('strPROGESPEDxNefroProteccion').allowBlank = false;
                                            Ext.getCmp('strPROGESPETipoDxNefroProteccion').allowBlank = false;
                                            Ext.getCmp('strPROGESPENivelRiesgoNefroProteccion').allowBlank = false;
                                            Ext.getCmp('intPROGESPEDxNefroProteccionMes').allowBlank = false;
                                            Ext.getCmp('intPROGESPEDxNefroProteccionAno').allowBlank = false;
                                            Ext.getCmp('strPROGESPEEstadioNefroProteccion').allowBlank = false;
                                            Ext.getCmp('fecPROGESPEParcialorina').allowBlank = true;
                                            Ext.getCmp('strPROGESPEParcialorinaRes').allowBlank = true;
                                            Ext.getCmp('fecPROGESPEColesterolTotal').allowBlank = true;
                                            Ext.getCmp('strPROGESPEColesterolTotalRes').allowBlank = true;
                                            Ext.getCmp('fecPROGESPEColesterolHDL').allowBlank = true;
                                            Ext.getCmp('strPROGESPEColesterolHDLRes').allowBlank = true;
                                            Ext.getCmp('fecPROGESPEColesterolLDL').allowBlank = true;
                                            Ext.getCmp('strPROGESPEColesterolLDLRes').allowBlank = true;
                                            Ext.getCmp('fecPROGESPETrigliceridos').allowBlank = true;
                                            Ext.getCmp('strPROGESPETrigliceridosRes').allowBlank = true;
                                            Ext.getCmp('fecPROGESPEHemoglobinaGlicosilada').allowBlank = true;
                                            Ext.getCmp('strPROGESPEHemoglobinaGlicosiladaRes').allowBlank = true;
                                            Ext.getCmp('fecPROGESPEGlicemia').allowBlank = true;
                                            Ext.getCmp('strPROGESPEGlicemiaRes').allowBlank = true;
                                            Ext.getCmp('fecPROGESPEMicroAlbuminuria').allowBlank = true;
                                            Ext.getCmp('strPROGESPEMicroAlbuminuriaRes').allowBlank = true;
                                            Ext.getCmp('fecPROGESPEUrea').allowBlank = true;
                                            Ext.getCmp('strPROGESPEUreaRes').allowBlank = true;
                                            Ext.getCmp('fecPROGESPECreatinina').allowBlank = true;
                                            Ext.getCmp('strPROGESPECreatininaRes').allowBlank = true;
                                            Ext.getCmp('strPROGESPESeguimientoTraeParcialorina').allowBlank = true;
                                            Ext.getCmp('fecPROGESPESeguimientoParcialorina').allowBlank = true;
                                            Ext.getCmp('strPROGESPESeguimientoParcialorinaRes').allowBlank = true;
                                            Ext.getCmp('strPROGESPESeguimientoTraeColesterolTotal').allowBlank = true;
                                            Ext.getCmp('fecPROGESPESeguimientoColesterolTotal').allowBlank = true;
                                            Ext.getCmp('strPROGESPESeguimientoColesterolTotalRes').allowBlank = true;
                                            Ext.getCmp('strPROGESPESeguimientoTraeColesterolHDL').allowBlank = true;
                                            Ext.getCmp('fecPROGESPESeguimientoColesterolHDL').allowBlank = true;
                                            Ext.getCmp('strPROGESPESeguimientoColesterolHDLRes').allowBlank = true;
                                            Ext.getCmp('strPROGESPESeguimientoTraeColesterolLDL').allowBlank = true;
                                            Ext.getCmp('fecPROGESPESeguimientoColesterolLDL').allowBlank = true;
                                            Ext.getCmp('strPROGESPESeguimientoColesterolLDLRes').allowBlank = true;
                                            Ext.getCmp('strPROGESPESeguimientoTraeTrigliceridos').allowBlank = true;
                                            Ext.getCmp('fecPROGESPESeguimientoTrigliceridos').allowBlank = true;
                                            Ext.getCmp('strPROGESPESeguimientoTrigliceridosRes').allowBlank = true;
                                            Ext.getCmp('strPROGESPESeguimientoTraeHemoglobinaGlicosilada').allowBlank = true;
                                            Ext.getCmp('fecPROGESPESeguimientoHemoglobinaGlicosilada').allowBlank = true;
                                            Ext.getCmp('strPROGESPESeguimientoHemoglobinaGlicosiladaRes').allowBlank = true;
                                            Ext.getCmp('strPROGESPESeguimientoTraeGlicemia').allowBlank = true;
                                            Ext.getCmp('fecPROGESPESeguimientoGlicemia').allowBlank = true;
                                            Ext.getCmp('strPROGESPESeguimientoGlicemiaRes').allowBlank = true;
                                            Ext.getCmp('strPROGESPESeguimientoTraeMicroAlbuminuria').allowBlank = true;
                                            Ext.getCmp('fecPROGESPESeguimientoMicroAlbuminuria').allowBlank = true;
                                            Ext.getCmp('strPROGESPESeguimientoMicroAlbuminuriaRes').allowBlank = true;
                                            Ext.getCmp('strPROGESPESeguimientoTraeUrea').allowBlank = true;
                                            Ext.getCmp('fecPROGESPESeguimientoUrea').allowBlank = true;
                                            Ext.getCmp('strPROGESPESeguimientoUreaRes').allowBlank = true;
                                            Ext.getCmp('strPROGESPESeguimientoTraeCreatinina').allowBlank = true;
                                            Ext.getCmp('fecPROGESPESeguimientoCreatinina').allowBlank = true;
                                            Ext.getCmp('strPROGESPESeguimientoCreatininaRes').allowBlank = true;
                                            Ext.getCmp('strPROGESPETFGSeguimiento').allowBlank = true;
                                            Ext.getCmp('strPROGESPETFGSeguimientoCalsifica').allowBlank = true;
                                            Ext.getCmp('memPROGESPEMetasTerapeuticas').allowBlank = true;
                                            Ext.getCmp('strPROGESPECumplimientoMetas').allowBlank = true;
                                            Ext.getCmp('intPROGESPENumCumplimientoMetas').allowBlank = true;
                                            Ext.getCmp('fecPROGESPEIngreso').readOnly=false;
                                            Ext.getCmp('strPROGESPEViaCaptacion').readOnly=false;
                                            Ext.getCmp('strPROGESPEDxHTA').readOnly=false;
                                            Ext.getCmp('strPROGESPETipoDxHTA').readOnly=false;
                                            Ext.getCmp('strPROGESPENivelRiesgoHTA').readOnly=false;
                                            Ext.getCmp('intPROGESPEDxHTAMes').readOnly=false;
                                            Ext.getCmp('intPROGESPEDxHTAAno').readOnly=false;
                                            Ext.getCmp('strPROGESPEDxHTAEstadio').readOnly=false;
                                            Ext.getCmp('strPROGESPEDxDM').readOnly=false;
                                            Ext.getCmp('strPROGESPETipoDxDM').readOnly=false;
                                            Ext.getCmp('strPROGESPENivelRiesgoDM').readOnly=false;
                                            Ext.getCmp('intPROGESPEDxDMMes').readOnly=false;
                                            Ext.getCmp('intPROGESPEDxDMAno').readOnly=false;
                                            Ext.getCmp('strPROGESPETipoDM').readOnly=false;
                                            Ext.getCmp('strPROGESPEDxNefroProteccion').readOnly=false;
                                            Ext.getCmp('strPROGESPETipoDxNefroProteccion').readOnly=false;
                                            Ext.getCmp('strPROGESPENivelRiesgoNefroProteccion').readOnly=false;
                                            Ext.getCmp('intPROGESPEDxNefroProteccionMes').readOnly=false;
                                            Ext.getCmp('intPROGESPEDxNefroProteccionAno').readOnly=false;
                                            Ext.getCmp('strPROGESPEEstadioNefroProteccion').readOnly=false;
                                            Ext.getCmp('fecPROGESPEParcialorina').readOnly=true;
                                            Ext.getCmp('strPROGESPEParcialorinaRes').readOnly=true;
                                            Ext.getCmp('fecPROGESPEColesterolTotal').readOnly=true;
                                            Ext.getCmp('strPROGESPEColesterolTotalRes').readOnly=true;
                                            Ext.getCmp('fecPROGESPEColesterolHDL').readOnly=true;
                                            Ext.getCmp('strPROGESPEColesterolHDLRes').readOnly=true;
                                            Ext.getCmp('fecPROGESPEColesterolLDL').readOnly=true;
                                            Ext.getCmp('strPROGESPEColesterolLDLRes').readOnly=true;
                                            Ext.getCmp('fecPROGESPETrigliceridos').readOnly=true;
                                            Ext.getCmp('strPROGESPETrigliceridosRes').readOnly=true;
                                            Ext.getCmp('fecPROGESPEHemoglobinaGlicosilada').readOnly=true;
                                            Ext.getCmp('strPROGESPEHemoglobinaGlicosiladaRes').readOnly=true;
                                            Ext.getCmp('fecPROGESPEGlicemia').readOnly=true;
                                            Ext.getCmp('strPROGESPEGlicemiaRes').readOnly=true;
                                            Ext.getCmp('fecPROGESPEMicroAlbuminuria').readOnly=true;
                                            Ext.getCmp('strPROGESPEMicroAlbuminuriaRes').readOnly=true;
                                            Ext.getCmp('fecPROGESPEUrea').readOnly=true;
                                            Ext.getCmp('strPROGESPEUreaRes').readOnly=true;
                                            Ext.getCmp('fecPROGESPECreatinina').readOnly=true;
                                            Ext.getCmp('strPROGESPECreatininaRes').readOnly=true;
                                            Ext.getCmp('strPROGESPESeguimientoTraeParcialorina').readOnly=false;
                                            Ext.getCmp('fecPROGESPESeguimientoParcialorina').readOnly=false;
                                            Ext.getCmp('strPROGESPESeguimientoParcialorinaRes').readOnly=false;
                                            Ext.getCmp('strPROGESPESeguimientoTraeColesterolTotal').readOnly=false;
                                            Ext.getCmp('fecPROGESPESeguimientoColesterolTotal').readOnly=false;
                                            Ext.getCmp('strPROGESPESeguimientoColesterolTotalRes').readOnly=false;
                                            Ext.getCmp('strPROGESPESeguimientoTraeColesterolHDL').readOnly=false;
                                            Ext.getCmp('fecPROGESPESeguimientoColesterolHDL').readOnly=false;
                                            Ext.getCmp('strPROGESPESeguimientoColesterolHDLRes').readOnly=false;
                                            Ext.getCmp('strPROGESPESeguimientoTraeColesterolLDL').readOnly=false;
                                            Ext.getCmp('fecPROGESPESeguimientoColesterolLDL').readOnly=false;
                                            Ext.getCmp('strPROGESPESeguimientoColesterolLDLRes').readOnly=false;
                                            Ext.getCmp('strPROGESPESeguimientoTraeTrigliceridos').readOnly=false;
                                            Ext.getCmp('fecPROGESPESeguimientoTrigliceridos').readOnly=false;
                                            Ext.getCmp('strPROGESPESeguimientoTrigliceridosRes').readOnly=false;
                                            Ext.getCmp('strPROGESPESeguimientoTraeHemoglobinaGlicosilada').readOnly=false;
                                            Ext.getCmp('fecPROGESPESeguimientoHemoglobinaGlicosilada').readOnly=false;
                                            Ext.getCmp('strPROGESPESeguimientoHemoglobinaGlicosiladaRes').readOnly=false;
                                            Ext.getCmp('strPROGESPESeguimientoTraeGlicemia').readOnly=false;
                                            Ext.getCmp('fecPROGESPESeguimientoGlicemia').readOnly=false;
                                            Ext.getCmp('strPROGESPESeguimientoGlicemiaRes').readOnly=false;
                                            Ext.getCmp('strPROGESPESeguimientoTraeMicroAlbuminuria').readOnly=false;
                                            Ext.getCmp('fecPROGESPESeguimientoMicroAlbuminuria').readOnly=false;
                                            Ext.getCmp('strPROGESPESeguimientoMicroAlbuminuriaRes').readOnly=false;
                                            Ext.getCmp('strPROGESPESeguimientoTraeUrea').readOnly=false;
                                            Ext.getCmp('fecPROGESPESeguimientoUrea').readOnly=false;
                                            Ext.getCmp('strPROGESPESeguimientoUreaRes').readOnly=false;
                                            Ext.getCmp('strPROGESPESeguimientoTraeCreatinina').readOnly=false;
                                            Ext.getCmp('fecPROGESPESeguimientoCreatinina').readOnly=false;
                                            Ext.getCmp('strPROGESPESeguimientoCreatininaRes').readOnly=false;
                                            Ext.getCmp('strPROGESPETFGSeguimiento').readOnly=false;
                                            Ext.getCmp('strPROGESPETFGSeguimientoCalsifica').readOnly=false;
                                            Ext.getCmp('memPROGESPEMetasTerapeuticas').readOnly=false;
                                            Ext.getCmp('strPROGESPECumplimientoMetas').readOnly=false;
                                            Ext.getCmp('intPROGESPENumCumplimientoMetas').readOnly=false;
                                        }else{
                                            Ext.getCmp('fecPROGESPEIngreso').allowBlank = false;
                                            Ext.getCmp('strPROGESPEViaCaptacion').allowBlank = false;
                                            Ext.getCmp('strPROGESPEDxHTA').allowBlank = false;
                                            Ext.getCmp('strPROGESPETipoDxHTA').allowBlank = false;
                                            Ext.getCmp('strPROGESPENivelRiesgoHTA').allowBlank = false;
                                            Ext.getCmp('intPROGESPEDxHTAMes').allowBlank = false;
                                            Ext.getCmp('intPROGESPEDxHTAAno').allowBlank = false;
                                            Ext.getCmp('strPROGESPEDxHTAEstadio').allowBlank = false;
                                            Ext.getCmp('strPROGESPEDxDM').allowBlank = false;
                                            Ext.getCmp('strPROGESPETipoDxDM').allowBlank = false;
                                            Ext.getCmp('strPROGESPENivelRiesgoDM').allowBlank = false;
                                            Ext.getCmp('intPROGESPEDxDMMes').allowBlank = false;
                                            Ext.getCmp('intPROGESPEDxDMAno').allowBlank = false;
                                            Ext.getCmp('strPROGESPETipoDM').allowBlank = false;
                                            Ext.getCmp('strPROGESPEDxNefroProteccion').allowBlank = false;
                                            Ext.getCmp('strPROGESPETipoDxNefroProteccion').allowBlank = false;
                                            Ext.getCmp('strPROGESPENivelRiesgoNefroProteccion').allowBlank = false;
                                            Ext.getCmp('intPROGESPEDxNefroProteccionMes').allowBlank = false;
                                            Ext.getCmp('intPROGESPEDxNefroProteccionAno').allowBlank = false;
                                            Ext.getCmp('strPROGESPEEstadioNefroProteccion').allowBlank = false;
                                            Ext.getCmp('fecPROGESPEParcialorina').allowBlank = true;
                                            Ext.getCmp('strPROGESPEParcialorinaRes').allowBlank = true;
                                            Ext.getCmp('fecPROGESPEColesterolTotal').allowBlank = true;
                                            Ext.getCmp('strPROGESPEColesterolTotalRes').allowBlank = true;
                                            Ext.getCmp('fecPROGESPEColesterolHDL').allowBlank = true;
                                            Ext.getCmp('strPROGESPEColesterolHDLRes').allowBlank = true;
                                            Ext.getCmp('fecPROGESPEColesterolLDL').allowBlank = true;
                                            Ext.getCmp('strPROGESPEColesterolLDLRes').allowBlank = true;
                                            Ext.getCmp('fecPROGESPETrigliceridos').allowBlank = true;
                                            Ext.getCmp('strPROGESPETrigliceridosRes').allowBlank = true;
                                            Ext.getCmp('fecPROGESPEHemoglobinaGlicosilada').allowBlank = true;
                                            Ext.getCmp('strPROGESPEHemoglobinaGlicosiladaRes').allowBlank = true;
                                            Ext.getCmp('fecPROGESPEGlicemia').allowBlank = true;
                                            Ext.getCmp('strPROGESPEGlicemiaRes').allowBlank = true;
                                            Ext.getCmp('fecPROGESPEMicroAlbuminuria').allowBlank = true;
                                            Ext.getCmp('strPROGESPEMicroAlbuminuriaRes').allowBlank = true;
                                            Ext.getCmp('fecPROGESPEUrea').allowBlank = true;
                                            Ext.getCmp('strPROGESPEUreaRes').allowBlank = true;
                                            Ext.getCmp('fecPROGESPECreatinina').allowBlank = true;
                                            Ext.getCmp('strPROGESPECreatininaRes').allowBlank = true;
                                            Ext.getCmp('strPROGESPESeguimientoTraeParcialorina').allowBlank = true;
                                            Ext.getCmp('fecPROGESPESeguimientoParcialorina').allowBlank = true;
                                            Ext.getCmp('strPROGESPESeguimientoParcialorinaRes').allowBlank = true;
                                            Ext.getCmp('strPROGESPESeguimientoTraeColesterolTotal').allowBlank = true;
                                            Ext.getCmp('fecPROGESPESeguimientoColesterolTotal').allowBlank = true;
                                            Ext.getCmp('strPROGESPESeguimientoColesterolTotalRes').allowBlank = true;
                                            Ext.getCmp('strPROGESPESeguimientoTraeColesterolHDL').allowBlank = true;
                                            Ext.getCmp('fecPROGESPESeguimientoColesterolHDL').allowBlank = true;
                                            Ext.getCmp('strPROGESPESeguimientoColesterolHDLRes').allowBlank = true;
                                            Ext.getCmp('strPROGESPESeguimientoTraeColesterolLDL').allowBlank = true;
                                            Ext.getCmp('fecPROGESPESeguimientoColesterolLDL').allowBlank = true;
                                            Ext.getCmp('strPROGESPESeguimientoColesterolLDLRes').allowBlank = true;
                                            Ext.getCmp('strPROGESPESeguimientoTraeTrigliceridos').allowBlank = true;
                                            Ext.getCmp('fecPROGESPESeguimientoTrigliceridos').allowBlank = true;
                                            Ext.getCmp('strPROGESPESeguimientoTrigliceridosRes').allowBlank = true;
                                            Ext.getCmp('strPROGESPESeguimientoTraeHemoglobinaGlicosilada').allowBlank = true;
                                            Ext.getCmp('fecPROGESPESeguimientoHemoglobinaGlicosilada').allowBlank = true;
                                            Ext.getCmp('strPROGESPESeguimientoHemoglobinaGlicosiladaRes').allowBlank = true;
                                            Ext.getCmp('strPROGESPESeguimientoTraeGlicemia').allowBlank = true;
                                            Ext.getCmp('fecPROGESPESeguimientoGlicemia').allowBlank = true;
                                            Ext.getCmp('strPROGESPESeguimientoGlicemiaRes').allowBlank = true;
                                            Ext.getCmp('strPROGESPESeguimientoTraeMicroAlbuminuria').allowBlank = true;
                                            Ext.getCmp('fecPROGESPESeguimientoMicroAlbuminuria').allowBlank = true;
                                            Ext.getCmp('strPROGESPESeguimientoMicroAlbuminuriaRes').allowBlank = true;
                                            Ext.getCmp('strPROGESPESeguimientoTraeUrea').allowBlank = true;
                                            Ext.getCmp('fecPROGESPESeguimientoUrea').allowBlank = true;
                                            Ext.getCmp('strPROGESPESeguimientoUreaRes').allowBlank = true;
                                            Ext.getCmp('strPROGESPESeguimientoTraeCreatinina').allowBlank = true;
                                            Ext.getCmp('fecPROGESPESeguimientoCreatinina').allowBlank = true;
                                            Ext.getCmp('strPROGESPESeguimientoCreatininaRes').allowBlank = true;
                                            Ext.getCmp('strPROGESPETFGSeguimiento').allowBlank = true;
                                            Ext.getCmp('strPROGESPETFGSeguimientoCalsifica').allowBlank = true;
                                            Ext.getCmp('memPROGESPEMetasTerapeuticas').allowBlank = true;
                                            Ext.getCmp('strPROGESPECumplimientoMetas').allowBlank = true;
                                            Ext.getCmp('intPROGESPENumCumplimientoMetas').allowBlank = true;
                                            Ext.getCmp('fecPROGESPEIngreso').readOnly=false;
                                            Ext.getCmp('strPROGESPEViaCaptacion').readOnly=false;
                                            Ext.getCmp('strPROGESPEDxHTA').readOnly=false;
                                            Ext.getCmp('strPROGESPETipoDxHTA').readOnly=false;
                                            Ext.getCmp('strPROGESPENivelRiesgoHTA').readOnly=false;
                                            Ext.getCmp('intPROGESPEDxHTAMes').readOnly=false;
                                            Ext.getCmp('intPROGESPEDxHTAAno').readOnly=false;
                                            Ext.getCmp('strPROGESPEDxHTAEstadio').readOnly=false;
                                            Ext.getCmp('strPROGESPEDxDM').readOnly=false;
                                            Ext.getCmp('strPROGESPETipoDxDM').readOnly=false;
                                            Ext.getCmp('strPROGESPENivelRiesgoDM').readOnly=false;
                                            Ext.getCmp('intPROGESPEDxDMMes').readOnly=false;
                                            Ext.getCmp('intPROGESPEDxDMAno').readOnly=false;
                                            Ext.getCmp('strPROGESPETipoDM').readOnly=false;
                                            Ext.getCmp('strPROGESPEDxNefroProteccion').readOnly=false;
                                            Ext.getCmp('strPROGESPETipoDxNefroProteccion').readOnly=false;
                                            Ext.getCmp('strPROGESPENivelRiesgoNefroProteccion').readOnly=false;
                                            Ext.getCmp('intPROGESPEDxNefroProteccionMes').readOnly=false;
                                            Ext.getCmp('intPROGESPEDxNefroProteccionAno').readOnly=false;
                                            Ext.getCmp('strPROGESPEEstadioNefroProteccion').readOnly=false;
                                            Ext.getCmp('fecPROGESPEParcialorina').readOnly=false;
                                            Ext.getCmp('strPROGESPEParcialorinaRes').readOnly=false;
                                            Ext.getCmp('fecPROGESPEColesterolTotal').readOnly=false;
                                            Ext.getCmp('strPROGESPEColesterolTotalRes').readOnly=false;
                                            Ext.getCmp('fecPROGESPEColesterolHDL').readOnly=false;
                                            Ext.getCmp('strPROGESPEColesterolHDLRes').readOnly=false;
                                            Ext.getCmp('fecPROGESPEColesterolLDL').readOnly=false;
                                            Ext.getCmp('strPROGESPEColesterolLDLRes').readOnly=false;
                                            Ext.getCmp('fecPROGESPETrigliceridos').readOnly=false;
                                            Ext.getCmp('strPROGESPETrigliceridosRes').readOnly=false;
                                            Ext.getCmp('fecPROGESPEHemoglobinaGlicosilada').readOnly=false;
                                            Ext.getCmp('strPROGESPEHemoglobinaGlicosiladaRes').readOnly=false;
                                            Ext.getCmp('fecPROGESPEGlicemia').readOnly=false;
                                            Ext.getCmp('strPROGESPEGlicemiaRes').readOnly=false;
                                            Ext.getCmp('fecPROGESPEMicroAlbuminuria').readOnly=false;
                                            Ext.getCmp('strPROGESPEMicroAlbuminuriaRes').readOnly=false;
                                            Ext.getCmp('fecPROGESPEUrea').readOnly=false;
                                            Ext.getCmp('strPROGESPEUreaRes').readOnly=false;
                                            Ext.getCmp('fecPROGESPECreatinina').readOnly=false;
                                            Ext.getCmp('strPROGESPECreatininaRes').readOnly=false;
                                            Ext.getCmp('strPROGESPESeguimientoTraeParcialorina').readOnly=true;
                                            Ext.getCmp('fecPROGESPESeguimientoParcialorina').readOnly=true;
                                            Ext.getCmp('strPROGESPESeguimientoParcialorinaRes').readOnly=true;
                                            Ext.getCmp('strPROGESPESeguimientoTraeColesterolTotal').readOnly=true;
                                            Ext.getCmp('fecPROGESPESeguimientoColesterolTotal').readOnly=true;
                                            Ext.getCmp('strPROGESPESeguimientoColesterolTotalRes').readOnly=true;
                                            Ext.getCmp('strPROGESPESeguimientoTraeColesterolHDL').readOnly=true;
                                            Ext.getCmp('fecPROGESPESeguimientoColesterolHDL').readOnly=true;
                                            Ext.getCmp('strPROGESPESeguimientoColesterolHDLRes').readOnly=true;
                                            Ext.getCmp('strPROGESPESeguimientoTraeColesterolLDL').readOnly=true;
                                            Ext.getCmp('fecPROGESPESeguimientoColesterolLDL').readOnly=true;
                                            Ext.getCmp('strPROGESPESeguimientoColesterolLDLRes').readOnly=true;
                                            Ext.getCmp('strPROGESPESeguimientoTraeTrigliceridos').readOnly=true;
                                            Ext.getCmp('fecPROGESPESeguimientoTrigliceridos').readOnly=true;
                                            Ext.getCmp('strPROGESPESeguimientoTrigliceridosRes').readOnly=true;
                                            Ext.getCmp('strPROGESPESeguimientoTraeHemoglobinaGlicosilada').readOnly=true;
                                            Ext.getCmp('fecPROGESPESeguimientoHemoglobinaGlicosilada').readOnly=true;
                                            Ext.getCmp('strPROGESPESeguimientoHemoglobinaGlicosiladaRes').readOnly=true;
                                            Ext.getCmp('strPROGESPESeguimientoTraeGlicemia').readOnly=true;
                                            Ext.getCmp('fecPROGESPESeguimientoGlicemia').readOnly=true;
                                            Ext.getCmp('strPROGESPESeguimientoGlicemiaRes').readOnly=true;
                                            Ext.getCmp('strPROGESPESeguimientoTraeMicroAlbuminuria').readOnly=true;
                                            Ext.getCmp('fecPROGESPESeguimientoMicroAlbuminuria').readOnly=true;
                                            Ext.getCmp('strPROGESPESeguimientoMicroAlbuminuriaRes').readOnly=true;
                                            Ext.getCmp('strPROGESPESeguimientoTraeUrea').readOnly=true;
                                            Ext.getCmp('fecPROGESPESeguimientoUrea').readOnly=true;
                                            Ext.getCmp('strPROGESPESeguimientoUreaRes').readOnly=true;
                                            Ext.getCmp('strPROGESPESeguimientoTraeCreatinina').readOnly=true;
                                            Ext.getCmp('fecPROGESPESeguimientoCreatinina').readOnly=true;
                                            Ext.getCmp('strPROGESPESeguimientoCreatininaRes').readOnly=true;
                                            Ext.getCmp('strPROGESPETFGSeguimiento').readOnly=true;
                                            Ext.getCmp('strPROGESPETFGSeguimientoCalsifica').readOnly=true;
                                            Ext.getCmp('memPROGESPEMetasTerapeuticas').readOnly=false;
                                            Ext.getCmp('strPROGESPECumplimientoMetas').readOnly=false;
                                            Ext.getCmp('intPROGESPENumCumplimientoMetas').readOnly=false;

                                        }
                                    }
                                }
                            }
                        ]
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'datefield',
                                width: 120,
                                fieldLabel: 'Fecha Ingreso',
                                name: 'Fecha Ingreso',
                                allowBlank: true,
                                emptyText: '(dia/mes/año) ',
                                style: 'text-align:center;',
                                id: 'fecPROGESPEIngreso'
                            },
                            {
                                html: '   Via de Captacion:'
                            },
                            {
                                xtype: 'combo',
                                name: 'Via de Captacion',
                                width: 250,
                                allowBlank: true,
                                store: stViaCaptacion,
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strPROGESPEViaCaptacion'
                            }
                        ]
                    },
                    {
                        html: '<br><hr><br>'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'combo',
                                fieldLabel: 'Dx HTA',
                                name: 'Dx HTA',
                                width: 60,
                                allowBlank: true,
                                store: 'StoreSiNo',
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strPROGESPEDxHTA',
                                listeners:{
                                    change : function( t, newValue, oldValue){
                                        if(newValue == "NO"){
                                            Ext.getCmp('strPROGESPETipoDxHTA').allowBlank = true;
                                            Ext.getCmp('intPROGESPEDxHTAMes').allowBlank = true;
                                            Ext.getCmp('intPROGESPEDxHTAAno').allowBlank = true;
                                            Ext.getCmp('strPROGESPENivelRiesgoHTA').allowBlank = true;
                                            Ext.getCmp('strPROGESPEDxHTAEstadio').allowBlank = true;
                                            Ext.getCmp('strPROGESPETipoDxHTA').setValue(null);
                                            Ext.getCmp('intPROGESPEDxHTAMes').setValue(null);
                                            Ext.getCmp('intPROGESPEDxHTAAno').setValue(null);
                                            Ext.getCmp('strPROGESPENivelRiesgoHTA').setValue(null);
                                            Ext.getCmp('strPROGESPEDxHTAEstadio').setValue(null);
                                            Ext.getCmp('strPROGESPETipoDxHTA').disable();
                                            Ext.getCmp('intPROGESPEDxHTAMes').disable();
                                            Ext.getCmp('intPROGESPEDxHTAAno').disable();
                                            Ext.getCmp('strPROGESPEDxHTAEstadio').disable();
                                            Ext.getCmp('strPROGESPENivelRiesgoHTA').disable();
                                            Ext.getCmp('strPROGESPETipoDxHTA').clearInvalid();
                                            Ext.getCmp('intPROGESPEDxHTAMes').clearInvalid();
                                            Ext.getCmp('strPROGESPEDxHTAEstadio').clearInvalid();
                                            Ext.getCmp('intPROGESPEDxHTAAno').clearInvalid();
                                            Ext.getCmp('strPROGESPENivelRiesgoHTA').clearInvalid();
                                        }else{
                                            Ext.getCmp('strPROGESPETipoDxHTA').enable();
                                            Ext.getCmp('intPROGESPEDxHTAMes').enable();
                                            Ext.getCmp('intPROGESPEDxHTAAno').enable();
                                            Ext.getCmp('strPROGESPENivelRiesgoHTA').enable();
                                            Ext.getCmp('strPROGESPEDxHTAEstadio').allowBlank = false;
                                            Ext.getCmp('strPROGESPEDxHTAEstadio').enable();
                                            Ext.getCmp('strPROGESPETipoDxHTA').allowBlank = false;
                                            Ext.getCmp('intPROGESPEDxHTAMes').allowBlank = false;
                                            Ext.getCmp('intPROGESPEDxHTAAno').allowBlank = false;
                                            Ext.getCmp('strPROGESPENivelRiesgoHTA').allowBlank = false;
                                            calculoEstadioHTA()
                                        }
                                    }
                                }
                            },
                            {
                                html:'Tipo de Dx:'
                            },
                            {
                                xtype: 'combo',
                                name: 'Tipo de Dx',
                                width: 90,
                                allowBlank: true,
                                store: stDatProgTipoDx,
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strPROGESPETipoDxHTA'
                            },
                            {
                                html:'Nivel de Riesgo:'
                            },
                            {
                                xtype: 'combo',
                                name: 'Nivel de Riesgo',
                                width: 90,
                                allowBlank: true,
                                store: stDatProgNivelRiesgo,
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strPROGESPENivelRiesgoHTA'
                            },
                            {
                                html:'Fecha Dx:'
                            },
                            {
                                xtype: 'numberfield',
                                name: 'Mes',
                                emptyText: 'Mes',
                                width: 50,
                                minValue: 1,
                                maxValue: 12,
                                decimalPrecision: 0,
                                allowBlank: true,
                                id: 'intPROGESPEDxHTAMes'
                            },
                            {
                                html:'/'
                            },
                            {
                                xtype: 'numberfield',
                                name: 'Año',
                                emptyText: 'Año',
                                width: 70,
                                minValue: 1900,
                                maxValue: 2199,
                                decimalPrecision: 0,
                                allowBlank: true,
                                id: 'intPROGESPEDxHTAAno'
                            },
                            {
                                html:'Estadio:'
                            },
                            {
                                xtype: 'textfield',
                                name: 'Estadio',
                                width: 90,
                                emptyText: 'Resultado',
                                readOnly: true,
                                allowBlank: true,
                                id: 'strPROGESPEDxHTAEstadio'
                            }
                        ]
                    },
                    {
                        html: '<br>'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'combo',
                                fieldLabel: 'Dx DM',
                                name: 'Dx DM',
                                width: 60,
                                allowBlank: true,
                                store: 'StoreSiNo',
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strPROGESPEDxDM',
                                listeners:{
                                    change : function( t, newValue, oldValue){
                                        if(newValue == "NO"){
                                            Ext.getCmp('strPROGESPETipoDxDM').allowBlank = true;
                                            Ext.getCmp('intPROGESPEDxDMMes').allowBlank = true;
                                            Ext.getCmp('intPROGESPEDxDMAno').allowBlank = true;
                                            Ext.getCmp('strPROGESPENivelRiesgoDM').allowBlank = true;
                                            Ext.getCmp('strPROGESPETipoDM').allowBlank = true;
                                            Ext.getCmp('strPROGESPETipoDxDM').setValue(null);
                                            Ext.getCmp('intPROGESPEDxDMMes').setValue(null);
                                            Ext.getCmp('intPROGESPEDxDMAno').setValue(null);
                                            Ext.getCmp('strPROGESPENivelRiesgoDM').setValue(null);
                                            Ext.getCmp('strPROGESPETipoDM').setValue(null);
                                            Ext.getCmp('strPROGESPETipoDxDM').disable();
                                            Ext.getCmp('intPROGESPEDxDMMes').disable();
                                            Ext.getCmp('intPROGESPEDxDMAno').disable();
                                            Ext.getCmp('strPROGESPENivelRiesgoDM').disable();
                                            Ext.getCmp('strPROGESPETipoDM').disable();
                                            Ext.getCmp('strPROGESPETipoDxDM').clearInvalid();
                                            Ext.getCmp('intPROGESPEDxDMMes').clearInvalid();
                                            Ext.getCmp('intPROGESPEDxDMAno').clearInvalid();
                                            Ext.getCmp('strPROGESPENivelRiesgoDM').clearInvalid();
                                            Ext.getCmp('strPROGESPETipoDM').clearInvalid();
                                        }else{
                                            Ext.getCmp('strPROGESPETipoDxDM').enable();
                                            Ext.getCmp('intPROGESPEDxDMMes').enable();
                                            Ext.getCmp('intPROGESPEDxDMAno').enable();
                                            Ext.getCmp('strPROGESPENivelRiesgoDM').enable();
                                            Ext.getCmp('strPROGESPETipoDM').enable();
                                            Ext.getCmp('strPROGESPETipoDxDM').allowBlank = false;
                                            Ext.getCmp('intPROGESPEDxDMMes').allowBlank = false;
                                            Ext.getCmp('intPROGESPEDxDMAno').allowBlank = false;
                                            Ext.getCmp('strPROGESPENivelRiesgoDM').allowBlank = false;
                                            Ext.getCmp('strPROGESPETipoDM').allowBlank = false;
                                        }
                                    }
                                }
                            },
                            {
                                html:'Tipo de Dx:'
                            },
                            {
                                xtype: 'combo',
                                name: 'Tipo de Dx',
                                width: 90,
                                allowBlank: true,
                                store: stDatProgTipoDx,
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strPROGESPETipoDxDM'
                            },
                            {
                                html:'Nivel de Riesgo:'
                            },
                            {
                                xtype: 'combo',
                                name: 'Nivel de Riesgo',
                                width: 90,
                                allowBlank: true,
                                store: stDatProgNivelRiesgo,
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strPROGESPENivelRiesgoDM'
                            },
                            {
                                html:'Fecha Dx:'
                            },
                            {
                                xtype: 'numberfield',
                                name: 'Mes',
                                emptyText: 'Mes',
                                width: 50,
                                minValue: 1,
                                maxValue: 12,
                                decimalPrecision: 0,
                                allowBlank: true,
                                id: 'intPROGESPEDxDMMes'
                            },
                            {
                                html:'/'
                            },
                            {
                                xtype: 'numberfield',
                                name: 'Año',
                                emptyText: 'Año',
                                width: 70,
                                minValue: 1900,
                                maxValue: 2199,
                                decimalPrecision: 0,
                                allowBlank: true,
                                id: 'intPROGESPEDxDMAno'
                            },
                            {
                                html:'Tipo DM:'
                            },
                            {
                                xtype: 'combo',
                                name: 'Tipo de DM',
                                width: 90,
                                allowBlank: true,
                                store: stDatProgTipoDM,
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strPROGESPETipoDM'
                            },
                        ]
                    },
                    {
                        html: '<br>'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'combo',
                                fieldLabel: 'Dx Nefroprot',
                                name: 'Dx Nefroproteccion',
                                width: 60,
                                allowBlank: true,
                                store: 'StoreSiNo',
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strPROGESPEDxNefroProteccion',
                                listeners:{
                                    change : function( t, newValue, oldValue){
                                        if(newValue == "NO"){
                                            Ext.getCmp('strPROGESPETipoDxNefroProteccion').allowBlank = true;
                                            Ext.getCmp('intPROGESPEDxNefroProteccionMes').allowBlank = true;
                                            Ext.getCmp('intPROGESPEDxNefroProteccionAno').allowBlank = true;
                                            Ext.getCmp('strPROGESPENivelRiesgoNefroProteccion').allowBlank = true;
                                            Ext.getCmp('strPROGESPEEstadioNefroProteccion').allowBlank = true;
                                            Ext.getCmp('strPROGESPETipoDxNefroProteccion').setValue(null);
                                            Ext.getCmp('intPROGESPEDxNefroProteccionMes').setValue(null);
                                            Ext.getCmp('intPROGESPEDxNefroProteccionAno').setValue(null);
                                            Ext.getCmp('strPROGESPENivelRiesgoNefroProteccion').setValue(null);
                                            Ext.getCmp('strPROGESPEEstadioNefroProteccion').setValue(null);
                                            Ext.getCmp('strPROGESPETipoDxNefroProteccion').disable();
                                            Ext.getCmp('intPROGESPEDxNefroProteccionMes').disable();
                                            Ext.getCmp('intPROGESPEDxNefroProteccionAno').disable();
                                            Ext.getCmp('strPROGESPENivelRiesgoNefroProteccion').disable();
                                            Ext.getCmp('strPROGESPEEstadioNefroProteccion').disable();
                                            Ext.getCmp('strPROGESPETipoDxNefroProteccion').clearInvalid();
                                            Ext.getCmp('intPROGESPEDxNefroProteccionMes').clearInvalid();
                                            Ext.getCmp('intPROGESPEDxNefroProteccionAno').clearInvalid();
                                            Ext.getCmp('strPROGESPENivelRiesgoNefroProteccion').clearInvalid();
                                            Ext.getCmp('strPROGESPEEstadioNefroProteccion').clearInvalid();
                                        }else{
                                            Ext.getCmp('strPROGESPETipoDxNefroProteccion').enable();
                                            Ext.getCmp('intPROGESPEDxNefroProteccionMes').enable();
                                            Ext.getCmp('intPROGESPEDxNefroProteccionAno').enable();
                                            Ext.getCmp('strPROGESPENivelRiesgoNefroProteccion').enable();
                                            Ext.getCmp('strPROGESPEEstadioNefroProteccion').enable();
                                            Ext.getCmp('strPROGESPETipoDxNefroProteccion').allowBlank = false;
                                            Ext.getCmp('intPROGESPEDxNefroProteccionMes').allowBlank = false;
                                            Ext.getCmp('intPROGESPEDxNefroProteccionAno').allowBlank = false;
                                            Ext.getCmp('strPROGESPENivelRiesgoNefroProteccion').allowBlank = false;
                                            Ext.getCmp('strPROGESPEEstadioNefroProteccion').allowBlank = false;
                                        }
                                    }
                                }
                            },
                            {
                                html:'Tipo de Dx:'
                            },
                            {
                                xtype: 'combo',
                                name: 'Tipo de Dx',
                                width: 90,
                                allowBlank: true,
                                store: stDatProgTipoDx,
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strPROGESPETipoDxNefroProteccion'
                            },
                             {
                                html:'Nivel de Riesgo:'
                            },
                            {
                                xtype: 'combo',
                                name: 'Nivel de Riesgo',
                                width: 90,
                                allowBlank: true,
                                store: stDatProgNivelRiesgo,
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strPROGESPENivelRiesgoNefroProteccion'
                            },
                            {
                                html:'Fecha Dx:'
                            },
                            {
                                xtype: 'numberfield',
                                name: 'Mes',
                                emptyText: 'Mes',
                                width: 50,
                                minValue: 1,
                                maxValue: 12,
                                decimalPrecision: 0,
                                allowBlank: true,
                                id: 'intPROGESPEDxNefroProteccionMes'
                            },
                            {
                                html:'/'
                            },
                            {
                                xtype: 'numberfield',
                                name: 'Año',
                                emptyText: 'Año',
                                width: 70,
                                minValue: 1900,
                                maxValue: 2199,
                                decimalPrecision: 0,
                                allowBlank: true,
                                id: 'intPROGESPEDxNefroProteccionAno'
                            },
                            {
                                html:'Estadio:'
                            },
                            {
                                xtype: 'combo',
                                name: 'Estadio',
                                width: 90,
                                allowBlank: true,
                                store: stDatProgEstadioNefroProteccion,
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strPROGESPEEstadioNefroProteccion'
                            },
                        ]
                    },
                    {
                        html: '<br>'
                    },
                    {
                        xtype: 'fieldset',
                        title: 'Examenes Ingreso',
                        layout: 'form',
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        anchor: '100%',
                        autoHeight: true,
                        padding: 5,
                        items: [
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        name: 'Fecha Parcial Orina',
                                        fieldLabel: 'Parcial Orina',
                                        allowBlank: true,
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecPROGESPEParcialorina'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 200,
                                        name: 'Resultado Pacial Orina',
                                        emptyText: 'Resultado',
                                        allowBlank: true,
                                        id: 'strPROGESPEParcialorinaRes'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        name: 'Fecha Colesterol Total',
                                        fieldLabel: 'Colesterol Total',
                                        allowBlank: true,
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecPROGESPEColesterolTotal'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Resultado Colesterol Total',
                                        emptyText: 'Rango 20 - 700',
                                        width: 200,
                                        decimalPrecision: 0,
                                        allowBlank: true,
                                        id: 'strPROGESPEColesterolTotalRes'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        name: 'Fecha Colesterol HDL',
                                        fieldLabel: 'Colesterol HDL',
                                        allowBlank: true,
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecPROGESPEColesterolHDL'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Resultado Colesterol HDL',
                                        emptyText: 'Rango 10 - 500',
                                        width: 200,
                                        decimalPrecision: 0,
                                        allowBlank: true,
                                        id: 'strPROGESPEColesterolHDLRes'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        name: 'Fecha Colesterol LDL',
                                        fieldLabel: 'Colesterol LDL',
                                        allowBlank: true,
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecPROGESPEColesterolLDL'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Resultado Colesterol LDL',
                                        emptyText: 'Rango 10 - 500',
                                        width: 200,
                                        decimalPrecision: 0,
                                        allowBlank: true,
                                        id: 'strPROGESPEColesterolLDLRes'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        name: 'Fecha Trigliceridos',
                                        fieldLabel: 'Trigliceridos',
                                        allowBlank: true,
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecPROGESPETrigliceridos'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Resultado Trigliceridos',
                                        emptyText: 'Rango 20 - 1000',
                                        width: 200,
                                        decimalPrecision: 0,
                                        allowBlank: true,
                                        id: 'strPROGESPETrigliceridosRes'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        name: 'Fecha Hb Glicosilada',
                                        fieldLabel: 'Hb Glicosilada',
                                        allowBlank: true,
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecPROGESPEHemoglobinaGlicosilada'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Resultado Hb Glicosilada',
                                        emptyText: 'Rango 5 - 20',
                                        width: 200,
                                        decimalPrecision: 0,
                                        allowBlank: true,
                                        id: 'strPROGESPEHemoglobinaGlicosiladaRes'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        name: 'Fecha Glicemia',
                                        fieldLabel: 'Glicemia',
                                        allowBlank: true,
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecPROGESPEGlicemia'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Resultado Glicemia',
                                        emptyText: 'Rango 20 - 1000',
                                        width: 200,
                                        decimalPrecision: 0,
                                        allowBlank: true,
                                        id: 'strPROGESPEGlicemiaRes'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        name: 'Fecha Micro Albuminuria',
                                        fieldLabel: 'Micro Albuminuria',
                                        allowBlank: true,
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecPROGESPEMicroAlbuminuria'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Resultado Micro Albuminuria',
                                        emptyText: 'Rango 0 - 700',
                                        width: 200,
                                        decimalPrecision: 0,
                                        allowBlank: true,
                                        id: 'strPROGESPEMicroAlbuminuriaRes'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        name: 'Fecha Urea',
                                        fieldLabel: 'Urea',
                                        allowBlank: true,
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecPROGESPEUrea'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Resultado Urea',
                                        emptyText: 'Resultado',
                                        width: 200,
                                        decimalPrecision: 0,
                                        allowBlank: true,
                                        id: 'strPROGESPEUreaRes'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        name: 'Fecha Creatinina',
                                        fieldLabel: 'Creatinina',
                                        allowBlank: true,
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecPROGESPECreatinina'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Resultado Creatinina',
                                        emptyText: 'Rango 0,2 - 25',
                                        width: 200,
                                        decimalPrecision: 2,
                                        allowBlank: true,
                                        id: 'strPROGESPECreatininaRes',
                                        listeners:{
                                            change : function(f,pNew, pOld){
                                                if(pNew === null || pNew === 0){
                                                    Ext.getCmp('intPROGESPETFGIngreso').setValue(null);
                                                    Ext.getCmp('strPROGESPETFGIngresoCalsifica').setValue(null);
                                                }else{
                                                    var resultadoTFGIngreso = ((140 - AniosCumplidos) * Ext.getCmp('intEXAFISPeso').getValue()) / (72 * Ext.getCmp('strPROGESPECreatininaRes').getValue())
                                                    
                                                    if(Ext.getCmp('sysGeneroHC').getValue() === "FEMENINO"){
                                                        Ext.getCmp('intPROGESPETFGIngreso').setValue(resultadoTFGIngreso * 0.85);
                                                    }else{
                                                        Ext.getCmp('intPROGESPETFGIngreso').setValue(resultadoTFGIngreso);
                                                    }
                                                    
                                                    if(resultadoTFGIngreso < 15){
                                                        Ext.getCmp('strPROGESPETFGIngresoCalsifica').setValue("Estadio V");
                                                    }else{
                                                        if(resultadoTFGIngreso < 30){
                                                            Ext.getCmp('strPROGESPETFGIngresoCalsifica').setValue("Estadio IV");
                                                        }else{
                                                            if(resultadoTFGIngreso < 60){
                                                                Ext.getCmp('strPROGESPETFGIngresoCalsifica').setValue("Estadio III");
                                                            }else{
                                                                if(resultadoTFGIngreso < 90){
                                                                    Ext.getCmp('strPROGESPETFGIngresoCalsifica').setValue("Estadio II");
                                                                }else{
                                                                    Ext.getCmp('strPROGESPETFGIngresoCalsifica').setValue("Estadio I");
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'numberfield',
                                        name: 'T.F.G Ingreso',
                                        fieldLabel: 'T.F.G',
                                        emptyText: 'Resultado',
                                        width: 120,
                                        decimalPrecision: 2,
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'intPROGESPETFGIngreso'
                                    },
                                    {
                                        html: '-'
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 200,
                                        allowBlank: true,
                                        readOnly: true,
                                        name: 'TFG CLASIFICACION',
                                        id: 'strPROGESPETFGIngresoCalsifica'
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: 'Examenes Seguimiento',
                        layout: 'form',
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        anchor: '100%',
                        autoHeight: true,
                        padding: 5,
                        id: 'fsProgramaEspecialesExamSeguimiento',
                        items: [
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {   
                                        xtype: 'combo',
                                        fieldLabel: 'Parcial de Orina',
                                        name: 'Parcial de Orina',
                                        width: 60,
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPROGESPESeguimientoTraeParcialorina',
                                        listeners:{
                                            change : function( t, newValue, oldValue){
                                                if(newValue == "NO"){
                                                    Ext.getCmp('fecPROGESPESeguimientoParcialorina').allowBlank = true;
                                                    Ext.getCmp('strPROGESPESeguimientoParcialorinaRes').allowBlank = true;
                                                    Ext.getCmp('fecPROGESPESeguimientoParcialorina').setValue(null);
                                                    Ext.getCmp('strPROGESPESeguimientoParcialorinaRes').setValue(null);
                                                    Ext.getCmp('fecPROGESPESeguimientoParcialorina').disable();
                                                    Ext.getCmp('strPROGESPESeguimientoParcialorinaRes').disable();
                                                    Ext.getCmp('fecPROGESPESeguimientoParcialorina').clearInvalid();
                                                    Ext.getCmp('strPROGESPESeguimientoParcialorinaRes').clearInvalid();
                                                }else{
                                                    Ext.getCmp('fecPROGESPESeguimientoParcialorina').enable();
                                                    Ext.getCmp('strPROGESPESeguimientoParcialorinaRes').enable();
                                                    Ext.getCmp('fecPROGESPESeguimientoParcialorina').allowBlank = false;
                                                    Ext.getCmp('strPROGESPESeguimientoParcialorinaRes').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html:'Fecha:'
                                    },
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        name: 'Fecha',
                                        allowBlank: true,
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecPROGESPESeguimientoParcialorina'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 200,
                                        name: 'Resultado Pacial Orina',
                                        emptyText: 'Resultado',
                                        allowBlank: true,
                                        id: 'strPROGESPESeguimientoParcialorinaRes'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {   
                                        xtype: 'combo',
                                        fieldLabel: 'Colesterol Total',
                                        name: 'Colesterol Total',
                                        width: 60,
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPROGESPESeguimientoTraeColesterolTotal',
                                        listeners:{
                                            change : function( t, newValue, oldValue){
                                                if(newValue == "NO"){
                                                    Ext.getCmp('fecPROGESPESeguimientoColesterolTotal').allowBlank = true;
                                                    Ext.getCmp('strPROGESPESeguimientoColesterolTotalRes').allowBlank = true;
                                                    Ext.getCmp('fecPROGESPESeguimientoColesterolTotal').setValue(null);
                                                    Ext.getCmp('strPROGESPESeguimientoColesterolTotalRes').setValue(null);
                                                    Ext.getCmp('fecPROGESPESeguimientoColesterolTotal').disable();
                                                    Ext.getCmp('strPROGESPESeguimientoColesterolTotalRes').disable();
                                                    Ext.getCmp('fecPROGESPESeguimientoColesterolTotal').clearInvalid();
                                                    Ext.getCmp('strPROGESPESeguimientoColesterolTotalRes').clearInvalid();
                                                }else{
                                                    Ext.getCmp('fecPROGESPESeguimientoColesterolTotal').enable();
                                                    Ext.getCmp('strPROGESPESeguimientoColesterolTotalRes').enable();
                                                    Ext.getCmp('fecPROGESPESeguimientoColesterolTotal').allowBlank = false;
                                                    Ext.getCmp('strPROGESPESeguimientoColesterolTotalRes').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html:'Fecha:'
                                    },
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        name: 'Fecha',
                                        allowBlank: true,
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecPROGESPESeguimientoColesterolTotal'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Resultado Colesterol Total',
                                        emptyText: 'Rango 20 - 700',
                                        width: 200,
                                        decimalPrecision: 0,
                                        allowBlank: true,
                                        id: 'strPROGESPESeguimientoColesterolTotalRes'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {   
                                        xtype: 'combo',
                                        fieldLabel: 'Colesterol HDL',
                                        name: 'Colesterol HDL',
                                        width: 60,
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPROGESPESeguimientoTraeColesterolHDL',
                                        listeners:{
                                            change : function( t, newValue, oldValue){
                                                if(newValue == "NO"){
                                                    Ext.getCmp('fecPROGESPESeguimientoColesterolHDL').allowBlank = true;
                                                    Ext.getCmp('strPROGESPESeguimientoColesterolHDLRes').allowBlank = true;
                                                    Ext.getCmp('fecPROGESPESeguimientoColesterolHDL').setValue(null);
                                                    Ext.getCmp('strPROGESPESeguimientoColesterolHDLRes').setValue(null);
                                                    Ext.getCmp('fecPROGESPESeguimientoColesterolHDL').disable();
                                                    Ext.getCmp('strPROGESPESeguimientoColesterolHDLRes').disable();
                                                    Ext.getCmp('fecPROGESPESeguimientoColesterolHDL').clearInvalid();
                                                    Ext.getCmp('strPROGESPESeguimientoColesterolHDLRes').clearInvalid();
                                                }else{
                                                    Ext.getCmp('fecPROGESPESeguimientoColesterolHDL').enable();
                                                    Ext.getCmp('strPROGESPESeguimientoColesterolHDLRes').enable();
                                                    Ext.getCmp('fecPROGESPESeguimientoColesterolHDL').allowBlank = false;
                                                    Ext.getCmp('strPROGESPESeguimientoColesterolHDLRes').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html:'Fecha:'
                                    },
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        name: 'Fecha',
                                        allowBlank: true,
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecPROGESPESeguimientoColesterolHDL'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Resultado Colesterol HDL',
                                        emptyText: 'Rango 10 - 500',
                                        width: 200,
                                        decimalPrecision: 0,
                                        allowBlank: true,
                                        id: 'strPROGESPESeguimientoColesterolHDLRes'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {   
                                        xtype: 'combo',
                                        fieldLabel: 'Colesterol LDL',
                                        name: 'Colesterol LDL',
                                        width: 60,
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPROGESPESeguimientoTraeColesterolLDL',
                                        listeners:{
                                            change : function( t, newValue, oldValue){
                                                if(newValue == "NO"){
                                                    Ext.getCmp('fecPROGESPESeguimientoColesterolLDL').allowBlank = true;
                                                    Ext.getCmp('strPROGESPESeguimientoColesterolLDLRes').allowBlank = true;
                                                    Ext.getCmp('fecPROGESPESeguimientoColesterolLDL').setValue(null);
                                                    Ext.getCmp('strPROGESPESeguimientoColesterolLDLRes').setValue(null);
                                                    Ext.getCmp('fecPROGESPESeguimientoColesterolLDL').disable();
                                                    Ext.getCmp('strPROGESPESeguimientoColesterolLDLRes').disable();
                                                    Ext.getCmp('fecPROGESPESeguimientoColesterolLDL').clearInvalid();
                                                    Ext.getCmp('strPROGESPESeguimientoColesterolLDLRes').clearInvalid();
                                                }else{
                                                    Ext.getCmp('fecPROGESPESeguimientoColesterolLDL').enable();
                                                    Ext.getCmp('strPROGESPESeguimientoColesterolLDLRes').enable();
                                                    Ext.getCmp('fecPROGESPESeguimientoColesterolLDL').allowBlank = false;
                                                    Ext.getCmp('strPROGESPESeguimientoColesterolLDLRes').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html:'Fecha:'
                                    },
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        name: 'Fecha',
                                        allowBlank: true,
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecPROGESPESeguimientoColesterolLDL'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Resultado Colesterol LDL',
                                        emptyText: 'Rango 10 - 500',
                                        width: 200,
                                        decimalPrecision: 0,
                                        allowBlank: true,
                                        id: 'strPROGESPESeguimientoColesterolLDLRes'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {   
                                        xtype: 'combo',
                                        fieldLabel: 'Trigliceridos',
                                        name: 'Trigliceridos',
                                        width: 60,
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPROGESPESeguimientoTraeTrigliceridos',
                                        listeners:{
                                            change : function( t, newValue, oldValue){
                                                if(newValue == "NO"){
                                                    Ext.getCmp('fecPROGESPESeguimientoTrigliceridos').allowBlank = true;
                                                    Ext.getCmp('strPROGESPESeguimientoTrigliceridosRes').allowBlank = true;
                                                    Ext.getCmp('fecPROGESPESeguimientoTrigliceridos').setValue(null);
                                                    Ext.getCmp('strPROGESPESeguimientoTrigliceridosRes').setValue(null);
                                                    Ext.getCmp('fecPROGESPESeguimientoTrigliceridos').disable();
                                                    Ext.getCmp('strPROGESPESeguimientoTrigliceridosRes').disable();
                                                    Ext.getCmp('fecPROGESPESeguimientoTrigliceridos').clearInvalid();
                                                    Ext.getCmp('strPROGESPESeguimientoTrigliceridosRes').clearInvalid();
                                                }else{
                                                    Ext.getCmp('fecPROGESPESeguimientoTrigliceridos').enable();
                                                    Ext.getCmp('strPROGESPESeguimientoTrigliceridosRes').enable();
                                                    Ext.getCmp('fecPROGESPESeguimientoTrigliceridos').allowBlank = false;
                                                    Ext.getCmp('strPROGESPESeguimientoTrigliceridosRes').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html:'Fecha:'
                                    },
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        name: 'Fecha',
                                        allowBlank: true,
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecPROGESPESeguimientoTrigliceridos'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Resultado Trigliceridos',
                                        emptyText: 'Rango 20 - 1000',
                                        width: 200,
                                        decimalPrecision: 0,
                                        allowBlank: true,
                                        id: 'strPROGESPESeguimientoTrigliceridosRes'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {   
                                        xtype: 'combo',
                                        fieldLabel: 'Hb Glicosilada',
                                        name: 'Hb Glicosilada',
                                        width: 60,
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPROGESPESeguimientoTraeHemoglobinaGlicosilada',
                                        listeners:{
                                            change : function( t, newValue, oldValue){
                                                if(newValue == "NO"){
                                                    Ext.getCmp('fecPROGESPESeguimientoHemoglobinaGlicosilada').allowBlank = true;
                                                    Ext.getCmp('strPROGESPESeguimientoHemoglobinaGlicosiladaRes').allowBlank = true;
                                                    Ext.getCmp('fecPROGESPESeguimientoHemoglobinaGlicosilada').setValue(null);
                                                    Ext.getCmp('strPROGESPESeguimientoHemoglobinaGlicosiladaRes').setValue(null);
                                                    Ext.getCmp('fecPROGESPESeguimientoHemoglobinaGlicosilada').disable();
                                                    Ext.getCmp('strPROGESPESeguimientoHemoglobinaGlicosiladaRes').disable();
                                                    Ext.getCmp('fecPROGESPESeguimientoHemoglobinaGlicosilada').clearInvalid();
                                                    Ext.getCmp('strPROGESPESeguimientoHemoglobinaGlicosiladaRes').clearInvalid();
                                                }else{
                                                    Ext.getCmp('fecPROGESPESeguimientoHemoglobinaGlicosilada').enable();
                                                    Ext.getCmp('strPROGESPESeguimientoHemoglobinaGlicosiladaRes').enable();
                                                    Ext.getCmp('fecPROGESPESeguimientoHemoglobinaGlicosilada').allowBlank = false;
                                                    Ext.getCmp('strPROGESPESeguimientoHemoglobinaGlicosiladaRes').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html:'Fecha:'
                                    },
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        name: 'Fecha',
                                        allowBlank: true,
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecPROGESPESeguimientoHemoglobinaGlicosilada'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Resultado Hb Glicosilada',
                                        emptyText: 'Rango 5 - 20',
                                        width: 200,
                                        decimalPrecision: 0,
                                        allowBlank: true,
                                        id: 'strPROGESPESeguimientoHemoglobinaGlicosiladaRes'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {   
                                        xtype: 'combo',
                                        fieldLabel: 'Glicemia',
                                        name: 'Glicemia',
                                        width: 60,
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPROGESPESeguimientoTraeGlicemia',
                                        listeners:{
                                            change : function( t, newValue, oldValue){
                                                if(newValue == "NO"){
                                                    Ext.getCmp('fecPROGESPESeguimientoGlicemia').allowBlank = true;
                                                    Ext.getCmp('strPROGESPESeguimientoGlicemiaRes').allowBlank = true;
                                                    Ext.getCmp('fecPROGESPESeguimientoGlicemia').setValue(null);
                                                    Ext.getCmp('strPROGESPESeguimientoGlicemiaRes').setValue(null);
                                                    Ext.getCmp('fecPROGESPESeguimientoGlicemia').disable();
                                                    Ext.getCmp('strPROGESPESeguimientoGlicemiaRes').disable();
                                                    Ext.getCmp('fecPROGESPESeguimientoGlicemia').clearInvalid();
                                                    Ext.getCmp('strPROGESPESeguimientoGlicemiaRes').clearInvalid();
                                                }else{
                                                    Ext.getCmp('fecPROGESPESeguimientoGlicemia').enable();
                                                    Ext.getCmp('strPROGESPESeguimientoGlicemiaRes').enable();
                                                    Ext.getCmp('fecPROGESPESeguimientoGlicemia').allowBlank = false;
                                                    Ext.getCmp('strPROGESPESeguimientoGlicemiaRes').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html:'Fecha:'
                                    },
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        name: 'Fecha',
                                        allowBlank: true,
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecPROGESPESeguimientoGlicemia'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Resultado Glicemia',
                                        emptyText: 'Rango 20 - 1000',
                                        width: 200,
                                        decimalPrecision: 0,
                                        allowBlank: true,
                                        id: 'strPROGESPESeguimientoGlicemiaRes'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {   
                                        xtype: 'combo',
                                        fieldLabel: 'Micro Albuminuria',
                                        name: 'Micro Albuminuria',
                                        width: 60,
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPROGESPESeguimientoTraeMicroAlbuminuria',
                                        listeners:{
                                            change : function( t, newValue, oldValue){
                                                if(newValue == "NO"){
                                                    Ext.getCmp('fecPROGESPESeguimientoMicroAlbuminuria').allowBlank = true;
                                                    Ext.getCmp('strPROGESPESeguimientoMicroAlbuminuriaRes').allowBlank = true;
                                                    Ext.getCmp('fecPROGESPESeguimientoMicroAlbuminuria').setValue(null);
                                                    Ext.getCmp('strPROGESPESeguimientoMicroAlbuminuriaRes').setValue(null);
                                                    Ext.getCmp('fecPROGESPESeguimientoMicroAlbuminuria').disable();
                                                    Ext.getCmp('strPROGESPESeguimientoMicroAlbuminuriaRes').disable();
                                                    Ext.getCmp('fecPROGESPESeguimientoMicroAlbuminuria').clearInvalid();
                                                    Ext.getCmp('strPROGESPESeguimientoMicroAlbuminuriaRes').clearInvalid();
                                                }else{
                                                    Ext.getCmp('fecPROGESPESeguimientoMicroAlbuminuria').enable();
                                                    Ext.getCmp('strPROGESPESeguimientoMicroAlbuminuriaRes').enable();
                                                    Ext.getCmp('fecPROGESPESeguimientoMicroAlbuminuria').allowBlank = false;
                                                    Ext.getCmp('strPROGESPESeguimientoMicroAlbuminuriaRes').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html:'Fecha:'
                                    },
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        name: 'Fecha',
                                        allowBlank: true,
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecPROGESPESeguimientoMicroAlbuminuria'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Resultado Micro Albuminuria',
                                        emptyText: 'Rango 0 - 700',
                                        width: 200,
                                        decimalPrecision: 0,
                                        allowBlank: true,
                                        id: 'strPROGESPESeguimientoMicroAlbuminuriaRes'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {   
                                        xtype: 'combo',
                                        fieldLabel: 'Urea',
                                        name: 'Urea',
                                        width: 60,
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPROGESPESeguimientoTraeUrea',
                                        listeners:{
                                            change : function( t, newValue, oldValue){
                                                if(newValue == "NO"){
                                                    Ext.getCmp('fecPROGESPESeguimientoUrea').allowBlank = true;
                                                    Ext.getCmp('strPROGESPESeguimientoUreaRes').allowBlank = true;
                                                    Ext.getCmp('fecPROGESPESeguimientoUrea').setValue(null);
                                                    Ext.getCmp('strPROGESPESeguimientoUreaRes').setValue(null);
                                                    Ext.getCmp('fecPROGESPESeguimientoUrea').disable();
                                                    Ext.getCmp('strPROGESPESeguimientoUreaRes').disable();
                                                    Ext.getCmp('fecPROGESPESeguimientoUrea').clearInvalid();
                                                    Ext.getCmp('strPROGESPESeguimientoUreaRes').clearInvalid();
                                                }else{
                                                    Ext.getCmp('fecPROGESPESeguimientoUrea').enable();
                                                    Ext.getCmp('strPROGESPESeguimientoUreaRes').enable();
                                                    Ext.getCmp('fecPROGESPESeguimientoUrea').allowBlank = false;
                                                    Ext.getCmp('strPROGESPESeguimientoUreaRes').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html:'Fecha:'
                                    },
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        name: 'Fecha',
                                        allowBlank: true,
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecPROGESPESeguimientoUrea'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Resultado Urea',
                                        emptyText: 'Resultado',
                                        width: 200,
                                        decimalPrecision: 0,
                                        allowBlank: true,
                                        id: 'strPROGESPESeguimientoUreaRes'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {   
                                        xtype: 'combo',
                                        fieldLabel: 'Creatinina',
                                        name: 'Creatinina',
                                        width: 60,
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPROGESPESeguimientoTraeCreatinina',
                                        listeners:{
                                            change : function( t, newValue, oldValue){
                                                if(newValue == "NO"){
                                                    Ext.getCmp('fecPROGESPESeguimientoCreatinina').allowBlank = true;
                                                    Ext.getCmp('strPROGESPESeguimientoCreatininaRes').allowBlank = true;
                                                    Ext.getCmp('fecPROGESPESeguimientoCreatinina').setValue(null);
                                                    Ext.getCmp('strPROGESPESeguimientoCreatininaRes').setValue(null);
                                                    Ext.getCmp('fecPROGESPESeguimientoCreatinina').disable();
                                                    Ext.getCmp('strPROGESPESeguimientoCreatininaRes').disable();
                                                    Ext.getCmp('fecPROGESPESeguimientoCreatinina').clearInvalid();
                                                    Ext.getCmp('strPROGESPESeguimientoCreatininaRes').clearInvalid();
                                                }else{
                                                    Ext.getCmp('fecPROGESPESeguimientoCreatinina').enable();
                                                    Ext.getCmp('strPROGESPESeguimientoCreatininaRes').enable();
                                                    Ext.getCmp('fecPROGESPESeguimientoCreatinina').allowBlank = false;
                                                    Ext.getCmp('strPROGESPESeguimientoCreatininaRes').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html:'Fecha:'
                                    },
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        name: 'Fecha',
                                        allowBlank: true,
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecPROGESPESeguimientoCreatinina'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Resultado Creatinina',
                                        emptyText: 'Rango 0,2 - 25',
                                        width: 200,
                                        decimalPrecision: 2,
                                        allowBlank: true,
                                        id: 'strPROGESPESeguimientoCreatininaRes',
                                        listeners:{
                                            change : function(f,pNew, pOld){
                                                if(pNew === null || pNew === 0){
                                                    Ext.getCmp('strPROGESPETFGSeguimiento').setValue(null);
                                                    Ext.getCmp('strPROGESPETFGIngresoCalsifica').setValue(null);
                                                }else{
                                                    var resultadoTFGIngreso = ((140 - AniosCumplidos) * Ext.getCmp('intEXAFISPeso').getValue()) / (72 * Ext.getCmp('strPROGESPESeguimientoCreatininaRes').getValue())
                                                    
                                                    if(Ext.getCmp('sysGeneroHC').getValue() === "FEMENINO"){
                                                        Ext.getCmp('strPROGESPETFGSeguimiento').setValue(resultadoTFGIngreso * 0.85);
                                                    }else{
                                                        Ext.getCmp('strPROGESPETFGSeguimiento').setValue(resultadoTFGIngreso);
                                                    }
                                                    
                                                    if(resultadoTFGIngreso < 15){
                                                        Ext.getCmp('strPROGESPETFGSeguimientoCalsifica').setValue("Estadio V");
                                                    }else{
                                                        if(resultadoTFGIngreso < 30){
                                                            Ext.getCmp('strPROGESPETFGSeguimientoCalsifica').setValue("Estadio IV");
                                                        }else{
                                                            if(resultadoTFGIngreso < 60){
                                                                Ext.getCmp('strPROGESPETFGSeguimientoCalsifica').setValue("Estadio III");
                                                            }else{
                                                                if(resultadoTFGIngreso < 90){
                                                                    Ext.getCmp('strPROGESPETFGSeguimientoCalsifica').setValue("Estadio II");
                                                                }else{
                                                                    Ext.getCmp('strPROGESPETFGSeguimientoCalsifica').setValue("Estadio I");
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                ]
                            },
                            
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'numberfield',
                                        name: 'T.F.G Seguimiento',
                                        fieldLabel: 'T.F.G Seguimiento',
                                        emptyText: 'Resultado',
                                        width: 120,
                                        decimalPrecision: 2,
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'strPROGESPETFGSeguimiento'
                                    },
                                    {
                                        html: '-'
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 200,
                                        allowBlank: true,
                                        readOnly: true,
                                        name: 'TFG CLASIFICACION',
                                        id: 'strPROGESPETFGSeguimientoCalsifica'
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: 'Metas Terapeuticas',
                        layout: 'form',
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        anchor: '100%',
                        autoHeight: true,
                        padding: 5,
                        id: 'fsMetasTerapeuticas',
                        items: [
                            {
                                xtype: 'panel',
                                layout: 'table',
                                anchor: '100%',
                                padding: 0,
                                layoutConfig: {
                                    columns: 5
                                },
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'panel',
                                        layout: 'form',
                                        width: 650,
                                        height: 300,
                                        labelWidth: 630,
                                        labelSeparator: '',
                                        labelStyle: 'color:blue;',
                                        title: '<center>Concepto</center>',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                fieldLabel: 'Cifras de Tension Arterial menores de 140/90 mm Hg',
                                                width: 1,
                                                height: 7,
                                                allowBlank: true,
                                                readOnly: true,
                                                border: 0,
                                                style: 'background:transparent;text-align:right;border:none;',
                                                id: 'sysExaA'
                                            },
                                            {
                                                xtype: 'textfield',
                                                fieldLabel: 'Glicemia prepandrial entre 90 a 120 hg/dl',
                                                width: 1,
                                                height: 7,
                                                allowBlank: true,
                                                readOnly: true,
                                                border: 0,
                                                style: 'background:transparent;text-align:right;border:none;',
                                                id: 'sysExaB'
                                            },
                                            {
                                                xtype: 'textfield',
                                                fieldLabel: 'Hemoglicemia Glicosilada (HbA1) <7.0% Ideal 6,5%',
                                                width: 1,
                                                height: 7,
                                                allowBlank: true,
                                                readOnly: true,
                                                border: 0,
                                                style: 'background:transparent;text-align:right;border:none;',
                                                id: 'sysExaC'
                                            },
                                            {
                                                xtype: 'textfield',
                                                fieldLabel: 'Trigliceridos menor a 150 mg/dl',
                                                width: 1,
                                                height: 7,
                                                allowBlank: true,
                                                readOnly: true,
                                                border: 0,
                                                style: 'background:transparent;text-align:right;border:none;',
                                                id: 'sysExaD'
                                            },
                                            {
                                                xtype: 'textfield',
                                                fieldLabel: 'Colesterol LDL menor a 100 mg/dl',
                                                width: 1,
                                                height: 7,
                                                allowBlank: true,
                                                readOnly: true,
                                                border: 0,
                                                style: 'background:transparent;text-align:right;border:none;',
                                                id: 'sysExaE'
                                            },
                                            {
                                                xtype: 'textfield',
                                                fieldLabel: 'HDL Mayor de 40 mg/dl en hombre y mayor de 50 mg/gl en mujeres',
                                                width: 1,
                                                height: 7,
                                                allowBlank: true,
                                                readOnly: true,
                                                border: 0,
                                                style: 'background:transparent;text-align:right;border:none;',
                                                id: 'sysExaF'
                                            },
                                            {
                                                xtype: 'textfield',
                                                fieldLabel: 'Microalbuminuria menor de 30 mg/dl',
                                                width: 1,
                                                height: 7,
                                                allowBlank: true,
                                                readOnly: true,
                                                border: 0,
                                                style: 'background:transparent;text-align:right;border:none;',
                                                id: 'sysExaG'
                                            },
                                            {
                                                xtype: 'textfield',
                                                fieldLabel: 'Perdida Gradual y Sostenida inicial de 5 a 10% del peso hasta alcanzar IMC 18.5 a 24.9 kg/m2',
                                                width: 1,
                                                height: 7,
                                                allowBlank: true,
                                                readOnly: true,
                                                border: 0,
                                                style: 'background:transparent;text-align:right;border:none;',
                                                id: 'sysExaH'
                                            },
                                            {
                                                xtype: 'textfield',
                                                fieldLabel: 'Perimetro de Cintura: hombres menor o igual a 90 cm, mujeres menor o igual a 80 cm',
                                                width: 1,
                                                height: 7,
                                                allowBlank: true,
                                                readOnly: true,
                                                border: 0,
                                                style: 'background:transparent;text-align:right;border:none;',
                                                id: 'sysExaI'
                                            },
                                            {
                                                xtype: 'textfield',
                                                fieldLabel: 'Manejo del estres, Desarrollo de habilidades para comunicacion asertiva y Solucion de problemas',
                                                width: 1,
                                                height: 7,
                                                allowBlank: true,
                                                readOnly: true,
                                                border: 0,
                                                style: 'background:transparent;text-align:right;border:none;',
                                                id: 'sysExaJ'
                                            },
                                        ]
                                    },
                                    {
                                        xtype: 'panel',
                                        layout: 'form',
                                        width: 80,
                                        height: 300,
                                        labelWidth: 1,
                                        labelSeparator: '',
                                        labelStyle: 'color:blue;',
                                        title: '<center>Indicado</center>',
                                        items: [
                                            {
                                                xtype: 'checkbox',
                                                name: 'Cifras de Tension Arterial menores de 140/90 mm Hg',
                                                anchor: '100%',
                                                value: 'false',
                                                height: 22,
                                                id: 'bolPROESPMetasCifras'
                                            },
                                            {
                                                xtype: 'checkbox',
                                                name: 'Glicemia prepandrial entre 90 a 120 hg/dl',
                                                anchor: '100%',
                                                value: 'false',
                                                height: 22,
                                                id: 'bolPROESPMetasGlicemia'
                                            },
                                            {
                                                xtype: 'checkbox',
                                                name: 'Hemoglicemia Glicosilada (HbA1) <7.0% Ideal 6,5%',
                                                anchor: '100%',
                                                value: 'false',
                                                height: 22,
                                                id: 'bolPROESPMetasHbA1'
                                            },
                                            {
                                                xtype: 'checkbox',
                                                name: 'Trigliceridos menor a 150 mg/dl',
                                                anchor: '100%',
                                                value: 'false',
                                                height: 22,
                                                id: 'bolPROESPMetasTrigliceridos'
                                            },
                                            {
                                                xtype: 'checkbox',
                                                name: 'Colesterol LDL menor a 100 mg/dl',
                                                anchor: '100%',
                                                value: 'false',
                                                height: 22,
                                                id: 'bolPROESPMetasLDL'
                                            },
                                            {
                                                xtype: 'checkbox',
                                                name: 'HDL Mayor de 40 mg/dl en hombre y mayor de 50 mg/gl en mujeres',
                                                anchor: '100%',
                                                value: 'false',
                                                height: 22,
                                                id: 'bolPROESPMetasHDL'
                                            },
                                            {
                                                xtype: 'checkbox',
                                                name: 'Microalbuminuria menor de 30 mg/dl',
                                                anchor: '100%',
                                                value: 'false',
                                                height: 22,
                                                id: 'bolPROESPMetasMicroalbuminuria'
                                            },
                                            {
                                                xtype: 'checkbox',
                                                name: 'Perdida Gradual y Sostenida inicial de 5 a 10% del peso hasta alcanzar IMC 18.5 a 24.9 kg/m2',
                                                anchor: '100%',
                                                value: 'false',
                                                height: 22,
                                                id: 'bolPROESPMetasIMC'
                                            },
                                            {
                                                xtype: 'checkbox',
                                                name: 'Perimetro de Cintura: hombres menor o igual a 90 cm, mujeres menor o igual a 80 cm',
                                                anchor: '100%',
                                                value: 'false',
                                                height: 22,
                                                id: 'bolPROESPMetasPerimetroCintura'
                                            },
                                            {
                                                xtype: 'checkbox',
                                                name: 'Manejo del estres, Desarrollo de habilidades para comunicacion asertiva y Solucion de problemas',
                                                anchor: '100%',
                                                value: 'false',
                                                height: 22,
                                                id: 'bolPROESPMetasManejoEstres'
                                            },
                                        ]
                                    },
                                    {
                                        xtype: 'panel',
                                        layout: 'form',
                                        width: 80,
                                        height: 300,
                                        labelWidth: 1,
                                        labelSeparator: '',
                                        labelStyle: 'color:blue;',
                                        title: '<center>Cumplido</center>',
                                        items: [
                                            {
                                                xtype: 'combo',
                                                width: 50,
                                                height: 7,
                                                name: 'Cumplido Cifras de Tension Arterial menores de 140/90 mm Hg',
                                                allowBlank: true,
                                                store: 'StoreEscalaValoracion',
                                                valueField: 'Valor',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: 0,
                                                id: 'intPROESPCumplidosCifras',
                                                listeners:{
                                                    change : function(f,pNew, pOld){
                                                        calculoMetas();
                                                    }
                                                }
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 50,
                                                height: 7,
                                                name: 'Cumplido Glicemia prepandrial entre 90 a 120 hg/dl',
                                                allowBlank: true,
                                                store: 'StoreEscalaValoracion',
                                                valueField: 'Valor',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: 0,
                                                id: 'intPROESPCumplidosGlicemia',
                                                listeners:{
                                                    change : function(f,pNew, pOld){
                                                        calculoMetas();
                                                    }
                                                }
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 50,
                                                height: 7,
                                                name: 'Cumplido Hemoglicemia Glicosilada (HbA1) <7.0% Ideal 6,5%',
                                                allowBlank: true,
                                                store: 'StoreEscalaValoracion',
                                                valueField: 'Valor',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: 0,
                                                id: 'intPROESPCumplidosHbA1',
                                                listeners:{
                                                    change : function(f,pNew, pOld){
                                                        calculoMetas();
                                                    }
                                                }
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 50,
                                                height: 7,
                                                name: 'Cumplido Trigliceridos menor a 150 mg/dl',
                                                allowBlank: true,
                                                store: 'StoreEscalaValoracion',
                                                valueField: 'Valor',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: 0,
                                                id: 'intPROESPCumplidosTrigliceridos',
                                                listeners:{
                                                    change : function(f,pNew, pOld){
                                                        calculoMetas();
                                                    }
                                                }
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 50,
                                                height: 7,
                                                name: 'Cumplido Colesterol LDL menor a 100 mg/dl',
                                                allowBlank: true,
                                                store: 'StoreEscalaValoracion',
                                                valueField: 'Valor',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: 0,
                                                id: 'intPROESPCumplidosLDL',
                                                listeners:{
                                                    change : function(f,pNew, pOld){
                                                        calculoMetas();
                                                    }
                                                }
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 50,
                                                height: 7,
                                                name: 'Cumplido HDL Mayor de 40 mg/dl en hombre y mayor de 50 mg/gl en mujeres',
                                                allowBlank: true,
                                                store: 'StoreEscalaValoracion',
                                                valueField: 'Valor',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: 0,
                                                id: 'intPROESPCumplidosHDL',
                                                listeners:{
                                                    change : function(f,pNew, pOld){
                                                        calculoMetas();
                                                    }
                                                }
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 50,
                                                height: 7,
                                                name: 'Cumplido Microalbuminuria menor de 30 mg/dl',
                                                allowBlank: true,
                                                store: 'StoreEscalaValoracion',
                                                valueField: 'Valor',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: 0,
                                                id: 'intPROESPCumplidosMicroalbuminuria',
                                                listeners:{
                                                    change : function(f,pNew, pOld){
                                                        calculoMetas();
                                                    }
                                                }
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 50,
                                                height: 7,
                                                name: 'Cumplido Perdida Gradual y Sostenida inicial de 5 a 10% del peso hasta alcanzar IMC 18.5 a 24.9 kg/m2',
                                                allowBlank: true,
                                                store: 'StoreEscalaValoracion',
                                                valueField: 'Valor',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: 0,
                                                id: 'intPROESPCumplidosIMC',
                                                listeners:{
                                                    change : function(f,pNew, pOld){
                                                        calculoMetas();
                                                    }
                                                }
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 50,
                                                height: 7,
                                                name: 'Cumplido Perimetro de Cintura: hombres menor o igual a 90 cm, mujeres menor o igual a 80 cm',
                                                allowBlank: true,
                                                store: 'StoreEscalaValoracion',
                                                valueField: 'Valor',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: 0,
                                                id: 'intPROESPCumplidospPerimetroCintura',
                                                listeners:{
                                                    change : function(f,pNew, pOld){
                                                        calculoMetas();
                                                    }
                                                }
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 50,
                                                height: 7,
                                                name: 'Cumplido Manejo del estres, Desarrollo de habilidades para comunicacion asertiva y Solucion de problemas',
                                                allowBlank: true,
                                                store: 'StoreEscalaValoracion',
                                                valueField: 'Valor',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: 0,
                                                id: 'intPROESPCumplidosEstres',
                                                listeners:{
                                                    change : function(f,pNew, pOld){
                                                        calculoMetas();
                                                    }
                                                }
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'textarea',
                                anchor: '100%',
                                width: 880,
                                fieldLabel: 'Observaciones',
                                name: 'Observaciones',
                                height: 100,
                                allowBlank: true,
                                id: 'memPROGESPEMetasTerapeuticasObservaciones'
                            },
                            {
                                xtype: 'numberfield',
                                width: 50,
                                fieldLabel: 'Numero Metas Cumplidas',
                                name: 'Numero Metas Cumplidas',
                                minValue: 0,
                                allowBlank: true,
                                style: 'text-align:center;',
                                id: 'intPROGESPENumCumplimientoMetas'
                            }
                        ]
                    }
                ]
            }
        ];
        pnProgramasEspecialesUi.superclass.initComponent.call(this);
    }
});


function calculoEstadioHTA(){
   if(Ext.getCmp('intEXAFISTASentadoSistolica').getValue() >= 160 || Ext.getCmp('intEXAFISTASentadoDiastolica').getValue() >= 100 || Ext.getCmp('intEXAFISTAdePieSistolica').getValue() >= 160 || Ext.getCmp('intEXAFISTAdePieDiastolica').getValue() >= 100){
       Ext.getCmp('strPROGESPEDxHTAEstadio').setValue("ESTADIO II");
   }else{
       if(Ext.getCmp('intEXAFISTASentadoSistolica').getValue() >= 140 || Ext.getCmp('intEXAFISTASentadoDiastolica').getValue() >= 90 || Ext.getCmp('intEXAFISTAdePieSistolica').getValue() >= 140 || Ext.getCmp('intEXAFISTAdePieDiastolica').getValue() >= 90){
           Ext.getCmp('strPROGESPEDxHTAEstadio').setValue("ESTADIO I");
       }else{
           if(Ext.getCmp('intEXAFISTASentadoSistolica').getValue() >= 120 || Ext.getCmp('intEXAFISTASentadoDiastolica').getValue() >= 80 || Ext.getCmp('intEXAFISTAdePieSistolica').getValue() >= 120 || Ext.getCmp('intEXAFISTAdePieDiastolica').getValue() >= 80){
               Ext.getCmp('strPROGESPEDxHTAEstadio').setValue("PREHIPERTENSION")
           }else{
               Ext.getCmp('strPROGESPEDxHTAEstadio').setValue("NORMAL")
           }
       }
   }
}

function calculoMetas(){
   var totalMetasCumplidas = 0;
   
   if(Ext.getCmp('intPROESPCumplidosEstres').getValue() != null){
        totalMetasCumplidas = (parseInt(Ext.getCmp('intPROESPCumplidosEstres').getValue()) + parseInt(Ext.getCmp('intPROESPCumplidospPerimetroCintura').getValue()) + parseInt(Ext.getCmp('intPROESPCumplidosIMC').getValue()) + parseInt(Ext.getCmp('intPROESPCumplidosMicroalbuminuria').getValue()) + parseInt(Ext.getCmp('intPROESPCumplidosHDL').getValue()) + parseInt(Ext.getCmp('intPROESPCumplidosLDL').getValue()) + parseInt(Ext.getCmp('intPROESPCumplidosTrigliceridos').getValue()) + parseInt(Ext.getCmp('intPROESPCumplidosHbA1').getValue()) + parseInt(Ext.getCmp('intPROESPCumplidosGlicemia').getValue()) + parseInt(Ext.getCmp('intPROESPCumplidosCifras').getValue()));
        Ext.getCmp('intPROGESPENumCumplimientoMetas').setValue(totalMetasCumplidas);
    }
}