/*
* @category    Formulario Modelo Evolucion Historia Clinica
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winHCJoven001Ui = Ext.extend(Ext.Window, {
    title: 'eOfiClinic ©  .:: Plantilla HC Joven ::.',
    width: 990,
    height: 636,
    closable: false,
    resizable: false,
    draggable: false,
    modal: true,
    id: 'winHC',
    initComponent: function() {
        
        var fsDiagnosticosConsulta = new fsDiagnosticosConsultaUi();
        var fsRevisionxSistemas = new fsRevisionxSistemasUi();
        var fsAntecedentesPersonales = new fsAntecedentesPersonalesUi();
        var fsAntecedentesFamiliares = new fsAntecedentesFamiliaresUi();
        var fsExamenFisico = new fsExamenFisicoUi();
        
        tmpmx = objMX;
        tmpmxadd = objMXADD;
        tmpexa = objEXA;
        tmprem = objREM;
        myPaciente = 0;
        myCAS = 0;

        try {
            var campo = Ext.getCmp('sysPacientePlantillaHC');
            if ( campo != null ) {
                myPaciente = Ext.getCmp('sysPacientePlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myPaciente == 0){
            try {
                var campo1 = Ext.getCmp('sysIdPacienteHC');
                if ( campo1 != null ) {
                    myPaciente = Ext.getCmp('sysIdPacienteHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myPaciente == 0){
            try {
                var campo5 = Ext.getCmp('sysPacienteRefHC');
                if ( campo5 != null ) {
                    myPaciente = Ext.getCmp('sysPacienteRefHC').getValue();
                }
            }catch(ex){
            }
        }
        try {
            var campo2 = Ext.getCmp('sysCASPlantillaHC');
            if ( campo2 != null ) {
                myCAS = Ext.getCmp('sysCASPlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myCAS == 0){
            try {
                var campo3 = Ext.getCmp('sysCASHC');
                if ( campo3 != null ) {
                    myCAS = Ext.getCmp('sysCASHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myCAS == 0){
            try {
                var campo4 = Ext.getCmp('sysCASRefHC');
                if ( campo4 != null ) {
                    myCAS = Ext.getCmp('sysCASRefHC').getValue();
                }
            }catch(ex){
            }
        }
        if (objMX != "NA"){
            var xSolMX = eval(objMX);
            Ext.getCmp('gridMedicamentosHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }
        else{
            var xSolMX = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        if (objEXA != "NA"){
            var xSolEXA = eval(objEXA);
            Ext.getCmp('gridExamenesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }else{
            var xSolEXA = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        if (objREM != "NA"){
            var xSolREM = eval(objREM);
            Ext.getCmp('gridRemisionesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }else{
            var xSolREM = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }

        //
        this.items = [
            {
                xtype: 'panel',
                frame: true,
                anchor: '100%',
                id: 'panelHC',
                border: false,
                height: 570,
                autoScroll: true,
                layout: 'form',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'tabpanel',
                        anchor: '99%',
                        autoHeight: true,
                        border: false,
                        enableTabScroll: true,
                        ref: 'fTabPanel',
                        id: 'fTabPanel',
                        activeTab: 0,
                        items: [
                            {
                                xtype: 'panel',
                                title: 'INFORMACION',
                                autoHeight: true,
                                autoScroll: true,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaIdentifica',
                                layout: 'form',
                                items:[
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysIdCodPlantillaHC'
                                    },
                                     {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        value: 1,
                                        id: 'sysUsaGridSalida'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                                        value: 0,
                                        id: 'sysYaGuardoHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Plantilla',
                                        id: 'sysPlantillaHC',
                                        name: 'PLANTILLA'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysRutaRptHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysRutaRptMx'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysRutaRptExa'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysRutaRptRem'
                                    },
                                    {
                                        xtype: 'textfield',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Actividad',
                                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                                        id: 'sysActividadHC',
                                        name: 'PLANTILLA'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Empresa',
                                        id: 'sysEmpresaHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'IPS',
                                        id: 'sysIPSHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Usuario',
                                        id: 'sysUsuarioHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Profesional',
                                        id: 'sysProfesionalHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Paciente',
                                        id: 'sysIdPacienteHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Apertura',
                                        id: 'sysAperturaHC'
                                    },
                                    {
                                        xtype: 'textfield',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Cliente',
                                        id: 'sysClienteHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Plantilla',
                                        id: 'sysIdClienteHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Plantilla',
                                        id: 'sysIdPlanHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Plantilla',
                                        id: 'sysIdSubPlanHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Plantilla',
                                        id: 'sysIdContratoHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Genero',
                                        id: 'sysGeneroPacHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Edad',
                                        id: 'sysEdadPacHC'
                                    },
                                    {
                                        xtype: 'textfield',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Profesional',
                                        id: 'sysProfesionalAgendaHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'ConsecutivoDetalle',
                                        id: 'sysConsecutivoDetalleHC'
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'CAS',
                                                id: 'sysCASHC'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysFechaHC',
                                                value: 'Fecha: '
                                            },
                                            {
                                                xtype: 'textfield',
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysFechaHC'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysHoraHC',
                                                value: 'Hora: '
                                            },
                                            {
                                                xtype: 'textfield',
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysHoraHC'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysLegalizacionHC',
                                                value: 'Legalización: '
                                            },
                                            {
                                                xtype: 'textfield',
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysLegalizaHC'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'textfield',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Paciente',
                                        value: 'CC 792558261  - JORGE GALEANO RUIZ - (Masculino) FechaNac: 1973-01-30, Edad 38 Años',
                                        id: 'sysPacienteHC'
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 100,
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Genero',
                                                id: 'sysGeneroHC'
                                            },
                                            {
                                                html: 'Fecha Nac:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 100,
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysFechaNac'
                                            },
                                            {
                                                html: 'Edad:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 350,
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysEdadHC'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 96,
                                                allowBlank: false,
                                                fieldLabel: 'Ocupacion',
                                                id: 'sysOcupacionHC'
                                            },
                                            {
                                                xtype: 'textarea',
                                                readOnly: true,
                                                width: 695,
                                                height: 22,
                                                id: 'sysOcupacionHCNom'
                                            },
                                            {
                                                xtype: 'button',
                                                iconCls: 'btnBuscar',
                                                tooltip: 'Buscar Ocupacion',
                                                id: 'btnSearchOcupacionHC',
                                                listeners:{
                                                    click : function(){
                                                        buscarciuo('sysOcupacionHC','sysOcupacionHCNom');
                                                    }
                                                }
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'combo',
                                                fieldLabel: 'Etnia',
                                                name: 'Etnia',
                                                width: 370,
                                                allowBlank: false,
                                                store: 'StoreEtnia4505',
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                id: 'sysEtniaHC'
                                            },
                                            {
                                                html: 'Escolaridad:'
                                            },
                                            {
                                                xtype: 'combo',
                                                name: 'Escolaridad',
                                                width: 380,
                                                allowBlank: false,
                                                store: 'StoreEscolaridad4505',
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                id: 'sysEscolaridadHC'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 370,
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Estado Civil',
                                                id: 'sysEstadoCivilHC'
                                            },
                                            {
                                                html: 'Discapacidad:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 370,
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysDiscapacidadHC'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 370,
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Dirección',
                                                id: 'sysDireccionHC'
                                            },
                                            {
                                                html: 'Telefono:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 390,
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysTelefonoHC'
                                            }
                                        ]
                                    },
                                    {
                                        html: '<hr>',
                                        style: 'background:transparent;',
                                        border: false
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Evolución',
                                autoHeight: true,
                                autoScroll: true,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaEvolucion',
                                layout: 'form',
                                items: [
                                    {
                                        xtype: 'form',
                                        frame: true,
                                        anchor: '100%',
                                        id: 'frmHC',
                                        padding: 10,
                                        border: false,
                                        autoScroll: true,
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        fieldLabel: 'Acompañante',
                                                        name: 'Acompañante',
                                                        width: 350,
                                                        allowBlank: true,
                                                        id: 'strDATINGPROGAcompanante'
                                                    },
                                                    {
                                                        html: '   Parentesco:'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: 'Parentezco',
                                                        width: 350,
                                                        allowBlank: true,
                                                        store: stParentesco,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strDATINGPROGParentesco'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'MOTIVO DE CONSULTA',
                                                layout: 'table',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'MOTIVO DE CONSULTA',
                                                        name: 'MOTIVO DE CONSULTA',
                                                        height: 100,
                                                        allowBlank: false,
                                                        id: 'memMotivoConsulta'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'ENFERMEDAD ACTUAL',
                                                layout: 'table',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'ENFERMEDAD ACTUAL',
                                                        name: 'ENFERMEDAD ACTUAL',
                                                        height: 100,
                                                        allowBlank: false,
                                                        id: 'memEnfermedadActual'
                                                    }
                                                ]
                                            },
                                            fsRevisionxSistemas,
                                            fsAntecedentesPersonales,
                                            fsAntecedentesFamiliares,
                                            fsExamenFisico,
                                            {
                                                xtype: 'fieldset',
                                                title: 'INFORMACION DEL PROGRAMA',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 5,
                                                id: 'fsAlteracionesJoven',
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Dependencia Economica',
                                                                fieldLabel: 'Dependencia Economica',
                                                                width: 100,
                                                                allowBlank: true,
                                                                store: stDependenciaEconomica,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strALTJOVDependencia'
                                                            },
                                                            {
                                                                html: 'Rel Intrafamiliares'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Relaciones Intrafamiliares',
                                                                width: 100,
                                                                allowBlank: true,
                                                                store: stRelaciones,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strALTJOVRelIntrafamiliares'
                                                            },
                                                            {
                                                                html: 'Rel Interpersonales'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Relaciones Interpersonales',
                                                                width: 100,
                                                                allowBlank: true,
                                                                store: stRelaciones,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strALTJOVRelInterpersonales'
                                                            },
                                                            {
                                                                html: 'Com Intrafamiliar'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Comunicacion Intrafamiliar',
                                                                width: 100,
                                                                allowBlank: true,
                                                                store: stRelaciones,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strALTJOVComIntrafamiliar'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        fieldLabel: 'Vida Sexual',
                                                        name: 'Riesgo Total',
                                                        width: 400,
                                                        id: 'strALTJOVVidaSexual',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strALTJOVVidaSexual').setValue("Negativo");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        fieldLabel: 'Proyecto de Vida',
                                                        name: 'Proyecto de Vida',
                                                        height: 100,
                                                        allowBlank: true,
                                                        id: 'memALTJOVproyectoVida',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('memALTJOVproyectoVida').setValue("No Refiere");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'Factores de Riesgo',
                                                        layout: 'form',
                                                        collapseFirst: false,
                                                        collapsible: true,
                                                        animCollapse: true,
                                                        titleCollapse: true,
                                                        anchor: '100%',
                                                        autoHeight: true,
                                                        padding: 5,
                                                        items: [
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'Fumador',
                                                                        name: 'Fumador',
                                                                        value: 'false',
                                                                        id: 'bolALTJOVFumador'
                                                                    },
                                                                    {
                                                                        html: 'Alcohol:'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        name: 'Alcohol',
                                                                        value: 'false',
                                                                        id: 'bolALTJOVAlcohol'
                                                                    },
                                                                    {
                                                                        html: 'Sust. Psicoa.:'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        name: 'Sust. Psicoa.',
                                                                        value: 'false',
                                                                        id: 'bolALTJOVSustPsicoa'
                                                                    },
                                                                    {
                                                                        html: 'Dieta Saludable:'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        name: 'Dieta Saludable',
                                                                        value: 'false',
                                                                        id: 'bolALTJOVDietaSaludable'
                                                                    },
                                                                    {
                                                                        html: 'Act. Fisica:'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        name: 'Act. Fisica',
                                                                        value: 'false',
                                                                        id: 'bolALTJOVActFisica'
                                                                    },
                                                                    {
                                                                        html: 'Manejo Stress:'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        name: 'Manejo Stress',
                                                                        value: 'false',
                                                                        id: 'bolALTJOVManejoStress'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {   
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Hemoglobina',
                                                                fieldLabel: 'Hemoglobina',
                                                                width: 60,
                                                                allowBlank: true,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strALTJOVHemoglo',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO"){
                                                                            Ext.getCmp('strALTJOVHemogloDescripcion').allowBlank = true;
                                                                            Ext.getCmp('fecALTJOVHemogloFecha').allowBlank = true;
                                                                            Ext.getCmp('strALTJOVHemogloDescripcion').disable();
                                                                            Ext.getCmp('fecALTJOVHemogloFecha').disable();
                                                                            Ext.getCmp('strALTJOVHemogloDescripcion').clearInvalid();
                                                                            Ext.getCmp('fecALTJOVHemogloFecha').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strALTJOVHemogloDescripcion').enable();
                                                                            Ext.getCmp('fecALTJOVHemogloFecha').enable();
                                                                            Ext.getCmp('strALTJOVHemogloDescripcion').allowBlank = false;
                                                                            Ext.getCmp('fecALTJOVHemogloFecha').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html: ' - '
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 250,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                name: 'Hemoglobina Descripcion',
                                                                id: 'strALTJOVHemogloDescripcion'
                                                            },
                                                            {
                                                                html: ' - '
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                name: 'Hemoglobina Fecha',
                                                                emptyText: '(dia/mes/año)',
                                                                width: 120,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                id: 'fecALTJOVHemogloFecha'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'EVOLUCION',
                                                layout: 'table',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'EVOLUCION',
                                                        name: 'EVOLUCION',
                                                        height: 100,
                                                        allowBlank: false,
                                                        id: 'memEvolucion'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'INFORMACION PROXIMA CITA',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 5,
                                                items: [
                                                        {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'datefield',
                                                                width: 120,
                                                                fieldLabel: 'Fecha Probable Proxima Cita',
                                                                name: 'Fecha Probable Proxima Cita',
                                                                allowBlank: true,
                                                                emptyText: '(dia/mes/año) ',
                                                                style: 'text-align:center;',
                                                                id: 'fecPROXCITACita'
                                                            },
                                                            {
                                                                html: 'Profesional que Atiende'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Profesional que Atiende',
                                                                width: 250,
                                                                allowBlank: true,
                                                                store: stProfesionalAtiende,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strPROXCITAProfesionalAtiende'
                                                            },
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'Observacion',
                                                        name: 'Observacion',
                                                        height: 100,
                                                        allowBlank: true,
                                                        id: 'memPROXCITAObservacion'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'CONDUCTA',
                                                layout: 'table',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'CONDUCTA',
                                                        name: 'CONDUCTA',
                                                        height: 100,
                                                        allowBlank: false,
                                                        id: 'memConducta'
                                                    }
                                                ]
                                            },
                                            fsDiagnosticosConsulta
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Medicamentos',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaMedicamentos',
                                items: [
                                    xSolMX
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Servicios',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaServicios',
                                items: [
                                    xSolEXA
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Remisiones',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaRemisiones',
                                items: [
                                    xSolREM
                                ]
                            }
                            /*,
                            {
                                xtype: 'panel',
                                title: 'Solicitud CTC',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaCTC',
                                items: [
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Consentimientos Informados',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaConsentimientos',
                                items: [
                                ]
                            },*/
                        ]
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btnSalirEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 1)
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Usted No ha Guardado la Evolución del Paciente y Se Perdera la Información, Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                },
                tbar:{
                    items: [
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Ver Historia Clínica',
                            iconCls: 'btnVerHC',
                            id: 'btnVerHC',
                            listeners:{
                                click : function(){
                                    var cmpResumenHC = new winFrmVerHistorialHC({
                                        renderTo: Ext.getBody()
                                    });
                                    Ext.getCmp('winViewEvolucionHC').title = "PACIENTE: " + Ext.getCmp('sysPacienteHC').getValue();
                                    Ext.getCmp('gridHistorialEvoluciones').store.load({
                                        params: {
                                            pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                                            pPaciente: Ext.getCmp('sysIdPacienteHC').getValue()
                                        }
                                    });
                                    cmpResumenHC.show();
                                }
                            }
                        },
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar Evolución',
                            iconCls: 'btnGuardar',
                            id: 'btnGuardarEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 0)
                                    {
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Guardar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnGuardarRegistrosMedicinaGeneral();
                                                }
                                            }
                                        });
                                    }else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Modificar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnModificarRegistrosMedicinaGeneral();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                }
            }
        ];
        this.on({
            afterlayout:{
                scope:this, 
                single:true, 
                fn:function() {
                    Ext.Msg.hide();
                    //Predefinir Comportamiento Campos

                    if(Ext.getCmp('sysFechaHC').getValue() != null || Ext.getCmp('sysFechaHC').getValue() != 0){
                       calculoEdadPacienteMeses()
                    }

                    Ext.getCmp('sysFinalidadConsultaHC').setValue(05);

                    //EVALUA ANTECEDENTES GINOECO-OBSTETrICOS
                    if(Ext.getCmp('sysGeneroHC').getValue()=="MASCULINO" || MesesCumplidos <= 96){
                        Ext.getCmp('fsANTGINECO').setVisible(false);
                        Ext.getCmp('fsEXAMFISValMamaria').setVisible(false);
                    }else{
                        Ext.getCmp('fsANTGINECO').setVisible(true);
                        Ext.getCmp('fsEXAMFISValMamaria').setVisible(true);
                        Ext.getCmp('intANTGINECOG').allowBlank = false;
                        Ext.getCmp('intANTGINECOP').allowBlank = false;
                        Ext.getCmp('intANTGINECOPV').allowBlank = false;
                        Ext.getCmp('intANTGINECOPC').allowBlank = false;
                        Ext.getCmp('intANTGINECOA').allowBlank = false;
                        Ext.getCmp('intANTGINECOVivos').allowBlank = false;
                        Ext.getCmp('intANTGINECOMuertos').allowBlank = false;
                        Ext.getCmp('strANTGINECOLactanciaHoy').allowBlank = true;
                        Ext.getCmp('strANTGINECOLactanciaPasado').allowBlank = true;
                        Ext.getCmp('strANTGONECOTiempoLactancia').allowBlank = true;
                        Ext.getCmp('strANTGINECOFum_1').allowBlank = true;
                        Ext.getCmp('strANTGINECOMenarquia').allowBlank = true;
                        Ext.getCmp('fecANTGINECOFum').allowBlank = true;
                        Ext.getCmp('fecANTGINECOFup').allowBlank = true;
                        Ext.getCmp('strANTGINECOFuc').allowBlank = true;
                        Ext.getCmp('fecANTGINECOFuc').allowBlank = true;
                        Ext.getCmp('strANTGINECOFucRes').allowBlank = true;
                        Ext.getCmp('strANTGINECOMetodoPlanifica').allowBlank = false;
                        Ext.getCmp('strANTGINECOCiclosMestruales').allowBlank = false;
                        Ext.getCmp('strANTGINECOActividadSexual').allowBlank = false;
                        Ext.getCmp('strANTGINECOPatologiaEmbarazo').allowBlank = false;
                        Ext.getCmp('strANTGINECOMenopausia').allowBlank = false;
                        Ext.getCmp('strEXAFISMamaAspecto').allowBlank = false;
                        Ext.getCmp('strEXAFISMamaGanglios').allowBlank = false;
                        Ext.getCmp('strEXAFISMamaMalestar').allowBlank = false;
                        Ext.getCmp('strEXAFISMamaDolor').allowBlank = false;
                        Ext.getCmp('strEXAFISMamaDescargas').allowBlank = false;
                        Ext.getCmp('strEXAFISMamaMasas').allowBlank = false;
                    }
                    //EVALUAR EDADES
                    //COMPANANTE MENOR A 14 ANOS
                    
                    if(MesesCumplidos <= 179){
                        Ext.getCmp('strDATINGPROGAcompanante').allowBlank = false;
                        Ext.getCmp('strDATINGPROGParentesco').allowBlank = false;
                    }else{
                        Ext.getCmp('strDATINGPROGAcompanante').allowBlank = true;
                        Ext.getCmp('strDATINGPROGParentesco').allowBlank = true;
                    }
                     //FUM MAYOR A 14 ANOS
                    if(Ext.getCmp('sysGeneroHC').getValue()=="FEMENINO" && MesesCumplidos >= 120){
                        Ext.getCmp('strANTGINECOFum_1').setValue (""); 
                        Ext.getCmp('strANTGINECOFum_1').allowBlank = false;
                        Ext.getCmp('fecANTGINECOFum').allowBlank = false;
                    }else{
                        Ext.getCmp('strANTGINECOFum_1').setValue ("NO"); 
                        Ext.getCmp('strANTGINECOFum_1').allowBlank = true;
                        Ext.getCmp('fecANTGINECOFum').allowBlank = true;
                    }
                    //CARGAR ANTECEDENTES
                    if(paramOpcion === "Nuevo"){ 
                        Ext.Ajax.request({
                            url: '../../controlador/asistencial/evolucionhc.php',
                            waitMsg: 'Cargando Información...',
                            params:{
                                pCAS: myCAS,
                                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                                task: 'ImportarAntecedentesFamiliares'
                            },
                            success: function(result, request)
                            {
                                var jsonAntFamiliares = Ext.util.JSON.decode(result.responseText);
                                CargarDataHCAntecedentes(jsonAntFamiliares.data.sysEvolucion);
                                Ext.Ajax.request({
                                    url: '../../controlador/asistencial/evolucionhc.php',
                                    waitMsg: 'Cargando Información...',
                                    params:{
                                        pCAS: myCAS,
                                        pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                                        task: 'ImportarAntecedentesPersonalesOfiClinic001'
                                    },
                                    success: function(result, request)
                                    {
                                        var jsonAntPersonales = Ext.util.JSON.decode(result.responseText);
                                        UtilCargarAntecedentesOfiClinic001(jsonAntPersonales.data);
                                    },
                                    scope:this
                                });
                            },
                            scope:this
                        });
                    }
                }
            }
        });
        winHCJoven001Ui.superclass.initComponent.call(this);
    }
});

function fnGuardarRegistrosMedicinaGeneral(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc.php',
            params:{
                task: 'guardar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pidPlantillaHC : Ext.getCmp('sysIdCodPlantillaHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function fnModificarRegistrosMedicinaGeneral(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc.php',
            params:{
                task: 'modificar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function calculoEdadPacienteMeses(){
    var valFecha1 = 0;
    var pFec2Anio = 0;
    var pFec2Mes = 0;
    var pFec2Dia = 0;
    var valFecha2 = 0;
    MesesCumplidos = 0;
    AniosCumplidos = 0;


    valFecha1 = Ext.getCmp('sysFechaHC').getValue();
    pFec2Anio = Ext.getCmp('sysFechaNac').getValue().substr(6,4);
    pFec2Mes = Ext.getCmp('sysFechaNac').getValue().substr(3,2);
    pFec2Dia = Ext.getCmp('sysFechaNac').getValue().substr(0,2);
    
    valFecha2 =  pFec2Anio + "/" + pFec2Mes + "/" + pFec2Dia;

    MesesCumplidos = MostrarEdadMeses(valFecha1, valFecha2);
    
    AniosCumplidos = MostrarEdadAnios(valFecha1, valFecha2);
}