/*
* @category    Formulario Modelo Evolucion Historia Clinica Cronicos
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winHCCronicos001Ui = Ext.extend(Ext.Window, {
    title: 'eOfiClinic ©  .:: Plantilla HC - Cronicos ::.',
    width: 990,
    height: 636,
    closable: false,
    resizable: false,
    draggable: false,
    modal: true,
    id: 'winHC',
    initComponent: function() {
        
        tmpmx = objMX;
        tmpmxadd = objMXADD;
        tmpexa = objEXA;
        tmprem = objREM;
        myPaciente = 0;
        myCAS = 0;
        
        try {
            var campo = Ext.getCmp('sysPacientePlantillaHC');
            if ( campo != null ) {
                myPaciente = Ext.getCmp('sysPacientePlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myPaciente == 0){
            try {
                var campo1 = Ext.getCmp('sysIdPacienteHC');
                if ( campo1 != null ) {
                    myPaciente = Ext.getCmp('sysIdPacienteHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myPaciente == 0){
            try {
                var campo5 = Ext.getCmp('sysPacienteRefHC');
                if ( campo5 != null ) {
                    myPaciente = Ext.getCmp('sysPacienteRefHC').getValue();
                }
            }catch(ex){
            }
        }
        try {
            var campo2 = Ext.getCmp('sysCASPlantillaHC');
            if ( campo2 != null ) {
                myCAS = Ext.getCmp('sysCASPlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myCAS == 0){
            try {
                var campo3 = Ext.getCmp('sysCASHC');
                if ( campo3 != null ) {
                    myCAS = Ext.getCmp('sysCASHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myCAS == 0){
            try {
                var campo4 = Ext.getCmp('sysCASRefHC');
                if ( campo4 != null ) {
                    myCAS = Ext.getCmp('sysCASRefHC').getValue();
                }
            }catch(ex){
            }
        }
        if (objMX != "NA"){
            var xSolMX = eval(objMX);
            Ext.getCmp('gridMedicamentosHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }
        else{
            var xSolMX = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        if (objEXA != "NA"){
            var xSolEXA = eval(objEXA);
            Ext.getCmp('gridExamenesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }else{
            var xSolEXA = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }    
        if (objREM != "NA"){
            var xSolREM = eval(objREM);
            Ext.getCmp('gridRemisionesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }else{
            var xSolREM = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        
        //Store Locales
        var dataResultadoCitologia = [
            ['NO REALIZADA'],
            ['NORMAL'],
            ['ANORMAL']
        ];
        var stResultadoCitologia = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stResultadoCitologia.loadData(dataResultadoCitologia);
        
        var dataViaCaptacion = [
            ['AFILIACIONES'],
            ['LABORATORIO'],
            ['URGENCIAS'],
            ['HOSPITALIZACION'],
            ['CONSULTA EXTERNA'],
            ['USUARIO']
        ];
        var stViaCaptacion = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stViaCaptacion.loadData(dataViaCaptacion);

        var dataParentesco = [
            ['CONYUGUE O COMPANERO PERMANENTE'],
            ['HIJO - HIJA'],
            ['PADRE - MADRE'],
            ['OTRO MIEMBRO DE LA FAMILIA'],
            ['OTRO NO PERTENECIENTE A LA FAMILIA']
        ];
        var stParentesco = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stParentesco.loadData(dataParentesco);
        
        var dataDatProgTipoDx = [
            ['NUEVO'],
            ['CONFIRMADO']
        ];
        var stDatProgTipoDx = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stDatProgTipoDx.loadData(dataDatProgTipoDx);
        
        var dataDatProgNivelRiesgo = [
            ['ALTO'],
            ['MEDIO'],
            ['BAJO']
        ];
        var stDatProgNivelRiesgo = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stDatProgNivelRiesgo.loadData(dataDatProgNivelRiesgo);
        
        var dataDatProgTipoDM = [
            ['TIPO 1'],
            ['TIPO 2']
        ];
        var stDatProgTipoDM = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stDatProgTipoDM.loadData(dataDatProgTipoDM);
        
        var dataDatProgEstadioNefroProteccion = [
            ['1'],
            ['2'],
            ['3'],
            ['4'],
            ['5']
        ];
        var stDatProgEstadioNefroProteccion = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stDatProgEstadioNefroProteccion.loadData(dataDatProgEstadioNefroProteccion);
        
        var dataProfesionalAtiende = [
            ['Medico General'],
            ['Medico Internista'],
            ['Medico Subespecialista'],
            ['Nutricionista'],
            ['Psicologia'],
            ['Enfermera']
        ];
        var stProfesionalAtiende = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stProfesionalAtiende.loadData(dataProfesionalAtiende);
        
        //
        this.items = [
            {
                xtype: 'panel',
                frame: true,
                anchor: '100%',
                id: 'panelHC',
                border: false,
                height: 570,
                autoScroll: true,
                layout: 'form',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'tabpanel',
                        anchor: '99%',
                        autoHeight: true,
                        border: false,
                        enableTabScroll: true,
                        ref: 'fTabPanel',
                        id: 'fTabPanel',
                        activeTab: 0,
                        items: [
                            {
                                xtype: 'panel',
                                title: 'IDENTIFICACION DEL PACIENTE',
                                autoHeight: true,
                                autoScroll: true,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaIdentifica',
                                layout: 'form',
                                items:[
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysIdCodPlantillaHC'
                                    },
                                     {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        value: 1,
                                        id: 'sysUsaGridSalida'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                                        value: 0,
                                        id: 'sysYaGuardoHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Plantilla',
                                        id: 'sysPlantillaHC',
                                        name: 'PLANTILLA'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysRutaRptHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysRutaRptMx'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysRutaRptExa'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysRutaRptRem'
                                    },
                                    {
                                        xtype: 'textfield',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Actividad',
                                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                                        id: 'sysActividadHC',
                                        name: 'PLANTILLA'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Empresa',
                                        id: 'sysEmpresaHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'IPS',
                                        id: 'sysIPSHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Usuario',
                                        id: 'sysUsuarioHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Profesional',
                                        id: 'sysProfesionalHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Paciente',
                                        id: 'sysIdPacienteHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Apertura',
                                        id: 'sysAperturaHC'
                                    },
                                    {
                                        xtype: 'textfield',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Cliente',
                                        id: 'sysClienteHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Plantilla',
                                        id: 'sysIdClienteHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Plantilla',
                                        id: 'sysIdPlanHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Plantilla',
                                        id: 'sysIdSubPlanHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Plantilla',
                                        id: 'sysIdContratoHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Genero',
                                        id: 'sysGeneroPacHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Edad',
                                        id: 'sysEdadPacHC'
                                    },
                                    {
                                        xtype: 'textfield',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Profesional',
                                        id: 'sysProfesionalAgendaHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'ConsecutivoDetalle',
                                        id: 'sysConsecutivoDetalleHC'
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'CAS',
                                                id: 'sysCASHC'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysFechaHC',
                                                value: 'Fecha: '
                                            },
                                            {
                                                xtype: 'textfield',
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysFechaHC'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysHoraHC',
                                                value: 'Hora: '
                                            },
                                            {
                                                xtype: 'textfield',
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysHoraHC'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysLegalizacionHC',
                                                value: 'Legalización: '
                                            },
                                            {
                                                xtype: 'textfield',
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysLegalizaHC'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'textfield',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Paciente',
                                        value: 'CC 792558261  - JORGE GALEANO RUIZ - (Masculino) FechaNac: 1973-01-30, Edad 38 Años',
                                        id: 'sysPacienteHC'
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 100,
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Genero',
                                                id: 'sysGeneroHC'
                                            },
                                            {
                                                html: 'Fecha Nac:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 100,
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysFechaNac'
                                            },
                                            {
                                                html: 'Edad:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 350,
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysEdadHC'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 370,
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Ocupación',
                                                id: 'sysOcupacionHC'
                                            },
                                            {
                                                html: 'Discapacidad:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 370,
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysDiscapacidadHC'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 370,
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Estado Civil',
                                                id: 'sysEstadoCivilHC'
                                            },
                                            {
                                                html: 'Escolaridad:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 380,
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysEscolaridadHC'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 370,
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Dirección',
                                                id: 'sysDireccionHC'
                                            },
                                            {
                                                html: 'Telefono:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 390,
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysTelefonoHC'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 380,
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Etnia',
                                                id: 'sysEtniaHC'
                                            },
                                            {
                                                html: 'Estrato:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 390,
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysEstratoHC'
                                            }
                                        ]
                                    },
                                    {
                                        html: '<hr>',
                                        style: 'background:transparent;',
                                        border: false
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Evolución',
                                autoHeight: true,
                                autoScroll: true,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaEvolucion',
                                layout: 'form',
                                items: [
                                    {
                                        xtype: 'form',
                                        frame: true,
                                        anchor: '100%',
                                        id: 'frmHC',
                                        padding: 10,
                                        border: false,
                                        autoScroll: true,
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                allowBlank: true,
                                                value: 'SI',
                                                readOnly: true,
                                                id: 'strINGRESOPROGRAMA'
                                            },      
                                            {   
                                                xtype: 'combo',
                                                fieldLabel: 'Inasistencia a la Consulta',
                                                name: 'Inasistencia a la Consulta',
                                                width: 60,
                                                allowBlank: false,
                                                value:'NO',
                                                store: 'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                id: 'strINASISTENCIA'
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        fieldLabel: 'Acompañante',
                                                        name: 'Acompañante',
                                                        width: 350,
                                                        allowBlank: true,
                                                        id: 'strDATINGPROGAcompañante'
                                                    },
                                                    {
                                                        html: '   Parentesco:'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: 'Parentezco',
                                                        width: 350,
                                                        allowBlank: false,
                                                        store: stParentesco,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strDATINGPROGParentesco'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'MOTIVO DE CONSULTA',
                                                layout: 'table',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'MOTIVO DE CONSULTA',
                                                        name: 'MOTIVO DE CONSULTA',
                                                        height: 100,            
                                                        allowBlank: false,
                                                        id: 'memMotivoConsulta'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'ENFERMEDAD ACTUAL',
                                                layout: 'table',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'ENFERMEDAD ACTUAL',
                                                        name: 'ENFERMEDAD ACTUAL',
                                                        height: 100,            
                                                        allowBlank: false,
                                                        id: 'memEnfermedadActual'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'REVISION POR SISTEMAS',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 5,
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Piel y Anexos',
                                                        name: 'Piel y Anexos',
                                                        allowBlank: false,
                                                        id: 'strREVxSISTEMASPielAnexos',
                                                        listeners: { 
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strREVxSISTEMASPielAnexos').setValue("No Refiere");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Organos de los Sentidos',
                                                        name: 'Organos de los Sentidos',
                                                        allowBlank: false,
                                                        id: 'strREVxSISTEMASOrganosSentidos',
                                                        listeners: { 
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strREVxSISTEMASOrganosSentidos').setValue("No Refiere");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Cardiovascular',
                                                        name: 'Cardiovascular',
                                                        allowBlank: false,
                                                        id: 'strREVxSISTEMASCardiovascular',
                                                        listeners: { 
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strREVxSISTEMASCardiovascular').setValue("No Refiere");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Pulmonar',
                                                        name: 'Pulmonar',
                                                        allowBlank: false,
                                                        id: 'strREVxSISTEMASPulmonar',
                                                        listeners: { 
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strREVxSISTEMASPulmonar').setValue("No Refiere");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Digestivo',
                                                        name: 'Digestivo',
                                                        allowBlank: false,
                                                        id: 'strREVxSISTEMASDigestivo',
                                                        listeners: { 
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strREVxSISTEMASDigestivo').setValue("No Refiere");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Genito-Urinario',
                                                        name: 'Genito-Urinario',
                                                        allowBlank: false,
                                                        id: 'strREVxSISTEMASGenitoUrinario',
                                                        listeners: { 
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strREVxSISTEMASGenitoUrinario').setValue("No Refiere");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Musculo-Esqueletico',
                                                        name: 'Musculo-Esqueletico',
                                                        allowBlank: false,
                                                        id: 'strREVxSISTEMASMusculoEsqueletico',
                                                        listeners: { 
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strREVxSISTEMASMusculoEsqueletico').setValue("No Refiere");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Neurologico',
                                                        name: 'Neurologico',
                                                        allowBlank: false,
                                                        id: 'strREVxSISTEMASNeurologico',
                                                        listeners: { 
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strREVxSISTEMASNeurologico').setValue("No Refiere");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Endocrinologico',
                                                        name: 'Otros',
                                                        allowBlank: false,
                                                        id: 'strREVxSISTEMASEndocrinologico',
                                                        listeners: { 
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strREVxSISTEMASEndocrinologico').setValue("No Refiere");
                                                                });
                                                            }
                                                        }
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'ANTECEDENTES PERSONALES',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        fieldLabel: 'Patologicos',
                                                        name: 'Patologicos',
                                                        allowBlank: false,
                                                        id: 'memANTPERSOPatologicos',
                                                        listeners: { 
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('memANTPERSOPatologicos').setValue("No Refiere");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        fieldLabel: 'Farmacologicos',
                                                        name: 'Farmacologicos',
                                                        allowBlank: false,
                                                        id: 'memANTPERSOFarmacologicos',
                                                        listeners: { 
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('memANTPERSOFarmacologicos').setValue("No Refiere");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        fieldLabel: 'Quirurgicos',
                                                        name: 'Quirurgicos',
                                                        allowBlank: false,
                                                        id: 'memANTPERSOQuirurgicos',
                                                        listeners: { 
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('memANTPERSOQuirurgicos').setValue("No Refiere");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        fieldLabel: 'Traumatologicos',
                                                        name: 'Traumatologicos',
                                                        allowBlank: false,
                                                        id: 'memANTPERSOTraumatologicos',
                                                        listeners: { 
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('memANTPERSOTraumatologicos').setValue("No Refiere");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        autoHeight: true,
                                                        anchor: '100%',
                                                        layout: {
                                                            columns: 3,
                                                            type: 'table'
                                                        },
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                autoHeight: true,
                                                                width: 280,
                                                                layout: {
                                                                    type: 'form'
                                                                },
                                                                items: [
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'TBC',
                                                                        name: 'TBC',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolANTPERSOTBC'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'Diabetes',
                                                                        name: 'Diabetes',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolANTPERSODiabetes'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'HTA',
                                                                        name: 'HTA',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolANTPERSOHTA'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'Preclampsia',
                                                                        name: 'Preclampsia',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolANTPERSOPreclampsia'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                autoHeight: true,
                                                                width: 280,
                                                                layout: {
                                                                    type: 'form'
                                                                },
                                                                items: [
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'Eclampsia',
                                                                        name: 'Eclampsia',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolANTPERSOEclampsia'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'Infertilidad',
                                                                        name: 'Infertilidad',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolANTPERSOInfertilidad'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'VIH',
                                                                        name: 'VIH',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolANTPERSOVIH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                autoHeight: true,
                                                                width: 280,
                                                                layout: {
                                                                    type: 'form'
                                                                },
                                                                items: [
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'Cardiopatias',
                                                                        name: 'Cardiopatias',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolANTPERSOCardiopatias'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'Nefropatias',
                                                                        name: 'Nefropatias',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolANTPERSONefropatias'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'Condicion Medica Grave',
                                                                        name: 'Condicion Medica Grave',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolANTPERSOCondicionGrave'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        fieldLabel: 'Otros',
                                                        name: 'Otros',
                                                        allowBlank: true,
                                                        id: 'memANTPERSOOtros'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'ANTECEDENTES TOXICOLOGICOS',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Alcohol',
                                                                name: 'Alcohol',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strANTTOXOAlcohol',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO"){
                                                                            Ext.getCmp('strANTTOXOAlcoholH').allowBlank = true;
                                                                            Ext.getCmp('strANTTOXOAlcoholH').setValue(null);
                                                                            Ext.getCmp('strANTTOXOAlcoholH').disable();
                                                                            Ext.getCmp('strANTTOXOAlcoholH').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strANTTOXOAlcoholH').enable();
                                                                            Ext.getCmp('strANTTOXOAlcoholH').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                emptyText: 'HALLAZGOS',
                                                                name: "HALLAZGOS - Alcohol",
                                                                disabled: true,
                                                                width: 710,
                                                                height: 20,
                                                                grow: true,
                                                                growMin: 20,
                                                                growMax: 40,
                                                                allowBlank: true,
                                                                id: 'strANTTOXOAlcoholH'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Tabaco',
                                                                name: 'Tabaco',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strANTTOXOTabaco',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO"){
                                                                            Ext.getCmp('strANTTOXOTabacoH').allowBlank = true;
                                                                            Ext.getCmp('strANTTOXOTabacoH').setValue(null);
                                                                            Ext.getCmp('strANTTOXOTabacoH').disable();
                                                                            Ext.getCmp('strANTTOXOTabacoH').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strANTTOXOTabacoH').enable();
                                                                            Ext.getCmp('strANTTOXOTabacoH').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                emptyText: 'HALLAZGOS',
                                                                name: "HALLAZGOS - Tabaco",
                                                                disabled: true,
                                                                width: 710,
                                                                height: 20,
                                                                grow: true,
                                                                growMin: 20,
                                                                growMax: 40,
                                                                allowBlank: true,
                                                                id: 'strANTTOXOTabacoH'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Sustancia Psicoactivas',
                                                                name: 'Sustancia Psicoactivas',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strANTTOXOSustanciaPsicoactivas',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO"){
                                                                            Ext.getCmp('strANTTOXOSustanciaPsicoactivasH').allowBlank = true;
                                                                            Ext.getCmp('strANTTOXOSustanciaPsicoactivasH').setValue(null);
                                                                            Ext.getCmp('strANTTOXOSustanciaPsicoactivasH').disable();
                                                                            Ext.getCmp('strANTTOXOSustanciaPsicoactivasH').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strANTTOXOSustanciaPsicoactivasH').enable();
                                                                            Ext.getCmp('strANTTOXOSustanciaPsicoactivasH').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                emptyText: 'HALLAZGOS',
                                                                name: "HALLAZGOS - Sustancia Psicoactivas",
                                                                disabled: true,
                                                                width: 710,
                                                                height: 20,
                                                                grow: true,
                                                                growMin: 20,
                                                                growMax: 40,
                                                                allowBlank: true,
                                                                id: 'strANTTOXOSustanciaPsicoactivasH'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        fieldLabel: 'Otros',
                                                        name: 'Otros',
                                                        allowBlank: true,
                                                        id: 'memANTTOXOOtros'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'ANTECEDENTES ALERGICOS',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Alimentos',
                                                                name: 'Alimentos',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strANTALERGAlimentos',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO"){
                                                                            Ext.getCmp('strANTALERGAlimentosH').allowBlank = true;
                                                                            Ext.getCmp('strANTALERGAlimentosH').setValue(null);
                                                                            Ext.getCmp('strANTALERGAlimentosH').disable();
                                                                            Ext.getCmp('strANTALERGAlimentosH').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strANTALERGAlimentosH').enable();
                                                                            Ext.getCmp('strANTALERGAlimentosH').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                emptyText: 'HALLAZGOS',
                                                                name: "HALLAZGOS - Alimentos",
                                                                disabled: true,
                                                                width: 710,
                                                                height: 20,
                                                                grow: true,
                                                                growMin: 20,
                                                                growMax: 40,
                                                                allowBlank: true,
                                                                id: 'strANTALERGAlimentosH'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Medicamentos',
                                                                name: 'Medicamentos',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strANTALERGMedicamentos',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO"){
                                                                            Ext.getCmp('strANTALERGMedicamentosH').allowBlank = true;
                                                                            Ext.getCmp('strANTALERGMedicamentosH').setValue(null);
                                                                            Ext.getCmp('strANTALERGMedicamentosH').disable();
                                                                            Ext.getCmp('strANTALERGMedicamentosH').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strANTALERGMedicamentosH').enable();
                                                                            Ext.getCmp('strANTALERGMedicamentosH').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                emptyText: 'HALLAZGOS',
                                                                name: "HALLAZGOS - Medicamentos",
                                                                disabled: true,
                                                                width: 710,
                                                                height: 20,
                                                                grow: true,
                                                                growMin: 20,
                                                                growMax: 40,
                                                                allowBlank: true,
                                                                id: 'strANTALERGMedicamentosH'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Medio Ambiente',
                                                                name: 'Medio Ambiente',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strANTALERGMedioAmbiente',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO"){
                                                                            Ext.getCmp('strANTALERGMedioAmbienteH').allowBlank = true;
                                                                            Ext.getCmp('strANTALERGMedioAmbienteH').setValue(null);
                                                                            Ext.getCmp('strANTALERGMedioAmbienteH').disable();
                                                                            Ext.getCmp('strANTALERGMedioAmbienteH').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strANTALERGMedioAmbienteH').enable();
                                                                            Ext.getCmp('strANTALERGMedioAmbienteH').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                emptyText: 'HALLAZGOS',
                                                                name: "HALLAZGOS - Medio Ambiente",
                                                                disabled: true,
                                                                width: 710,
                                                                height: 20,
                                                                grow: true,
                                                                growMin: 20,
                                                                growMax: 40,
                                                                allowBlank: true,
                                                                id: 'strANTALERGMedioAmbienteH'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        fieldLabel: 'Otros',
                                                        name: 'Otros',
                                                        allowBlank: true,
                                                        id: 'memANTALERGOtros'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'ANTECEDENTES GINECO-OBSTETRICOS',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                html: 'G:'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'G',
                                                                emptyText: 'Gestaciones', 
                                                                width: 70,
                                                                minValue: 0,
                                                                maxValue: 20,
                                                                decimalPrecision: 0,
                                                                allowBlank: false,
                                                                id: 'intANTGINECOG'
                                                            },
                                                            {
                                                                html: 'P:'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'P',
                                                                emptyText: 'Partos', 
                                                                width: 70,
                                                                minValue: 0,
                                                                maxValue: 20,
                                                                decimalPrecision: 0,
                                                                allowBlank: false,
                                                                id: 'intANTGINECOP'
                                                            },
                                                            {
                                                                html: 'P.V:'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'PV',
                                                                emptyText: 'Vaginales', 
                                                                width: 70,
                                                                minValue: 0,
                                                                maxValue: 20,
                                                                decimalPrecision: 0,
                                                                allowBlank: false,
                                                                id: 'intANTGINECOPV'
                                                            },
                                                            {
                                                                html: 'P.C:'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'PC',
                                                                emptyText: 'Por Cesarea', 
                                                                width: 70,
                                                                minValue: 0,
                                                                maxValue: 20,
                                                                decimalPrecision: 0,
                                                                allowBlank: false,
                                                                id: 'intANTGINECOPC'
                                                            },
                                                            {
                                                                html: 'A:'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'A',
                                                                emptyText: 'Abortos', 
                                                                width: 70,
                                                                minValue: 0,
                                                                maxValue: 20,
                                                                decimalPrecision: 0,
                                                                allowBlank: false,
                                                                id: 'intANTGINECOA'
                                                            },
                                                            {
                                                                html: 'Vivos:'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'V',
                                                                width: 70,
                                                                minValue: 0,
                                                                maxValue: 20,
                                                                decimalPrecision: 0,
                                                                allowBlank: false,
                                                                id: 'intANTGINECOVivos'
                                                            },
                                                            {
                                                                html: 'Muertos:'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'M',
                                                                width: 70,
                                                                minValue: 0,
                                                                maxValue: 20,
                                                                decimalPrecision: 0,
                                                                allowBlank: false,
                                                                id: 'intANTGINECOMuertos'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                html: 'Mola:'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                name: 'Mola',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolANTGINECOMola'
                                                            },
                                                            {
                                                                html: 'Embarazo Ectopico:'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                name: 'Embarazo Ectopico',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolANTGINECOEmbEctopico'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                fieldLabel: 'Menarquia',
                                                                name: 'Menarquia',
                                                                width: 370,
                                                                allowBlank: true,
                                                                id: 'strANTGINECOMenarquia'
                                                            },
                                                            {
                                                                html: 'Menopausia:'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Menopausia',
                                                                width: 300,
                                                                allowBlank: true,
                                                                id: 'strANTGINECOMenopausia'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'datefield',
                                                                width: 120,
                                                                fieldLabel: 'FUM',
                                                                name: 'FUM',
                                                                allowBlank: true,
                                                                disabledDates: '',
                                                                emptyText: '(dia/mes/año) ',
                                                                style: 'text-align:center;',
                                                                id: 'fecANTGINECOFum'
                                                            },
                                                            {
                                                                html: 'FUP:'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 120,
                                                                name: 'FUP',
                                                                allowBlank: true,
                                                                disabledDates: '',
                                                                emptyText: '(dia/mes/año) ',
                                                                style: 'text-align:center;',
                                                                id: 'fecANTGINECOFup'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'datefield',
                                                                width: 120,
                                                                fieldLabel: 'Ultima Citologia',
                                                                name: 'Ultima Citologia',
                                                                allowBlank: true,
                                                                disabledDates: '',
                                                                emptyText: '(dia/mes/año) ',
                                                                style: 'text-align:center;',
                                                                id: 'fecANTGINECOFuc'
                                                            },
                                                            {
                                                                html: 'Resultado:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Resultado',
                                                                width: 150,
                                                                allowBlank: false,
                                                                store: stResultadoCitologia,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strANTGINECOFucRes'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Metodo Planificacion',
                                                        name: 'Metodo Planificacion',
                                                        anchor: '100%',
                                                        allowBlank: false,
                                                        store: 'StoreMetodosPlanificacion',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strANTGINECOMetodoPlanifica'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Ciclos Mestruales',
                                                        name: 'Ciclos Mestruales',
                                                        allowBlank: false,
                                                        id: 'strANTGINECOCiclosMestruales',
                                                        listeners: { 
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strANTGINECOCiclosMestruales').setValue("Negativo");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Actividad Sexual',
                                                        name: 'Actividad Sexual',
                                                        allowBlank: false,
                                                        id: 'strANTGINECOActividadSexual',
                                                        listeners: { 
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strANTGINECOActividadSexual').setValue("Negativo");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Patologias Relacionadas Emb.',
                                                        name: 'Patologias Relacionadas Emb.',
                                                        allowBlank: false,
                                                        id: 'strANTGINECOPatologiaEmbarazo',
                                                        listeners: { 
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strANTGINECOPatologiaEmbarazo').setValue("Negativo");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        fieldLabel: 'Otros',
                                                        name: 'Otros',
                                                        allowBlank: true,
                                                        id: 'memANTGINECOOtros'
                                                    }
                                                ]
                                            },
                                            {   
                                                xtype: 'fieldset',
                                                title: 'ANTECEDENTES FAMILIARES',
                                                layout: 'table',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'ANTECEDENTES FAMILIARES',
                                                        name: 'ANTECEDENTES FAMILIARES',
                                                        height: 100,            
                                                        allowBlank: false,
                                                        id: 'memAntecedentesFamiliares'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'EXAMEN FISICO',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                fieldLabel: 'T.A. (Sentado)',
                                                                name: 'T.A. (Sentado) Sistolica',
                                                                width: 70,
                                                                minValue: 0,
                                                                maxValue: 300,
                                                                decimalPrecision: 0,
                                                                allowBlank: false,
                                                                id: 'intEXAFISTASentadoSistolica'
                                                            },
                                                            {
                                                                html: '/'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'T.A. (Sentado) Diastolica',
                                                                width: 70,
                                                                minValue: 0,
                                                                maxValue: 300,
                                                                decimalPrecision: 0,
                                                                allowBlank: false,
                                                                id: 'intEXAFISTASentadoDiastolica'
                                                            },
                                                            {
                                                                html: '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;-&nbsp;'
                                                            },
                                                            {
                                                                html: 'T.A. (Acostado):'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'T.A. (Acostado) Sistolica',
                                                                width: 70,
                                                                minValue: 0,
                                                                maxValue: 300,
                                                                decimalPrecision: 0,
                                                                allowBlank: false,
                                                                id: 'intEXAFISTAAcostadoSistolica'
                                                            },
                                                            {
                                                                html: '/'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'T.A. (Acostado) Diastolica',
                                                                width: 70,
                                                                minValue: 0,
                                                                maxValue: 300,
                                                                decimalPrecision: 0,
                                                                allowBlank: false,
                                                                id: 'intEXAFISTAAcostadoDiastolica'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                fieldLabel: 'TALLA (cm)',
                                                                name:"TALLA (cm)",
                                                                emptyText: '(cm)',
                                                                id: 'intEXAFISTalla',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        if(pNew == null || pNew == 0){
                                                                            Ext.getCmp('intEXAFISTalla').setValue(null);
                                                                            Ext.getCmp('intEXAFISIMC').setValue(0);
                                                                        }else{
                                                                            if(Ext.getCmp('intEXAFISPeso').getValue() > 0){
                                                                                var pTalla = Ext.getCmp('intEXAFISTalla').getValue() / 100;
                                                                                Ext.getCmp('intEXAFISIMC').setValue(Ext.getCmp('intEXAFISPeso').getValue()/(pTalla*pTalla));
                                                                            }else{
                                                                                Ext.getCmp('intEXAFISIMC').setValue(0);
                                                                            }
                                                                        }
                                                                        if(Ext.getCmp('intEXAFISIMC').getValue()<1){
                                                                           Ext.getCmp('strEXAFISIMCClasificacon').setValue(null);
                                                                        }else{
                                                                            if(Ext.getCmp('intEXAFISIMC').getValue()<24.9){
                                                                               Ext.getCmp('strEXAFISIMCClasificacon').setValue("ACEPTABLE");
                                                                            }else{
                                                                                if(Ext.getCmp('intEXAFISIMC').getValue()<29.9){
                                                                                   Ext.getCmp('strEXAFISIMCClasificacon').setValue("SOBREPESO");
                                                                                }else{
                                                                                    Ext.getCmp('strEXAFISIMCClasificacon').setValue("OBESIDAD");
                                                                                }

                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysEXAFISPeso',
                                                                value: 'PESO (Kg): '
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                emptyText: '(Kg)',
                                                                name:"PESO (Kg)",
                                                                id: 'intEXAFISPeso',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        if(pNew == null || pNew == 0){
                                                                            Ext.getCmp('intEXAFISPeso').setValue(null);
                                                                            Ext.getCmp('intEXAFISIMC').setValue(0);
                                                                        }else{
                                                                            //peso [kg]/ estatura [m2]
                                                                            if(Ext.getCmp('intEXAFISTalla').getValue() > 0){
                                                                                var pTalla = Ext.getCmp('intEXAFISTalla').getValue() / 100;
                                                                                Ext.getCmp('intEXAFISIMC').setValue(Ext.getCmp('intEXAFISPeso').getValue()/(pTalla*pTalla));
                                                                            }else{
                                                                                Ext.getCmp('intEXAFISIMC').setValue(0);
                                                                            }
                                                                        }
                                                                        if(Ext.getCmp('intEXAFISIMC').getValue()<1){
                                                                           Ext.getCmp('strEXAFISIMCClasificacon').setValue(null);
                                                                        }else{
                                                                            if(Ext.getCmp('intEXAFISIMC').getValue()<24.9){
                                                                               Ext.getCmp('strEXAFISIMCClasificacon').setValue("ACEPTABLE");
                                                                            }else{
                                                                                if(Ext.getCmp('intEXAFISIMC').getValue()<29.9){
                                                                                   Ext.getCmp('strEXAFISIMCClasificacon').setValue("SOBREPESO");
                                                                                }else{
                                                                                    Ext.getCmp('strEXAFISIMCClasificacon').setValue("OBESIDAD");
                                                                                }

                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysEXAFISIMC',
                                                                value: 'IMC: '
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                readOnly: true,
                                                                name: "IMC",
                                                                id: 'intEXAFISIMC'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                allowBlank: true,
                                                                readOnly: true,
                                                                name: "IMC - CLASIFICACION",
                                                                id: 'strEXAFISIMCClasificacon'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysEXAFISPA',
                                                                value: 'P. Abd: '
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                decimalPrecision: 2,
                                                                name: 'PA',
                                                                allowBlank: true,
                                                                id: 'strEXAFISPA'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Condiciones Generales',
                                                        name: 'Condiciones Generales',
                                                        allowBlank: false,
                                                        id: 'strEXAFISCondicionesGenerales',
                                                        listeners: { 
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strEXAFISCondicionesGenerales').setValue("Normal");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Cabeza',
                                                        name: 'Cabeza',
                                                        allowBlank: false,
                                                        id: 'strEXAFISCabeza',
                                                        listeners: { 
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strEXAFISCabeza').setValue("Normal");
                                                                });
                                                            }
                                                        }
                                                        
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Ojos',
                                                        name: 'Ojos',
                                                        allowBlank: false,
                                                        id: 'strEXAFISOjos',
                                                        listeners: { 
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strEXAFISOjos').setValue("Normal");
                                                                });
                                                            }
                                                        }
                                                    },
                                                     {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Nariz',
                                                        name: 'Nariz',
                                                        allowBlank: false,
                                                        id: 'strEXAFISNariz',
                                                        listeners: { 
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strEXAFISNariz').setValue("Normal");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Orofaringe',
                                                        name: 'Orofaringe',
                                                        allowBlank: false,
                                                        id: 'strEXAFISOrofaringe',
                                                        listeners: { 
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strEXAFISOrofaringe').setValue("Normal");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Cuello',
                                                        name: 'Cuello',
                                                        allowBlank: false,
                                                        id: 'strEXAFISCuello',
                                                        listeners: { 
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strEXAFISCuello').setValue("Normal");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Dorso',
                                                        name: 'Dorso',
                                                        allowBlank: false,
                                                        id: 'strEXAFISDorso',
                                                        listeners: { 
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strEXAFISDorso').setValue("Normal");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Mamas',
                                                        name: 'Mamas',
                                                        allowBlank: false,
                                                        id: 'strEXAFISMamas',
                                                        listeners: { 
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strEXAFISMamas').setValue("Normal");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Cardiaco',
                                                        name: 'Cardiaco',
                                                        allowBlank: false,
                                                        id: 'strEXAFISCardiaco',
                                                        listeners: { 
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strEXAFISCardiaco').setValue("Normal");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Pulmonar',
                                                        name: 'Pulmonar',
                                                        allowBlank: false,
                                                        id: 'strEXAFISPulmonar',
                                                        listeners: { 
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strEXAFISPulmonar').setValue("Normal");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Abdomen',
                                                        name: 'Abdomen',
                                                        allowBlank: false,
                                                        id: 'strEXAFISAbdomen',
                                                        listeners: { 
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strEXAFISAbdomen').setValue("Normal");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Genitales',
                                                        name: 'Genitales',
                                                        allowBlank: false,
                                                        id: 'strEXAFISGenitales',
                                                        listeners: { 
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strEXAFISGenitales').setValue("Normal");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Extremidades',
                                                        name: 'Extremidades',
                                                        allowBlank: false,
                                                        id: 'strEXAFISExtremidades',
                                                        listeners: { 
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strEXAFISExtremidades').setValue("Normal");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Neurologico',
                                                        name: 'Neurologico',
                                                        allowBlank: false,
                                                        id: 'strEXAFISNeurologico',
                                                        listeners: { 
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strEXAFISNeurologico').setValue("Normal");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'Compromiso de Organo Blanco',
                                                        layout: 'form',
                                                        collapsible: true,
                                                        titleCollapse: true,
                                                        anchor: '100%',
                                                        autoHeight: true,
                                                        padding: 7,
                                                        items:[
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                fieldLabel: 'Corazon',
                                                                name: 'Corazon',
                                                                allowBlank: false,
                                                                id: 'strEXAFISCompromisoCorazon',
                                                                listeners: { 
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strEXAFISCompromisoCorazon').setValue("Negativo");
                                                                        });
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                fieldLabel: 'Cerebro Vascular',
                                                                name: 'Cerebro Vascular',
                                                                allowBlank: false,
                                                                id: 'strEXAFISCompromisoCerebroVascular',
                                                                listeners: { 
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strEXAFISCompromisoCerebroVascular').setValue("Negativo");
                                                                        });
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                fieldLabel: 'Vascular',
                                                                name: 'Vascular',
                                                                allowBlank: false,
                                                                id: 'strEXAFISCompromisoVascular',
                                                                listeners: { 
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strEXAFISCompromisoVascular').setValue("Negativo");
                                                                        });
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                fieldLabel: 'Renal',
                                                                name: 'Renal',
                                                                allowBlank: false,
                                                                id: 'strEXAFISCompromisoRenal',
                                                                listeners: { 
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strEXAFISCompromisoRenal').setValue("Negativo");
                                                                        });
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                fieldLabel: 'Vision',
                                                                name: 'Vision',
                                                                allowBlank: false,
                                                                id: 'strEXAFISCompromisoVision',
                                                                listeners: { 
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strEXAFISCompromisoVision').setValue("Negativo");
                                                                        });
                                                                    }
                                                                }
                                                            },
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'REPORTE DE LABORATORIOS',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items:[
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {   
                                                                xtype: 'combo',
                                                                fieldLabel: 'Parcial de Orina',
                                                                name: 'Parcial de Orina',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strRESLABTraeParcialorina',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO"){
                                                                            Ext.getCmp('fecRESLABParcialorina').allowBlank = true;
                                                                            Ext.getCmp('strRESLABParcialorinaRes').allowBlank = true;
                                                                            Ext.getCmp('fecRESLABParcialorina').setValue(null);
                                                                            Ext.getCmp('strRESLABParcialorinaRes').setValue(null);
                                                                            Ext.getCmp('fecRESLABParcialorina').disable();
                                                                            Ext.getCmp('strRESLABParcialorinaRes').disable();
                                                                            Ext.getCmp('fecRESLABParcialorina').clearInvalid();
                                                                            Ext.getCmp('strRESLABParcialorinaRes').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('fecRESLABParcialorina').enable();
                                                                            Ext.getCmp('strRESLABParcialorinaRes').enable();
                                                                            Ext.getCmp('fecRESLABParcialorina').allowBlank = false;
                                                                            Ext.getCmp('strRESLABParcialorinaRes').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html:'Fecha:'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 120,
                                                                name: 'Fecha',
                                                                allowBlank: true,
                                                                disabled: true,
                                                                emptyText: '(dia/mes/año) ',
                                                                style: 'text-align:center;',
                                                                id: 'fecRESLABParcialorina'
                                                            },
                                                            {
                                                                html: ' - '
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 400,
                                                                name: 'Resultado Pacial Orina',
                                                                emptyText: 'Resultado',
                                                                disabled: true,
                                                                allowBlank: false,
                                                                id: 'strRESLABParcialorinaRes'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {   
                                                                xtype: 'combo',
                                                                fieldLabel: 'Colesterol Total',
                                                                name: 'Colesterol Total',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strRESLABTraeColesterolTotal',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO"){
                                                                            Ext.getCmp('fecRESLABColesterolTotal').allowBlank = true;
                                                                            Ext.getCmp('strRESLABColesterolTotalRes').allowBlank = true;
                                                                            Ext.getCmp('fecRESLABColesterolTotal').setValue(null);
                                                                            Ext.getCmp('strRESLABColesterolTotalRes').setValue(null);
                                                                            Ext.getCmp('fecRESLABColesterolTotal').disable();
                                                                            Ext.getCmp('strRESLABColesterolTotalRes').disable();
                                                                            Ext.getCmp('fecRESLABColesterolTotal').clearInvalid();
                                                                            Ext.getCmp('strRESLABColesterolTotalRes').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('fecRESLABColesterolTotal').enable();
                                                                            Ext.getCmp('strRESLABColesterolTotalRes').enable();
                                                                            Ext.getCmp('fecRESLABColesterolTotal').allowBlank = false;
                                                                            Ext.getCmp('strRESLABColesterolTotalRes').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html:'Fecha:'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 120,
                                                                name: 'Fecha',
                                                                allowBlank: true,
                                                                disabled: true,
                                                                emptyText: '(dia/mes/año) ',
                                                                style: 'text-align:center;',
                                                                id: 'fecRESLABColesterolTotal'
                                                            },
                                                            {
                                                                html: ' - '
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'Resultado Colesterol Total',
                                                                emptyText: 'Rango 20 - 700',
                                                                width: 110,
                                                                decimalPrecision: 0,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                id: 'strRESLABColesterolTotalRes'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {   
                                                                xtype: 'combo',
                                                                fieldLabel: 'Colesterol HDL',
                                                                name: 'Colesterol HDL',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strRESLABTraeColesterolHDL',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO"){
                                                                            Ext.getCmp('fecRESLABColesterolHDL').allowBlank = true;
                                                                            Ext.getCmp('strRESLABColesterolHDLRes').allowBlank = true;
                                                                            Ext.getCmp('fecRESLABColesterolHDL').setValue(null);
                                                                            Ext.getCmp('strRESLABColesterolHDLRes').setValue(null);
                                                                            Ext.getCmp('fecRESLABColesterolHDL').disable();
                                                                            Ext.getCmp('strRESLABColesterolHDLRes').disable();
                                                                            Ext.getCmp('fecRESLABColesterolHDL').clearInvalid();
                                                                            Ext.getCmp('strRESLABColesterolHDLRes').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('fecRESLABColesterolHDL').enable();
                                                                            Ext.getCmp('strRESLABColesterolHDLRes').enable();
                                                                            Ext.getCmp('fecRESLABColesterolHDL').allowBlank = false;
                                                                            Ext.getCmp('strRESLABColesterolHDLRes').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html:'Fecha:'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 120,
                                                                name: 'Fecha',
                                                                allowBlank: true,
                                                                disabled: true,
                                                                emptyText: '(dia/mes/año) ',
                                                                style: 'text-align:center;',
                                                                id: 'fecRESLABColesterolHDL'
                                                            },
                                                            {
                                                                html: ' - '
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'Resultado Colesterol HDL',
                                                                emptyText: 'Rango 10 - 500',
                                                                width: 110,
                                                                decimalPrecision: 0,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                id: 'strRESLABColesterolHDLRes'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {   
                                                                xtype: 'combo',
                                                                fieldLabel: 'Colesterol LDL',
                                                                name: 'Colesterol LDL',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strRESLABTraeColesterolLDL',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO"){
                                                                            Ext.getCmp('fecRESLABColesterolLDL').allowBlank = true;
                                                                            Ext.getCmp('strRESLABColesterolLDLRes').allowBlank = true;
                                                                            Ext.getCmp('fecRESLABColesterolLDL').setValue(null);
                                                                            Ext.getCmp('strRESLABColesterolLDLRes').setValue(null);
                                                                            Ext.getCmp('fecRESLABColesterolLDL').disable();
                                                                            Ext.getCmp('strRESLABColesterolLDLRes').disable();
                                                                            Ext.getCmp('fecRESLABColesterolLDL').clearInvalid();
                                                                            Ext.getCmp('strRESLABColesterolLDLRes').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('fecRESLABColesterolLDL').enable();
                                                                            Ext.getCmp('strRESLABColesterolLDLRes').enable();
                                                                            Ext.getCmp('fecRESLABColesterolLDL').allowBlank = false;
                                                                            Ext.getCmp('strRESLABColesterolLDLRes').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html:'Fecha:'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 120,
                                                                name: 'Fecha',
                                                                allowBlank: true,
                                                                disabled: true,
                                                                emptyText: '(dia/mes/año) ',
                                                                style: 'text-align:center;',
                                                                id: 'fecRESLABColesterolLDL'
                                                            },
                                                            {
                                                                html: ' - '
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'Resultado Colesterol LDL',
                                                                emptyText: 'Rango 10 - 500',
                                                                width: 110,
                                                                decimalPrecision: 0,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                id: 'strRESLABColesterolLDLRes'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {   
                                                                xtype: 'combo',
                                                                fieldLabel: 'Trigliceridos',
                                                                name: 'Trigliceridos',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strRESLABTraeTrigliceridos',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO"){
                                                                            Ext.getCmp('fecRESLABTrigliceridos').allowBlank = true;
                                                                            Ext.getCmp('strRESLABTrigliceridosRes').allowBlank = true;
                                                                            Ext.getCmp('fecRESLABTrigliceridos').setValue(null);
                                                                            Ext.getCmp('strRESLABTrigliceridosRes').setValue(null);
                                                                            Ext.getCmp('fecRESLABTrigliceridos').disable();
                                                                            Ext.getCmp('strRESLABTrigliceridosRes').disable();
                                                                            Ext.getCmp('fecRESLABTrigliceridos').clearInvalid();
                                                                            Ext.getCmp('strRESLABTrigliceridosRes').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('fecRESLABTrigliceridos').enable();
                                                                            Ext.getCmp('strRESLABTrigliceridosRes').enable();
                                                                            Ext.getCmp('fecRESLABTrigliceridos').allowBlank = false;
                                                                            Ext.getCmp('strRESLABTrigliceridosRes').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html:'Fecha:'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 120,
                                                                name: 'Fecha',
                                                                allowBlank: true,
                                                                disabled: true,
                                                                emptyText: '(dia/mes/año) ',
                                                                style: 'text-align:center;',
                                                                id: 'fecRESLABTrigliceridos'
                                                            },
                                                            {
                                                                html: ' - '
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'Resultado Trigliceridos',
                                                                emptyText: 'Rango 20 - 1000',
                                                                width: 110,
                                                                decimalPrecision: 0,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                id: 'strRESLABTrigliceridosRes'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {   
                                                                xtype: 'combo',
                                                                fieldLabel: 'Hb Glicosilada',
                                                                name: 'Hb Glicosilada',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strRESLABTraeHemoglobinaGlicosilada',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO"){
                                                                            Ext.getCmp('fecRESLABHemoglobinaGlicosilada').allowBlank = true;
                                                                            Ext.getCmp('strRESLABHemoglobinaGlicosiladaRes').allowBlank = true;
                                                                            Ext.getCmp('fecRESLABHemoglobinaGlicosilada').setValue(null);
                                                                            Ext.getCmp('strRESLABHemoglobinaGlicosiladaRes').setValue(null);
                                                                            Ext.getCmp('fecRESLABHemoglobinaGlicosilada').disable();
                                                                            Ext.getCmp('strRESLABHemoglobinaGlicosiladaRes').disable();
                                                                            Ext.getCmp('fecRESLABHemoglobinaGlicosilada').clearInvalid();
                                                                            Ext.getCmp('strRESLABHemoglobinaGlicosiladaRes').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('fecRESLABHemoglobinaGlicosilada').enable();
                                                                            Ext.getCmp('strRESLABHemoglobinaGlicosiladaRes').enable();
                                                                            Ext.getCmp('fecRESLABHemoglobinaGlicosilada').allowBlank = false;
                                                                            Ext.getCmp('strRESLABHemoglobinaGlicosiladaRes').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html:'Fecha:'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 120,
                                                                name: 'Fecha',
                                                                allowBlank: true,
                                                                disabled: true,
                                                                emptyText: '(dia/mes/año) ',
                                                                style: 'text-align:center;',
                                                                id: 'fecRESLABHemoglobinaGlicosilada'
                                                            },
                                                            {
                                                                html: ' - '
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'Resultado Hb Glicosilada',
                                                                emptyText: 'Rango 5 - 20',
                                                                width: 110,
                                                                decimalPrecision: 0,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                id: 'strRESLABHemoglobinaGlicosiladaRes'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {   
                                                                xtype: 'combo',
                                                                fieldLabel: 'Glicemia',
                                                                name: 'Glicemia',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strRESLABTraeGlicemia',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO"){
                                                                            Ext.getCmp('fecRESLABGlicemia').allowBlank = true;
                                                                            Ext.getCmp('strRESLABGlicemiaRes').allowBlank = true;
                                                                            Ext.getCmp('fecRESLABGlicemia').setValue(null);
                                                                            Ext.getCmp('strRESLABGlicemiaRes').setValue(null);
                                                                            Ext.getCmp('fecRESLABGlicemia').disable();
                                                                            Ext.getCmp('strRESLABGlicemiaRes').disable();
                                                                            Ext.getCmp('fecRESLABGlicemia').clearInvalid();
                                                                            Ext.getCmp('strRESLABGlicemiaRes').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('fecRESLABGlicemia').enable();
                                                                            Ext.getCmp('strRESLABGlicemiaRes').enable();
                                                                            Ext.getCmp('fecRESLABGlicemia').allowBlank = false;
                                                                            Ext.getCmp('strRESLABGlicemiaRes').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html:'Fecha:'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 120,
                                                                name: 'Fecha',
                                                                allowBlank: true,
                                                                disabled: true,
                                                                emptyText: '(dia/mes/año) ',
                                                                style: 'text-align:center;',
                                                                id: 'fecRESLABGlicemia'
                                                            },
                                                            {
                                                                html: ' - '
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'Resultado Glicemia',
                                                                emptyText: 'Rango 20 - 1000',
                                                                width: 110,
                                                                decimalPrecision: 0,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                id: 'strRESLABGlicemiaRes'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {   
                                                                xtype: 'combo',
                                                                fieldLabel: 'Micro Albuminuria',
                                                                name: 'Micro Albuminuria',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strRESLABTraeMicroAlbuminuria',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO"){
                                                                            Ext.getCmp('fecRESLABMicroAlbuminuria').allowBlank = true;
                                                                            Ext.getCmp('strRESLABMicroAlbuminuriaRes').allowBlank = true;
                                                                            Ext.getCmp('fecRESLABMicroAlbuminuria').setValue(null);
                                                                            Ext.getCmp('strRESLABMicroAlbuminuriaRes').setValue(null);
                                                                            Ext.getCmp('fecRESLABMicroAlbuminuria').disable();
                                                                            Ext.getCmp('strRESLABMicroAlbuminuriaRes').disable();
                                                                            Ext.getCmp('fecRESLABMicroAlbuminuria').clearInvalid();
                                                                            Ext.getCmp('strRESLABMicroAlbuminuriaRes').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('fecRESLABMicroAlbuminuria').enable();
                                                                            Ext.getCmp('strRESLABMicroAlbuminuriaRes').enable();
                                                                            Ext.getCmp('fecRESLABMicroAlbuminuria').allowBlank = false;
                                                                            Ext.getCmp('strRESLABMicroAlbuminuriaRes').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html:'Fecha:'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 120,
                                                                name: 'Fecha',
                                                                allowBlank: true,
                                                                disabled: true,
                                                                emptyText: '(dia/mes/año) ',
                                                                style: 'text-align:center;',
                                                                id: 'fecRESLABMicroAlbuminuria'
                                                            },
                                                            {
                                                                html: ' - '
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'Resultado Micro Albuminuria',
                                                                emptyText: 'Rango 0 - 700',
                                                                width: 110,
                                                                decimalPrecision: 0,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                id: 'strRESLABMicroAlbuminuriaRes'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {   
                                                                xtype: 'combo',
                                                                fieldLabel: 'Urea',
                                                                name: 'Urea',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strRESLABTraeUrea',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO"){
                                                                            Ext.getCmp('fecRESLABUrea').allowBlank = true;
                                                                            Ext.getCmp('strRESLABUreaRes').allowBlank = true;
                                                                            Ext.getCmp('fecRESLABUrea').setValue(null);
                                                                            Ext.getCmp('strRESLABUreaRes').setValue(null);
                                                                            Ext.getCmp('fecRESLABUrea').disable();
                                                                            Ext.getCmp('strRESLABUreaRes').disable();
                                                                            Ext.getCmp('fecRESLABUrea').clearInvalid();
                                                                            Ext.getCmp('strRESLABUreaRes').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('fecRESLABUrea').enable();
                                                                            Ext.getCmp('strRESLABUreaRes').enable();
                                                                            Ext.getCmp('fecRESLABUrea').allowBlank = false;
                                                                            Ext.getCmp('strRESLABUreaRes').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html:'Fecha:'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 120,
                                                                name: 'Fecha',
                                                                allowBlank: true,
                                                                disabled: true,
                                                                emptyText: '(dia/mes/año) ',
                                                                style: 'text-align:center;',
                                                                id: 'fecRESLABUrea'
                                                            },
                                                            {
                                                                html: ' - '
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'Resultado Urea',
                                                                emptyText: 'Resultado',
                                                                width: 110,
                                                                decimalPrecision: 0,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                id: 'strRESLABUreaRes'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {   
                                                                xtype: 'combo',
                                                                fieldLabel: 'Creatinina',
                                                                name: 'Creatinina',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strRESLABTraeCreatinina',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO"){
                                                                            Ext.getCmp('fecRESLABCreatinina').allowBlank = true;
                                                                            Ext.getCmp('strRESLABCreatininaRes').allowBlank = true;
                                                                            Ext.getCmp('fecRESLABCreatinina').setValue(null);
                                                                            Ext.getCmp('strRESLABCreatininaRes').setValue(null);
                                                                            Ext.getCmp('fecRESLABCreatinina').disable();
                                                                            Ext.getCmp('strRESLABCreatininaRes').disable();
                                                                            Ext.getCmp('fecRESLABCreatinina').clearInvalid();
                                                                            Ext.getCmp('strRESLABCreatininaRes').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('fecRESLABCreatinina').enable();
                                                                            Ext.getCmp('strRESLABCreatininaRes').enable();
                                                                            Ext.getCmp('fecRESLABCreatinina').allowBlank = false;
                                                                            Ext.getCmp('strRESLABCreatininaRes').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html:'Fecha:'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 120,
                                                                name: 'Fecha',
                                                                allowBlank: true,
                                                                disabled: true,
                                                                emptyText: '(dia/mes/año) ',
                                                                style: 'text-align:center;',
                                                                id: 'fecRESLABCreatinina'
                                                            },
                                                            {
                                                                html: ' - '
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'Resultado Creatinina',
                                                                emptyText: 'Rango 0,2 - 25',
                                                                width: 110,
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                id: 'strRESLABCreatininaRes'
                                                            }
                                                        ]
                                                    },  
                                                        {
                                                            xtype: 'numberfield',
                                                            name: 'T.F.G',
                                                            fieldLabel: 'T.F.G',
                                                            emptyText: 'Resultado',
                                                            width: 110,
                                                            decimalPrecision: 2,
                                                            allowBlank: true,
                                                            id: 'strRESLABTFGRes'
                                                        }
                                                    ]
                                                },
                                            {
                                                xtype: 'fieldset',
                                                title: 'DATOS DEL PROGRAMA Y CLASIFICACION DEL RIESGO',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'datefield',
                                                                width: 120,
                                                                fieldLabel: 'Fecha Ingreso',
                                                                name: 'Fecha Ingreso',
                                                                allowBlank: false,
                                                                emptyText: '(dia/mes/año) ',
                                                                style: 'text-align:center;',
                                                                id: 'fecDATPROGIngreso'
                                                            },
                                                            {
                                                                html: '   Via de Captacion:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Via de Captacion',
                                                                width: 250,
                                                                allowBlank: false,
                                                                store: stViaCaptacion,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strDATPROGViaCaptacion'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {   
                                                                xtype: 'combo',
                                                                fieldLabel: 'Dx HTA',
                                                                name: 'Dx HTA',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strDATPROGDxHTA',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO"){
                                                                            Ext.getCmp('strDATPROGTipoDxHTA').allowBlank = true;
                                                                            Ext.getCmp('intDATPROGDxHTAMes').allowBlank = true;
                                                                            Ext.getCmp('intDATPROGDxHTAAno').allowBlank = true;
                                                                            Ext.getCmp('strDATPROGNivelRiesgoHTA').allowBlank = true;
                                                                            Ext.getCmp('strDATPROGTipoDxHTA').setValue(null);
                                                                            Ext.getCmp('intDATPROGDxHTAMes').setValue(null);
                                                                            Ext.getCmp('intDATPROGDxHTAAno').setValue(null);
                                                                            Ext.getCmp('strDATPROGNivelRiesgoHTA').setValue(null);
                                                                            Ext.getCmp('strDATPROGTipoDxHTA').disable();
                                                                            Ext.getCmp('intDATPROGDxHTAMes').disable();
                                                                            Ext.getCmp('intDATPROGDxHTAAno').disable();
                                                                            Ext.getCmp('strDATPROGNivelRiesgoHTA').disable();
                                                                            Ext.getCmp('strDATPROGTipoDxHTA').clearInvalid();
                                                                            Ext.getCmp('intDATPROGDxHTAMes').clearInvalid();
                                                                            Ext.getCmp('intDATPROGDxHTAAno').clearInvalid();
                                                                            Ext.getCmp('strDATPROGNivelRiesgoHTA').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strDATPROGTipoDxHTA').enable();
                                                                            Ext.getCmp('intDATPROGDxHTAMes').enable();
                                                                            Ext.getCmp('intDATPROGDxHTAAno').enable();
                                                                            Ext.getCmp('strDATPROGNivelRiesgoHTA').enable();
                                                                            Ext.getCmp('strDATPROGTipoDxHTA').allowBlank = false;
                                                                            Ext.getCmp('intDATPROGDxHTAMes').allowBlank = false;
                                                                            Ext.getCmp('intDATPROGDxHTAAno').allowBlank = false;
                                                                            Ext.getCmp('strDATPROGNivelRiesgoHTA').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html:'Tipo de Dx:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Tipo de Dx',
                                                                width: 90,
                                                                allowBlank: false,
                                                                store: stDatProgTipoDx,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strDATPROGTipoDxHTA'
                                                            },
                                                            {
                                                                html:'Nivel de Riesgo:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Nivel de Riesgo',
                                                                width: 90,
                                                                allowBlank: false,
                                                                store: stDatProgNivelRiesgo,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strDATPROGNivelRiesgoHTA'
                                                            },
                                                            {
                                                                html:'Fecha Dx:'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'Mes',
                                                                emptyText: 'Mes', 
                                                                width: 50,
                                                                minValue: 1,
                                                                maxValue: 12,
                                                                decimalPrecision: 0,
                                                                allowBlank: false,
                                                                id: 'intDATPROGDxHTAMes'
                                                            },
                                                            {
                                                                html:'/'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'Año',
                                                                emptyText: 'Año', 
                                                                width: 70,
                                                                minValue: 1900,
                                                                maxValue: 2199,
                                                                decimalPrecision: 0,
                                                                allowBlank: false,
                                                                id: 'intDATPROGDxHTAAno'
                                                            },
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {   
                                                                xtype: 'combo',
                                                                fieldLabel: 'Dx DM',
                                                                name: 'Dx DM',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strDATPROGDxDM',
                                                               listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO"){
                                                                            Ext.getCmp('strDATPROGTipoDxDM').allowBlank = true;
                                                                            Ext.getCmp('intDATPROGDxDMMes').allowBlank = true;
                                                                            Ext.getCmp('intDATPROGDxDMAno').allowBlank = true;
                                                                            Ext.getCmp('strDATPROGNivelRiesgoDM').allowBlank = true;
                                                                            Ext.getCmp('strDATPROGTipoDM').allowBlank = true;
                                                                            Ext.getCmp('strDATPROGTipoDxDM').setValue(null);
                                                                            Ext.getCmp('intDATPROGDxDMMes').setValue(null);
                                                                            Ext.getCmp('intDATPROGDxDMAno').setValue(null);
                                                                            Ext.getCmp('strDATPROGNivelRiesgoDM').setValue(null);
                                                                            Ext.getCmp('strDATPROGTipoDM').setValue(null);
                                                                            Ext.getCmp('strDATPROGTipoDxDM').disable();
                                                                            Ext.getCmp('intDATPROGDxDMMes').disable();
                                                                            Ext.getCmp('intDATPROGDxDMAno').disable();
                                                                            Ext.getCmp('strDATPROGNivelRiesgoDM').disable();
                                                                            Ext.getCmp('strDATPROGTipoDM').disable();
                                                                            Ext.getCmp('strDATPROGTipoDxDM').clearInvalid();
                                                                            Ext.getCmp('intDATPROGDxDMMes').clearInvalid();
                                                                            Ext.getCmp('intDATPROGDxDMAno').clearInvalid();
                                                                            Ext.getCmp('strDATPROGNivelRiesgoDM').clearInvalid();
                                                                            Ext.getCmp('strDATPROGTipoDM').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strDATPROGTipoDxDM').enable();
                                                                            Ext.getCmp('intDATPROGDxDMMes').enable();
                                                                            Ext.getCmp('intDATPROGDxDMAno').enable();
                                                                            Ext.getCmp('strDATPROGNivelRiesgoDM').enable();
                                                                            Ext.getCmp('strDATPROGTipoDM').enable();
                                                                            Ext.getCmp('strDATPROGTipoDxDM').allowBlank = false;
                                                                            Ext.getCmp('intDATPROGDxDMMes').allowBlank = false;
                                                                            Ext.getCmp('intDATPROGDxDMAno').allowBlank = false;
                                                                            Ext.getCmp('strDATPROGNivelRiesgoDM').allowBlank = false;
                                                                            Ext.getCmp('strDATPROGTipoDM').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html:'Tipo de Dx:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Tipo de Dx',
                                                                width: 90,
                                                                allowBlank: false,
                                                                store: stDatProgTipoDx,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strDATPROGTipoDxDM'
                                                            },
                                                            {
                                                                html:'Nivel de Riesgo:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Nivel de Riesgo',
                                                                width: 90,
                                                                allowBlank: false,
                                                                store: stDatProgNivelRiesgo,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strDATPROGNivelRiesgoDM'
                                                            },
                                                            {
                                                                html:'Fecha Dx:'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'Mes',
                                                                emptyText: 'Mes', 
                                                                width: 50,
                                                                minValue: 1,
                                                                maxValue: 12,
                                                                decimalPrecision: 0,
                                                                allowBlank: false,
                                                                id: 'intDATPROGDxDMMes'
                                                            },
                                                            {
                                                                html:'/'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'Año',
                                                                emptyText: 'Año', 
                                                                width: 70,
                                                                minValue: 1900,
                                                                maxValue: 2199,
                                                                decimalPrecision: 0,
                                                                allowBlank: false,
                                                                id: 'intDATPROGDxDMAno'
                                                            },
                                                            {
                                                                html:'Tipo DM:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Tipo de DM',
                                                                width: 90,
                                                                allowBlank: false,
                                                                store: stDatProgTipoDM,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strDATPROGTipoDM'
                                                            },
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {   
                                                                xtype: 'combo',
                                                                fieldLabel: 'Dx Nefroproteccion',
                                                                name: 'Dx Dx Nefroproteccion',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strDATPROGDxNefroProteccion',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO"){
                                                                            Ext.getCmp('strDATPROGTipoDxNefroProteccion').allowBlank = true;
                                                                            Ext.getCmp('intDATPROGDxNefroProteccionMes').allowBlank = true;
                                                                            Ext.getCmp('intDATPROGDxNefroProteccionAno').allowBlank = true;
                                                                            Ext.getCmp('strDATPROGNivelRiesgoNefroProteccion').allowBlank = true;
                                                                            Ext.getCmp('strDATPROGEstadioNefroProteccion').allowBlank = true;
                                                                            Ext.getCmp('strDATPROGTipoDxNefroProteccion').setValue(null);
                                                                            Ext.getCmp('intDATPROGDxNefroProteccionMes').setValue(null);
                                                                            Ext.getCmp('intDATPROGDxNefroProteccionAno').setValue(null);
                                                                            Ext.getCmp('strDATPROGNivelRiesgoNefroProteccion').setValue(null);
                                                                            Ext.getCmp('strDATPROGEstadioNefroProteccion').setValue(null);
                                                                            Ext.getCmp('strDATPROGTipoDxNefroProteccion').disable();
                                                                            Ext.getCmp('intDATPROGDxNefroProteccionMes').disable();
                                                                            Ext.getCmp('intDATPROGDxNefroProteccionAno').disable();
                                                                            Ext.getCmp('strDATPROGNivelRiesgoNefroProteccion').disable();
                                                                            Ext.getCmp('strDATPROGEstadioNefroProteccion').disable();
                                                                            Ext.getCmp('strDATPROGTipoDxNefroProteccion').clearInvalid();
                                                                            Ext.getCmp('intDATPROGDxNefroProteccionMes').clearInvalid();
                                                                            Ext.getCmp('intDATPROGDxNefroProteccionAno').clearInvalid();
                                                                            Ext.getCmp('strDATPROGNivelRiesgoNefroProteccion').clearInvalid();
                                                                            Ext.getCmp('strDATPROGEstadioNefroProteccion').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strDATPROGTipoDxNefroProteccion').enable();
                                                                            Ext.getCmp('intDATPROGDxNefroProteccionMes').enable();
                                                                            Ext.getCmp('intDATPROGDxNefroProteccionAno').enable();
                                                                            Ext.getCmp('strDATPROGNivelRiesgoNefroProteccion').enable();
                                                                            Ext.getCmp('strDATPROGEstadioNefroProteccion').enable();
                                                                            Ext.getCmp('strDATPROGTipoDxNefroProteccion').allowBlank = false;
                                                                            Ext.getCmp('intDATPROGDxNefroProteccionMes').allowBlank = false;
                                                                            Ext.getCmp('intDATPROGDxNefroProteccionAno').allowBlank = false;
                                                                            Ext.getCmp('strDATPROGNivelRiesgoNefroProteccion').allowBlank = false;
                                                                            Ext.getCmp('strDATPROGEstadioNefroProteccion').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html:'Tipo de Dx:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Tipo de Dx',
                                                                width: 90,
                                                                allowBlank: false,
                                                                store: stDatProgTipoDx,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strDATPROGTipoDxNefroProteccion'
                                                            },
                                                             {
                                                                html:'Nivel de Riesgo:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Nivel de Riesgo',
                                                                width: 90,
                                                                allowBlank: false,
                                                                store: stDatProgNivelRiesgo,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strDATPROGNivelRiesgoNefroProteccion'
                                                            },
                                                            {
                                                                html:'Fecha Dx:'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'Mes',
                                                                emptyText: 'Mes', 
                                                                width: 50,
                                                                minValue: 1,
                                                                maxValue: 12,
                                                                decimalPrecision: 0,
                                                                allowBlank: false,
                                                                id: 'intDATPROGDxNefroProteccionMes'
                                                            },
                                                            {
                                                                html:'/'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'Año',
                                                                emptyText: 'Año', 
                                                                width: 70,
                                                                minValue: 1900,
                                                                maxValue: 2199,
                                                                decimalPrecision: 0,
                                                                allowBlank: false,
                                                                id: 'intDATPROGDxNefroProteccionAno'
                                                            },
                                                            {
                                                                html:'Estadio:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Estadio',
                                                                width: 90,
                                                                allowBlank: false,
                                                                store: stDatProgEstadioNefroProteccion,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strDATPROGEstadioNefroProteccion'
                                                            },
                                                        ]
                                                    },
                                                  {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'METAS TERAPEUTICAS',
                                                        name: 'METAS TERAPEUTICAS',
                                                        height: 100,            
                                                        allowBlank: false,
                                                        id: 'memMetasTerapeuticas'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: 'Programa Asignado',
                                                        width: 90,
                                                        allowBlank: false,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strDATPROGPrograma'
                                                    },
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'PROXIMA CITA DE CONTROL Y SEGUIMIENTO',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'datefield',
                                                                width: 120,
                                                                fieldLabel: 'Fecha Probable proxima Cita',
                                                                name: 'Fecha Ingreso',
                                                                allowBlank: false,
                                                                emptyText: '(dia/mes/año) ',
                                                                style: 'text-align:center;',
                                                                id: 'fecPROXCITAFecha'
                                                            },
                                                            {
                                                                html: 'Profesional que Atiende'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Profesional que Atiende',
                                                                width: 250,
                                                                allowBlank: false,
                                                                store: stProfesionalAtiende,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strPROXCITAProfesionalAtiende'
                                                            }
                                                        ]
                                                    }
                                                ]
                                                    
                                            },

                                            //Sigue Formulario
                                            {
                                                xtype: 'fieldset',
                                                title: 'CONDUCTA',
                                                layout: 'table',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'CONDUCTA',
                                                        name: 'CONDUCTA',
                                                        height: 100,            
                                                        allowBlank: false,
                                                        id: 'memConducta'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'INCAPACIDAD',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        fieldLabel: 'Dias',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 50,
                                                                name: 'INCAPACIDAD DIAS',
                                                                minValue: 0,
                                                                allowBlank: true,
                                                                style: 'text-align:center;',
                                                                id: 'intDiasIncapacidad',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        //new Date(año,mes,dia) 01/05/2010
                                                                        if(Ext.getCmp('fecDesdeIncapacidad').getValue() == null || Ext.getCmp('fecDesdeIncapacidad').getValue() == ""){
                                                                            Ext.getCmp('fecDesdeIncapacidad').setValue(new Date().format('d/m/Y'))
                                                                        }
                                                                        var xFecha = Ext.getCmp('fecDesdeIncapacidad').getValue().format('d/m/Y')
                                                                        var xMes = xFecha.substr(3,2);
                                                                        var NewFecha = new Date(xFecha.substr(6,10),(xMes-1),xFecha.substr(0,2));
                                                                        if(pNew > 0)
                                                                            DiasIncapacidad = pNew - 1;
                                                                        else
                                                                            DiasIncapacidad = pNew;
                                                                        NewFecha.setDate(NewFecha.getDate()+DiasIncapacidad);
                                                                        Ext.getCmp('fecHastaIncapacidad').setValue(NewFecha.format('d/m/Y'));
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysIncDsd',
                                                                value: 'Desde:'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 120,
                                                                name: 'INCAPACIDAD DESDE',
                                                                allowBlank: true,
                                                                disabledDates: '',
                                                                emptyText: '(dia/mes/año) ',
                                                                style: 'text-align:center;',
                                                                id: 'fecDesdeIncapacidad',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        Ext.getCmp('fecHastaIncapacidad').setValue(null);
                                                                        Ext.getCmp('fecHastaIncapacidad').setMinValue(pNew.format("d/m/Y"));
                                                                        Ext.getCmp('fecHastaIncapacidad').clearInvalid();
                                                                        var xFecha = pNew.format('d/m/Y')
                                                                        var xMes = xFecha.substr(3,2);
                                                                        var NewFecha = new Date(xFecha.substr(6,10),(xMes-1),xFecha.substr(0,2));
                                                                        if(Ext.getCmp('intDiasIncapacidad').getValue() > 0){
                                                                            DiasIncapacidad = Ext.getCmp('intDiasIncapacidad').getValue() - 1;
                                                                        }else{
                                                                            DiasIncapacidad = Ext.getCmp('intDiasIncapacidad').getValue();
                                                                        }
                                                                        NewFecha.setDate(NewFecha.getDate()+DiasIncapacidad);
                                                                        Ext.getCmp('fecHastaIncapacidad').setValue(NewFecha.format('d/m/Y'));
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysIncHst',
                                                                value: 'Hasta:'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 120,
                                                                name: 'INCAPACIDAD HASTA',
                                                                allowBlank: true,
                                                                disabledDates: '',
                                                                emptyText: '(dia/mes/año) ',
                                                                style: 'text-align:center;',
                                                                id: 'fecHastaIncapacidad'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        fieldLabel: 'Observaciones',
                                                        items: [
                                                            {
                                                                xtype: 'textarea',
                                                                anchor: '100%',
                                                                width: 615,
                                                                name: 'INCAPACIDAD OBSERVACIONES',
                                                                height: 50,
                                                                allowBlank: true,
                                                                id: 'memIncapacidadObserva'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnImprimir',
                                                                text: 'Imprimir Incapacidad',
                                                                tooltip: 'Imprimir Incapacidad',
                                                                id: 'btnPrintIncapacidadHC',
                                                                listeners:{
                                                                    click : function(){
                                                                        if (Ext.getCmp('sysYaGuardoHC').getValue() == 1)
                                                                            window.open ("../../controlador/asistencial/printincapacidad0.php?pEmpresa=" + ID_EMPRESA + "&pIPS=" + ID_IPS + "&pPaciente=" + Ext.getCmp('sysIdPacienteHC').getValue() + "&pCAS=" + Ext.getCmp('sysCASHC').getValue() + "&pConsecutivo=" + Ext.getCmp('sysConsecutivoDetalleHC').getValue(),"Incapacidad");
                                                                        else{
                                                                            Ext.Msg.show({
                                                                                title: 'eOfiClinic',
                                                                                msg: 'Usted No ha Guardado la Evolución',
                                                                                buttons: Ext.Msg.OK,
                                                                                icon: Ext.Msg.ERROR
                                                                            });
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'RIPS',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                id: 'fsRips',
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: false,
                                                                fieldLabel: 'Diagnostico Principal',
                                                                id: 'sysDiagPpalHC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request({
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                        Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagPpalHCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Principal',
                                                                id: 'btnSearchDiagPpalHC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagPpalHC','sysDiagPpalHCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.1',
                                                                id: 'sysDiagRel1HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel1HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado1',
                                                                id: 'btnSearchDiagRel1HC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel1HC','sysDiagRel1HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.2',
                                                                id: 'sysDiagRel2HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel2HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado2',
                                                                id: 'btnSearchDiagRel2HC1',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel2HC','sysDiagRel2HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.3',
                                                                id: 'sysDiagRel3HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel3HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado3',
                                                                id: 'btnSearchDiagRel3HC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel3HC','sysDiagRel3HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Tipo de Diagnostico',
                                                        width:750,
                                                        name: 'Tipo de Diagnostico',
                                                        allowBlank: false,
                                                        store: 'StoreTipoDiagnostico',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        id: 'sysTipoDiagosticoHC'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Finalidad Consulta',
                                                        width:750,
                                                        name: 'Finalidad Consulta',
                                                        allowBlank: false,
                                                        store: 'StoreFinalidadConsulta',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 10,
                                                        id: 'sysFinalidadConsultaHC'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Causa Externa',
                                                        width:750,
                                                        name: 'Causa Externa',
                                                        allowBlank: false,
                                                        store: 'StoreCausaExterna',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 13,
                                                        id: 'sysCausaExternaHC'
                                                    }                            
                                                ]
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Medicamentos',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaMedicamentos',
                                items: [
                                    xSolMX
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Servicios',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaServicios',
                                items: [
                                    xSolEXA
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Remisiones',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaRemisiones',
                                items: [
                                    xSolREM
                                ]
                            }
                            /*,
                            {
                                xtype: 'panel',
                                title: 'Solicitud CTC',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaCTC',
                                items: [
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Consentimientos Informados',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaConsentimientos',
                                items: [
                                ]
                            },*/
                        ]
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btnSalirEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 1) 
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Usted No ha Guardado la Evolución del Paciente y Se Perdera la Información, Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                },
                tbar:{
                    items: [
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Ver Historia Clínica',
                            iconCls: 'btnVerHC',
                            id: 'btnVerHC',
                            listeners:{
                                click : function(){
                                    var cmpResumenHC = new winFrmVerHistorialHC({
                                        renderTo: Ext.getBody()
                                    });
                                    Ext.getCmp('winViewEvolucionHC').title = "PACIENTE: " + Ext.getCmp('sysPacienteHC').getValue();
                                    Ext.getCmp('gridHistorialEvoluciones').store.load({
                                        params: {
                                            pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                                            pPaciente: Ext.getCmp('sysIdPacienteHC').getValue()
                                        }
                                    });
                                    cmpResumenHC.show();
                                }
                            }
                        },
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar Evolución',
                            iconCls: 'btnGuardar',
                            id: 'btnGuardarEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 0) 
                                    {
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Guardar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnGuardarRegistrosMedicinaGeneral();
                                                }
                                            }
                                        });
                                    }else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Modificar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnModificarRegistrosMedicinaGeneral();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                }
            }
        ];
        winHCCronicos001Ui.superclass.initComponent.call(this);
    }
});

function fnGuardarRegistrosMedicinaGeneral(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc.php',
            params:{
                task: 'guardar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pidPlantillaHC : Ext.getCmp('sysIdCodPlantillaHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1); 
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function fnModificarRegistrosMedicinaGeneral(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc.php',
            params:{
                task: 'modificar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}
