/*
* @category    Formulario Modelo Evolucion Historia Clinica Prioritaria
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winHCProcedimientos4505Ui = Ext.extend(Ext.Window, {
    title: 'eOfiClinic ©  .:: Plantilla HC Procedimientos 4505 ::.',
    width: 990,
    height: 636,
    closable: false,
    resizable: false,
    draggable: false,
    modal: true,
    id: 'winHC',
    initComponent: function() {
        
   
        //
        
        var dataConsultas4505 = [
            [1,'Citologia'],
            [2,'Colposcopia'],
            [3,'Biopsia Cervical'],
            [4,'Mamografia'],
            [5,'Biopsia de Seno por BACAF']
        ];
        var stConsultas4505 = new Ext.data.ArrayStore({
            fields: [
                {name: 'Codigo'},
                {name: 'Descripcion'}
            ]
        });
        stConsultas4505.loadData(dataConsultas4505);

        var searchStoreREPSS = new Ext.data.Store({
            proxy: new Ext.data.ScriptTagProxy({
                url: '../../controlador/asistencial/controlador_oficlinic_repss.php'
            }),
            reader: new Ext.data.JsonReader({
                root: 'data',
                totalProperty: 'totalCount',
                id: 'id'
            }, [
                {name: 'Codigo'},
                {name: 'Descripcion'}
            ])
        });



        this.items = [
            {
                xtype: 'panel',
                frame: true,
                anchor: '100%',
                id: 'panelHC',
                border: false,
                height: 570,
                autoScroll: true,
                layout: 'form',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysIdCodPlantillaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        value: 1,
                        id: 'sysUsaGridSalida'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        value: 0,
                        id: 'sysYaGuardoHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysPlantillaHC',
                        name: 'PLANTILLA'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptMx'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptExa'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptRem'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Actividad',
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        id: 'sysActividadHC',
                        name: 'PLANTILLA'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Empresa',
                        id: 'sysEmpresaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'IPS',
                        id: 'sysIPSHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Usuario',
                        id: 'sysUsuarioHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Profesional',
                        id: 'sysProfesionalHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Paciente',
                        id: 'sysIdPacienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Apertura',
                        id: 'sysAperturaHC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Cliente',
                        id: 'sysClienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdClienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdPlanHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdSubPlanHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdContratoHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Genero',
                        id: 'sysGeneroPacHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Edad',
                        id: 'sysEdadPacHC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Profesional',
                        id: 'sysProfesionalAgendaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'ConsecutivoDetalle',
                        id: 'sysConsecutivoDetalleHC'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'CAS',
                                id: 'sysCASHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysFechaHC',
                                value: 'Fecha: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysFechaHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysHoraHC',
                                value: 'Hora: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysHoraHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysLegalizacionHC',
                                value: 'Legalización: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysLegalizaHC'
                            }
                        ]
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Paciente',
                        value: 'CC 792558261  - JORGE GALEANO RUIZ - (Masculino) FechaNac: 1973-01-30, Edad 38 Años',
                        id: 'sysPacienteHC'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                width: 100,
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'Genero',
                                id: 'sysGeneroHC'
                            },
                            {
                                html: 'Fecha Nac:'
                            },
                            {
                                xtype: 'textfield',
                                width: 100,
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysFechaNac'
                            },
                            {
                                html: 'Edad:'
                            },
                            {
                                xtype: 'textfield',
                                width: 350,
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysEdadHC'
                            }
                        ]
                    },
                    /*{
                        xtype: 'button',
                        iconCls: 'btnImprimir',
                        text: 'Cargar Antecedentes',
                        tooltip: 'Cargar Antecedentes',
                        listeners:{
                            click : function(){
                                Ext.Ajax.request({
                                    url: '../../controlador/asistencial/evolucionhc.php',
                                    waitMsg: 'Cargando Información...',
                                    params:{
                                        pCAS: myCAS,
                                        pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                                        task: 'ImportarAntecedentesPersonalesOfiClinic001'
                                    },
                                    success: function(result, request)
                                    {
                                        var jsonAntPersonales = Ext.util.JSON.decode(result.responseText);
                                        UtilCargarAntecedentesOfiClinic001(jsonAntPersonales.data);
                                    },
                                    scope:this
                                });
                            }
                        }
                    },*/
                    {
                        html: '<hr>',
                        style: 'background:transparent;',
                        border: false
                    },
                    {
                        xtype: 'tabpanel',
                        anchor: '99%',
                        autoHeight: true,
                        border: false,
                        enableTabScroll: true,
                        ref: 'fTabPanel',
                        id: 'fTabPanel',
                        activeTab: 0,
                        items: [
                            {
                                xtype: 'panel',
                                title: 'Evolución',
                                autoHeight: true,
                                autoScroll: true,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaEvolucion',
                                layout: 'form',
                                items: [
                                    {
                                        xtype: 'form',
                                        frame: true,
                                        anchor: '100%',
                                        id: 'frmHC',
                                        padding: 10,
                                        border: false,
                                        autoScroll: true,
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'datefield',
                                                width: 120,
                                                name: 'Fecha Servicio',
                                                allowBlank: false,
                                                hidden: true,
                                                emptyText: '(dia/mes/año) ',
                                                style: 'text-align:center;',
                                                id: 'fecServicio'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Citologia',
                                                allowBlank: true,
                                                hidden: true,
                                                id: 'sysCitologia4505'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Prenatal Primera Vez',
                                                allowBlank: true,
                                                hidden: true,
                                                id: 'sysColposcopia4505'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Biopsia Cervical',
                                                allowBlank: true,
                                                hidden: true,
                                                id: 'sysBiopsiaCervical4505'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Mamografia',
                                                allowBlank: true,
                                                hidden: true,
                                                id: 'sysMamografia4505'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Biopsia Seno',
                                                allowBlank: true,
                                                hidden: true,
                                                id: 'sysBiopsiaSeno4505'
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'IDENTIFICACION DEL RIESGO',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                labelSeparator: '',
                                                autoHeight: true,
                                                id: 'fsIdentificacionRiesgo',
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 86,
                                                                allowBlank: false,
                                                                fieldLabel: 'Ocupacion',
                                                                id: 'strOcupacionHC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null){
                                                                                Ext.Ajax.request({
                                                                                    url: '../../controlador/ciuo/controlador_ciuo.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('strOcupacionHC').setValue(null);
                                                                                            Ext.getCmp('sysOcupacionHCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('strOcupacionHC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysOcupacionHCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('strOcupacionHC').setValue(null);
                                                                                        Ext.getCmp('sysOcupacionHCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('strOcupacionHC').setValue(null);
                                                                                Ext.getCmp('sysOcupacionHCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    },
                                                                    blur: function(t){
                                                                        if(Ext.getCmp('sysOcupacionHCNom').getValue()==null || Ext.getCmp('sysOcupacionHCNom').getValue()== "")
                                                                        {
                                                                            if (Ext.getCmp('strOcupacionHC').getValue() != "" && Ext.getCmp('strOcupacionHC').getValue() != null){
                                                                                Ext.Ajax.request({
                                                                                    url: '../../controlador/ciuo/controlador_ciuo.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: Ext.getCmp('strOcupacionHC').getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('strOcupacionHC').setValue(null);
                                                                                            Ext.getCmp('sysOcupacionHCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('strOcupacionHC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysOcupacionHCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('strOcupacionHC').setValue(null);
                                                                                        Ext.getCmp('sysOcupacionHCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('strOcupacionHC').setValue(null);
                                                                                Ext.getCmp('sysOcupacionHCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 615,
                                                                height: 22,
                                                                id: 'sysOcupacionHCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Ocupacion',
                                                                id: 'btnSearchOcupacionHC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarciuo('strOcupacionHC','sysOcupacionHCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Etnia',
                                                                name: 'Etnia',
                                                                width: 330,
                                                                allowBlank: false,
                                                                store: 'StoreEtnia4505',
                                                                valueField: 'Codigo',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'intEtniaHC'
                                                            },
                                                            {
                                                                html: 'Escolaridad:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Escolaridad',
                                                                width: 330,
                                                                allowBlank: false,
                                                                store: 'StoreEscolaridad4505',
                                                                valueField: 'Codigo',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'intEscolaridadHC'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        html: '<br>'
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        layout: 'table',
                                                        anchor: '100%',
                                                        padding: 0,
                                                        layoutConfig: {
                                                            columns: 2
                                                        },
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                width: 400,
                                                                height: 270,
                                                                labelSeparator: '',
                                                                labelStyle: 'color:blue;',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Paciente en Gestacion?',
                                                                        fieldLabel: 'Paciente en Gestacion?<br>&nbsp;',
                                                                        width: 250,
                                                                        allowBlank: false,
                                                                        store: stGestacion,
                                                                        valueField: 'Codigo',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 21,
                                                                        id: 'intIdentificacionRiesgoGestacion',
                                                                        listeners:{
                                                                            change : function( t, newValue, oldValue){
                                                                                if(newValue == 21 || newValue == 1){
                                                                                    Ext.getCmp('intIdentificacionRiesgoSifilisGestacional').setValue(21);
                                                                                    Ext.getCmp('intIdentificacionRiesgoSifilisGestacional').enable();
                                                                                    Ext.getCmp('intIdentificacionRiesgoHipertencionGestacional').setValue(21);
                                                                                    Ext.getCmp('intIdentificacionRiesgoHipertencionGestacional').enable();
                                                                                }else{
                                                                                    Ext.getCmp('intIdentificacionRiesgoSifilisGestacional').setValue(0);
                                                                                    Ext.getCmp('intIdentificacionRiesgoHipertencionGestacional').setValue(0);
                                                                                    Ext.getCmp('intIdentificacionRiesgoHipertencionGestacional').disable();
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Paciente con Sifilis Gestacional o Congenita?',
                                                                        fieldLabel: 'Paciente con Sifilis Gestacional o Congenita?',
                                                                        width: 250,
                                                                        allowBlank: false,
                                                                        store: stSifilisGestacional,
                                                                        valueField: 'Codigo',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 21,
                                                                        id: 'intIdentificacionRiesgoSifilisGestacional'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Paciente con Hipertension Gestacional?',
                                                                        fieldLabel: 'Paciente con Hipertension Gestacional?',
                                                                        width: 250,
                                                                        allowBlank: false,
                                                                        store: stHipertencionGestacional,
                                                                        valueField: 'Codigo',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 21,
                                                                        id: 'intIdentificacionRiesgoHipertencionGestacional'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Paciente con Hipotiroidismo Congenito?',
                                                                        fieldLabel: 'Paciente con Hipotiroidismo Congenito?',
                                                                        width: 250,
                                                                        allowBlank: false,
                                                                        store: stHipotiroidismoCongenito,
                                                                        valueField: 'Codigo',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 21,
                                                                        id: 'intIdentificacionRiesgoHipotiroidismoCongenito'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                width: 400,
                                                                height: 270,
                                                                labelSeparator: '',
                                                                labelStyle: 'color:blue;',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Paciente Tuberculosis Multidrogoresistente?',
                                                                        fieldLabel: 'Paciente Tuberculosis Multidrogoresistente?',
                                                                        width: 250,
                                                                        allowBlank: false,
                                                                        store: stTuberculosisMultidrogoresistente,
                                                                        valueField: 'Codigo',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 21,
                                                                        id: 'intIdentificacionRiesgoTuberculosisMultidrogoresistente'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Paciente con Lepra?',
                                                                        fieldLabel: 'Paciente con Lepra<br>&nbsp;',
                                                                        width: 250,
                                                                        allowBlank: false,
                                                                        store: stLepra,
                                                                        valueField: 'Codigo',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 21,
                                                                        id: 'intIdentificacionRiesgoLepra'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Paciente Victima Maltrato',
                                                                        fieldLabel: 'Paciente Victima Maltrato<br>&nbsp;',
                                                                        width: 250,
                                                                        allowBlank: false,
                                                                        store: stVictimaMaltrato,
                                                                        valueField: 'Codigo',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 21,
                                                                        id: 'intIdentificacionRiesgoVictimaMaltrato'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Paciente Victima Violencia Sexual',
                                                                        fieldLabel: 'Paciente Victima Violencia Sexual<br>&nbsp;',
                                                                        width: 250,
                                                                        allowBlank: false,
                                                                        store: stViolenciaSexual,
                                                                        valueField: 'Codigo',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 21,
                                                                        id: 'intIdentificacionRiesgoViolenciaSexual'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Paciente con Fluorosis Dental',
                                                                        fieldLabel: 'Paciente con Fluorosis Dental<br>&nbsp;',
                                                                        width: 250,
                                                                        allowBlank: false,
                                                                        store: stFluorosisDental,
                                                                        valueField: 'Codigo',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 21,
                                                                        id: 'intIdentificacionRiesgoFluorosisDental'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'PROGRAMA TAMIZACION CANCER CUELLO UTERINO',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                id: 'fsProgramaCancerCuelloUterino',
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        name: 'Tamizaje Cancer Cuello Uterino',
                                                        fieldLabel: 'Tamizaje Cancer Cuello Uterino',
                                                        width: 350,
                                                        allowBlank: false,
                                                        store: stTamizajeCancerCuelloUterino,
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'intTamizajeCancerCuelloUterino'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Registrar Citologia?',
                                                        name: 'Registrar Citologia?',
                                                        width: 50,
                                                        allowBlank: true,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'sysRegistroCitologia',
                                                        listeners:{
                                                            change : function( t, newValue, oldValue){
                                                                
                                                                if(Ext.getCmp('sysRegistroCitologia').getValue()=="SI"){
                                                                    Ext.getCmp('sysCitologia4505').setValue(Ext.getCmp('fecServicio').getValue().format('Y-m-d'));
                                                                    Ext.getCmp('intResultadoCitologia').enable();
                                                                    Ext.getCmp('intCalidadMuestraCitologia').enable();
                                                                    Ext.getCmp('sysRegistroIPSTomaCitologia').enable();
                                                                    Ext.getCmp('intCodIPSTomaCitologia').enable();
                                                                }else{
                                                                    Ext.getCmp('intResultadoCitologia').disable();
                                                                    Ext.getCmp('intCalidadMuestraCitologia').disable();
                                                                    Ext.getCmp('sysRegistroIPSTomaCitologia').disable();
                                                                    Ext.getCmp('intCodIPSTomaCitologia').disable();
                                                                    Ext.getCmp('sysCitologia4505').setValue(null);
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: 'Resultado Citologia',
                                                        fieldLabel: 'Resultado Citologia',
                                                        width: 600,
                                                        allowBlank: false,
                                                        store: stResultadoCitologia,
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'intResultadoCitologia'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: 'Calidad Muestra de la Citologia',
                                                        fieldLabel: 'Calidad Muestra de la Citologia',
                                                        width: 350,
                                                        allowBlank: false,
                                                        store: stCalidadMuestraCitologia,
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'intCalidadMuestraCitologia'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Registro IPS Toma Citologia?',
                                                                name: 'Registro IPS Toma Citologia?',
                                                                width: 100,
                                                                allowBlank: false,
                                                                store: stRegistroFechas,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'sysRegistroIPSTomaCitologia',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO APLICA"){
                                                                            Ext.getCmp('strSearchREPSSCitologia').setValue(0);
                                                                            Ext.getCmp('strSearchREPSSCitologia').disable();
                                                                        }else{
                                                                            if(newValue == "SIN DATO"){
                                                                                Ext.getCmp('strSearchREPSSCitologia').disable();
                                                                                Ext.getCmp('strSearchREPSSCitologia').setValue(999);
                                                                            }else{
                                                                                if(newValue == "SI"){
                                                                                    Ext.getCmp('strSearchREPSSCitologia').clearValue();
                                                                                    Ext.getCmp('strSearchREPSSCitologia').enable();
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Busqueda',
                                                                store: searchStoreREPSS,
                                                                allowBlank: false,
                                                                valueField: 'Codigo',
                                                                displayField: 'Descripcion',
                                                                typeAhead: false,
                                                                loadingText: 'Buscando...',
                                                                width: 490,
                                                                anchor: '100%',
                                                                hideTrigger: true,
                                                                minChars: 4,
                                                                emptyText:'Escriba el nombre del Prestador -- p.e: HOSPI',
                                                                id: 'intCodIPSTomaCitologia'
                                                            },
                                                        ]
                                                    },
                                                    /*{
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Registro IPS Toma Citologia?',
                                                                name: 'Registro IPS Toma Citologia?',
                                                                width: 100,
                                                                allowBlank: false,
                                                                store: stRegistroFechas,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'sysRegistroIPSTomaCitologia',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO APLICA"){
                                                                            Ext.getCmp('intCodIPSTomaCitologia').setValue(0);
                                                                            Ext.getCmp('intCodIPSTomaCitologia').disable();
                                                                        }else{
                                                                            if(newValue == "SIN DATO"){
                                                                                Ext.getCmp('intCodIPSTomaCitologia').setValue(999);
                                                                                Ext.getCmp('intCodIPSTomaCitologia').disable();
                                                                            }else{
                                                                                Ext.getCmp('intCodIPSTomaCitologia').enable();
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'Cod IPS Toma Citologia',
                                                                width: 200,
                                                                value: 0,
                                                                allowBlank: false,
                                                                id: 'intCodIPSTomaCitologia',
                                                                style: 'text-align:center;'
                                                            }
                                                        ]
                                                    },*/
                                                    {
                                                        html: '<br>'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Registrar Colposcopia?',
                                                        name: 'Registrar Colposcopia?',
                                                        width: 50,
                                                        allowBlank: true,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'sysRegistroColposcopia',
                                                        listeners:{
                                                            change : function( t, newValue, oldValue){
                                                                
                                                                if(Ext.getCmp('sysRegistroColposcopia').getValue()=="SI"){
                                                                    Ext.getCmp('sysColposcopia4505').setValue(Ext.getCmp('fecServicio').getValue().format('Y-m-d'));
                                                                    Ext.getCmp('sysRegistroIPSTomaColposcopia').enable();
                                                                    Ext.getCmp('intCodIPSTomaColposcopia').enable();
                                                                }else{
                                                                    Ext.getCmp('sysRegistroIPSTomaColposcopia').disable();
                                                                    Ext.getCmp('intCodIPSTomaColposcopia').disable();
                                                                    Ext.getCmp('sysColposcopia4505').setValue(null);
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Registro IPS Toma Colposcopia?',
                                                                name: 'Registro IPS Toma Colposcopia?',
                                                                width: 100,
                                                                allowBlank: false,
                                                                store: stRegistroFechas,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'sysRegistroIPSTomaColposcopia',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO APLICA"){
                                                                            Ext.getCmp('intCodIPSTomaColposcopia').setValue(0);
                                                                            Ext.getCmp('intCodIPSTomaColposcopia').disable();
                                                                        }else{
                                                                            if(newValue == "SIN DATO"){
                                                                                Ext.getCmp('intCodIPSTomaColposcopia').disable();
                                                                                Ext.getCmp('intCodIPSTomaColposcopia').setValue(999);
                                                                            }else{
                                                                                if(newValue == "SI"){
                                                                                    Ext.getCmp('intCodIPSTomaColposcopia').clearValue();
                                                                                    Ext.getCmp('intCodIPSTomaColposcopia').enable();
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Busqueda',
                                                                store: searchStoreREPSS,
                                                                allowBlank: false,
                                                                valueField: 'Codigo',
                                                                displayField: 'Descripcion',
                                                                typeAhead: false,
                                                                loadingText: 'Buscando...',
                                                                width: 490,
                                                                anchor: '100%',
                                                                hideTrigger: true,
                                                                minChars: 4,
                                                                emptyText:'Escriba el nombre del Prestador -- p.e: HOSPI',
                                                                id: 'intCodIPSTomaColposcopia'
                                                            },
                                                        ]
                                                    },
                                                    /*{
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Registro IPS Toma Colposcopia?',
                                                                name: 'Registro IPS Toma Colposcopia?',
                                                                width: 100,
                                                                allowBlank: false,
                                                                store: stRegistroFechas,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'sysRegistroIPSTomaColposcopia',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO APLICA"){
                                                                            Ext.getCmp('intCodIPSTomaColposcopia').setValue(0);
                                                                            Ext.getCmp('intCodIPSTomaColposcopia').disable();
                                                                        }else{
                                                                            if(newValue == "SIN DATO"){
                                                                                Ext.getCmp('intCodIPSTomaColposcopia').setValue(999);
                                                                                Ext.getCmp('intCodIPSTomaColposcopia').disable();
                                                                            }else{
                                                                                Ext.getCmp('intCodIPSTomaColposcopia').enable();
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'Cod IPS Toma Colposcopia',
                                                                width: 200,
                                                                value: 0,
                                                                allowBlank: false,
                                                                id: 'intCodIPSTomaColposcopia',
                                                                style: 'text-align:center;'
                                                            }
                                                        ]
                                                    },*/
                                                    {
                                                        html: '<br>'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Registrar Biopsia Cervical?',
                                                        name: 'Registrar Biopsia Cervical?',
                                                        width: 50,
                                                        allowBlank: true,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'sysRegistroBiopsiaCervical',
                                                        listeners:{
                                                            change : function( t, newValue, oldValue){
                                                                if(Ext.getCmp('sysRegistroBiopsiaCervical').getValue()=="SI"){
                                                                    Ext.getCmp('sysBiopsiaCervical4505').setValue(Ext.getCmp('fecServicio').getValue().format('Y-m-d'));
                                                                    Ext.getCmp('intResultadoBiopsiaCervical').enable();
                                                                    Ext.getCmp('sysRegistroIPSTomaBiopsiaCervical').enable();
                                                                    Ext.getCmp('intCodIPSTomaBiopsiaCervical').enable();
                                                                }else{
                                                                    Ext.getCmp('intResultadoBiopsiaCervical').disable();
                                                                    Ext.getCmp('sysRegistroIPSTomaBiopsiaCervical').disable();
                                                                    Ext.getCmp('intCodIPSTomaBiopsiaCervical').disable();
                                                                    Ext.getCmp('sysBiopsiaCervical4505').setValue(null);
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: 'Resultado Biopsia Cervical',
                                                        fieldLabel: 'Resultado Biopsia Cervical',
                                                        width: 350,
                                                        allowBlank: false,
                                                        store: stResultadoBiopsiaCervical,
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'intResultadoBiopsiaCervical'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Registro IPS Toma Biopsia Cervical?',
                                                                name: 'Registro IPS Toma Biopsia Cervical?',
                                                                width: 100,
                                                                allowBlank: false,
                                                                store: stRegistroFechas,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'sysRegistroIPSTomaBiopsiaCervical',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO APLICA"){
                                                                            Ext.getCmp('intCodIPSTomaBiopsiaCervical').setValue(0);
                                                                            Ext.getCmp('intCodIPSTomaBiopsiaCervical').disable();
                                                                        }else{
                                                                            if(newValue == "SIN DATO"){
                                                                                Ext.getCmp('intCodIPSTomaBiopsiaCervical').disable();
                                                                                Ext.getCmp('intCodIPSTomaBiopsiaCervical').setValue(999);
                                                                            }else{
                                                                                if(newValue == "SI"){
                                                                                    Ext.getCmp('intCodIPSTomaBiopsiaCervical').clearValue();
                                                                                    Ext.getCmp('intCodIPSTomaBiopsiaCervical').enable();
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Busqueda',
                                                                store: searchStoreREPSS,
                                                                allowBlank: false,
                                                                valueField: 'Codigo',
                                                                displayField: 'Descripcion',
                                                                typeAhead: false,
                                                                loadingText: 'Buscando...',
                                                                width: 490,
                                                                anchor: '100%',
                                                                hideTrigger: true,
                                                                minChars: 4,
                                                                emptyText:'Escriba el nombre del Prestador -- p.e: HOSPI',
                                                                id: 'intCodIPSTomaBiopsiaCervical'
                                                            },
                                                        ]
                                                    },
                                                    /*{
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Registro IPS Toma Biopsia Cervical?',
                                                                name: 'Registro IPS Toma Biopsia Cervical?',
                                                                width: 100,
                                                                allowBlank: false,
                                                                store: stRegistroFechas,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'sysRegistroIPSTomaBiopsiaCervical',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO APLICA"){
                                                                            Ext.getCmp('intCodIPSTomaBiopsiaCervical').setValue(0);
                                                                            Ext.getCmp('intCodIPSTomaBiopsiaCervical').disable();
                                                                        }else{
                                                                            if(newValue == "SIN DATO"){
                                                                                Ext.getCmp('intCodIPSTomaBiopsiaCervical').setValue(999);
                                                                                Ext.getCmp('intCodIPSTomaBiopsiaCervical').disable();
                                                                            }else{
                                                                                Ext.getCmp('intCodIPSTomaBiopsiaCervical').enable();
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'Cod IPS Toma Biopsia Cervical',
                                                                width: 200,
                                                                value: 0,
                                                                allowBlank: false,
                                                                id: 'intCodIPSTomaBiopsiaCervical',
                                                                style: 'text-align:center;'
                                                            }
                                                        ]
                                                    }*/
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'PROGRAMA CANCER DE MAMA',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Registrar Mamografia?',
                                                        name: 'Registrar Mamografia?',
                                                        width: 50,
                                                        allowBlank: true,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'sysRegistroMamografia',
                                                        listeners:{
                                                            change : function( t, newValue, oldValue){
                                                                if(Ext.getCmp('sysRegistroMamografia').getValue()=="SI"){
                                                                    Ext.getCmp('sysMamografia4505').setValue(Ext.getCmp('fecServicio').getValue().format('Y-m-d'));
                                                                    Ext.getCmp('intResultadoMamografia').enable();
                                                                    Ext.getCmp('sysRegistroIPSTomaMamografia').enable();
                                                                    Ext.getCmp('intCodIPSTomaMamografia').enable();
                                                                }else{
                                                                    Ext.getCmp('sysMamografia4505').setValue(null);
                                                                    Ext.getCmp('intResultadoMamografia').disable();
                                                                    Ext.getCmp('sysRegistroIPSTomaMamografia').disable();
                                                                    Ext.getCmp('intCodIPSTomaMamografia').disable();
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: 'Resultado Mamografia',
                                                        fieldLabel: 'Resultado Mamografia',
                                                        width: 350,
                                                        allowBlank: false,
                                                        store: stResultadoMamografia,
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'intResultadoMamografia'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Registro IPS Toma Mamografia?',
                                                                name: 'Registro IPS Toma Mamografia?',
                                                                width: 100,
                                                                allowBlank: false,
                                                                store: stRegistroFechas,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'sysRegistroIPSTomaMamografia',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO APLICA"){
                                                                            Ext.getCmp('intCodIPSTomaMamografia').setValue(0);
                                                                            Ext.getCmp('intCodIPSTomaMamografia').disable();
                                                                        }else{
                                                                            if(newValue == "SIN DATO"){
                                                                                Ext.getCmp('intCodIPSTomaMamografia').disable();
                                                                                Ext.getCmp('intCodIPSTomaMamografia').setValue(999);
                                                                            }else{
                                                                                if(newValue == "SI"){
                                                                                    Ext.getCmp('intCodIPSTomaMamografia').clearValue();
                                                                                    Ext.getCmp('intCodIPSTomaMamografia').enable();
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Busqueda',
                                                                store: searchStoreREPSS,
                                                                allowBlank: false,
                                                                valueField: 'Codigo',
                                                                displayField: 'Descripcion',
                                                                typeAhead: false,
                                                                loadingText: 'Buscando...',
                                                                width: 490,
                                                                anchor: '100%',
                                                                hideTrigger: true,
                                                                minChars: 4,
                                                                emptyText:'Escriba el nombre del Prestador -- p.e: HOSPI',
                                                                id: 'intCodIPSTomaMamografia'
                                                            },
                                                        ]
                                                    },
                                                    /*{
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Registro IPS Toma Mamografia?',
                                                                name: 'Registro IPS Toma Mamografia?',
                                                                width: 100,
                                                                allowBlank: false,
                                                                store: stRegistroFechas,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'sysRegistroIPSTomaMamografia',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO APLICA"){
                                                                            Ext.getCmp('intCodIPSTomaMamografia').setValue(0);
                                                                            Ext.getCmp('intCodIPSTomaMamografia').disable();
                                                                        }else{
                                                                            if(newValue == "SIN DATO"){
                                                                                Ext.getCmp('intCodIPSTomaMamografia').setValue(999);
                                                                                Ext.getCmp('intCodIPSTomaMamografia').disable();
                                                                            }else{
                                                                                Ext.getCmp('intCodIPSTomaMamografia').enable();
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'Cod IPS Toma Mamografia',
                                                                width: 200,
                                                                value: 0,
                                                                allowBlank: false,
                                                                id: 'intCodIPSTomaMamografia',
                                                                style: 'text-align:center;'
                                                            }
                                                        ]
                                                    },*/
                                                    {
                                                        html: '<br>'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Registrar Biopsia Seno?',
                                                        name: 'Registrar Biopsia Seno?',
                                                        width: 50,
                                                        allowBlank: true,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'sysRegistroBiopsiaSeno',
                                                        listeners:{
                                                            change : function( t, newValue, oldValue){
                                                                if(Ext.getCmp('sysRegistroBiopsiaSeno').getValue()=="SI"){
                                                                    Ext.getCmp('sysBiopsiaSeno4505').setValue(Ext.getCmp('fecServicio').getValue().format('Y-m-d'));
                                                                    Ext.getCmp('intResultadoBiopsiaSeno').enable();
                                                                    Ext.getCmp('sysRegistroIPSTomaBiopsiaSeno').enable();
                                                                    Ext.getCmp('intCodIPSTomaBiopsiaSeno').enable();
                                                                }else{
                                                                    Ext.getCmp('sysBiopsiaSeno4505').setValue(null);
                                                                    Ext.getCmp('intResultadoBiopsiaSeno').disable();
                                                                    Ext.getCmp('sysRegistroIPSTomaBiopsiaSeno').disable();
                                                                    Ext.getCmp('intCodIPSTomaBiopsiaSeno').disable();
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: 'Resultado Biopsia Seno',
                                                        fieldLabel: 'Resultado Biopsia Seno',
                                                        width: 350,
                                                        allowBlank: false,
                                                        store: stResultadoBiopsiaSeno,
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'intResultadoBiopsiaSeno'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Registro IPS Toma Biopsia Seno?',
                                                                name: 'Registro IPS Toma Biopsia Seno?',
                                                                width: 100,
                                                                allowBlank: false,
                                                                store: stRegistroFechas,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'sysRegistroIPSTomaBiopsiaSeno',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO APLICA"){
                                                                            Ext.getCmp('intCodIPSTomaBiopsiaSeno').setValue(0);
                                                                            Ext.getCmp('intCodIPSTomaBiopsiaSeno').disable();
                                                                        }else{
                                                                            if(newValue == "SIN DATO"){
                                                                                Ext.getCmp('intCodIPSTomaBiopsiaSeno').disable();
                                                                                Ext.getCmp('intCodIPSTomaBiopsiaSeno').setValue(999);
                                                                            }else{
                                                                                if(newValue == "SI"){
                                                                                    Ext.getCmp('intCodIPSTomaBiopsiaSeno').clearValue();
                                                                                    Ext.getCmp('intCodIPSTomaBiopsiaSeno').enable();
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Busqueda',
                                                                store: searchStoreREPSS,
                                                                allowBlank: false,
                                                                valueField: 'Codigo',
                                                                displayField: 'Descripcion',
                                                                typeAhead: false,
                                                                loadingText: 'Buscando...',
                                                                width: 490,
                                                                anchor: '100%',
                                                                hideTrigger: true,
                                                                minChars: 4,
                                                                emptyText:'Escriba el nombre del Prestador -- p.e: HOSPI',
                                                                id: 'intCodIPSTomaBiopsiaSeno'
                                                            },
                                                        ]
                                                    },
                                                    /*{
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Registro IPS Toma Biopsia Seno?',
                                                                name: 'Registro IPS Toma Biopsia Seno?',
                                                                width: 100,
                                                                allowBlank: false,
                                                                store: stRegistroFechas,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'sysRegistroIPSTomaBiopsiaSeno',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO APLICA"){
                                                                            Ext.getCmp('intCodIPSTomaBiopsiaSeno').setValue(0);
                                                                            Ext.getCmp('intCodIPSTomaBiopsiaSeno').disable();
                                                                        }else{
                                                                            if(newValue == "SIN DATO"){
                                                                                Ext.getCmp('intCodIPSTomaBiopsiaSeno').setValue(999);
                                                                                Ext.getCmp('intCodIPSTomaBiopsiaSeno').disable();
                                                                            }else{
                                                                                Ext.getCmp('intCodIPSTomaBiopsiaSeno').enable();
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'Cod IPS Toma Biopsia Seno',
                                                                width: 200,
                                                                value: 0,
                                                                allowBlank: false,
                                                                style: 'text-align:center;',
                                                                id: 'intCodIPSTomaBiopsiaSeno'
                                                            }
                                                        ]
                                                    }*/
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'PARACLINICOS',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Registro Toma Hemoglobina?',
                                                                name: 'Registro Toma Hemoglobina?',
                                                                width: 350,
                                                                allowBlank: false,
                                                                store: stRegistroFechasAdicional,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'sysRegistroTomaHemoglobina',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO APLICA"){
                                                                            Ext.getCmp('fecTomaHemoglobina').disable();
                                                                            Ext.getCmp('intResultadoHemoglobina').disable();
                                                                        }else{
                                                                            if(newValue == "SIN DATO"){
                                                                                Ext.getCmp('fecTomaHemoglobina').setValue("01/01/1800");
                                                                                Ext.getCmp('fecTomaHemoglobina').disable();
                                                                                Ext.getCmp('intResultadoHemoglobina').setValue(0);
                                                                                Ext.getCmp('intResultadoHemoglobina').disable();
                                                                            }else{
                                                                                if(newValue == "NO SE REALIZA POR TRADICIONES"){
                                                                                    Ext.getCmp('fecTomaHemoglobina').setValue("01/01/1805");
                                                                                    Ext.getCmp('fecTomaHemoglobina').disable();
                                                                                    Ext.getCmp('intResultadoHemoglobina').setValue(0);
                                                                                    Ext.getCmp('intResultadoHemoglobina').disable();
                                                                                }else{
                                                                                    if(newValue == "NO SE REALIZA POR CONDICIONES DE SALUD"){
                                                                                        Ext.getCmp('fecTomaHemoglobina').setValue("01/01/1810");
                                                                                        Ext.getCmp('fecTomaHemoglobina').disable();
                                                                                        Ext.getCmp('intResultadoHemoglobina').setValue(0);
                                                                                        Ext.getCmp('intResultadoHemoglobina').disable();
                                                                                    }else{
                                                                                        if(newValue == "NO SE REALIZA POR NEGACION DEL USUARIO"){
                                                                                            Ext.getCmp('fecTomaHemoglobina').setValue("01/01/1825");
                                                                                            Ext.getCmp('fecTomaHemoglobina').disable();
                                                                                            Ext.getCmp('intResultadoHemoglobina').setValue(0);
                                                                                            Ext.getCmp('intResultadoHemoglobina').disable();
                                                                                        }else{
                                                                                            if(newValue == "NO SE REALIZA POR DATOS DEL USUARIO DESACTUALIZADOS"){
                                                                                                Ext.getCmp('fecTomaHemoglobina').setValue("01/01/1830");
                                                                                                Ext.getCmp('fecTomaHemoglobina').disable();
                                                                                                Ext.getCmp('intResultadoHemoglobina').setValue(0);
                                                                                                Ext.getCmp('intResultadoHemoglobina').disable();
                                                                                            }else{
                                                                                                if(newValue == "NO SE REALIZA POR OTRAS RAZONES"){
                                                                                                    Ext.getCmp('fecTomaHemoglobina').setValue("01/01/1835");
                                                                                                    Ext.getCmp('fecTomaHemoglobina').disable();
                                                                                                    Ext.getCmp('intResultadoHemoglobina').setValue(0);
                                                                                                    Ext.getCmp('intResultadoHemoglobina').disable();
                                                                                                }else{
                                                                                                    Ext.getCmp('fecTomaHemoglobina').enable();
                                                                                                    Ext.getCmp('intResultadoHemoglobina').enable();
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 200,
                                                                name: 'Fecha Toma Hemoglobina',
                                                                allowBlank: false,
                                                                emptyText: '(dia/mes/año) ',
                                                                style: 'text-align:center;',
                                                                id: 'fecTomaHemoglobina'
                                                            },
                                                            {
                                                                html: 'Resultado'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'Resultado Hemoglobina',
                                                                width: 100,
                                                                maxValue: 20,
                                                                minValue: 0,
                                                                style: 'text-align:center;',
                                                                allowBlank: false,
                                                                id: 'intResultadoHemoglobina'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Registro Toma Creatinina?',
                                                                name: 'Registro Toma Creatinina?',
                                                                width: 350,
                                                                allowBlank: false,
                                                                store: stRegistroFechasAdicional,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'sysRegistroTomaCreatinina',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO APLICA"){
                                                                            Ext.getCmp('fecTomaCreatinina').disable();
                                                                            Ext.getCmp('intResultadoCreatinina').disable();
                                                                        }else{
                                                                            if(newValue == "SIN DATO"){
                                                                                Ext.getCmp('fecTomaCreatinina').setValue("01/01/1800");
                                                                                Ext.getCmp('fecTomaCreatinina').disable();
                                                                                Ext.getCmp('intResultadoCreatinina').setValue(999);
                                                                                Ext.getCmp('intResultadoCreatinina').disable();
                                                                            }else{
                                                                                if(newValue == "NO SE REALIZA POR TRADICIONES"){
                                                                                    Ext.getCmp('fecTomaCreatinina').setValue("01/01/1805");
                                                                                    Ext.getCmp('fecTomaCreatinina').disable();
                                                                                    Ext.getCmp('intResultadoCreatinina').setValue(0);
                                                                                    Ext.getCmp('intResultadoCreatinina').disable();
                                                                                }else{
                                                                                    if(newValue == "NO SE REALIZA POR CONDICIONES DE SALUD"){
                                                                                        Ext.getCmp('fecTomaCreatinina').setValue("01/01/1810");
                                                                                        Ext.getCmp('fecTomaCreatinina').disable();
                                                                                        Ext.getCmp('intResultadoCreatinina').setValue(0);
                                                                                        Ext.getCmp('intResultadoCreatinina').disable();
                                                                                    }else{
                                                                                        if(newValue == "NO SE REALIZA POR NEGACION DEL USUARIO"){
                                                                                            Ext.getCmp('fecTomaCreatinina').setValue("01/01/1825");
                                                                                            Ext.getCmp('fecTomaCreatinina').disable();
                                                                                            Ext.getCmp('intResultadoCreatinina').setValue(0);
                                                                                            Ext.getCmp('intResultadoCreatinina').disable();
                                                                                        }else{
                                                                                            if(newValue == "NO SE REALIZA POR DATOS DEL USUARIO DESACTUALIZADOS"){
                                                                                                Ext.getCmp('fecTomaCreatinina').setValue("01/01/1830");
                                                                                                Ext.getCmp('fecTomaCreatinina').disable();
                                                                                                Ext.getCmp('intResultadoCreatinina').setValue(0);
                                                                                                Ext.getCmp('intResultadoCreatinina').disable();
                                                                                            }else{
                                                                                                if(newValue == "NO SE REALIZA POR OTRAS RAZONES"){
                                                                                                    Ext.getCmp('fecTomaCreatinina').setValue("01/01/1835");
                                                                                                    Ext.getCmp('fecTomaCreatinina').disable();
                                                                                                    Ext.getCmp('intResultadoCreatinina').setValue(0);
                                                                                                    Ext.getCmp('intResultadoCreatinina').disable();
                                                                                                }else{
                                                                                                    Ext.getCmp('fecTomaCreatinina').enable();
                                                                                                    Ext.getCmp('intResultadoCreatinina').enable();
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 200,
                                                                name: 'Fecha Toma Creatinina',
                                                                allowBlank: false,
                                                                emptyText: '(dia/mes/año) ',
                                                                style: 'text-align:center;',
                                                                id: 'fecTomaCreatinina'
                                                            },
                                                            {
                                                                html: 'Resultado'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'Resultado Creatinina',
                                                                width: 100,
                                                                maxValue: 999,
                                                                minValue: 0,
                                                                style: 'text-align:center;',
                                                                allowBlank: false,
                                                                id: 'intResultadoCreatinina'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Registro Toma Hemoglobina Glicosilada?',
                                                                name: 'Registro Toma Hemoglobina Glicosilada?',
                                                                width: 350,
                                                                allowBlank: false,
                                                                store: stRegistroFechasAdicional,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'sysRegistroTomaHemoglobinaGlicosilada',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO APLICA"){
                                                                            Ext.getCmp('fecTomaHemoglobinaGlicosilada').disable();
                                                                            Ext.getCmp('intResultadoHemoglobinaGlicosilada').disable();
                                                                        }else{
                                                                            if(newValue == "SIN DATO"){
                                                                                Ext.getCmp('fecTomaHemoglobinaGlicosilada').setValue("01/01/1800");
                                                                                Ext.getCmp('fecTomaHemoglobinaGlicosilada').disable();
                                                                                Ext.getCmp('intResultadoHemoglobinaGlicosilada').setValue(999);
                                                                                Ext.getCmp('intResultadoHemoglobinaGlicosilada').disable();
                                                                            }else{
                                                                                if(newValue == "NO SE REALIZA POR TRADICIONES"){
                                                                                    Ext.getCmp('fecTomaHemoglobinaGlicosilada').setValue("01/01/1805");
                                                                                    Ext.getCmp('fecTomaHemoglobinaGlicosilada').disable();
                                                                                    Ext.getCmp('intResultadoHemoglobinaGlicosilada').setValue(0);
                                                                                    Ext.getCmp('intResultadoHemoglobinaGlicosilada').disable();
                                                                                }else{
                                                                                    if(newValue == "NO SE REALIZA POR CONDICIONES DE SALUD"){
                                                                                        Ext.getCmp('fecTomaHemoglobinaGlicosilada').setValue("01/01/1810");
                                                                                        Ext.getCmp('fecTomaHemoglobinaGlicosilada').disable();
                                                                                        Ext.getCmp('intResultadoHemoglobinaGlicosilada').setValue(0);
                                                                                        Ext.getCmp('intResultadoHemoglobinaGlicosilada').disable();
                                                                                    }else{
                                                                                        if(newValue == "NO SE REALIZA POR NEGACION DEL USUARIO"){
                                                                                            Ext.getCmp('fecTomaHemoglobinaGlicosilada').setValue("01/01/1825");
                                                                                            Ext.getCmp('fecTomaHemoglobinaGlicosilada').disable();
                                                                                            Ext.getCmp('intResultadoHemoglobinaGlicosilada').setValue(0);
                                                                                            Ext.getCmp('intResultadoHemoglobinaGlicosilada').disable();
                                                                                        }else{
                                                                                            if(newValue == "NO SE REALIZA POR DATOS DEL USUARIO DESACTUALIZADOS"){
                                                                                                Ext.getCmp('fecTomaHemoglobinaGlicosilada').setValue("01/01/1830");
                                                                                                Ext.getCmp('fecTomaHemoglobinaGlicosilada').disable();
                                                                                                Ext.getCmp('intResultadoHemoglobinaGlicosilada').setValue(0);
                                                                                                Ext.getCmp('intResultadoHemoglobinaGlicosilada').disable();
                                                                                            }else{
                                                                                                if(newValue == "NO SE REALIZA POR OTRAS RAZONES"){
                                                                                                    Ext.getCmp('fecTomaHemoglobinaGlicosilada').setValue("01/01/1835");
                                                                                                    Ext.getCmp('fecTomaHemoglobinaGlicosilada').disable();
                                                                                                    Ext.getCmp('intResultadoHemoglobinaGlicosilada').setValue(0);
                                                                                                    Ext.getCmp('intResultadoHemoglobinaGlicosilada').disable();
                                                                                                }else{
                                                                                                    Ext.getCmp('fecTomaHemoglobinaGlicosilada').enable();
                                                                                                    Ext.getCmp('intResultadoHemoglobinaGlicosilada').enable();
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 200,
                                                                name: 'Fecha Toma Hemoglobina Glicosilada',
                                                                allowBlank: false,
                                                                emptyText: '(dia/mes/año) ',
                                                                style: 'text-align:center;',
                                                                id: 'fecTomaHemoglobinaGlicosilada'
                                                            },
                                                            {
                                                                html: 'Resultado'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'Resultado Hemoglobina Glicosilada',
                                                                width: 100,
                                                                maxValue: 999,
                                                                minValue: 0,
                                                                style: 'text-align:center;',
                                                                allowBlank: false,
                                                                id: 'intResultadoHemoglobinaGlicosilada'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Registro Toma Glicemia?',
                                                                name: 'Registro Toma Glicemia?',
                                                                width: 350,
                                                                allowBlank: false,
                                                                store: stRegistroFechasAdicional,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'sysRegistroTomaGlicemia',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO APLICA"){
                                                                            Ext.getCmp('fecTomaGlicemia').disable();
                                                                        }else{
                                                                            if(newValue == "SIN DATO"){
                                                                                Ext.getCmp('fecTomaGlicemia').setValue("01/01/1800");
                                                                                Ext.getCmp('fecTomaGlicemia').disable();
                                                                            }else{
                                                                                if(newValue == "NO SE REALIZA POR TRADICIONES"){
                                                                                    Ext.getCmp('fecTomaGlicemia').setValue("01/01/1805");
                                                                                    Ext.getCmp('fecTomaGlicemia').disable();
                                                                                }else{
                                                                                    if(newValue == "NO SE REALIZA POR CONDICIONES DE SALUD"){
                                                                                        Ext.getCmp('fecTomaGlicemia').setValue("01/01/1810");
                                                                                        Ext.getCmp('fecTomaGlicemia').disable();
                                                                                    }else{
                                                                                        if(newValue == "NO SE REALIZA POR NEGACION DEL USUARIO"){
                                                                                            Ext.getCmp('fecTomaGlicemia').setValue("01/01/1825");
                                                                                            Ext.getCmp('fecTomaGlicemia').disable();
                                                                                        }else{
                                                                                            if(newValue == "NO SE REALIZA POR DATOS DEL USUARIO DESACTUALIZADOS"){
                                                                                                Ext.getCmp('fecTomaGlicemia').setValue("01/01/1830");
                                                                                                Ext.getCmp('fecTomaGlicemia').disable();
                                                                                            }else{
                                                                                                if(newValue == "NO SE REALIZA POR OTRAS RAZONES"){
                                                                                                    Ext.getCmp('fecTomaGlicemia').setValue("01/01/1835");
                                                                                                    Ext.getCmp('fecTomaGlicemia').disable();
                                                                                                }else{
                                                                                                    Ext.getCmp('fecTomaGlicemia').enable();
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 200,
                                                                name: 'Fecha Toma Glicemia',
                                                                allowBlank: false,
                                                                emptyText: '(dia/mes/año) ',
                                                                style: 'text-align:center;',
                                                                id: 'fecTomaGlicemia'
                                                            },
                                                            {
                                                                html: 'Resultado'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'Resultado Glicemia',
                                                                width: 100,
                                                                style: 'text-align:center;',
                                                                allowBlank: false,
                                                                id: 'sysResultadoGlicemia'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Registro Toma Microalbuminuria?',
                                                                name: 'Registro Toma Microalbuminuria?',
                                                                width: 350,
                                                                allowBlank: false,
                                                                store: stRegistroFechasAdicional,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'sysRegistroTomaMicroalbuminuria',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO APLICA"){
                                                                            Ext.getCmp('fecTomaMicroalbuminuria').disable();
                                                                        }else{
                                                                            if(newValue == "SIN DATO"){
                                                                                Ext.getCmp('fecTomaMicroalbuminuria').setValue("01/01/1800");
                                                                                Ext.getCmp('fecTomaMicroalbuminuria').disable();
                                                                            }else{
                                                                                if(newValue == "NO SE REALIZA POR TRADICIONES"){
                                                                                    Ext.getCmp('fecTomaMicroalbuminuria').setValue("01/01/1805");
                                                                                    Ext.getCmp('fecTomaMicroalbuminuria').disable();
                                                                                }else{
                                                                                    if(newValue == "NO SE REALIZA POR CONDICIONES DE SALUD"){
                                                                                        Ext.getCmp('fecTomaMicroalbuminuria').setValue("01/01/1810");
                                                                                        Ext.getCmp('fecTomaMicroalbuminuria').disable();
                                                                                    }else{
                                                                                        if(newValue == "NO SE REALIZA POR NEGACION DEL USUARIO"){
                                                                                            Ext.getCmp('fecTomaMicroalbuminuria').setValue("01/01/1825");
                                                                                            Ext.getCmp('fecTomaMicroalbuminuria').disable();
                                                                                        }else{
                                                                                            if(newValue == "NO SE REALIZA POR DATOS DEL USUARIO DESACTUALIZADOS"){
                                                                                                Ext.getCmp('fecTomaMicroalbuminuria').setValue("01/01/1830");
                                                                                                Ext.getCmp('fecTomaMicroalbuminuria').disable();
                                                                                            }else{
                                                                                                if(newValue == "NO SE REALIZA POR OTRAS RAZONES"){
                                                                                                    Ext.getCmp('fecTomaMicroalbuminuria').setValue("01/01/1835");
                                                                                                    Ext.getCmp('fecTomaMicroalbuminuria').disable();
                                                                                                }else{
                                                                                                    Ext.getCmp('fecTomaMicroalbuminuria').enable();
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 200,
                                                                name: 'Fecha Toma Microalbuminuria',
                                                                allowBlank: false,
                                                                emptyText: '(dia/mes/año) ',
                                                                style: 'text-align:center;',
                                                                id: 'fecTomaMicroalbuminuria'
                                                            },
                                                            {
                                                                html: 'Resultado'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'Resultado Microalbuminuria',
                                                                width: 100,
                                                                style: 'text-align:center;',
                                                                allowBlank: false,
                                                                id: 'sysResultadoMicroalbuminuria'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Registro Toma HDL?',
                                                                name: 'Registro Toma HDL?',
                                                                width: 350,
                                                                allowBlank: false,
                                                                store: stRegistroFechasAdicional,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'sysRegistroTomaHDL',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO APLICA"){
                                                                            Ext.getCmp('fecTomaHDL').disable();
                                                                        }else{
                                                                            if(newValue == "SIN DATO"){
                                                                                Ext.getCmp('fecTomaHDL').setValue("01/01/1800");
                                                                                Ext.getCmp('fecTomaHDL').disable();
                                                                            }else{
                                                                                if(newValue == "NO SE REALIZA POR TRADICIONES"){
                                                                                    Ext.getCmp('fecTomaHDL').setValue("01/01/1805");
                                                                                    Ext.getCmp('fecTomaHDL').disable();
                                                                                }else{
                                                                                    if(newValue == "NO SE REALIZA POR CONDICIONES DE SALUD"){
                                                                                        Ext.getCmp('fecTomaHDL').setValue("01/01/1810");
                                                                                        Ext.getCmp('fecTomaHDL').disable();
                                                                                    }else{
                                                                                        if(newValue == "NO SE REALIZA POR NEGACION DEL USUARIO"){
                                                                                            Ext.getCmp('fecTomaHDL').setValue("01/01/1825");
                                                                                            Ext.getCmp('fecTomaHDL').disable();
                                                                                        }else{
                                                                                            if(newValue == "NO SE REALIZA POR DATOS DEL USUARIO DESACTUALIZADOS"){
                                                                                                Ext.getCmp('fecTomaHDL').setValue("01/01/1830");
                                                                                                Ext.getCmp('fecTomaHDL').disable();
                                                                                            }else{
                                                                                                if(newValue == "NO SE REALIZA POR OTRAS RAZONES"){
                                                                                                    Ext.getCmp('fecTomaHDL').setValue("01/01/1835");
                                                                                                    Ext.getCmp('fecTomaHDL').disable();
                                                                                                }else{
                                                                                                    Ext.getCmp('fecTomaHDL').enable();
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 200,
                                                                name: 'Fecha Toma HDL',
                                                                allowBlank: false,
                                                                emptyText: '(dia/mes/año) ',
                                                                style: 'text-align:center;',
                                                                id: 'fecTomaHDL'
                                                            },
                                                            {
                                                                html: 'Resultado'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'Resultado HDL',
                                                                width: 100,
                                                                style: 'text-align:center;',
                                                                allowBlank: false,
                                                                id: 'sysResultadoHDL'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Registro Toma Baciloscopia?',
                                                                name: 'Registro Toma Baciloscopia?',
                                                                width: 350,
                                                                allowBlank: false,
                                                                store: stRegistroFechasAdicional,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'sysRegistroTomaBaciloscopia',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO APLICA"){
                                                                            Ext.getCmp('fecTomaBaciloscopiaDiagnostica').disable();
                                                                        }else{
                                                                            if(newValue == "SIN DATO"){
                                                                                Ext.getCmp('fecTomaBaciloscopiaDiagnostica').setValue("01/01/1800");
                                                                                Ext.getCmp('fecTomaBaciloscopiaDiagnostica').disable();
                                                                            }else{
                                                                                if(newValue == "NO SE REALIZA POR TRADICIONES"){
                                                                                    Ext.getCmp('fecTomaBaciloscopiaDiagnostica').setValue("01/01/1805");
                                                                                    Ext.getCmp('fecTomaBaciloscopiaDiagnostica').disable();
                                                                                }else{
                                                                                    if(newValue == "NO SE REALIZA POR CONDICIONES DE SALUD"){
                                                                                        Ext.getCmp('fecTomaBaciloscopiaDiagnostica').setValue("01/01/1810");
                                                                                        Ext.getCmp('fecTomaBaciloscopiaDiagnostica').disable();
                                                                                    }else{
                                                                                        if(newValue == "NO SE REALIZA POR NEGACION DEL USUARIO"){
                                                                                            Ext.getCmp('fecTomaBaciloscopiaDiagnostica').setValue("01/01/1825");
                                                                                            Ext.getCmp('fecTomaBaciloscopiaDiagnostica').disable();
                                                                                        }else{
                                                                                            if(newValue == "NO SE REALIZA POR DATOS DEL USUARIO DESACTUALIZADOS"){
                                                                                                Ext.getCmp('fecTomaBaciloscopiaDiagnostica').setValue("01/01/1830");
                                                                                                Ext.getCmp('fecTomaBaciloscopiaDiagnostica').disable();
                                                                                            }else{
                                                                                                if(newValue == "NO SE REALIZA POR OTRAS RAZONES"){
                                                                                                    Ext.getCmp('fecTomaBaciloscopiaDiagnostica').setValue("01/01/1835");
                                                                                                    Ext.getCmp('fecTomaBaciloscopiaDiagnostica').disable();
                                                                                                }else{
                                                                                                    Ext.getCmp('fecTomaBaciloscopiaDiagnostica').enable();
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 200,
                                                                name: 'Fecha Toma Baciloscopia Diagnostica',
                                                                allowBlank: false,
                                                                emptyText: '(dia/mes/año) ',
                                                                style: 'text-align:center;',
                                                                id: 'fecTomaBaciloscopiaDiagnostica'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: 'Resultado Baciloscopia Diagnostica',
                                                        fieldLabel: 'Resultado Baciloscopia Diagnostica',
                                                        width: 350,
                                                        allowBlank: false,
                                                        store: stResultadoBaciloscopiaDiagnostica,
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'intResultadoBaciloscopiaDiagnostica'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Registro Toma Serologia?',
                                                                name: 'Registro Toma Serologia?',
                                                                width: 350,
                                                                allowBlank: false,
                                                                store: stRegistroFechasAdicional,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'sysRegistroTomaSerologia',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO APLICA"){
                                                                            Ext.getCmp('fecSerologia').disable();
                                                                        }else{
                                                                            if(newValue == "SIN DATO"){
                                                                                Ext.getCmp('fecSerologia').setValue("01/01/1800");
                                                                                Ext.getCmp('fecSerologia').disable();
                                                                            }else{
                                                                                if(newValue == "NO SE REALIZA POR TRADICIONES"){
                                                                                    Ext.getCmp('fecSerologia').setValue("01/01/1805");
                                                                                    Ext.getCmp('fecSerologia').disable();
                                                                                }else{
                                                                                    if(newValue == "NO SE REALIZA POR CONDICIONES DE SALUD"){
                                                                                        Ext.getCmp('fecSerologia').setValue("01/01/1810");
                                                                                        Ext.getCmp('fecSerologia').disable();
                                                                                    }else{
                                                                                        if(newValue == "NO SE REALIZA POR NEGACION DEL USUARIO"){
                                                                                            Ext.getCmp('fecSerologia').setValue("01/01/1825");
                                                                                            Ext.getCmp('fecSerologia').disable();
                                                                                        }else{
                                                                                            if(newValue == "NO SE REALIZA POR DATOS DEL USUARIO DESACTUALIZADOS"){
                                                                                                Ext.getCmp('fecSerologia').setValue("01/01/1830");
                                                                                                Ext.getCmp('fecSerologia').disable();
                                                                                            }else{
                                                                                                if(newValue == "NO SE REALIZA POR OTRAS RAZONES"){
                                                                                                    Ext.getCmp('fecSerologia').setValue("01/01/1835");
                                                                                                    Ext.getCmp('fecSerologia').disable();
                                                                                                }else{
                                                                                                    Ext.getCmp('fecSerologia').enable();
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 200,
                                                                name: 'Fecha Serologia',
                                                                allowBlank: false,
                                                                emptyText: '(dia/mes/año) ',
                                                                style: 'text-align:center;',
                                                                id: 'fecSerologia'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: 'Resultado Serologia',
                                                        fieldLabel: 'Resultado Serologia',
                                                        width: 350,
                                                        allowBlank: false,
                                                        store: stResultadoAntigenoHepatitisB,
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'intResultadoSerologia'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Registro Toma Elisa VIH?',
                                                                name: 'Registro Toma Elisa VIH?',
                                                                width: 350,
                                                                allowBlank: false,
                                                                store: stRegistroFechasAdicional,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'sysRegistroTomaElisaVIH',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO APLICA"){
                                                                            Ext.getCmp('fecTomaElisaVIH').disable();
                                                                        }else{
                                                                            if(newValue == "SIN DATO"){
                                                                                Ext.getCmp('fecTomaElisaVIH').setValue("01/01/1800");
                                                                                Ext.getCmp('fecTomaElisaVIH').disable();
                                                                            }else{
                                                                                if(newValue == "NO SE REALIZA POR TRADICIONES"){
                                                                                    Ext.getCmp('fecTomaElisaVIH').setValue("01/01/1805");
                                                                                    Ext.getCmp('fecTomaElisaVIH').disable();
                                                                                }else{
                                                                                    if(newValue == "NO SE REALIZA POR CONDICIONES DE SALUD"){
                                                                                        Ext.getCmp('fecTomaElisaVIH').setValue("01/01/1810");
                                                                                        Ext.getCmp('fecTomaElisaVIH').disable();
                                                                                    }else{
                                                                                        if(newValue == "NO SE REALIZA POR NEGACION DEL USUARIO"){
                                                                                            Ext.getCmp('fecTomaElisaVIH').setValue("01/01/1825");
                                                                                            Ext.getCmp('fecTomaElisaVIH').disable();
                                                                                        }else{
                                                                                            if(newValue == "NO SE REALIZA POR DATOS DEL USUARIO DESACTUALIZADOS"){
                                                                                                Ext.getCmp('fecTomaElisaVIH').setValue("01/01/1830");
                                                                                                Ext.getCmp('fecTomaElisaVIH').disable();
                                                                                            }else{
                                                                                                if(newValue == "NO SE REALIZA POR OTRAS RAZONES"){
                                                                                                    Ext.getCmp('fecTomaElisaVIH').setValue("01/01/1835");
                                                                                                    Ext.getCmp('fecTomaElisaVIH').disable();
                                                                                                }else{
                                                                                                    Ext.getCmp('fecTomaElisaVIH').enable();
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 200,
                                                                name: 'Fecha Toma Elisa VIH',
                                                                allowBlank: false,
                                                                emptyText: '(dia/mes/año) ',
                                                                style: 'text-align:center;',
                                                                id: 'fecTomaElisaVIH'
                                                            },
                                                            {
                                                                html:'Resultado'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Resultado Elisa VIH',
                                                                width: 100,
                                                                allowBlank: false,
                                                                store: stResultadoAntigenoHepatitisB,
                                                                valueField: 'Codigo',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'intResultadoElisaVIH'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Registro TSH Neonatal?',
                                                                name: 'Registro TSH Neonatal?',
                                                                width: 350,
                                                                allowBlank: false,
                                                                store: stRegistroFechasAdicional,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'sysRegistroTSHNeonatal',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO APLICA"){
                                                                            Ext.getCmp('fecTSHNeonatal').disable();
                                                                        }else{
                                                                            if(newValue == "SIN DATO"){
                                                                                Ext.getCmp('fecTSHNeonatal').setValue("01/01/1800");
                                                                                Ext.getCmp('fecTSHNeonatal').disable();
                                                                            }else{
                                                                                if(newValue == "NO SE REALIZA POR TRADICIONES"){
                                                                                    Ext.getCmp('fecTSHNeonatal').setValue("01/01/1805");
                                                                                    Ext.getCmp('fecTSHNeonatal').disable();
                                                                                }else{
                                                                                    if(newValue == "NO SE REALIZA POR CONDICIONES DE SALUD"){
                                                                                        Ext.getCmp('fecTSHNeonatal').setValue("01/01/1810");
                                                                                        Ext.getCmp('fecTSHNeonatal').disable();
                                                                                    }else{
                                                                                        if(newValue == "NO SE REALIZA POR NEGACION DEL USUARIO"){
                                                                                            Ext.getCmp('fecTSHNeonatal').setValue("01/01/1825");
                                                                                            Ext.getCmp('fecTSHNeonatal').disable();
                                                                                        }else{
                                                                                            if(newValue == "NO SE REALIZA POR DATOS DEL USUARIO DESACTUALIZADOS"){
                                                                                                Ext.getCmp('fecTSHNeonatal').setValue("01/01/1830");
                                                                                                Ext.getCmp('fecTSHNeonatal').disable();
                                                                                            }else{
                                                                                                if(newValue == "NO SE REALIZA POR OTRAS RAZONES"){
                                                                                                    Ext.getCmp('fecTSHNeonatal').setValue("01/01/1835");
                                                                                                    Ext.getCmp('fecTSHNeonatal').disable();
                                                                                                }else{
                                                                                                    Ext.getCmp('fecTSHNeonatal').enable();
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 200,
                                                                name: 'Fecha TSH Neonatal',
                                                                allowBlank: false,
                                                                emptyText: '(dia/mes/año) ',
                                                                style: 'text-align:center;',
                                                                id: 'fecTSHNeonatal'
                                                            },
                                                            {
                                                                html:'Resultado'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Resultado TSH Neonatal',
                                                                width: 100,
                                                                allowBlank: false,
                                                                store: stTSHNeonatal,
                                                                valueField: 'Codigo',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'intResultadoTSHNeonatal'
                                                            }
                                                        ]
                                                    },
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'VACUNACION',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        name: 'BCG',
                                                        fieldLabel: 'BCG',
                                                        width: 450,
                                                        allowBlank: false,
                                                        store: stBCG,
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: 22,
                                                        id: 'intBCG'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: 'Hepatitis B',
                                                        fieldLabel: 'Hepatitis B',
                                                        width: 450,
                                                        allowBlank: false,
                                                        store: stHepatitisB,
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: 22,
                                                        id: 'intHepatitisB'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: 'Pentavalente',
                                                        fieldLabel: 'Pentavalente',
                                                        width: 450,
                                                        allowBlank: false,
                                                        store: stPentavalente,
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: 22,
                                                        id: 'intPentavalente'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: 'Polio',
                                                        fieldLabel: 'Polio',
                                                        width: 450,
                                                        allowBlank: false,
                                                        store: stPolio,
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: 22,
                                                        id: 'intPolio'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: 'DPT',
                                                        fieldLabel: 'DPT',
                                                        width: 450,
                                                        allowBlank: false,
                                                        store: stDPT,
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: 22,
                                                        id: 'intDPT'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: 'Rotavirus',
                                                        fieldLabel: 'Rotavirus',
                                                        width: 450,
                                                        allowBlank: false,
                                                        store: stRotavirus,
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: 22,
                                                        id: 'intRotavirus'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: 'Neumococo',
                                                        fieldLabel: 'Neumococo',
                                                        width: 450,
                                                        allowBlank: false,
                                                        store: stNeumococo,
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: 22,
                                                        id: 'intNeumococo'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: 'Influenza',
                                                        fieldLabel: 'Influenza',
                                                        width: 450,
                                                        allowBlank: false,
                                                        store: stInfluenza,
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: 22,
                                                        id: 'intInfluenza'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: 'Fiebre Amarilla',
                                                        fieldLabel: 'Fiebre Amarilla',
                                                        width: 450,
                                                        allowBlank: false,
                                                        store: stFiebreAmarilla,
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: 22,
                                                        id: 'intFiebreAmarilla'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: 'Hepatitis A',
                                                        fieldLabel: 'Hepatitis A',
                                                        width: 450,
                                                        allowBlank: false,
                                                        store: stHepatitisA,
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: 22,
                                                        id: 'intHepatitisA'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: 'Triple Viral',
                                                        fieldLabel: 'Triple Viral',
                                                        width: 450,
                                                        allowBlank: false,
                                                        store: stTripleViral,
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: 22,
                                                        id: 'intTripleViral'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: 'VPH',
                                                        fieldLabel: 'VPH',
                                                        width: 450,
                                                        allowBlank: false,
                                                        store: stVPH,
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: 22,
                                                        id: 'intVPH'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: 'TD o TT',
                                                        fieldLabel: 'TD o TT',
                                                        width: 450,
                                                        allowBlank: false,
                                                        store: stTD,
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: 22,
                                                        id: 'intTD'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'EVOLUCION',
                                                layout: 'table',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'EVOLUCION',
                                                        name: 'EVOLUCION',
                                                        height: 100,
                                                        allowBlank: false,
                                                        id: 'memEvolucion'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'RIPS',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Principal',
                                                                id: 'sysDiagPpalProc',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue()){
                                                                                Ext.Ajax.request({
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagPpalProc').setValue(null);
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagPpalProc').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagPpalProc').setValue(null);
                                                                                        Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagPpalProc').setValue(null);
                                                                                Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    },
                                                                    blur: function(t){
                                                                        if(Ext.getCmp('sysDiagPpalProcNom').getValue()==null || Ext.getCmp('sysDiagPpalProcNom').getValue()== "")
                                                                        {
                                                                            if (Ext.getCmp('sysDiagPpalProc').getValue() != "" && Ext.getCmp('sysDiagPpalProc').getValue() != null && Ext.getCmp('sysDiagPpalProc').getValue().toUpperCase() != Ext.getCmp('sysDiagRel1Proc').getValue() && Ext.getCmp('sysDiagPpalProc').getValue().toUpperCase() != Ext.getCmp('sysDiagRel2Proc').getValue()){
                                                                                Ext.Ajax.request({
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: Ext.getCmp('sysDiagPpalProc').getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagPpalProc').setValue(null);
                                                                                            Ext.getCmp('sysDiagPpalProcNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagPpalProc').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagPpalProcNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagPpalProc').setValue(null);
                                                                                        Ext.getCmp('sysDiagPpalProcNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagPpalProc').setValue(null);
                                                                                Ext.getCmp('sysDiagPpalProcNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 600,
                                                                height: 22,
                                                                id: 'sysDiagPpalProcNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Principal',
                                                                id: 'btnSearchDiagPpalProc',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagPpalProc','sysDiagPpalProcNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado',
                                                                id: 'sysDiagRel1Proc',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalProc').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2Proc').getValue()){
                                                                                Ext.Ajax.request({
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel1Proc').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel1ProcNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel1Proc').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagRel1ProcNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel1Proc').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel1ProcNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel1Proc').setValue(null);
                                                                                Ext.getCmp('sysDiagRel1ProcNom').setValue(null);
                                                                            }
                                                                        }
                                                                    },
                                                                    blur: function(t){
                                                                        if(Ext.getCmp('sysDiagRel1ProcNom').getValue()==null || Ext.getCmp('sysDiagRel1ProcNom').getValue()== "")
                                                                        {
                                                                            if (Ext.getCmp('sysDiagRel1Proc').getValue() != "" && Ext.getCmp('sysDiagRel1Proc').getValue() != null && Ext.getCmp('sysDiagRel1Proc').getValue().toUpperCase() != Ext.getCmp('sysDiagPpalProc').getValue() && Ext.getCmp('sysDiagRel1Proc').getValue().toUpperCase() != Ext.getCmp('sysDiagRel2Proc').getValue()){
                                                                                Ext.Ajax.request({
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: Ext.getCmp('sysDiagRel1Proc').getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel1Proc').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel1ProcNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel1Proc').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagRel1ProcNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel1Proc').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel1ProcNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel1Proc').setValue(null);
                                                                                Ext.getCmp('sysDiagRel1ProcNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 600,
                                                                height: 22,
                                                                id: 'sysDiagRel1ProcNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado',
                                                                id: 'btnSearchDiagRel1Proc',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel1Proc','sysDiagRel1ProcNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Complicación',
                                                                id: 'sysDiagRel2Proc',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalProc').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1Proc').getValue()){
                                                                                Ext.Ajax.request({
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel2Proc').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel2ProcNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel2Proc').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagRel2ProcNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel2Proc').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel2ProcNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel2Proc').setValue(null);
                                                                                Ext.getCmp('sysDiagRel2ProcNom').setValue(null);
                                                                            }
                                                                        }
                                                                    },
                                                                    blur: function(t){
                                                                        if(Ext.getCmp('sysDiagRel2ProcNom').getValue()==null || Ext.getCmp('sysDiagRel2ProcNom').getValue()== "")
                                                                        {
                                                                            if (Ext.getCmp('sysDiagRel2Proc').getValue() != "" && Ext.getCmp('sysDiagRel2Proc').getValue() != null && Ext.getCmp('sysDiagRel2Proc').getValue().toUpperCase() != Ext.getCmp('sysDiagPpalProc').getValue() && Ext.getCmp('sysDiagRel2Proc').getValue().toUpperCase() != Ext.getCmp('sysDiagRel1Proc').getValue()){
                                                                                Ext.Ajax.request({
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: Ext.getCmp('sysDiagRel2Proc').getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel2Proc').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel2ProcNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel2Proc').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagRel2ProcNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel2Proc').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel2ProcNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel2Proc').setValue(null);
                                                                                Ext.getCmp('sysDiagRel2ProcNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 600,
                                                                height: 22,
                                                                id: 'sysDiagRel2ProcNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Complicación',
                                                                id: 'btnSearchDiagRel2Proc',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel2Proc','sysDiagRel2ProcNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Ambito',
                                                        width:700,
                                                        name: 'Ambito',
                                                        allowBlank: false,
                                                        store: 'StoreAmbitoProcedimiento',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 1,
                                                        id: 'sysAmbitoProc'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Finalidad Procedimiento',
                                                        width:700,
                                                        name: 'Finalidad Procedimiento',
                                                        allowBlank: false,
                                                        store: 'StoreFinalidadProcedimiento',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 1,
                                                        id: 'sysFinalidadProcedimientoProc'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Personal Atiende',
                                                        width:700,
                                                        name: 'Personal Atiende',
                                                        allowBlank: false,
                                                        store: 'StorePersonalAtiendeProcedimiento',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 1,
                                                        id: 'sysPersonalAtiendeProcedimientoProc'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Forma Realización Acto Quirúrgico',
                                                        width:700,
                                                        name: 'Forma Realización Acto Quirúrgico',
                                                        allowBlank: false,
                                                        store: 'StoreFormaRealizacionProcedimiento',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 1,
                                                        id: 'sysFormaRealizaProcedimientoProc'
                                                    }
                                                ]
                                            }
                                        ]
                                    }
                                ]
                            }
                        ]
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btnSalirEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 1)
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Usted No ha Guardado la Evolución del Paciente y Se Perdera la Información, Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                },
                tbar:{
                    items: [
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Ver Historia Clínica',
                            iconCls: 'btnVerHC',
                            id: 'btnVerHC',
                            listeners:{
                                click : function(){
                                    var cmpResumenHC = new winFrmVerHistorialHC({
                                        renderTo: Ext.getBody()
                                    });
                                    Ext.getCmp('winViewEvolucionHC').title = "PACIENTE: " + Ext.getCmp('sysPacienteHC').getValue();
                                    Ext.getCmp('gridHistorialEvoluciones').store.load({
                                        params: {
                                            pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                                            pPaciente: Ext.getCmp('sysIdPacienteHC').getValue()
                                        }
                                    });
                                    cmpResumenHC.show();
                                }
                            }
                        },
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar Evolución',
                            iconCls: 'btnGuardar',
                            id: 'btnGuardarEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 0)
                                    {
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Guardar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnGuardarRegistrosMedicinaGeneral();
                                                }
                                            }
                                        });
                                    }else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Modificar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnModificarRegistrosMedicinaGeneral();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                }
            }
        ];
        this.on({
            afterlayout:{
                scope:this, 
                single:true, 
                fn:function() {
                    Ext.Msg.hide();
                    //Predefinir Comportamiento Campos
                    if(Ext.getCmp('sysFechaHC').getValue() != null || Ext.getCmp('sysFechaHC').getValue() != 0){
                       calculoEdadPacienteMeses()
                       var pFec2Anio = Ext.getCmp('sysFechaHC').getValue().substr(0,4);
                       var pFec2Mes = Ext.getCmp('sysFechaHC').getValue().substr(5,2);
                       var pFec2Dia = Ext.getCmp('sysFechaHC').getValue().substr(8,2);
                       Ext.getCmp('fecServicio').setValue(pFec2Dia+"/"+pFec2Mes+"/"+pFec2Anio);
                    }
                    //IDENTIFICACION DEL RIESGO FILTROS
                    if(Ext.getCmp('sysGeneroHC').getValue()=="FEMENINO" && MesesCumplidos >= 121){
                        Ext.getCmp('intIdentificacionRiesgoGestacion').setValue(21);
                        Ext.getCmp('intIdentificacionRiesgoGestacion').enable();
                    }else{
                        Ext.getCmp('intIdentificacionRiesgoGestacion').setValue(0);
                        Ext.getCmp('intIdentificacionRiesgoGestacion').disable();
                        Ext.getCmp('intIdentificacionRiesgoHipertencionGestacional').setValue(0);
                        Ext.getCmp('intIdentificacionRiesgoHipertencionGestacional').disable();
                    }
                    if(Ext.getCmp('sysGeneroHC').getValue()=="FEMENINO" || MesesCumplidos <= 216){
                        Ext.getCmp('intIdentificacionRiesgoVictimaMaltrato').setValue(21);
                        Ext.getCmp('intIdentificacionRiesgoVictimaMaltrato').enable();
                    }else{
                        Ext.getCmp('intIdentificacionRiesgoVictimaMaltrato').setValue(0);
                        Ext.getCmp('intIdentificacionRiesgoVictimaMaltrato').disable();
                    }
                    if(MesesCumplidos <= 36){
                        Ext.getCmp('intIdentificacionRiesgoHipotiroidismoCongenito').setValue(21);
                        Ext.getCmp('intIdentificacionRiesgoHipotiroidismoCongenito').enable();
                    }else{
                        Ext.getCmp('intIdentificacionRiesgoHipotiroidismoCongenito').setValue(0);
                        Ext.getCmp('intIdentificacionRiesgoHipotiroidismoCongenito').disable();
                    }
                    //VALIDACIONES INICIALES CARGUE
                    if(Ext.getCmp('sysGeneroHC').getValue()!= "FEMENINO" || MesesCumplidos <= 120){
                        Ext.getCmp('intTamizajeCancerCuelloUterino').setValue(0);
                        Ext.getCmp('intTamizajeCancerCuelloUterino').disable();
                        Ext.getCmp('sysRegistroCitologia').setValue("NO");
                        Ext.getCmp('sysRegistroCitologia').disable();
                        Ext.getCmp('intResultadoCitologia').setValue(0);
                        Ext.getCmp('intResultadoCitologia').disable();
                        Ext.getCmp('intCalidadMuestraCitologia').setValue(0);
                        Ext.getCmp('intCalidadMuestraCitologia').disable();
                        Ext.getCmp('sysRegistroIPSTomaCitologia').setValue("NO APLICA");
                        Ext.getCmp('sysRegistroIPSTomaCitologia').disable();
                        Ext.getCmp('intCodIPSTomaCitologia').setValue(0);
                        Ext.getCmp('intCodIPSTomaCitologia').disable();
                        Ext.getCmp('sysRegistroColposcopia').setValue("NO");
                        Ext.getCmp('sysRegistroColposcopia').disable();
                        Ext.getCmp('sysRegistroIPSTomaColposcopia').setValue("NO APLICA");
                        Ext.getCmp('sysRegistroIPSTomaColposcopia').disable();
                        Ext.getCmp('intCodIPSTomaColposcopia').setValue(0);
                        Ext.getCmp('intCodIPSTomaColposcopia').disable();
                        Ext.getCmp('sysRegistroBiopsiaCervical').setValue("NO");
                        Ext.getCmp('sysRegistroBiopsiaCervical').disable();
                        Ext.getCmp('intResultadoBiopsiaCervical').setValue(0);
                        Ext.getCmp('intResultadoBiopsiaCervical').disable();
                        Ext.getCmp('sysRegistroIPSTomaBiopsiaCervical').setValue("NO APLICA");
                        Ext.getCmp('sysRegistroIPSTomaBiopsiaCervical').disable();
                        Ext.getCmp('intCodIPSTomaBiopsiaCervical').setValue(0);
                        Ext.getCmp('intCodIPSTomaBiopsiaCervical').disable();
                        Ext.getCmp('sysRegistroMamografia').setValue("NO");
                        Ext.getCmp('sysRegistroMamografia').disable();
                        Ext.getCmp('intResultadoMamografia').setValue(0);
                        Ext.getCmp('intResultadoMamografia').disable();
                        Ext.getCmp('sysRegistroIPSTomaMamografia').setValue("NO APLICA");
                        Ext.getCmp('sysRegistroIPSTomaMamografia').disable();
                        Ext.getCmp('intCodIPSTomaMamografia').setValue(0);
                        Ext.getCmp('intCodIPSTomaMamografia').disable();
                        Ext.getCmp('sysRegistroBiopsiaSeno').setValue("NO");
                        Ext.getCmp('sysRegistroBiopsiaSeno').disable();
                        Ext.getCmp('intResultadoBiopsiaSeno').setValue(0);
                        Ext.getCmp('intResultadoBiopsiaSeno').disable();
                        Ext.getCmp('sysRegistroIPSTomaBiopsiaSeno').setValue("NO APLICA");
                        Ext.getCmp('sysRegistroIPSTomaBiopsiaSeno').disable();
                        Ext.getCmp('intCodIPSTomaBiopsiaSeno').setValue(0);
                        Ext.getCmp('intCodIPSTomaBiopsiaSeno').disable();
                    }
                    if(Ext.getCmp('sysGeneroHC').getValue()!= "FEMENINO"){
                        Ext.getCmp('intVPH').setValue(0);
                        Ext.getCmp('intVPH').disable();
                        Ext.getCmp('intTD').setValue(0);
                        Ext.getCmp('intTD').disable();
                    }
                    if(MesesCumplidos >= 36){
                        Ext.getCmp('intNeumococo').setValue(0);
                        Ext.getCmp('intNeumococo').disable();
                        Ext.getCmp('intInfluenza').setValue(0);
                        Ext.getCmp('intInfluenza').disable();
                    }
                    if(MesesCumplidos >= 12){
                        Ext.getCmp('intHepatitisB').setValue(0);
                        Ext.getCmp('intHepatitisB').disable();
                        Ext.getCmp('intFiebreAmarilla').setValue(0);
                        Ext.getCmp('intFiebreAmarilla').disable();
                    }
                    if(MesesCumplidos >= 25){
                        Ext.getCmp('intPentavalente').setValue(0);
                        Ext.getCmp('intPentavalente').disable();
                        Ext.getCmp('intHepatitisA').setValue(0);
                        Ext.getCmp('intHepatitisA').disable();
                    }
                    if(MesesCumplidos >= 8){
                        Ext.getCmp('intRotavirus').setValue(0);
                        Ext.getCmp('intRotavirus').disable();
                    }
                    if(MesesCumplidos >= 2){
                        Ext.getCmp('sysRegistroTSHNeonatal').disable();
                        Ext.getCmp('fecTSHNeonatal').disable();
                        Ext.getCmp('intResultadoTSHNeonatal').disable();
                    }
                    if(MesesCumplidos >= 83){
                        Ext.getCmp('intPolio').setValue(0);
                        Ext.getCmp('intPolio').disable();
                        Ext.getCmp('intDPT').setValue(0);
                        Ext.getCmp('intDPT').disable();
                        Ext.getCmp('intBCG').setValue(0);
                        Ext.getCmp('intBCG').disable();
                        Ext.getCmp('intTripleViral').setValue(0);
                        Ext.getCmp('intTripleViral').disable();
                    }
                    //CARGAR ANTECEDENTES
                    if(paramOpcion === "Nuevo"){ 
                        Ext.Ajax.request({
                            url: '../../controlador/asistencial/evolucionhc.php',
                            waitMsg: 'Cargando Información...',
                            params:{
                                pCAS: wCAS,
                                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                                task: 'ImportarAntecedentesFamiliares'
                            },
                            success: function(result, request)
                            {
                                var jsonAntFamiliares = Ext.util.JSON.decode(result.responseText);
                                CargarDataHCAntecedentes(jsonAntFamiliares.data.sysEvolucion);
                                Ext.Ajax.request({
                                    url: '../../controlador/asistencial/evolucionhc.php',
                                    waitMsg: 'Cargando Información...',
                                    params:{
                                        pCAS: wCAS,
                                        pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                                        task: 'ImportarAntecedentesPersonalesOfiClinic001'
                                    },
                                    success: function(result, request)
                                    {
                                        var jsonAntPersonales = Ext.util.JSON.decode(result.responseText);
                                        UtilCargarAntecedentesOfiClinic001(jsonAntPersonales.data);
                                    },
                                    scope:this
                                });
                            },
                            scope:this
                        });
                    }
                }
            }
        });
        winHCProcedimientos4505Ui.superclass.initComponent.call(this);
    }
});

function fnGuardarRegistrosMedicinaGeneral(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc2013.php',
            params:{
                task: 'guardar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pidPlantillaHC : Ext.getCmp('sysIdCodPlantillaHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalProc').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1Proc').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2Proc').getValue(),
                pAmbito: Ext.getCmp('sysAmbitoProc').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadProcedimientoProc').getValue(),
                pPersona: Ext.getCmp('sysPersonalAtiendeProcedimientoProc').getValue(),
                pForma: Ext.getCmp('sysFormaRealizaProcedimientoProc').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue(),
                pOcupacion4505: Ext.getCmp('strOcupacionHC').getValue(),
                pEtnia4505: Ext.getCmp('intEtniaHC').getValue(),
                pEscolaridad4505: Ext.getCmp('intEscolaridadHC').getValue(),
                pGestacion4505: Ext.getCmp('intIdentificacionRiesgoGestacion').getValue(),
                pSifilisGestacional4505: Ext.getCmp('intIdentificacionRiesgoSifilisGestacional').getValue(),
                pHipertencionGestacional4505: Ext.getCmp('intIdentificacionRiesgoHipertencionGestacional').getValue(),
                pHipotiroidismoCongenito4505: Ext.getCmp('intIdentificacionRiesgoHipotiroidismoCongenito').getValue(),
                pTuberculosisMultidrogoresistente4505: Ext.getCmp('intIdentificacionRiesgoTuberculosisMultidrogoresistente').getValue(),
                pLepra4505: Ext.getCmp('intIdentificacionRiesgoLepra').getValue(),
                pVictimaMaltrato4505: Ext.getCmp('intIdentificacionRiesgoVictimaMaltrato').getValue(),
                pViolenciaSexual4505: Ext.getCmp('intIdentificacionRiesgoViolenciaSexual').getValue(),
                pFluorosisDental4505: Ext.getCmp('intIdentificacionRiesgoFluorosisDental').getValue(),
                pCitologia4505: Ext.getCmp('sysCitologia4505').getValue(),
                pColposcopia4505: Ext.getCmp('sysColposcopia4505').getValue(),
                pBiopsiaCervical4505: Ext.getCmp('sysBiopsiaCervical4505').getValue(),
                pMamografia4505: Ext.getCmp('sysMamografia4505').getValue(),
                pBiopsiaSeno4505: Ext.getCmp('sysBiopsiaSeno4505').getValue(),
                pResultadoCitologia4505: Ext.getCmp('intResultadoCitologia').getValue(),
                pCalidadMuestraCitologia4505: Ext.getCmp('intCalidadMuestraCitologia').getValue(),
                pCodIPSTomaCitologia4505: Ext.getCmp('intCodIPSTomaCitologia').getValue(),
                pCodIPSTomaColposcopia4505: Ext.getCmp('intCodIPSTomaColposcopia').getValue(),
                pResultadoBiopsiaCervical4505: Ext.getCmp('intResultadoBiopsiaCervical').getValue(),
                pCodIPSTomaBiopsiaCervical4505: Ext.getCmp('intCodIPSTomaBiopsiaCervical').getValue(),
                pResultadoMamografia4505: Ext.getCmp('intResultadoMamografia').getValue(),
                pCodIPSTomaMamografia4505: Ext.getCmp('intCodIPSTomaMamografia').getValue(),
                pResultadoBiopsiaSeno4505: Ext.getCmp('intResultadoBiopsiaSeno').getValue(),
                pCodIPSTomaBiopsiaSeno4505: Ext.getCmp('intCodIPSTomaBiopsiaSeno').getValue(),
                pBCG: Ext.getCmp('intBCG').getValue(),
                pHepatitisB: Ext.getCmp('intHepatitisB').getValue(),
                pPentavalente: Ext.getCmp('intPentavalente').getValue(),
                pPolio: Ext.getCmp('intPolio').getValue(),
                pDPT: Ext.getCmp('intDPT').getValue(),
                pRotavirus: Ext.getCmp('intRotavirus').getValue(),
                pNeumococo: Ext.getCmp('intNeumococo').getValue(),
                pInfluenza: Ext.getCmp('intInfluenza').getValue(),
                pFiebreAmarilla: Ext.getCmp('intFiebreAmarilla').getValue(),
                pHepatitisA: Ext.getCmp('intHepatitisA').getValue(),
                pTripleViral: Ext.getCmp('intTripleViral').getValue(),
                pVPH: Ext.getCmp('intVPH').getValue(),
                pTD: Ext.getCmp('intTD').getValue(),
                pTomaHemoglobina: Ext.getCmp('fecTomaHemoglobina').getValue(),
                pResultadoHemoglobina: Ext.getCmp('intResultadoHemoglobina').getValue(),
                pTomaCreatinina: Ext.getCmp('fecTomaCreatinina').getValue(),
                pResultadoCreatinina: Ext.getCmp('intResultadoCreatinina').getValue(),
                pTomaHemoglobinaGlicosilada: Ext.getCmp('fecTomaHemoglobinaGlicosilada').getValue(),
                pResultadoHemoglobinaGlicosilada: Ext.getCmp('intResultadoHemoglobinaGlicosilada').getValue(),
                pTomaGlicemia: Ext.getCmp('fecTomaGlicemia').getValue(),
                pTomaMicroalbuminuria: Ext.getCmp('fecTomaMicroalbuminuria').getValue(),
                pTomaHDL: Ext.getCmp('fecTomaHDL').getValue(),
                pTomaBaciloscopiaDiagnostica: Ext.getCmp('fecTomaBaciloscopiaDiagnostica').getValue(),
                pResultadoBaciloscopiaDiagnostica: Ext.getCmp('intResultadoBaciloscopiaDiagnostica').getValue(),
                pSerologia: Ext.getCmp('fecSerologia').getValue(),
                pResultadoSerologia: Ext.getCmp('intResultadoSerologia').getValue(),
                pTomaElisaVIH: Ext.getCmp('fecTomaElisaVIH').getValue(),
                pResultadoElisaVIH: Ext.getCmp('intResultadoElisaVIH').getValue(),
                pTSHNeonatal: Ext.getCmp('fecTSHNeonatal').getValue(),
                pResultadoTSHNeonatal: Ext.getCmp('intResultadoTSHNeonatal').getValue(),
                pGuardarSignos: "SI"
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function fnModificarRegistrosMedicinaGeneral(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc2013.php',
            params:{
                task: 'modificar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalProc').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1Proc').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2Proc').getValue(),
                pAmbito: Ext.getCmp('sysAmbitoProc').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadProcedimientoProc').getValue(),
                pPersona: Ext.getCmp('sysPersonalAtiendeProcedimientoProc').getValue(),
                pForma: Ext.getCmp('sysFormaRealizaProcedimientoProc').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue(),
                pFormulacion: 1,
                pOcupacion4505: Ext.getCmp('strOcupacionHC').getValue(),
                pEtnia4505: Ext.getCmp('intEtniaHC').getValue(),
                pEscolaridad4505: Ext.getCmp('intEscolaridadHC').getValue(),
                pGestacion4505: Ext.getCmp('intIdentificacionRiesgoGestacion').getValue(),
                pSifilisGestacional4505: Ext.getCmp('intIdentificacionRiesgoSifilisGestacional').getValue(),
                pHipertencionGestacional4505: Ext.getCmp('intIdentificacionRiesgoHipertencionGestacional').getValue(),
                pHipotiroidismoCongenito4505: Ext.getCmp('intIdentificacionRiesgoHipotiroidismoCongenito').getValue(),
                pTuberculosisMultidrogoresistente4505: Ext.getCmp('intIdentificacionRiesgoTuberculosisMultidrogoresistente').getValue(),
                pLepra4505: Ext.getCmp('intIdentificacionRiesgoLepra').getValue(),
                pVictimaMaltrato4505: Ext.getCmp('intIdentificacionRiesgoVictimaMaltrato').getValue(),
                pViolenciaSexual4505: Ext.getCmp('intIdentificacionRiesgoViolenciaSexual').getValue(),
                pFluorosisDental4505: Ext.getCmp('intIdentificacionRiesgoFluorosisDental').getValue(),
                pGuardarSignos: "SI",
                pCitologia4505: Ext.getCmp('sysCitologia4505').getValue(),
                pColposcopia4505: Ext.getCmp('sysColposcopia4505').getValue(),
                pBiopsiaCervical4505: Ext.getCmp('sysBiopsiaCervical4505').getValue(),
                pMamografia4505: Ext.getCmp('sysMamografia4505').getValue(),
                pBiopsiaSeno4505: Ext.getCmp('sysBiopsiaSeno4505').getValue(),
                pResultadoCitologia4505: Ext.getCmp('intResultadoCitologia').getValue(),
                pCalidadMuestraCitologia4505: Ext.getCmp('intCalidadMuestraCitologia').getValue(),
                pCodIPSTomaCitologia4505: Ext.getCmp('intCodIPSTomaCitologia').getValue(),
                pCodIPSTomaColposcopia4505: Ext.getCmp('intCodIPSTomaColposcopia').getValue(),
                pResultadoBiopsiaCervical4505: Ext.getCmp('intResultadoBiopsiaCervical').getValue(),
                pCodIPSTomaBiopsiaCervical4505: Ext.getCmp('intCodIPSTomaBiopsiaCervical').getValue(),
                pResultadoMamografia4505: Ext.getCmp('intResultadoMamografia').getValue(),
                pCodIPSTomaMamografia4505: Ext.getCmp('intCodIPSTomaMamografia').getValue(),
                pResultadoBiopsiaSeno4505: Ext.getCmp('intResultadoBiopsiaSeno').getValue(),
                pCodIPSTomaBiopsiaSeno4505: Ext.getCmp('intCodIPSTomaBiopsiaSeno').getValue(),
                pBCG: Ext.getCmp('intBCG').getValue(),
                pHepatitisB: Ext.getCmp('intHepatitisB').getValue(),
                pPentavalente: Ext.getCmp('intPentavalente').getValue(),
                pPolio: Ext.getCmp('intPolio').getValue(),
                pDPT: Ext.getCmp('intDPT').getValue(),
                pRotavirus: Ext.getCmp('intRotavirus').getValue(),
                pNeumococo: Ext.getCmp('intNeumococo').getValue(),
                pInfluenza: Ext.getCmp('intInfluenza').getValue(),
                pFiebreAmarilla: Ext.getCmp('intFiebreAmarilla').getValue(),
                pHepatitisA: Ext.getCmp('intHepatitisA').getValue(),
                pTripleViral: Ext.getCmp('intTripleViral').getValue(),
                pVPH: Ext.getCmp('intVPH').getValue(),
                pTD: Ext.getCmp('intTD').getValue(),
                pTomaHemoglobina: Ext.getCmp('fecTomaHemoglobina').getValue(),
                pResultadoHemoglobina: Ext.getCmp('intResultadoHemoglobina').getValue(),
                pTomaCreatinina: Ext.getCmp('fecTomaCreatinina').getValue(),
                pResultadoCreatinina: Ext.getCmp('intResultadoCreatinina').getValue(),
                pTomaHemoglobinaGlicosilada: Ext.getCmp('fecTomaHemoglobinaGlicosilada').getValue(),
                pResultadoHemoglobinaGlicosilada: Ext.getCmp('intResultadoHemoglobinaGlicosilada').getValue(),
                pTomaGlicemia: Ext.getCmp('fecTomaGlicemia').getValue(),
                pTomaMicroalbuminuria: Ext.getCmp('fecTomaMicroalbuminuria').getValue(),
                pTomaHDL: Ext.getCmp('fecTomaHDL').getValue(),
                pTomaBaciloscopiaDiagnostica: Ext.getCmp('fecTomaBaciloscopiaDiagnostica').getValue(),
                pResultadoBaciloscopiaDiagnostica: Ext.getCmp('intResultadoBaciloscopiaDiagnostica').getValue(),
                pSerologia: Ext.getCmp('fecSerologia').getValue(),
                pResultadoSerologia: Ext.getCmp('intResultadoSerologia').getValue(),
                pTomaElisaVIH: Ext.getCmp('fecTomaElisaVIH').getValue(),
                pResultadoElisaVIH: Ext.getCmp('intResultadoElisaVIH').getValue(),
                pTSHNeonatal: Ext.getCmp('fecTSHNeonatal').getValue(),
                pResultadoTSHNeonatal: Ext.getCmp('intResultadoTSHNeonatal').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function calculoEdadPacienteMeses(){
    var valFecha1 = 0;
    var pFec2Anio = 0;
    var pFec2Mes = 0;
    var pFec2Dia = 0;
    var valFecha2 = 0;
    MesesCumplidos = 0;
    AniosCumplidos = 0;


    valFecha1 = Ext.getCmp('sysFechaHC').getValue();
    pFec2Anio = Ext.getCmp('sysFechaNac').getValue().substr(6,4);
    pFec2Mes = Ext.getCmp('sysFechaNac').getValue().substr(3,2);
    pFec2Dia = Ext.getCmp('sysFechaNac').getValue().substr(0,2);
    
    valFecha2 =  pFec2Anio + "/" + pFec2Mes + "/" + pFec2Dia;

    MesesCumplidos = MostrarEdadMeses(valFecha1, valFecha2);
    
    AniosCumplidos = MostrarEdadAnios(valFecha1, valFecha2);
}

function tipoConsulta4505(){
    
}