/*
* @category    Formulario Modelo Evolucion Epicrisis
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winHCEpicrisis001Ui = Ext.extend(Ext.Window, {
    title: 'eOfiClinic ©  .:: Plantilla HC - Epicrisis ::.',
    width: 990,
    height: 636,
    closable: false,
    resizable: false,
    draggable: false,
    modal: true,
    id: 'winHC',
    initComponent: function() {

        tmpmx = objMX;
        tmpmxadd = objMXADD;
        tmpexa = objEXA;
        tmprem = objREM;
        myPaciente = 0;
        myCAS = 0;
        
        try {
            var campo = Ext.getCmp('sysPacientePlantillaHC');
            if ( campo !== null ) {
                myPaciente = Ext.getCmp('sysPacientePlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myPaciente === 0){
            try {
                var campo1 = Ext.getCmp('sysIdPacienteHC');
                if ( campo1 !== null ) {
                    myPaciente = Ext.getCmp('sysIdPacienteHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myPaciente === 0){
            try {
                var campo5 = Ext.getCmp('sysPacienteRefHC');
                if ( campo5 !== null ) {
                    myPaciente = Ext.getCmp('sysPacienteRefHC').getValue();
                }
            }catch(ex){
            }
        }
        try {
            var campo2 = Ext.getCmp('sysCASPlantillaHC');
            if ( campo2 !== null ) {
                myCAS = Ext.getCmp('sysCASPlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myCAS === 0){
            try {
                var campo3 = Ext.getCmp('sysCASHC');
                if ( campo3 !== null ) {
                    myCAS = Ext.getCmp('sysCASHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myCAS === 0){
            try {
                var campo4 = Ext.getCmp('sysCASRefHC');
                if ( campo4 !== null ) {
                    myCAS = Ext.getCmp('sysCASRefHC').getValue();
                }
            }catch(ex){
            }
        }
        
        if (objMX !== "NA"){
            var xSolMX = eval(objMX);
            Ext.getCmp('gridMedicamentosHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }
        else{
            var xSolMX = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        if (objEXA !== "NA"){
            var xSolEXA = eval(objEXA);
            Ext.getCmp('gridExamenesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }else{
            var xSolEXA = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }    
        if (objREM !== "NA"){
            var xSolREM = eval(objREM);
            Ext.getCmp('gridRemisionesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }else{
            var xSolREM = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        
        var dataDestinoSalida = [
            ['1','ALTA DE URGENCIAS'],
            ['2','REMISION A OTRO NIVEL DE COMPLEJIDAD'],
            ['3','HOSPITALIZACION']
        ];
        var stDestinoSalida = new Ext.data.ArrayStore({
            fields: [
                {name: 'Codigo'},
                {name: 'Descripcion'}
            ]
        });
        stDestinoSalida.loadData(dataDestinoSalida);
            
        var dataEstadoSalida = [
            ['1','VIVO'],
            ['2','MUERTO']
        ];
        var stEstadoSalida = new Ext.data.ArrayStore({
            fields: [
                {name: 'Codigo'},
                {name: 'Descripcion'}
            ]
        });
        stEstadoSalida.loadData(dataEstadoSalida);
        
        var dataCondicionSalida = [
            ['PACIENTE DADO DE ALTA'],
            ['REMISION DE NIVEL COMPLEJIDAD'],
            ['PACIENTE DADO DE FUGA'],
            ['RETIRO VOLUNTARIO']
        ];
        var stCondicionSalida = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stCondicionSalida.loadData(dataCondicionSalida);
        
        this.items = [
            {
                xtype: 'panel',
                frame: true,
                anchor: '100%',
                id: 'panelHC',
                padding: 10,
                border: false,
                height: 610,
                autoScroll: true,
                layout: 'form',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysServicioHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysTipoNotaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysIdCodPlantillaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        value: 1,
                        id: 'sysUsaGridSalida'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        value: 0,
                        id: 'sysYaGuardoHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysPlantillaHC',
                        name: 'PLANTILLA'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptMx'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptExa'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptRem'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Actividad',
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        id: 'sysActividadHC',
                        name: 'PLANTILLA'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Empresa',
                        id: 'sysEmpresaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'IPS',
                        id: 'sysIPSHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Usuario',
                        id: 'sysUsuarioHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Profesional',
                        id: 'sysProfesionalHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Paciente',
                        id: 'sysIdPacienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Apertura',
                        id: 'sysAperturaHC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Cliente',
                        id: 'sysClienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdClienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdPlanHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdSubPlanHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdContratoHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Genero',
                        id: 'sysGeneroPacHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Edad',
                        id: 'sysEdadPacHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Profesional',
                        id: 'sysProfesionalAgendaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'ConsecutivoDetalle',
                        id: 'sysConsecutivoDetalleHC'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'CAS',
                                id: 'sysCASHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysFechaHC',
                                value: 'Fecha: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysFechaHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysHoraHC',
                                value: 'Hora: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysHoraHC'
                            },
                            {
                                xtype: 'hidden',
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysLegalizaHC'
                            }
                        ]
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Paciente',
                        value: 'CC 792558261  - JORGE GALEANO RUIZ - (Masculino) FechaNac: 1973-01-30, Edad 38 Años',
                        id: 'sysPacienteHC'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                width: 100,
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'Genero',
                                id: 'sysGeneroHC'
                            },
                            {
                                html: 'Fecha Nac:'
                            },
                            {
                                xtype: 'textfield',
                                width: 100,
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysFechaNac'
                            },
                            {
                                html: 'Edad:'
                            },
                            {
                                xtype: 'textfield',
                                width: 350,
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysEdadHC'
                            }
                        ]
                    },
                    {
                        xtype: 'hidden',
                        width: 370,
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Ocupación',
                        id: 'sysOcupacionHC'
                    },
                    {
                        xtype: 'hidden',
                        width: 370,
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysDiscapacidadHC'
                    },
                    {
                        xtype: 'hidden',
                        width: 370,
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Estado Civil',
                        id: 'strEstadoCivilHC'
                    },
                    {
                        xtype: 'hidden',
                        width: 380,
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysEscolaridadHC'
                    },
                    {
                        xtype: 'hidden',
                        width: 370,
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Dirección',
                        id: 'sysDireccionHC'
                    },
                    {
                        xtype: 'hidden',
                        width: 390,
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysTelefonoHC'
                    },
                    {
                        xtype: 'hidden',
                        width: 380,
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Etnia',
                        id: 'sysEtniaHC'
                    },
                    {
                        xtype: 'hidden',
                        width: 390,
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysEstratoHC'
                    },
                    {
                        html: '<hr>',
                        style: 'background:transparent;',
                        border: false
                    },
                    {
                        xtype: 'tabpanel',
                        width: 930,
                        autoHeight: true,
                        border: false,
                        ref: 'fTabPanel',
                        id: 'fTabPanel',
                        activeTab: 0,
                        items: [
                            {
                                xtype: 'panel',
                                title: 'Evolución',
                                autoHeight: true,
                                autoScroll: true,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaEvolucion',
                                layout: 'form',
                                items: [
                                    {
                                        xtype: 'form',
                                        frame: true,
                                        anchor: '100%',
                                        id: 'frmHC',
                                        padding: 10,
                                        border: false,
                                        autoScroll: true,
                                        style: 'background:transparent;',
                                        items: [
                                            /*
                                            {
                                                xtype: 'fieldset',
                                                title: 'EJEMPLO',
                                                layout: 'table',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        width: 850,
                                                        fieldLabel: 'EJEMPLO',
                                                        name: 'EJEMPLO',
                                                        height: 30,
                                                        grow: true,
                                                        minGrow: 30,
                                                        allowBlank: false,
                                                        id: 'memEjemlpo'
                                                    }
                                                ]
                                            }
                                            */
                                            {
                                                xtype: 'fieldset',
                                                title: 'MOTIVO SOLICITUD DEL SERVICIO',
                                                layout: 'table',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        width: 850,
                                                        fieldLabel: 'MOTIVO SOLICITUD DEL SERVICIO',
                                                        name: 'MOTIVO SOLICITUD DEL SERVICIO',
                                                        emptyText: '(percepción del usuario)',
                                                        height: 30,
                                                        grow: true,
                                                        minGrow: 30,
                                                        allowBlank: true,
                                                        id: 'memMotivoSolicitudServicio'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'ESTADO GENERAL AL INGRESO',
                                                layout: 'table',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        width: 850,
                                                        fieldLabel: 'ESTADO GENERAL AL INGRESO',
                                                        name: 'ESTADO GENERAL AL INGRESO',
                                                        emptyText: '(especialmente cuando sea una urgencia)',
                                                        height: 30,
                                                        grow: true,
                                                        minGrow: 30,
                                                        allowBlank: true,
                                                        id: 'memEstadoGeneralIngreso'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'ENFERMEDAD ACTUAL',
                                                layout: 'table',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        width: 850,
                                                        fieldLabel: 'ENFERMEDAD ACTUAL',
                                                        name: 'ENFERMEDAD ACTUAL',
                                                        height: 30,
                                                        grow: true,
                                                        minGrow: 30,
                                                        allowBlank: true,
                                                        id: 'memEnfermedadActual'
                                                    }
                                                ]
                                            },
                                            //{
                                            //    xtype: 'fieldset',
                                            //    title: 'ANTECEDENTES',
                                            //    layout: 'table',
                                            //    collapsible: true,
                                            //    titleCollapse: true,
                                            //    anchor: '100%',
                                            //    autoHeight: true,
                                            //    padding: 7,
                                            //    items: [
                                                    {
                                                        xtype: 'hidden',
                                                        width: 850,
                                                        fieldLabel: 'ANTECEDENTES',
                                                        name: 'ANTECEDENTES',
                                                        height: 30,
                                                        grow: true,
                                                        minGrow: 30,
                                                        allowBlank: true,
                                                        id: 'memAntecedentes'
                                                    },
                                             //   ]
                                            //},
                                            //{
                                            //    xtype: 'fieldset',
                                            //    title: 'REVISION POR SISTEMAS',
                                            //    layout: 'table',
                                            //    collapsible: true,
                                            //    titleCollapse: true,
                                            //    anchor: '100%',
                                            //    autoHeight: true,
                                            //    padding: 7,
                                            //    items: [
                                                    {
                                                        xtype: 'hidden',
                                                        width: 850,
                                                        fieldLabel: 'REVISION POR SISTEMAS',
                                                        name: 'REVISION POR SISTEMAS',
                                                        emptyText: '(relacionada con el motivo que originó el servicio, hallazgos del examen fisico)',
                                                        height: 30,
                                                        grow: true,
                                                        minGrow: 30,
                                                        allowBlank: true,
                                                        id: 'memRevisionSistemas'
                                                    },
                                             //   ]
                                            //},
                                            //{
                                            //    xtype: 'fieldset',
                                            //     title: 'DIAGNOSTICO',
                                            //    layout: 'table',
                                            //    collapsible: true,
                                            //    titleCollapse: true,
                                            //    anchor: '100%',
                                            //    autoHeight: true,
                                            //    padding: 7,
                                            //    items: [
                                                    {
                                                        xtype: 'hidden',
                                                        width: 850,
                                                        fieldLabel: 'DIAGNOSTICO',
                                                        name: 'DIAGNOSTICO',
                                                        emptyText: '(incluir los presuntivos, confirmados y relacionados)',
                                                        height: 30,
                                                        grow: true,
                                                        minGrow: 30,
                                                        allowBlank: true,
                                                        id: 'memDiagnostico'
                                                    },
                                            //    ]
                                            //},
                                            {
                                                xtype: 'fieldset',
                                                title: 'CONDUCTA',
                                                layout: 'table',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        width: 850,
                                                        fieldLabel: 'CONDUCTA',
                                                        name: 'CONDUCTA',
                                                        emptyText: '(incluye la solicitud de procedimientos diagnósticos y el plan de manejo terapéutico)',
                                                        height: 30,
                                                        grow: true,
                                                        minGrow: 30,
                                                        allowBlank: true,
                                                        id: 'memConducta'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'DE LA EVOLUCION',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        width: 850,
                                                        fieldLabel: 'CAMBIOS EN EL ESTADO DEL PACIENTE',
                                                        name: 'DE LA EVOLUCION',
                                                        emptyText: 'cambios que conlleven a modificar la Conducta o el manejo ( se deben incluir complicaciones, accidentes u otro eventos adversos que haya surgido durante la estancia en el servicio de urgencia o de hospitalización)',
                                                        height: 30,
                                                        grow: true,
                                                        minGrow: 30,
                                                        allowBlank: true,
                                                        id: 'memDeLaEvolucion'
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        width: 850,
                                                        fieldLabel: 'RESULTADO PROCEDIMIENTOS DIAGNOSTICOS',
                                                        name: 'RESULTADO PROCEDIMIENTOS DIAGNOSTICOS',
                                                        emptyText: '(que justifiquen los cambios en el manejo o en el diagnóstico)',
                                                        height: 30,
                                                        grow: true,
                                                        minGrow: 30,
                                                        allowBlank: true,
                                                        id: 'memResultadoProcedimientosDiagnosticos'
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        width: 850,
                                                        fieldLabel: 'JUSTIFICACIÓN DE INDICACIONES TERAPÉUTICAS',
                                                        name: 'JUSTIFICACIÓN DE INDICACIONES TERAPÉUTICAS',
                                                        height: 30,
                                                        grow: true,
                                                        minGrow: 30,
                                                        allowBlank: true,
                                                        id: 'memJustificacionIndicacionesMetasTerapeuticas'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'DEL EGRESO',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                labelAlign: 'top',
                                                items: [
                                                    {
                                                        xtype: 'hidden',
                                                        width: 850,
                                                        fieldLabel: 'DIAGNOSTICO',
                                                        name: 'DIAGNOSTICO EGRESO',
                                                        emptyText: '(incluir los presuntivos, confirmados y relacionados)',
                                                        height: 30,
                                                        grow: true,
                                                        minGrow: 30,
                                                        allowBlank: true,
                                                        id: 'memDiagnosticoEgreso'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'CONDICION',
                                                        width: 850,
                                                        name: 'CONDICION',
                                                        allowBlank: true,
                                                        store: stCondicionSalida,
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        id: 'strCondicionesSalida'
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        width: 850,
                                                        fieldLabel: 'CONDICIONES GENERALES SALIDA',
                                                        name: 'CONDICIONES GENERALES SALIDA',
                                                        height: 30,
                                                        grow: true,
                                                        minGrow: 30,
                                                        allowBlank: true,
                                                        id: 'memCondicionesSalida'
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        width: 850,
                                                        fieldLabel: 'PLAN DE MANEJO AMBULATORIO',
                                                        name: 'PLAN DE MANEJO AMBULATORIO',
                                                        height: 30,
                                                        grow: true,
                                                        minGrow: 30,
                                                        allowBlank: true,
                                                        id: 'memPlanManejoAmbulatorio'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'DIAGNOSTICOS, ESTADO Y DESTINO DE LA SALIDA',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                id: 'fsRips',
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: false,
                                                                fieldLabel: 'Diagnostico Principal',
                                                                name: 'Cod. Diagnóstico a la Salida',
                                                                id: 'strDiagPpalHC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('strDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('strDiagRel2HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('strDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request({
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('strDiagPpalHC').setValue(null);
                                                                                            Ext.getCmp('strDiagPpalHCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('strDiagPpalHC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('strDiagPpalHCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('strDiagPpalHC').setValue(null);
                                                                                        Ext.getCmp('strDiagPpalHCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('strDiagPpalHC').setValue(null);
                                                                                Ext.getCmp('strDiagPpalHCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    },
                                                                    blur: function(t){
                                                                        if (Ext.getCmp('strDiagPpalHC').getValue() != "" && Ext.getCmp('strDiagPpalHC').getValue() != null && Ext.getCmp('strDiagPpalHC').getValue().toUpperCase() != Ext.getCmp('strDiagRel1HC').getValue() && Ext.getCmp('strDiagPpalHC').getValue().toUpperCase() != Ext.getCmp('strDiagRel2HC').getValue() && Ext.getCmp('strDiagPpalHC').getValue().toUpperCase() != Ext.getCmp('strDiagRel3HC').getValue()){
                                                                            Ext.Ajax.request({
                                                                                url: '../../controlador/cie10/controlador_cie10.php',
                                                                                params:{
                                                                                    task: 'BUSCAR',
                                                                                    pCodigo: Ext.getCmp('strDiagPpalHC').getValue().toUpperCase()
                                                                                },
                                                                                success: function(response,options)
                                                                                {
                                                                                    var el = Ext.get('response'); // get the LOG
                                                                                    var Respuesta = response.responseText;
                                                                                    var Contenido = Respuesta.split('^');
                                                                                    if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                        Ext.getCmp('strDiagPpalHC').setValue(null);
                                                                                        Ext.getCmp('strDiagPpalHCNom').setValue(null);
                                                                                    } else {
                                                                                        Ext.getCmp('strDiagPpalHC').setValue(Contenido[0].toUpperCase());
                                                                                        Ext.getCmp('strDiagPpalHCNom').setValue(Contenido[1].toUpperCase());
                                                                                    }
                                                                                },
                                                                                failure: function(response,options){
                                                                                    var el = Ext.get('response');
                                                                                    Ext.getCmp('strDiagPpalHC').setValue(null);
                                                                                    Ext.getCmp('strDiagPpalHCNom').setValue(null);
                                                                                },
                                                                                scope:this //bind the callbacks
                                                                            });
                                                                        }else{
                                                                            Ext.getCmp('strDiagPpalHC').setValue(null);
                                                                            Ext.getCmp('strDiagPpalHCNom').setValue(null);
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                name: 'Diagnóstico a la Salida',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'strDiagPpalHCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Principal',
                                                                id: 'btnSearchDiagPpalHC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('strDiagPpalHC','strDiagPpalHCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.1',
                                                                name: 'Cod. Diagnóstico Rel1 a la Salida',
                                                                id: 'strDiagRel1HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('strDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('strDiagRel2HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('strDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('strDiagRel1HC').setValue(null);
                                                                                            Ext.getCmp('strDiagRel1HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('strDiagRel1HC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('strDiagRel1HCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('strDiagRel1HC').setValue(null);
                                                                                        Ext.getCmp('strDiagRel1HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('strDiagRel1HC').setValue(null);
                                                                                Ext.getCmp('strDiagRel1HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    },
                                                                    blur: function(t){
                                                                        if (Ext.getCmp('strDiagRel1HC').getValue() != "" && Ext.getCmp('strDiagRel1HC').getValue() != null && Ext.getCmp('strDiagRel1HC').getValue().toUpperCase() != Ext.getCmp('strDiagPpalHC').getValue() && Ext.getCmp('strDiagRel1HC').getValue().toUpperCase() != Ext.getCmp('strDiagRel2HC').getValue() && Ext.getCmp('strDiagRel1HC').getValue().toUpperCase() != Ext.getCmp('strDiagRel3HC').getValue()){
                                                                            Ext.Ajax.request(
                                                                            {
                                                                                url: '../../controlador/cie10/controlador_cie10.php',
                                                                                params:{
                                                                                    task: 'BUSCAR',
                                                                                    pCodigo: Ext.getCmp('strDiagRel1HC').getValue().toUpperCase()
                                                                                },
                                                                                success: function(response,options)
                                                                                {
                                                                                    var el = Ext.get('response'); // get the LOG
                                                                                    var Respuesta = response.responseText;
                                                                                    var Contenido = Respuesta.split('^');
                                                                                    if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                        Ext.getCmp('strDiagRel1HC').setValue(null);
                                                                                        Ext.getCmp('strDiagRel1HCNom').setValue(null);
                                                                                    } else {
                                                                                        Ext.getCmp('strDiagRel1HC').setValue(Contenido[0].toUpperCase());
                                                                                        Ext.getCmp('strDiagRel1HCNom').setValue(Contenido[1].toUpperCase());
                                                                                    }
                                                                                },
                                                                                failure: function(response,options){
                                                                                    var el = Ext.get('response');
                                                                                    Ext.getCmp('strDiagRel1HC').setValue(null);
                                                                                    Ext.getCmp('strDiagRel1HCNom').setValue(null);
                                                                                },
                                                                                scope:this //bind the callbacks
                                                                            });
                                                                        }else{
                                                                            Ext.getCmp('strDiagRel1HC').setValue(null);
                                                                            Ext.getCmp('strDiagRel1HCNom').setValue(null);
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                name: 'Diagnóstico Rel1 a la Salida',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'strDiagRel1HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado1',
                                                                id: 'btnSearchDiagRel1HC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('strDiagRel1HC','strDiagRel1HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.2',
                                                                name: 'Cod. Diagnóstico Rel2 a la Salida',
                                                                id: 'strDiagRel2HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('strDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('strDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('strDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('strDiagRel2HC').setValue(null);
                                                                                            Ext.getCmp('strDiagRel2HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('strDiagRel2HC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('strDiagRel2HCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('strDiagRel2HC').setValue(null);
                                                                                        Ext.getCmp('strDiagRel2HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('strDiagRel2HC').setValue(null);
                                                                                Ext.getCmp('strDiagRel2HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    },
                                                                    blur: function(t){
                                                                        if (Ext.getCmp('strDiagRel2HC').getValue() != "" && Ext.getCmp('strDiagRel2HC').getValue() != null && Ext.getCmp('strDiagRel2HC').getValue().toUpperCase() != Ext.getCmp('strDiagPpalHC').getValue() && Ext.getCmp('strDiagRel2HC').getValue().toUpperCase() != Ext.getCmp('strDiagRel1HC').getValue() && Ext.getCmp('strDiagRel2HC').getValue().toUpperCase() != Ext.getCmp('strDiagRel3HC').getValue()){
                                                                            Ext.Ajax.request(
                                                                            {
                                                                                url: '../../controlador/cie10/controlador_cie10.php',
                                                                                params:{
                                                                                    task: 'BUSCAR',
                                                                                    pCodigo: Ext.getCmp('strDiagRel2HC').getValue().toUpperCase()
                                                                                },
                                                                                success: function(response,options)
                                                                                {
                                                                                    var el = Ext.get('response'); // get the LOG
                                                                                    var Respuesta = response.responseText;
                                                                                    var Contenido = Respuesta.split('^');
                                                                                    if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                        Ext.getCmp('strDiagRel2HC').setValue(null);
                                                                                        Ext.getCmp('strDiagRel2HCNom').setValue(null);
                                                                                    } else {
                                                                                        Ext.getCmp('strDiagRel2HC').setValue(Contenido[0].toUpperCase());
                                                                                        Ext.getCmp('strDiagRel2HCNom').setValue(Contenido[1].toUpperCase());
                                                                                    }
                                                                                },
                                                                                failure: function(response,options){
                                                                                    var el = Ext.get('response');
                                                                                    Ext.getCmp('strDiagRel2HC').setValue(null);
                                                                                    Ext.getCmp('strDiagRel2HCNom').setValue(null);
                                                                                },
                                                                                scope:this //bind the callbacks
                                                                            });
                                                                        }else{
                                                                            Ext.getCmp('strDiagRel2HC').setValue(null);
                                                                            Ext.getCmp('strDiagRel2HCNom').setValue(null);
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                name: 'Diagnóstico Rel2 a la Salida',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'strDiagRel2HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado2',
                                                                id: 'btnSearchDiagRel2HC1',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('strDiagRel2HC','strDiagRel2HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.3',
                                                                name: 'Cod. Diagnóstico Rel3 a la Salida',
                                                                id: 'strDiagRel3HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('strDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('strDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('strDiagRel2HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('strDiagRel3HC').setValue(null);
                                                                                            Ext.getCmp('strDiagRel3HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('strDiagRel3HC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('strDiagRel3HCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('strDiagRel3HC').setValue(null);
                                                                                        Ext.getCmp('strDiagRel3HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('strDiagRel3HC').setValue(null);
                                                                                Ext.getCmp('strDiagRel3HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    },
                                                                    blur: function(t){
                                                                        if (Ext.getCmp('strDiagRel3HC').getValue() != "" && Ext.getCmp('strDiagRel3HC').getValue() != null && Ext.getCmp('strDiagRel3HC').getValue().toUpperCase() != Ext.getCmp('strDiagPpalHC').getValue() && Ext.getCmp('strDiagRel3HC').getValue().toUpperCase() != Ext.getCmp('strDiagRel1HC').getValue() && Ext.getCmp('strDiagRel3HC').getValue().toUpperCase() != Ext.getCmp('strDiagRel2HC').getValue()){
                                                                            Ext.Ajax.request(
                                                                            {
                                                                                url: '../../controlador/cie10/controlador_cie10.php',
                                                                                params:{
                                                                                    task: 'BUSCAR',
                                                                                    pCodigo: Ext.getCmp('strDiagRel3HC').getValue().toUpperCase()
                                                                                },
                                                                                success: function(response,options)
                                                                                {
                                                                                    var el = Ext.get('response'); // get the LOG
                                                                                    var Respuesta = response.responseText;
                                                                                    var Contenido = Respuesta.split('^');
                                                                                    if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                        Ext.getCmp('strDiagRel3HC').setValue(null);
                                                                                        Ext.getCmp('strDiagRel3HCNom').setValue(null);
                                                                                    } else {
                                                                                        Ext.getCmp('strDiagRel3HC').setValue(Contenido[0].toUpperCase());
                                                                                        Ext.getCmp('strDiagRel3HCNom').setValue(Contenido[1].toUpperCase());
                                                                                    }
                                                                                },
                                                                                failure: function(response,options){
                                                                                    var el = Ext.get('response');
                                                                                    Ext.getCmp('strDiagRel3HC').setValue(null);
                                                                                    Ext.getCmp('strDiagRel3HCNom').setValue(null);
                                                                                },
                                                                                scope:this //bind the callbacks
                                                                            });
                                                                        }else{
                                                                            Ext.getCmp('strDiagRel3HC').setValue(null);
                                                                            Ext.getCmp('strDiagRel3HCNom').setValue(null);
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                name: 'Diagnóstico Rel3 a la Salida',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'strDiagRel3HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado3',
                                                                id: 'btnSearchDiagRel3HC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('strDiagRel3HC','strDiagRel3HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Complicacion',
                                                                name: 'Cod. Diagnóstico Complicacion',
                                                                id: 'strDiagComplicaHC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('strDiagComplicaHC').setValue(null);
                                                                                            Ext.getCmp('strDiagComplicaHCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('strDiagComplicaHC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('strDiagComplicaHCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('strDiagComplicaHC').setValue(null);
                                                                                        Ext.getCmp('strDiagComplicaHCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('strDiagComplicaHC').setValue(null);
                                                                                Ext.getCmp('strDiagComplicaHCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    },
                                                                    blur: function(t){
                                                                        if (Ext.getCmp('strDiagComplicaHC').getValue() != "" && Ext.getCmp('strDiagComplicaHC').getValue() != null){
                                                                            Ext.Ajax.request(
                                                                            {
                                                                                url: '../../controlador/cie10/controlador_cie10.php',
                                                                                params:{
                                                                                    task: 'BUSCAR',
                                                                                    pCodigo: Ext.getCmp('strDiagComplicaHC').getValue().toUpperCase()
                                                                                },
                                                                                success: function(response,options)
                                                                                {
                                                                                    var el = Ext.get('response'); // get the LOG
                                                                                    var Respuesta = response.responseText;
                                                                                    var Contenido = Respuesta.split('^');
                                                                                    if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                        Ext.getCmp('strDiagComplicaHC').setValue(null);
                                                                                        Ext.getCmp('strDiagComplicaHCNom').setValue(null);
                                                                                    } else {
                                                                                        Ext.getCmp('strDiagComplicaHC').setValue(Contenido[0].toUpperCase());
                                                                                        Ext.getCmp('strDiagComplicaHCNom').setValue(Contenido[1].toUpperCase());
                                                                                    }
                                                                                },
                                                                                failure: function(response,options){
                                                                                    var el = Ext.get('response');
                                                                                    Ext.getCmp('strDiagComplicaHC').setValue(null);
                                                                                    Ext.getCmp('strDiagComplicaHCNom').setValue(null);
                                                                                },
                                                                                scope:this //bind the callbacks
                                                                            });
                                                                        }else{
                                                                            Ext.getCmp('strDiagComplicaHC').setValue(null);
                                                                            Ext.getCmp('strDiagComplicaHCNom').setValue(null);
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                name: 'Diagnóstico Complicacion',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'strDiagComplicaHCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Complicacion',
                                                                id: 'btnSearchDiagComplicaHC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('strDiagComplicaHC','strDiagComplicaHCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Estado Salida',
                                                        width:750,
                                                        name: 'Estado Salida',
                                                        allowBlank: false,
                                                        store: stEstadoSalida,
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        id: 'strEstadoSalidaHC',
                                                        listeners: {
                                                            select: function(cmb, rec, idx) {
                                                                if(Ext.getCmp('sysServicioHC').getValue() !== "H"){
                                                                    if(parseInt(cmb.getValue()) === 2){
                                                                        Ext.getCmp('strDiagCausaMuerteHC').allowBlank = false;
                                                                        Ext.getCmp('strDiagCausaMuerteHC').setDisabled(false);
                                                                        Ext.getCmp('btnSearchDiagCausaMuerteHC').setDisabled(false);
                                                                        Ext.getCmp('strDestinoSalidaHC').allowBlank = true;
                                                                        Ext.getCmp('strDestinoSalidaHC').setValue(null);
                                                                        Ext.getCmp('strDestinoSalidaHC').setDisabled(true);
                                                                        Ext.getCmp('strDestinoSalidaHC').clearInvalid();
                                                                    }else{
                                                                        Ext.getCmp('strDiagCausaMuerteHC').allowBlank = true;
                                                                        Ext.getCmp('strDiagCausaMuerteHC').setDisabled(true);
                                                                        Ext.getCmp('btnSearchDiagCausaMuerteHC').setDisabled(true);
                                                                        Ext.getCmp('strDiagCausaMuerteHC').clearInvalid();
                                                                        Ext.getCmp('strDiagCausaMuerteHC').setValue(null);
                                                                        Ext.getCmp('strDiagCausaMuerteHCNom').setValue(null);
                                                                        Ext.getCmp('strDestinoSalidaHC').allowBlank = false;
                                                                        Ext.getCmp('strDestinoSalidaHC').setDisabled(false);
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Destino Salida',
                                                        width:750,
                                                        name: 'Destino Salida',
                                                        allowBlank: false,
                                                        store: stDestinoSalida,
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        id: 'strDestinoSalidaHC'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                fieldLabel: 'Diagnostico Causa Muerte',
                                                                name: 'Cod. Diagnóstico Causa Muerte',
                                                                id: 'strDiagCausaMuerteHC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('strDiagCausaMuerteHC').setValue(null);
                                                                                            Ext.getCmp('strDiagCausaMuerteHCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('strDiagCausaMuerteHC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('strDiagCausaMuerteHCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('strDiagCausaMuerteHC').setValue(null);
                                                                                        Ext.getCmp('strDiagCausaMuerteHCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('strDiagCausaMuerteHC').setValue(null);
                                                                                Ext.getCmp('strDiagCausaMuerteHCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    },
                                                                    blur: function(t){
                                                                        if (Ext.getCmp('strDiagCausaMuerteHC').getValue() != "" && Ext.getCmp('strDiagCausaMuerteHC').getValue() != null){
                                                                            Ext.Ajax.request(
                                                                            {
                                                                                url: '../../controlador/cie10/controlador_cie10.php',
                                                                                params:{
                                                                                    task: 'BUSCAR',
                                                                                    pCodigo: Ext.getCmp('strDiagCausaMuerteHC').getValue().toUpperCase()
                                                                                },
                                                                                success: function(response,options)
                                                                                {
                                                                                    var el = Ext.get('response'); // get the LOG
                                                                                    var Respuesta = response.responseText;
                                                                                    var Contenido = Respuesta.split('^');
                                                                                    if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                        Ext.getCmp('strDiagCausaMuerteHC').setValue(null);
                                                                                        Ext.getCmp('strDiagCausaMuerteHCNom').setValue(null);
                                                                                    } else {
                                                                                        Ext.getCmp('strDiagCausaMuerteHC').setValue(Contenido[0].toUpperCase());
                                                                                        Ext.getCmp('strDiagCausaMuerteHCNom').setValue(Contenido[1].toUpperCase());
                                                                                    }
                                                                                },
                                                                                failure: function(response,options){
                                                                                    var el = Ext.get('response');
                                                                                    Ext.getCmp('strDiagCausaMuerteHC').setValue(null);
                                                                                    Ext.getCmp('strDiagCausaMuerteHCNom').setValue(null);
                                                                                },
                                                                                scope:this //bind the callbacks
                                                                            });
                                                                        }else{
                                                                            Ext.getCmp('strDiagCausaMuerteHC').setValue(null);
                                                                            Ext.getCmp('strDiagCausaMuerteHCNom').setValue(null);
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                name: 'Diagnóstico Causa Muerte',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'strDiagCausaMuerteHCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                disabled: true,
                                                                tooltip: 'Buscar Diagnostico Complicacion',
                                                                id: 'btnSearchDiagCausaMuerteHC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('strDiagCausaMuerteHC','strDiagCausaMuerteHCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'datefield',
                                                                fieldLabel: 'Fecha Salida',
                                                                name: 'Fecha Salida',
                                                                width: 120,
                                                                allowBlank: false,
                                                                style: 'text-align:center;',
                                                                emptyText: '(dia/mes/año) ',
                                                                id: 'strFechaSalidaHC'
                                                            },
                                                            {
                                                                html: 'Hora Cita'
                                                            },
                                                            {
                                                                xtype: 'timefield',
                                                                name: 'Hora Salida',      
                                                                width: 90,
                                                                allowBlank: false,
                                                                forceSelection: false,
                                                                minValue: '00:00 AM',
                                                                maxValue: '23:59 PM',
                                                                emptyText: 'p.e. 15:25',
                                                                format:'H:i',
                                                                id: 'strHoraSalidaHC'
                                                            }
                                                        ]
                                                    }                            
                                                ]
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Medicamentos',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaMedicamentos',
                                items: [
                                    xSolMX
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Servicios',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaServicios',
                                items: [
                                    xSolEXA
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Remisiones',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaRemisiones',
                                items: [
                                    xSolREM
                                ]
                            }
                            /*,
                            {
                                xtype: 'panel',
                                title: 'Solicitud CTC',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaCTC',
                                items: [
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Consentimientos Informados',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaConsentimientos',
                                items: [
                                ]
                            },*/
                        ]
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btnSalirEvolucion',
                            listeners:{
                                click : function(){
                                    if (parseInt(Ext.getCmp('sysYaGuardoHC').getValue()) === 1){ 
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn){
                                                if(btn === "yes"){
                                                    if (Ext.getCmp('sysUsaGridSalida').getValue() === 1){
                                                        Ext.getCmp('gridFormulario').store.reload();
                                                    }
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    }else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Usted No ha Guardado la Evolución del Paciente y Se Perdera la Información, Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn){
                                                if(btn === "yes"){
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                },
                tbar:{
                    items: [
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Ver Historia Clínica',
                            iconCls: 'btnVerHC',
                            id: 'btnVerHC',
                            listeners:{
                                click : function(){
                                    var cmpResumenHC = new winFrmVerHistorialHC({
                                        renderTo: Ext.getBody()
                                    });
                                    Ext.getCmp('winViewEvolucionHC').title = "PACIENTE: " + Ext.getCmp('sysPacienteHC').getValue();
                                    Ext.getCmp('gridHistorialEvoluciones').store.load({
                                        params: {
                                            pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                                            pPaciente: Ext.getCmp('sysIdPacienteHC').getValue()
                                        }
                                    });
                                    cmpResumenHC.show();
                                }
                            }
                        },
                        {
                            xtype: 'tbseparator'
                        },        
                        {
                            xtype: 'button',
                            text: 'Ver Observacion/Hospitalizacion',
                            iconCls: 'btnVerHCObservaHospitaliza',
                            id: 'btnVerObservaHospitalizaEpicHC',
                            listeners:{
                                click : function(){
                                    var cmpResumenHC = new winViewEvolucionObservaHospitalizaHC({
                                        renderTo: Ext.getBody()
                                    });
                                    Ext.getCmp('sysEmpresaViewObservaHospitaliza').setValue(Ext.getCmp('sysEmpresaHC').getValue());
                                    Ext.getCmp('sysPacienteViewObservaHospitaliza').setValue(Ext.getCmp('sysIdPacienteHC').getValue());
                                    Ext.getCmp('winViewEvolucionObservaHospitalizaHC').title = "PACIENTE: " + Ext.getCmp('sysPacienteHC').getValue();
                                    Ext.getCmp('gridHistorialEvolucionesObservaHospitaliza').store.load({
                                        params: {
                                            pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                                            pPaciente: Ext.getCmp('sysIdPacienteHC').getValue()
                                        }
                                    });
                                    cmpResumenHC.show();
                                }
                            }
                        },
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar Evolución',
                            iconCls: 'btnGuardar',
                            id: 'btnGuardarEvolucion',
                            listeners:{
                                click : function(){
                                    if(parseInt(Ext.getCmp('sysYaGuardoHC').getValue()) === 0){
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Guardar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn){
                                                if(btn === "yes"){
                                                    fnGuardarRegistrosEpicrisis();
                                                }
                                            }
                                        });
                                    }else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Modificar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn){
                                                if(btn === "yes"){
                                                    fnModificarRegistrosEpicrisis();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                }
            }
        ];
        this.on({
            afterlayout:{
                scope:this, 
                single:true, 
                fn:function() {
                    Ext.Msg.hide();
                    Ext.Ajax.request({
                        url: '../../controlador/asistencial/controlador_observahospitaliza.php',
                        waitMsg: 'Cargando Información...',
                        params:{
                            pCAS: Ext.getCmp('sysCASHC').getValue(),
                            pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                            task: 'ImportarEpicrisisOrigenAtencion'
                        },
                        success: function(result, request)
                        {
                            var jsonOrigenEpicrisis = Ext.util.JSON.decode(result.responseText);
                            CargarDataEpicrisis(jsonOrigenEpicrisis.data.sysEvolucion);
                        },
                        scope:this
                    });
                    if(Ext.getCmp('sysServicioHC').getValue() === "H"){
                        Ext.getCmp('strEstadoSalidaHC').clearInvalid();
                        Ext.getCmp('strDestinoSalidaHC').clearInvalid();
                        Ext.getCmp('strEstadoSalidaHC').allowBlank = true;
                        Ext.getCmp('strDestinoSalidaHC').allowBlank = true;
                        Ext.getCmp('strEstadoSalidaHC').setValue(null);
                        Ext.getCmp('strDestinoSalidaHC').getValue(null);
                        //Ext.getCmp('strEstadoSalidaHC').setDisabled(true);
                        Ext.getCmp('strDestinoSalidaHC').setDisabled(true);
                    }
                }
            }
        });
        winHCEpicrisis001Ui.superclass.initComponent.call(this);
    }
});

function fnGuardarRegistrosEpicrisis(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/controlador_observahospitaliza.php',
            params:{
                task: 'guardar_epicrisis',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pidPlantillaHC : Ext.getCmp('sysIdCodPlantillaHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('strDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('strDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('strDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('strDiagRel3HC').getValue(),
                pDiagComplica: Ext.getCmp('strDiagComplicaHC').getValue(),
                pEstadoSalida: Ext.getCmp('strEstadoSalidaHC').getValue(),
                pDestinoSalida: Ext.getCmp('strDestinoSalidaHC').getValue(),
                pCausaMuerte: Ext.getCmp('strDiagCausaMuerteHC').getValue(),
                pFechaSalida: Ext.getCmp('strFechaSalidaHC').getValue(),
                pHoraSalida: Ext.getCmp('strHoraSalidaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue()
            },
            success: function(res,req){
                switch(req.result.requestedId){
                    case "0":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1); 
                        Ext.getCmp('sysConsecutivoDetalleHC').setValue(req.result.requestedId); 
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function fnModificarRegistrosEpicrisis(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/controlador_observahospitaliza.php',
            params:{
                task: 'modificar_epicrisis',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('strDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('strDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('strDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('strDiagRel3HC').getValue(),
                pDiagComplica: Ext.getCmp('strDiagComplicaHC').getValue(),
                pEstadoSalida: Ext.getCmp('strEstadoSalidaHC').getValue(),
                pDestinoSalida: Ext.getCmp('strDestinoSalidaHC').getValue(),
                pCausaMuerte: Ext.getCmp('strDiagCausaMuerteHC').getValue(),
                pFechaSalida: Ext.getCmp('strFechaSalidaHC').getValue(),
                pHoraSalida: Ext.getCmp('strHoraSalidaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}
