/*
* @category    Formulario Modelo Evolucion Historia Clinica Notas Enfermeria Hospitalizacion - Observacion
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winHCNotaEnfermeriaUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic ©  .:: Plantilla HC - Notas Enfermeria - Hospitalizacion ::.',
    width: 990,
    height: 636,
    closable: false,
    resizable: false,
    draggable: false,
    modal: true,
    id: 'winHCEnf',
    initComponent: function() {
        
        myPaciente = 0;
        myCAS = 0;

        try {
            var campo = Ext.getCmp('sysPacientePlantillaHC');
            if ( campo !== null ) {
                myPaciente = Ext.getCmp('sysPacientePlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myPaciente === 0){
            try {
                var campo1 = Ext.getCmp('sysIdPacienteHC');
                if ( campo1 !== null ) {
                    myPaciente = Ext.getCmp('sysIdPacienteHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myPaciente === 0){
            try {
                var campo5 = Ext.getCmp('sysPacienteRefHC');
                if ( campo5 !== null ) {
                    myPaciente = Ext.getCmp('sysPacienteRefHC').getValue();
                }
            }catch(ex){
            }
        }
        try {
            var campo2 = Ext.getCmp('sysCASPlantillaHC');
            if ( campo2 !== null ) {
                myCAS = Ext.getCmp('sysCASPlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myCAS === 0){
            try {
                var campo3 = Ext.getCmp('sysCASHC');
                if ( campo3 !== null ) {
                    myCAS = Ext.getCmp('sysCASHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myCAS === 0){
            try {
                var campo4 = Ext.getCmp('sysCASRefHC');
                if ( campo4 !== null ) {
                    myCAS = Ext.getCmp('sysCASRefHC').getValue();
                }
            }catch(ex){
            }
        }
        
        //
        this.items = [
            {
                xtype: 'panel',
                frame: true,
                anchor: '100%',
                id: 'panelHC',
                border: false,
                height: 570,
                autoScroll: true,
                layout: 'form',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'tabpanel',
                        anchor: '99%',
                        autoHeight: true,
                        border: false,
                        enableTabScroll: true,
                        ref: 'fTabPanel',
                        id: 'fTabPanelEnf',
                        activeTab: 0,
                        items: [
                            {
                                xtype: 'panel',
                                title: 'Evolución',
                                autoHeight: true,
                                autoScroll: true,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaEvolucionEnf',
                                layout: 'form',
                                items: [
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysServicioEnfHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysTipoNotaEnfHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysIdCodPlantillaEnfHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        value: 1,
                                        id: 'sysUsaGridSalidaEnf'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                                        value: 0,
                                        id: 'sysYaGuardoEnfHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Plantilla',
                                        id: 'sysPlantillaEnfHC',
                                        name: 'PLANTILLA'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysRutaRptHCEnf'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysRutaRptMxEnf'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysRutaRptExaEnf'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysRutaRptRemEnf'
                                    },
                                    {
                                        xtype: 'textfield',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Actividad',
                                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                                        id: 'sysActividadEnfHC',
                                        name: 'PLANTILLA'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Empresa',
                                        id: 'sysEmpresaEnfHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'IPS',
                                        id: 'sysIPSEnfHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Usuario',
                                        id: 'sysUsuarioEnfHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Profesional',
                                        id: 'sysProfesionalEnfHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Paciente',
                                        id: 'sysIdPacienteEnfHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Apertura',
                                        id: 'sysAperturaEnfHC'
                                    },
                                    {
                                        xtype: 'textfield',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Cliente',
                                        id: 'sysClienteEnfHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Plantilla',
                                        id: 'sysIdClienteEnfHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Plantilla',
                                        id: 'sysIdPlanEnfHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Plantilla',
                                        id: 'sysIdSubPlanEnfHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Plantilla',
                                        id: 'sysIdContratoEnfHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Genero',
                                        id: 'sysGeneroPacEnfHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Edad',
                                        id: 'sysEdadPacEnfHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Profesional',
                                        id: 'sysProfesionalAgendaEnfHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'ConsecutivoDetalle',
                                        id: 'sysConsecutivoDetalleEnfHC'
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'CAS',
                                                id: 'sysCASEnfHC'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysFechaEnfHC',
                                                value: 'Fecha: '
                                            },
                                            {
                                                xtype: 'textfield',
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysFechaEnfHC'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysHoraEnfHC',
                                                value: 'Hora: '
                                            },
                                            {
                                                xtype: 'textfield',
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysHoraEnfHC'
                                            },
                                            {
                                                xtype: 'hidden',
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysLegalizaEnfHC'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'textfield',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Paciente',
                                        value: 'CC 792558261  - JORGE GALEANO RUIZ - (Masculino) FechaNac: 1973-01-30, Edad 38 Años',
                                        id: 'sysPacienteEnfHC'
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 100,
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Genero',
                                                id: 'sysGeneroEnfHC'
                                            },
                                            {
                                                html: 'Fecha Nac:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 100,
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysFechaEnfNac'
                                            },
                                            {
                                                html: 'Edad:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 350,
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysEdadEnfHC'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'hidden',
                                        width: 370,
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Ocupación',
                                        id: 'sysOcupacionEnfHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        width: 370,
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysDiscapacidadEnfHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        width: 370,
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Estado Civil',
                                        id: 'sysEstadoCivilEnfHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        width: 380,
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysEscolaridadEnfHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        width: 370,
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Dirección',
                                        id: 'sysDireccionEnfHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        width: 390,
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysTelefonoEnfHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        width: 380,
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Etnia',
                                        id: 'sysEtniaEnfHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        width: 390,
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysEstratoEnfHC'
                                    },
                                    {
                                        html: '<hr>',
                                        style: 'background:transparent;',
                                        border: false
                                    },
                                    {
                                        xtype: 'form',
                                        frame: true,
                                        anchor: '100%',
                                        id: 'frmHCEnf',
                                        padding: 10,
                                        border: false,
                                        autoScroll: true,
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'panel',
                                                title: 'RESUMEN ULTIMA ATENCION',
                                                collapsible: true,
                                                titleCollapse: true,
                                                autoScroll: true,
                                                closable: false,
                                                anchor: '100%',
                                                autoHeight: true,
                                                style: 'color:#999;',
                                                id: 'viewResumenUltimaAtencionEnfHC'
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'NOTA ENFERMERIA DE EVOLUCION',
                                                layout: 'table',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        width: 850,
                                                        fieldLabel: 'NOTA ENFERMERIA DE EVOLUCION',
                                                        name: 'NOTA ENFERMERIA',
                                                        height: 150,
                                                        grow: true,
                                                        minGrow: 30,
                                                        allowBlank: false,
                                                        id: 'memNotaEnfermeria'
                                                    }
                                                ]
                                            }
                                        ]
                                    }
                                ]
                            }
                        ]
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btnSalirEvolucionEnf',
                            listeners:{
                                click : function(){
                                    if (parseInt(Ext.getCmp('sysYaGuardoEnfHC').getValue()) === 1)
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn){
                                                if(btn === "yes"){
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHCEnf').close();
                                                }
                                            }
                                        });
                                    else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Usted No ha Guardado la Evolución del Paciente y Se Perdera la Información, Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn){
                                                if(btn === "yes"){
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHCEnf').close();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                },
                tbar:{
                    items: [
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Ver Historia Clínica',
                            iconCls: 'btnVerHC',
                            id: 'btnVerHCEnf',
                            listeners:{
                                click : function(){
                                    var cmpResumenHC = new winFrmVerHistorialHC({
                                        renderTo: Ext.getBody()
                                    });
                                    Ext.getCmp('winViewEvolucionHC').title = "PACIENTE: " + Ext.getCmp('sysPacienteEnfHC').getValue();
                                    Ext.getCmp('gridHistorialEvoluciones').store.load({
                                        params: {
                                            pEmpresa: Ext.getCmp('sysEmpresaEnfHC').getValue(),
                                            pPaciente: Ext.getCmp('sysIdPacienteEnfHC').getValue()
                                        }
                                    });
                                    cmpResumenHC.show();
                                }
                            }
                        },
                        {
                            xtype: 'tbseparator'
                        },        
                        {
                            xtype: 'button',
                            text: 'Ver Observacion/Hospitalizacion',
                            iconCls: 'btnVerHCObservaHospitaliza',
                            id: 'btnVerObservaHospitalizaEnfHC',
                            listeners:{
                                click : function(){
                                    var cmpResumenHC = new winViewEvolucionObservaHospitalizaHC({
                                        renderTo: Ext.getBody()
                                    });
                                    Ext.getCmp('sysEmpresaViewObservaHospitaliza').setValue(Ext.getCmp('sysEmpresaEnfHC').getValue());
                                    Ext.getCmp('sysPacienteViewObservaHospitaliza').setValue(Ext.getCmp('sysIdPacienteEnfHC').getValue());
                                    Ext.getCmp('winViewEvolucionObservaHospitalizaHC').title = "PACIENTE: " + Ext.getCmp('sysPacienteEnfHC').getValue();
                                    Ext.getCmp('gridHistorialEvolucionesObservaHospitaliza').store.load({
                                        params: {
                                            pEmpresa: Ext.getCmp('sysEmpresaEnfHC').getValue(),
                                            pPaciente: Ext.getCmp('sysIdPacienteEnfHC').getValue()
                                        }
                                    });
                                    cmpResumenHC.show();
                                }
                            }
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar Evolución',
                            iconCls: 'btnGuardar',
                            id: 'btnGuardarEvolucion',
                            listeners:{
                                click : function(){
                                    if (parseInt(Ext.getCmp('sysYaGuardoEnfHC').getValue()) === 0){
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Guardar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn){
                                                if(btn === "yes"){
                                                    fnGuardarRegistrosNotasEnfermeria();
                                                }
                                            }
                                        });
                                    }else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Modificar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn){
                                                if(btn === "yes"){
                                                    fnModificarRegistrosNotasEnfermeria();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                }
            }
        ];
        this.on({
            afterlayout:{scope:this, single:true, fn:function() {
                Ext.Msg.hide();
                var frm = Ext.getCmp('frmHCEnf').getForm();
                frm.doAction('load', {
                    url: '../../controlador/asistencial/controlador_observahospitaliza.php',
                    waitMsg: 'Cargando Información...',
                    params:{
                        pCAS: Ext.getCmp('sysCASEnfHC').getValue(),
                        pPaciente: Ext.getCmp('sysIdPacienteEnfHC').getValue(),
                        task: 'ImportarUltimaAtencion'
                    },
                    success:function(form, action) {
                        Ext.getCmp('viewResumenUltimaAtencionEnfHC').load({
                            url: '../../controlador/asistencial/viewnotasobserbahospitaliza.php?pEmpresa=' + ID_EMPRESA + '&pIPS=' + ID_IPS + '&pPaciente=' + Ext.getCmp('sysIdPacienteEnfHC').getValue() + '&pEvolucion=' + action.result.data[0].ConsecutivoHC,
                            scripts:true,
                            scope:this,
                            nocache: false,
                            text: 'Cargando...'
                        });
                    }
                });
            }}
        });
        winHCNotaEnfermeriaUi.superclass.initComponent.call(this);
    }
});


function fnGuardarRegistrosNotasEnfermeria(){
    var frm = Ext.getCmp('frmHCEnf').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/controlador_observahospitaliza.php',
            params:{
                task: 'guardar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaEnfHC').getValue(),
                pIPS: Ext.getCmp('sysIPSEnfHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteEnfHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalEnfHC').getValue(),
                pCAS: Ext.getCmp('sysCASEnfHC').getValue(),
                pidPlantillaHC : Ext.getCmp('sysIdCodPlantillaEnfHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaEnfHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaEnfHC').getValue(),
                pActividad: Ext.getCmp('sysActividadEnfHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaEnfHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHCEnf').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMxEnf').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExaEnf').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRemEnf').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioEnfHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteEnfHC').getValue(),
                pServicio: Ext.getCmp('sysServicioEnfHC').getValue(),
                pTipoNota: Ext.getCmp('sysTipoNotaEnfHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "0":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoEnfHC').setValue(1); 
                        Ext.getCmp('sysConsecutivoDetalleEnfHC').setValue(req.result.requestedId); 
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function fnModificarRegistrosNotasEnfermeria(){
    var frm = Ext.getCmp('frmHCEnf').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/controlador_observahospitaliza.php',
            params:{
                task: 'modificar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaEnfHC').getValue(),
                pIPS: Ext.getCmp('sysIPSEnfHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteEnfHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalEnfHC').getValue(),
                pCAS: Ext.getCmp('sysCASEnfHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaEnfHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaEnfHC').getValue(),
                pActividad: Ext.getCmp('sysActividadEnfHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaEnfHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHCEnf').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMxEnf').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExaEnf').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRemEnf').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioEnfHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteEnfHC').getValue(),
                pServicio: Ext.getCmp('sysServicioEnfHC').getValue(),
                pTipoNota: Ext.getCmp('sysTipoNotaEnfHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleEnfHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoEnfHC').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}
