/*
* @category    Fieldset Antecedentes Familiares
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


fsRES202AgudezaVisual2022Ui = Ext.extend(Ext.form.FieldSet, {
    anchor: '100%',
    autoHeight: true,
    layout: 'form',
    title: '** AGUDEZA VISUAL **',
    collapseFirst: false,
    collapsible: true,
    animCollapse: true,
    labelWidth: 150,
    titleCollapse: true,
    padding: 0,
    id: 'fsRES202AgudezaVisual',
    initComponent: function() {
        
        var dataRES202AgudezaVisual = [
            //['0','0 - No aplica'],
            ['3','3 - Menor o igual a 20/20 normal'],
            ['4','4 - Entre 20/25 y 20/40'],
            ['5','5 - Mayor o igual de 20/50 hasta 1200 anormal'],
            ['6','6 - Cuenta dedos'],
            ['7','7 - Percepcion de bultos'],
            ['8','8 - Proyeccion y percepcion de luz'],
            ['9','9 - No percibe luz'],
            //['21','21 - Riesgo no evaluado']
        ];
        var stRES202AgudezaVisual = new Ext.data.ArrayStore({
            fields: [
                {name: 'Codigo'},
                {name: 'Descripcion'}
            ]
        });
        stRES202AgudezaVisual.loadData(dataRES202AgudezaVisual);
        

        this.items = [
            {
                xtype: 'hidden',
                fieldLabel: 'Fecha Valoracion',
                allowBlank: true,
                id: 'sysAgudezaVisualValoracion'
            },
            {
                xtype: 'hidden',
                fieldLabel: 'Ojo Izquierdo',
                allowBlank: true,
                id: 'sysAgudezaVisualOjoIzquierdo'
            },
            {
                xtype: 'hidden',
                fieldLabel: 'Ojo Derecho',
                allowBlank: true,
                id: 'sysAgudezaVisualOjoDerecho'
            },
            {
                xtype: 'datefield',
                fieldLabel: 'Fecha Valoracion',
                name: 'AGUDEZA VISUAL - FECHA DE VALORACION',
                width: 110,
                allowBlank: true,
                value: new Date().format('d/m/Y'),
                disabledDates: '',
                emptyText: '(dia/mes/año) ',
                style: 'text-align:center;',
                id: 'fecAgudezaVisualValoracion62'
            },
            {
                xtype: 'combo',
                fieldLabel: 'Ojo Izquierdo',
                name: 'AGUDEZA VISUAL - OJO IZQUIERDO',
                anchor: '100%',
                allowBlank: true,
                store: stRES202AgudezaVisual,
                forceSelection: true,
                triggerAction: 'all',
                typeAhead: true,
                typeAheadDelay: 50,
                mode: 'local',
                valueField: 'Descripcion',
                displayField: 'Descripcion',
                id: 'strAgudezaVisualOjoIzquierdo27'
            },
            {
                xtype: 'combo',
                fieldLabel: 'Ojo Derecho',
                name: 'AGUDEZA VISUAL - OJO DERECHO',
                anchor: '100%',
                allowBlank: true,
                store: stRES202AgudezaVisual,
                forceSelection: true,
                triggerAction: 'all',
                typeAhead: true,
                typeAheadDelay: 50,
                mode: 'local',
                valueField: 'Descripcion',
                displayField: 'Descripcion',
                id: 'strAgudezaVisualOjoDerecho28'
            }
        ];
        this.on({
            afterlayout:{
                scope:this, 
                single:true, 
                fn:function() {
                    var MyDate = new Date();
                    MyDate.setDate(MyDate.getDate() - 360);
                    Ext.getCmp('fecAgudezaVisualValoracion62').setMinValue(MyDate.format("d/m/Y"));
                    Ext.getCmp('fecAgudezaVisualValoracion62').setMaxValue(new Date().format("d/m/Y"));
                }
            }
        });
        fsRES202AgudezaVisual2022Ui.superclass.initComponent.call(this);
    }
});
