/*
* @category    Fieldset Diagnostico Consulta
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


fsDiagnosticosConsulta2022Ui = Ext.extend(Ext.form.FieldSet, {
    anchor: '100%',
    autoHeight: true,
    collapseFirst: false,
    collapsible: true,
    animCollapse: true,
    titleCollapse: true,
    layout: 'form',
    title: 'Diagnosticos de la Atencion',
    padding: 0,
    id: 'fsDiagnosticosConsulta',
    initComponent: function() {
        this.tbar = [
            {
                xtype: 'button',
                text: 'Cargar Datos',
                iconCls: 'btnActualizarGrid',
                listeners: {
                    click : function() {
                        Ext.getCmp('sysTipoDiagosticoHC').store.load();
                        Ext.getCmp('sysFinalidadConsultaHC').store.load();
                        Ext.getCmp('sysCausaExternaHC').store.load();
                    }
                }
            }
        ];
        this.items = [
            {
                xtype: 'combo',
                fieldLabel: 'Finalidad Consulta',
                width:750,
                name: 'Finalidad Consulta',
                allowBlank: false,
                store: 'StoreFinalidadConsulta',
                forceSelection: true,
                triggerAction: 'all',
                typeAhead: true,
                typeAheadDelay: 50,
                mode: 'local',
                valueField: 'Codigo',
                displayField: 'Descripcion',
                emptyText: 'Seleccione....',
                submitValue: true,
                value: 10,
                id: 'sysFinalidadConsultaHC',
                listeners:{
                    change : function( t, newValue, oldValue){
                        if(newValue != "10"){
                            Ext.getCmp('sysCausaExternaHC').setValue("15");
                            Ext.getCmp('sysCausaExternaHC').setReadOnly(true);
                            Ext.getCmp('sysDiagPpalHC').setValue(null);
                            Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                        }else{
                            Ext.getCmp('sysCausaExternaHC').setValue("13");
                            Ext.getCmp('sysCausaExternaHC').setReadOnly(false);
                            Ext.getCmp('sysDiagPpalHC').setValue(null);
                            Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                        }
                    }
                }
            },
            {
                xtype: 'combo',
                fieldLabel: 'Causa Externa',
                width:750,
                name: 'Causa Externa',
                allowBlank: false,
                store: 'StoreCausaExterna',
                forceSelection: true,
                triggerAction: 'all',
                typeAhead: true,
                typeAheadDelay: 50,
                mode: 'local',
                valueField: 'Codigo',
                displayField: 'Descripcion',
                emptyText: 'Seleccione....',
                submitValue: true,
                value: 13,
                id: 'sysCausaExternaHC'
            },
            {
                xtype: 'compositefield',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'textfield',
                        width: 96,
                        allowBlank: false,
                        fieldLabel: 'Diagnostico Principal',
                        id: 'sysDiagPpalHC',
                        listeners:{
                            specialkey: function(f,e){
                                if (e.getKey() === e.ENTER || e.getKey() === e.TAB){
                                    if(Ext.getCmp('sysFinalidadConsultaHC').getValue() != null && Ext.getCmp('sysFinalidadConsultaHC').getValue() != ""){
                                        if (f.getValue() !== "" && f.getValue() !== null && f.getValue().toUpperCase() !== Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() !== Ext.getCmp('sysDiagRel2HC').getValue() && f.getValue().toUpperCase() !== Ext.getCmp('sysDiagRel3HC').getValue()){
                                            Ext.Ajax.request({
                                                url: '../../controlador/cie10/controlador_cie10.php',
                                                params:{
                                                    task: 'BUSCAR',
                                                    pCodigo: f.getValue().toUpperCase(),
                                                    pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                                                    pTipoDx: 1
                                                },
                                                success: function(response,options)
                                                {
                                                    var el = Ext.get('response'); // get the LOG
                                                    var Respuesta = response.responseText;
                                                    var Contenido = Respuesta.split('^');
                                                    if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                        Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                        Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                    } else {
                                                        Ext.getCmp('sysDiagPpalHC').setValue(Contenido[0].toUpperCase());
                                                        Ext.getCmp('sysDiagPpalHCNom').setValue(Contenido[1].toUpperCase());
                                                    }
                                                },
                                                failure: function(response,options){
                                                    var el = Ext.get('response');
                                                    Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                    Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                },
                                                scope:this //bind the callbacks
                                            });
                                        }else{
                                            Ext.getCmp('sysDiagPpalHC').setValue(null);
                                            Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                        }
                                    }else{
                                        Ext.getCmp('sysDiagPpalHC').setValue(null);
                                        Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                    }
                                }
                            },
                            blur: function(t){
                                if(Ext.getCmp('sysFinalidadConsultaHC').getValue() != null && Ext.getCmp('sysFinalidadConsultaHC').getValue() != ""){
                                    if(Ext.getCmp('sysDiagPpalHCNom').getValue() === null || Ext.getCmp('sysDiagPpalHCNom').getValue() === ""){
                                        if (Ext.getCmp('sysDiagPpalHC').getValue() !== "" && Ext.getCmp('sysDiagPpalHC').getValue() !== null && Ext.getCmp('sysDiagPpalHC').getValue().toUpperCase() !== Ext.getCmp('sysDiagRel1HC').getValue() && Ext.getCmp('sysDiagPpalHC').getValue().toUpperCase() !== Ext.getCmp('sysDiagRel2HC').getValue() && Ext.getCmp('sysDiagPpalHC').getValue().toUpperCase() !== Ext.getCmp('sysDiagRel3HC').getValue()){
                                            Ext.Ajax.request({
                                                url: '../../controlador/cie10/controlador_cie10.php',
                                                params:{
                                                    task: 'BUSCAR',
                                                    pCodigo: Ext.getCmp('sysDiagPpalHC').getValue().toUpperCase(),
                                                    pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                                                    pTipoDx: 1
                                                },
                                                success: function(response,options)
                                                {
                                                    var el = Ext.get('response'); // get the LOG
                                                    var Respuesta = response.responseText;
                                                    var Contenido = Respuesta.split('^');
                                                    if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                        Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                        Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                    } else {
                                                        Ext.getCmp('sysDiagPpalHC').setValue(Contenido[0].toUpperCase());
                                                        Ext.getCmp('sysDiagPpalHCNom').setValue(Contenido[1].toUpperCase());
                                                    }
                                                },
                                                failure: function(response,options){
                                                    var el = Ext.get('response');
                                                    Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                    Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                },
                                                scope:this //bind the callbacks
                                            });
                                        }else{
                                            Ext.getCmp('sysDiagPpalHC').setValue(null);
                                            Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                        }
                                    }
                                }else{
                                    Ext.getCmp('sysDiagPpalHC').setValue(null);
                                    Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                }
                            }
                        }
                    },
                    {
                        xtype: 'textarea',
                        readOnly: true,
                        width: 625,
                        height: 22,
                        id: 'sysDiagPpalHCNom'
                    },
                    {
                        xtype: 'button',
                        iconCls: 'btnBuscar',
                        tooltip: 'Buscar Diagnostico Principal',
                        id: 'btnSearchDiagPpalHC',
                        listeners:{
                            click : function(){
                                buscarcie10('sysDiagPpalHC','sysDiagPpalHCNom', Ext.getCmp('sysFinalidadConsultaHC').getValue(), 1);
                            }
                        }
                    }
                ]
            },
            {
                xtype: 'combo',
                fieldLabel: 'Tipo de Diagnostico',
                width:750,
                name: 'Tipo de Diagnostico',
                allowBlank: false,
                store: 'StoreTipoDiagnostico',
                forceSelection: true,
                triggerAction: 'all',
                typeAhead: true,
                typeAheadDelay: 50,
                mode: 'local',
                valueField: 'Codigo',
                displayField: 'Descripcion',
                emptyText: 'Seleccione....',
                submitValue: true,
                id: 'sysTipoDiagosticoHC'
            },
            {
                xtype: 'compositefield',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'textfield',
                        width: 96,
                        allowBlank: true,
                        fieldLabel: 'Diagnostico Relacionado Nro.1',
                        id: 'sysDiagRel1HC',
                        listeners:{
                            specialkey: function(f,e){
                                if (e.getKey() === e.ENTER || e.getKey() === e.TAB)
                                {
                                    if (f.getValue() !== "" && f.getValue() !== null && f.getValue().toUpperCase() !== Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() !== Ext.getCmp('sysDiagRel2HC').getValue() && f.getValue().toUpperCase() !== Ext.getCmp('sysDiagRel3HC').getValue()){
                                        Ext.Ajax.request(
                                        {
                                            url: '../../controlador/cie10/controlador_cie10.php',
                                            params:{
                                                task: 'BUSCAR',
                                                pCodigo: f.getValue().toUpperCase()
                                            },
                                            success: function(response,options)
                                            {
                                                var el = Ext.get('response'); // get the LOG
                                                var Respuesta = response.responseText;
                                                var Contenido = Respuesta.split('^');
                                                if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                    Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                    Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                } else {
                                                    Ext.getCmp('sysDiagRel1HC').setValue(Contenido[0].toUpperCase());
                                                    Ext.getCmp('sysDiagRel1HCNom').setValue(Contenido[1].toUpperCase());
                                                }
                                            },
                                            failure: function(response,options){
                                                var el = Ext.get('response');
                                                Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                            },
                                            scope:this //bind the callbacks
                                        });
                                    }else{
                                        Ext.getCmp('sysDiagRel1HC').setValue(null);
                                        Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                    }
                                }
                            },
                            blur: function(t){
                                if (Ext.getCmp('sysDiagRel1HCNom').getValue === null ||  Ext.getCmp('sysDiagRel1HCNom').getValue() === "")
                                {
                                    if (Ext.getCmp('sysDiagRel1HC').getValue() !== "" && Ext.getCmp('sysDiagRel1HC').getValue() !== null && Ext.getCmp('sysDiagRel1HC').getValue().toUpperCase() !== Ext.getCmp('sysDiagPpalHC').getValue() && Ext.getCmp('sysDiagRel1HC').getValue().toUpperCase() !== Ext.getCmp('sysDiagRel2HC').getValue() && Ext.getCmp('sysDiagRel1HC').getValue().toUpperCase() !== Ext.getCmp('sysDiagRel3HC').getValue()){
                                        Ext.Ajax.request(
                                        {
                                            url: '../../controlador/cie10/controlador_cie10.php',
                                            params:{
                                                task: 'BUSCAR',
                                                pCodigo: Ext.getCmp('sysDiagRel1HC').getValue().toUpperCase()
                                            },
                                            success: function(response,options)
                                            {
                                                var el = Ext.get('response'); // get the LOG
                                                var Respuesta = response.responseText;
                                                var Contenido = Respuesta.split('^');
                                                if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                    Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                    Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                } else {
                                                    Ext.getCmp('sysDiagRel1HC').setValue(Contenido[0].toUpperCase());
                                                    Ext.getCmp('sysDiagRel1HCNom').setValue(Contenido[1].toUpperCase());
                                                }
                                            },
                                            failure: function(response,options){
                                                var el = Ext.get('response');
                                                Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                            },
                                            scope:this //bind the callbacks
                                        });
                                    }else{
                                        Ext.getCmp('sysDiagRel1HC').setValue(null);
                                        Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                    }
                                }
                            }
                        }
                    },
                    {
                        xtype: 'textarea',
                        readOnly: true,
                        width: 625,
                        height: 22,
                        id: 'sysDiagRel1HCNom'
                    },
                    {
                        xtype: 'button',
                        iconCls: 'btnBuscar',
                        tooltip: 'Buscar Diagnostico Relacionado1',
                        id: 'btnSearchDiagRel1HC',
                        listeners:{
                            click : function(){
                                buscarcie10('sysDiagRel1HC','sysDiagRel1HCNom');
                            }
                        }
                    }
                ]
            },
            {
                xtype: 'compositefield',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'textfield',
                        width: 96,
                        allowBlank: true,
                        fieldLabel: 'Diagnostico Relacionado Nro.2',
                        id: 'sysDiagRel2HC',
                        listeners:{
                            specialkey: function(f,e){
                                if (e.getKey() === e.ENTER || e.getKey() === e.TAB)
                                {
                                    if (f.getValue() !== "" && f.getValue() !== null && f.getValue().toUpperCase() !== Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() !== Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() !== Ext.getCmp('sysDiagRel3HC').getValue()){
                                        Ext.Ajax.request(
                                        {
                                            url: '../../controlador/cie10/controlador_cie10.php',
                                            params:{
                                                task: 'BUSCAR',
                                                pCodigo: f.getValue().toUpperCase()
                                            },
                                            success: function(response,options)
                                            {
                                                //if(Ext.getCmp('sysFinalidadConsultaHC').getValue() == "10"){
                                                var el = Ext.get('response'); // get the LOG
                                                var Respuesta = response.responseText;
                                                var Contenido = Respuesta.split('^');
                                                if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                    Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                    Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                } else {
                                                    Ext.getCmp('sysDiagRel2HC').setValue(Contenido[0].toUpperCase());
                                                    Ext.getCmp('sysDiagRel2HCNom').setValue(Contenido[1].toUpperCase());
                                                }
                                            },
                                            failure: function(response,options){
                                                var el = Ext.get('response');
                                                Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                            },
                                            scope:this //bind the callbacks
                                        });
                                    }else{
                                        Ext.getCmp('sysDiagRel2HC').setValue(null);
                                        Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                    }
                                }
                            },
                            blur: function(t){
                                if (Ext.getCmp('sysDiagRel2HCNom').getValue === null || Ext.getCmp('sysDiagRel2HCNom').getValue() === "")
                                {
                                    if (Ext.getCmp('sysDiagRel2HC').getValue() !== "" && Ext.getCmp('sysDiagRel2HC').getValue() !== null && Ext.getCmp('sysDiagRel2HC').getValue().toUpperCase() !== Ext.getCmp('sysDiagPpalHC').getValue() && Ext.getCmp('sysDiagRel2HC').getValue().toUpperCase() !== Ext.getCmp('sysDiagRel1HC').getValue() && Ext.getCmp('sysDiagRel2HC').getValue().toUpperCase() !== Ext.getCmp('sysDiagRel3HC').getValue()){
                                        Ext.Ajax.request(
                                        {
                                            url: '../../controlador/cie10/controlador_cie10.php',
                                            params:{
                                                task: 'BUSCAR',
                                                pCodigo: Ext.getCmp('sysDiagRel2HC').getValue().toUpperCase()
                                            },
                                            success: function(response,options)
                                            {
                                                var el = Ext.get('response'); // get the LOG
                                                var Respuesta = response.responseText;
                                                var Contenido = Respuesta.split('^');
                                                if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                    Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                    Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                } else {
                                                    Ext.getCmp('sysDiagRel2HC').setValue(Contenido[0].toUpperCase());
                                                    Ext.getCmp('sysDiagRel2HCNom').setValue(Contenido[1].toUpperCase());
                                                }
                                            },
                                            failure: function(response,options){
                                                var el = Ext.get('response');
                                                Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                            },
                                            scope:this //bind the callbacks
                                        });
                                    }else{
                                        Ext.getCmp('sysDiagRel2HC').setValue(null);
                                        Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                    }
                                }
                            }
                        }
                    },
                    {
                        xtype: 'textarea',
                        readOnly: true,
                        width: 625,
                        height: 22,
                        id: 'sysDiagRel2HCNom'
                    },
                    {
                        xtype: 'button',
                        iconCls: 'btnBuscar',
                        tooltip: 'Buscar Diagnostico Relacionado2',
                        id: 'btnSearchDiagRel2HC1',
                        listeners:{
                            click : function(){
                                buscarcie10('sysDiagRel2HC','sysDiagRel2HCNom');
                            }
                        }
                    }
                ]
            },
            {
                xtype: 'compositefield',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'textfield',
                        width: 96,
                        allowBlank: true,
                        fieldLabel: 'Diagnostico Relacionado Nro.3',
                        id: 'sysDiagRel3HC',
                        listeners:{
                            specialkey: function(f,e){
                                if (e.getKey() === e.ENTER || e.getKey() === e.TAB)
                                {
                                    if (f.getValue() !== "" && f.getValue() !== null && f.getValue().toUpperCase() !== Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() !== Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() !== Ext.getCmp('sysDiagRel2HC').getValue()){
                                        Ext.Ajax.request(
                                        {
                                            url: '../../controlador/cie10/controlador_cie10.php',
                                            params:{
                                                task: 'BUSCAR',
                                                pCodigo: f.getValue().toUpperCase()
                                            },
                                            success: function(response,options)
                                            {
                                                var el = Ext.get('response'); // get the LOG
                                                var Respuesta = response.responseText;
                                                var Contenido = Respuesta.split('^');
                                                if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                    Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                    Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                } else {
                                                    Ext.getCmp('sysDiagRel3HC').setValue(Contenido[0].toUpperCase());
                                                    Ext.getCmp('sysDiagRel3HCNom').setValue(Contenido[1].toUpperCase());
                                                }
                                            },
                                            failure: function(response,options){
                                                var el = Ext.get('response');
                                                Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                            },
                                            scope:this //bind the callbacks
                                        });
                                    }else{
                                        Ext.getCmp('sysDiagRel3HC').setValue(null);
                                        Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                    }
                                }
                            },
                            blur: function(t){
                                if (Ext.getCmp('sysDiagRel3HCNom').getValue === null || Ext.getCmp('sysDiagRel3HCNom').getValue() === "")
                                {
                                    if (Ext.getCmp('sysDiagRel3HC').getValue() !== "" && Ext.getCmp('sysDiagRel3HC').getValue() !== null && Ext.getCmp('sysDiagRel3HC').getValue().toUpperCase() !== Ext.getCmp('sysDiagPpalHC').getValue() && Ext.getCmp('sysDiagRel3HC').getValue().toUpperCase() !== Ext.getCmp('sysDiagRel1HC').getValue() && Ext.getCmp('sysDiagRel3HC').getValue().toUpperCase() !== Ext.getCmp('sysDiagRel2HC').getValue()){
                                        Ext.Ajax.request(
                                        {
                                            url: '../../controlador/cie10/controlador_cie10.php',
                                            params:{
                                                task: 'BUSCAR',
                                                pCodigo: Ext.getCmp('sysDiagRel3HC').getValue().toUpperCase()
                                            },
                                            success: function(response,options)
                                            {
                                                var el = Ext.get('response'); // get the LOG
                                                var Respuesta = response.responseText;
                                                var Contenido = Respuesta.split('^');
                                                if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                    Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                    Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                } else {
                                                    Ext.getCmp('sysDiagRel3HC').setValue(Contenido[0].toUpperCase());
                                                    Ext.getCmp('sysDiagRel3HCNom').setValue(Contenido[1].toUpperCase());
                                                }
                                            },
                                            failure: function(response,options){
                                                var el = Ext.get('response');
                                                Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                            },
                                            scope:this //bind the callbacks
                                        });
                                    }else{
                                        Ext.getCmp('sysDiagRel3HC').setValue(null);
                                        Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                    }
                                }
                            }
                        }
                    },
                    {
                        xtype: 'textarea',
                        readOnly: true,
                        width: 625,
                        height: 22,
                        id: 'sysDiagRel3HCNom'
                    },
                    {
                        xtype: 'button',
                        iconCls: 'btnBuscar',
                        tooltip: 'Buscar Diagnostico Relacionado3',
                        id: 'btnSearchDiagRel3HC',
                        listeners:{
                            click : function(){
                                buscarcie10('sysDiagRel3HC','sysDiagRel3HCNom');
                            }
                        }
                    }
                ]
            }
        ];
        fsDiagnosticosConsulta2022Ui.superclass.initComponent.call(this);
    }
});
