/*
* @category    Formulario Otras Actividades Promocion Y Prevencion  Y De Demanda Inducida 2013 
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winHCPromPrevDemanInducidaUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic ©  .:: Plantilla HC - Otras Actividades Promocion Y Prevencion  Y De Demanda Inducida 2013  ::.',
    width: 990,
    height: 636,
    closable: false,
    resizable: false,
    draggable: false,
    modal: true,
    id: 'winHC',
    initComponent: function() {
        
        tmpmx = objMX;
        tmpmxadd = objMXADD;
        tmpexa = objEXA;
        tmprem = objREM;
        myPaciente = 0;
        myCAS = 0;
        
        try {
            var campo = Ext.getCmp('sysPacientePlantillaHC');
            if ( campo != null ) {
                myPaciente = Ext.getCmp('sysPacientePlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myPaciente == 0){
            try {
                var campo1 = Ext.getCmp('sysIdPacienteHC');
                if ( campo1 != null ) {
                    myPaciente = Ext.getCmp('sysIdPacienteHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myPaciente == 0){
            try {
                var campo5 = Ext.getCmp('sysPacienteRefHC');
                if ( campo5 != null ) {
                    myPaciente = Ext.getCmp('sysPacienteRefHC').getValue();
                }
            }catch(ex){
            }
        }
        try {
            var campo2 = Ext.getCmp('sysCASPlantillaHC');
            if ( campo2 != null ) {
                myCAS = Ext.getCmp('sysCASPlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myCAS == 0){
            try {
                var campo3 = Ext.getCmp('sysCASHC');
                if ( campo3 != null ) {
                    myCAS = Ext.getCmp('sysCASHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myCAS == 0){
            try {
                var campo4 = Ext.getCmp('sysCASRefHC');
                if ( campo4 != null ) {
                    myCAS = Ext.getCmp('sysCASRefHC').getValue();
                }
            }catch(ex){
            }
        }
        if (objMX != "NA"){
            var xSolMX = eval(objMX);
            Ext.getCmp('gridMedicamentosHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: myPaciente,
                    pCAS: myCAS
                }
            });
        }
        else{
            var xSolMX = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        if (objEXA != "NA"){
            var xSolEXA = eval(objEXA);
            Ext.getCmp('gridExamenesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: myPaciente,
                    pCAS: myCAS
                }
            });
        }else{
            var xSolEXA = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }    
        if (objREM != "NA"){
            var xSolREM = eval(objREM);
            Ext.getCmp('gridRemisionesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: myPaciente,
                    pCAS: myCAS
                }
            });
        }else{
            var xSolREM = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        var dataActAsistenciales = [
            ['SEGUIMIENTO GLUCOMETRO  UNIS MEDELLIN '],
            ['CONSULTA FRCV DIFERENTE A  AUTOCUIDADO   UNIS MEDELLIN '],
            ['CONSULTA  CRECIMIENTO Y DESARROLLO POR ENFERMERA  UNIS MEDELLIN '],
            ['CONSULTA GESTANTE POR ENFERMERA  UNIS MEDELLIN '],
            ['CONTROL POSPARTO  POR ENFERMERA  UNIS MEDELLIN '],
            ['CONSULTA  PLANIFICACION FAMILIAR POR ENFERMERA  UNIS MEDELLIN '],
            ['VISITA DOMICILIARIA POR ENFERMERA  UNIS MEDELLIN '],
            ['TAMIZAJES RCV (TA, PESO, PERIMETROS)  POR ENFERMERIA  SALUD P&P SAS - UNIS MEDELLIN '],
            ['APLICACION DE VACUNAS POR  ENFERMERIA  SALUD P&P UNIS MEDELLIN ']
        ];
        stActAsistenciales.loadData(dataActAsistenciales);
        var stActAsistenciales = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        
        var dataActEduIndividual = [
            ['EDUCACION EN PREVENCION CANCER DE SENO (AUTOEXAMEN-TAMIZAJES)'],
            ['EDUCACION EN PREVENCION CANCER DE CERVIX '],
            ['EDUCACION EN CANCER DE PROSTATA '],
            ['EDUCACION EN FRCV -NUTRICION-EJERCICIO '],
            ['EDUCACION SALUD ORAL '],
            ['ASESORÍA EN ITS'],
            ['ASESORÍA EN PF'],
            ['EDUCACION EN EL MENOR DE 10 AÑOS'],
            ['EDUCACION JOVENES 10-19 AÑOS'],
            ['EDUCACION  EN EL ADULTO MAYOR DE  46 AÑOS  (DIFERENTE A RCV) '],
            ['EDUCACION DE LA PREVENCION EN LA MORTALIDAD MATERNA DE 14-59 AÑOS '],
            ['PROMOCION DE LA NECESIDAD DE UNA ADECUADA CORRECCION DE DEFECTOS OCULARES ']
        ];
        stActEduIndividual.loadData(dataActEduIndividual);
        var stActEduIndividual = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        
        var dataActDemInducida = [
            ['INDUCCIÓN A LA DEMANDA PLAN DE AUTOCUIDADO (llamadas)'],
            ['INDUCCIÓN A LA DEMANDA CONSULTA DE NUTRICIÓN   (llamadas + demanada en consulta)'],
            ['INDUCCIÓN A LA DEMANDA AL PROGRAMA DE GIMNASIOS (llamadas + demanda en consulta) '],
            ['INDUCCIÓN A LA DEMANDA   SALUD ORAL  (llamadas+demanda en la consulta)'],
            ['INDUCCION A LA DEMANDA   TALLERES Y ACTIVIDADES EDUCATIVAS  (llamadas-personalizada)'],
            ['INDUCCION A LA DEMANDA   SALUD MENTAL  (llamadas + demanda en consulta) '],
            ['LLAMADAS TELEFONICAS DE RECORDACION DE CITAS  (llamadas repetidas) '],
            ['LLAMADAS TELEFONICAS DEMANDA INDUCIDA PROGRAMAS PYP REPORTADAS EN EL INFORME DE VCO  ']
        ];
        stActDemInducida.loadData(dataActDemInducida);
        var stActDemInducida = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        
        var dataActSeguimiento = [
            ['SEGUIMIENTO A USUARIOS HOSPITALIZADOS  RCV'],
            ['SEGUIMIENTO A INCAPACIDADES '],
            ['SEGUIMIENTO A PACIENTES PROGRAMA DE SALUD MENTAL ATENDIDOS POR PROFESIONALES(ESPECIALISTAS Y/O PSICOLOGOS)'],
            ['SEGUIMIENTO A PROGRAMA DE ERC (NUMERO DE LLAMADAS)'],
            ['INDUCCION A LA DEMANDA   TALLERES Y ACTIVIDADES EDUCATIVAS  (llamadas-personalizada)'],
            ['INDUCCION A LA DEMANDA   SALUD MENTAL  (llamadas + demanda en consulta) '],
            ['LLAMADAS TELEFONICAS DE RECORDACION DE CITAS  (llamadas repetidas) '],
            ['LLAMADAS TELEFONICAS DEMANDA INDUCIDA PROGRAMAS PYP REPORTADAS EN EL INFORME DE VCO  ']
        ];
        stActSeguimiento.loadData(dataActSeguimiento);
        var stActSeguimiento = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        
        this.items = [
            {
                xtype: 'panel',
                frame: true,
                anchor: '100%',
                id: 'panelHC',
                padding: 10,
                border: false,
                height: 610,
                autoScroll: true,
                layout: 'form',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysIdCodPlantillaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        value: 1,
                        id: 'sysUsaGridSalida'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        value: 0,
                        id: 'sysYaGuardoHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysPlantillaHC',
                        name: 'PLANTILLA'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptMx'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptExa'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptRem'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Actividad',
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        id: 'sysActividadHC',
                        name: 'PLANTILLA'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Empresa',
                        id: 'sysEmpresaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'IPS',
                        id: 'sysIPSHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Usuario',
                        id: 'sysUsuarioHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Profesional',
                        id: 'sysProfesionalHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Paciente',
                        id: 'sysIdPacienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Apertura',
                        id: 'sysAperturaHC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Cliente',
                        id: 'sysClienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdClienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdPlanHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdSubPlanHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdContratoHC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Profesional',
                        id: 'sysProfesionalAgendaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'ConsecutivoDetalle',
                        id: 'sysConsecutivoDetalleHC'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'CAS',
                                id: 'sysCASHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysFechaHC',
                                value: 'Fecha: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                width: 100,
                                id: 'sysFechaHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysHoraHC',
                                value: 'Hora: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                width: 90,
                                id: 'sysHoraHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysLegalizacionHC',
                                value: 'Legalización: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                width: 100,
                                id: 'sysLegalizaHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysAutorizacionHC',
                                value: 'Nro Autorización: '
                            },
                            {
                                xtype: 'textfield',
                                width: 210,
                                allowBlank: true,
                                style: 'color:brown;',
                                readOnly: true,
                                id: 'sysNroAutorizacionHC'
                            }
                        ]
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Paciente',
                        value: 'CC 792558261  - JORGE GALEANO RUIZ - (Masculino) FechaNac: 1973-01-30, Edad 38 Años',
                        id: 'sysPacienteHC'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                width: 120,
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'Genero',
                                id: 'sysGeneroPacHC'
                            },
                            {
                                html: 'Fecha Nacimiento'
                            },
                            {
                                xtype: 'datefield',
                                width: 120,
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysFecNacPacHC'
                            },
                            {
                                html: 'Edad'
                            },
                            {
                                xtype: 'textfield',
                                width: 250,
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysEdadPacHC'
                            }
                        ]
                    },
                    {
                        html: '<hr>',
                        style: 'background:transparent;',
                        border: false
                    },
                    {
                        xtype: 'tabpanel',
                        width: 930,
                        autoHeight: true,
                        border: false,
                        ref: 'fTabPanel',
                        id: 'fTabPanel',
                        activeTab: 0,
                        items: [
                            {
                                xtype: 'panel',
                                title: 'Evolución',
                                autoHeight: true,
                                autoScroll: true,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaEvolucion',
                                layout: 'form',
                                items: [
                                    {
                                        xtype: 'form',
                                        frame: true,
                                        anchor: '100%',
                                        id: 'frmHC',
                                        padding: 10,
                                        border: false,
                                        autoScroll: true,
                                        style: 'background:transparent;',
                                        items: [
                                            // AQUI EMPIEZAN CAMBIOS
                                            {
                                                xtype: 'panel',
                                                title: 'OTRAS ACTIVIDADES PROMOCIÓN Y PREVENCIÓN  Y DE DEMANDA INDUCIDA 2013',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                id: 'paActProPreDemInducida',
                                                items: [
                                                    {
                                                        xtype: 'panel',
                                                        title: 'ACTIVIDADES ASISTENCIALES',
                                                        layout: 'form',
                                                        collapsible: true,
                                                        titleCollapse: true,
                                                        anchor: '100%',
                                                        autoHeight: true,
                                                        id: 'paActAsistenciales',
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                title: 'AUTOCUIDADOS UNIS MEDELLIN ',
                                                                layout: 'form',
                                                                collapsible: true,
                                                                titleCollapse: true,
                                                                anchor: '100%',
                                                                autoHeight: true,
                                                                id: 'paAutUNISMedellin',
                                                                items:[
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        width: 100,
                                                                        minValue: 0,
                                                                        maxValue: 250,
                                                                        fieldLabel: 'PEREIRA',
                                                                        decimalPrecision: 2,
                                                                        allowBlank: true,
                                                                        name:"PEREIRA",
                                                                        id: 'intAutUniMedPereira'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        width: 100,
                                                                        minValue: 0,
                                                                        maxValue: 250,
                                                                        fieldLabel: 'DOSQUEBRADAS ',
                                                                        decimalPrecision: 2,
                                                                        allowBlank: true,
                                                                        name:"DOSQUEBRADAS ",
                                                                        id: 'intAutUniMedDosquebradas'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        width: 100,
                                                                        minValue: 0,
                                                                        maxValue: 250,
                                                                        fieldLabel: 'ARMENIA  ',
                                                                        decimalPrecision: 2,
                                                                        allowBlank: true,
                                                                        name:"ARMENIA  ",
                                                                        id: 'intAutUniMedArmenia'
                                                                    },
                                                                    {
                                                                        xtype: 'fieldset',
                                                                        title: 'MANIZALES',
                                                                        layout: 'form',
                                                                        collapsible: true,
                                                                        titleCollapse: true,
                                                                        anchor: '100%',
                                                                        autoHeight: true,
                                                                        id: 'fsAutUniMedManizales',
                                                                        items: [
                                                                            {
                                                                                xtype: 'numberfield',
                                                                                width: 100,
                                                                                minValue: 0,
                                                                                maxValue: 250,
                                                                                fieldLabel: 'MANIZALES  OTRA POBLACION  ',
                                                                                decimalPrecision: 2,
                                                                                allowBlank: true,
                                                                                name:"MANIZALES  OTRA POBLACION  ",
                                                                                id: 'intManOtraPoblacion'
                                                                            },
                                                                            {
                                                                                xtype: 'numberfield',
                                                                                width: 100,
                                                                                minValue: 0,
                                                                                maxValue: 250,
                                                                                fieldLabel: 'TRABAJADORES PLANTA MANIZALES  ',
                                                                                decimalPrecision: 2,
                                                                                allowBlank: true,
                                                                                name:"TRABAJADORES PLANTA MANIZALES ",
                                                                                id: 'intManTraPlaManizales'
                                                                            },
                                                                            {
                                                                                xtype: 'numberfield',
                                                                                width: 100,
                                                                                minValue: 0,
                                                                                maxValue: 250,
                                                                                fieldLabel: 'TRABAJADORES PLANTA  HERVEO   ',
                                                                                decimalPrecision: 2,
                                                                                allowBlank: true,
                                                                                name:"TRABAJADORES PLANTA  HERVEO  ",
                                                                                id: 'intManTraPlaHerveo'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'fieldset',
                                                                        title: 'MEDELLIN',
                                                                        layout: 'form',
                                                                        collapsible: true,
                                                                        titleCollapse: true,
                                                                        anchor: '100%',
                                                                        autoHeight: true,
                                                                        id: 'fsAutUniMedMedellin',
                                                                        items: [
                                                                            {
                                                                                xtype: 'numberfield',
                                                                                width: 100,
                                                                                minValue: 0,
                                                                                maxValue: 250,
                                                                                fieldLabel: 'ANTIOQUIA  OTRA POBLACION  ',
                                                                                decimalPrecision: 2,
                                                                                allowBlank: true,
                                                                                name:"ANTIOQUIA  OTRA POBLACION  ",
                                                                                id: 'intMedAntOtrPoblacion'
                                                                            },
                                                                            {
                                                                                xtype: 'numberfield',
                                                                                width: 100,
                                                                                minValue: 0,
                                                                                maxValue: 250,
                                                                                fieldLabel: 'TRABAJADORES PLANTA MEDELLIN',
                                                                                decimalPrecision: 2,
                                                                                allowBlank: true,
                                                                                name:"TRABAJADORES PLANTA MEDELLIN",
                                                                                id: 'intMedTraPlaMedellin'
                                                                            },
                                                                            {
                                                                                xtype: 'numberfield',
                                                                                width: 100,
                                                                                minValue: 0,
                                                                                maxValue: 250,
                                                                                fieldLabel: 'TRABAJADORES PLANTA PUERTO B   ',
                                                                                decimalPrecision: 2,
                                                                                allowBlank: true,
                                                                                name:"TRABAJADORES PLANTA PUERTO B   ",
                                                                                id: 'intMedTraPlaPueB'
                                                                            },
                                                                            {
                                                                                xtype: 'numberfield',
                                                                                width: 100,
                                                                                minValue: 0,
                                                                                maxValue: 250,
                                                                                fieldLabel: 'TRABAJADORES PLANTA CISNEROS    ',
                                                                                decimalPrecision: 2,
                                                                                allowBlank: true,
                                                                                name:"TRABAJADORES PLANTA CISNEROS ",
                                                                                id: 'intMedTraPlaCisneros'
                                                                            },
                                                                            {
                                                                                xtype: 'numberfield',
                                                                                width: 100,
                                                                                minValue: 0,
                                                                                maxValue: 250,
                                                                                fieldLabel: 'TRABAJADORES PLANTA CAUCASIA',
                                                                                decimalPrecision: 2,
                                                                                allowBlank: true,
                                                                                name:"TRABAJADORES PLANTA CAUCASIA",
                                                                                id: 'intMedTraPlaCaucasia'
                                                                            }
                                                                        ]
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'ACTIVIDADES ASISTENCIALES ',
                                                                width:750,
                                                                name: 'ACTIVIDADES ASISTENCIALES ',
                                                                allowBlank: false,
                                                                store: stActAsistenciales,
                                                                forceSelection: true,
                                                                triggerAction: 'all',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                mode: 'local',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                emptyText: 'Seleccione....',
                                                                submitValue: true,
                                                                id: 'strStoreActAsistenciales'
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                collapsible: true,
                                                                titleCollapse: true,
                                                                anchor: '100%',
                                                                autoHeight: true,
                                                                id: 'paActAsiCiudades',
                                                                items:[
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        width: 100,
                                                                        minValue: 0,
                                                                        maxValue: 250,
                                                                        fieldLabel: 'PEREIRA',
                                                                        decimalPrecision: 2,
                                                                        allowBlank: true,
                                                                        name:"PEREIRA",
                                                                        id: 'intActAsiCiuPereira'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        width: 100,
                                                                        minValue: 0,
                                                                        maxValue: 250,
                                                                        fieldLabel: 'ARMENIA  ',
                                                                        decimalPrecision: 2,
                                                                        allowBlank: true,
                                                                        name:"ARMENIA  ",
                                                                        id: 'intActAsiCiuArmenia'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        width: 100,
                                                                        minValue: 0,
                                                                        maxValue: 250,
                                                                        fieldLabel: 'MANIZALES',
                                                                        decimalPrecision: 2,
                                                                        allowBlank: true,
                                                                        name:"MANIZALES",
                                                                        id: 'intActAsiCiuManizales'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        width: 100,
                                                                        minValue: 0,
                                                                        maxValue: 250,
                                                                        fieldLabel: 'MEDELLIN ',
                                                                        decimalPrecision: 2,
                                                                        allowBlank: true,
                                                                        name:"MEDELLIN ",
                                                                        id: 'intActAsiCiuMedellin'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                title: 'GLUCOMETRÍAS',
                                                                layout: 'form',
                                                                collapsible: true,
                                                                titleCollapse: true,
                                                                anchor: '100%',
                                                                autoHeight: true,
                                                                id: 'paGlucometrias',
                                                                items:[
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        width: 100,
                                                                        minValue: 0,
                                                                        maxValue: 250,
                                                                        fieldLabel: 'DE TAMIZAJE (USUARIO NO DIABETICO)',
                                                                        decimalPrecision: 2,
                                                                        allowBlank: true,
                                                                        name:"DE TAMIZAJE (USUARIO NO DIABETICO)",
                                                                        id: 'intGluTamizajeUsuDiabetico'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        width: 100,
                                                                        minValue: 0,
                                                                        maxValue: 250,
                                                                        fieldLabel: 'GLUCOMETRIA EN USUARIO DIABETICO   ',
                                                                        decimalPrecision: 2,
                                                                        allowBlank: true,
                                                                        name:"GLUCOMETRIA EN USUARIO DIABETICO   ",
                                                                        id: 'intGluGluUsuDiabetico'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: 'ACTIVIDADES DE EDUCACION  INDIVIDUAL ',
                                                        layout: 'form',
                                                        collapsible: true,
                                                        titleCollapse: true,
                                                        anchor: '100%',
                                                        autoHeight: true,
                                                        id: 'paActEduIndivual',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'ACTIVIDADES DE EDUCACION INDIVIDUAL',
                                                                width:750,
                                                                name: 'ACTIVIDADES DE EDUCACION INDIVIDUAL',
                                                                allowBlank: false,
                                                                store: stActEduIndividual,
                                                                forceSelection: true,
                                                                triggerAction: 'all',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                mode: 'local',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                emptyText: 'Seleccione....',
                                                                submitValue: true,
                                                                id: 'strStoreActEduIndividual'
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                collapsible: true,
                                                                titleCollapse: true,
                                                                anchor: '100%',
                                                                autoHeight: true,
                                                                id: 'paEduInd',
                                                                items:[
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        width: 100,
                                                                        minValue: 0,
                                                                        maxValue: 250,
                                                                        fieldLabel: 'PEREIRA',
                                                                        decimalPrecision: 2,
                                                                        allowBlank: true,
                                                                        name:"PEREIRA",
                                                                        id: 'intEduIndPereira'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        width: 100,
                                                                        minValue: 0,
                                                                        maxValue: 250,
                                                                        fieldLabel: 'ARMENIA  ',
                                                                        decimalPrecision: 2,
                                                                        allowBlank: true,
                                                                        name:"ARMENIA  ",
                                                                        id: 'intEduIndSenArmenia'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        width: 100,
                                                                        minValue: 0,
                                                                        maxValue: 250,
                                                                        fieldLabel: 'MANIZALES',
                                                                        decimalPrecision: 2,
                                                                        allowBlank: true,
                                                                        name:"MANIZALES",
                                                                        id: 'intEduIndManizales'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        width: 100,
                                                                        minValue: 0,
                                                                        maxValue: 250,
                                                                        fieldLabel: 'MEDELLIN ',
                                                                        decimalPrecision: 2,
                                                                        allowBlank: true,
                                                                        name:"MEDELLIN ",
                                                                        id: 'intEduIndMedellin'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: 'ACTIVIDADES DE DEMANDA INDUCIDA  ',
                                                        layout: 'form',
                                                        collapsible: true,
                                                        titleCollapse: true,
                                                        anchor: '100%',
                                                        autoHeight: true,
                                                        id: 'paActDemInducida',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'ACTIVIDADES DE DEMANDA INDUCIDA  ',
                                                                width:750,
                                                                name: 'ACTIVIDADES DE DEMANDA INDUCIDA  ',
                                                                allowBlank: false,
                                                                store: stActDemInducida,
                                                                forceSelection: true,
                                                                triggerAction: 'all',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                mode: 'local',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                emptyText: 'Seleccione....',
                                                                submitValue: true,
                                                                id: 'strStoreActDemInducida'
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                collapsible: true,
                                                                titleCollapse: true,
                                                                anchor: '100%',
                                                                autoHeight: true,
                                                                id: 'paEducaInducida',
                                                                items:[
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        width: 100,
                                                                        minValue: 0,
                                                                        maxValue: 250,
                                                                        fieldLabel: 'PEREIRA',
                                                                        decimalPrecision: 2,
                                                                        allowBlank: true,
                                                                        name:"PEREIRA",
                                                                        id: 'intEducaInducidaPereira'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        width: 100,
                                                                        minValue: 0,
                                                                        maxValue: 250,
                                                                        fieldLabel: 'ARMENIA  ',
                                                                        decimalPrecision: 2,
                                                                        allowBlank: true,
                                                                        name:"ARMENIA  ",
                                                                        id: 'intEducaInducidaArmenia'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        width: 100,
                                                                        minValue: 0,
                                                                        maxValue: 250,
                                                                        fieldLabel: 'MANIZALES',
                                                                        decimalPrecision: 2,
                                                                        allowBlank: true,
                                                                        name:"MANIZALES",
                                                                        id: 'intEducaInducidaManizales'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        width: 100,
                                                                        minValue: 0,
                                                                        maxValue: 250,
                                                                        fieldLabel: 'MEDELLIN ',
                                                                        decimalPrecision: 2,
                                                                        allowBlank: true,
                                                                        name:"MEDELLIN ",
                                                                        id: 'intEducaInducidaMedellin'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: '<center>ACTIVIDADES DE  SEGUIMIENTO</center>  ',
                                                        layout: 'form',
                                                        collapsible: true,
                                                        titleCollapse: true,
                                                        anchor: '100%',
                                                        autoHeight: true,
                                                        id: 'paActSeguimiento',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'ACTIVIDADES DE  SEGUIMIENTO ',
                                                                width:750,
                                                                name: 'ACTIVIDADES DE  SEGUIMIENTO ',
                                                                allowBlank: false,
                                                                store: stActSeguimiento,
                                                                forceSelection: true,
                                                                triggerAction: 'all',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                mode: 'local',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                emptyText: 'Seleccione....',
                                                                submitValue: true,
                                                                id: 'strStoreActSeguimiento'
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                collapsible: true,
                                                                titleCollapse: true,
                                                                anchor: '100%',
                                                                autoHeight: true,
                                                                id: 'paActivSeguimiento',
                                                                items:[
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        width: 100,
                                                                        minValue: 0,
                                                                        maxValue: 250,
                                                                        fieldLabel: 'PEREIRA',
                                                                        decimalPrecision: 2,
                                                                        allowBlank: true,
                                                                        name:"PEREIRA",
                                                                        id: 'intActivSeguimientoPereira'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        width: 100,
                                                                        minValue: 0,
                                                                        maxValue: 250,
                                                                        fieldLabel: 'ARMENIA  ',
                                                                        decimalPrecision: 2,
                                                                        allowBlank: true,
                                                                        name:"ARMENIA  ",
                                                                        id: 'intActivSeguimientoArmenia'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        width: 100,
                                                                        minValue: 0,
                                                                        maxValue: 250,
                                                                        fieldLabel: 'MANIZALES',
                                                                        decimalPrecision: 2,
                                                                        allowBlank: true,
                                                                        name:"MANIZALES",
                                                                        id: 'intActivSeguimientoManizales'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        width: 100,
                                                                        minValue: 0,
                                                                        maxValue: 250,
                                                                        fieldLabel: 'MEDELLIN ',
                                                                        decimalPrecision: 2,
                                                                        allowBlank: true,
                                                                        name:"MEDELLIN ",
                                                                        id: 'intActivSeguimientoMedellin'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: 'CARGOS PARA FACTURA  AUDITORIA',
                                                        layout: 'form',
                                                        collapsible: true,
                                                        titleCollapse: true,
                                                        anchor: '100%',
                                                        autoHeight: true,
                                                        id: 'paCarFacAuditoria',
                                                        items: [
                                                            {
                                                                xtype: 'fieldset',
                                                                title: 'ANTIOQUIA',
                                                                layout: 'form',
                                                                collapsible: true,
                                                                titleCollapse: true,
                                                                anchor: '100%',
                                                                autoHeight: true,
                                                                id: 'fsAntioquia',
                                                                items: [
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        width: 100,
                                                                        minValue: 0,
                                                                        maxValue: 250,
                                                                        fieldLabel: 'ACTIVIDADES ASISTENCIALES  ',
                                                                        decimalPrecision: 2,
                                                                        allowBlank: true,
                                                                        name:"ACTIVIDADES ASISTENCIALES  ",
                                                                        id: 'intAntActAsistenciales'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        width: 100,
                                                                        minValue: 0,
                                                                        maxValue: 250,
                                                                        fieldLabel: 'EDUCACION INDIVIDUAL',
                                                                        decimalPrecision: 2,
                                                                        allowBlank: true,
                                                                        name:"EDUCACION INDIVIDUAL  ",
                                                                        id: 'intAntEduIndividual'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        width: 100,
                                                                        minValue: 0,
                                                                        maxValue: 250,
                                                                        fieldLabel: 'DEMANDA INDUCIDA TOTAL /10 ',
                                                                        decimalPrecision: 2,
                                                                        allowBlank: true,
                                                                        name:"DEMANDA INDUCIDA TOTAL /10 ",
                                                                        id: 'intAntDemIndTotal'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        width: 100,
                                                                        minValue: 0,
                                                                        maxValue: 250,
                                                                        fieldLabel: 'ACTIVIDADES DE SEGUIMIENTO ',
                                                                        decimalPrecision: 2,
                                                                        allowBlank: true,
                                                                        name:"ACTIVIDADES DE SEGUIMIENTO ",
                                                                        id: 'intAntActSeguimiento'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        width: 100,
                                                                        minValue: 0,
                                                                        maxValue: 250,
                                                                        fieldLabel: 'ACTIVIDADES DE SEGUIMIENTO ',
                                                                        decimalPrecision: 2,
                                                                        allowBlank: true,
                                                                        name:"ACTIVIDADES DE SEGUIMIENTO ",
                                                                        id: 'intAntActSeguimiento'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    }
                                                ]                                                
                                            },
                                            // AQUI FINALIZAN CAMBIOS 
                                            {
                                                xtype: 'fieldset',
                                                title: 'RIPS',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                id: 'fsRips',
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: false,
                                                                fieldLabel: 'Diagnostico Principal',
                                                                id: 'sysDiagPpalHC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request({
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                        Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagPpalHCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Principal',
                                                                id: 'btnSearchDiagPpalHC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagPpalHC','sysDiagPpalHCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.1',
                                                                id: 'sysDiagRel1HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel1HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado1',
                                                                id: 'btnSearchDiagRel1HC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel1HC','sysDiagRel1HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.2',
                                                                id: 'sysDiagRel2HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel2HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado2',
                                                                id: 'btnSearchDiagRel2HC1',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel2HC','sysDiagRel2HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.3',
                                                                id: 'sysDiagRel3HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel3HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado3',
                                                                id: 'btnSearchDiagRel3HC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel3HC','sysDiagRel3HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Tipo de Diagnostico',
                                                        width:750,
                                                        name: 'Tipo de Diagnostico',
                                                        allowBlank: false,
                                                        store: 'StoreTipoDiagnostico',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        id: 'sysTipoDiagosticoHC'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Finalidad Consulta',
                                                        width:750,
                                                        name: 'Finalidad Consulta',
                                                        allowBlank: false,
                                                        store: 'StoreFinalidadConsulta',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 10,
                                                        id: 'sysFinalidadConsultaHC'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Causa Externa',
                                                        width:750,
                                                        name: 'Causa Externa',
                                                        allowBlank: false,
                                                        store: 'StoreCausaExterna',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 13,
                                                        id: 'sysCausaExternaHC'
                                                    }                            
                                                ]
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Medicamentos',
                                height: 352,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaMedicamentos',
                                items: [
                                    xSolMX
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Servicios',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaServicios',
                                items: [
                                    xSolEXA
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Remisiones',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaRemisiones',
                                items: [
                                    xSolREM
                                ]
                            }
                            /*,
                            {
                                xtype: 'panel',
                                title: 'Solicitud CTC',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaCTC',
                                items: [
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Consentimientos Informados',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaConsentimientos',
                                items: [
                                ]
                            },*/
                        ]
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btnSalirEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 1) 
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    if (Ext.getCmp('sysUsaGridSalida').getValue() == 1){
                                                        Ext.getCmp('gridFormulario').store.reload();
                                                    }
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Usted No ha Guardado la Evolución del Paciente y Se Perdera la Información, Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                },
                tbar:{
                    items: [
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Ver Historia Clínica',
                            iconCls: 'btnVerHC',
                            id: 'btnVerHC',
                            listeners:{
                                click : function(){
                                    var cmpResumenHC = new winFrmVerHistorialHC({
                                        renderTo: Ext.getBody()
                                    });
                                    Ext.getCmp('winViewEvolucionHC').title = "PACIENTE: " + Ext.getCmp('sysPacienteHC').getValue();
                                    Ext.getCmp('gridHistorialEvoluciones').store.load({
                                        params: {
                                            pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                                            pPaciente: Ext.getCmp('sysIdPacienteHC').getValue()
                                        }
                                    });
                                    cmpResumenHC.show();
                                }
                            }
                        },
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar Evolución',
                            iconCls: 'btnGuardar',
                            id: 'btnGuardarEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 0) 
                                    {
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Guardar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnGuardarRegistros();
                                                }
                                            }
                                        });
                                    }else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Modificar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnModificarRegistros();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                }
            }
        ];
        winHCPromPrevDemanInducidaUi.superclass.initComponent.call(this);
    }
});

function fnGuardarRegistros(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc.php',
            params:{
                task: 'guardar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pidPlantillaHC : Ext.getCmp('sysIdCodPlantillaHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1); 
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function fnModificarRegistros(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc.php',
            params:{
                task: 'modificar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}
