/*
* @category    Formulario Seguimiento A Programas De Promocion Y Prevencion
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winHCSegProgPromPrevencionUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic ©  .:: Plantilla HC - Seguimiento A Programas De Promocion Y Prevencion  ::.',
    width: 990,
    height: 636,
    closable: false,
    resizable: false,
    draggable: false,
    modal: true,
    id: 'winHC',
    initComponent: function() {
        
        tmpmx = objMX;
        tmpmxadd = objMXADD;
        tmpexa = objEXA;
        tmprem = objREM;
        myPaciente = 0;
        myCAS = 0;
        
        try {
            var campo = Ext.getCmp('sysPacientePlantillaHC');
            if ( campo != null ) {
                myPaciente = Ext.getCmp('sysPacientePlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myPaciente == 0){
            try {
                var campo1 = Ext.getCmp('sysIdPacienteHC');
                if ( campo1 != null ) {
                    myPaciente = Ext.getCmp('sysIdPacienteHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myPaciente == 0){
            try {
                var campo5 = Ext.getCmp('sysPacienteRefHC');
                if ( campo5 != null ) {
                    myPaciente = Ext.getCmp('sysPacienteRefHC').getValue();
                }
            }catch(ex){
            }
        }
        try {
            var campo2 = Ext.getCmp('sysCASPlantillaHC');
            if ( campo2 != null ) {
                myCAS = Ext.getCmp('sysCASPlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myCAS == 0){
            try {
                var campo3 = Ext.getCmp('sysCASHC');
                if ( campo3 != null ) {
                    myCAS = Ext.getCmp('sysCASHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myCAS == 0){
            try {
                var campo4 = Ext.getCmp('sysCASRefHC');
                if ( campo4 != null ) {
                    myCAS = Ext.getCmp('sysCASRefHC').getValue();
                }
            }catch(ex){
            }
        }
        if (objMX != "NA"){
            var xSolMX = eval(objMX);
            Ext.getCmp('gridMedicamentosHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: myPaciente,
                    pCAS: myCAS
                }
            });
        }
        else{
            var xSolMX = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        if (objEXA != "NA"){
            var xSolEXA = eval(objEXA);
            Ext.getCmp('gridExamenesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: myPaciente,
                    pCAS: myCAS
                }
            });
        }else{
            var xSolEXA = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }    
        if (objREM != "NA"){
            var xSolREM = eval(objREM);
            Ext.getCmp('gridRemisionesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: myPaciente,
                    pCAS: myCAS
                }
            });
        }else{
            var xSolREM = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        var dataProceIntervenciones = [
            ['POBLACION OBJETO'],
            ['CONCENTRACION DE LA POBLACION'],
            ['PROGRAMACION 3384 2013'],
            ['DEMANDA INDUCIDA PROGRAMADA '],
            ['DEMANDA INDUCIDA EJECUTADA'],
            ['DEMANDA INDUCIDA EFECTIVA'],
            ['COBERTURA EN DEMANDA INDUCIDA'],
            ['PROGRAMACION DE ACTIVIDADES DE P YP'],
            ['EJECUCION EN CUMPLIMIENTO DE METAS']
        ];
        var stProceIntervenciones = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stProceIntervenciones.loadData(dataProceIntervenciones);
        
        this.items = [
            {
                xtype: 'panel',
                frame: true,
                anchor: '100%',
                id: 'panelHC',
                padding: 10,
                border: false,
                height: 610,
                autoScroll: true,
                layout: 'form',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysIdCodPlantillaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        value: 1,
                        id: 'sysUsaGridSalida'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        value: 0,
                        id: 'sysYaGuardoHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysPlantillaHC',
                        name: 'PLANTILLA'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptMx'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptExa'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptRem'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Actividad',
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        id: 'sysActividadHC',
                        name: 'PLANTILLA'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Empresa',
                        id: 'sysEmpresaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'IPS',
                        id: 'sysIPSHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Usuario',
                        id: 'sysUsuarioHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Profesional',
                        id: 'sysProfesionalHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Paciente',
                        id: 'sysIdPacienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Apertura',
                        id: 'sysAperturaHC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Cliente',
                        id: 'sysClienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdClienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdPlanHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdSubPlanHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdContratoHC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Profesional',
                        id: 'sysProfesionalAgendaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'ConsecutivoDetalle',
                        id: 'sysConsecutivoDetalleHC'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'CAS',
                                id: 'sysCASHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysFechaHC',
                                value: 'Fecha: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                width: 100,
                                id: 'sysFechaHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysHoraHC',
                                value: 'Hora: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                width: 90,
                                id: 'sysHoraHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysLegalizacionHC',
                                value: 'Legalización: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                width: 100,
                                id: 'sysLegalizaHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysAutorizacionHC',
                                value: 'Nro Autorización: '
                            },
                            {
                                xtype: 'textfield',
                                width: 210,
                                allowBlank: true,
                                style: 'color:brown;',
                                readOnly: true,
                                id: 'sysNroAutorizacionHC'
                            }
                        ]
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Paciente',
                        value: 'CC 792558261  - JORGE GALEANO RUIZ - (Masculino) FechaNac: 1973-01-30, Edad 38 Años',
                        id: 'sysPacienteHC'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                width: 120,
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'Genero',
                                id: 'sysGeneroPacHC'
                            },
                            {
                                html: 'Fecha Nacimiento'
                            },
                            {
                                xtype: 'datefield',
                                width: 120,
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysFecNacPacHC'
                            },
                            {
                                html: 'Edad'
                            },
                            {
                                xtype: 'textfield',
                                width: 250,
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysEdadPacHC'
                            }
                        ]
                    },
                    {
                        html: '<hr>',
                        style: 'background:transparent;',
                        border: false
                    },
                    {
                        xtype: 'tabpanel',
                        width: 930,
                        autoHeight: true,
                        border: false,
                        ref: 'fTabPanel',
                        id: 'fTabPanel',
                        activeTab: 0,
                        items: [
                            {
                                xtype: 'panel',
                                title: 'Evolución',
                                autoHeight: true,
                                autoScroll: true,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaEvolucion',
                                layout: 'form',
                                items: [
                                    {
                                        xtype: 'form',
                                        frame: true,
                                        anchor: '100%',
                                        id: 'frmHC',
                                        padding: 10,
                                        border: false,
                                        autoScroll: true,
                                        style: 'background:transparent;',
                                        items: [
                                            // AQUI EMPIEZAN CAMBIOS
                                            {
                                                xtype: 'panel',
                                                title: 'SEGUIMIENTO A PROGRAMAS DE PROMOCION Y PREVENCION',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                id: 'paSegProProPrevencion',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'PROCEDIMIENTOS E INTERVENCIONES  ',
                                                        width:750,
                                                        name: 'PROCEDIMIENTOS E INTERVENCIONES',
                                                        allowBlank: false,
                                                        store: stProceIntervenciones,
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        id: 'strSegProProPreProIntervenciones'
                                                    },
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'ACTIVIDADES',
                                                        layout: 'form',
                                                        collapsible: true,
                                                        titleCollapse: true,
                                                        anchor: '100%',
                                                        autoHeight: true,
                                                        id: 'fsActividades',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                fieldLabel: 'VACUNACION ',
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"VACUNACION ",
                                                                id: 'intActVacunacion'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                fieldLabel: 'DOSIS DE BCG ',
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"DOSIS DE BCG  ",
                                                                id: 'intActDosBCG'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                fieldLabel: 'DOSIS ANTIHEPATITIS  B APLICADAS EN MENORES DE 1 AÑO ',
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"DOSIS ANTIHEPATITIS  B APLICADAS EN MENORES DE 1 AÑO",
                                                                id: 'intActDosAntBAplMenores'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                fieldLabel: 'DOSIS DPT APLICADAS EN MENORES DE 5 AÑOS',
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"DOSIS DPT APLICADAS EN MENORES DE 5 AÑOS",
                                                                id: 'intActDosDPTAplMenores'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                fieldLabel: 'DOSIS POLIO',
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"DOSIS POLIO",
                                                                id: 'intActDosPolio'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                fieldLabel: 'DOSIS CONJUGADA H INFLUENZA TIPO B',
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"DOSIS CONJUGADA H INFLUENZA TIPO B",
                                                                id: 'intActDosConHInfTipB'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                fieldLabel: 'DOSIS TD O TT',
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"DOSIS TD O TT",
                                                                id: 'intActDosConHInfTipB'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                fieldLabel: 'DOSIS TRIPLE VIRAL',
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"DOSIS TRIPLE VIRAL",
                                                                id: 'intActDosTriViral'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                fieldLabel: 'DOSIS FIEBRE AMARILLA NIÑOS 1 AÑO',
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"DOSIS FIEBRE AMARILLA NIÑOS 1 AÑO",
                                                                id: 'intActDosFieAmaNin'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                fieldLabel: 'ROTAVIRUS ',
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"ROTAVIRUS ",
                                                                id: 'intActRotavirus'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                fieldLabel: 'NEUMOCOCO ',
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"NEUMOCOCO ",
                                                                id: 'intActNeumococo'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                fieldLabel: 'HEPATITIS A ',
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"HEPATITIS A ",
                                                                id: 'intActHepA'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                fieldLabel: 'VARICELA ',
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"VARICELA ",
                                                                id: 'intActVaricela'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                fieldLabel: 'VPH',
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"VPH",
                                                                id: 'intActVPH'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                fieldLabel: 'SR BIVALENTE CAMPAÑA',
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"SR BIVALENTE CAMPAÑA",
                                                                id: 'intActSRBriCampaña'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                fieldLabel: 'INFLUENZA NIÑOS DE 1 AÑO Y MENOS',
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"INFLUENZA NIÑOS DE 1 AÑO Y MENOS",
                                                                id: 'intActInfNinAnoMenos'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                fieldLabel: 'INFLUENZA GRUPOS DE RIESGO ',
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"INFLUENZA GRUPOS DE RIESGO ",
                                                                id: 'intActInfGruRiesgo'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                fieldLabel: 'INFLUENZA ADULTO MAYOR DE 60 AÑOS',
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"INFLUENZA ADULTO MAYOR DE 60 AÑOS",
                                                                id: 'intActInfAduMayor'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                fieldLabel: 'INFLUENZA TRABAJADORES',
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"INFLUENZA TRABAJADORES",
                                                                id: 'intActInfTrabajadores'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                fieldLabel: 'FIEBRE AMARILLA A TRABAJADORES ',
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"FIEBRE AMARILLA A TRABAJADORES ",
                                                                id: 'intActFieAmaTrabajadores'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                fieldLabel: 'TD EN TRABAJADORES',
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"TD EN TRABAJADORES",
                                                                id: 'intActTDTrabajadores'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                fieldLabel: 'PARTO /CESAREA ',
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"PARTO /CESAREA ",
                                                                id: 'intActParCesarea'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                fieldLabel: 'ATENCION DEL PARTO ',
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"ATENCION DEL PARTO ",
                                                                id: 'intActAteParto'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                fieldLabel: 'SEROLOGIA  ',
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"SEROLOGIA ",
                                                                id: 'intActSerologia'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                fieldLabel: 'CONSULTA MEDICA POSPARTO  ',
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"CONSULTA MEDICA POSPARTO ",
                                                                id: 'intActConMedPosparto'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                fieldLabel: 'ATENCION AL RN',
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"ATENCION AL RN",
                                                                id: 'intActAteRN'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                fieldLabel: 'TSH TOMA Y ANALISIS ',
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"TSH TOMA Y ANALISIS ",
                                                                id: 'intTSHTomAnalisis'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                fieldLabel: 'VITAMINA K ',
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"VITAMINA K",
                                                                id: 'intActVitK'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                fieldLabel: 'HEMOCLASIFICACION ',
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"HEMOCLASIFICACION ",
                                                                id: 'intActHemoclasificacion'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                fieldLabel: 'CONSULTA DE CONTROL RN ',
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"CONSULTA DE CONTROL RN ",
                                                                id: 'intActConControlRN'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                fieldLabel: 'PLANIFICACION FAMILIAR A MUJERES',
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"PLANIFICACION FAMILIAR A MUJERES",
                                                                id: 'intActPlaFamMujeres'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                fieldLabel: 'CONSULTAS DE PLANIFICACIÓN FAMILIAR DE PRIMERA VEZ (POR MÉDICO O ENFERMERA)',
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"CONSULTAS DE PLANIFICACIÓN FAMILIAR DE PRIMERA VEZ (POR MÉDICO O ENFERMERA)",
                                                                id: 'intActConPlaFamPriVez'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                fieldLabel: 'CONSULTAS DE PLANIFICACIÓN FAMILIAR DE CONTROL (POR MÉDICO O ENFERMERA)',
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"CONSULTAS DE PLANIFICACIÓN FAMILIAR DE CONTROL (POR MÉDICO O ENFERMERA)",
                                                                id: 'intActConPlaFamControl'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                fieldLabel: 'APLICACIÓN DE DISPOSITIVO',
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"APLICACIÓN DE DISPOSITIVO",
                                                                id: 'intActAplDispositivo'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                fieldLabel: 'OCLUSIÓN TUBÁRICA BILATERAL',
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"OCLUSIÓN TUBÁRICA BILATERAL",
                                                                id: 'intActOclTubBilateral'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                fieldLabel: 'SUMINISTRO DE ANTICONCEPTIVO HORMONAL ORAL',
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"SUMINISTRO DE ANTICONCEPTIVO HORMONAL ORAL",
                                                                id: 'intActSumAntHorOral'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                fieldLabel: 'ANTICONCEPCIÓN HORMONAL MÉTODOS MODERNOS',
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"ANTICONCEPCIÓN HORMONAL MÉTODOS MODERNOS",
                                                                id: 'intActAntHorMetModernos'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                fieldLabel: 'ANTICONCEPCIÓN DE EMERGENCIA',
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"ANTICONCEPCIÓN DE EMERGENCIA",
                                                                id: 'intActAntEmergencia'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                fieldLabel: 'PLANIFICACION FAMILIAR A HOMBRES ',
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"PLANIFICACION FAMILIAR A HOMBRES",
                                                                id: 'intActPlaFamHombres'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                fieldLabel: 'CONSULTAS DE PLANIFICACIÓN FAMILIAR DE PRIMERA VEZ HOMBRES',
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"CONSULTAS DE PLANIFICACIÓN FAMILIAR DE PRIMERA VEZ HOMBRES",
                                                                id: 'intActConPlaFamPriVezHombres'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                fieldLabel: 'CONSULTAS DE PLANIFICACIÓN FAMILIAR DE CONTROL HOMBRES',
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"CONSULTAS DE PLANIFICACIÓN FAMILIAR DE CONTROL HOMBRES",
                                                                id: 'intActConPlaFamConHombres'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                fieldLabel: 'VASECTOMIA',
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"VASECTOMIA",
                                                                id: 'intActVasectomia'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                fieldLabel: 'DETECCIÓN TEMPRANA DE LAS ALTERACIONES DEL CRECIMIENTO Y DESARROLLO (MENORES DE 10 AÑOS)',
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"DETECCIÓN TEMPRANA DE LAS ALTERACIONES DEL CRECIMIENTO Y DESARROLLO (MENORES DE 10 AÑOS)",
                                                                id: 'intActDetTemAltCreDesarrollo'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                fieldLabel: 'CONSULTA MÉDICA DE PRIMERA VEZ',
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"CONSULTA MÉDICA DE PRIMERA VEZ",
                                                                id: 'intActConMedPriVez'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                fieldLabel: 'CONSULTA DE CONTROL POR ENFERMERIA',
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"CONSULTA DE CONTROL POR ENFERMERIA",
                                                                id: 'intActConContEnfermeria'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                fieldLabel: 'DETECCIÓN TEMPRANA DE LAS ALTERACIONES DEL DESARROLLO DEL JOVEN (10-29 AÑOS)',
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"DETECCIÓN TEMPRANA DE LAS ALTERACIONES DEL DESARROLLO DEL JOVEN (10-29 AÑOS)",
                                                                id: 'intActDetTemAltDesJoven'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                fieldLabel: 'CONSULTA DE PRIMERA VEZ POR MÉDICO',
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"CONSULTA DE PRIMERA VEZ POR MÉDICO",
                                                                id: 'intActConPriVezMedico'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                fieldLabel: 'EXÁMEN DE HEMOGLOBINA',
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"EXÁMEN DE HEMOGLOBINA",
                                                                id: 'intActExaHemoglobina'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                fieldLabel: 'DETECCIÓN TEMPRANA DE LAS ALTERACIONES DEL EMBARAZO',
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"DETECCIÓN TEMPRANA DE LAS ALTERACIONES DEL EMBARAZO",
                                                                id: 'intActDetTemAltEmbarazado'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                fieldLabel: 'CONSULTA PRENATAL DE PRIMERA VEZ POR MÉDICO',
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"CONSULTA PRENATAL DE PRIMERA VEZ POR MÉDICO",
                                                                id: 'intActConPrePriVezMedico'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                fieldLabel: 'SEROLOGÍA VDRL - RPR',
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"SEROLOGÍA VDRL - RPR",
                                                                id: 'intActSerVDRLRPDR'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                fieldLabel: 'CONSULTA DE CONTROL PRENATAL POR MÉDICO',
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"CONSULTA DE CONTROL PRENATAL POR MÉDICO",
                                                                id: 'intActConConPreMedico'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                fieldLabel: 'CONSULTA DE CONTROL PRENATAL POR ENFERMERA',
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"CONSULTA DE CONTROL PRENATAL POR ENFERMERA",
                                                                id: 'intActConContPreEnfermeria'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                fieldLabel: 'HEMOGRAMA COMPLETO',
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"HEMOGRAMA COMPLETO",
                                                                id: 'intActHemCompleto'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                fieldLabel: 'HEMOCLASIFICACIÓN',
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"HEMOCLASIFICACIÓN",
                                                                id: 'intActHemoclasificacion'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                fieldLabel: 'UROANÁLISIS',
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"UROANÁLISIS",
                                                                id: 'intActUroanalisis'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                fieldLabel: 'GLICEMIA',
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"GLICEMIA",
                                                                id: 'intActGlicemia'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                fieldLabel: 'ULTRASONOGRAFIA PÉLVICA OBSTÉTRICA',
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"ULTRASONOGRAFIA PÉLVICA OBSTÉTRICA",
                                                                id: 'intActUltPelObstetrica'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                fieldLabel: 'SUMINISTRO DE MULTIVITAMINICOS',
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"SUMINISTRO DE MULTIVITAMINICOS",
                                                                id: 'intActSumMultivitaminicos'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                fieldLabel: 'CONSULTA ODONTOLÓGICA GENERAL DE LA GESTANTE',
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"CONSULTA ODONTOLÓGICA GENERAL DE LA GESTANTE",
                                                                id: 'intActConOdoGenGestantes'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                fieldLabel: 'APLICACIÓN DE TD O TT',
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"APLICACIÓN DE TD O TT",
                                                                id: 'intActAplTDTT'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                fieldLabel: 'CONSEJERIA PARA VIH GESTANTES',
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"CONSEJERIA PARA VIH GESTANTES",
                                                                id: 'intActConVIHGestantes'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                fieldLabel: 'PRUEBA VIH ',
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"PRUEBA VIH ",
                                                                id: 'intActPruVIH'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                fieldLabel: 'CONTROL PORSPARTO POR ENFERMERA ',
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"CONTROL PORSPARTO POR ENFERMERA ",
                                                                id: 'intActConPorEnfermeria'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                fieldLabel: 'DETECCIÓN TEMPRANA DE LAS ALTERACIONES DEL ADULTO (MAYOR DE 45 AÑOS)',
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"DETECCIÓN TEMPRANA DE LAS ALTERACIONES DEL ADULTO (MAYOR DE 45 AÑOS)",
                                                                id: 'intActDetTemAltAdulto'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                fieldLabel: 'CONSULTA MÉDICA',
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"CONSULTA MÉDICA",
                                                                id: 'intActConMedica'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                fieldLabel: 'PARCIAL DE ORINA',
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"PARCIAL DE ORINA",
                                                                id: 'intActParOrina'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                fieldLabel: 'CREATININA',
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"CREATININA",
                                                                id: 'intActCreatinina'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                fieldLabel: 'GLICEMIA BASAL',
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"GLICEMIA BASAL",
                                                                id: 'intActGliBasal'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                fieldLabel: 'PERFIL LIPÍDICO',
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"PERFIL LIPÍDICO",
                                                                id: 'intActPerLipico'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                fieldLabel: 'DETECCIÓN TEMPRANA DEL CÁNCER DE CUELLO UTERINO',
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"DETECCIÓN TEMPRANA DEL CÁNCER DE CUELLO UTERINO",
                                                                id: 'intActDetTemCanCueUterino'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                fieldLabel: 'CITOLOGÍAS',
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"CITOLOGÍAS",
                                                                id: 'intActCitologias'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                fieldLabel: 'COLPSCOPIA',
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"COLPSCOPIA",
                                                                id: 'intActColpscopia'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                fieldLabel: 'BIOPSIA',
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"BIOPSIA",
                                                                id: 'intActBiopsia'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                fieldLabel: 'DETECCIÓN TEMPRANA DEL CÁNCER DE SENO',
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"DETECCIÓN TEMPRANA DEL CÁNCER DE SENO",
                                                                id: 'intActDetTemCanSeno'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                fieldLabel: 'MAMOGRAFÍA EN MUJERES DE 45 AÑOS EN ADELANTE',
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"MAMOGRAFÍA EN MUJERES DE 45 AÑOS EN ADELANTE",
                                                                id: 'intActMamMujAñoAdelante'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                fieldLabel: 'BIOPSIA CON PUNCIÓN DE AGUJA FINA',
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"BIOPSIA CON PUNCIÓN DE AGUJA FINA",
                                                                id: 'intActBioPunAguFina'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                fieldLabel: 'DETECCIÓN TEMPRANA DE LAS ALTERACIONES DE LA AGUDEZA VISUAL',
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"DETECCIÓN TEMPRANA DE LAS ALTERACIONES DE LA AGUDEZA VISUAL",
                                                                id: 'intActDetTemAltAguVisual'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                fieldLabel: 'TAMIZAJE VISUAL 4,11,16 Y 45 AÑOS',
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"TAMIZAJE VISUAL 4,11,16 Y 45 AÑOS",
                                                                id: 'intActTamVisAños'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                fieldLabel: 'CONSULTA PRIMERA VEZ OFTALMOLOGO 55 65 70 75 80 Y MÁS',
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"CONSULTA PRIMERA VEZ OFTALMOLOGO 55 65 70 75 80 Y MÁS",
                                                                id: 'intActConPriVezOftalmologo'
                                                            }
                                                        ]
                                                    }
                                                ]                                                
                                            },
                                            // AQUI FINALIZAN CAMBIOS 
                                            {
                                                xtype: 'fieldset',
                                                title: 'RIPS',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                id: 'fsRips',
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: false,
                                                                fieldLabel: 'Diagnostico Principal',
                                                                id: 'sysDiagPpalHC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request({
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                        Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagPpalHCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Principal',
                                                                id: 'btnSearchDiagPpalHC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagPpalHC','sysDiagPpalHCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.1',
                                                                id: 'sysDiagRel1HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel1HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado1',
                                                                id: 'btnSearchDiagRel1HC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel1HC','sysDiagRel1HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.2',
                                                                id: 'sysDiagRel2HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel2HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado2',
                                                                id: 'btnSearchDiagRel2HC1',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel2HC','sysDiagRel2HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.3',
                                                                id: 'sysDiagRel3HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel3HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado3',
                                                                id: 'btnSearchDiagRel3HC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel3HC','sysDiagRel3HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Tipo de Diagnostico',
                                                        width:750,
                                                        name: 'Tipo de Diagnostico',
                                                        allowBlank: false,
                                                        store: 'StoreTipoDiagnostico',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        id: 'sysTipoDiagosticoHC'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Finalidad Consulta',
                                                        width:750,
                                                        name: 'Finalidad Consulta',
                                                        allowBlank: false,
                                                        store: 'StoreFinalidadConsulta',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 10,
                                                        id: 'sysFinalidadConsultaHC'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Causa Externa',
                                                        width:750,
                                                        name: 'Causa Externa',
                                                        allowBlank: false,
                                                        store: 'StoreCausaExterna',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 13,
                                                        id: 'sysCausaExternaHC'
                                                    }                            
                                                ]
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Medicamentos',
                                height: 352,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaMedicamentos',
                                items: [
                                    xSolMX
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Servicios',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaServicios',
                                items: [
                                    xSolEXA
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Remisiones',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaRemisiones',
                                items: [
                                    xSolREM
                                ]
                            }
                            /*,
                            {
                                xtype: 'panel',
                                title: 'Solicitud CTC',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaCTC',
                                items: [
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Consentimientos Informados',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaConsentimientos',
                                items: [
                                ]
                            },*/
                        ]
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btnSalirEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 1) 
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    if (Ext.getCmp('sysUsaGridSalida').getValue() == 1){
                                                        Ext.getCmp('gridFormulario').store.reload();
                                                    }
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Usted No ha Guardado la Evolución del Paciente y Se Perdera la Información, Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                },
                tbar:{
                    items: [
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Ver Historia Clínica',
                            iconCls: 'btnVerHC',
                            id: 'btnVerHC',
                            listeners:{
                                click : function(){
                                    var cmpResumenHC = new winFrmVerHistorialHC({
                                        renderTo: Ext.getBody()
                                    });
                                    Ext.getCmp('winViewEvolucionHC').title = "PACIENTE: " + Ext.getCmp('sysPacienteHC').getValue();
                                    Ext.getCmp('gridHistorialEvoluciones').store.load({
                                        params: {
                                            pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                                            pPaciente: Ext.getCmp('sysIdPacienteHC').getValue()
                                        }
                                    });
                                    cmpResumenHC.show();
                                }
                            }
                        },
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar Evolución',
                            iconCls: 'btnGuardar',
                            id: 'btnGuardarEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 0) 
                                    {
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Guardar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnGuardarRegistros();
                                                }
                                            }
                                        });
                                    }else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Modificar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnModificarRegistros();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                }
            }
        ];
        winHCSegProgPromPrevencionUi.superclass.initComponent.call(this);
    }
});

function fnGuardarRegistros(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc.php',
            params:{
                task: 'guardar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pidPlantillaHC : Ext.getCmp('sysIdCodPlantillaHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1); 
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function fnModificarRegistros(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc.php',
            params:{
                task: 'modificar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}
