/*
* @category    Fieldset Examen Fisico
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


fsExamenFisicoUi = Ext.extend(Ext.form.FieldSet, {
    anchor: '100%',
    autoHeight: true,
    layout: 'form',
    title: 'EXAMEN FISICO',
    collapseFirst: false,
    collapsible: true,
    animCollapse: true,
    titleCollapse: true,
    labelSeparator: '',
    padding: 0,
    id: 'fsExamenFisico',
    initComponent: function() {
        this.items = [
            {
                xtype: 'compositefield',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'combo',
                        fieldLabel: 'Tension Arterial',
                        name: 'Tension Arterial Posicion 1',
                        width: 370,
                        allowBlank: false,
                        store: stPosicionTomaTA,
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        id: 'intEXAFISTAPosicion1'
                    },
                    {
                        xtype: 'numberfield',
                        name: 'T.A. Sistolica Posicion 1',
                        width: 70,
                        minValue: 0,
                        maxValue: 300,
                        decimalPrecision: 0,
                        allowBlank: false,
                        emptyText: "Sistolica",
                        id: 'intEXAFISTASistolica1'
                    },
                    {
                        html: '/'
                    },
                    {
                        xtype: 'numberfield',
                        name: 'T.A. Diastolica Posicion 1',
                        width: 70,
                        minValue: 0,
                        maxValue: 300,
                        decimalPrecision: 0,
                        allowBlank: false,
                        emptyText: "Diastolica",
                        id: 'intEXAFISTADiastolica1'
                    }
                ]
            },
            {
                xtype: 'compositefield',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'combo',
                        fieldLabel: 'Tension Arterial',
                        name: 'Tension Arterial Posicion 2',
                        width: 370,
                        allowBlank: true,
                        store: stPosicionTomaTA,
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        id: 'intEXAFISTAPosicion2'
                    },
                    {
                        xtype: 'numberfield',
                        name: 'T.A. Sistolica Posicion 2',
                        width: 70,
                        minValue: 0,
                        maxValue: 300,
                        decimalPrecision: 0,
                        allowBlank: true,
                        emptyText: "Sistolica",
                        id: 'intEXAFISTASistolica2'
                    },
                    {
                        html: '/'
                    },
                    {
                        xtype: 'numberfield',
                        name: 'T.A. Diastolica Posicion 2',
                        width: 70,
                        minValue: 0,
                        maxValue: 300,
                        decimalPrecision: 0,
                        allowBlank: true,
                        emptyText: "Diastolica",
                        id: 'intEXAFISTADiastolica2'
                    }
                ]
            },
            {
                xtype: 'compositefield',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'numberfield',
                        width: 60,
                        minValue: 0,
                        maxValue: 250,
                        decimalPrecision: 2,
                        allowBlank: false,
                        fieldLabel: 'TALLA (cm)',
                        name:"TALLA (cm)",
                        emptyText: '(cm)',
                        id: 'intEXAFISTalla',
                        listeners:{
                            change : function(f,pNew, pOld){
                                if(pNew == null || pNew == 0){
                                    Ext.getCmp('intEXAFISTalla').setValue(null);
                                    Ext.getCmp('intEXAFISIMC').setValue(0);
                                }else{
                                    if(Ext.getCmp('intEXAFISPeso').getValue() > 0){
                                        var pTalla = Ext.getCmp('intEXAFISTalla').getValue() / 100;
                                        Ext.getCmp('intEXAFISIMC').setValue(Ext.getCmp('intEXAFISPeso').getValue()/(pTalla*pTalla));
                                    }else{
                                        Ext.getCmp('intEXAFISIMC').setValue(0);
                                    }
                                }
                               if(Ext.getCmp('intEXAFISIMC').getValue()<1){
                                   Ext.getCmp('strEXAFISIMCClasificacon').setValue(null);
                                }else{
                                    if(Ext.getCmp('intEXAFISIMC').getValue() < 16.00){
                                       Ext.getCmp('strEXAFISIMCClasificacon').setValue("DESGADEZ SEVERA");
                                    }else{
                                        if(Ext.getCmp('intEXAFISIMC').getValue()<=16.90 && Ext.getCmp('intEXAFISIMC').getValue()>=16.00){
                                           Ext.getCmp('strEXAFISIMCClasificacon').setValue("DELGADEZ MODERADA");
                                        }else{
                                            if(Ext.getCmp('intEXAFISIMC').getValue()<=18.49 && Ext.getCmp('intEXAFISIMC').getValue()>=17.00){
                                               Ext.getCmp('strEXAFISIMCClasificacon').setValue("DELGADEZ ACEPTABLE");
                                            }else{
                                                if(Ext.getCmp('intEXAFISIMC').getValue()<=24.99 && Ext.getCmp('intEXAFISIMC').getValue()>=18.50){
                                                   Ext.getCmp('strEXAFISIMCClasificacon').setValue("NORMAL");
                                                }else{
                                                    if(Ext.getCmp('intEXAFISIMC').getValue()<=29.99 && Ext.getCmp('intEXAFISIMC').getValue()>=25.00){
                                                       Ext.getCmp('strEXAFISIMCClasificacon').setValue("PREOBESO");
                                                    }else{
                                                        if(Ext.getCmp('intEXAFISIMC').getValue()<=34.99 && Ext.getCmp('intEXAFISIMC').getValue()>=30.00){
                                                           Ext.getCmp('strEXAFISIMCClasificacon').setValue("OBESO TIPO I");
                                                        }else{
                                                            if(Ext.getCmp('intEXAFISIMC').getValue()<=39.99 && Ext.getCmp('intEXAFISIMC').getValue()>=35.00){
                                                               Ext.getCmp('strEXAFISIMCClasificacon').setValue("OBESO TIPO II");
                                                            }else{
                                                                if(Ext.getCmp('intEXAFISIMC').getValue()>=40.00){
                                                                Ext.getCmp('strEXAFISIMCClasificacon').setValue("OBESO TIPO III");
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    },
                    {
                        xtype: 'displayfield',
                        id: 'sysEXAFISPeso',
                        value: 'PESO (Kg) '
                    },
                    {
                        xtype: 'numberfield',
                        width: 60,
                        minValue: 0,
                        maxValue: 250,
                        decimalPrecision: 2,
                        allowBlank: false,
                        emptyText: '(Kg)',
                        name:"PESO (Kg)",
                        id: 'intEXAFISPeso',
                        listeners:{
                            change : function(f,pNew, pOld){
                                if(pNew == null || pNew == 0){
                                    Ext.getCmp('intEXAFISPeso').setValue(null);
                                    Ext.getCmp('intEXAFISIMC').setValue(0);
                                }else{
                                    //peso [kg]/ estatura [m2]
                                    if(Ext.getCmp('intEXAFISTalla').getValue() > 0){
                                        var pTalla = Ext.getCmp('intEXAFISTalla').getValue() / 100;
                                        Ext.getCmp('intEXAFISIMC').setValue(Ext.getCmp('intEXAFISPeso').getValue()/(pTalla*pTalla));
                                    }else{
                                        Ext.getCmp('intEXAFISIMC').setValue(0);
                                    }
                                }
                                if(Ext.getCmp('intEXAFISIMC').getValue()<1){
                                   Ext.getCmp('strEXAFISIMCClasificacon').setValue(null);
                                }else{
                                    if(Ext.getCmp('intEXAFISIMC').getValue() < 16.00){
                                       Ext.getCmp('strEXAFISIMCClasificacon').setValue("DESGADEZ SEVERA");
                                    }else{
                                        if(Ext.getCmp('intEXAFISIMC').getValue()<=16.90 && Ext.getCmp('intEXAFISIMC').getValue()>=16.00){
                                           Ext.getCmp('strEXAFISIMCClasificacon').setValue("DELGADEZ MODERADA");
                                        }else{
                                            if(Ext.getCmp('intEXAFISIMC').getValue()<=18.49 && Ext.getCmp('intEXAFISIMC').getValue()>=17.00){
                                               Ext.getCmp('strEXAFISIMCClasificacon').setValue("DELGADEZ ACEPTABLE");
                                            }else{
                                                if(Ext.getCmp('intEXAFISIMC').getValue()<=24.99 && Ext.getCmp('intEXAFISIMC').getValue()>=18.50){
                                                   Ext.getCmp('strEXAFISIMCClasificacon').setValue("NORMAL");
                                                }else{
                                                    if(Ext.getCmp('intEXAFISIMC').getValue()<=29.99 && Ext.getCmp('intEXAFISIMC').getValue()>=25.00){
                                                       Ext.getCmp('strEXAFISIMCClasificacon').setValue("PREOBESO");
                                                    }else{
                                                        if(Ext.getCmp('intEXAFISIMC').getValue()<=34.99 && Ext.getCmp('intEXAFISIMC').getValue()>=30.00){
                                                           Ext.getCmp('strEXAFISIMCClasificacon').setValue("OBESO TIPO I");
                                                        }else{
                                                            if(Ext.getCmp('intEXAFISIMC').getValue()<=39.99 && Ext.getCmp('intEXAFISIMC').getValue()>=35.00){
                                                               Ext.getCmp('strEXAFISIMCClasificacon').setValue("OBESO TIPO II");
                                                            }else{
                                                                if(Ext.getCmp('intEXAFISIMC').getValue()>=40.00){
                                                                Ext.getCmp('strEXAFISIMCClasificacon').setValue("OBESO TIPO III");
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    },
                    {
                        xtype: 'displayfield',
                        id: 'sysEXAFISIMC',
                        value: 'IMC '
                    },
                    {
                        xtype: 'numberfield',
                        width: 60,
                        minValue: 0,
                        decimalPrecision: 2,
                        allowBlank: false,
                        readOnly: true,
                        name: "IMC",
                        id: 'intEXAFISIMC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: false,
                        readOnly: true,
                        name: "IMC - CLASIFICACION",
                        id: 'strEXAFISIMCClasificacon'
                    },
                    {
                        xtype: 'displayfield',
                        id: 'sysEXAFISPA',
                        value: 'P. Abd '
                    },
                    {
                        xtype: 'numberfield',
                        width: 60,
                        minValue: 0,
                        decimalPrecision: 2,
                        name: 'PA',
                        allowBlank: false,
                        id: 'strEXAFISPA'
                    }
                ]
            },
            {
                xtype: 'compositefield',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'numberfield',
                        fieldLabel: 'Temp',
                        width: 60,
                        minValue: 0,
                        decimalPrecision: 2,
                        name: 'Temperatura',
                        allowBlank: false,
                        id: 'intEXAFISTemp'
                    },
                    {
                        html: 'F.C.'
                    },                                                            
                    {
                        xtype: 'numberfield',
                        width: 60,
                        minValue: 0,
                        decimalPrecision: 2,
                        name: 'FC',
                        allowBlank: false,
                        id: 'intEXAFISFC'
                    },
                    {
                        html: 'F.R.'
                    },                                                            
                    {
                        xtype: 'numberfield',
                        width: 60,
                        minValue: 0,
                        decimalPrecision: 2,
                        name: 'FR',
                        allowBlank: false,
                        id: 'intEXAFISFR'
                    }
                ]
            },
            {
                xtype: 'textfield',
                anchor: '100%',
                fieldLabel: 'Condiciones Generales',
                name: 'Condiciones Generales',
                allowBlank: false,
                id: 'strEXAFISCondicionesGenerales',
                listeners: {
                    render: function( p ) {
                        p.getEl().on('dblclick', function (){
                            Ext.getCmp('strEXAFISCondicionesGenerales').setValue("Normal");
                        });
                    }
                }
            },
            {
                xtype: 'textfield',
                anchor: '100%',
                fieldLabel: 'Cabeza<br>&nbsp;',
                name: 'Cabeza',
                allowBlank: false,
                id: 'strEXAFISCabeza',
                listeners: {
                    render: function( p ) {
                        p.getEl().on('dblclick', function (){
                            Ext.getCmp('strEXAFISCabeza').setValue("Normal");
                        });
                    }
                }

            },
            {
                xtype: 'textfield',
                anchor: '100%',
                fieldLabel: 'Organos de los Sentidos',
                name: 'Ojos',
                allowBlank: false,
                id: 'strEXAFISOrganosSentidos',
                listeners: {
                    render: function( p ) {
                        p.getEl().on('dblclick', function (){
                            Ext.getCmp('strEXAFISOrganosSentidos').setValue("Normal");
                        });
                    }
                }
            },
            {
                xtype: 'textfield',
                anchor: '100%',
                fieldLabel: 'Orofaringe<br>&nbsp;',
                name: 'Orofaringe',
                allowBlank: false,
                id: 'strEXAFISOrofaringe',
                listeners: {
                    render: function( p ) {
                        p.getEl().on('dblclick', function (){
                            Ext.getCmp('strEXAFISOrofaringe').setValue("Normal");
                        });
                    }
                }
            },
            {
                xtype: 'textfield',
                anchor: '100%',
                fieldLabel: 'Cuello<br>&nbsp;',
                name: 'Cuello',
                allowBlank: false,
                id: 'strEXAFISCuello',
                listeners: {
                    render: function( p ) {
                        p.getEl().on('dblclick', function (){
                            Ext.getCmp('strEXAFISCuello').setValue("Normal");
                        });
                    }
                }
            },
            {
                xtype: 'fieldset',
                title: 'Valoracion Mamaria',
                layout: 'form',
                collapsible: true,
                titleCollapse: true,
                anchor: '100%',
                autoHeight: true,
                padding: 7,
                id: 'fsEXAMFISValMamaria',
                items:[
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        fieldLabel: 'Aspecto',
                        name: 'Aspecto',
                        allowBlank: false,
                        id: 'strEXAFISMamaAspecto',
                        listeners: {
                            render: function( p ) {
                                p.getEl().on('dblclick', function (){
                                    Ext.getCmp('strEXAFISMamaAspecto').setValue("Normal");
                                });
                            }
                        }
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        fieldLabel: 'Ganglios',
                        name: 'Ganglios',
                        allowBlank: false,
                        id: 'strEXAFISMamaGanglios',
                        listeners: {
                            render: function( p ) {
                                p.getEl().on('dblclick', function (){
                                    Ext.getCmp('strEXAFISMamaGanglios').setValue("Normal");
                                });
                            }
                        }
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        fieldLabel: 'Malestar',
                        name: 'Malestar',
                        allowBlank: false,
                        id: 'strEXAFISMamaMalestar',
                        listeners: {
                            render: function( p ) {
                                p.getEl().on('dblclick', function (){
                                    Ext.getCmp('strEXAFISMamaMalestar').setValue("Normal");
                                });
                            }
                        }
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        fieldLabel: 'Dolores',
                        name: 'Dolores',
                        allowBlank: false,
                        id: 'strEXAFISMamaDolor',
                        listeners: {
                            render: function( p ) {
                                p.getEl().on('dblclick', function (){
                                    Ext.getCmp('strEXAFISMamaDolor').setValue("Normal");
                                });
                            }
                        }
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        fieldLabel: 'Descargas',
                        name: 'Descargas',
                        allowBlank: false,
                        id: 'strEXAFISMamaDescargas',
                        listeners: {
                            render: function( p ) {
                                p.getEl().on('dblclick', function (){
                                    Ext.getCmp('strEXAFISMamaDescargas').setValue("Normal");
                                });
                            }
                        }
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        fieldLabel: 'Masas o Bultos',
                        name: 'Masas o Bultos',
                        allowBlank: false,
                        id: 'strEXAFISMamaMasas',
                        listeners: {
                            render: function( p ) {
                                p.getEl().on('dblclick', function (){
                                    Ext.getCmp('strEXAFISMamaMasas').setValue("Normal");
                                });
                            }
                        }
                    }
                ]
            },
            {
                xtype: 'textfield',
                anchor: '100%',
                fieldLabel: 'Dorso<br>&nbsp;',
                name: 'Dorso',
                allowBlank: false,
                id: 'strEXAFISDorso',
                listeners: {
                    render: function( p ) {
                        p.getEl().on('dblclick', function (){
                            Ext.getCmp('strEXAFISDorso').setValue("Normal");
                        });
                    }
                }
            },
            {
                xtype: 'textfield',
                anchor: '100%',
                fieldLabel: 'Cardiaco<br>&nbsp;',
                name: 'Cardiaco',
                allowBlank: false,
                id: 'strEXAFISCardiaco',
                listeners: {
                    render: function( p ) {
                        p.getEl().on('dblclick', function (){
                            Ext.getCmp('strEXAFISCardiaco').setValue("Normal");
                        });
                    }
                }
            },
            {
                xtype: 'textfield',
                anchor: '100%',
                fieldLabel: 'Pulmonar<br>&nbsp;',
                name: 'Pulmonar',
                allowBlank: false,
                id: 'strEXAFISPulmonar',
                listeners: {
                    render: function( p ) {
                        p.getEl().on('dblclick', function (){
                            Ext.getCmp('strEXAFISPulmonar').setValue("Normal");
                        });
                    }
                }
            },
            {
                xtype: 'textfield',
                anchor: '100%',
                fieldLabel: 'Abdomen<br>&nbsp;',
                name: 'Abdomen',
                allowBlank: false,
                id: 'strEXAFISAbdomen',
                listeners: {
                    render: function( p ) {
                        p.getEl().on('dblclick', function (){
                            Ext.getCmp('strEXAFISAbdomen').setValue("Normal");
                        });
                    }
                }
            },
            {
                xtype: 'textfield',
                anchor: '100%',
                fieldLabel: 'Genitales<br>&nbsp;',
                name: 'Genitales',
                allowBlank: false,
                id: 'strEXAFISGenitales',
                listeners: {
                    render: function( p ) {
                        p.getEl().on('dblclick', function (){
                            Ext.getCmp('strEXAFISGenitales').setValue("Normal");
                        });
                    }
                }
            },
            {
                xtype: 'textfield',
                anchor: '100%',
                fieldLabel: 'Extremidades<br>&nbsp;',
                name: 'Extremidades',
                allowBlank: false,
                id: 'strEXAFISExtremidades',
                listeners: {
                    render: function( p ) {
                        p.getEl().on('dblclick', function (){
                            Ext.getCmp('strEXAFISExtremidades').setValue("Normal");
                        });
                    }
                }
            },
            {
                xtype: 'textfield',
                anchor: '100%',
                fieldLabel: 'Neurologico<br>&nbsp;',
                name: 'Neurologico',
                allowBlank: false,
                id: 'strEXAFISNeurologico',
                listeners: {
                    render: function( p ) {
                        p.getEl().on('dblclick', function (){
                            Ext.getCmp('strEXAFISNeurologico').setValue("Normal");
                        });
                    }
                }
            }
        ];
        fsExamenFisicoUi.superclass.initComponent.call(this);
    }
});
