/*
* @category    Panel Mamografia Alterna
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


pnMamografiaalteUi = Ext.extend(Ext.Panel, {
    anchor: '100%',
    autoHeight: true,
    layout: 'form',
    collapseFirst: false,
    collapsible: false,
    animCollapse: false,
    titleCollapse: false,
    border: false,
    labelWidth:120,
    title: '<center>MAMOGRAFIA ALTERNA</center> ',
    padding: 5,
    id: 'pnMamAlterna',
    initComponent: function() {
        
        var dataSeguimiento=[
            ['SEGUIMIENTO 1 '],
            ['SEGUIMIENTO 2'],
            ['SEGUIMIENTO 3']
        ];
        var stSeguimiento = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stSeguimiento.loadData(dataSeguimiento);
        
        this.items = [
            {
                xtype: 'compositefield',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'datefield',
                        width:100,
                        allowBlank: true,
                        fieldLabel: 'FECHA DEL EXAMEN',
                        id: 'fecMamAltExamen',
                        name: 'FECHA DEL EXAMEN'
                    },
                    {
                        html:'RESULTADO'
                    },
                    {
                        xtype: 'textfield',
                        width:200,
                        name: 'RESULTADO',
                        id: 'strMamAltResultado'
                    }
                ]
            },
            {
                xtype: 'compositefield',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'textfield',
                        width:200,
                        allowBlank: true,
                        fieldLabel: 'DIAGNÓSTICO',
                        id: 'strMamAltDiagnostico',
                        name: 'DIAGNÓSTICO'
                    },
                    {
                        html:'CONDUCTA '
                    },
                    {
                        xtype: 'textfield',
                        width:200,
                        name: 'CONDUCTA ',
                        id: 'strMamAltConduca'
                    }
                ]
            },
            {
                xtype: 'compositefield',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'textfield',
                        width:200,
                        allowBlank: true,
                        fieldLabel: 'FASE DE DE DETECCION',
                        id: 'strMamAltFasDeteccion',
                        name: 'FASE DE DE DETECCION'
                    },
                    {
                        html:'FECHA DE REALIZACIÓN DE LA BIOPSIA '
                    },
                    {
                        xtype: 'datefield',
                        width:100,
                        name: 'FECHA DE REALIZACIÓN DE LA BIOPSIA ',
                        id: 'fecMamAltReaBiopsia'
                    },
                    {
                        html:'RESULTADO'
                    },
                    {
                        xtype: 'textfield',
                        width:200,
                        allowBlank: true,
                        id: 'strMamAltResultado',
                        name: 'RESULTADO'
                    }
                ]
            },
            {
                xtype: 'fieldset',
                layout: 'form',
                anchor: '100%',
                autoHeight: true,
                labelWidth:100,
                padding: 5,
                items:[
                    {
                        xtype: 'combo',
                        anchor: '30%',
                        store:stSeguimiento,
                        forceSelection: true,
                        fieldLabel:'SEGUIMIENTO',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        name: 'SEGUIMIENTO',
                        allowBlank: false,
                        emptyText: 'Seleccione...!',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        listEmptyText: '',
                        triggerAction: 'all',
                        mode: 'local',
                        id: 'strSeguimiento'
                    },
                    {
                        xtype: 'fieldset',
                        layout: 'form',
                        anchor: '100%',
                        autoHeight: true,
                        labelWidth:230,
                        padding: 5,
                        items:[
                            {
                                xtype: 'textfield',
                                width:400,
                                allowBlank: true,
                                fieldLabel: 'SEGUIMIENTO REALIZADO AL USUARIO Y RESULTADO  ',
                                name: 'SEGUIMIENTO REALIZADO AL USUARIO Y RESULTADO ',
                                id: 'strSegReaUsuResultado'
                            },
                            {
                                xtype: 'datefield',
                                width:100,
                                allowBlank: true,
                                fieldLabel: 'FECHA DEL PROXIMO CONTROL',
                                name: 'FECHA DEL PROXIMO CONTROL',
                                id: 'fecSegFecProControl'
                            },
                            {
                                xtype: 'datefield',
                                width:100,
                                allowBlank: true,
                                fieldLabel: 'FECHA SEGUIMIENTO PYP',
                                name: 'FECHA SEGUIMIENTO PYP',
                                id: 'fecSegFecSegPYP'
                            },
                            {
                                xtype: 'textarea',
                                fieldLabel: 'OBSERVACIONES Y/O REMISIONES ',
                                name: 'OBSERVACIONES  REMISIONES',
                                anchor:'90%',
                                id: 'memObsRemisiones'
                            }
                        ]
                    }
                ]
            }
        ];
        pnMamografiaalteUi.superclass.initComponent.call(this);
    }
});
