/*
* @category    Panel Control PostParto
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


pnAdultoJoven001Ui = Ext.extend(Ext.Panel, {
    anchor: '100%',
    autoHeight: true,
    layout: 'form',
    collapseFirst: false,
    collapsible: false,
    animCollapse: false,
    titleCollapse: false,
    border: false,
    padding: 0,
    id: 'pnAdultoJoven',
    initComponent: function() {
        this.items = [
            {
                xtype: 'panel',
                anchor: '100%',
                autoHeight: true,
                layout: 'form',
                labelWidth: 280,
                padding: 5,
                items: [
                    {
                        xtype: 'combo',
                        labelStyle: 'background-color:#FF0; color:#F00; text-decoration:blink;',
                        fieldLabel: 'Registrar HC Adulto Joven (25 a 44 años)?',
                        name: 'Registrar HC Adulto Joven (25 a 44 años)?',
                        width: 60,
                        allowBlank: false,
                        store: 'StoreSiNo',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        id: 'strRegistrarAdultoJoven',
                        listeners:{
                            change : function( t, newValue, oldValue){
                                if(newValue == "NO"){
                                    Ext.getCmp('fsAdultoJoven').setVisible(false);
                                    Ext.getCmp('strAdultoJovenExamenGlicemia').allowBlank = true;
                                    Ext.getCmp('strAdultoJovenExamenPerfilLipidico').allowBlank = true;
                                    Ext.getCmp('strAdultoJovenExamenCitologia').allowBlank = true;
                                    Ext.getCmp('strAdultoJovenEduAutocuidado').allowBlank = true;
                                    Ext.getCmp('strAdultoJovenEduNutricion').allowBlank = true;
                                    Ext.getCmp('strAdultoJovenEduEjercicio').allowBlank = true;
                                    Ext.getCmp('strAdultoJovenEduTieLib').allowBlank = true;
                                    Ext.getCmp('strAdultoJovenEduSexualidad').allowBlank = true;
                                    Ext.getCmp('strAdultoJovenEduPlaFamiliar').allowBlank = true;
                                    Ext.getCmp('strAdultoJovenEduAlcTabDro').allowBlank = true;
                                    Ext.getCmp('strAdultoJovenEduAutSeno').allowBlank = true;
                                    Ext.getCmp('strAdultoJovenEduAutTesticulos').allowBlank = true;
                                    Ext.getCmp('strAdultoJovenEduSalOral').allowBlank = true;
                                    Ext.getCmp('fecAdultoJovenProximaCita').allowBlank = true;
                                    Ext.getCmp('strAdultoJovenProximaCitaProfesionalAtiende').allowBlank = true;
                                    Ext.getCmp('strAdultoJovenExamenGlicemia').setValue(null);
                                    Ext.getCmp('strAdultoJovenExamenPerfilLipidico').setValue(null);
                                    Ext.getCmp('strAdultoJovenExamenCitologia').setValue(null);
                                    Ext.getCmp('strAdultoJovenEduAutocuidado').setValue(null);
                                    Ext.getCmp('strAdultoJovenEduNutricion').setValue(null);
                                    Ext.getCmp('strAdultoJovenEduEjercicio').setValue(null);
                                    Ext.getCmp('strAdultoJovenEduTieLib').setValue(null);
                                    Ext.getCmp('strAdultoJovenEduSexualidad').setValue(null);
                                    Ext.getCmp('strAdultoJovenEduPlaFamiliar').setValue(null);
                                    Ext.getCmp('strAdultoJovenEduAlcTabDro').setValue(null);
                                    Ext.getCmp('strAdultoJovenEduAutSeno').setValue(null);
                                    Ext.getCmp('strAdultoJovenEduAutTesticulos').setValue(null);
                                    Ext.getCmp('strAdultoJovenEduSalOral').setValue(null);
                                    Ext.getCmp('fecAdultoJovenProximaCita').setValue(null);
                                    Ext.getCmp('strAdultoJovenProximaCitaProfesionalAtiende').setValue(null);
                                    Ext.getCmp('strAdultoJovenExamenGlicemia').disable();
                                    Ext.getCmp('strAdultoJovenExamenPerfilLipidico').disable();
                                    Ext.getCmp('strAdultoJovenExamenCitologia').disable();
                                    Ext.getCmp('strAdultoJovenEduAutocuidado').disable();
                                    Ext.getCmp('strAdultoJovenEduNutricion').disable();
                                    Ext.getCmp('strAdultoJovenEduEjercicio').disable();
                                    Ext.getCmp('strAdultoJovenEduTieLib').disable();
                                    Ext.getCmp('strAdultoJovenEduSexualidad').disable();
                                    Ext.getCmp('strAdultoJovenEduPlaFamiliar').disable();
                                    Ext.getCmp('strAdultoJovenEduAlcTabDro').disable();
                                    Ext.getCmp('strAdultoJovenEduAutSeno').disable();
                                    Ext.getCmp('strAdultoJovenEduAutTesticulos').disable();
                                    Ext.getCmp('strAdultoJovenEduSalOral').disable();
                                    Ext.getCmp('fecAdultoJovenProximaCita').disable();
                                    Ext.getCmp('strAdultoJovenProximaCitaProfesionalAtiende').disable();
                                    Ext.getCmp('strAdultoJovenExamenGlicemia').clearInvalid();
                                    Ext.getCmp('strAdultoJovenExamenPerfilLipidico').clearInvalid();
                                    Ext.getCmp('strAdultoJovenExamenCitologia').clearInvalid();
                                    Ext.getCmp('strAdultoJovenEduAutocuidado').clearInvalid();
                                    Ext.getCmp('strAdultoJovenEduNutricion').clearInvalid();
                                    Ext.getCmp('strAdultoJovenEduEjercicio').clearInvalid();
                                    Ext.getCmp('strAdultoJovenEduTieLib').clearInvalid();
                                    Ext.getCmp('strAdultoJovenEduSexualidad').clearInvalid();
                                    Ext.getCmp('strAdultoJovenEduPlaFamiliar').clearInvalid();
                                    Ext.getCmp('strAdultoJovenEduAlcTabDro').clearInvalid();
                                    Ext.getCmp('strAdultoJovenEduAutSeno').clearInvalid();
                                    Ext.getCmp('strAdultoJovenEduAutTesticulos').clearInvalid();
                                    Ext.getCmp('strAdultoJovenEduSalOral').clearInvalid();
                                    Ext.getCmp('fecAdultoJovenProximaCita').clearInvalid();
                                    Ext.getCmp('strAdultoJovenProximaCitaProfesionalAtiende').clearInvalid();

                                }else{
                                    Ext.getCmp('fsAdultoJoven').setVisible(true);
                                    Ext.getCmp('strAdultoJovenExamenGlicemia').allowBlank = false;
                                    Ext.getCmp('strAdultoJovenExamenPerfilLipidico').allowBlank = false;
                                    Ext.getCmp('strAdultoJovenExamenCitologia').allowBlank = false;
                                    Ext.getCmp('strAdultoJovenEduAutocuidado').allowBlank = false;
                                    Ext.getCmp('strAdultoJovenEduNutricion').allowBlank = false;
                                    Ext.getCmp('strAdultoJovenEduEjercicio').allowBlank = false;
                                    Ext.getCmp('strAdultoJovenEduTieLib').allowBlank = false;
                                    Ext.getCmp('strAdultoJovenEduSexualidad').allowBlank = false;
                                    Ext.getCmp('strAdultoJovenEduPlaFamiliar').allowBlank = false;
                                    Ext.getCmp('strAdultoJovenEduAlcTabDro').allowBlank = false;
                                    Ext.getCmp('strAdultoJovenEduAutSeno').allowBlank = false;
                                    Ext.getCmp('strAdultoJovenEduAutTestículos').allowBlank = false;
                                    Ext.getCmp('strAdultoJovenEduSalOral').allowBlank = false;
                                    Ext.getCmp('fecAdultoJovenProximaCita').allowBlank = false;
                                    Ext.getCmp('strAdultoJovenProximaCitaProfesionalAtiende').allowBlank = false;
                                    Ext.getCmp('strAdultoJovenExamenGlicemia').enable();
                                    Ext.getCmp('strAdultoJovenExamenPerfilLipidico').enable();
                                    Ext.getCmp('strAdultoJovenExamenCitologia').enable();
                                    Ext.getCmp('strAdultoJovenEduAutocuidado').enable();
                                    Ext.getCmp('strAdultoJovenEduNutricion').enable();
                                    Ext.getCmp('strAdultoJovenEduEjercicio').enable();
                                    Ext.getCmp('strAdultoJovenEduTieLib').enable();
                                    Ext.getCmp('strAdultoJovenEduSexualidad').enable();
                                    Ext.getCmp('strAdultoJovenEduPlaFamiliar').enable();
                                    Ext.getCmp('strAdultoJovenEduAlcTabDro').enable();
                                    Ext.getCmp('strAdultoJovenEduAutSeno').enable();
                                    Ext.getCmp('strAdultoJovenEduAutTestículos').enable();
                                    Ext.getCmp('strAdultoJovenEduSalOral').enable();
                                    Ext.getCmp('fecAdultoJovenProximaCita').enable();
                                    Ext.getCmp('strAdultoJovenProximaCitaProfesionalAtiende').enable();

                                }
                            }
                        }
                    }
                ]
            },
            {
                xtype: 'fieldset',
                title: 'EVALUACION INTEGRAL ADULTO JOVEN (25 a 44 A�OS)',
                layout: 'form',
                collapsible: true,
                titleCollapse: true,
                anchor: '100%',
                autoHeight: true,
                id: 'fsAdultoJoven',
                items: [
                    {
                        xtype: 'panel',
                        title: '<center>APOYO DIAGNOSTICO</center>',
                        layout: 'form',
                        labelSeparator: '',
                        anchor: '100%',
                        autoHeight: true,
                        id: 'pnFicIntAduJovApoDX',
                        items: [
                            {   
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 60,
                                        forceSelection: true,
                                        emptyText: 'SI/NO',
                                        mode: 'local',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        listEmptyText: '',
                                        triggerAction: 'all',
                                        store:'StoreSiNo',
                                        fieldLabel:'Glicemia<br>&nbsp;',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        name:'Glicemia',
                                        id: 'strAdultoJovenExamenGlicemia',
                                        listeners:{
                                            change : function( t, newValue, oldValue){
                                                if(newValue == "NO"){
                                                    Ext.getCmp('strAdultoJovenExamenGlicemiaDescripcion').allowBlank = true;
                                                    Ext.getCmp('fecAdultoJovenExamenGlicemiaFecha').allowBlank = true;
                                                    Ext.getCmp('strAdultoJovenExamenGlicemiaDescripcion').disable();
                                                    Ext.getCmp('fecAdultoJovenExamenGlicemiaFecha').disable();
                                                    Ext.getCmp('strAdultoJovenExamenGlicemiaDescripcion').clearInvalid();
                                                    Ext.getCmp('fecAdultoJovenExamenGlicemiaFecha').clearInvalid();
                                                }else{
                                                    Ext.getCmp('strAdultoJovenExamenGlicemiaDescripcion').enable();
                                                    Ext.getCmp('fecAdultoJovenExamenGlicemiaFecha').enable();
                                                    Ext.getCmp('strAdultoJovenExamenGlicemiaDescripcion').allowBlank = false;
                                                    Ext.getCmp('fecAdultoJovenExamenGlicemiaFecha').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 250,
                                        allowBlank: true,
                                        disabled: true,
                                        name: 'Glicemia Descripcion',
                                        id: 'strAdultoJovenExamenGlicemiaDescripcion'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'datefield',
                                        name: 'Glicemia Fecha',
                                        emptyText: '(dia/mes/a�o)',
                                        width: 120,
                                        allowBlank: true,
                                        disabled: true,
                                        id: 'fecAdultoJovenExamenGlicemiaFecha'
                                    }
                                ]
                            },
                            {   
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 60,
                                        forceSelection: true,
                                        emptyText: 'SI/NO',
                                        mode: 'local',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        listEmptyText: '',
                                        triggerAction: 'all',
                                        store:'StoreSiNo',
                                        fieldLabel:'Perfil Lipidico<br>&nbsp;',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        name:'Perfil Lipidico',
                                        id: 'strAdultoJovenExamenPerfilLipidico',
                                        listeners:{
                                            change : function( t, newValue, oldValue){
                                                if(newValue == "NO"){
                                                    Ext.getCmp('strAdultoJovenExamenPerfilLipidicoDescripcion').allowBlank = true;
                                                    Ext.getCmp('fecAdultoJovenExamenPerfilLipidicoFecha').allowBlank = true;
                                                    Ext.getCmp('strAdultoJovenExamenPerfilLipidicoDescripcion').disable();
                                                    Ext.getCmp('fecAdultoJovenExamenPerfilLipidicoFecha').disable();
                                                    Ext.getCmp('strAdultoJovenExamenPerfilLipidicoDescripcion').clearInvalid();
                                                    Ext.getCmp('fecAdultoJovenExamenPerfilLipidicoFecha').clearInvalid();
                                                }else{
                                                    Ext.getCmp('strAdultoJovenExamenPerfilLipidicoDescripcion').enable();
                                                    Ext.getCmp('fecAdultoJovenExamenPerfilLipidicoFecha').enable();
                                                    Ext.getCmp('strAdultoJovenExamenPerfilLipidicoDescripcion').allowBlank = false;
                                                    Ext.getCmp('fecAdultoJovenExamenPerfilLipidicoFecha').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'textarea',
                                        anchor: '100%',
                                        allowBlank: true,
                                        disabled: true,
                                        name: 'Perfil Lipidico Descripcion',
                                        id: 'strAdultoJovenExamenPerfilLipidicoDescripcion'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'datefield',
                                        name: 'Perfil Lipidico Fecha',
                                        emptyText: '(dia/mes/a�o)',
                                        width: 120,
                                        allowBlank: true,
                                        disabled: true,
                                        id: 'fecAdultoJovenExamenPerfilLipidicoFecha'
                                    }
                                ]
                            },
                            {   
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 60,
                                        forceSelection: true,
                                        emptyText: 'SI/NO',
                                        mode: 'local',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        listEmptyText: '',
                                        triggerAction: 'all',
                                        store:'StoreSiNo',
                                        fieldLabel:'Citologia<br>&nbsp;',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        name:'Citologia',
                                        id: 'strAdultoJovenExamenCitologia',
                                        listeners:{
                                            change : function( t, newValue, oldValue){
                                                if(newValue == "NO"){
                                                    Ext.getCmp('strAdultoJovenExamenCitologiaDescripcion').allowBlank = true;
                                                    Ext.getCmp('fecAdultoJovenExamenCitologiaFecha').allowBlank = true;
                                                    Ext.getCmp('strAdultoJovenExamenCitologiaDescripcion').disable();
                                                    Ext.getCmp('fecAdultoJovenExamenCitologiaFecha').disable();
                                                    Ext.getCmp('strAdultoJovenExamenCitologiaDescripcion').clearInvalid();
                                                    Ext.getCmp('fecAdultoJovenExamenCitologiaFecha').clearInvalid();
                                                }else{
                                                    Ext.getCmp('strAdultoJovenExamenCitologiaDescripcion').enable();
                                                    Ext.getCmp('fecAdultoJovenExamenCitologiaFecha').enable();
                                                    Ext.getCmp('strAdultoJovenExamenCitologiaDescripcion').allowBlank = false;
                                                    Ext.getCmp('fecAdultoJovenExamenCitologiaFecha').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 250,
                                        allowBlank: true,
                                        disabled: true,
                                        name: 'Citologia Descripcion',
                                        id: 'strAdultoJovenExamenCitologiaDescripcion'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'datefield',
                                        name: 'Citologia Fecha',
                                        emptyText: '(dia/mes/a�o)',
                                        width: 120,
                                        allowBlank: true,
                                        disabled: true,
                                        id: 'fecAdultoJovenExamenCitologiaFecha'
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'panel',
                        title: '<center>EDUCACION</center>',
                        layout: 'form',
                        anchor: '100%',
                        autoHeight: true,
                        id: 'pnFicIntAduJovEducacion',
                        items: [
                            {
                                xtype: 'panel',
                                layout: 'table',
                                anchor: '100%',
                                padding: 0,
                                layoutConfig: {
                                    columns: 2
                                },
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'panel',
                                        layout: 'form',
                                        width: 400,
                                        autoHeight: true,
                                        labelSeparator: '',
                                        labelStyle: 'color:blue;',
                                        items: [
                                            {
                                                xtype: 'combo',
                                                width: 60,
                                                forceSelection: true,
                                                emptyText: 'SI/NO',
                                                mode: 'local',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                listEmptyText: '',
                                                triggerAction: 'all',
                                                store:'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                name:'Autocuidado',
                                                fieldLabel:'Autocuidado<br>&nbsp;',
                                                id: 'strAdultoJovenEduAutocuidado'
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 60,
                                                forceSelection: true,
                                                emptyText: 'SI/NO',
                                                mode: 'local',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                listEmptyText: '',
                                                triggerAction: 'all',
                                                store:'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                name:'Nutricion',
                                                fieldLabel:'Nutricion<br>&nbsp;',
                                                id: 'strAdultoJovenEduNutricion'
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 60,
                                                forceSelection: true,
                                                emptyText: 'SI/NO',
                                                mode: 'local',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                listEmptyText: '',
                                                triggerAction: 'all',
                                                store:'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                name:'Ejercicio',
                                                fieldLabel:'Ejercicio<br>&nbsp;',
                                                id: 'strAdultoJovenEduEjercicio'
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 60,
                                                forceSelection: true,
                                                emptyText: 'SI/NO',
                                                mode: 'local',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                listEmptyText: '',
                                                triggerAction: 'all',
                                                store:'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                name:'Tiempo Libre',
                                                fieldLabel:'Tiempo Libre<br>&nbsp;',
                                                id: 'strAdultoJovenEduTieLib'
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 60,
                                                forceSelection: true,
                                                emptyText: 'SI/NO',
                                                mode: 'local',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                listEmptyText: '',
                                                triggerAction: 'all',
                                                store:'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                name:'Sexualidad',
                                                fieldLabel:'Sexualidad<br>&nbsp;',
                                                id: 'strAdultoJovenEduSexualidad'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'panel',
                                        layout: 'form',
                                        width: 400,
                                        autoHeight: true,
                                        labelSeparator: '',
                                        labelStyle: 'color:blue;',
                                        items: [
                                            {
                                                xtype: 'combo',
                                                width: 60,
                                                forceSelection: true,
                                                emptyText: 'SI/NO',
                                                mode: 'local',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                listEmptyText: '',
                                                triggerAction: 'all',
                                                store:'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                name:'Planificacion Familiar',
                                                fieldLabel:'Planificacion Familiar',
                                                id: 'strAdultoJovenEduPlaFamiliar'
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 60,
                                                forceSelection: true,
                                                emptyText: 'SI/NO',
                                                mode: 'local',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                listEmptyText: '',
                                                triggerAction: 'all',
                                                store:'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                name:'Alcohol, Tabaco y Drogas',
                                                fieldLabel:'Alcohol, Tabaco y Drogas',
                                                id: 'strAdultoJovenEduAlcTabDro'
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 60,
                                                forceSelection: true,
                                                emptyText: 'SI/NO',
                                                mode: 'local',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                listEmptyText: '',
                                                triggerAction: 'all',
                                                store:'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                name:'Autoexamen Seno',
                                                fieldLabel:'Autoexamen Seno',
                                                id: 'strAdultoJovenEduAutSeno'
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 60,
                                                forceSelection: true,
                                                emptyText: 'SI/NO',
                                                mode: 'local',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                listEmptyText: '',
                                                triggerAction: 'all',
                                                store:'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                name:'Autoexamen Testiculo',
                                                fieldLabel:'Autoexamen Testiculo',
                                                id: 'strAdultoJovenEduAutTestículos'
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 60,
                                                forceSelection: true,
                                                emptyText: 'SI/NO',
                                                mode: 'local',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                listEmptyText: '',
                                                triggerAction: 'all',
                                                store:'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                name:'Salud Oral',
                                                fieldLabel:'Salud Oral<br>&nbsp;',
                                                id: 'strAdultoJovenEduSalOral'
                                            }
                                        ]
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'datefield',
                                width: 120,
                                fieldLabel: 'Fecha Probable Proxima Cita',
                                name: 'Fecha Probable Proxima Cita',
                                allowBlank: true,
                                emptyText: '(dia/mes/a�o) ',
                                style: 'text-align:center;',
                                id: 'fecAdultoJovenProximaCita'
                            },
                            {
                                html: 'Profesional que Atiende'
                            },
                            {
                                xtype: 'combo',
                                name: 'Profesional que Atiende',
                                width: 250,
                                allowBlank: true,
                                store: stProfesionalAtiende,
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strAdultoJovenProximaCitaProfesionalAtiende'
                            }
                        ]
                    },
                    {
                        xtype: 'textarea',
                        anchor: '100%',
                        width: 880,
                        fieldLabel: 'PLAN',
                        name: 'PLAN',
                        height: 100,
                        allowBlank: true,
                        id: 'memAdultoJovenPlan'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                width: 96,
                                allowBlank: true,
                                fieldLabel: 'Diagnostico',
                                id: 'sysAdultoJovenDiag',
                                listeners:{
                                    specialkey: function(f,e){
                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                        {
                                            if (f.getValue() != "" && f.getValue() != null){
                                                Ext.Ajax.request({
                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                    params:{
                                                        task: 'BUSCAR',
                                                        pCodigo: f.getValue().toUpperCase()
                                                    },
                                                    success: function(response,options)
                                                    {
                                                        var el = Ext.get('response'); // get the LOG
                                                        var Respuesta = response.responseText;
                                                        var Contenido = Respuesta.split('^');
                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                            Ext.getCmp('sysAdultoJovenDiag').setValue(null);
                                                            Ext.getCmp('sysAdultoJovenDiagNom').setValue(null);
                                                        } else {
                                                            Ext.getCmp('sysAdultoJovenDiag').setValue(Contenido[0]);
                                                            Ext.getCmp('sysAdultoJovenDiagNom').setValue(Contenido[1]);
                                                        }
                                                    },
                                                    failure: function(response,options){
                                                        var el = Ext.get('response');
                                                        Ext.getCmp('sysAdultoJovenDiag').setValue(null);
                                                        Ext.getCmp('sysAdultoJovenDiagNom').setValue(null);
                                                    },
                                                    scope:this //bind the callbacks
                                                });
                                            }else{
                                                Ext.getCmp('sysAdultoJovenDiag').setValue(null);
                                                Ext.getCmp('sysAdultoJovenDiagNom').setValue(null);
                                            }
                                        }
                                    }
                                }
                            },
                            {
                                xtype: 'textarea',
                                readOnly: true,
                                width: 625,
                                height: 22,
                                id: 'sysAdultoJovenDiagNom'
                            },
                            {
                                xtype: 'button',
                                iconCls: 'btnBuscar',
                                tooltip: 'Buscar Diagnostico Principal',
                                listeners:{
                                    click : function(){
                                        buscarcie10('sysAdultoJovenDiag','sysAdultoJovenDiagNom');
                                    }
                                }
                            }
                        ]
                    }
                ]
            }
        ];
        pnAdultoJoven001Ui.superclass.initComponent.call(this);
    }
});

