/*
* @category    Panel PSA Alterados
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


pnPSAAlteradosUi = Ext.extend(Ext.Panel, {
    anchor: '100%',
    autoHeight: true,
    layout: 'form',
    collapseFirst: false,
    collapsible: false,
    title: '<center>PSA ALTERADOS</center> ',
    animCollapse: false,
    labelWidth:120,
    titleCollapse: false,
    border: false,
    padding: 5,
    id: 'pnPSAAlterados',
    initComponent: function() {
        
        var dataSeguimiento=[
            ['SEGUIMIENTO 1 '],
            ['SEGUIMIENTO 2'],
            ['SEGUIMIENTO 3']
        ];
        var stSeguimiento = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stSeguimiento.loadData(dataSeguimiento);
        
        this.items = [
            {
                xtype: 'compositefield',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'datefield',
                        width:100,
                        allowBlank: true,
                        fieldLabel: 'FECHA DEL EXAMEN',
                        id: 'fecPSAAltExamen',
                        name: 'FECHA DEL EXAMEN'
                    },
                    {
                        html:'RESULTADO'
                    },
                    {
                        xtype: 'textfield',
                        width:200,
                        name: 'RESULTADO',
                        id: 'strPSAAltResultado'
                    }
                ]
            },
            {
                xtype: 'compositefield',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'textfield',
                        width:200,
                        allowBlank: true,
                        fieldLabel: 'DIAGNÓSTICO',
                        id: 'strPSAAltDiagnostico',
                        name: 'DIAGNÓSTICO'
                    },
                    {
                        html:'CONDUCTA '
                    },
                    {
                        xtype: 'textarea',
                        width:200,
                        name: 'CONDUCTA ',
                        id: 'strPSAAltConduca'
                    }
                ]
            },
            {
                xtype: 'compositefield',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'textfield',
                        width:200,
                        allowBlank: true,
                        fieldLabel: 'FASE DE DE DETECCION',
                        id: 'strPSAAltFasDeteccion',
                        name: 'FASE DE DE DETECCION'
                    },
                    {
                        html:'FECHA DE REALIZACIÓN DE LA BIOPSIA '
                    },
                    {
                        xtype: 'datefield',
                        width:100,
                        name: 'FECHA DE REALIZACIÓN DE LA BIOPSIA ',
                        id: 'fecPSAAltReaBiopsia'
                    },
                    {
                        html:'RESULTADO'
                    },
                    {
                        xtype: 'textfield',
                        width:200,
                        allowBlank: true,
                        id: 'strPSAAltResultado',
                        name: 'RESULTADO'
                    }
                ]
            },
            {
                xtype: 'fieldset',
                layout: 'form',
                anchor: '100%',
                autoHeight: true,
                labelWidth:100,
                padding: 5,
                items:[
                    {
                        xtype: 'combo',
                        anchor: '30%',
                        store:stSeguimiento,
                        forceSelection: true,
                        fieldLabel:'SEGUIMIENTO',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        name: 'SEGUIMIENTO',
                        allowBlank: false,
                        emptyText: 'Seleccione...!',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        listEmptyText: '',
                        triggerAction: 'all',
                        mode: 'local',
                        id: 'strPSASeguimiento'
                    },
                    {
                        xtype: 'fieldset',
                        layout: 'form',
                        anchor: '100%',
                        autoHeight: true,
                        labelWidth:230,
                        padding: 5,
                        items:[
                            {
                                xtype: 'textfield',
                                width:400,
                                allowBlank: true,
                                fieldLabel: 'SEGUIMIENTO REALIZADO AL USUARIO Y RESULTADO  ',
                                name: 'SEGUIMIENTO REALIZADO AL USUARIO Y RESULTADO ',
                                id: 'strPSASegReaUsuResultado'
                            },
                            {
                                xtype: 'datefield',
                                width:100,
                                allowBlank: true,
                                fieldLabel: 'FECHA DEL PROXIMO CONTROL',
                                name: 'FECHA DEL PROXIMO CONTROL',
                                id: 'fecPSASegFecProControl'
                            },
                            {
                                xtype: 'datefield',
                                width:100,
                                allowBlank: true,
                                fieldLabel: 'FECHA SEGUIMIENTO PYP',
                                name: 'FECHA SEGUIMIENTO PYP',
                                id: 'fecPSASegFecSegPYP'
                            },
                            {
                                xtype: 'textarea',
                                fieldLabel: 'OBSERVACIONES Y/O REMISIONES ',
                                name: 'OBSERVACIONES  REMISIONES',
                                anchor:'90%',
                                id: 'memPSAObsRemisiones'
                            }
                        ]
                    }
                ]
            }
        ];
        pnPSAAlteradosUi.superclass.initComponent.call(this);
    }
});
