/*
* @category    Panel Guia Integral Menor (Menor De 10 Años)
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


pnGuiIntMenorUi = Ext.extend(Ext.Panel, {
    anchor: '100%',
    autoHeight: true,
    layout: 'form',
    collapseFirst: false,
    collapsible: false,
    animCollapse: false,
    titleCollapse: false,
    border: false,
    title: '<center>GUIA INTEGRAL MENOR (MENOR DE 10 AÑOS)</center> ',
    padding: 5,
    id: 'pnGuiIntMenor',
    initComponent: function() {
        
        var dataMenoresAno=[
            ['1 MES'],
            ['3 MESES'],
            ['6 MESES'],
            ['9 MESES'],
            ['1 AÑO']
        ];
        
        var stMenoresAno = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stMenoresAno.loadData(dataMenoresAno);
        
        var dataDeUnoADosAnos=[
            ['16 MESES'],
            ['20 MESES'],
            ['2 AÑOS']
        ];
        var stDeUnoADosAnos = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stDeUnoADosAnos.loadData(dataDeUnoADosAnos);
        
        var dataMayorDosACuaAnos=[
            ['30 MESES'],
            ['3 AÑOS '],
            ['42 MESES'],
            ['4 AÑOS']
        ];
        var stMayorDosACuaAnos = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stMayorDosACuaAnos.loadData(dataMayorDosACuaAnos);
        
        var dataMayorACinco=[
            ['5 AÑOS'],
            ['6 AÑOS '],
            ['7 AÑOS'],
            ['8 AÑOS'],
            ['9 AÑOS']
        ];
        var stMayorACinco = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stMayorACinco.loadData(dataMayorACinco);
        
        this.items = [
            {
                xtype: 'fieldset',
                title: 'MENORES DE UN AÑO ',
                layout: 'form',
                collapseFirst: false,
                collapsible: true,
                animCollapse: true,
                titleCollapse: true,
                anchor: '100%',
                autoHeight: true,
                labelWidth:40,
                padding: 5,
                id: 'fsMenAno',
                items:[
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'combo',
                                anchor: '100%',
                                store:stMenoresAno,
                                forceSelection: true,
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                fieldLabel: 'MES ',
                                name: 'MES',
                                allowBlank: false,
                                emptyText: 'Seleccione...!',
                                typeAhead: true,
                                typeAheadDelay: 50,
                                listEmptyText: '',
                                triggerAction: 'all',
                                mode: 'local',
                                id: 'strMenAnoCombMes'
                            },
                            {
                                html:'FECHA'
                            },
                            {
                                xtype: 'datefield',
                                name: 'FECHA',
                                width: 100,
                                id: 'fecMenAnoFecha'
                            }
                        ]
                    }
                ]
            },
            {
                xtype: 'fieldset',
                title: 'DE 1 A 2 AÑOS  ',
                layout: 'form',
                collapseFirst: false,
                collapsible: true,
                animCollapse: true,
                titleCollapse: true,
                anchor: '100%',
                labelWidth:40,
                autoHeight: true,
                padding: 5,
                id: 'fsDe1A2Anos',
                items:[
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'combo',
                                anchor: '100%',
                                store:stDeUnoADosAnos,
                                forceSelection: true,
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                fieldLabel: 'MES ',
                                name: 'MES',
                                allowBlank: false,
                                emptyText: 'Seleccione...!',
                                typeAhead: true,
                                typeAheadDelay: 50,
                                listEmptyText: '',
                                triggerAction: 'all',
                                mode: 'local',
                                id: 'strCombDe1A2AnoMes'
                            },
                            {
                                html:'FECHA'
                            },
                            {
                                xtype: 'datefield',
                                name: 'FECHA',
                                width: 100,
                                id: 'fecDe1A2AnoFecha'
                            }
                        ]
                    }
                ]
            },
            {
                xtype: 'fieldset',
                title: 'MAYOR DE  2 AÑOS  A 4 AÑOS',
                layout: 'form',
                collapseFirst: false,
                collapsible: true,
                animCollapse: true,
                titleCollapse: true,
                anchor: '100%',
                labelWidth:80,
                autoHeight: true,
                padding: 5,
                id: 'fsMayDosAnoACuaAnos',
                items:[
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'combo',
                                anchor: '100%',
                                store:stMayorDosACuaAnos,
                                forceSelection: true,
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                fieldLabel: 'MES  O AÑOS ',
                                name: 'MES  O AÑOS',
                                allowBlank: false,
                                emptyText: 'Seleccione...!',
                                typeAhead: true,
                                typeAheadDelay: 50,
                                listEmptyText: '',
                                triggerAction: 'all',
                                mode: 'local',
                                id: 'strCombMayDosAnoACuaAnoMesAno'
                            },
                            {
                                html:'FECHA'
                            },
                            {
                                xtype: 'datefield',
                                name: 'FECHA',
                                width: 100,
                                id: 'fecMayDosAnoACuaAnoFecha'
                            },
                            {
                                html:'EXAMEN OPTOMETRICO  4 AÑOS'
                            },
                            {
                                xtype: 'datefield',
                                name: 'EXAMEN OPTOMETRICO 4 AÑOS',
                                width: 100,
                                id: 'fecMayDosAnoACuaAnoExaOptometrico'
                            },
                            {
                                html:'AUDIOMETRIA 4 AÑOS'
                            },
                            {
                                xtype: 'datefield',
                                name: 'AUDIOMETRIA 4 AÑOS',
                                width: 100,
                                id: 'fecMayDosAnoACuaAnoAudiometria'
                            }
                        ]
                    }
                ]
            },
            {
                xtype: 'fieldset',
                layout: 'form',
                title:'MAYOR DE CINCO AÑOS ',
                collapseFirst: false,
                collapsible: true,
                animCollapse: true,
                titleCollapse: true,
                anchor: '100%',
                autoHeight: true,
                labelWidth:40,
                padding: 5,
                id: 'fsMayCinAnos',
                items:[
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'combo',
                                anchor: '100%',
                                store:stMayorACinco,
                                forceSelection: true,
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                fieldLabel: 'AÑOS ',
                                name: 'AÑOS',
                                allowBlank: false,
                                emptyText: 'Seleccione...!',
                                typeAhead: true,
                                typeAheadDelay: 50,
                                listEmptyText: '',
                                triggerAction: 'all',
                                mode: 'local',
                                id: 'strCombMayCinAnoMes'
                            },
                            {
                                html:'FECHA'
                            },
                            {
                                xtype: 'datefield',
                                name: 'FECHA',
                                width: 100,
                                id: 'fecMayCinFecha'
                            },
                            {
                                html:'HB HCT 7 AÑOS'
                            },
                            {
                                xtype: 'datefield',
                                name: 'HB  HCT 7 AÑOS',
                                width: 100,
                                id: 'fecMayCinHBHCTAnos'
                            }
                        ]
                    }
                ]
            },
            {
                xtype: 'fieldset',
                layout: 'form',
                collapseFirst: false,
                collapsible: true,
                animCollapse: true,
                titleCollapse: true,
                anchor: '100%',
                labelWidth:80,
                autoHeight: true,
                padding: 5,
                items:[
                    {
                        xtype: 'textfield',
                        anchor: '20%',
                        allowBlank: true,
                        fieldLabel: 'EDUCACION',
                        id: 'strEducacion1',
                        name: 'EDUCACION'
                    },
                    {
                        xtype: 'fieldset',
                        layout: 'form',
                        anchor: '80%',
                        labelWidth:200,
                        autoHeight: true,
                        padding: 5,
                        items:[
                            {
                                xtype: 'textfield',
                                anchor: '45%',
                                allowBlank: true,
                                labelWidth:300,
                                fieldLabel: 'ASESORIA EN SALUD MENTAL',
                                name: 'ASESORIA EN SALUD MENTAL',
                                id: 'strEducacion'
                            },
                            {
                                xtype: 'datefield',
                                fieldLabel: 'ULTIMA CONSULTA CTO Y DLLO MEGA',
                                name: 'ULTIMA CONSULTA CTO Y DLLO MEGA',
                                anchor: '35%',
                                id: 'fecUltConCTODLloMega'
                            },
                            {
                                xtype: 'datefield',
                                fieldLabel: 'PROXIMA CITA GUIA',
                                name: 'PROXIMA CITA GUIA',
                                anchor: '35%',
                                id: 'fecProCitGuia'
                            },
                            {
                                xtype: 'textarea',
                                fieldLabel: 'OBSERVACIONES  REMISIONES ',
                                name: 'OBSERVACIONES  REMISIONES',
                                anchor:'90%',
                                id: 'memObsRemisiones'
                            }
                        ]
                    }
                ]
            }
        ];
        pnGuiIntMenorUi.superclass.initComponent.call(this);
    }
});
