/*
* @category    Panel Control PostParto
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


pnAnciano001Ui = Ext.extend(Ext.Panel, {
    anchor: '100%',
    autoHeight: true,
    layout: 'form',
    collapseFirst: false,
    collapsible: false,
    animCollapse: false,
    titleCollapse: false,
    border: false,
    padding: 0,
    id: 'pnAnciano',
    initComponent: function() {
        this.items = [
            {
                xtype: 'panel',
                anchor: '100%',
                autoHeight: true,
                layout: 'form',
                labelWidth: 280,
                padding: 5,
                items: [
                    {
                        xtype: 'combo',
                        labelStyle: 'background-color:#FF0; color:#F00; text-decoration:blink;',
                        fieldLabel: 'Registrar HC Anciano (Mayor 64 años)?',
                        name: 'Registrar HC Anciano (Mayor 64 años)?',
                        width: 60,
                        allowBlank: false,
                        store: 'StoreSiNo',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        id: 'strRegistrarAnciano',
                        listeners:{
                            change : function( t, newValue, oldValue){
                                if(newValue == "NO"){
                                    Ext.getCmp('fsAnciano').setVisible(false);
                                    Ext.getCmp('strAncianoExamenOftalmologico').allowBlank = true;
                                    Ext.getCmp('strAncianoExamenGlicemia').allowBlank = true;
                                    Ext.getCmp('strAncianoExamenPerfilLipidico').allowBlank = true;
                                    Ext.getCmp('strAncianoExamenParcialOrina').allowBlank = true;
                                    Ext.getCmp('strAncianoExamenCreatinina').allowBlank = true;
                                    Ext.getCmp('strAncianoExamenAntigenoProstatico').allowBlank = true;
                                    Ext.getCmp('strAncianoExamenMamografia').allowBlank = true;
                                    Ext.getCmp('strAncianoExamenCitologia').allowBlank = true;
                                    Ext.getCmp('strAncianoExamenSandreOcultaHeces').allowBlank = true;
                                    Ext.getCmp('strAncianoEduAutocuidado').allowBlank = true;
                                    Ext.getCmp('strAncianoEduNutricion').allowBlank = true;
                                    Ext.getCmp('strAncianoEduEjercicio').allowBlank = true;
                                    Ext.getCmp('strAncianoEduTieLib').allowBlank = true;
                                    Ext.getCmp('strAncianoEduSexualidad').allowBlank = true;
                                    Ext.getCmp('strAncianoEduPlaFamiliar').allowBlank = true;
                                    Ext.getCmp('strAncianoEduAlcTabDro').allowBlank = true;
                                    Ext.getCmp('strAncianoEduAutSeno').allowBlank = true;
                                    Ext.getCmp('strAncianoEduAutTesticulos').allowBlank = true;
                                    Ext.getCmp('strAncianoEduSalOral').allowBlank = true;
                                    Ext.getCmp('fecAncianoProximaCita').allowBlank = true;
                                    Ext.getCmp('strAncianoProximaCitaProfesionalAtiende').allowBlank = true;
                                    Ext.getCmp('memAncianoPlan').allowBlank = true;
                                    Ext.getCmp('strAncianoExamenOftalmologico').setValue(null);
                                    Ext.getCmp('strAncianoExamenGlicemia').setValue(null);
                                    Ext.getCmp('strAncianoExamenPerfilLipidico').setValue(null);
                                    Ext.getCmp('strAncianoExamenParcialOrina').setValue(null);
                                    Ext.getCmp('strAncianoExamenCreatinina').setValue(null);
                                    Ext.getCmp('strAncianoExamenAntigenoProstatico').setValue(null);
                                    Ext.getCmp('strAncianoExamenMamografia').setValue(null);
                                    Ext.getCmp('strAncianoExamenCitologia').setValue(null);
                                    Ext.getCmp('strAncianoExamenSandreOcultaHeces').setValue(null);
                                    Ext.getCmp('strAncianoEduAutocuidado').setValue(null);
                                    Ext.getCmp('strAncianoEduNutricion').setValue(null);
                                    Ext.getCmp('strAncianoEduEjercicio').setValue(null);
                                    Ext.getCmp('strAncianoEduTieLib').setValue(null);
                                    Ext.getCmp('strAncianoEduSexualidad').setValue(null);
                                    Ext.getCmp('strAncianoEduPlaFamiliar').setValue(null);
                                    Ext.getCmp('strAncianoEduAlcTabDro').setValue(null);
                                    Ext.getCmp('strAncianoEduAutSeno').setValue(null);
                                    Ext.getCmp('strAncianoEduAutTesticulos').setValue(null);
                                    Ext.getCmp('strAncianoEduSalOral').setValue(null);
                                    Ext.getCmp('fecAncianoProximaCita').setValue(null);
                                    Ext.getCmp('strAncianoProximaCitaProfesionalAtiende').setValue(null);
                                    Ext.getCmp('memAncianoPlan').setValue(null);
                                    Ext.getCmp('strAncianoExamenOftalmologico').disable();
                                    Ext.getCmp('strAncianoExamenGlicemia').disable();
                                    Ext.getCmp('strAncianoExamenPerfilLipidico').disable();
                                    Ext.getCmp('strAncianoExamenParcialOrina').disable();
                                    Ext.getCmp('strAncianoExamenCreatinina').disable();
                                    Ext.getCmp('strAncianoExamenAntigenoProstatico').disable();
                                    Ext.getCmp('strAncianoExamenMamografia').disable();
                                    Ext.getCmp('strAncianoExamenCitologia').disable();
                                    Ext.getCmp('strAncianoExamenSandreOcultaHeces').disable();
                                    Ext.getCmp('strAncianoEduAutocuidado').disable();
                                    Ext.getCmp('strAncianoEduNutricion').disable();
                                    Ext.getCmp('strAncianoEduEjercicio').disable();
                                    Ext.getCmp('strAncianoEduTieLib').disable();
                                    Ext.getCmp('strAncianoEduSexualidad').disable();
                                    Ext.getCmp('strAncianoEduPlaFamiliar').disable();
                                    Ext.getCmp('strAncianoEduAlcTabDro').disable();
                                    Ext.getCmp('strAncianoEduAutSeno').disable();
                                    Ext.getCmp('strAncianoEduAutTesticulos').disable();
                                    Ext.getCmp('strAncianoEduSalOral').disable();
                                    Ext.getCmp('fecAncianoProximaCita').disable();
                                    Ext.getCmp('strAncianoProximaCitaProfesionalAtiende').disable();
                                    Ext.getCmp('memAncianoPlan').disable();
                                    Ext.getCmp('strAncianoExamenOftalmologico').clearInvalid();
                                    Ext.getCmp('strAncianoExamenGlicemia').clearInvalid();
                                    Ext.getCmp('strAncianoExamenPerfilLipidico').clearInvalid();
                                    Ext.getCmp('strAncianoExamenParcialOrina').clearInvalid();
                                    Ext.getCmp('strAncianoExamenCreatinina').clearInvalid();
                                    Ext.getCmp('strAncianoExamenAntigenoProstatico').clearInvalid();
                                    Ext.getCmp('strAncianoExamenMamografia').clearInvalid();
                                    Ext.getCmp('strAncianoExamenCitologia').clearInvalid();
                                    Ext.getCmp('strAncianoExamenSandreOcultaHeces').clearInvalid();
                                    Ext.getCmp('strAncianoEduAutocuidado').clearInvalid();
                                    Ext.getCmp('strAncianoEduNutricion').clearInvalid();
                                    Ext.getCmp('strAncianoEduEjercicio').clearInvalid();
                                    Ext.getCmp('strAncianoEduTieLib').clearInvalid();
                                    Ext.getCmp('strAncianoEduSexualidad').clearInvalid();
                                    Ext.getCmp('strAncianoEduPlaFamiliar').clearInvalid();
                                    Ext.getCmp('strAncianoEduAlcTabDro').clearInvalid();
                                    Ext.getCmp('strAncianoEduAutSeno').clearInvalid();
                                    Ext.getCmp('strAncianoEduAutTesticulos').clearInvalid();
                                    Ext.getCmp('strAncianoEduSalOral').clearInvalid();
                                    Ext.getCmp('fecAncianoProximaCita').clearInvalid();
                                    Ext.getCmp('strAncianoProximaCitaProfesionalAtiende').clearInvalid();
                                    Ext.getCmp('memAncianoPlan').clearInvalid();
                                }else{
                                    Ext.getCmp('fsAnciano').setVisible(true);
                                    Ext.getCmp('strAncianoExamenOftalmologico').allowBlank = false;
                                    Ext.getCmp('strAncianoExamenGlicemia').allowBlank = false;
                                    Ext.getCmp('strAncianoExamenPerfilLipidico').allowBlank = false;
                                    Ext.getCmp('strAncianoExamenParcialOrina').allowBlank = false;
                                    Ext.getCmp('strAncianoExamenCreatinina').allowBlank = false;
                                    Ext.getCmp('strAncianoExamenAntigenoProstatico').allowBlank = false;
                                    Ext.getCmp('strAncianoExamenMamografia').allowBlank = false;
                                    Ext.getCmp('strAncianoExamenCitologia').allowBlank = false;
                                    Ext.getCmp('strAncianoExamenSandreOcultaHeces').allowBlank = false;
                                    Ext.getCmp('strAncianoEduAutocuidado').allowBlank = false;
                                    Ext.getCmp('strAncianoEduNutricion').allowBlank = false;
                                    Ext.getCmp('strAncianoEduEjercicio').allowBlank = false;
                                    Ext.getCmp('strAncianoEduTieLib').allowBlank = false;
                                    Ext.getCmp('strAncianoEduSexualidad').allowBlank = false;
                                    Ext.getCmp('strAncianoEduPlaFamiliar').allowBlank = false;
                                    Ext.getCmp('strAncianoEduAlcTabDro').allowBlank = false;
                                    Ext.getCmp('strAncianoEduAutSeno').allowBlank = false;
                                    Ext.getCmp('strAncianoEduAutTesticulos').allowBlank = false;
                                    Ext.getCmp('strAncianoEduSalOral').allowBlank = false;
                                    Ext.getCmp('fecAncianoProximaCita').allowBlank = false;
                                    Ext.getCmp('strAncianoProximaCitaProfesionalAtiende').allowBlank = false;
                                    Ext.getCmp('memAncianoPlan').allowBlank = false;
                                    Ext.getCmp('strAncianoExamenOftalmologico').enable();
                                    Ext.getCmp('strAncianoExamenGlicemia').enable();
                                    Ext.getCmp('strAncianoExamenPerfilLipidico').enable();
                                    Ext.getCmp('strAncianoExamenParcialOrina').enable();
                                    Ext.getCmp('strAncianoExamenCreatinina').enable();
                                    Ext.getCmp('strAncianoExamenAntigenoProstatico').enable();
                                    Ext.getCmp('strAncianoExamenMamografia').enable();
                                    Ext.getCmp('strAncianoExamenCitologia').enable();
                                    Ext.getCmp('strAncianoExamenSandreOcultaHeces').enable();
                                    Ext.getCmp('strAncianoEduAutocuidado').enable();
                                    Ext.getCmp('strAncianoEduNutricion').enable();
                                    Ext.getCmp('strAncianoEduEjercicio').enable();
                                    Ext.getCmp('strAncianoEduTieLib').enable();
                                    Ext.getCmp('strAncianoEduSexualidad').enable();
                                    Ext.getCmp('strAncianoEduPlaFamiliar').enable();
                                    Ext.getCmp('strAncianoEduAlcTabDro').enable();
                                    Ext.getCmp('strAncianoEduAutSeno').enable();
                                    Ext.getCmp('strAncianoEduAutTesticulos').enable();
                                    Ext.getCmp('strAncianoEduSalOral').enable();
                                    Ext.getCmp('fecAncianoProximaCita').enable();
                                    Ext.getCmp('strAncianoProximaCitaProfesionalAtiende').enable();
                                    Ext.getCmp('memAncianoPlan').enable();
                                }
                            }
                        }
                    }
                ]
            },
            {
                xtype: 'fieldset',
                title: 'EVALUACÓN INTEGRAL AL ANCIANO (10 a 24 AÑOS)',
                layout: 'form',
                collapsible: true,
                titleCollapse: true,
                anchor: '100%',
                autoHeight: true,
                id: 'fsAnciano',
                items: [
                    {
                        xtype: 'panel',
                        title: '<center>APOYO DIAGNOSTICO</center>',
                        layout: 'form',
                        labelSeparator: '',
                        anchor: '100%',
                        autoHeight: true,
                        id: 'pnFicIntAncianoApoDiagnostico',
                        items: [
                            {   
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 60,
                                        forceSelection: true,
                                        emptyText: 'SI/NO',
                                        mode: 'local',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        listEmptyText: '',
                                        triggerAction: 'all',
                                        store:'StoreSiNo',
                                        fieldLabel:'Examen Oftalmologico',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        name:'Examen Oftalmologico',
                                        id: 'strAncianoExamenOftalmologico',
                                        listeners:{
                                            change : function( t, newValue, oldValue){
                                                if(newValue == "NO"){
                                                    Ext.getCmp('strAncianoExamenOftalmologicoDescripcion').allowBlank = true;
                                                    Ext.getCmp('fecAncianoExamenOftalmologicoFecha').allowBlank = true;
                                                    Ext.getCmp('strAncianoExamenOftalmologicoDescripcion').disable();
                                                    Ext.getCmp('fecAncianoExamenOftalmologicoFecha').disable();
                                                    Ext.getCmp('strAncianoExamenOftalmologicoDescripcion').clearInvalid();
                                                    Ext.getCmp('fecAncianoExamenOftalmologicoFecha').clearInvalid();
                                                }else{
                                                    Ext.getCmp('strAncianoExamenOftalmologicoDescripcion').enable();
                                                    Ext.getCmp('fecAncianoExamenOftalmologicoFecha').enable();
                                                    Ext.getCmp('strAncianoExamenOftalmologicoDescripcion').allowBlank = false;
                                                    Ext.getCmp('fecAncianoExamenOftalmologicoFecha').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 250,
                                        allowBlank: true,
                                        disabled: true,
                                        name: 'Examen Oftalmologico Descripcion',
                                        id: 'strAncianoExamenOftalmologicoDescripcion'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'datefield',
                                        name: 'Examen Oftalmologico Fecha',
                                        emptyText: '(dia/mes/año)',
                                        width: 120,
                                        allowBlank: true,
                                        disabled: true,
                                        id: 'fecAncianoExamenOftalmologicoFecha'
                                    }
                                ]
                            },
                            {   
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 60,
                                        forceSelection: true,
                                        emptyText: 'SI/NO',
                                        mode: 'local',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        listEmptyText: '',
                                        triggerAction: 'all',
                                        store:'StoreSiNo',
                                        fieldLabel:'Glicemia<br>&nbsp;',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        name:'Glicemia',
                                        id: 'strAncianoExamenGlicemia',
                                        listeners:{
                                            change : function( t, newValue, oldValue){
                                                if(newValue == "NO"){
                                                    Ext.getCmp('strAncianoExamenGlicemiaDescripcion').allowBlank = true;
                                                    Ext.getCmp('fecAncianoExamenGlicemiaFecha').allowBlank = true;
                                                    Ext.getCmp('strAncianoExamenGlicemiaDescripcion').disable();
                                                    Ext.getCmp('fecAncianoExamenGlicemiaFecha').disable();
                                                    Ext.getCmp('strAncianoExamenGlicemiaDescripcion').clearInvalid();
                                                    Ext.getCmp('fecAncianoExamenGlicemiaFecha').clearInvalid();
                                                }else{
                                                    Ext.getCmp('strAncianoExamenGlicemiaDescripcion').enable();
                                                    Ext.getCmp('fecAncianoExamenGlicemiaFecha').enable();
                                                    Ext.getCmp('strAncianoExamenGlicemiaDescripcion').allowBlank = false;
                                                    Ext.getCmp('fecAncianoExamenGlicemiaFecha').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 250,
                                        allowBlank: true,
                                        disabled: true,
                                        name: 'Glicemia Descripcion',
                                        id: 'strAncianoExamenGlicemiaDescripcion'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'datefield',
                                        name: 'Glicemia Fecha',
                                        emptyText: '(dia/mes/año)',
                                        width: 120,
                                        allowBlank: true,
                                        disabled: true,
                                        id: 'fecAncianoExamenGlicemiaFecha'
                                    }
                                ]
                            },
                            {   
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 60,
                                        forceSelection: true,
                                        emptyText: 'SI/NO',
                                        mode: 'local',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        listEmptyText: '',
                                        triggerAction: 'all',
                                        store:'StoreSiNo',
                                        fieldLabel:'Perfil Lipidico<br>&nbsp;',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        name:'Perfil Lipidico',
                                        id: 'strAncianoExamenPerfilLipidico',
                                        listeners:{
                                            change : function( t, newValue, oldValue){
                                                if(newValue == "NO"){
                                                    Ext.getCmp('strAncianoExamenPerfilLipidicoDescripcion').allowBlank = true;
                                                    Ext.getCmp('fecAncianoExamenPerfilLipidicoFecha').allowBlank = true;
                                                    Ext.getCmp('strAncianoExamenPerfilLipidicoDescripcion').disable();
                                                    Ext.getCmp('fecAncianoExamenPerfilLipidicoFecha').disable();
                                                    Ext.getCmp('strAncianoExamenPerfilLipidicoDescripcion').clearInvalid();
                                                    Ext.getCmp('fecAncianoExamenPerfilLipidicoFecha').clearInvalid();
                                                }else{
                                                    Ext.getCmp('strAncianoExamenPerfilLipidicoDescripcion').enable();
                                                    Ext.getCmp('fecAncianoExamenPerfilLipidicoFecha').enable();
                                                    Ext.getCmp('strAncianoExamenPerfilLipidicoDescripcion').allowBlank = false;
                                                    Ext.getCmp('fecAncianoExamenPerfilLipidicoFecha').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'textarea',
                                        anchor: '100%',
                                        allowBlank: true,
                                        disabled: true,
                                        name: 'Perfil Lipidico Descripcion',
                                        id: 'strAncianoExamenPerfilLipidicoDescripcion'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'datefield',
                                        name: 'Perfil Lipidico Fecha',
                                        emptyText: '(dia/mes/año)',
                                        width: 120,
                                        allowBlank: true,
                                        disabled: true,
                                        id: 'fecAncianoExamenPerfilLipidicoFecha'
                                    }
                                ]
                            },
                            {   
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 60,
                                        forceSelection: true,
                                        emptyText: 'SI/NO',
                                        mode: 'local',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        listEmptyText: '',
                                        triggerAction: 'all',
                                        store:'StoreSiNo',
                                        fieldLabel:'Parcial Orina<br>&nbsp;',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        name:'Parcial Orina',
                                        id: 'strAncianoExamenParcialOrina',
                                        listeners:{
                                            change : function( t, newValue, oldValue){
                                                if(newValue == "NO"){
                                                    Ext.getCmp('strAncianoExamenParcialOrinaDescripcion').allowBlank = true;
                                                    Ext.getCmp('fecAncianoExamenParcialOrinaFecha').allowBlank = true;
                                                    Ext.getCmp('strAncianoExamenParcialOrinaDescripcion').disable();
                                                    Ext.getCmp('fecAncianoExamenParcialOrinaFecha').disable();
                                                    Ext.getCmp('strAncianoExamenParcialOrinaDescripcion').clearInvalid();
                                                    Ext.getCmp('fecAncianoExamenParcialOrinaFecha').clearInvalid();
                                                }else{
                                                    Ext.getCmp('strAncianoExamenParcialOrinaDescripcion').enable();
                                                    Ext.getCmp('fecAncianoExamenParcialOrinaFecha').enable();
                                                    Ext.getCmp('strAncianoExamenParcialOrinaDescripcion').allowBlank = false;
                                                    Ext.getCmp('fecAncianoExamenParcialOrinaFecha').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 250,
                                        allowBlank: true,
                                        disabled: true,
                                        name: 'Parcial Orina Descripcion',
                                        id: 'strAncianoExamenParcialOrinaDescripcion'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'datefield',
                                        name: 'Parcial Orina Fecha',
                                        emptyText: '(dia/mes/año)',
                                        width: 120,
                                        allowBlank: true,
                                        disabled: true,
                                        id: 'fecAncianoExamenParcialOrinaFecha'
                                    }
                                ]
                            },
                            {   
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 60,
                                        forceSelection: true,
                                        emptyText: 'SI/NO',
                                        mode: 'local',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        listEmptyText: '',
                                        triggerAction: 'all',
                                        store:'StoreSiNo',
                                        fieldLabel:'Creatinina<br>&nbsp;',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        name:'Creatinina',
                                        id: 'strAncianoExamenCreatinina',
                                        listeners:{
                                            change : function( t, newValue, oldValue){
                                                if(newValue == "NO"){
                                                    Ext.getCmp('strAncianoExamenCreatininaDescripcion').allowBlank = true;
                                                    Ext.getCmp('fecAncianoExamenCreatininaFecha').allowBlank = true;
                                                    Ext.getCmp('strAncianoExamenCreatininaDescripcion').disable();
                                                    Ext.getCmp('fecAncianoExamenCreatininaFecha').disable();
                                                    Ext.getCmp('strAncianoExamenCreatininaDescripcion').clearInvalid();
                                                    Ext.getCmp('fecAncianoExamenCreatininaFecha').clearInvalid();
                                                }else{
                                                    Ext.getCmp('strAncianoExamenCreatininaDescripcion').enable();
                                                    Ext.getCmp('fecAncianoExamenCreatininaFecha').enable();
                                                    Ext.getCmp('strAncianoExamenCreatininaDescripcion').allowBlank = false;
                                                    Ext.getCmp('fecAncianoExamenCreatininaFecha').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 250,
                                        allowBlank: true,
                                        disabled: true,
                                        name: 'Creatinina Descripcion',
                                        id: 'strAncianoExamenCreatininaDescripcion'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'datefield',
                                        name: 'Creatinina Fecha',
                                        emptyText: '(dia/mes/año)',
                                        width: 120,
                                        allowBlank: true,
                                        disabled: true,
                                        id: 'fecAncianoExamenCreatininaFecha'
                                    }
                                ]
                            },
                            {   
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 60,
                                        forceSelection: true,
                                        emptyText: 'SI/NO',
                                        mode: 'local',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        listEmptyText: '',
                                        triggerAction: 'all',
                                        store:'StoreSiNo',
                                        fieldLabel:'Antigeno Prostatico',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        name:'Antigeno Prostatico',
                                        id: 'strAncianoExamenAntigenoProstatico',
                                        listeners:{
                                            change : function( t, newValue, oldValue){
                                                if(newValue == "NO"){
                                                    Ext.getCmp('strAncianoExamenAntigenoProstaticoDescripcion').allowBlank = true;
                                                    Ext.getCmp('fecAncianoExamenAntigenoProstaticoFecha').allowBlank = true;
                                                    Ext.getCmp('strAncianoExamenAntigenoProstaticoDescripcion').disable();
                                                    Ext.getCmp('fecAncianoExamenAntigenoProstaticoFecha').disable();
                                                    Ext.getCmp('strAncianoExamenAntigenoProstaticoDescripcion').clearInvalid();
                                                    Ext.getCmp('fecAncianoExamenAntigenoProstaticoFecha').clearInvalid();
                                                }else{
                                                    Ext.getCmp('strAncianoExamenAntigenoProstaticoDescripcion').enable();
                                                    Ext.getCmp('fecAncianoExamenAntigenoProstaticoFecha').enable();
                                                    Ext.getCmp('strAncianoExamenAntigenoProstaticoDescripcion').allowBlank = false;
                                                    Ext.getCmp('fecAncianoExamenAntigenoProstaticoFecha').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 250,
                                        allowBlank: true,
                                        disabled: true,
                                        name: 'Antigeno Prostatico Descripcion',
                                        id: 'strAncianoExamenAntigenoProstaticoDescripcion'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'datefield',
                                        name: 'Antigeno Prostatico Fecha',
                                        emptyText: '(dia/mes/año)',
                                        width: 120,
                                        allowBlank: true,
                                        disabled: true,
                                        id: 'fecAncianoExamenAntigenoProstaticoFecha'
                                    }
                                ]
                            },
                            {   
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 60,
                                        forceSelection: true,
                                        emptyText: 'SI/NO',
                                        mode: 'local',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        listEmptyText: '',
                                        triggerAction: 'all',
                                        store:'StoreSiNo',
                                        fieldLabel:'Mamografia<br>&nbsp;',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        name:'Mamografia',
                                        id: 'strAncianoExamenMamografia',
                                        listeners:{
                                            change : function( t, newValue, oldValue){
                                                if(newValue == "NO"){
                                                    Ext.getCmp('strAncianoExamenMamografiaDescripcion').allowBlank = true;
                                                    Ext.getCmp('fecAncianoExamenMamografiaFecha').allowBlank = true;
                                                    Ext.getCmp('strAncianoExamenMamografiaDescripcion').disable();
                                                    Ext.getCmp('fecAncianoExamenMamografiaFecha').disable();
                                                    Ext.getCmp('strAncianoExamenMamografiaDescripcion').clearInvalid();
                                                    Ext.getCmp('fecAncianoExamenMamografiaFecha').clearInvalid();
                                                }else{
                                                    Ext.getCmp('strAncianoExamenMamografiaDescripcion').enable();
                                                    Ext.getCmp('fecAncianoExamenMamografiaFecha').enable();
                                                    Ext.getCmp('strAncianoExamenMamografiaDescripcion').allowBlank = false;
                                                    Ext.getCmp('fecAncianoExamenMamografiaFecha').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 250,
                                        allowBlank: true,
                                        disabled: true,
                                        name: 'Mamografia Descripcion',
                                        id: 'strAncianoExamenMamografiaDescripcion'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'datefield',
                                        name: 'Mamografia Fecha',
                                        emptyText: '(dia/mes/año)',
                                        width: 120,
                                        allowBlank: true,
                                        disabled: true,
                                        id: 'fecAncianoExamenMamografiaFecha'
                                    }
                                ]
                            },
                            {   
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 60,
                                        forceSelection: true,
                                        emptyText: 'SI/NO',
                                        mode: 'local',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        listEmptyText: '',
                                        triggerAction: 'all',
                                        store:'StoreSiNo',
                                        fieldLabel:'Citologia<br>&nbsp;',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        name:'Citologia',
                                        id: 'strAncianoExamenCitologia',
                                        listeners:{
                                            change : function( t, newValue, oldValue){
                                                if(newValue == "NO"){
                                                    Ext.getCmp('strAncianoExamenCitologiaDescripcion').allowBlank = true;
                                                    Ext.getCmp('fecAncianoExamenCitologiaFecha').allowBlank = true;
                                                    Ext.getCmp('strAncianoExamenCitologiaDescripcion').disable();
                                                    Ext.getCmp('fecAncianoExamenCitologiaFecha').disable();
                                                    Ext.getCmp('strAncianoExamenCitologiaDescripcion').clearInvalid();
                                                    Ext.getCmp('fecAncianoExamenCitologiaFecha').clearInvalid();
                                                }else{
                                                    Ext.getCmp('strAncianoExamenCitologiaDescripcion').enable();
                                                    Ext.getCmp('fecAncianoExamenCitologiaFecha').enable();
                                                    Ext.getCmp('strAncianoExamenCitologiaDescripcion').allowBlank = false;
                                                    Ext.getCmp('fecAncianoExamenCitologiaFecha').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 250,
                                        allowBlank: true,
                                        disabled: true,
                                        name: 'Citologia Descripcion',
                                        id: 'strAncianoExamenCitologiaDescripcion'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'datefield',
                                        name: 'Citologia Fecha',
                                        emptyText: '(dia/mes/año)',
                                        width: 120,
                                        allowBlank: true,
                                        disabled: true,
                                        id: 'fecAncianoExamenCitologiaFecha'
                                    }
                                ]
                            },
                            {   
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 60,
                                        forceSelection: true,
                                        emptyText: 'SI/NO',
                                        mode: 'local',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        listEmptyText: '',
                                        triggerAction: 'all',
                                        store:'StoreSiNo',
                                        fieldLabel:'Sandre Oculta en Heces',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        name:'Sandre Oculta en Heces',
                                        id: 'strAncianoExamenSandreOcultaHeces',
                                        listeners:{
                                            change : function( t, newValue, oldValue){
                                                if(newValue == "NO"){
                                                    Ext.getCmp('strAncianoExamenSandreOcultaHecesDescripcion').allowBlank = true;
                                                    Ext.getCmp('fecAncianoExamenSandreOcultaHecesFecha').allowBlank = true;
                                                    Ext.getCmp('strAncianoExamenSandreOcultaHecesDescripcion').disable();
                                                    Ext.getCmp('fecAncianoExamenSandreOcultaHecesFecha').disable();
                                                    Ext.getCmp('strAncianoExamenSandreOcultaHecesDescripcion').clearInvalid();
                                                    Ext.getCmp('fecAncianoExamenSandreOcultaHecesFecha').clearInvalid();
                                                }else{
                                                    Ext.getCmp('strAncianoExamenSandreOcultaHecesDescripcion').enable();
                                                    Ext.getCmp('fecAncianoExamenSandreOcultaHecesFecha').enable();
                                                    Ext.getCmp('strAncianoExamenSandreOcultaHecesDescripcion').allowBlank = false;
                                                    Ext.getCmp('fecAncianoExamenSandreOcultaHecesFecha').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 250,
                                        allowBlank: true,
                                        disabled: true,
                                        name: 'Sandre Oculta en Heces Descripcion',
                                        id: 'strAncianoExamenSandreOcultaHecesDescripcion'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'datefield',
                                        name: 'Sandre Oculta en Heces Fecha',
                                        emptyText: '(dia/mes/año)',
                                        width: 120,
                                        allowBlank: true,
                                        disabled: true,
                                        id: 'fecAncianoExamenSandreOcultaHecesFecha'
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'panel',
                        title: '<center>EDUCACION</center>',
                        layout: 'form',
                        anchor: '100%',
                        autoHeight: true,
                        id: 'pnAncianoEducacion',
                        items: [
                            {
                                xtype: 'panel',
                                layout: 'table',
                                anchor: '100%',
                                padding: 0,
                                layoutConfig: {
                                    columns: 2
                                },
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'panel',
                                        layout: 'form',
                                        width: 400,
                                        autoHeight: true,
                                        labelSeparator: '',
                                        labelStyle: 'color:blue;',
                                        items: [
                                            {
                                                xtype: 'combo',
                                                width: 60,
                                                forceSelection: true,
                                                emptyText: 'SI/NO',
                                                mode: 'local',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                listEmptyText: '',
                                                triggerAction: 'all',
                                                store:'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                name:'Autocuidado',
                                                fieldLabel:'Autocuidado<br>&nbsp;',
                                                id: 'strAncianoEduAutocuidado'
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 60,
                                                forceSelection: true,
                                                emptyText: 'SI/NO',
                                                mode: 'local',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                listEmptyText: '',
                                                triggerAction: 'all',
                                                store:'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                name:'Nutricion',
                                                fieldLabel:'Nutricion<br>&nbsp;',
                                                id: 'strAncianoEduNutricion'
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 60,
                                                forceSelection: true,
                                                emptyText: 'SI/NO',
                                                mode: 'local',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                listEmptyText: '',
                                                triggerAction: 'all',
                                                store:'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                name:'Ejercicio',
                                                fieldLabel:'Ejercicio<br>&nbsp;',
                                                id: 'strAncianoEduEjercicio'
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 60,
                                                forceSelection: true,
                                                emptyText: 'SI/NO',
                                                mode: 'local',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                listEmptyText: '',
                                                triggerAction: 'all',
                                                store:'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                name:'Tiempo Libre',
                                                fieldLabel:'Tiempo Libre<br>&nbsp;',
                                                id: 'strAncianoEduTieLib'
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 60,
                                                forceSelection: true,
                                                emptyText: 'SI/NO',
                                                mode: 'local',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                listEmptyText: '',
                                                triggerAction: 'all',
                                                store:'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                name:'Sexualidad',
                                                fieldLabel:'Sexualidad<br>&nbsp;',
                                                id: 'strAncianoEduSexualidad'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'panel',
                                        layout: 'form',
                                        width: 400,
                                        autoHeight: true,
                                        labelSeparator: '',
                                        labelStyle: 'color:blue;',
                                        items: [
                                            {
                                                xtype: 'combo',
                                                width: 60,
                                                forceSelection: true,
                                                emptyText: 'SI/NO',
                                                mode: 'local',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                listEmptyText: '',
                                                triggerAction: 'all',
                                                store:'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                name:'Planificacion Familiar',
                                                fieldLabel:'Planificacion Familiar',
                                                id: 'strAncianoEduPlaFamiliar'
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 60,
                                                forceSelection: true,
                                                emptyText: 'SI/NO',
                                                mode: 'local',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                listEmptyText: '',
                                                triggerAction: 'all',
                                                store:'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                name:'Alcohol, Tabaco y Drogas',
                                                fieldLabel:'Alcohol, Tabaco y Drogas',
                                                id: 'strAncianoEduAlcTabDro'
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 60,
                                                forceSelection: true,
                                                emptyText: 'SI/NO',
                                                mode: 'local',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                listEmptyText: '',
                                                triggerAction: 'all',
                                                store:'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                name:'Autoexamen Seno',
                                                fieldLabel:'Autoexamen Seno',
                                                id: 'strAncianoEduAutSeno'
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 60,
                                                forceSelection: true,
                                                emptyText: 'SI/NO',
                                                mode: 'local',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                listEmptyText: '',
                                                triggerAction: 'all',
                                                store:'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                name:'Autoexamen Testiculo',
                                                fieldLabel:'Autoexamen Testiculo',
                                                id: 'strAncianoEduAutTesticulos'
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 60,
                                                forceSelection: true,
                                                emptyText: 'SI/NO',
                                                mode: 'local',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                listEmptyText: '',
                                                triggerAction: 'all',
                                                store:'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                name:'Salud Oral',
                                                fieldLabel:'Salud Oral<br>&nbsp;',
                                                id: 'strAncianoEduSalOral'
                                            }
                                        ]
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        html: '<br>'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'datefield',
                                width: 120,
                                fieldLabel: 'Fecha Probable Proxima Cita',
                                name: 'Fecha Probable Proxima Cita',
                                allowBlank: true,
                                emptyText: '(dia/mes/año) ',
                                style: 'text-align:center;',
                                id: 'fecAncianoProximaCita'
                            },
                            {
                                html: 'Profesional que Atiende'
                            },
                            {
                                xtype: 'combo',
                                name: 'Profesional que Atiende',
                                width: 250,
                                allowBlank: true,
                                store: stProfesionalAtiende,
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strAncianoProximaCitaProfesionalAtiende'
                            }
                        ]
                    },
                    {
                        xtype: 'textarea',
                        anchor: '100%',
                        width: 880,
                        fieldLabel: 'PLAN',
                        name: 'PLAN',
                        height: 100,
                        allowBlank: true,
                        id: 'memAncianoPlan'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                width: 96,
                                allowBlank: true,
                                fieldLabel: 'Diagnostico',
                                id: 'sysAncianoDiag',
                                listeners:{
                                    specialkey: function(f,e){
                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                        {
                                            if (f.getValue() != "" && f.getValue() != null){
                                                Ext.Ajax.request({
                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                    params:{
                                                        task: 'BUSCAR',
                                                        pCodigo: f.getValue().toUpperCase()
                                                    },
                                                    success: function(response,options)
                                                    {
                                                        var el = Ext.get('response'); // get the LOG
                                                        var Respuesta = response.responseText;
                                                        var Contenido = Respuesta.split('^');
                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                            Ext.getCmp('sysAncianoDiag').setValue(null);
                                                            Ext.getCmp('sysAncianoDiagNom').setValue(null);
                                                        } else {
                                                            Ext.getCmp('sysAncianoDiag').setValue(Contenido[0]);
                                                            Ext.getCmp('sysAncianoDiagNom').setValue(Contenido[1]);
                                                        }
                                                    },
                                                    failure: function(response,options){
                                                        var el = Ext.get('response');
                                                        Ext.getCmp('sysAncianoDiag').setValue(null);
                                                        Ext.getCmp('sysAncianoDiagNom').setValue(null);
                                                    },
                                                    scope:this //bind the callbacks
                                                });
                                            }else{
                                                Ext.getCmp('sysAncianoDiag').setValue(null);
                                                Ext.getCmp('sysAncianoDiagNom').setValue(null);
                                            }
                                        }
                                    }
                                }
                            },
                            {
                                xtype: 'textarea',
                                readOnly: true,
                                width: 625,
                                height: 22,
                                id: 'sysAncianoDiagNom'
                            },
                            {
                                xtype: 'button',
                                iconCls: 'btnBuscar',
                                tooltip: 'Buscar Diagnostico Principal',
                                listeners:{
                                    click : function(){
                                        buscarcie10('sysAncianoDiag','sysAncianoDiagNom');
                                    }
                                }
                            }
                        ]
                    }
                ]
            }
        ];
        pnAnciano001Ui.superclass.initComponent.call(this);
    }
});