/*
* @category    Panel Riesgo Cardiovascular
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


pnRiesgoCardioVascular002Ui = Ext.extend(Ext.Panel, {
    anchor: '100%',
    autoHeight: true,
    layout: 'form',
    collapseFirst: false,
    collapsible: false,
    animCollapse: false,
    titleCollapse: false,
    border: false,
    padding: 0,
    id: 'pnRiesgoCardioVascular',
    initComponent: function() {
        
        var dataRiesgoHTA = [
            ['B','BAJO'],
            ['M','MODERADO'],
            ['A','ALTO'],
            ['MA','MUY ALTO']
        ];
        var stRiesgoHTA = new Ext.data.ArrayStore({
            fields: [
               {name: 'Codigo'},
               {name: 'Descripcion'}
            ]
        });
        stRiesgoHTA.loadData(dataRiesgoHTA);
        
        
        var dataDiabetes = [
            ['T1','TIPO I'],
            ['T2','TIPO II NO INSULINORREQUIRIENTE'],
            ['T2-1','TIPO II INSULINORREQUIRIENTE']
        ];
        var stDiabetes = new Ext.data.ArrayStore({
            fields: [
               {name: 'Codigo'},
               {name: 'Descripcion'}
            ]
        });
        stDiabetes.loadData(dataDiabetes);
        
        this.items = [
            {
                xtype: 'fieldset',
                title: 'SEGUIMIENTO USUARIOS CON RIESGO CARDIOVASCULAR',
                layout: 'form',
                collapseFirst: false,
                collapsible: true,
                animCollapse: true,
                titleCollapse: true,
                anchor: '100%',
                autoHeight: true,
                padding: 5,
                id: 'fsRCV',
                items: [
                    {
                        xtype: 'fieldset',
                        title: 'DIAGNOSTICO',
                        layout: 'form',
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        anchor: '100%',
                        autoHeight: true,
                        padding: 5,
                        id: 'fsRCV_1',
                        items: [
                            {
                                xtype: 'combo',
                                name: 'ESTA REGISTRADO EN ANEXO 12 FRCV',
                                fieldLabel: 'ESTA REGISTRADO EN ANEXO 12 FRCV',
                                width: 60,
                                allowBlank: true,
                                store: 'StoreSiNo',
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strRCV_1'
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        name: 'HTA Estratificacion de Riesgo',
                                        fieldLabel: 'HTA Estratificacion de Riesgo',
                                        width: 200,
                                        allowBlank: true,
                                        store: stRiesgoHTA,
                                        valueField: 'Codigo',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        listWidth: 150,
                                        value: "NORMAL",
                                        id: 'strRCV_2'
                                    },
                                    {
                                        html: 'DIABETES Clasificacion:'
                                    },
                                    {
                                        xtype: 'combo',
                                        name: 'DIABETES Clasificacion',
                                        width: 200,
                                        allowBlank: true,
                                        store: stDiabetes,
                                        valueField: 'Codigo',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        listWidth: 150,
                                        value: "NORMAL",
                                        id: 'strRCV_3'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        name: 'DISLIPIDEMIA',
                                        fieldLabel: 'DISLIPIDEMIA',
                                        width: 60,
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strRCV_4'
                                    },
                                    {
                                        html: 'OBESIDAD:'
                                    },
                                    {
                                        xtype: 'combo',
                                        name: 'OBESIDAD',
                                        width: 60,
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strRCV_5'
                                    },
                                    {
                                        html: 'SOPREPESO:'
                                    },
                                    {
                                        xtype: 'combo',
                                        name: 'SOPREPESO:',
                                        width: 60,
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strRCV_6'
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: 'LESION ORGANO BLANCO',
                        layout: 'form',
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        anchor: '100%',
                        autoHeight: true,
                        padding: 5,
                        id: 'fsRCV_2',
                        items: [
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        name: 'CARDIOVASCULAR',
                                        fieldLabel: 'CARDIOVASCULAR',
                                        width: 60,
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strRCV_7'
                                    },
                                    {
                                        html: 'NEFROPATIA'
                                    },
                                    {
                                        xtype: 'combo',
                                        name: 'NEFROPATIA',
                                        width: 60,
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strRCV_8'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        name: 'RETINOPATIA',
                                        fieldLabel: 'RETINOPATIA',
                                        width: 60,
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strRCV_9'
                                    },
                                    {
                                        html: 'NEUROPATIA'
                                    },
                                    {
                                        xtype: 'combo',
                                        name: 'NEUROPATIA',
                                        width: 60,
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strRCV_10'
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: 'EXAMENES BASICOS',
                        layout: 'form',
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        anchor: '100%',
                        autoHeight: true,
                        padding: 5,
                        id: 'fsRCV_3',
                        items: [
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'textfield',
                                        width: 200,
                                        allowBlank: true,
                                        name: 'CUADRO HEM�TICO (PERIODICIDAD: INICIAL Y BIANUAL)',
                                        fieldLabel: 'CUADRO HEM�TICO (PERIODICIDAD: INICIAL Y BIANUAL)',
                                        id: 'strRCV_11'
                                    },
                                    {
                                        html: 'PARCIAL DE ORINA(PERIODICIDAD: INICIAL Y ANUAL):'
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 200,
                                        allowBlank: true,
                                        name: 'PARCIAL DE ORINA(PERIODICIDAD: INICIAL Y ANUAL)',
                                        id: 'strRCV_12'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'textfield',
                                        width: 200,
                                        allowBlank: true,
                                        name: 'GLICEMIA BASAL (PERIODICIDAD: INICIAL Y ANUAL)',
                                        fieldLabel: 'GLICEMIA BASAL (PERIODICIDAD: INICIAL Y ANUAL)',
                                        id: 'strRCV_13'
                                    },
                                    {
                                        html: 'CREATININA S�RICA (PERIODICIDAD: INICIAL Y BIANUAL):'
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 200,
                                        allowBlank: true,
                                        name: 'CREATININA S�RICA (PERIODICIDAD: INICIAL Y BIANUAL)',
                                        id: 'strRCV_14'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'textfield',
                                        width: 200,
                                        allowBlank: true,
                                        name: 'COLESTEROL TOTAL, HDL, LDL,TRIGLICERIDOS (PERIODICIDAD: INICIAL Y BIANUAL)',
                                        fieldLabel: 'COLESTEROL TOTAL, HDL, LDL,TRIGLICERIDOS (PERIODICIDAD: INICIAL Y BIANUAL)',
                                        id: 'strRCV_15'
                                    },
                                    {
                                        html: 'POTASIO S�RICO:'
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 200,
                                        allowBlank: true,
                                        name: 'POTASIO S�RICO',
                                        id: 'strRCV_16'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'textfield',
                                        width: 200,
                                        allowBlank: true,
                                        name: 'ELECTROCARDIOGRAMA DE 12 DERIVACIONES (PERIODICIDAD: INICIAL Y BIANUAL)',
                                        fieldLabel: 'ELECTROCARDIOGRAMA DE 12 DERIVACIONES (PERIODICIDAD: INICIAL Y BIANUAL)',
                                        id: 'strRCV_17'
                                    },
                                    {
                                        html: 'MICROALBUMINURIA (PERIODICIDAD: INICIAL Y ANUAL):'
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 200,
                                        allowBlank: true,
                                        name: 'MICROALBUMINURIA (PERIODICIDAD: INICIAL Y ANUAL)',
                                        id: 'strRCV_18'
                                    }
                                ]
                            },
                            {
                                xtype: 'textfield',
                                width: 200,
                                allowBlank: true,
                                name: 'OTROS  EXAMENES',
                                fieldLabel: 'OTROS  EXAMENES',
                                id: 'strRCV_19'
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: 'VALORACION POR OTROS PROFESIONALES',
                        layout: 'form',
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        anchor: '100%',
                        autoHeight: true,
                        padding: 5,
                        id: 'fsRCV_4',
                        items: [    
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'textfield',
                                        width: 200,
                                        allowBlank: true,
                                        name: 'VALORACION CON INTERNISTA',
                                        fieldLabel: 'VALORACION CON INTERNISTA',
                                        id: 'strRCV_20'
                                    },
                                    {
                                        html: 'VALORACION POR OFTALMOLOGO:'
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 200,
                                        allowBlank: true,
                                        name: 'VALORACION POR OFTALMOLOGO',
                                        id: 'strRCV_21'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'textfield',
                                        width: 200,
                                        allowBlank: true,
                                        name: 'VALORACION POR ENDOCRINOLOGO',
                                        fieldLabel: 'VALORACION POR ENDOCRINOLOGO',
                                        id: 'strRCV_22'
                                    },
                                    {
                                        html: 'VALORACION POR CARDIOLOGIA:'
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 200,
                                        allowBlank: true,
                                        name: 'VALORACION POR CARDIOLOGIA',
                                        id: 'strRCV_23'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'textfield',
                                        width: 200,
                                        allowBlank: true,
                                        name: 'VALORACION POR NEFROLOGIA',
                                        fieldLabel: 'VALORACION POR NEFROLOGIA',
                                        id: 'strRCV_24'
                                    },
                                    {
                                        html: 'VALORACION POR SIC�LOGO:'
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 200,
                                        allowBlank: true,
                                        name: 'VALORACION POR SIC�LOGO',
                                        id: 'strRCV_23'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'textfield',
                                        width: 200,
                                        allowBlank: true,
                                        name: 'VALORACION POR NUTRICIONISTA',
                                        fieldLabel: 'VALORACION POR NUTRICIONISTA',
                                        id: 'strRCV_24'
                                    },
                                    {
                                        html: 'SALUD ORAL:'
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 200,
                                        allowBlank: true,
                                        name: 'SALUD ORAL',
                                        id: 'strRCV_25'
                                    }
                                ]
                            },
                            {
                                xtype: 'datefield',
                                width: 120,
                                fieldLabel: 'FECHA CONTROL CON ESPECIALISTA',
                                name: 'FECHA CONTROL CON ESPECIALISTA',
                                allowBlank: true,
                                emptyText: '(dia/mes/año) ',
                                style: 'text-align:center;',
                                id: 'fecRCV_25'
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: ' PLAN DE AUTOCUIDADO',
                        layout: 'form',
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        anchor: '100%',
                        autoHeight: true,
                        padding: 5,
                        id: 'fsRCV_6',
                        items: [
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        fieldLabel: 'FECHA DE ATENCION',
                                        name: 'FECHA DE ATENCION',
                                        allowBlank: true,
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecRCV_25'
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 200,
                                        allowBlank: true,
                                        name: 'FRAMINGHAN',
                                        fieldLabel: 'FRAMINGHAN',
                                        id: 'strRCV_26'
                                    },
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'numberfield',
                                        width: 100,
                                        minValue: 0,
                                        maxValue: 250,
                                        decimalPrecision: 2,
                                        allowBlank: true,
                                        fieldLabel: 'TALLA (cm)',
                                        name:"TALLA (cm)",
                                        emptyText: '(cm)',
                                        id: 'intRCV_27',
                                        listeners:{
                                            change : function(f,pNew, pOld){
                                                if(pNew == null || pNew == 0){
                                                    Ext.getCmp('intRCV_27').setValue(null);
                                                    Ext.getCmp('intRCV_29').setValue(0);
                                                }else{
                                                    //peso [kg]/ estatura [m2]
                                                    if(Ext.getCmp('intRCV_28').getValue() > 0){
                                                        var pTalla = Ext.getCmp('intRCV_27').getValue() / 100;
                                                        Ext.getCmp('intRCV_29').setValue(Ext.getCmp('intRCV_28').getValue()/(pTalla*pTalla));
                                                    }else{
                                                        Ext.getCmp('intRCV_29').setValue(0);
                                                    }
                                                }
                                                if(Ext.getCmp('intRCV_29').getValue()<1){
                                                   Ext.getCmp('strRCV_30').setValue(null);
                                                }else{
                                                    if(Ext.getCmp('intRCV_29').getValue()<24.9){
                                                       Ext.getCmp('strRCV_30').setValue("ACEPTABLE");
                                                    }else{
                                                        if(Ext.getCmp('intRCV_29').getValue()<29.9){
                                                           Ext.getCmp('strRCV_30').setValue("SOBREPESO");
                                                        }else{
                                                            Ext.getCmp('strRCV_30').setValue("OBESIDAD");
                                                        }

                                                    }
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html: 'PESO (Kg):'
                                    },
                                    {
                                        xtype: 'numberfield',
                                        width: 100,
                                        minValue: 0,
                                        maxValue: 250,
                                        decimalPrecision: 2,
                                        allowBlank: true,
                                        emptyText: '(Kg)',
                                        name:"PESO (Kg)",
                                        id: 'intRCV_28',
                                        listeners:{
                                            change : function(f,pNew, pOld){
                                                if(pNew == null || pNew == 0){
                                                    Ext.getCmp('intRCV_28').setValue(null);
                                                    Ext.getCmp('intRCV_29').setValue(0);
                                                }else{
                                                    //peso [kg]/ estatura [m2]
                                                    if(Ext.getCmp('intRCV_27').getValue() > 0){
                                                        var pTalla = Ext.getCmp('intRCV_27').getValue() / 100;
                                                        Ext.getCmp('intRCV_29').setValue(Ext.getCmp('intRCV_28').getValue()/(pTalla*pTalla));
                                                    }else{
                                                        Ext.getCmp('intRCV_29').setValue(0);
                                                    }
                                                }
                                                if(Ext.getCmp('intRCV_29').getValue()<1){
                                                   Ext.getCmp('strRCV_30').setValue(null);
                                                }else{
                                                    if(Ext.getCmp('intRCV_29').getValue()<24.9){
                                                       Ext.getCmp('strRCV_30').setValue("ACEPTABLE");
                                                    }else{
                                                        if(Ext.getCmp('intRCV_29').getValue()<29.9){
                                                           Ext.getCmp('strRCV_30').setValue("SOBREPESO");
                                                        }else{
                                                            Ext.getCmp('strRCV_30').setValue("OBESIDAD");
                                                        }

                                                    }
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html: 'IMC: '
                                    },
                                    {
                                        xtype: 'numberfield',
                                        width: 100,
                                        minValue: 0,
                                        decimalPrecision: 2,
                                        allowBlank: true,
                                        readOnly: true,
                                        name: "IMC",
                                        id: 'intRCV_29'
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 100,
                                        allowBlank: true,
                                        readOnly: true,
                                        name: "IMC - CLASIFICACION",
                                        id: 'strRCV_30'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'numberfield',
                                        width: 100,
                                        minValue: 0,
                                        decimalPrecision: 2,
                                        allowBlank: true,
                                        readOnly: true,
                                        name: 'PERIMETRO ABDOMINAL',
                                        id: 'intRCV_31'
                                    },
                                    {
                                        html: 'TA: '
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 100,
                                        allowBlank: true,
                                        readOnly: true,
                                        name: 'TA',
                                        id: 'strRCV_32'
                                    },
                                    {
                                        html: 'GLUCOMETRIA: '
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 100,
                                        allowBlank: true,
                                        readOnly: true,
                                        name: 'GLUCOMETRIA',
                                        id: 'strRCV_33'
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: ' TRATAMIENTO',
                        layout: 'form',
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        anchor: '100%',
                        autoHeight: true,
                        padding: 5,
                        id: 'fsRCV_7',
                        items: [
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'textfield',
                                        width: 200,
                                        allowBlank: true,
                                        name: 'INDICACIONES   NUTRICIONALES',
                                        fieldLabel: 'INDICACIONES   NUTRICIONALES',
                                        id: 'strRCV_34'
                                    },
                                    {
                                        html: 'MANEJO DE LA SAL:'
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 200,
                                        allowBlank: true,
                                        name: 'MANEJO DE LA SAL',
                                        id: 'strRCV_35'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'textfield',
                                        width: 200,
                                        allowBlank: true,
                                        name: ' CONSUMO DE CIGARRILLO-ALCOHO',
                                        fieldLabel: 'CONSUMO DE CIGARRILLO-ALCOHOL',
                                        id: 'strRCV_36'
                                    },
                                    {
                                        html: 'MANEJO DEL ESTR�S:'
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 200,
                                        allowBlank: true,
                                        name: 'MANEJO DEL ESTR�S',
                                        id: 'strRCV_37'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'textfield',
                                        width: 200,
                                        allowBlank: true,
                                        name: 'EJERCICIO',
                                        fieldLabel: 'EJERCICIO',
                                        id: 'strRCV_38'
                                    },
                                    {
                                        html: 'ASISTE A GIMNASIO DE ECOPETROL:'
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 200,
                                        allowBlank: true,
                                        name: 'ASISTE A GIMNASIO DE ECOPETROL',
                                        id: 'strRCV_39'
                                    }
                                ]
                            },
                            {
                                xtype: 'textfield',
                                width: 200,
                                allowBlank: true,
                                name: 'FARMACOLOGICO',
                                fieldLabel: 'FARMACOLOGICO',
                                id: 'strRCV_40'
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: ' PLAN DE AUTOCUIDADO',
                        layout: 'form',
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        anchor: '100%',
                        autoHeight: true,
                        padding: 5,
                        id: 'fsRCV_8',
                        items: [
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        fieldLabel: 'FECHA DE ATENCION',
                                        name: 'FECHA DE ATENCION',
                                        allowBlank: true,
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecRCV_41'
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 200,
                                        allowBlank: true,
                                        name: 'FRAMINGHAN',
                                        fieldLabel: 'FRAMINGHAN',
                                        id: 'strRCV_42'
                                    },
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'numberfield',
                                        width: 100,
                                        minValue: 0,
                                        maxValue: 250,
                                        decimalPrecision: 2,
                                        allowBlank: true,
                                        fieldLabel: 'TALLA (cm)',
                                        name:"TALLA (cm)",
                                        emptyText: '(cm)',
                                        id: 'intRCV_43',
                                        listeners:{
                                            change : function(f,pNew, pOld){
                                                if(pNew == null || pNew == 0){
                                                    Ext.getCmp('intRCV_43').setValue(null);
                                                    Ext.getCmp('intRCV_45').setValue(0);
                                                }else{
                                                    //peso [kg]/ estatura [m2]
                                                    if(Ext.getCmp('intRCV_44').getValue() > 0){
                                                        var pTalla = Ext.getCmp('intRCV_43').getValue() / 100;
                                                        Ext.getCmp('intRCV_45').setValue(Ext.getCmp('intRCV_44').getValue()/(pTalla*pTalla));
                                                    }else{
                                                        Ext.getCmp('intRCV_45').setValue(0);
                                                    }
                                                }
                                                if(Ext.getCmp('intRCV_45').getValue()<1){
                                                   Ext.getCmp('strRCV_46').setValue(null);
                                                }else{
                                                    if(Ext.getCmp('intRCV_45').getValue()<24.9){
                                                       Ext.getCmp('strRCV_46').setValue("ACEPTABLE");
                                                    }else{
                                                        if(Ext.getCmp('intRCV_45').getValue()<29.9){
                                                           Ext.getCmp('strRCV_46').setValue("SOBREPESO");
                                                        }else{
                                                            Ext.getCmp('strRCV_46').setValue("OBESIDAD");
                                                        }

                                                    }
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html: 'PESO (Kg):'
                                    },
                                    {
                                        xtype: 'numberfield',
                                        width: 100,
                                        minValue: 0,
                                        maxValue: 250,
                                        decimalPrecision: 2,
                                        allowBlank: true,
                                        emptyText: '(Kg)',
                                        name:"PESO (Kg)",
                                        id: 'intRCV_44',
                                        listeners:{
                                            change : function(f,pNew, pOld){
                                                if(pNew == null || pNew == 0){
                                                    Ext.getCmp('intRCV_44').setValue(null);
                                                    Ext.getCmp('intRCV_45').setValue(0);
                                                }else{
                                                    //peso [kg]/ estatura [m2]
                                                    if(Ext.getCmp('intRCV_43').getValue() > 0){
                                                        var pTalla = Ext.getCmp('intRCV_43').getValue() / 100;
                                                        Ext.getCmp('intRCV_45').setValue(Ext.getCmp('intRCV_44').getValue()/(pTalla*pTalla));
                                                    }else{
                                                        Ext.getCmp('intRCV_45').setValue(0);
                                                    }
                                                }
                                                if(Ext.getCmp('intRCV_45').getValue()<1){
                                                   Ext.getCmp('strRCV_46').setValue(null);
                                                }else{
                                                    if(Ext.getCmp('intRCV_45').getValue()<24.9){
                                                       Ext.getCmp('strRCV_46').setValue("ACEPTABLE");
                                                    }else{
                                                        if(Ext.getCmp('intRCV_45').getValue()<29.9){
                                                           Ext.getCmp('strRCV_46').setValue("SOBREPESO");
                                                        }else{
                                                            Ext.getCmp('strRCV_46').setValue("OBESIDAD");
                                                        }

                                                    }
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html: 'IMC: '
                                    },
                                    {
                                        xtype: 'numberfield',
                                        width: 100,
                                        minValue: 0,
                                        decimalPrecision: 2,
                                        allowBlank: true,
                                        readOnly: true,
                                        name: "IMC",
                                        id: 'intRCV_45'
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 100,
                                        allowBlank: true,
                                        readOnly: true,
                                        name: "IMC - CLASIFICACION",
                                        id: 'strRCV_46'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'numberfield',
                                        width: 100,
                                        minValue: 0,
                                        decimalPrecision: 2,
                                        allowBlank: true,
                                        readOnly: true,
                                        name: 'PERIMETRO ABDOMINAL',
                                        id: 'intRCV_47'
                                    },
                                    {
                                        html: 'TA: '
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 100,
                                        allowBlank: true,
                                        readOnly: true,
                                        name: 'TA',
                                        id: 'strRCV_48'
                                    },
                                    {
                                        html: 'GLUCOMETRIA: '
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 100,
                                        allowBlank: true,
                                        readOnly: true,
                                        name: 'GLUCOMETRIA',
                                        id: 'strRCV_49'
                                    }
                                ]
                            }
                        ]
                    },      
                    {
                        xtype: 'datefield',
                        width: 120,
                        fieldLabel: 'PROXIMA CITA CON ENFERMERA',
                        name: 'PROXIMA CITA CON ENFERMERA',
                        allowBlank: true,
                        emptyText: '(dia/mes/año) ',
                        style: 'text-align:center;',
                        id: 'fecRCV_50'
                    },
                    {
                        xtype: 'textarea',
                        anchor: '100%',
                        width: 650,
                        fieldLabel: 'PLAN',
                        name: 'PLAN',
                        height: 88,
                        allowBlank: true,
                        id: 'memRCV_51'
                    }
                ]
            }
        ];
        pnRiesgoCardioVascularUi.superclass.initComponent.call(this);
    }
});
