/*
* @category    Formulario Ficha De Evaluacion Integral Al Adulto Joven(25 a 44 años)
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winHCAdultoJovenUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic ©  .:: Plantilla HC - Evaluacion Adulto Joven(25 a 44 años) ::.',
    width: 990,
    height: 636,
    closable: false,
    resizable: false,
    draggable: false,
    modal: true,
    id: 'winHC',
    initComponent: function() {
        
        tmpmx = objMX;
        tmpmxadd = objMXADD;
        tmpexa = objEXA;
        tmprem = objREM;
        myPaciente = 0;
        myCAS = 0;
        
        try {
            var campo = Ext.getCmp('sysPacientePlantillaHC');
            if ( campo != null ) {
                myPaciente = Ext.getCmp('sysPacientePlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myPaciente == 0){
            try {
                var campo1 = Ext.getCmp('sysIdPacienteHC');
                if ( campo1 != null ) {
                    myPaciente = Ext.getCmp('sysIdPacienteHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myPaciente == 0){
            try {
                var campo5 = Ext.getCmp('sysPacienteRefHC');
                if ( campo5 != null ) {
                    myPaciente = Ext.getCmp('sysPacienteRefHC').getValue();
                }
            }catch(ex){
            }
        }
        try {
            var campo2 = Ext.getCmp('sysCASPlantillaHC');
            if ( campo2 != null ) {
                myCAS = Ext.getCmp('sysCASPlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myCAS == 0){
            try {
                var campo3 = Ext.getCmp('sysCASHC');
                if ( campo3 != null ) {
                    myCAS = Ext.getCmp('sysCASHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myCAS == 0){
            try {
                var campo4 = Ext.getCmp('sysCASRefHC');
                if ( campo4 != null ) {
                    myCAS = Ext.getCmp('sysCASRefHC').getValue();
                }
            }catch(ex){
            }
        }
        if (objMX != "NA"){
            var xSolMX = eval(objMX);
            Ext.getCmp('gridMedicamentosHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: myPaciente,
                    pCAS: myCAS
                }
            });
        }
        else{
            var xSolMX = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        if (objEXA != "NA"){
            var xSolEXA = eval(objEXA);
            Ext.getCmp('gridExamenesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: myPaciente,
                    pCAS: myCAS
                }
            });
        }else{
            var xSolEXA = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }    
        if (objREM != "NA"){
            var xSolREM = eval(objREM);
            Ext.getCmp('gridRemisionesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: myPaciente,
                    pCAS: myCAS
                }
            });
        }else{
            var xSolREM = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        
        
        var dataProfesionalAtiende = [
            ['Medico General'],
            ['Medico Especialista'],
            ['Enfermera'],
            ['Otro Profesional']
        ];
        var stProfesionalAtiende = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stProfesionalAtiende.loadData(dataProfesionalAtiende);
        
        
        this.items = [
            {
                xtype: 'panel',
                frame: true,
                anchor: '100%',
                id: 'panelHC',
                padding: 10,
                border: false,
                height: 610,
                autoScroll: true,
                layout: 'form',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysIdCodPlantillaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        value: 1,
                        id: 'sysUsaGridSalida'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        value: 0,
                        id: 'sysYaGuardoHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysPlantillaHC',
                        name: 'PLANTILLA'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptMx'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptExa'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptRem'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Actividad',
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        id: 'sysActividadHC',
                        name: 'PLANTILLA'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Empresa',
                        id: 'sysEmpresaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'IPS',
                        id: 'sysIPSHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Usuario',
                        id: 'sysUsuarioHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Profesional',
                        id: 'sysProfesionalHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Paciente',
                        id: 'sysIdPacienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Apertura',
                        id: 'sysAperturaHC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Cliente',
                        id: 'sysClienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdClienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdPlanHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdSubPlanHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdContratoHC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Profesional',
                        id: 'sysProfesionalAgendaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'ConsecutivoDetalle',
                        id: 'sysConsecutivoDetalleHC'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'CAS',
                                id: 'sysCASHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysFechaHC',
                                value: 'Fecha: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                width: 100,
                                id: 'sysFechaHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysHoraHC',
                                value: 'Hora: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                width: 90,
                                id: 'sysHoraHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysLegalizacionHC',
                                value: 'Legalización: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                width: 100,
                                id: 'sysLegalizaHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysAutorizacionHC',
                                value: 'Nro Autorización: '
                            },
                            {
                                xtype: 'textfield',
                                width: 210,
                                allowBlank: true,
                                style: 'color:brown;',
                                readOnly: true,
                                id: 'sysNroAutorizacionHC'
                            }
                        ]
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Paciente',
                        value: 'CC 792558261  - JORGE GALEANO RUIZ - (Masculino) FechaNac: 1973-01-30, Edad 38 Años',
                        id: 'sysPacienteHC'
                    },
                    {
                        //xtype: 'textfield',
                        xtype: 'hidden',
                        width: 120,
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Genero',
                        id: 'sysGeneroPacHC'
                    },
                    {
                        //xtype: 'datefield',
                        xtype: 'hidden',
                        width: 120,
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysFecNacPacHC'
                    },
                    {
                        //xtype: 'textfield',
                        xtype: 'hidden',
                        width: 250,
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysEdadPacHC'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                width: 100,
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'Genero',
                                id: 'sysGeneroHC'
                            },
                            {
                                html: 'Fecha Nac:'
                            },
                            {
                                xtype: 'textfield',
                                width: 100,
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysFechaNac'
                            },
                            {
                                html: 'Edad:'
                            },
                            {
                                xtype: 'textfield',
                                width: 350,
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysEdadHC'
                            }
                        ]
                    },
                    {
                        html: '<hr>',
                        style: 'background:transparent;',
                        border: false
                    },
                    {
                        xtype: 'tabpanel',
                        width: 930,
                        autoHeight: true,
                        border: false,
                        ref: 'fTabPanel',
                        id: 'fTabPanel',
                        activeTab: 0,
                        items: [
                            {
                                xtype: 'panel',
                                title: 'Evolución',
                                autoHeight: true,
                                autoScroll: true,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaEvolucion',
                                layout: 'form',
                                items: [
                                    {
                                        xtype: 'form',
                                        frame: true,
                                        anchor: '100%',
                                        id: 'frmHC',
                                        padding: 10,
                                        border: false,
                                        autoScroll: true,
                                        style: 'background:transparent;',
                                        items: [
                                            // AQUI EMPIEZAN CAMBIOS
                                            {
                                                xtype: 'fieldset',
                                                title: 'FICHA DE EVALUACÓN INTEGRAL AL ADULTO JOVEN(25 a 44 AÑOS)',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                id: 'fsFicEvaJoven',
                                                items: [
                                                    {
                                                        xtype: 'panel',
                                                        title: '<center>ANAMNESIS</center>',
                                                        layout: 'form',
                                                        anchor: '100%',
                                                        autoHeight: true,
                                                        id: 'pnFicIntAduJovenAnamnesis',
                                                        items: [
                                                            {
                                                                xtype: 'textarea',
                                                                width: 700,
                                                                fieldLabel: 'Salud Familiar y Personal',
                                                                name: 'Salud Familiar y Personal',
                                                                height: 50,
                                                                allowBlank: false,
                                                                id: 'memAnamnesis'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: '<center>EXAMEN  FÍSICO</center>',
                                                        layout: 'form',
                                                        anchor: '100%',
                                                        autoHeight: true,
                                                        id: 'pnFicIntAdulJovExaFisico',
                                                        items: [
                                                            {
                                                              html: '<br>'  
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        width: 60,
                                                                        minValue: 0,
                                                                        maxValue: 250,
                                                                        decimalPrecision: 2,
                                                                        allowBlank: false,
                                                                        fieldLabel: 'TALLA (cm)',
                                                                        name:"TALLA (cm)",
                                                                        emptyText: '(cm)',
                                                                        id: 'intEXAFISTalla',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null || pNew == 0){
                                                                                    Ext.getCmp('intEXAFISTalla').setValue(null);
                                                                                    Ext.getCmp('intEXAFISIMC').setValue(0);
                                                                                }else{
                                                                                    if(Ext.getCmp('intEXAFISPeso').getValue() > 0){
                                                                                        var pTalla = Ext.getCmp('intEXAFISTalla').getValue() / 100;
                                                                                        Ext.getCmp('intEXAFISIMC').setValue(Ext.getCmp('intEXAFISPeso').getValue()/(pTalla*pTalla));
                                                                                    }else{
                                                                                        Ext.getCmp('intEXAFISIMC').setValue(0);
                                                                                    }
                                                                                }
                                                                                if(Ext.getCmp('intEXAFISIMC').getValue()<1){
                                                                                   Ext.getCmp('strEXAFISIMCClasificacon').setValue(null);
                                                                                }else{
                                                                                    if(Ext.getCmp('intEXAFISIMC').getValue()<24.9){
                                                                                       Ext.getCmp('strEXAFISIMCClasificacon').setValue("ACEPTABLE");
                                                                                    }else{
                                                                                        if(Ext.getCmp('intEXAFISIMC').getValue()<29.9){
                                                                                           Ext.getCmp('strEXAFISIMCClasificacon').setValue("SOBREPESO");
                                                                                        }else{
                                                                                            Ext.getCmp('strEXAFISIMCClasificacon').setValue("OBESIDAD");
                                                                                        }

                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sysEXAFISPeso',
                                                                        value: 'PESO (Kg): '
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        width: 60,
                                                                        minValue: 0,
                                                                        maxValue: 250,
                                                                        decimalPrecision: 2,
                                                                        allowBlank: false,
                                                                        emptyText: '(Kg)',
                                                                        name:"PESO (Kg)",
                                                                        id: 'intEXAFISPeso',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null || pNew == 0){
                                                                                    Ext.getCmp('intEXAFISPeso').setValue(null);
                                                                                    Ext.getCmp('intEXAFISIMC').setValue(0);
                                                                                }else{
                                                                                    //peso [kg]/ estatura [m2]
                                                                                    if(Ext.getCmp('intEXAFISTalla').getValue() > 0){
                                                                                        var pTalla = Ext.getCmp('intEXAFISTalla').getValue() / 100;
                                                                                        Ext.getCmp('intEXAFISIMC').setValue(Ext.getCmp('intEXAFISPeso').getValue()/(pTalla*pTalla));
                                                                                    }else{
                                                                                        Ext.getCmp('intEXAFISIMC').setValue(0);
                                                                                    }
                                                                                }
                                                                                if(Ext.getCmp('intEXAFISIMC').getValue()<1){
                                                                                   Ext.getCmp('strEXAFISIMCClasificacon').setValue(null);
                                                                                }else{
                                                                                    if(Ext.getCmp('intEXAFISIMC').getValue()<24.9){
                                                                                       Ext.getCmp('strEXAFISIMCClasificacon').setValue("ACEPTABLE");
                                                                                    }else{
                                                                                        if(Ext.getCmp('intEXAFISIMC').getValue()<29.9){
                                                                                           Ext.getCmp('strEXAFISIMCClasificacon').setValue("SOBREPESO");
                                                                                        }else{
                                                                                            Ext.getCmp('strEXAFISIMCClasificacon').setValue("OBESIDAD");
                                                                                        }

                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sysEXAFISIMC',
                                                                        value: 'IMC: '
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        width: 60,
                                                                        minValue: 0,
                                                                        decimalPrecision: 2,
                                                                        allowBlank: false,
                                                                        readOnly: true,
                                                                        name: "IMC",
                                                                        id: 'intEXAFISIMC'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        anchor: '100%',
                                                                        allowBlank: false,
                                                                        readOnly: true,
                                                                        name: "IMC - CLASIFICACION",
                                                                        id: 'strEXAFISIMCClasificacon'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sysEXAFISPA',
                                                                        value: 'Relacion Cintura / Cadera: '
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 100,
                                                                        name: 'Relacion Cintura / Cadera',
                                                                        allowBlank: false,
                                                                        id: 'strExaFisRelCinCadera'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        fieldLabel: 'T.A.',
                                                                        name: 'T.A. Sistolica',
                                                                        width: 70,
                                                                        minValue: 0,
                                                                        maxValue: 300,
                                                                        decimalPrecision: 0,
                                                                        allowBlank: false,
                                                                        id: 'intEXAFISTASistolica'
                                                                    },
                                                                    {
                                                                        html: '/'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        name: 'T.A. Diastolica',
                                                                        width: 70,
                                                                        minValue: 0,
                                                                        maxValue: 300,
                                                                        decimalPrecision: 0,
                                                                        allowBlank: false,
                                                                        id: 'intEXAFISTADiastolica'
                                                                    }
                                                                ]
                                                            },
                                                            {   
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name:'Valoracion RCV',
                                                                        fieldLabel:'Valoracion RCV',
                                                                        width: 600,
                                                                        id: 'strExaFisValRieCardiovascular'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'fieldset',
                                                                title: 'Valoracion Mamaria',
                                                                layout: 'form',
                                                                collapsible: true,
                                                                titleCollapse: true,
                                                                anchor: '100%',
                                                                autoHeight: true,
                                                                padding: 7,
                                                                id: 'fsEXAMFISValMamaria',
                                                                items:[
                                                                    {
                                                                        xtype: 'textfield',
                                                                        anchor: '100%',
                                                                        fieldLabel: 'Aspecto',
                                                                        name: 'Aspecto',
                                                                        allowBlank: false,
                                                                        id: 'strEXAFISMamaAspecto',
                                                                        listeners: {
                                                                            render: function( p ) {
                                                                                p.getEl().on('dblclick', function (){
                                                                                    Ext.getCmp('strEXAFISMamaAspecto').setValue("No Evaluado");
                                                                                });
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        anchor: '100%',
                                                                        fieldLabel: 'Ganglios',
                                                                        name: 'Ganglios',
                                                                        allowBlank: false,
                                                                        id: 'strEXAFISMamaGanglios',
                                                                        listeners: {
                                                                            render: function( p ) {
                                                                                p.getEl().on('dblclick', function (){
                                                                                    Ext.getCmp('strEXAFISMamaGanglios').setValue("No Evaluado");
                                                                                });
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        anchor: '100%',
                                                                        fieldLabel: 'Malestar',
                                                                        name: 'Malestar',
                                                                        allowBlank: false,
                                                                        id: 'strEXAFISMamaMalestar',
                                                                        listeners: {
                                                                            render: function( p ) {
                                                                                p.getEl().on('dblclick', function (){
                                                                                    Ext.getCmp('strEXAFISMamaMalestar').setValue("No Evaluado");
                                                                                });
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        anchor: '100%',
                                                                        fieldLabel: 'Dolores',
                                                                        name: 'Dolores',
                                                                        allowBlank: false,
                                                                        id: 'strEXAFISMamaDolor',
                                                                        listeners: {
                                                                            render: function( p ) {
                                                                                p.getEl().on('dblclick', function (){
                                                                                    Ext.getCmp('strEXAFISMamaDolor').setValue("No Evaluado");
                                                                                });
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        anchor: '100%',
                                                                        fieldLabel: 'Descargas',
                                                                        name: 'Descargas',
                                                                        allowBlank: false,
                                                                        id: 'strEXAFISMamaDescargas',
                                                                        listeners: {
                                                                            render: function( p ) {
                                                                                p.getEl().on('dblclick', function (){
                                                                                    Ext.getCmp('strEXAFISMamaDescargas').setValue("No Evaluado");
                                                                                });
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        anchor: '100%',
                                                                        fieldLabel: 'Masas o Bultos',
                                                                        name: 'Masas o Bultos',
                                                                        allowBlank: false,
                                                                        id: 'strEXAFISMamaMasas',
                                                                        listeners: {
                                                                            render: function( p ) {
                                                                                p.getEl().on('dblclick', function (){
                                                                                    Ext.getCmp('strEXAFISMamaMasas').setValue("No Evaluado");
                                                                                });
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: '<center>APOYO DIAGNOSTICO</center>',
                                                        layout: 'form',
                                                        anchor: '100%',
                                                        autoHeight: true,
                                                        id: 'pnFicIntAduJovApoDX',
                                                        items: [
                                                            {   
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 60,
                                                                        forceSelection: true,
                                                                        emptyText: 'SI/NO',
                                                                        mode: 'local',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        listEmptyText: '',
                                                                        triggerAction: 'all',
                                                                        store:'StoreSiNo',
                                                                        fieldLabel:'Glicemia<br>&nbsp;',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        name:'Glicemia',
                                                                        id: 'strExamenGlicemia',
                                                                        listeners:{
                                                                            change : function( t, newValue, oldValue){
                                                                                if(newValue == "NO"){
                                                                                    Ext.getCmp('strExamenOftalmologicoDescripcion').allowBlank = true;
                                                                                    Ext.getCmp('fecExamenOftalmologicoFecha').allowBlank = true;
                                                                                    Ext.getCmp('strExamenOftalmologicoDescripcion').disable();
                                                                                    Ext.getCmp('fecExamenOftalmologicoFecha').disable();
                                                                                    Ext.getCmp('strExamenOftalmologicoDescripcion').clearInvalid();
                                                                                    Ext.getCmp('fecExamenOftalmologicoFecha').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('strExamenOftalmologicoDescripcion').enable();
                                                                                    Ext.getCmp('fecExamenOftalmologicoFecha').enable();
                                                                                    Ext.getCmp('strExamenOftalmologicoDescripcion').allowBlank = false;
                                                                                    Ext.getCmp('fecExamenOftalmologicoFecha').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        html: ' - '
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 250,
                                                                        allowBlank: true,
                                                                        disabled: true,
                                                                        name: 'Glicemia Descripcion',
                                                                        id: 'strExamenGlicemiaDescripcion'
                                                                    },
                                                                    {
                                                                        html: ' - '
                                                                    },
                                                                    {
                                                                        xtype: 'datefield',
                                                                        name: 'Glicemia Fecha',
                                                                        emptyText: '(dia/mes/año)',
                                                                        width: 120,
                                                                        allowBlank: true,
                                                                        disabled: true,
                                                                        id: 'fecExamenGlicemiaFecha'
                                                                    }
                                                                ]
                                                            },
                                                            {   
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 60,
                                                                        forceSelection: true,
                                                                        emptyText: 'SI/NO',
                                                                        mode: 'local',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        listEmptyText: '',
                                                                        triggerAction: 'all',
                                                                        store:'StoreSiNo',
                                                                        fieldLabel:'Perfil Lipidico<br>&nbsp;',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        name:'Perfil Lipidico',
                                                                        id: 'strExamenPerfilLipidico',
                                                                        listeners:{
                                                                            change : function( t, newValue, oldValue){
                                                                                if(newValue == "NO"){
                                                                                    Ext.getCmp('strExamenPerfilLipidicoDescripcion').allowBlank = true;
                                                                                    Ext.getCmp('fecExamenPerfilLipidicoFecha').allowBlank = true;
                                                                                    Ext.getCmp('strExamenPerfilLipidicoDescripcion').disable();
                                                                                    Ext.getCmp('fecExamenPerfilLipidicoFecha').disable();
                                                                                    Ext.getCmp('strExamenPerfilLipidicoDescripcion').clearInvalid();
                                                                                    Ext.getCmp('fecExamenPerfilLipidicoFecha').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('strExamenPerfilLipidicoDescripcion').enable();
                                                                                    Ext.getCmp('fecExamenPerfilLipidicoFecha').enable();
                                                                                    Ext.getCmp('strExamenPerfilLipidicoDescripcion').allowBlank = false;
                                                                                    Ext.getCmp('fecExamenPerfilLipidicoFecha').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        html: ' - '
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 250,
                                                                        allowBlank: true,
                                                                        disabled: true,
                                                                        name: 'Perfil Lipidico Descripcion',
                                                                        id: 'strExamenPerfilLipidicoDescripcion'
                                                                    },
                                                                    {
                                                                        html: ' - '
                                                                    },
                                                                    {
                                                                        xtype: 'datefield',
                                                                        name: 'Perfil Lipidico Fecha',
                                                                        emptyText: '(dia/mes/año)',
                                                                        width: 120,
                                                                        allowBlank: true,
                                                                        disabled: true,
                                                                        id: 'fecExamenPerfilLipidicoFecha'
                                                                    }
                                                                ]
                                                            },
                                                            {   
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 60,
                                                                        forceSelection: true,
                                                                        emptyText: 'SI/NO',
                                                                        mode: 'local',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        listEmptyText: '',
                                                                        triggerAction: 'all',
                                                                        store:'StoreSiNo',
                                                                        fieldLabel:'Citologia<br>&nbsp;',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        name:'Citologia',
                                                                        id: 'strExamenCitologia',
                                                                        listeners:{
                                                                            change : function( t, newValue, oldValue){
                                                                                if(newValue == "NO"){
                                                                                    Ext.getCmp('strExamenCitologiaDescripcion').allowBlank = true;
                                                                                    Ext.getCmp('fecExamenCitologiaFecha').allowBlank = true;
                                                                                    Ext.getCmp('strExamenCitologiaDescripcion').disable();
                                                                                    Ext.getCmp('fecExamenCitologiaFecha').disable();
                                                                                    Ext.getCmp('strExamenCitologiaDescripcion').clearInvalid();
                                                                                    Ext.getCmp('fecExamenCitologiaFecha').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('strExamenCitologiaDescripcion').enable();
                                                                                    Ext.getCmp('fecExamenCitologiaFecha').enable();
                                                                                    Ext.getCmp('strExamenCitologiaDescripcion').allowBlank = false;
                                                                                    Ext.getCmp('fecExamenCitologiaFecha').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        html: ' - '
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 250,
                                                                        allowBlank: true,
                                                                        disabled: true,
                                                                        name: 'Citologia Descripcion',
                                                                        id: 'strExamenCitologiaDescripcion'
                                                                    },
                                                                    {
                                                                        html: ' - '
                                                                    },
                                                                    {
                                                                        xtype: 'datefield',
                                                                        name: 'Citologia Fecha',
                                                                        emptyText: '(dia/mes/año)',
                                                                        width: 120,
                                                                        allowBlank: true,
                                                                        disabled: true,
                                                                        id: 'fecExamenCitologiaFecha'
                                                                    }
                                                                ]
                                                            },
                                                            {   
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 60,
                                                                        forceSelection: true,
                                                                        emptyText: 'SI/NO',
                                                                        mode: 'local',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        listEmptyText: '',
                                                                        triggerAction: 'all',
                                                                        store:'StoreSiNo',
                                                                        fieldLabel:'Sandre Oculta en Eces',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        name:'Sandre Oculta en Eces',
                                                                        id: 'strExamenSandreOcultaEces',
                                                                        listeners:{
                                                                            change : function( t, newValue, oldValue){
                                                                                if(newValue == "NO"){
                                                                                    Ext.getCmp('strExamenSandreOcultaEcesDescripcion').allowBlank = true;
                                                                                    Ext.getCmp('fecExamenSandreOcultaEcesFecha').allowBlank = true;
                                                                                    Ext.getCmp('strExamenSandreOcultaEcesDescripcion').disable();
                                                                                    Ext.getCmp('fecExamenSandreOcultaEcesFecha').disable();
                                                                                    Ext.getCmp('strExamenSandreOcultaEcesDescripcion').clearInvalid();
                                                                                    Ext.getCmp('fecExamenSandreOcultaEcesFecha').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('strExamenSandreOcultaEcesDescripcion').enable();
                                                                                    Ext.getCmp('fecExamenSandreOcultaEcesFecha').enable();
                                                                                    Ext.getCmp('strExamenSandreOcultaEcesDescripcion').allowBlank = false;
                                                                                    Ext.getCmp('fecExamenSandreOcultaEcesFecha').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        html: ' - '
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 250,
                                                                        allowBlank: true,
                                                                        disabled: true,
                                                                        name: 'Sandre Oculta en Eces Descripcion',
                                                                        id: 'strExamenSandreOcultaEcesDescripcion'
                                                                    },
                                                                    {
                                                                        html: ' - '
                                                                    },
                                                                    {
                                                                        xtype: 'datefield',
                                                                        name: 'Sandre Oculta en Eces Fecha',
                                                                        emptyText: '(dia/mes/año)',
                                                                        width: 120,
                                                                        allowBlank: true,
                                                                        disabled: true,
                                                                        id: 'fecExamenSandreOcultaEcesFecha'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: '<center>EDUCACION</center>',
                                                        layout: 'form',
                                                        anchor: '100%',
                                                        autoHeight: true,
                                                        id: 'pnFicIntAduJovEducacion',
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'table',
                                                                anchor: '100%',
                                                                padding: 0,
                                                                layoutConfig: {
                                                                    columns: 2
                                                                },
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'panel',
                                                                        layout: 'form',
                                                                        width: 400,
                                                                        autoHeight: true,
                                                                        labelSeparator: '',
                                                                        labelStyle: 'color:blue;',
                                                                        items: [
                                                                            {
                                                                                xtype: 'combo',
                                                                                width: 60,
                                                                                forceSelection: true,
                                                                                emptyText: 'SI/NO',
                                                                                mode: 'local',
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 50,
                                                                                listEmptyText: '',
                                                                                triggerAction: 'all',
                                                                                store:'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                name:'Autocuidado',
                                                                                fieldLabel:'Autocuidado<br>&nbsp;',
                                                                                id: 'strEduAutocuidado'
                                                                            },
                                                                            {
                                                                                xtype: 'combo',
                                                                                width: 60,
                                                                                forceSelection: true,
                                                                                emptyText: 'SI/NO',
                                                                                mode: 'local',
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 50,
                                                                                listEmptyText: '',
                                                                                triggerAction: 'all',
                                                                                store:'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                name:'Nutricion',
                                                                                fieldLabel:'Nutricion<br>&nbsp;',
                                                                                id: 'strEduNutricion'
                                                                            },
                                                                            {
                                                                                xtype: 'combo',
                                                                                width: 60,
                                                                                forceSelection: true,
                                                                                emptyText: 'SI/NO',
                                                                                mode: 'local',
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 50,
                                                                                listEmptyText: '',
                                                                                triggerAction: 'all',
                                                                                store:'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                name:'Ejercicio',
                                                                                fieldLabel:'Ejercicio<br>&nbsp;',
                                                                                id: 'strEduEjercicio'
                                                                            },
                                                                            {
                                                                                xtype: 'combo',
                                                                                width: 60,
                                                                                forceSelection: true,
                                                                                emptyText: 'SI/NO',
                                                                                mode: 'local',
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 50,
                                                                                listEmptyText: '',
                                                                                triggerAction: 'all',
                                                                                store:'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                name:'Tiempo Libre',
                                                                                fieldLabel:'Tiempo Libre<br>&nbsp;',
                                                                                id: 'strEduTieLib'
                                                                            },
                                                                            {
                                                                                xtype: 'combo',
                                                                                width: 60,
                                                                                forceSelection: true,
                                                                                emptyText: 'SI/NO',
                                                                                mode: 'local',
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 50,
                                                                                listEmptyText: '',
                                                                                triggerAction: 'all',
                                                                                store:'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                name:'Sexualidad',
                                                                                fieldLabel:'Sexualidad<br>&nbsp;',
                                                                                id: 'strEduSexualidad'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'panel',
                                                                        layout: 'form',
                                                                        width: 400,
                                                                        autoHeight: true,
                                                                        labelSeparator: '',
                                                                        labelStyle: 'color:blue;',
                                                                        items: [
                                                                            {
                                                                                xtype: 'combo',
                                                                                width: 60,
                                                                                forceSelection: true,
                                                                                emptyText: 'SI/NO',
                                                                                mode: 'local',
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 50,
                                                                                listEmptyText: '',
                                                                                triggerAction: 'all',
                                                                                store:'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                name:'Planificacion Familiar',
                                                                                fieldLabel:'Planificacion Familiar',
                                                                                id: 'strEduPlaFamiliar'
                                                                            },
                                                                            {
                                                                                xtype: 'combo',
                                                                                width: 60,
                                                                                forceSelection: true,
                                                                                emptyText: 'SI/NO',
                                                                                mode: 'local',
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 50,
                                                                                listEmptyText: '',
                                                                                triggerAction: 'all',
                                                                                store:'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                name:'Alcohol, Tabaco y Drogas',
                                                                                fieldLabel:'Alcohol, Tabaco y Drogas',
                                                                                id: 'strEduAlcTabDro'
                                                                            },
                                                                            {
                                                                                xtype: 'combo',
                                                                                width: 60,
                                                                                forceSelection: true,
                                                                                emptyText: 'SI/NO',
                                                                                mode: 'local',
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 50,
                                                                                listEmptyText: '',
                                                                                triggerAction: 'all',
                                                                                store:'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                name:'Autoexamen Seno',
                                                                                fieldLabel:'Autoexamen Seno',
                                                                                id: 'strEduAutSeno'
                                                                            },
                                                                            {
                                                                                xtype: 'combo',
                                                                                width: 60,
                                                                                forceSelection: true,
                                                                                emptyText: 'SI/NO',
                                                                                mode: 'local',
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 50,
                                                                                listEmptyText: '',
                                                                                triggerAction: 'all',
                                                                                store:'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                name:'Autoexamen Testiculo',
                                                                                fieldLabel:'Autoexamen Testiculo',
                                                                                id: 'strEduAutTestículos'
                                                                            },
                                                                            {
                                                                                xtype: 'combo',
                                                                                width: 60,
                                                                                forceSelection: true,
                                                                                emptyText: 'SI/NO',
                                                                                mode: 'local',
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 50,
                                                                                listEmptyText: '',
                                                                                triggerAction: 'all',
                                                                                store:'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                name:'Salud Oral',
                                                                                fieldLabel:'Salud Oral<br>&nbsp;',
                                                                                id: 'strEduSalOral'
                                                                            }
                                                                        ]
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'datefield',
                                                                width: 120,
                                                                fieldLabel: 'Fecha Probable Proxima Cita',
                                                                name: 'Fecha Probable Proxima Cita',
                                                                allowBlank: true,
                                                                emptyText: '(dia/mes/año) ',
                                                                style: 'text-align:center;',
                                                                id: 'fecProximaCita'
                                                            },
                                                            {
                                                                html: 'Profesional que Atiende'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Profesional que Atiende',
                                                                width: 250,
                                                                allowBlank: true,
                                                                store: stProfesionalAtiende,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strProximaCitaProfesionalAtiende'
                                                            }
                                                        ]
                                                    }
                                                ]                                                
                                            },
                                            // AQUI FINALIZAN CAMBIOS 
                                            {
                                                xtype: 'fieldset',
                                                title: 'RIPS',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                id: 'fsRips',
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: false,
                                                                fieldLabel: 'Diagnostico Principal',
                                                                id: 'sysDiagPpalHC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request({
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                        Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagPpalHCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Principal',
                                                                id: 'btnSearchDiagPpalHC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagPpalHC','sysDiagPpalHCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.1',
                                                                id: 'sysDiagRel1HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel1HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado1',
                                                                id: 'btnSearchDiagRel1HC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel1HC','sysDiagRel1HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.2',
                                                                id: 'sysDiagRel2HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel2HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado2',
                                                                id: 'btnSearchDiagRel2HC1',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel2HC','sysDiagRel2HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.3',
                                                                id: 'sysDiagRel3HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel3HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado3',
                                                                id: 'btnSearchDiagRel3HC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel3HC','sysDiagRel3HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Tipo de Diagnostico',
                                                        width:750,
                                                        name: 'Tipo de Diagnostico',
                                                        allowBlank: false,
                                                        store: 'StoreTipoDiagnostico',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        id: 'sysTipoDiagosticoHC'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Finalidad Consulta',
                                                        width:750,
                                                        name: 'Finalidad Consulta',
                                                        allowBlank: false,
                                                        store: 'StoreFinalidadConsulta',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 10,
                                                        id: 'sysFinalidadConsultaHC'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Causa Externa',
                                                        width:750,
                                                        name: 'Causa Externa',
                                                        allowBlank: false,
                                                        store: 'StoreCausaExterna',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 13,
                                                        id: 'sysCausaExternaHC'
                                                    }                            
                                                ]
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Medicamentos',
                                height: 352,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaMedicamentos',
                                items: [
                                    xSolMX
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Servicios',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaServicios',
                                items: [
                                    xSolEXA
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Remisiones',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaRemisiones',
                                items: [
                                    xSolREM
                                ]
                            }
                            /*,
                            {
                                xtype: 'panel',
                                title: 'Solicitud CTC',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaCTC',
                                items: [
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Consentimientos Informados',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaConsentimientos',
                                items: [
                                ]
                            },*/
                        ]
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btnSalirEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 1) 
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    if (Ext.getCmp('sysUsaGridSalida').getValue() == 1){
                                                        Ext.getCmp('gridFormulario').store.reload();
                                                    }
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Usted No ha Guardado la Evolución del Paciente y Se Perdera la Información, Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                },
                tbar:{
                    items: [
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Ver Historia Clínica',
                            iconCls: 'btnVerHC',
                            id: 'btnVerHC',
                            listeners:{
                                click : function(){
                                    var cmpResumenHC = new winFrmVerHistorialHC({
                                        renderTo: Ext.getBody()
                                    });
                                    Ext.getCmp('winViewEvolucionHC').title = "PACIENTE: " + Ext.getCmp('sysPacienteHC').getValue();
                                    Ext.getCmp('gridHistorialEvoluciones').store.load({
                                        params: {
                                            pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                                            pPaciente: Ext.getCmp('sysIdPacienteHC').getValue()
                                        }
                                    });
                                    cmpResumenHC.show();
                                }
                            }
                        },
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar Evolución',
                            iconCls: 'btnGuardar',
                            id: 'btnGuardarEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 0) 
                                    {
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Guardar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnGuardarRegistros();
                                                }
                                            }
                                        });
                                    }else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Modificar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnModificarRegistros();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                }
            }
        ];
        this.on({
            afterlayout:{
                scope:this, 
                single:true, 
                fn:function() {
                    Ext.Msg.hide();
                    //Predefinir Comportamiento Campos

                    //EVALUA VALORACION MAMARIA
                    if(Ext.getCmp('sysGeneroPacHC').getValue()=="MASCULINO"){
                        Ext.getCmp('fsEXAMFISValMamaria').setVisible(false);
                        Ext.getCmp('strEXAFISMamaAspecto').allowBlank = true;
                        Ext.getCmp('strEXAFISMamaGanglios').allowBlank = true;
                        Ext.getCmp('strEXAFISMamaMalestar').allowBlank = true;
                        Ext.getCmp('strEXAFISMamaDolor').allowBlank = true;
                        Ext.getCmp('strEXAFISMamaDescargas').allowBlank = true;
                        Ext.getCmp('strEXAFISMamaMasas').allowBlank = true;
                    }else{
                        Ext.getCmp('fsEXAMFISValMamaria').setVisible(true);
                        Ext.getCmp('strEXAFISMamaAspecto').allowBlank = false;
                        Ext.getCmp('strEXAFISMamaGanglios').allowBlank = false;
                        Ext.getCmp('strEXAFISMamaMalestar').allowBlank = false;
                        Ext.getCmp('strEXAFISMamaDolor').allowBlank = false;
                        Ext.getCmp('strEXAFISMamaDescargas').allowBlank = false;
                        Ext.getCmp('strEXAFISMamaMasas').allowBlank = false;
                    }
                }
            }
        });
        winHCAdultoJovenUi.superclass.initComponent.call(this);
    }
});

function fnGuardarRegistros(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc.php',
            params:{
                task: 'guardar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pidPlantillaHC : Ext.getCmp('sysIdCodPlantillaHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1); 
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function fnModificarRegistros(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc.php',
            params:{
                task: 'modificar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}
