/*
* @category    Formulario Modelo Evolucion Historia Clinica Riesgo Reproductivo 
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winHCRiesgoReproductivoUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic ©  .:: Plantilla HC Riesgo Reproductivo ::.',
    width: 990,
    height: 636,
    closable: false,
    resizable: false,
    draggable: false,
    modal: true,
    id: 'winHC',
    initComponent: function() {
        
        var EdadMujer = 0;
        var Paridad = 0;
        var SocioEconomico = 0;
        var IntervaloEmbarazos = 0;
        var Aborto = 0;
        var Cesarea = 0;
        var Mortinato = 0;
        var Prematuro = 0;
        var HipertensionA = 0;
        var HipertensionB = 0;
        var Toxemia = 0;
        var CardiopatiaA = 0;
        var CardiopatiaB = 0;
        var OtraPatologiaA = 0;
        var OtraPatologiaB = 0;
        var EnfermedadRenal = 0;
        var AnemiaSevera = 0;
        
        
        
        tmpmx = objMX;
        tmpmxadd = objMXADD;
        tmpexa = objEXA;
        tmprem = objREM;
        myPaciente = 0;
        myCAS = 0;

        try {
            var campo = Ext.getCmp('sysPacientePlantillaHC');
            if ( campo != null ) {
                myPaciente = Ext.getCmp('sysPacientePlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myPaciente == 0){
            try {
                var campo1 = Ext.getCmp('sysIdPacienteHC');
                if ( campo1 != null ) {
                    myPaciente = Ext.getCmp('sysIdPacienteHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myPaciente == 0){
            try {
                var campo5 = Ext.getCmp('sysPacienteRefHC');
                if ( campo5 != null ) {
                    myPaciente = Ext.getCmp('sysPacienteRefHC').getValue();
                }
            }catch(ex){
            }
        }
        try {
            var campo2 = Ext.getCmp('sysCASPlantillaHC');
            if ( campo2 != null ) {
                myCAS = Ext.getCmp('sysCASPlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myCAS == 0){
            try {
                var campo3 = Ext.getCmp('sysCASHC');
                if ( campo3 != null ) {
                    myCAS = Ext.getCmp('sysCASHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myCAS == 0){
            try {
                var campo4 = Ext.getCmp('sysCASRefHC');
                if ( campo4 != null ) {
                    myCAS = Ext.getCmp('sysCASRefHC').getValue();
                }
            }catch(ex){
            }
        }
        if (objMX != "NA"){
            var xSolMX = eval(objMX);
            Ext.getCmp('gridMedicamentosHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }
        else{
            var xSolMX = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        if (objEXA != "NA"){
            var xSolEXA = eval(objEXA);
            Ext.getCmp('gridExamenesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }else{
            var xSolEXA = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        if (objREM != "NA"){
            var xSolREM = eval(objREM);
            Ext.getCmp('gridRemisionesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }else{
            var xSolREM = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }

        var dataEdadMujer = [
            ['17 años o menos'],
            ['18 a 34 años'],
            ['35 años o mas']
        ];
        var stEdadMujer = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stEdadMujer.loadData(dataEdadMujer);


        var dataParidad = [
            ['Nulipara'],
            ['1 a 3 partos'],
            ['4 partos o mas']
        ];
        var stParidad = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stParidad.loadData(dataParidad);
        

        var dataSocioEconomico = [
            ['Tugurio'],
            ['Niño menor de 2 años o desnutrido'],
            ['muerte niño menor de 2 años']
        ];
        var stSocioEconomico = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stSocioEconomico.loadData(dataSocioEconomico);
        

        var dataIntervaloEmbarazo = [
            ['Menor de 12 meses'],
            ['1 a 2 años'],
            ['mas de 2 años']
        ];
        var stIntervaloEmbarazo = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stIntervaloEmbarazo.loadData(dataIntervaloEmbarazo);
        

        var dataAntecedentes = [
            ['1 o 2'],
            ['3 o mas']
        ];
        var stAntecedentes = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stAntecedentes.loadData(dataAntecedentes);
        

        
        this.items = [
            {
                xtype: 'panel',
                frame: true,
                anchor: '100%',
                id: 'panelHC',
                border: false,
                height: 570,
                autoScroll: true,
                layout: 'form',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysIdCodPlantillaHC'
                    },
                     {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        value: 1,
                        id: 'sysUsaGridSalida'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        value: 0,
                        id: 'sysYaGuardoHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysPlantillaHC',
                        name: 'PLANTILLA'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptMx'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptExa'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptRem'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Actividad',
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        id: 'sysActividadHC',
                        name: 'PLANTILLA'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Empresa',
                        id: 'sysEmpresaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'IPS',
                        id: 'sysIPSHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Usuario',
                        id: 'sysUsuarioHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Profesional',
                        id: 'sysProfesionalHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Paciente',
                        id: 'sysIdPacienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Apertura',
                        id: 'sysAperturaHC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Cliente',
                        id: 'sysClienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdClienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdPlanHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdSubPlanHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdContratoHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Genero',
                        id: 'sysGeneroPacHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Edad',
                        id: 'sysEdadPacHC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Profesional',
                        id: 'sysProfesionalAgendaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'ConsecutivoDetalle',
                        id: 'sysConsecutivoDetalleHC'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'CAS',
                                id: 'sysCASHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysFechaHC',
                                value: 'Fecha: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysFechaHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysHoraHC',
                                value: 'Hora: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysHoraHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysLegalizacionHC',
                                value: 'Legalización: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysLegalizaHC'
                            }
                        ]
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Paciente',
                        value: 'CC 792558261  - JORGE GALEANO RUIZ - (Masculino) FechaNac: 1973-01-30, Edad 38 Años',
                        id: 'sysPacienteHC'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                width: 100,
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'Genero',
                                id: 'sysGeneroHC'
                            },
                            {
                                html: 'Fecha Nac:'
                            },
                            {
                                xtype: 'textfield',
                                width: 100,
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysFechaNac'
                            },
                            {
                                html: 'Edad:'
                            },
                            {
                                xtype: 'textfield',
                                width: 350,
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysEdadHC'
                            }
                        ]
                    },
                    {
                        xtype: 'hidden',
                        width: 370,
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Ocupación',
                        id: 'sysOcupacionHC'
                    },
                    {
                        xtype: 'hidden',
                        width: 370,
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysDiscapacidadHC'
                    },
                    {
                        xtype: 'hidden',
                        width: 370,
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Estado Civil',
                        id: 'sysEstadoCivilHC'
                    },
                    {
                        xtype: 'hidden',
                        width: 380,
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysEscolaridadHC'
                    },
                    {
                        xtype: 'hidden',
                        width: 370,
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Dirección',
                        id: 'sysDireccionHC'
                    },
                    {
                        xtype: 'hidden',
                        width: 390,
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysTelefonoHC'
                    },
                    {
                        xtype: 'hidden',
                        width: 380,
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Etnia',
                        id: 'sysEtniaHC'
                    },
                    {
                        xtype: 'hidden',
                        width: 390,
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysEstratoHC'
                    },
                    {
                        html: '<hr>',
                        style: 'background:transparent;',
                        border: false
                    },
                    {
                        xtype: 'tabpanel',
                        anchor: '99%',
                        autoHeight: true,
                        border: false,
                        enableTabScroll: true,
                        ref: 'fTabPanel',
                        id: 'fTabPanel',
                        activeTab: 0,
                        items: [
                            {
                                xtype: 'panel',
                                title: 'Evolución',
                                autoHeight: true,
                                autoScroll: true,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaEvolucion',
                                layout: 'form',
                                items: [
                                    {
                                        xtype: 'form',
                                        frame: true,
                                        anchor: '100%',
                                        id: 'frmHC',
                                        padding: 10,
                                        border: false,
                                        autoScroll: true,
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'fieldset',
                                                title: 'MOTIVO DE CONSULTA',
                                                layout: 'table',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'MOTIVO DE CONSULTA',
                                                        name: 'MOTIVO DE CONSULTA',
                                                        height: 100,
                                                        allowBlank: false,
                                                        id: 'memMotivoConsulta'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'INDICE DE RIESGO REPRODUCTIVO',
                                                layout: 'table',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'panel',
                                                        layout: 'table',
                                                        anchor: '100%',
                                                        padding: 0,
                                                        layoutConfig: {
                                                            columns: 2
                                                        },
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                width: 400,
                                                                autoHeight: true,
                                                                labelSeparator: '',
                                                                labelStyle: 'color:blue;',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Edad de la Mujer',
                                                                        fieldLabel: 'Edad de la Mujer',
                                                                        width: 250,
                                                                        allowBlank: true,
                                                                        store: stEdadMujer,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'intEdadMujer',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew != "18 a 34 años" || pNew != "18 a 34 años"){
                                                                                    EdadMujer = 2;
                                                                                    Ext.getCmp('intPuntajeTotal').setValue(EdadMujer + Paridad + SocioEconomico + IntervaloEmbarazos + Aborto + Cesarea + Mortinato + Prematuro + HipertensionA + HipertensionB + Toxemia + CardiopatiaA + CardiopatiaB + OtraPatologiaA + OtraPatologiaB + EnfermedadRenal + AnemiaSevera)
                                                                                }else{
                                                                                    EdadMujer = 0;
                                                                                    Ext.getCmp('intPuntajeTotal').setValue(EdadMujer + Paridad + SocioEconomico + IntervaloEmbarazos + Aborto + Cesarea + Mortinato + Prematuro + HipertensionA + HipertensionB + Toxemia + CardiopatiaA + CardiopatiaB + OtraPatologiaA + OtraPatologiaB + EnfermedadRenal + AnemiaSevera)
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        html: '<br>'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Paridad',
                                                                        fieldLabel: 'Paridad',
                                                                        width: 250,
                                                                        allowBlank: true,
                                                                        store: stParidad,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'intParidad',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == "1 a 3 partos"){
                                                                                    Paridad = 1;
                                                                                    Ext.getCmp('intPuntajeTotal').setValue(EdadMujer + Paridad + SocioEconomico + IntervaloEmbarazos + Aborto + Cesarea + Mortinato + Prematuro + HipertensionA + HipertensionB + Toxemia + CardiopatiaA + CardiopatiaB + OtraPatologiaA + OtraPatologiaB + EnfermedadRenal + AnemiaSevera)
                                                                                }else{
                                                                                    if(pNew == "4 partos o mas"){
                                                                                        Paridad = 4;
                                                                                        Ext.getCmp('intPuntajeTotal').setValue(EdadMujer + Paridad + SocioEconomico + IntervaloEmbarazos + Aborto + Cesarea + Mortinato + Prematuro + HipertensionA + HipertensionB + Toxemia + CardiopatiaA + CardiopatiaB + OtraPatologiaA + OtraPatologiaB + EnfermedadRenal + AnemiaSevera)
                                                                                    }else{
                                                                                        Paridad = 0;
                                                                                        Ext.getCmp('intPuntajeTotal').setValue(EdadMujer + Paridad + SocioEconomico + IntervaloEmbarazos + Aborto + Cesarea + Mortinato + Prematuro + HipertensionA + HipertensionB + Toxemia + CardiopatiaA + CardiopatiaB + OtraPatologiaA + OtraPatologiaB + EnfermedadRenal + AnemiaSevera)
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        html: '<br>'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Socio-Economico',
                                                                        fieldLabel: 'Socio-Economico',
                                                                        width: 250,
                                                                        allowBlank: true,
                                                                        store: stSocioEconomico,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'intSocioEconomico',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew != null || pNew != ''){
                                                                                    SocioEconomico = 2;
                                                                                    Ext.getCmp('intPuntajeTotal').setValue(EdadMujer + Paridad + SocioEconomico + IntervaloEmbarazos + Aborto + Cesarea + Mortinato + Prematuro + HipertensionA + HipertensionB + Toxemia + CardiopatiaA + CardiopatiaB + OtraPatologiaA + OtraPatologiaB + EnfermedadRenal + AnemiaSevera)
                                                                                }else{
                                                                                    SocioEconomico = 0;
                                                                                    Ext.getCmp('intPuntajeTotal').setValue(EdadMujer + Paridad + SocioEconomico + IntervaloEmbarazos + Aborto + Cesarea + Mortinato + Prematuro + HipertensionA + HipertensionB + Toxemia + CardiopatiaA + CardiopatiaB + OtraPatologiaA + OtraPatologiaB + EnfermedadRenal + AnemiaSevera)
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        html: '<br>'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Intervalo de Embarazos',
                                                                        fieldLabel: 'Intervalo de Embarazos',
                                                                        width: 250,
                                                                        allowBlank: true,
                                                                        store: stIntervaloEmbarazo,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'intIntervaloEmbarazos',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == "Menor de 12 meses"){
                                                                                    IntervaloEmbarazos = 4;
                                                                                    Ext.getCmp('intPuntajeTotal').setValue(EdadMujer + Paridad + SocioEconomico + IntervaloEmbarazos + Aborto + Cesarea + Mortinato + Prematuro + HipertensionA + HipertensionB + Toxemia + CardiopatiaA + CardiopatiaB + OtraPatologiaA + OtraPatologiaB + EnfermedadRenal + AnemiaSevera)
                                                                                }else{
                                                                                    if(pNew == "1 a 2 años"){
                                                                                        IntervaloEmbarazos = 1;
                                                                                        Ext.getCmp('intPuntajeTotal').setValue(EdadMujer + Paridad + SocioEconomico + IntervaloEmbarazos + Aborto + Cesarea + Mortinato + Prematuro + HipertensionA + HipertensionB + Toxemia + CardiopatiaA + CardiopatiaB + OtraPatologiaA + OtraPatologiaB + EnfermedadRenal + AnemiaSevera)
                                                                                    }else{
                                                                                        IntervaloEmbarazos = 0;
                                                                                        Ext.getCmp('intPuntajeTotal').setValue(EdadMujer + Paridad + SocioEconomico + IntervaloEmbarazos + Aborto + Cesarea + Mortinato + Prematuro + HipertensionA + HipertensionB + Toxemia + CardiopatiaA + CardiopatiaB + OtraPatologiaA + OtraPatologiaB + EnfermedadRenal + AnemiaSevera)
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'panel',
                                                                        layout: 'form',
                                                                        width: 375,
                                                                        autoHeight: true,
                                                                        labelSeparator: '',
                                                                        labelStyle: 'color:blue;',
                                                                        title: 'Patologia Actual',
                                                                        items: [
                                                                            {
                                                                                html: '<br>'
                                                                            },
                                                                            {
                                                                                xtype: 'checkbox',
                                                                                fieldLabel: 'Anemia Severa',
                                                                                name: 'Anemia Severa',
                                                                                anchor: '100%',
                                                                                value: 'false',
                                                                                id: 'bolAnemiaSevera',
                                                                                listeners:{
                                                                                    change : function(f,pNew, pOld){
                                                                                        if(pNew == true){
                                                                                            AnemiaSevera = 4;
                                                                                            Ext.getCmp('intPuntajeTotal').setValue(EdadMujer + Paridad + SocioEconomico + IntervaloEmbarazos + Aborto + Cesarea + Mortinato + Prematuro + HipertensionA + HipertensionB + Toxemia + CardiopatiaA + CardiopatiaB + OtraPatologiaA + OtraPatologiaB + EnfermedadRenal + AnemiaSevera)
                                                                                        }else{
                                                                                            AnemiaSevera = 0;
                                                                                            Ext.getCmp('intPuntajeTotal').setValue(EdadMujer + Paridad + SocioEconomico + IntervaloEmbarazos + Aborto + Cesarea + Mortinato + Prematuro + HipertensionA + HipertensionB + Toxemia + CardiopatiaA + CardiopatiaB + OtraPatologiaA + OtraPatologiaB + EnfermedadRenal + AnemiaSevera)
                                                                                        }
                                                                                    }
                                                                                }
                                                                            },
                                                                            {
                                                                                xtype: 'checkbox',
                                                                                fieldLabel: 'Enfermedad Renal',
                                                                                name: 'Enfermedad Renal',
                                                                                anchor: '100%',
                                                                                value: 'false',
                                                                                id: 'bolEnfermedadRenal',
                                                                                listeners:{
                                                                                    change : function(f,pNew, pOld){
                                                                                        if(pNew == true){
                                                                                            EnfermedadRenal = 4;
                                                                                            Ext.getCmp('intPuntajeTotal').setValue(EdadMujer + Paridad + SocioEconomico + IntervaloEmbarazos + Aborto + Cesarea + Mortinato + Prematuro + HipertensionA + HipertensionB + Toxemia + CardiopatiaA + CardiopatiaB + OtraPatologiaA + OtraPatologiaB + EnfermedadRenal + AnemiaSevera)
                                                                                        }else{
                                                                                            EnfermedadRenal = 0;
                                                                                            Ext.getCmp('intPuntajeTotal').setValue(EdadMujer + Paridad + SocioEconomico + IntervaloEmbarazos + Aborto + Cesarea + Mortinato + Prematuro + HipertensionA + HipertensionB + Toxemia + CardiopatiaA + CardiopatiaB + OtraPatologiaA + OtraPatologiaB + EnfermedadRenal + AnemiaSevera)
                                                                                        }
                                                                                    }
                                                                                }
                                                                            },
                                                                            {
                                                                                xtype: 'checkbox',
                                                                                fieldLabel: 'Hipertension',
                                                                                name: 'Hipertension',
                                                                                anchor: '100%',
                                                                                value: 'false',
                                                                                id: 'bolHipertensionB',
                                                                                listeners:{
                                                                                    change : function(f,pNew, pOld){
                                                                                        if(pNew == true){
                                                                                            HipertensionB = 4;
                                                                                            Ext.getCmp('intPuntajeTotal').setValue(EdadMujer + Paridad + SocioEconomico + IntervaloEmbarazos + Aborto + Cesarea + Mortinato + Prematuro + HipertensionA + HipertensionB + Toxemia + CardiopatiaA + CardiopatiaB + OtraPatologiaA + OtraPatologiaB + EnfermedadRenal + AnemiaSevera)
                                                                                        }else{
                                                                                            HipertensionB = 0;
                                                                                            Ext.getCmp('intPuntajeTotal').setValue(EdadMujer + Paridad + SocioEconomico + IntervaloEmbarazos + Aborto + Cesarea + Mortinato + Prematuro + HipertensionA + HipertensionB + Toxemia + CardiopatiaA + CardiopatiaB + OtraPatologiaA + OtraPatologiaB + EnfermedadRenal + AnemiaSevera)
                                                                                        }
                                                                                    }
                                                                                }
                                                                            },
                                                                            {
                                                                                xtype: 'checkbox',
                                                                                fieldLabel: 'Cardiopatia',
                                                                                name: 'Cardiopatia',
                                                                                anchor: '100%',
                                                                                value: 'false',
                                                                                id: 'bolCardiopatiaB',
                                                                                listeners:{
                                                                                    change : function(f,pNew, pOld){
                                                                                        if(pNew == true){
                                                                                            CardiopatiaB = 4;
                                                                                            Ext.getCmp('intPuntajeTotal').setValue(EdadMujer + Paridad + SocioEconomico + IntervaloEmbarazos + Aborto + Cesarea + Mortinato + Prematuro + HipertensionA + HipertensionB + Toxemia + CardiopatiaA + CardiopatiaB + OtraPatologiaA + OtraPatologiaB + EnfermedadRenal + AnemiaSevera)
                                                                                        }else{
                                                                                            CardiopatiaB = 0;
                                                                                            Ext.getCmp('intPuntajeTotal').setValue(EdadMujer + Paridad + SocioEconomico + IntervaloEmbarazos + Aborto + Cesarea + Mortinato + Prematuro + HipertensionA + HipertensionB + Toxemia + CardiopatiaA + CardiopatiaB + OtraPatologiaA + OtraPatologiaB + EnfermedadRenal + AnemiaSevera)
                                                                                        }
                                                                                    }
                                                                                }
                                                                            },
                                                                            {
                                                                                xtype: 'checkbox',
                                                                                fieldLabel: 'Otra Patologia',
                                                                                name: 'Otra Patologia',
                                                                                anchor: '100%',
                                                                                value: 'false',
                                                                                id: 'bolOtraPatologiaB',
                                                                                listeners:{
                                                                                    change : function(f,pNew, pOld){
                                                                                        if(pNew == true){
                                                                                            OtraPatologiaB = 4;
                                                                                            Ext.getCmp('intPuntajeTotal').setValue(EdadMujer + Paridad + SocioEconomico + IntervaloEmbarazos + Aborto + Cesarea + Mortinato + Prematuro + HipertensionA + HipertensionB + Toxemia + CardiopatiaA + CardiopatiaB + OtraPatologiaA + OtraPatologiaB + EnfermedadRenal + AnemiaSevera)
                                                                                        }else{
                                                                                            OtraPatologiaB = 0;
                                                                                            Ext.getCmp('intPuntajeTotal').setValue(EdadMujer + Paridad + SocioEconomico + IntervaloEmbarazos + Aborto + Cesarea + Mortinato + Prematuro + HipertensionA + HipertensionB + Toxemia + CardiopatiaA + CardiopatiaB + OtraPatologiaA + OtraPatologiaB + EnfermedadRenal + AnemiaSevera)
                                                                                        }
                                                                                    }
                                                                                }
                                                                            },
                                                                            {
                                                                                xtype: 'textfield',
                                                                                fieldLabel: 'Cual',
                                                                                name: 'Cual',
                                                                                anchor: '100%',
                                                                                allowBlank: true,
                                                                                id: 'strOtraPatologiaBCual'
                                                                            }
                                                                        ]
                                                                    }
                                                                ]
                                                            },     
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                width: 400,
                                                                autoHeight: true,
                                                                labelSeparator: '',
                                                                labelStyle: 'color:blue;',
                                                                items: [
                                                                    {
                                                                        xtype: 'panel',
                                                                        layout: 'form',
                                                                        width: 375,
                                                                        autoHeight: true,
                                                                        labelSeparator: '',
                                                                        labelStyle: 'color:blue;',
                                                                        title: 'Antecedentes',
                                                                        items: [
                                                                            {
                                                                                html: '<br>'
                                                                            },
                                                                            {
                                                                                xtype: 'combo',
                                                                                name: 'Abortos',
                                                                                fieldLabel: 'Abortos',
                                                                                width: 250,
                                                                                allowBlank: true,
                                                                                store: stAntecedentes,
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                mode: 'local',
                                                                                forceSelection: true,
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 10,
                                                                                triggerAction: 'all',
                                                                                id: 'intAbortos',
                                                                                listeners:{
                                                                                    change : function(f,pNew, pOld){
                                                                                        if(pNew == "1 o 2"){
                                                                                            Aborto = 2;
                                                                                            Ext.getCmp('intPuntajeTotal').setValue(EdadMujer + Paridad + SocioEconomico + IntervaloEmbarazos + Aborto + Cesarea + Mortinato + Prematuro + HipertensionA + HipertensionB + Toxemia + CardiopatiaA + CardiopatiaB + OtraPatologiaA + OtraPatologiaB + EnfermedadRenal + AnemiaSevera)
                                                                                        }else{
                                                                                            if(pNew == "3 o mas"){
                                                                                                Aborto = 4;
                                                                                                Ext.getCmp('intPuntajeTotal').setValue(EdadMujer + Paridad + SocioEconomico + IntervaloEmbarazos + Aborto + Cesarea + Mortinato + Prematuro + HipertensionA + HipertensionB + Toxemia + CardiopatiaA + CardiopatiaB + OtraPatologiaA + OtraPatologiaB + EnfermedadRenal + AnemiaSevera)
                                                                                            }else{
                                                                                                Aborto = 0;
                                                                                                Ext.getCmp('intPuntajeTotal').setValue(EdadMujer + Paridad + SocioEconomico + IntervaloEmbarazos + Aborto + Cesarea + Mortinato + Prematuro + HipertensionA + HipertensionB + Toxemia + CardiopatiaA + CardiopatiaB + OtraPatologiaA + OtraPatologiaB + EnfermedadRenal + AnemiaSevera)
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            },
                                                                            {
                                                                                html: '<br>'
                                                                            },
                                                                            {
                                                                                xtype: 'combo',
                                                                                name: 'Cesarea',
                                                                                fieldLabel: 'Cesarea',
                                                                                width: 250,
                                                                                allowBlank: true,
                                                                                store: stAntecedentes,
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                mode: 'local',
                                                                                forceSelection: true,
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 10,
                                                                                triggerAction: 'all',
                                                                                id: 'intCesarea',
                                                                                listeners:{
                                                                                    change : function(f,pNew, pOld){
                                                                                        if(pNew == "1 o 2"){
                                                                                            Cesarea = 2;
                                                                                            Ext.getCmp('intPuntajeTotal').setValue(EdadMujer + Paridad + SocioEconomico + IntervaloEmbarazos + Aborto + Cesarea + Mortinato + Prematuro + HipertensionA + HipertensionB + Toxemia + CardiopatiaA + CardiopatiaB + OtraPatologiaA + OtraPatologiaB + EnfermedadRenal + AnemiaSevera)
                                                                                        }else{
                                                                                            if(pNew == "3 o mas"){
                                                                                                Cesarea = 4;
                                                                                                Ext.getCmp('intPuntajeTotal').setValue(EdadMujer + Paridad + SocioEconomico + IntervaloEmbarazos + Aborto + Cesarea + Mortinato + Prematuro + HipertensionA + HipertensionB + Toxemia + CardiopatiaA + CardiopatiaB + OtraPatologiaA + OtraPatologiaB + EnfermedadRenal + AnemiaSevera)
                                                                                            }else{
                                                                                                Cesarea = 0;
                                                                                                Ext.getCmp('intPuntajeTotal').setValue(EdadMujer + Paridad + SocioEconomico + IntervaloEmbarazos + Aborto + Cesarea + Mortinato + Prematuro + HipertensionA + HipertensionB + Toxemia + CardiopatiaA + CardiopatiaB + OtraPatologiaA + OtraPatologiaB + EnfermedadRenal + AnemiaSevera)
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            },
                                                                            {
                                                                                html: '<br>'
                                                                            },
                                                                            {
                                                                                xtype: 'combo',
                                                                                name: 'Mortinato',
                                                                                fieldLabel: 'Mortinato',
                                                                                width: 250,
                                                                                allowBlank: true,
                                                                                store: stAntecedentes,
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                mode: 'local',
                                                                                forceSelection: true,
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 10,
                                                                                triggerAction: 'all',
                                                                                id: 'intMortinato',
                                                                                listeners:{
                                                                                    change : function(f,pNew, pOld){
                                                                                        if(pNew == "1 o 2"){
                                                                                            Mortinato = 2;
                                                                                            Ext.getCmp('intPuntajeTotal').setValue(EdadMujer + Paridad + SocioEconomico + IntervaloEmbarazos + Aborto + Cesarea + Mortinato + Prematuro + HipertensionA + HipertensionB + Toxemia + CardiopatiaA + CardiopatiaB + OtraPatologiaA + OtraPatologiaB + EnfermedadRenal + AnemiaSevera)
                                                                                        }else{
                                                                                            if(pNew == "3 o mas"){
                                                                                                Mortinato = 4;
                                                                                                Ext.getCmp('intPuntajeTotal').setValue(EdadMujer + Paridad + SocioEconomico + IntervaloEmbarazos + Aborto + Cesarea + Mortinato + Prematuro + HipertensionA + HipertensionB + Toxemia + CardiopatiaA + CardiopatiaB + OtraPatologiaA + OtraPatologiaB + EnfermedadRenal + AnemiaSevera)
                                                                                            }else{
                                                                                                Mortinato = 0;
                                                                                                Ext.getCmp('intPuntajeTotal').setValue(EdadMujer + Paridad + SocioEconomico + IntervaloEmbarazos + Aborto + Cesarea + Mortinato + Prematuro + HipertensionA + HipertensionB + Toxemia + CardiopatiaA + CardiopatiaB + OtraPatologiaA + OtraPatologiaB + EnfermedadRenal + AnemiaSevera)
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            },
                                                                            {
                                                                                html: '<br>'
                                                                            },
                                                                            {
                                                                                xtype: 'combo',
                                                                                name: 'Prematuro',
                                                                                fieldLabel: 'Prematuro',
                                                                                width: 250,
                                                                                allowBlank: true,
                                                                                store: stAntecedentes,
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                mode: 'local',
                                                                                forceSelection: true,
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 10,
                                                                                triggerAction: 'all',
                                                                                id: 'intPrematuro',
                                                                                listeners:{
                                                                                    change : function(f,pNew, pOld){
                                                                                        if(pNew == "1 o 2"){
                                                                                            Prematuro = 2;
                                                                                            Ext.getCmp('intPuntajeTotal').setValue(EdadMujer + Paridad + SocioEconomico + IntervaloEmbarazos + Aborto + Cesarea + Mortinato + Prematuro + HipertensionA + HipertensionB + Toxemia + CardiopatiaA + CardiopatiaB + OtraPatologiaA + OtraPatologiaB + EnfermedadRenal + AnemiaSevera)
                                                                                        }else{
                                                                                            if(pNew == "3 o mas"){
                                                                                                Prematuro = 4;
                                                                                                Ext.getCmp('intPuntajeTotal').setValue(EdadMujer + Paridad + SocioEconomico + IntervaloEmbarazos + Aborto + Cesarea + Mortinato + Prematuro + HipertensionA + HipertensionB + Toxemia + CardiopatiaA + CardiopatiaB + OtraPatologiaA + OtraPatologiaB + EnfermedadRenal + AnemiaSevera)
                                                                                            }else{
                                                                                                Prematuro = 0;
                                                                                                Ext.getCmp('intPuntajeTotal').setValue(EdadMujer + Paridad + SocioEconomico + IntervaloEmbarazos + Aborto + Cesarea + Mortinato + Prematuro + HipertensionA + HipertensionB + Toxemia + CardiopatiaA + CardiopatiaB + OtraPatologiaA + OtraPatologiaB + EnfermedadRenal + AnemiaSevera)
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            },
                                                                            {
                                                                                xtype: 'checkbox',
                                                                                fieldLabel: 'Hipertension',
                                                                                name: 'Hipertension',
                                                                                anchor: '100%',
                                                                                value: 'false',
                                                                                id: 'bolHipertension',
                                                                                listeners:{
                                                                                    change : function(f,pNew, pOld){
                                                                                        if(pNew == true){
                                                                                            HipertensionA = 4;
                                                                                            Ext.getCmp('intPuntajeTotal').setValue(EdadMujer + Paridad + SocioEconomico + IntervaloEmbarazos + Aborto + Cesarea + Mortinato + Prematuro + HipertensionA + HipertensionB + Toxemia + CardiopatiaA + CardiopatiaB + OtraPatologiaA + OtraPatologiaB + EnfermedadRenal + AnemiaSevera)
                                                                                        }else{
                                                                                            HipertensionA = 0;
                                                                                            Ext.getCmp('intPuntajeTotal').setValue(EdadMujer + Paridad + SocioEconomico + IntervaloEmbarazos + Aborto + Cesarea + Mortinato + Prematuro + HipertensionA + HipertensionB + Toxemia + CardiopatiaA + CardiopatiaB + OtraPatologiaA + OtraPatologiaB + EnfermedadRenal + AnemiaSevera)
                                                                                        }
                                                                                    }
                                                                                }
                                                                            },
                                                                            {
                                                                                xtype: 'checkbox',
                                                                                fieldLabel: 'Toxemia',
                                                                                name: 'Toxemia',
                                                                                anchor: '100%',
                                                                                value: 'false',
                                                                                id: 'bolToxemia',
                                                                                listeners:{
                                                                                    change : function(f,pNew, pOld){
                                                                                        if(pNew == true){
                                                                                            Toxemia = 4;
                                                                                            Ext.getCmp('intPuntajeTotal').setValue(EdadMujer + Paridad + SocioEconomico + IntervaloEmbarazos + Aborto + Cesarea + Mortinato + Prematuro + HipertensionA + HipertensionB + Toxemia + CardiopatiaA + CardiopatiaB + OtraPatologiaA + OtraPatologiaB + EnfermedadRenal + AnemiaSevera)
                                                                                        }else{
                                                                                            Toxemia = 0;
                                                                                            Ext.getCmp('intPuntajeTotal').setValue(EdadMujer + Paridad + SocioEconomico + IntervaloEmbarazos + Aborto + Cesarea + Mortinato + Prematuro + HipertensionA + HipertensionB + Toxemia + CardiopatiaA + CardiopatiaB + OtraPatologiaA + OtraPatologiaB + EnfermedadRenal + AnemiaSevera)
                                                                                        }
                                                                                    }
                                                                                }
                                                                            },
                                                                            {
                                                                                xtype: 'checkbox',
                                                                                fieldLabel: 'Cardiopatia',
                                                                                name: 'Cardiopatia',
                                                                                anchor: '100%',
                                                                                value: 'false',
                                                                                id: 'bolCardiopatia',
                                                                                listeners:{
                                                                                    change : function(f,pNew, pOld){
                                                                                        if(pNew == true){
                                                                                            CardiopatiaA = 4;
                                                                                            Ext.getCmp('intPuntajeTotal').setValue(EdadMujer + Paridad + SocioEconomico + IntervaloEmbarazos + Aborto + Cesarea + Mortinato + Prematuro + HipertensionA + HipertensionB + Toxemia + CardiopatiaA + CardiopatiaB + OtraPatologiaA + OtraPatologiaB + EnfermedadRenal + AnemiaSevera)
                                                                                        }else{
                                                                                            CardiopatiaA = 0;
                                                                                            Ext.getCmp('intPuntajeTotal').setValue(EdadMujer + Paridad + SocioEconomico + IntervaloEmbarazos + Aborto + Cesarea + Mortinato + Prematuro + HipertensionA + HipertensionB + Toxemia + CardiopatiaA + CardiopatiaB + OtraPatologiaA + OtraPatologiaB + EnfermedadRenal + AnemiaSevera)
                                                                                        }
                                                                                    }
                                                                                }
                                                                            },
                                                                            {
                                                                                xtype: 'checkbox',
                                                                                fieldLabel: 'Otra Patologia',
                                                                                name: 'Otra Patologia',
                                                                                anchor: '100%',
                                                                                value: 'false',
                                                                                id: 'bolOtraPatologia',
                                                                                listeners:{
                                                                                    change : function(f,pNew, pOld){
                                                                                        if(pNew == true){
                                                                                            OtraPatologiaA = 4;
                                                                                            Ext.getCmp('intPuntajeTotal').setValue(EdadMujer + Paridad + SocioEconomico + IntervaloEmbarazos + Aborto + Cesarea + Mortinato + Prematuro + HipertensionA + HipertensionB + Toxemia + CardiopatiaA + CardiopatiaB + OtraPatologiaA + OtraPatologiaB + EnfermedadRenal + AnemiaSevera)
                                                                                        }else{
                                                                                            OtraPatologiaA = 0;
                                                                                            Ext.getCmp('intPuntajeTotal').setValue(EdadMujer + Paridad + SocioEconomico + IntervaloEmbarazos + Aborto + Cesarea + Mortinato + Prematuro + HipertensionA + HipertensionB + Toxemia + CardiopatiaA + CardiopatiaB + OtraPatologiaA + OtraPatologiaB + EnfermedadRenal + AnemiaSevera)
                                                                                        }
                                                                                    }
                                                                                }
                                                                            },
                                                                            {
                                                                                xtype: 'textfield',
                                                                                fieldLabel: 'Cual',
                                                                                name: 'Cual',
                                                                                anchor: '100%',
                                                                                allowBlank: true,
                                                                                id: 'strOtraPatologiaCual'
                                                                            },
                                                                            {
                                                                                html: '<br>'
                                                                            },{
                                                                                html: '<br>'
                                                                            },
                                                                        ]
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                html: '<br><hr><br>'
                                            },
                                            {
                                                xtype: 'numberfield',
                                                name: 'Puntaje Total',
                                                fieldLabel: 'Puntaje Total',
                                                width: 50,
                                                minValue: 0,
                                                decimalPrecision: 0,
                                                allowBlank: true,
                                                value: 0,
                                                id: 'intPuntajeTotal'
                                            },
                                            {
                                                html: '<br><hr><br>'
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'EVOLUCION',
                                                layout: 'table',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'EVOLUCION',
                                                        name: 'EVOLUCION',
                                                        height: 100,
                                                        allowBlank: false,
                                                        id: 'memEvolucion'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'RIPS',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: false,
                                                                fieldLabel: 'Diagnostico Principal',
                                                                id: 'sysDiagPpalHC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request({
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                        Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    },
                                                                    blur: function(t){
                                                                        if(Ext.getCmp('sysDiagPpalHCNom').getValue()==null || Ext.getCmp('sysDiagPpalHCNom').getValue()== "")
                                                                        {
                                                                            if (Ext.getCmp('sysDiagPpalHC').getValue() != "" && Ext.getCmp('sysDiagPpalHC').getValue() != null && Ext.getCmp('sysDiagPpalHC').getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && Ext.getCmp('sysDiagPpalHC').getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && Ext.getCmp('sysDiagPpalHC').getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request({
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: Ext.getCmp('sysDiagPpalHC').getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                        Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagPpalHCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Principal',
                                                                id: 'btnSearchDiagPpalHC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagPpalHC','sysDiagPpalHCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.1',
                                                                id: 'sysDiagRel1HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    },
                                                                    blur: function(t){
                                                                        if (Ext.getCmp('sysDiagRel1HCNom').getValue == null ||  Ext.getCmp('sysDiagRel1HCNom').getValue() == "")
                                                                        {
                                                                            if (Ext.getCmp('sysDiagRel1HC').getValue() != "" && Ext.getCmp('sysDiagRel1HC').getValue() != null && Ext.getCmp('sysDiagRel1HC').getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && Ext.getCmp('sysDiagRel1HC').getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && Ext.getCmp('sysDiagRel1HC').getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: Ext.getCmp('sysDiagRel1HC').getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel1HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado1',
                                                                id: 'btnSearchDiagRel1HC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel1HC','sysDiagRel1HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.2',
                                                                id: 'sysDiagRel2HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    },
                                                                    blur: function(t){
                                                                        if (Ext.getCmp('sysDiagRel2HCNom').getValue == null || Ext.getCmp('sysDiagRel2HCNom').getValue() == "")
                                                                        {
                                                                            if (Ext.getCmp('sysDiagRel2HC').getValue() != "" && Ext.getCmp('sysDiagRel2HC').getValue() != null && Ext.getCmp('sysDiagRel2HC').getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && Ext.getCmp('sysDiagRel2HC').getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && Ext.getCmp('sysDiagRel2HC').getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: Ext.getCmp('sysDiagRel2HC').getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel2HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado2',
                                                                id: 'btnSearchDiagRel2HC1',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel2HC','sysDiagRel2HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.3',
                                                                id: 'sysDiagRel3HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    },
                                                                    blur: function(t){
                                                                        if (Ext.getCmp('sysDiagRel3HCNom').getValue == null || Ext.getCmp('sysDiagRel3HCNom').getValue() == "")
                                                                        {
                                                                            if (Ext.getCmp('sysDiagRel3HC').getValue() != "" && Ext.getCmp('sysDiagRel3HC').getValue() != null && Ext.getCmp('sysDiagRel3HC').getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && Ext.getCmp('sysDiagRel3HC').getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && Ext.getCmp('sysDiagRel3HC').getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: Ext.getCmp('sysDiagRel3HC').getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel3HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado3',
                                                                id: 'btnSearchDiagRel3HC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel3HC','sysDiagRel3HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Tipo de Diagnostico',
                                                        width:750,
                                                        name: 'Tipo de Diagnostico',
                                                        allowBlank: false,
                                                        store: 'StoreTipoDiagnostico',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        id: 'sysTipoDiagosticoHC'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Finalidad Consulta',
                                                        width:750,
                                                        name: 'Finalidad Consulta',
                                                        allowBlank: false,
                                                        store: 'StoreFinalidadConsulta',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 10,
                                                        id: 'sysFinalidadConsultaHC'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Causa Externa',
                                                        width:750,
                                                        name: 'Causa Externa',
                                                        allowBlank: false,
                                                        store: 'StoreCausaExterna',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 13,
                                                        id: 'sysCausaExternaHC'
                                                    }
                                                ]
                                            }
                                        ]
                                    }
                                ]
                            }/*,
                            {
                                xtype: 'panel',
                                title: 'Solicitud Medicamentos',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaMedicamentos',
                                items: [
                                    xSolMX
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Servicios',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaServicios',
                                items: [
                                    xSolEXA
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Remisiones',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaRemisiones',
                                items: [
                                    xSolREM
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud CTC',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaCTC',
                                items: [
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Consentimientos Informados',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaConsentimientos',
                                items: [
                                ]
                            },*/
                        ]
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btnSalirEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 1)
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Usted No ha Guardado la Evolución del Paciente y Se Perdera la Información, Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                },
                tbar:{
                    items: [
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Ver Historia Clínica',
                            iconCls: 'btnVerHC',
                            id: 'btnVerHC',
                            listeners:{
                                click : function(){
                                    var cmpResumenHC = new winFrmVerHistorialHC({
                                        renderTo: Ext.getBody()
                                    });
                                    Ext.getCmp('winViewEvolucionHC').title = "PACIENTE: " + Ext.getCmp('sysPacienteHC').getValue();
                                    Ext.getCmp('gridHistorialEvoluciones').store.load({
                                        params: {
                                            pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                                            pPaciente: Ext.getCmp('sysIdPacienteHC').getValue()
                                        }
                                    });
                                    cmpResumenHC.show();
                                }
                            }
                        },
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar Evolución',
                            iconCls: 'btnGuardar',
                            id: 'btnGuardarEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 0)
                                    {
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Guardar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnGuardarRegistrosMedicinaGeneral();
                                                }
                                            }
                                        });
                                    }else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Modificar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnModificarRegistrosMedicinaGeneral();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                }
            }
        ];
        winHCRiesgoReproductivoUi.superclass.initComponent.call(this);
    }
});

function fnGuardarRegistrosMedicinaGeneral(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc.php',
            params:{
                task: 'guardar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pidPlantillaHC : Ext.getCmp('sysIdCodPlantillaHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function fnModificarRegistrosMedicinaGeneral(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc.php',
            params:{
                task: 'modificar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}
