/*
* @category    Formulario Modelo Evolucion Historia Clinica Fisioterapia Evolucion
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winHCFisioterapia001Ui = Ext.extend(Ext.Window, {
    title: 'eOfiClinic ©  .:: Plantilla HC - Evolucion Fisioterapia ::.',
    width: 990,
    height: 636,
    closable: false,
    resizable: false,
    draggable: false,
    modal: true,
    id: 'winHC',
    initComponent: function() {

    var dataFinTratamiento = [
        ['SI'],
        ['NO'],
        ['ABANDONO']
    ];
    var stFinTratamiento = new Ext.data.ArrayStore({
        fields: [
            {name: 'Descripcion'}
        ]
    });
    stFinTratamiento.loadData(dataFinTratamiento);
             
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmHC',
                padding: 10,
                border: false,
                height: 610,
                autoScroll: true,
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysIdCodPlantillaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Actividad',
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        value: 0,
                        id: 'sysYaGuardoHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysPlantillaHC',
                        name: 'PLANTILLA'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptMx'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptExa'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptRem'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Actividad',
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        id: 'sysActividadHC',
                        name: 'PLANTILLA'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Empresa',
                        id: 'sysEmpresaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'IPS',
                        id: 'sysIPSHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Usuario',
                        id: 'sysUsuarioHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Profesional',
                        id: 'sysProfesionalHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Paciente',
                        id: 'sysIdPacienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Apertura',
                        id: 'sysAperturaHC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Cliente',
                        id: 'sysClienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdClienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdPlanHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdSubPlanHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdContratoHC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'CAS',
                        id: 'sysCASHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'ConsecutivoDetalle',
                        id: 'sysConsecutivoDetalleHC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Profesional',
                        id: 'sysProfesionalAgendaHC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Fecha',
                        id: 'sysFechaHC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Hora',
                        id: 'sysHoraHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Hora',
                        id: 'sysLegalizaHC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Paciente',
                        id: 'sysPacienteHC'
                    },
                    {
                        html: '<hr>',
                        style: 'background:transparent;',
                        border: false
                    },
                    {
                        xtype: 'numberfield',
                        fieldLabel: 'Nro Sesion',
                        name: 'Nro Sesion',
                        width: 90,
                        allowBlank: true,
                        minValue: 1,
                        maxValue: 30,
                        id: 'intNroSesion'
                    },
                    {
                        xtype: 'timefield',
                        fieldLabel: 'Hora Inicio',
                        name: 'Hora Inicio',
                        width: 90,
                        allowBlank: true,
                        forceSelection: false,
                        minValue: '6:00 AM',
                        maxValue: '9:00 PM',
                        emptyText: 'p.e. 07:00',
                        //format:'H:i',
                        id: 'strHoraInicio'
                    },
                    {
                        xtype: 'textfield',
                        name: 'OCUPACION',
                        fieldLabel: 'OCUPACION',
                        width: 650,
                        allowBlank: true,
                        id: 'strOcupacion'
                    },
                    {
                        xtype: 'fieldset',
                        title: 'I. TERMOTERAPIA',
                        labelWidth: 210,
                        layout: 'form',
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        anchor: '100%',
                        autoHeight: true,
                        items: [
                            {
                                xtype: 'numberfield',
                                fieldLabel: 'Tiempo',
                                name: 'Tiempo',
                                width: 90,
                                allowBlank: true,
                                minValue: 0,
                                maxValue: 720,
                                emptyText: 'mm',
                                id: 'intTERMOTERAPIA_Tiempo'
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 70,
                                        fieldLabel: 'Parafina',
                                        name: 'Parafina',
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        value: "NO",
                                        id: 'strTERMOTERAPIA_Parafina',
                                        listeners:{
                                            select : function(cmb, rec, idx){
                                                if(cmb.getValue() == "NO"){
                                                    Ext.getCmp('intTERMOTERAPIA_ParafinaTiempo').allowBlank = true;
                                                    Ext.getCmp('intTERMOTERAPIA_ParafinaTiempo').setValue(null);
                                                    Ext.getCmp('intTERMOTERAPIA_ParafinaTiempo').disable();
                                                    Ext.getCmp('intTERMOTERAPIA_ParafinaTiempo').clearInvalid();
                                                }else{
                                                    Ext.getCmp('intTERMOTERAPIA_ParafinaTiempo').enable();
                                                    Ext.getCmp('intTERMOTERAPIA_ParafinaTiempo').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Tiempo',
                                        width: 90,
                                        allowBlank: true,
                                        disabled: true,
                                        minValue: 0,
                                        maxValue: 720,
                                        emptyText: 'mim',
                                        id: 'intTERMOTERAPIA_ParafinaTiempo'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 70,
                                        fieldLabel: 'Calor Humedo',
                                        name: 'Calor Humedo',
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        value: "NO",
                                        id: 'strTERMOTERAPIA_CalorHumedo',
                                        listeners:{
                                            select : function(cmb, rec, idx){
                                                if(cmb.getValue() == "NO"){
                                                    Ext.getCmp('intTERMOTERAPIA_CalorHumedoTiempo').allowBlank = true;
                                                    Ext.getCmp('intTERMOTERAPIA_CalorHumedoTiempo').setValue(null);
                                                    Ext.getCmp('intTERMOTERAPIA_CalorHumedoTiempo').disable();
                                                    Ext.getCmp('intTERMOTERAPIA_CalorHumedoTiempo').clearInvalid();
                                                }else{
                                                    Ext.getCmp('intTERMOTERAPIA_CalorHumedoTiempo').enable();
                                                    Ext.getCmp('intTERMOTERAPIA_CalorHumedoTiempo').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Tiempo',
                                        width: 90,
                                        allowBlank: true,
                                        disabled: true,
                                        minValue: 0,
                                        maxValue: 720,
                                        emptyText: 'min',
                                        id: 'intTERMOTERAPIA_CalorHumedoTiempo'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 70,
                                        fieldLabel: 'Infrarrojo',
                                        name: 'Infrarrojo',
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        value: "NO",
                                        id: 'strTERMOTERAPIA_Infrarojo',
                                        listeners:{
                                            select : function(cmb, rec, idx){
                                                if(cmb.getValue() == "NO"){
                                                    Ext.getCmp('intTERMOTERAPIA_InfrarojoTiempo').allowBlank = true;
                                                    Ext.getCmp('intTERMOTERAPIA_InfrarojoTiempo').setValue(null);
                                                    Ext.getCmp('intTERMOTERAPIA_InfrarojoTiempo').disable();
                                                    Ext.getCmp('intTERMOTERAPIA_InfrarojoTiempo').clearInvalid();
                                                }else{
                                                    Ext.getCmp('intTERMOTERAPIA_InfrarojoTiempo').enable();
                                                    Ext.getCmp('intTERMOTERAPIA_InfrarojoTiempo').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Tiempo',
                                        width: 90,
                                        allowBlank: true,
                                        disabled: true,
                                        minValue: 0,
                                        maxValue: 720,
                                        emptyText: 'min',
                                        id: 'intTERMOTERAPIA_InfrarojoTiempo'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 70,
                                        fieldLabel: 'Crioterapia',
                                        name: 'Crioterapia',
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        value: "NO",
                                        id: 'strTERMOTERAPIA_Crioterapia',
                                        listeners:{
                                            select : function(cmb, rec, idx){
                                                if(cmb.getValue() == "NO"){
                                                    Ext.getCmp('intTERMOTERAPIA_CrioterapiaTiempo').allowBlank = true;
                                                    Ext.getCmp('intTERMOTERAPIA_CrioterapiaTiempo').setValue(null);
                                                    Ext.getCmp('intTERMOTERAPIA_CrioterapiaTiempo').disable();
                                                    Ext.getCmp('intTERMOTERAPIA_CrioterapiaTiempo').clearInvalid();
                                                }else{
                                                    Ext.getCmp('intTERMOTERAPIA_CrioterapiaTiempo').enable();
                                                    Ext.getCmp('intTERMOTERAPIA_CrioterapiaTiempo').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Tiempo',
                                        width: 90,
                                        allowBlank: true,
                                        disabled: true,
                                        minValue: 0,
                                        maxValue: 720,
                                        emptyText: 'min',
                                        id: 'intTERMOTERAPIA_CrioterapiaTiempo'
                                    }
                                ]
                            },
                            {
                                xtype: 'textarea',
                                width: 650,
                                fieldLabel: 'Observaciones',
                                name: 'Observaciones',
                                height: 100,            
                                allowBlank: true,
                                id: 'memObservacionesTermoterapia'
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: 'II. HIDROTERAPIA',
                        labelWidth: 210,
                        layout: 'form',
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        anchor: '100%',
                        autoHeight: true,
                        items: [
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 70,
                                        fieldLabel: 'Tanque Remolinos',
                                        name: 'Tanque Remolinos',
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        value: "NO",
                                        id: 'strHIDROTERAPIA_TanqueRemolinos',
                                        listeners:{
                                            select : function(cmb, rec, idx){
                                                if(cmb.getValue() == "NO"){
                                                    Ext.getCmp('intHIDROTERAPIA_TanqueRemolinosTiempo').allowBlank = true;
                                                    Ext.getCmp('intHIDROTERAPIA_TanqueRemolinosTiempo').setValue(null);
                                                    Ext.getCmp('intHIDROTERAPIA_TanqueRemolinosTiempo').disable();
                                                    Ext.getCmp('intHIDROTERAPIA_TanqueRemolinosTiempo').clearInvalid();
                                                }else{
                                                    Ext.getCmp('intHIDROTERAPIA_TanqueRemolinosTiempo').enable();
                                                    Ext.getCmp('intHIDROTERAPIA_TanqueRemolinosTiempo').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Tiempo',
                                        width: 90,
                                        allowBlank: true,
                                        disabled: true,
                                        minValue: 0,
                                        maxValue: 720,
                                        emptyText: 'mim',
                                        id: 'intHIDROTERAPIA_TanqueRemolinosTiempo'
                                    }
                                ]
                            },
                            {
                                xtype: 'textarea',
                                width: 650,
                                fieldLabel: 'Observaciones',
                                name: 'Observaciones',
                                height: 100,            
                                allowBlank: true,
                                id: 'memObservacionesHidroterapia'
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: 'III. ELECTROTERAPIA',
                        labelWidth: 210,
                        layout: 'form',
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        anchor: '100%',
                        autoHeight: true,
                        items: [
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 70,
                                        fieldLabel: 'TENS',
                                        name: 'TENS',
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        value: "NO",
                                        id: 'strELECTROTERAPIA_TENS',
                                        listeners:{
                                            select : function(cmb, rec, idx){
                                                if(cmb.getValue() == "NO"){
                                                    Ext.getCmp('intELECTROTERAPIA_TENSTiempo').allowBlank = true;
                                                    Ext.getCmp('intELECTROTERAPIA_TENSTiempo').setValue(null);
                                                    Ext.getCmp('intELECTROTERAPIA_TENSTiempo').disable();
                                                    Ext.getCmp('intELECTROTERAPIA_TENSTiempo').clearInvalid();
                                                }else{
                                                    Ext.getCmp('intELECTROTERAPIA_TENSTiempo').enable();
                                                    Ext.getCmp('intELECTROTERAPIA_TENSTiempo').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Tiempo',
                                        width: 90,
                                        allowBlank: true,
                                        disabled: true,
                                        minValue: 0,
                                        maxValue: 720,
                                        emptyText: 'mim',
                                        id: 'intELECTROTERAPIA_TENSTiempo'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 70,
                                        fieldLabel: 'EMS',
                                        name: 'EMS',
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        value: "NO",
                                        id: 'strELECTROTERAPIA_EMS',
                                        listeners:{
                                            select : function(cmb, rec, idx){
                                                if(cmb.getValue() == "NO"){
                                                    Ext.getCmp('intELECTROTERAPIA_EMSTiempo').allowBlank = true;
                                                    Ext.getCmp('intELECTROTERAPIA_EMSTiempo').setValue(null);
                                                    Ext.getCmp('intELECTROTERAPIA_EMSTiempo').disable();
                                                    Ext.getCmp('intELECTROTERAPIA_EMSTiempo').clearInvalid();
                                                }else{
                                                    Ext.getCmp('intELECTROTERAPIA_EMSTiempo').enable();
                                                    Ext.getCmp('intELECTROTERAPIA_EMSTiempo').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Tiempo',
                                        width: 90,
                                        allowBlank: true,
                                        disabled: true,
                                        minValue: 0,
                                        maxValue: 720,
                                        emptyText: 'mim',
                                        id: 'intELECTROTERAPIA_EMSTiempo'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 70,
                                        fieldLabel: 'IFC',
                                        name: 'IFC',
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        value: "NO",
                                        id: 'strELECTROTERAPIA_IFC',
                                        listeners:{
                                            select : function(cmb, rec, idx){
                                                if(cmb.getValue() == "NO"){
                                                    Ext.getCmp('intELECTROTERAPIA_IFCTiempo').allowBlank = true;
                                                    Ext.getCmp('intELECTROTERAPIA_IFCTiempo').setValue(null);
                                                    Ext.getCmp('intELECTROTERAPIA_IFCTiempo').disable();
                                                    Ext.getCmp('intELECTROTERAPIA_IFCTiempo').clearInvalid();
                                                }else{
                                                    Ext.getCmp('intELECTROTERAPIA_IFCTiempo').enable();
                                                    Ext.getCmp('intELECTROTERAPIA_IFCTiempo').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Tiempo',
                                        width: 90,
                                        allowBlank: true,
                                        disabled: true,
                                        minValue: 0,
                                        maxValue: 720,
                                        emptyText: 'mim',
                                        id: 'intELECTROTERAPIA_IFCTiempo'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 70,
                                        fieldLabel: 'Premodulada',
                                        name: 'Premodulada',
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        value: "NO",
                                        id: 'strELECTROTERAPIA_Premodulada',
                                        listeners:{
                                            select : function(cmb, rec, idx){
                                                if(cmb.getValue() == "NO"){
                                                    Ext.getCmp('intELECTROTERAPIA_PremoduladaTiempo').allowBlank = true;
                                                    Ext.getCmp('intELECTROTERAPIA_PremoduladaTiempo').setValue(null);
                                                    Ext.getCmp('intELECTROTERAPIA_PremoduladaTiempo').disable();
                                                    Ext.getCmp('intELECTROTERAPIA_PremoduladaTiempo').clearInvalid();
                                                }else{
                                                    Ext.getCmp('intELECTROTERAPIA_PremoduladaTiempo').enable();
                                                    Ext.getCmp('intELECTROTERAPIA_PremoduladaTiempo').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Tiempo',
                                        width: 90,
                                        allowBlank: true,
                                        disabled: true,
                                        minValue: 0,
                                        maxValue: 720,
                                        emptyText: 'mim',
                                        id: 'intELECTROTERAPIA_PremoduladaTiempo'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 70,
                                        fieldLabel: 'RUSA',
                                        name: 'RUSA',
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        value: "NO",
                                        id: 'strELECTROTERAPIA_RUSA',
                                        listeners:{
                                            select : function(cmb, rec, idx){
                                                if(cmb.getValue() == "NO"){
                                                    Ext.getCmp('intELECTROTERAPIA_RUSATiempo').allowBlank = true;
                                                    Ext.getCmp('intELECTROTERAPIA_RUSATiempo').setValue(null);
                                                    Ext.getCmp('intELECTROTERAPIA_RUSATiempo').disable();
                                                    Ext.getCmp('intELECTROTERAPIA_RUSATiempo').clearInvalid();
                                                }else{
                                                    Ext.getCmp('intELECTROTERAPIA_RUSATiempo').enable();
                                                    Ext.getCmp('intELECTROTERAPIA_RUSATiempo').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Tiempo',
                                        width: 90,
                                        allowBlank: true,
                                        disabled: true,
                                        minValue: 0,
                                        maxValue: 720,
                                        emptyText: 'mim',
                                        id: 'intELECTROTERAPIA_RUSATiempo'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 70,
                                        fieldLabel: 'VMS',
                                        name: 'VMS',
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        value: "NO",
                                        id: 'strELECTROTERAPIA_VMS',
                                        listeners:{
                                            select : function(cmb, rec, idx){
                                                if(cmb.getValue() == "NO"){
                                                    Ext.getCmp('intELECTROTERAPIA_VMSTiempo').allowBlank = true;
                                                    Ext.getCmp('intELECTROTERAPIA_VMSTiempo').setValue(null);
                                                    Ext.getCmp('intELECTROTERAPIA_VMSTiempo').disable();
                                                    Ext.getCmp('intELECTROTERAPIA_VMSTiempo').clearInvalid();
                                                }else{
                                                    Ext.getCmp('intELECTROTERAPIA_VMSTiempo').enable();
                                                    Ext.getCmp('intELECTROTERAPIA_VMSTiempo').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Tiempo',
                                        width: 90,
                                        allowBlank: true,
                                        disabled: true,
                                        minValue: 0,
                                        maxValue: 720,
                                        emptyText: 'mim',
                                        id: 'intELECTROTERAPIA_VMSTiempo'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 70,
                                        fieldLabel: 'Microcorrientes',
                                        name: 'Microcorrientes',
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        value: "NO",
                                        id: 'strELECTROTERAPIA_Microcorrientes',
                                        listeners:{
                                            select : function(cmb, rec, idx){
                                                if(cmb.getValue() == "NO"){
                                                    Ext.getCmp('intELECTROTERAPIA_MicrocorrientesTiempo').allowBlank = true;
                                                    Ext.getCmp('intELECTROTERAPIA_MicrocorrientesTiempo').setValue(null);
                                                    Ext.getCmp('intELECTROTERAPIA_MicrocorrientesTiempo').disable();
                                                    Ext.getCmp('intELECTROTERAPIA_MicrocorrientesTiempo').clearInvalid();
                                                }else{
                                                    Ext.getCmp('intELECTROTERAPIA_MicrocorrientesTiempo').enable();
                                                    Ext.getCmp('intELECTROTERAPIA_MicrocorrientesTiempo').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Tiempo',
                                        width: 90,
                                        allowBlank: true,
                                        disabled: true,
                                        minValue: 0,
                                        maxValue: 720,
                                        emptyText: 'mim',
                                        id: 'intELECTROTERAPIA_MicrocorrientesTiempo'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 70,
                                        fieldLabel: 'Alto Voltaje',
                                        name: 'Alto Voltaje',
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        value: "NO",
                                        id: 'strELECTROTERAPIA_AltoVoltaje',
                                        listeners:{
                                            select : function(cmb, rec, idx){
                                                if(cmb.getValue() == "NO"){
                                                    Ext.getCmp('intELECTROTERAPIA_AltoVoltajeTiempo').allowBlank = true;
                                                    Ext.getCmp('intELECTROTERAPIA_AltoVoltajeTiempo').setValue(null);
                                                    Ext.getCmp('intELECTROTERAPIA_AltoVoltajeTiempo').disable();
                                                    Ext.getCmp('intELECTROTERAPIA_AltoVoltajeTiempo').clearInvalid();
                                                }else{
                                                    Ext.getCmp('intELECTROTERAPIA_AltoVoltajeTiempo').enable();
                                                    Ext.getCmp('intELECTROTERAPIA_AltoVoltajeTiempo').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Tiempo',
                                        width: 90,
                                        allowBlank: true,
                                        disabled: true,
                                        minValue: 0,
                                        maxValue: 720,
                                        emptyText: 'mim',
                                        id: 'intELECTROTERAPIA_AltoVoltajeTiempo'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 70,
                                        fieldLabel: 'TENS Clinico',
                                        name: 'TENS Clinico',
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        value: "NO",
                                        id: 'strELECTROTERAPIA_TENSClinico',
                                        listeners:{
                                            select : function(cmb, rec, idx){
                                                if(cmb.getValue() == "NO"){
                                                    Ext.getCmp('intELECTROTERAPIA_TENSClinicoTiempo').allowBlank = true;
                                                    Ext.getCmp('intELECTROTERAPIA_TENSClinicoTiempo').setValue(null);
                                                    Ext.getCmp('intELECTROTERAPIA_TENSClinicoTiempo').disable();
                                                    Ext.getCmp('intELECTROTERAPIA_TENSClinicoTiempo').clearInvalid();
                                                }else{
                                                    Ext.getCmp('intELECTROTERAPIA_TENSClinicoTiempo').enable();
                                                    Ext.getCmp('intELECTROTERAPIA_TENSClinicoTiempo').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Tiempo',
                                        width: 90,
                                        allowBlank: true,
                                        disabled: true,
                                        minValue: 0,
                                        maxValue: 720,
                                        emptyText: 'mim',
                                        id: 'intELECTROTERAPIA_TENSClinicoTiempo'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 70,
                                        fieldLabel: 'Corriente Directa Interrumpida',
                                        name: 'Corriente Directa Interrumpida',
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        value: "NO",
                                        id: 'strELECTROTERAPIA_CteDirectaInterrumpida',
                                        listeners:{
                                            select : function(cmb, rec, idx){
                                                if(cmb.getValue() == "NO"){
                                                    Ext.getCmp('intELECTROTERAPIA_CteDirectaInterrumpidaTiempo').allowBlank = true;
                                                    Ext.getCmp('intELECTROTERAPIA_CteDirectaInterrumpidaTiempo').setValue(null);
                                                    Ext.getCmp('intELECTROTERAPIA_CteDirectaInterrumpidaTiempo').disable();
                                                    Ext.getCmp('intELECTROTERAPIA_CteDirectaInterrumpidaTiempo').clearInvalid();
                                                }else{
                                                    Ext.getCmp('intELECTROTERAPIA_CteDirectaInterrumpidaTiempo').enable();
                                                    Ext.getCmp('intELECTROTERAPIA_CteDirectaInterrumpidaTiempo').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Tiempo',
                                        width: 90,
                                        allowBlank: true,
                                        disabled: true,
                                        minValue: 0,
                                        maxValue: 720,
                                        emptyText: 'mim',
                                        id: 'intELECTROTERAPIA_CteDirectaInterrumpidaTiempo'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 70,
                                        fieldLabel: 'Corriente Directa Continua',
                                        name: 'Corriente Directa Continua',
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        value: "NO",
                                        id: 'strELECTROTERAPIA_CteDirectaContinua',
                                        listeners:{
                                            select : function(cmb, rec, idx){
                                                if(cmb.getValue() == "NO"){
                                                    Ext.getCmp('intELECTROTERAPIA_CteDirectaContinuaTiempo').allowBlank = true;
                                                    Ext.getCmp('intELECTROTERAPIA_CteDirectaContinuaTiempo').setValue(null);
                                                    Ext.getCmp('intELECTROTERAPIA_CteDirectaContinuaTiempo').disable();
                                                    Ext.getCmp('intELECTROTERAPIA_CteDirectaContinuaTiempo').clearInvalid();
                                                }else{
                                                    Ext.getCmp('intELECTROTERAPIA_CteDirectaContinuaTiempo').enable();
                                                    Ext.getCmp('intELECTROTERAPIA_CteDirectaContinuaTiempo').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Tiempo',
                                        width: 90,
                                        allowBlank: true,
                                        disabled: true,
                                        minValue: 0,
                                        maxValue: 720,
                                        emptyText: 'mim',
                                        id: 'intELECTROTERAPIA_CteDirectaContinuaTiempo'
                                    }
                                ]
                            },
                            {
                                xtype: 'textarea',
                                width: 650,
                                fieldLabel: 'Observaciones',
                                name: 'Observaciones',
                                height: 100,            
                                allowBlank: true,
                                id: 'memObservacionesElectroterapia'
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: 'IV. ULTRASONIDO',
                        labelWidth: 210,
                        layout: 'form',
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        anchor: '100%',
                        autoHeight: true,
                        items: [
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 70,
                                        fieldLabel: 'Pulsado',
                                        name: 'Pulsado',
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        value: "NO",
                                        id: 'strULTRASONIDO_Pulsado',
                                        listeners:{
                                            select : function(cmb, rec, idx){
                                                if(cmb.getValue() == "NO"){
                                                    Ext.getCmp('intULTRASONIDO_PulsadoTiempo').allowBlank = true;
                                                    Ext.getCmp('intULTRASONIDO_PulsadoTiempo').setValue(null);
                                                    Ext.getCmp('intULTRASONIDO_PulsadoTiempo').disable();
                                                    Ext.getCmp('intULTRASONIDO_PulsadoTiempo').clearInvalid();
                                                }else{
                                                    Ext.getCmp('intULTRASONIDO_PulsadoTiempo').enable();
                                                    Ext.getCmp('intULTRASONIDO_PulsadoTiempo').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Tiempo',
                                        width: 90,
                                        allowBlank: true,
                                        disabled: true,
                                        minValue: 0,
                                        maxValue: 720,
                                        emptyText: 'mim',
                                        id: 'intULTRASONIDO_PulsadoTiempo'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 70,
                                        fieldLabel: 'Continuo',
                                        name: 'Continuo',
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        value: "NO",
                                        id: 'strULTRASONIDO_Continuo',
                                        listeners:{
                                            select : function(cmb, rec, idx){
                                                if(cmb.getValue() == "NO"){
                                                    Ext.getCmp('intULTRASONIDO_ContinuoTiempo').allowBlank = true;
                                                    Ext.getCmp('intULTRASONIDO_ContinuoTiempo').setValue(null);
                                                    Ext.getCmp('intULTRASONIDO_ContinuoTiempo').disable();
                                                    Ext.getCmp('intULTRASONIDO_ContinuoTiempo').clearInvalid();
                                                }else{
                                                    Ext.getCmp('intULTRASONIDO_ContinuoTiempo').enable();
                                                    Ext.getCmp('intULTRASONIDO_ContinuoTiempo').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Tiempo',
                                        width: 90,
                                        allowBlank: true,
                                        disabled: true,
                                        minValue: 0,
                                        maxValue: 720,
                                        emptyText: 'mim',
                                        id: 'intULTRASONIDO_ContinuoTiempo'
                                    }
                                ]
                            },
                            {
                                xtype: 'textarea',
                                width: 650,
                                fieldLabel: 'Observaciones',
                                name: 'Observaciones',
                                height: 100,            
                                allowBlank: true,
                                id: 'memObservacionesUltrasonido'
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        labelWidth: 210,
                        title: 'V. TRACCION',
                        layout: 'form',
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        anchor: '100%',
                        autoHeight: true,
                        items: [
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 70,
                                        fieldLabel: 'Cervical',
                                        name: 'Cervical',
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        value: "NO",
                                        id: 'strTRACCION_Cervical',
                                        listeners:{
                                            select : function(cmb, rec, idx){
                                                if(cmb.getValue() == "NO"){
                                                    Ext.getCmp('intTRACCION_CervicalTiempo').allowBlank = true;
                                                    Ext.getCmp('intTRACCION_CervicalTiempo').setValue(null);
                                                    Ext.getCmp('intTRACCION_CervicalTiempo').disable();
                                                    Ext.getCmp('intTRACCION_CervicalTiempo').clearInvalid();
                                                }else{
                                                    Ext.getCmp('intTRACCION_CervicalTiempo').enable();
                                                    Ext.getCmp('intTRACCION_CervicalTiempo').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Tiempo',
                                        width: 90,
                                        allowBlank: true,
                                        disabled: true,
                                        minValue: 0,
                                        maxValue: 720,
                                        emptyText: 'mim',
                                        id: 'intTRACCION_CervicalTiempo'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 70,
                                        fieldLabel: 'Lumbar',
                                        name: 'Lumbar',
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        value: "NO",
                                        id: 'strTRACCION_Lumbar',
                                        listeners:{
                                            select : function(cmb, rec, idx){
                                                if(cmb.getValue() == "NO"){
                                                    Ext.getCmp('intTRACCION_LumbarTiempo').allowBlank = true;
                                                    Ext.getCmp('intTRACCION_LumbarTiempo').setValue(null);
                                                    Ext.getCmp('intTRACCION_LumbarTiempo').disable();
                                                    Ext.getCmp('intTRACCION_LumbarTiempo').clearInvalid();
                                                }else{
                                                    Ext.getCmp('intTRACCION_LumbarTiempo').enable();
                                                    Ext.getCmp('intTRACCION_LumbarTiempo').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Tiempo',
                                        width: 90,
                                        allowBlank: true,
                                        disabled: true,
                                        minValue: 0,
                                        maxValue: 720,
                                        emptyText: 'mim',
                                        id: 'intTRACCION_LumbarTiempo'
                                    }
                                ]
                            },
                            {
                                xtype: 'textarea',
                                width: 650,
                                fieldLabel: 'Observaciones',
                                name: 'Observaciones',
                                height: 100,            
                                allowBlank: true,
                                id: 'memObservacionesTraccion'
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        labelWidth: 210,
                        title: 'VI. BANDA SIN FIN',
                        layout: 'form',
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        anchor: '100%',
                        autoHeight: true,
                        items: [
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 70,
                                        fieldLabel: 'Banda Sin Fin',
                                        name: 'Banda Sin Fin',
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        value: "NO",
                                        id: 'strBSINFIN_BandaSinFin',
                                        listeners:{
                                            select : function(cmb, rec, idx){
                                                if(cmb.getValue() == "NO"){
                                                    Ext.getCmp('intBSINFIN_BandaSinFinTiempo').allowBlank = true;
                                                    Ext.getCmp('intBSINFIN_BandaSinFinTiempo').setValue(null);
                                                    Ext.getCmp('intBSINFIN_BandaSinFinTiempo').disable();
                                                    Ext.getCmp('intBSINFIN_BandaSinFinTiempo').clearInvalid();
                                                }else{
                                                    Ext.getCmp('intBSINFIN_BandaSinFinTiempo').enable();
                                                    Ext.getCmp('intBSINFIN_BandaSinFinTiempo').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Tiempo',
                                        width: 90,
                                        allowBlank: true,
                                        disabled: true,
                                        minValue: 0,
                                        maxValue: 720,
                                        emptyText: 'mim',
                                        id: 'intBSINFIN_BandaSinFinTiempo'
                                    }
                                ]
                            },
                            {
                                xtype: 'textarea',
                                width: 650,
                                fieldLabel: 'Observaciones',
                                name: 'Observaciones',
                                height: 100,            
                                allowBlank: true,
                                id: 'memObservacionesBandasinFin'
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: 'VII. BICICLETA ESTATICA',
                        labelWidth: 210,
                        layout: 'form',
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        anchor: '100%',
                        autoHeight: true,
                        items: [
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 70,
                                        fieldLabel: 'Bicicleta Estatica',
                                        name: 'Bicicleta Estatica',
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        value: "NO",
                                        id: 'strBESTATICA_BicicletaEstatica',
                                        listeners:{
                                            select : function(cmb, rec, idx){
                                                if(cmb.getValue() == "NO"){
                                                    Ext.getCmp('intBESTATICA_BicicletaEstaticaTiempo').allowBlank = true;
                                                    Ext.getCmp('intBESTATICA_BicicletaEstaticaTiempo').setValue(null);
                                                    Ext.getCmp('intBESTATICA_BicicletaEstaticaTiempo').disable();
                                                    Ext.getCmp('intBESTATICA_BicicletaEstaticaTiempo').clearInvalid();
                                                }else{
                                                    Ext.getCmp('intBESTATICA_BicicletaEstaticaTiempo').enable();
                                                    Ext.getCmp('intBESTATICA_BicicletaEstaticaTiempo').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Tiempo',
                                        width: 90,
                                        allowBlank: true,
                                        disabled: true,
                                        minValue: 0,
                                        maxValue: 720,
                                        emptyText: 'mim',
                                        id: 'intBESTATICA_BicicletaEstaticaTiempo'
                                    }
                                ]
                            },
                            {
                                xtype: 'textarea',
                                width: 650,
                                fieldLabel: 'Observaciones',
                                name: 'Observaciones',
                                height: 100,            
                                allowBlank: true,
                                id: 'memObservacionesBicicletaEstatica'
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        labelWidth: 210,
                        title: 'VIII. ESCALADOR',
                        layout: 'form',
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        anchor: '100%',
                        autoHeight: true,
                        items: [
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 70,
                                        fieldLabel: 'Escalador',
                                        name: 'Escalador',
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        value: "NO",
                                        id: 'strESCALADOR_Escalador',
                                        listeners:{
                                            select : function(cmb, rec, idx){
                                                if(cmb.getValue() == "NO"){
                                                    Ext.getCmp('intESCALADOR_EscaladorTiempo').allowBlank = true;
                                                    Ext.getCmp('intESCALADOR_EscaladorTiempo').setValue(null);
                                                    Ext.getCmp('intESCALADOR_EscaladorTiempo').disable();
                                                    Ext.getCmp('intESCALADOR_EscaladorTiempo').clearInvalid();
                                                }else{
                                                    Ext.getCmp('intESCALADOR_EscaladorTiempo').enable();
                                                    Ext.getCmp('intESCALADOR_EscaladorTiempo').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Tiempo',
                                        width: 90,
                                        allowBlank: true,
                                        disabled: true,
                                        minValue: 0,
                                        maxValue: 720,
                                        emptyText: 'mim',
                                        id: 'intESCALADOR_EscaladorTiempo'
                                    }
                                ]
                            },
                            {
                                xtype: 'textarea',
                                width: 650,
                                fieldLabel: 'Observaciones',
                                name: 'Observaciones',
                                height: 100,            
                                allowBlank: true,
                                id: 'memObservacionesEscalador'
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        labelWidth: 210,
                        title: 'IX. EJERCICIOS',
                        layout: 'form',
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        anchor: '100%',
                        autoHeight: true,
                        items: [
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 70,
                                        fieldLabel: 'Activos Asistidos',
                                        name: 'Activos Asistidos',
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        value: "NO",
                                        id: 'strEJERCICIOS_ActivosAsistidos',
                                        listeners:{
                                            select : function(cmb, rec, idx){
                                                if(cmb.getValue() == "NO"){
                                                    Ext.getCmp('intEJERCICIOS_ActivosAsistidosTiempo').allowBlank = true;
                                                    Ext.getCmp('intEJERCICIOS_ActivosAsistidosTiempo').setValue(null);
                                                    Ext.getCmp('intEJERCICIOS_ActivosAsistidosTiempo').disable();
                                                    Ext.getCmp('intEJERCICIOS_ActivosAsistidosTiempo').clearInvalid();
                                                }else{
                                                    Ext.getCmp('intEJERCICIOS_ActivosAsistidosTiempo').enable();
                                                    Ext.getCmp('intEJERCICIOS_ActivosAsistidosTiempo').allowBlank = true;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Tiempo',
                                        width: 90,
                                        allowBlank: true,
                                        disabled: true,
                                        minValue: 0,
                                        maxValue: 720,
                                        emptyText: 'mim',
                                        id: 'intEJERCICIOS_ActivosAsistidosTiempo'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 70,
                                        fieldLabel: 'Activos Libres',
                                        name: 'Activos Libres',
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        value: "NO",
                                        id: 'strEJERCICIOS_ActivosLibres',
                                        listeners:{
                                            select : function(cmb, rec, idx){
                                                if(cmb.getValue() == "NO"){
                                                    Ext.getCmp('intEJERCICIOS_ActivosLibresTiempo').allowBlank = true;
                                                    Ext.getCmp('intEJERCICIOS_ActivosLibresTiempo').setValue(null);
                                                    Ext.getCmp('intEJERCICIOS_ActivosLibresTiempo').disable();
                                                    Ext.getCmp('intEJERCICIOS_ActivosLibresTiempo').clearInvalid();
                                                }else{
                                                    Ext.getCmp('intEJERCICIOS_ActivosLibresTiempo').enable();
                                                    Ext.getCmp('intEJERCICIOS_ActivosLibresTiempo').allowBlank = true;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Tiempo',
                                        width: 90,
                                        allowBlank: true,
                                        disabled: true,
                                        minValue: 0,
                                        maxValue: 720,
                                        emptyText: 'mim',
                                        id: 'intEJERCICIOS_ActivosLibresTiempo'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 70,
                                        fieldLabel: 'Activos Resistidos',
                                        name: 'Activos Resistidos',
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        value: "NO",
                                        id: 'strEJERCICIOS_ActivosResistidos',
                                        listeners:{
                                            select : function(cmb, rec, idx){
                                                if(cmb.getValue() == "NO"){
                                                    Ext.getCmp('intEJERCICIOS_ActivosResistidosTiempo').allowBlank = true;
                                                    Ext.getCmp('intEJERCICIOS_ActivosResistidosTiempo').setValue(null);
                                                    Ext.getCmp('intEJERCICIOS_ActivosResistidosTiempo').disable();
                                                    Ext.getCmp('intEJERCICIOS_ActivosResistidosTiempo').clearInvalid();
                                                }else{
                                                    Ext.getCmp('intEJERCICIOS_ActivosResistidosTiempo').enable();
                                                    Ext.getCmp('intEJERCICIOS_ActivosResistidosTiempo').allowBlank = true;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Tiempo',
                                        width: 90,
                                        allowBlank: true,
                                        disabled: true,
                                        minValue: 0,
                                        maxValue: 720,
                                        emptyText: 'mim',
                                        id: 'intEJERCICIOS_ActivosResistidosTiempo'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 70,
                                        fieldLabel: 'Pasivos',
                                        name: 'Pasivos',
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        value: "NO",
                                        id: 'strEJERCICIOS_Pasivos',
                                        listeners:{
                                            select : function(cmb, rec, idx){
                                                if(cmb.getValue() == "NO"){
                                                    Ext.getCmp('intEJERCICIOS_PasivosTiempo').allowBlank = true;
                                                    Ext.getCmp('intEJERCICIOS_PasivosTiempo').setValue(null);
                                                    Ext.getCmp('intEJERCICIOS_PasivosTiempo').disable();
                                                    Ext.getCmp('intEJERCICIOS_PasivosTiempo').clearInvalid();
                                                }else{
                                                    Ext.getCmp('intEJERCICIOS_PasivosTiempo').enable();
                                                    Ext.getCmp('intEJERCICIOS_PasivosTiempo').allowBlank = true;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Tiempo',
                                        width: 90,
                                        allowBlank: true,
                                        disabled: true,
                                        minValue: 0,
                                        maxValue: 720,
                                        emptyText: 'mim',
                                        id: 'intEJERCICIOS_PasivosTiempo'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 70,
                                        fieldLabel: 'Isometricos',
                                        name: 'Isometricos',
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        value: "NO",
                                        id: 'strEJERCICIOS_Isometricos',
                                        listeners:{
                                            select : function(cmb, rec, idx){
                                                if(cmb.getValue() == "NO"){
                                                    Ext.getCmp('intEJERCICIOS_IsometricosTiempo').allowBlank = true;
                                                    Ext.getCmp('intEJERCICIOS_IsometricosTiempo').setValue(null);
                                                    Ext.getCmp('intEJERCICIOS_IsometricosTiempo').disable();
                                                    Ext.getCmp('intEJERCICIOS_IsometricosTiempo').clearInvalid();
                                                }else{
                                                    Ext.getCmp('intEJERCICIOS_IsometricosTiempo').enable();
                                                    Ext.getCmp('intEJERCICIOS_IsometricosTiempo').allowBlank = true;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Tiempo',
                                        width: 90,
                                        allowBlank: true,
                                        disabled: true,
                                        minValue: 0,
                                        maxValue: 720,
                                        emptyText: 'mim',
                                        id: 'intEJERCICIOS_IsometricosTiempo'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 70,
                                        fieldLabel: 'Dinamicos Concentricos',
                                        name: 'Dinamicos Concentricos',
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        value: "NO",
                                        id: 'strEJERCICIOS_DinamicosConcentricos',
                                        listeners:{
                                            select : function(cmb, rec, idx){
                                                if(cmb.getValue() == "NO"){
                                                    Ext.getCmp('intEJERCICIOS_DinamicosConcentricosTiempo').allowBlank = true;
                                                    Ext.getCmp('intEJERCICIOS_DinamicosConcentricosTiempo').setValue(null);
                                                    Ext.getCmp('intEJERCICIOS_DinamicosConcentricosTiempo').disable();
                                                    Ext.getCmp('intEJERCICIOS_DinamicosConcentricosTiempo').clearInvalid();
                                                }else{
                                                    Ext.getCmp('intEJERCICIOS_DinamicosConcentricosTiempo').enable();
                                                    Ext.getCmp('intEJERCICIOS_DinamicosConcentricosTiempo').allowBlank = true;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Tiempo',
                                        width: 90,
                                        allowBlank: true,
                                        disabled: true,
                                        minValue: 0,
                                        maxValue: 720,
                                        emptyText: 'mim',
                                        id: 'intEJERCICIOS_DinamicosConcentricosTiempo'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 70,
                                        fieldLabel: 'Dinamicos Excentricos',
                                        name: 'Isotonicos Excentricos',
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        value: "NO",
                                        id: 'strEJERCICIOS_DinamicosExcentricos',
                                        listeners:{
                                            select : function(cmb, rec, idx){
                                                if(cmb.getValue() == "NO"){
                                                    Ext.getCmp('intEJERCICIOS_DinamicosExcentricosTiempo').allowBlank = true;
                                                    Ext.getCmp('intEJERCICIOS_DinamicosExcentricosTiempo').setValue(null);
                                                    Ext.getCmp('intEJERCICIOS_DinamicosExcentricosTiempo').disable();
                                                    Ext.getCmp('intEJERCICIOS_DinamicosExcentricosTiempo').clearInvalid();
                                                }else{
                                                    Ext.getCmp('intEJERCICIOS_DinamicosExcentricosTiempo').enable();
                                                    Ext.getCmp('intEJERCICIOS_DinamicosExcentricosTiempo').allowBlank = true;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Tiempo',
                                        width: 90,
                                        allowBlank: true,
                                        disabled: true,
                                        minValue: 0,
                                        maxValue: 720,
                                        emptyText: 'mim',
                                        id: 'intEJERCICIOS_DinamicosExcentricosTiempo'
                                    }
                                ]
                            },
                            {
                                xtype: 'textarea',
                                width: 650,
                                fieldLabel: 'Observaciones',
                                name: 'Observaciones',
                                height: 100,            
                                allowBlank: true,
                                id: 'memObservacionesEjercicios'
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 70,
                                        fieldLabel: 'Estiramientos',
                                        name: 'Estiramientos',
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        value: "NO",
                                        id: 'strOTROS_Estiramientos',
                                        listeners:{
                                            select : function(cmb, rec, idx){
                                                if(cmb.getValue() == "NO"){
                                                    Ext.getCmp('intOTROS_EstiramientosTiempo').allowBlank = true;
                                                    Ext.getCmp('intOTROS_EstiramientosTiempo').setValue(null);
                                                    Ext.getCmp('intOTROS_EstiramientosTiempo').disable();
                                                    Ext.getCmp('intOTROS_EstiramientosTiempo').clearInvalid();
                                                }else{
                                                    Ext.getCmp('intOTROS_EstiramientosTiempo').enable();
                                                    Ext.getCmp('intOTROS_EstiramientosTiempo').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Tiempo',
                                        width: 90,
                                        allowBlank: true,
                                        disabled: true,
                                        minValue: 0,
                                        maxValue: 720,
                                        emptyText: 'mim',
                                        id: 'intOTROS_EstiramientosTiempo'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 70,
                                        fieldLabel: 'Propiocepcion',
                                        name: 'Propiocepcion',
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        value: "NO",
                                        id: 'strOTROS_Propiocepcion',
                                        listeners:{
                                            select : function(cmb, rec, idx){
                                                if(cmb.getValue() == "NO"){
                                                    Ext.getCmp('intOTROS_PropiocepcionTiempo').allowBlank = true;
                                                    Ext.getCmp('intOTROS_PropiocepcionTiempo').setValue(null);
                                                    Ext.getCmp('intOTROS_PropiocepcionTiempo').disable();
                                                    Ext.getCmp('intOTROS_PropiocepcionTiempo').clearInvalid();
                                                }else{
                                                    Ext.getCmp('intOTROS_PropiocepcionTiempo').enable();
                                                    Ext.getCmp('intOTROS_PropiocepcionTiempo').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Tiempo',
                                        width: 90,
                                        allowBlank: true,
                                        disabled: true,
                                        minValue: 0,
                                        maxValue: 720,
                                        emptyText: 'mim',
                                        id: 'intOTROS_PropiocepcionTiempo'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 70,
                                        fieldLabel: 'Equilibrio',
                                        name: 'Equilibrio',
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        value: "NO",
                                        id: 'strOTROS_Equilibrio',
                                        listeners:{
                                            select : function(cmb, rec, idx){
                                                if(cmb.getValue() == "NO"){
                                                    Ext.getCmp('intOTROS_EquilibrioTiempo').allowBlank = true;
                                                    Ext.getCmp('intOTROS_EquilibrioTiempo').setValue(null);
                                                    Ext.getCmp('intOTROS_EquilibrioTiempo').disable();
                                                    Ext.getCmp('intOTROS_EquilibrioTiempo').clearInvalid();
                                                }else{
                                                    Ext.getCmp('intOTROS_EquilibrioTiempo').enable();
                                                    Ext.getCmp('intOTROS_EquilibrioTiempo').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Tiempo',
                                        width: 90,
                                        allowBlank: true,
                                        disabled: true,
                                        minValue: 0,
                                        maxValue: 720,
                                        emptyText: 'mim',
                                        id: 'intOTROS_EquilibrioTiempo'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 70,
                                        fieldLabel: 'Reeducacion de Marcha',
                                        name: 'Reeducacion de Marcha',
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        value: "NO",
                                        id: 'strOTROS_ReeducacionMarcha',
                                        listeners:{
                                            select : function(cmb, rec, idx){
                                                if(cmb.getValue() == "NO"){
                                                    Ext.getCmp('intOTROS_ReeducacionMarchaTiempo').allowBlank = true;
                                                    Ext.getCmp('intOTROS_ReeducacionMarchaTiempo').setValue(null);
                                                    Ext.getCmp('intOTROS_ReeducacionMarchaTiempo').disable();
                                                    Ext.getCmp('intOTROS_ReeducacionMarchaTiempo').clearInvalid();
                                                }else{
                                                    Ext.getCmp('intOTROS_ReeducacionMarchaTiempo').enable();
                                                    Ext.getCmp('intOTROS_ReeducacionMarchaTiempo').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Tiempo',
                                        width: 90,
                                        allowBlank: true,
                                        disabled: true,
                                        minValue: 0,
                                        maxValue: 720,
                                        emptyText: 'mim',
                                        id: 'intOTROS_ReeducacionMarchaTiempo'
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        labelWidth: 210,
                        title: 'XI. TECNICAS MANUALES',
                        layout: 'form',
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        anchor: '100%',
                        autoHeight: true,
                        items: [
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 70,
                                        fieldLabel: 'Masaje',
                                        name: 'Masaje',
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        value: "NO",
                                        id: 'strTECMANUALES_Masaje',
                                        listeners:{
                                            select : function(cmb, rec, idx){
                                                if(cmb.getValue() == "NO"){
                                                    Ext.getCmp('intTECMANUALES_MasajeTiempo').allowBlank = true;
                                                    Ext.getCmp('intTECMANUALES_MasajeTiempo').setValue(null);
                                                    Ext.getCmp('intTECMANUALES_MasajeTiempo').disable();
                                                    Ext.getCmp('intTECMANUALES_MasajeTiempo').clearInvalid();
                                                }else{
                                                    Ext.getCmp('intOTROS_TherabyteTiempo').enable();
                                                    Ext.getCmp('intOTROS_TherabyteTiempo').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Tiempo',
                                        width: 90,
                                        allowBlank: true,
                                        disabled: true,
                                        minValue: 0,
                                        maxValue: 720,
                                        emptyText: 'mim',
                                        id: 'intTECMANUALES_MasajeTiempo'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 70,
                                        fieldLabel: 'Movilizaciones Articulares',
                                        name: 'Movilizaciones Articulares',
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        value: "NO",
                                        id: 'strTECMANUALES_MovilizacionesArticulares',
                                        listeners:{
                                            select : function(cmb, rec, idx){
                                                if(cmb.getValue() == "NO"){
                                                    Ext.getCmp('intTECMANUALES_MovilizacionesArticularesTiempo').allowBlank = true;
                                                    Ext.getCmp('intTECMANUALES_MovilizacionesArticularesTiempo').setValue(null);
                                                    Ext.getCmp('intTECMANUALES_MovilizacionesArticularesTiempo').disable();
                                                    Ext.getCmp('intTECMANUALES_MovilizacionesArticularesTiempo').clearInvalid();
                                                }else{
                                                    Ext.getCmp('intTECMANUALES_MovilizacionesArticularesTiempo').enable();
                                                    Ext.getCmp('intTECMANUALES_MovilizacionesArticularesTiempo').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Tiempo',
                                        width: 90,
                                        allowBlank: true,
                                        disabled: true,
                                        minValue: 0,
                                        maxValue: 720,
                                        emptyText: 'mim',
                                        id: 'intTECMANUALES_MovilizacionesArticularesTiempo'
                                    }
                                ]
                            },
                            {
                                xtype: 'textarea',
                                width: 650,
                                fieldLabel: 'Observaciones',
                                name: 'Observaciones',
                                height: 100,            
                                allowBlank: true,
                                id: 'memObservacionesTecnicasManuales'
                            }
                        ]
                    },
                    {
                        xtype: 'timefield',
                        fieldLabel: 'Hora Salida',
                        name: 'Hora Salida',
                        width: 90,
                        allowBlank: true,
                        forceSelection: false,
                        minValue: '6:00 AM',
                        maxValue: '9:00 PM',
                        emptyText: 'p.e. 07:00',
                        //format:'H:i',
                        id: 'strHoraSalida'
                    },
                    {
                        xtype: 'fieldset',
                        title: 'OBSERVACIONES',
                        layout: 'form',
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        anchor: '100%',
                        autoHeight: true,
                        items: [
                            {
                                xtype: 'textarea',
                                width: 700,
                                fieldLabel: 'OBSERVACIONES',
                                name: 'OBSERVACIONES',
                                height: 100,            
                                allowBlank: true,
                                id: 'memObservaciones'
                            },
                            {
                                xtype: 'combo',
                                name: 'Fin Tratamiento',
                                fieldLabel: 'Fin Tratamiento',
                                width: 150,
                                allowBlank: true,
                                store: stFinTratamiento,
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                value: "NO",
                                id: 'strFinTratamiento'
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: 'EVOLUCION FINAL TRATAMIENTO',
                        layout: 'table',
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        anchor: '100%',
                        autoHeight: true,
                        items: [
                            {
                                xtype: 'textarea',
                                width: 885,
                                fieldLabel: 'EVOLUCION FINAL TRATAMIENTO',
                                name: 'EVOLUCION FINAL TRATAMIENTO',
                                height: 100,            
                                allowBlank: true,
                                id: 'memEvolucionFinal'
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: 'RIPS',
                        layout: 'form',
                        collapsible: true,
                        titleCollapse: true,
                        anchor: '100%',
                        autoHeight: true,
                        id: 'fsRips',
                        items: [
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'textfield',
                                        width: 96,
                                        allowBlank: false,
                                        fieldLabel: 'Diagnostico Principal',
                                        id: 'sysDiagPpalHC',
                                        listeners:{
                                            specialkey: function(f,e){
                                                if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                {
                                                    if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                        Ext.Ajax.request({
                                                            url: '../../controlador/cie10/controlador_cie10.php',
                                                            params:{
                                                                task: 'BUSCAR',
                                                                pCodigo: f.getValue().toUpperCase()
                                                            },
                                                            success: function(response,options)
                                                            {
                                                                var el = Ext.get('response'); // get the LOG
                                                                var Respuesta = response.responseText;
                                                                var Contenido = Respuesta.split('^');
                                                                if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                    Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                    Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                } else {
                                                                    Ext.getCmp('sysDiagPpalHC').setValue(Contenido[0]);
                                                                    Ext.getCmp('sysDiagPpalHCNom').setValue(Contenido[1]);
                                                                }
                                                            },
                                                            failure: function(response,options){
                                                                var el = Ext.get('response');
                                                                Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                            },
                                                            scope:this //bind the callbacks
                                                        });
                                                    }else{
                                                        Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                        Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                    }
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'textarea',
                                        width: 625,
                                        height: 22,
                                        id: 'sysDiagPpalHCNom'
                                    },
                                    {
                                        xtype: 'button',
                                        iconCls: 'btnBuscar',
                                        tooltip: 'Buscar Diagnostico Principal',
                                        id: 'btnSearchDiagPpalHC',
                                        listeners:{
                                            click : function(){
                                                buscarcie10('sysDiagPpalHC','sysDiagPpalHCNom');
                                            }
                                        }
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'textfield',
                                        width: 96,
                                        allowBlank: true,
                                        fieldLabel: 'Diagnostico Relacionado Nro.1',
                                        id: 'sysDiagRel1HC',
                                        listeners:{
                                            specialkey: function(f,e){
                                                if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                {
                                                    if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                        Ext.Ajax.request(
                                                        {
                                                            url: '../../controlador/cie10/controlador_cie10.php',
                                                            params:{
                                                                task: 'BUSCAR',
                                                                pCodigo: f.getValue().toUpperCase()
                                                            },
                                                            success: function(response,options)
                                                            {
                                                                var el = Ext.get('response'); // get the LOG
                                                                var Respuesta = response.responseText;
                                                                var Contenido = Respuesta.split('^');
                                                                if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                    Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                    Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                } else {
                                                                    Ext.getCmp('sysDiagRel1HC').setValue(Contenido[0]);
                                                                    Ext.getCmp('sysDiagRel1HCNom').setValue(Contenido[1]);
                                                                }
                                                            },
                                                            failure: function(response,options){
                                                                var el = Ext.get('response');
                                                                Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                            },
                                                            scope:this //bind the callbacks
                                                        });
                                                    }else{
                                                        Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                        Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                    }
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'textarea',
                                        readOnly: true,
                                        width: 625,
                                        height: 22,
                                        id: 'sysDiagRel1HCNom'
                                    },
                                    {
                                        xtype: 'button',
                                        iconCls: 'btnBuscar',
                                        tooltip: 'Buscar Diagnostico Relacionado1',
                                        id: 'btnSearchDiagRel1HC',
                                        listeners:{
                                            click : function(){
                                                buscarcie10('sysDiagRel1HC','sysDiagRel1HCNom');
                                            }
                                        }
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'textfield',
                                        width: 96,
                                        allowBlank: true,
                                        fieldLabel: 'Diagnostico Relacionado Nro.2',
                                        id: 'sysDiagRel2HC',
                                        listeners:{
                                            specialkey: function(f,e){
                                                if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                {
                                                    if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                        Ext.Ajax.request(
                                                        {
                                                            url: '../../controlador/cie10/controlador_cie10.php',
                                                            params:{
                                                                task: 'BUSCAR',
                                                                pCodigo: f.getValue().toUpperCase()
                                                            },
                                                            success: function(response,options)
                                                            {
                                                                var el = Ext.get('response'); // get the LOG
                                                                var Respuesta = response.responseText;
                                                                var Contenido = Respuesta.split('^');
                                                                if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                    Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                    Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                } else {
                                                                    Ext.getCmp('sysDiagRel2HC').setValue(Contenido[0]);
                                                                    Ext.getCmp('sysDiagRel2HCNom').setValue(Contenido[1]);
                                                                }
                                                            },
                                                            failure: function(response,options){
                                                                var el = Ext.get('response');
                                                                Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                            },
                                                            scope:this //bind the callbacks
                                                        });
                                                    }else{
                                                        Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                        Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                    }
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'textarea',
                                        width: 625,
                                        height: 22,
                                        id: 'sysDiagRel2HCNom'
                                    },
                                    {
                                        xtype: 'button',
                                        iconCls: 'btnBuscar',
                                        tooltip: 'Buscar Diagnostico Relacionado2',
                                        id: 'btnSearchDiagRel2HC1',
                                        listeners:{
                                            click : function(){
                                                buscarcie10('sysDiagRel2HC','sysDiagRel2HCNom');
                                            }
                                        }
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'textfield',
                                        width: 96,
                                        allowBlank: true,
                                        fieldLabel: 'Diagnostico Relacionado Nro.3',
                                        id: 'sysDiagRel3HC',
                                        listeners:{
                                            specialkey: function(f,e){
                                                if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                {
                                                    if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue()){
                                                        Ext.Ajax.request(
                                                        {
                                                            url: '../../controlador/cie10/controlador_cie10.php',
                                                            params:{
                                                                task: 'BUSCAR',
                                                                pCodigo: f.getValue().toUpperCase()
                                                            },
                                                            success: function(response,options)
                                                            {
                                                                var el = Ext.get('response'); // get the LOG
                                                                var Respuesta = response.responseText;
                                                                var Contenido = Respuesta.split('^');
                                                                if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                    Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                    Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                } else {
                                                                    Ext.getCmp('sysDiagRel3HC').setValue(Contenido[0]);
                                                                    Ext.getCmp('sysDiagRel3HCNom').setValue(Contenido[1]);
                                                                }
                                                            },
                                                            failure: function(response,options){
                                                                var el = Ext.get('response');
                                                                Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                            },
                                                            scope:this //bind the callbacks
                                                        });
                                                    }else{
                                                        Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                        Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                    }
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'textarea',
                                        readOnly: true,
                                        width: 625,
                                        height: 22,
                                        id: 'sysDiagRel3HCNom'
                                    },
                                    {
                                        xtype: 'button',
                                        iconCls: 'btnBuscar',
                                        tooltip: 'Buscar Diagnostico Relacionado3',
                                        id: 'btnSearchDiagRel3HC',
                                        listeners:{
                                            click : function(){
                                                buscarcie10('sysDiagRel3HC','sysDiagRel3HCNom');
                                            }
                                        }
                                    }
                                ]
                            },
                            {
                                xtype: 'combo',
                                fieldLabel: 'Tipo de Diagnostico',
                                width:750,
                                name: 'Tipo de Diagnostico',
                                allowBlank: false,
                                store: 'StoreTipoDiagnostico',
                                forceSelection: true,
                                triggerAction: 'all',
                                typeAhead: true,
                                typeAheadDelay: 50,
                                mode: 'local',
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                emptyText: 'Seleccione....',
                                submitValue: true,
                                id: 'sysTipoDiagosticoHC'
                            },
                            {
                                xtype: 'combo',
                                fieldLabel: 'Finalidad Consulta',
                                width:750,
                                name: 'Finalidad Consulta',
                                allowBlank: false,
                                store: 'StoreFinalidadConsulta',
                                forceSelection: true,
                                triggerAction: 'all',
                                typeAhead: true,
                                typeAheadDelay: 50,
                                mode: 'local',
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                emptyText: 'Seleccione....',
                                submitValue: true,
                                value: 10,
                                id: 'sysFinalidadConsultaHC'
                            },
                            {
                                xtype: 'combo',
                                fieldLabel: 'Causa Externa',
                                width:750,
                                name: 'Causa Externa',
                                allowBlank: false,
                                store: 'StoreCausaExterna',
                                forceSelection: true,
                                triggerAction: 'all',
                                typeAhead: true,
                                typeAheadDelay: 50,
                                mode: 'local',
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                emptyText: 'Seleccione....',
                                submitValue: true,
                                value: 13,
                                id: 'sysCausaExternaHC'
                            }                            
                        ]
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btnSalirEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 1) 
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Usted No ha Guardado la Evolución del Paciente y Se Perdera la Información, Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                },
                tbar:{
                    items: [
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Ver Historia Clínica',
                            iconCls: 'btnVerHC',
                            id: 'btnVerHC',
                            listeners:{
                                click : function(){
                                    var cmpResumenHC = new winFrmVerHistorialHC({
                                        renderTo: Ext.getBody()
                                    });
                                    Ext.getCmp('winViewEvolucionHC').title = "PACIENTE: " + Ext.getCmp('sysPacienteHC').getValue();
                                    Ext.getCmp('gridHistorialEvoluciones').store.load({
                                        params: {
                                            pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                                            pPaciente: Ext.getCmp('sysIdPacienteHC').getValue()
                                        }
                                    });
                                    cmpResumenHC.show();
                                }
                            }
                        },
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar Evolución',
                            iconCls: 'btnGuardar',
                            id: 'btnGuardarEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 0) 
                                    {
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Guardar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnGuardarRegistros();
                                                }
                                            }
                                        });
                                    }else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Modificar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnModificarRegistros();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                }
            }
        ];
        winHCFisioterapia001Ui.superclass.initComponent.call(this);
    }
});

function fnGuardarRegistros(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc.php',
            params:{
                task: 'guardar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pidPlantillaHC : Ext.getCmp('sysIdCodPlantillaHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1); 
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function fnModificarRegistros(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc.php',
            params:{
                task: 'modificar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

