/*
* @category    Formulario Modelo Evolucion Fonoaudiologia
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winHCFonoaudiologia002Ui = Ext.extend(Ext.Window, {
    title: 'eOfiClinic ©  .:: Plantilla HC - Tamizaje Auditivo ::.',
    width: 990,
    height: 636,
    closable: false,
    resizable: false,
    draggable: false,
    modal: true,
    id: 'winHC',
    initComponent: function() {
        
        var fsDiagnosticosConsulta = new fsDiagnosticosConsultaUi();
        var stAudiograma = new StoreAudiograma();
        
        chartAudiograma = new Ext.chart.LineChart({
            id: 'chartAudiograma',
            store: stAudiograma,
            xField: 'frecuencia',
            extraStyle: {
                 legend: {
                    display: 'right'
                 }
            },
            yAxis: new Ext.chart.NumericAxis({
                reverse: true, // ### here
                maximum: 130,
                minimum: -20,
                majorUnit: 10,
                minorUnit: 5//,
                //displayName: 'Rank'
            }),
            series: [
                {
                    yField: 'OD',
                    displayName: 'OD',
                    style: {
                        color: '#FE2E2E'
                    },
                    markerCfg: {
                        type: 'circle'
                    }
                },{
                    yField: 'OI',
                    displayName: 'OI',
                    style: {
                        color: 0x15428B
                    },
                    markerCfg: {
                        type: 'cross'
                    }
                }
            ]
        });
        
        tmpmx = objMX;
        tmpmxadd = objMXADD;
        tmpexa = objEXA;
        tmprem = objREM;
        myPaciente = 0;
        myCAS = 0;

        try {
            var campo = Ext.getCmp('sysPacientePlantillaHC');
            if ( campo !== null ) {
                myPaciente = Ext.getCmp('sysPacientePlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myPaciente === 0){
            try {
                var campo1 = Ext.getCmp('sysIdPacienteHC');
                if ( campo1 !== null ) {
                    myPaciente = Ext.getCmp('sysIdPacienteHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myPaciente === 0){
            try {
                var campo5 = Ext.getCmp('sysPacienteRefHC');
                if ( campo5 !== null ) {
                    myPaciente = Ext.getCmp('sysPacienteRefHC').getValue();
                }
            }catch(ex){
            }
        }
        try {
            var campo2 = Ext.getCmp('sysCASPlantillaHC');
            if ( campo2 !== null ) {
                myCAS = Ext.getCmp('sysCASPlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myCAS === 0){
            try {
                var campo3 = Ext.getCmp('sysCASHC');
                if ( campo3 !== null ) {
                    myCAS = Ext.getCmp('sysCASHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myCAS === 0){
            try {
                var campo4 = Ext.getCmp('sysCASRefHC');
                if ( campo4 !== null ) {
                    myCAS = Ext.getCmp('sysCASRefHC').getValue();
                }
            }catch(ex){
            }
        }
        if (objMX !== "NA"){
            var xSolMX = eval(objMX);
            Ext.getCmp('gridMedicamentosHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS,
                    pConsecutivoDetalle: wConsecutivoDetalle
                }
            });
        }
        else{
            var xSolMX = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        if (objEXA !== "NA"){
            var xSolEXA = eval(objEXA);
            Ext.getCmp('gridExamenesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS,
                    pConsecutivoDetalle: wConsecutivoDetalle
                }
            });
        }else{
            var xSolEXA = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        if (objREM !== "NA"){
            var xSolREM = eval(objREM);
            Ext.getCmp('gridRemisionesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS,
                    pConsecutivoDetalle: wConsecutivoDetalle
                }
            });
        }else{
            var xSolREM = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        var dataProximaCita = [
            ['2 DIAS'],
            ['1 SEMANA'],
            ['1 MES'],
            ['6 MESES'],
            ['1 AÑO'],
            ['CONTROL CON PARACLINICOS']
        ];
        var stProximaCita = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stProximaCita.loadData(dataProximaCita);


        //
        this.items = [
            {
                xtype: 'panel',
                frame: true,
                anchor: '100%',
                id: 'panelHC',
                border: false,
                height: 570,
                autoScroll: true,
                layout: 'form',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'tabpanel',
                        anchor: '99%',
                        autoHeight: true,
                        border: false,
                        enableTabScroll: true,
                        ref: 'fTabPanel',
                        id: 'fTabPanel',
                        activeTab: 0,
                        items: [
                            {
                                xtype: 'panel',
                                title: 'Evolución',
                                autoHeight: true,
                                autoScroll: true,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaEvolucion',
                                layout: 'form',
                                items: [
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysIdCodPlantillaHC'
                                    },
                                     {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        value: 1,
                                        id: 'sysUsaGridSalida'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                                        value: 0,
                                        id: 'sysYaGuardoHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Plantilla',
                                        id: 'sysPlantillaHC',
                                        name: 'PLANTILLA'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysRutaRptHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysRutaRptMx'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysRutaRptExa'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysRutaRptRem'
                                    },
                                    {
                                        xtype: 'textfield',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Actividad',
                                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                                        id: 'sysActividadHC',
                                        name: 'PLANTILLA'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Empresa',
                                        id: 'sysEmpresaHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'IPS',
                                        id: 'sysIPSHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Usuario',
                                        id: 'sysUsuarioHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Profesional',
                                        id: 'sysProfesionalHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Paciente',
                                        id: 'sysIdPacienteHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Apertura',
                                        id: 'sysAperturaHC'
                                    },
                                    {
                                        xtype: 'textfield',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Cliente',
                                        id: 'sysClienteHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Plantilla',
                                        id: 'sysIdClienteHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Plantilla',
                                        id: 'sysIdPlanHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Plantilla',
                                        id: 'sysIdSubPlanHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Plantilla',
                                        id: 'sysIdContratoHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Genero',
                                        id: 'sysGeneroPacHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Edad',
                                        id: 'sysEdadPacHC'
                                    },
                                    {
                                        xtype: 'textfield',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Profesional',
                                        id: 'sysProfesionalAgendaHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'ConsecutivoDetalle',
                                        id: 'sysConsecutivoDetalleHC'
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'CAS',
                                                id: 'sysCASHC'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysFechaHC',
                                                value: 'Fecha: '
                                            },
                                            {
                                                xtype: 'textfield',
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysFechaHC'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysHoraHC',
                                                value: 'Hora: '
                                            },
                                            {
                                                xtype: 'textfield',
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysHoraHC'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysLegalizacionHC',
                                                value: 'Legalización: '
                                            },
                                            {
                                                xtype: 'textfield',
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysLegalizaHC'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'textfield',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Paciente',
                                        value: 'CC 792558261  - JORGE GALEANO RUIZ - (Masculino) FechaNac: 1973-01-30, Edad 38 Años',
                                        id: 'sysPacienteHC'
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 100,
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Genero',
                                                id: 'sysGeneroHC'
                                            },
                                            {
                                                html: 'Fecha Nac:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 100,
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysFechaNac'
                                            },
                                            {
                                                html: 'Edad:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 350,
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysEdadHC'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        visible: false,
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 370,
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Ocupación',
                                                id: 'sysOcupacionHC'
                                            },
                                            {
                                                html: 'Discapacidad:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 370,
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysDiscapacidadHC'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        visible: false,
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 370,
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Estado Civil',
                                                id: 'sysEstadoCivilHC'
                                            },
                                            {
                                                html: 'Escolaridad:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 380,
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysEscolaridadHC'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        visible: false,
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 370,
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Dirección',
                                                id: 'sysDireccionHC'
                                            },
                                            {
                                                html: 'Telefono:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 390,
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysTelefonoHC'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        visible: false,
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 380,
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Etnia',
                                                id: 'sysEtniaHC'
                                            },
                                            {
                                                html: 'Estrato:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 390,
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysEstratoHC'
                                            }
                                        ]
                                    },
                                    {
                                        html: '<hr>',
                                        style: 'background:transparent;',
                                        border: false
                                    },
                                    {
                                        xtype: 'form',
                                        frame: true,
                                        anchor: '100%',
                                        id: 'frmHC',
                                        padding: 10,
                                        border: false,
                                        autoScroll: true,
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'fieldset',
                                                title: 'ANTECEDENTES OTOLOGICOS',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '99%',
                                                autoHeight: true,
                                                id: 'fs0',
                                                items: [
                                                    {
                                                        xtype: 'panel',
                                                        autoHeight: true,
                                                        autoScroll: true,
                                                        anchor: '100%',
                                                        //frame: true,
                                                        border: false,
                                                        layout: 'table',
                                                        layoutConfig: {
                                                            columns: 2
                                                        },
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                width: 400,
                                                                height: 105,
                                                                layout: 'form',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        fieldLabel: 'Otalqia',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strAO_Otalqia'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        fieldLabel: 'Otitis Extrena',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strAO_OtitisExterna'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        fieldLabel: 'Otitis Media',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strAO_OtitisMedia'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        fieldLabel: 'Acúfenos',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strAO_Acufenos'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 400,
                                                                height: 105,
                                                                layout: 'form',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        fieldLabel: 'Vértigo',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strAO_Vertigo'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        fieldLabel: 'Otorrea',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strAO_Otorrea'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        fieldLabel: 'Otorragia',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strAO_Otorragia'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        fieldLabel: 'Otros',
                                                                        id: 'strAO_Otros'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'ANTECEDENTES FAMILIARES',
                                                layout: 'table',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '99%',
                                                autoHeight: true,
                                                id: 'fsAF',
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        width: '980',
                                                        allowBlank: true,
                                                        fieldLabel: 'Antecedentes Familiares',
                                                        name: 'Antecedentes Familiares',
                                                        id: 'memFonoAntecedentesFamiliares'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'EXPOSICIÓN A OTROS',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '99%',
                                                autoHeight: true,
                                                id: 'fsEOTR',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        width: 100,
                                                        fieldLabel: 'Servicio Militar',
                                                        name: 'Servicio Militar',
                                                        allowBlank: false,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: "NO",
                                                        id: 'strExpoOtros_ServicioMilitar'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        width: 100,
                                                        fieldLabel: 'Moto',
                                                        name: 'Moto',
                                                        allowBlank: false,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: "NO",
                                                        id: 'strExpoOtros_Moto'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        width: 100,
                                                        fieldLabel: 'Dispositivos de Sonido',
                                                        name: 'Dispositivos de Sonido',
                                                        allowBlank: false,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: "NO",
                                                        id: 'strExpoOtros_DispositivoSonido'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        allowBlank: true,
                                                        fieldLabel: 'Otros',
                                                        id: 'strExpoOtros_Otros'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'EXPLORACION CLINICA',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '99%',
                                                autoHeight: true,
                                                id: 'fs1',
                                                items: [
                                                    {
                                                        xtype: 'panel',
                                                        autoHeight: true,
                                                        autoScroll: true,
                                                        anchor: '100%',
                                                        //frame: true,
                                                        border: false,
                                                        layout: 'table',
                                                        layoutConfig: {
                                                            columns: 3
                                                        },
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                title: 'Descripción',
                                                                labelWidth: 1,
                                                                width: 300,
                                                                height: 185,
                                                                layout: 'form',
                                                                items: [
                                                                    {
                                                                        xtype: 'textfield',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        value: 'Otoscopia:',
                                                                        style: 'background:transparent;',
                                                                        id: 'sysOtoscopia1'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        value: 'Pabellón Auricular:',
                                                                        style: 'background:transparent;',
                                                                        id: 'sysOtoscopia2'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        value: 'Conducto Auditivo Externo:',
                                                                        style: 'background:transparent;',
                                                                        id: 'sysOtoscopia3'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        value: 'Tapón de Cerumen Parcial:',
                                                                        style: 'background:transparent;',
                                                                        id: 'sysOtoscopia4'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        value: 'Membrana Timpánica:',
                                                                        style: 'background:transparent;',
                                                                        id: 'sysOtoscopia5'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        value: 'Otros:',
                                                                        style: 'background:transparent;',
                                                                        id: 'sysOtoscopia6'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                title: 'OD',
                                                                labelWidth: 1,
                                                                width: 110,
                                                                height: 185,
                                                                layout: 'form',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        name: 'Otoscopia',
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NORMAL',
                                                                        id: 'strOtoscopiaOD_Otoscopia'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        name: 'Pabellón Auricular',
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NORMAL',
                                                                        id: 'strOtoscopiaOD_PabellonAuricular'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        name: 'Conducto Auditivo Externo',
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NORMAL',
                                                                        id: 'strOtoscopiaOD_ConductoAuditivoExterno'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        name: 'Tapón de Cerumen Parcial',
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NORMAL',
                                                                        id: 'strOtoscopiaOD_TaponCerumen'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        name: 'Membrana Timpánica',
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NORMAL',
                                                                        id: 'strOtoscopiaOD_membranaTimpanica'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        name: 'Otros',
                                                                        id: 'strOtoscopiaOD_Otros'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                title: 'OI',
                                                                labelWidth: 1,
                                                                width: 110,
                                                                height: 185,
                                                                layout: 'form',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        name: 'Otoscopia',
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NORMAL',
                                                                        id: 'strOtoscopiaOI_Otoscopia'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        name: 'Pabellón Auricular',
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NORMAL',
                                                                        id: 'strOtoscopiaOI_PabellonAuricular'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        name: 'Conducto Auditivo Externo',
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NORMAL',
                                                                        id: 'strOtoscopiaOI_ConductoAuditivoExterno'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        name: 'Tapón de Cerumen Parcial',
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NORMAL',
                                                                        id: 'strOtoscopiaOI_TaponCerumen'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        name: 'Membrana Timpánica',
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NORMAL',
                                                                        id: 'strOtoscopiaOI_membranaTimpanica'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        name: 'Otros',
                                                                        id: 'strOtoscopiaOI_Otros'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'EVALUACION AUDIOMETRICA',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '99%',
                                                autoHeight: true,
                                                id: 'fs3',
                                                items: [
                                                    {
                                                        xtype: 'panel',
                                                        autoHeight: true,
                                                        autoScroll: true,
                                                        anchor: '100%',
                                                        //frame: true,
                                                        border: false,
                                                        layout: 'table',
                                                        layoutConfig: {
                                                            columns: 2
                                                        },
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                title: 'VIA AEREA',
                                                                labelWidth: 1,
                                                                width: 335,
                                                                height: 260,
                                                                layout: 'table',
                                                                layoutConfig: {
                                                                    columns: 3
                                                                },
                                                                items: [
                                                                    {
                                                                        xtype: 'panel',
                                                                        title: 'Frecuencia',
                                                                        labelWidth: 1,
                                                                        width: 105,
                                                                        height: 255,
                                                                        layout: 'form',
                                                                        items: [
                                                                            {
                                                                                xtype: 'textfield',
                                                                                anchor: '100%',
                                                                                allowBlank: true,
                                                                                readOnly: true,
                                                                                value: '250',
                                                                                style: 'background:transparent;color:#800000; font-weight:bold',
                                                                                id: 'sysAudiogramaVA1'
                                                                            },
                                                                            {
                                                                                xtype: 'textfield',
                                                                                anchor: '100%',
                                                                                allowBlank: true,
                                                                                readOnly: true,
                                                                                value: '500',
                                                                                style: 'background:transparent;color:#800000; font-weight:bold',
                                                                                id: 'sysAudiogramaVA2'
                                                                            },
                                                                            {
                                                                                xtype: 'textfield',
                                                                                anchor: '100%',
                                                                                allowBlank: true,
                                                                                readOnly: true,
                                                                                value: '1000',
                                                                                style: 'background:transparent;color:#800000; font-weight:bold',
                                                                                id: 'sysAudiogramaVA3'
                                                                            },
                                                                            {
                                                                                xtype: 'textfield',
                                                                                anchor: '100%',
                                                                                allowBlank: true,
                                                                                readOnly: true,
                                                                                value: '2000',
                                                                                style: 'background:transparent;color:#800000; font-weight:bold',
                                                                                id: 'sysAudiogramaVA4'
                                                                            },
                                                                            {
                                                                                xtype: 'textfield',
                                                                                anchor: '100%',
                                                                                allowBlank: true,
                                                                                readOnly: true,
                                                                                value: '3000',
                                                                                style: 'background:transparent;color:#800000; font-weight:bold',
                                                                                id: 'sysAudiogramaVA5'
                                                                            },
                                                                            {
                                                                                xtype: 'textfield',
                                                                                anchor: '100%',
                                                                                allowBlank: true,
                                                                                readOnly: true,
                                                                                value: '4000',
                                                                                style: 'background:transparent;color:#800000; font-weight:bold',
                                                                                id: 'sysAudiogramaVA6'
                                                                            },
                                                                            {
                                                                                xtype: 'textfield',
                                                                                anchor: '100%',
                                                                                allowBlank: true,
                                                                                readOnly: true,
                                                                                value: '6000',
                                                                                style: 'background:transparent;color:#800000; font-weight:bold',
                                                                                id: 'sysAudiogramaVA7'
                                                                            },
                                                                            {
                                                                                xtype: 'textfield',
                                                                                anchor: '100%',
                                                                                allowBlank: true,
                                                                                readOnly: true,
                                                                                value: '8000',
                                                                                style: 'background:transparent;color:#800000; font-weight:bold',
                                                                                id: 'sysAudiogramaVA8'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'panel',
                                                                        title: 'OD',
                                                                        labelWidth: 1,
                                                                        width: 105,
                                                                        height: 255,
                                                                        layout: 'form',
                                                                        items: [
                                                                            {
                                                                                xtype: 'numberfield',
                                                                                anchor: '99%',
                                                                                name: 'Audiograma Via AEREA OD 250',
                                                                                minValue: -10,
                                                                                maxValue: 120,
                                                                                allowBlank: true,
                                                                                style: 'text-align:center;',
                                                                                id: 'intAudiogramaVA_OD250'
                                                                            },
                                                                            {
                                                                                xtype: 'numberfield',
                                                                                anchor: '99%',
                                                                                name: 'Audiograma Via AEREA OD 500',
                                                                                minValue: -10,
                                                                                maxValue: 120,
                                                                                allowBlank: true,
                                                                                style: 'text-align:center;',
                                                                                id: 'intAudiogramaVA_OD500'
                                                                            },
                                                                            {
                                                                                xtype: 'numberfield',
                                                                                anchor: '99%',
                                                                                name: 'Audiograma Via AEREA OD 1000',
                                                                                minValue: -10,
                                                                                maxValue: 120,
                                                                                allowBlank: true,
                                                                                style: 'text-align:center;',
                                                                                id: 'intAudiogramaVA_OD1000'
                                                                            },
                                                                            {
                                                                                xtype: 'numberfield',
                                                                                anchor: '99%',
                                                                                name: 'Audiograma Via AEREA OD 2000',
                                                                                minValue: -10,
                                                                                maxValue: 120,
                                                                                allowBlank: true,
                                                                                style: 'text-align:center;',
                                                                                id: 'intAudiogramaVA_OD2000'
                                                                            },
                                                                            {
                                                                                xtype: 'numberfield',
                                                                                anchor: '99%',
                                                                                name: 'Audiograma Via AEREA OD 3000',
                                                                                minValue: -10,
                                                                                maxValue: 120,
                                                                                allowBlank: true,
                                                                                style: 'text-align:center;',
                                                                                id: 'intAudiogramaVA_OD3000'
                                                                            },
                                                                            {
                                                                                xtype: 'numberfield',
                                                                                anchor: '99%',
                                                                                name: 'Audiograma Via AEREA OD 4000',
                                                                                minValue: -10,
                                                                                maxValue: 120,
                                                                                allowBlank: true,
                                                                                style: 'text-align:center;',
                                                                                id: 'intAudiogramaVA_OD4000'
                                                                            },
                                                                            {
                                                                                xtype: 'numberfield',
                                                                                anchor: '99%',
                                                                                name: 'Audiograma Via AEREA OD 6000',
                                                                                minValue: -10,
                                                                                maxValue: 120,
                                                                                allowBlank: true,
                                                                                style: 'text-align:center;',
                                                                                id: 'intAudiogramaVA_OD6000'
                                                                            },
                                                                            {
                                                                                xtype: 'numberfield',
                                                                                anchor: '99%',
                                                                                name: 'Audiograma Via AEREA OD 8000',
                                                                                minValue: -10,
                                                                                maxValue: 120,
                                                                                allowBlank: true,
                                                                                style: 'text-align:center;',
                                                                                id: 'intAudiogramaVA_OD8000'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'panel',
                                                                        title: 'OI',
                                                                        labelWidth: 1,
                                                                        width: 105,
                                                                        height: 255,
                                                                        layout: 'form',
                                                                        items: [
                                                                            {
                                                                                xtype: 'numberfield',
                                                                                anchor: '99%',
                                                                                name: 'Audiograma Via AEREA OI 250',
                                                                                minValue: -10,
                                                                                maxValue: 120,
                                                                                allowBlank: true,
                                                                                style: 'text-align:center;',
                                                                                id: 'intAudiogramaVA_OI250'
                                                                            },
                                                                            {
                                                                                xtype: 'numberfield',
                                                                                anchor: '99%',
                                                                                name: 'Audiograma Via AEREA OI 500',
                                                                                minValue: -10,
                                                                                maxValue: 120,
                                                                                allowBlank: true,
                                                                                style: 'text-align:center;',
                                                                                id: 'intAudiogramaVA_OI500'
                                                                            },
                                                                            {
                                                                                xtype: 'numberfield',
                                                                                anchor: '99%',
                                                                                name: 'Audiograma Via AEREA OI 1000',
                                                                                minValue: -10,
                                                                                maxValue: 120,
                                                                                allowBlank: true,
                                                                                style: 'text-align:center;',
                                                                                id: 'intAudiogramaVA_OI1000'
                                                                            },
                                                                            {
                                                                                xtype: 'numberfield',
                                                                                anchor: '99%',
                                                                                name: 'Audiograma Via AEREA OI 2000',
                                                                                minValue: -10,
                                                                                maxValue: 120,
                                                                                allowBlank: true,
                                                                                style: 'text-align:center;',
                                                                                id: 'intAudiogramaVA_OI2000'
                                                                            },
                                                                            {
                                                                                xtype: 'numberfield',
                                                                                anchor: '99%',
                                                                                name: 'Audiograma Via AEREA OI 3000',
                                                                                minValue: -10,
                                                                                maxValue: 120,
                                                                                allowBlank: true,
                                                                                style: 'text-align:center;',
                                                                                id: 'intAudiogramaVA_OI3000'
                                                                            },
                                                                            {
                                                                                xtype: 'numberfield',
                                                                                anchor: '99%',
                                                                                name: 'Audiograma Via AEREA OI 4000',
                                                                                minValue: -10,
                                                                                maxValue: 120,
                                                                                allowBlank: true,
                                                                                style: 'text-align:center;',
                                                                                id: 'intAudiogramaVA_OI4000'
                                                                            },
                                                                            {
                                                                                xtype: 'numberfield',
                                                                                anchor: '99%',
                                                                                name: 'Audiograma Via AEREA OI 6000',
                                                                                minValue: -10,
                                                                                maxValue: 120,
                                                                                allowBlank: true,
                                                                                style: 'text-align:center;',
                                                                                id: 'intAudiogramaVA_OI6000'
                                                                            },
                                                                            {
                                                                                xtype: 'numberfield',
                                                                                anchor: '99%',
                                                                                name: 'Audiograma Via AEREA OI 8000',
                                                                                minValue: -10,
                                                                                maxValue: 120,
                                                                                allowBlank: true,
                                                                                style: 'text-align:center;',
                                                                                id: 'intAudiogramaVA_OI8000'
                                                                            }
                                                                        ]
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                title: 'AUDIOGRAMA',
                                                                width: 550,
                                                                height: 260,
                                                                autoScroll: true,
                                                                anchor: '100%',
                                                                border: true,
                                                                items: [
                                                                    chartAudiograma //Grafica
                                                                ],
                                                                tbar:{
                                                                    items: [
                                                                        {
                                                                            xtype: 'tbfill'
                                                                        },
                                                                        {
                                                                            xtype: 'tbseparator'
                                                                        },
                                                                        {
                                                                            xtype: 'button',
                                                                            text: 'Graficar',
                                                                            iconCls: 'btnGraficar',
                                                                            id: 'btnGraficarAudiograma',
                                                                            listeners:{
                                                                                click : function(){
                                                                                    DrawAudiogramaTamizajeAuditivo();
                                                                                }
                                                                            }
                                                                        },
                                                                        {
                                                                            xtype: 'tbseparator'
                                                                        }
                                                                    ]
                                                                }
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'textarea',
                                                width: '800',
                                                allowBlank: true,
                                                fieldLabel: 'Tamizaje',
                                                name: 'Tamizaje',
                                                id: 'memAudiometria'
                                            },
                                            {
                                                xtype: 'textfield',
                                                fieldLabel: 'Concepto',
                                                anchor: '100%',
                                                name: 'CONCEPTO',
                                                allowBlank: false,
                                                id: 'strFonoaudiologiaConcepto'
                                            },
                                            fsDiagnosticosConsulta
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Medicamentos',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaMedicamentos',
                                items: [
                                    xSolMX
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Servicios',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaServicios',
                                items: [
                                    xSolEXA
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Remisiones',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaRemisiones',
                                items: [
                                    xSolREM
                                ]
                            }
                        ]
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btnSalirEvolucion',
                            listeners:{
                                click : function(){
                                    if (parseInt(Ext.getCmp('sysYaGuardoHC').getValue()) === 1)
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn === "yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Usted No ha Guardado la Evolución del Paciente y Se Perdera la Información, Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn === "yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                },
                tbar:{
                    items: [
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Ver Historia Clínica',
                            iconCls: 'btnVerHC',
                            id: 'btnVerHC',
                            listeners:{
                                click : function(){
                                    var cmpResumenHC = new winFrmVerHistorialHC({
                                        renderTo: Ext.getBody()
                                    });
                                    Ext.getCmp('winViewEvolucionHC').title = "PACIENTE: " + Ext.getCmp('sysPacienteHC').getValue();
                                    Ext.getCmp('gridHistorialEvoluciones').store.load({
                                        params: {
                                            pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                                            pPaciente: Ext.getCmp('sysIdPacienteHC').getValue()
                                        }
                                    });
                                    cmpResumenHC.show();
                                }
                            }
                        },
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar Evolución',
                            iconCls: 'btnGuardar',
                            id: 'btnGuardarEvolucion',
                            listeners:{
                                click : function(){
                                    if (parseInt(Ext.getCmp('sysYaGuardoHC').getValue()) === 0)
                                    {
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Guardar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn === "yes")
                                                {
                                                    fnGuardarRegistrosFonoaudiologiaTamizaje();
                                                }
                                            }
                                        });
                                    }else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Modificar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn === "yes")
                                                {
                                                    fnModificarRegistrosFonoaudiologiaTamizaje();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                }
            }
        ];
        this.on({
            afterlayout:{
                scope:this, 
                single:true, 
                fn:function() {
                    Ext.Msg.hide();
                }
            }
        });
        winHCFonoaudiologia002Ui.superclass.initComponent.call(this);
    }
});

function fnGuardarRegistrosFonoaudiologiaTamizaje(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc.php',
            params:{
                task: 'guardar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pidPlantillaHC : Ext.getCmp('sysIdCodPlantillaHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function fnModificarRegistrosFonoaudiologiaTamizaje(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc.php',
            params:{
                task: 'modificar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function DrawAudiogramaTamizajeAuditivo(){
    Ext.getCmp('chartAudiograma').store.removeAll();
    var recId;
    var st = new StoreAudiograma();
    recId = 2;
    if(Ext.getCmp('intAudiogramaVA_OD250').getValue() === null || Ext.getCmp('intAudiogramaVA_OD250').getValue() === ""){
        Ext.getCmp('intAudiogramaVA_OD250').setValue(0);  
    }
    if(Ext.getCmp('intAudiogramaVA_OI250').getValue() === null || Ext.getCmp('intAudiogramaVA_OI250').getValue() === ""){
        Ext.getCmp('intAudiogramaVA_OI250').setValue(0);  
    }
    Ext.getCmp('chartAudiograma').store.add(new st.recordType({
            IDReg: recId,
            frecuencia: 250,
            OD: Ext.getCmp('intAudiogramaVA_OD250').getValue(),
            OI: Ext.getCmp('intAudiogramaVA_OI250').getValue()
        })
    );
    recId = 3;
    if(Ext.getCmp('intAudiogramaVA_OD500').getValue() === null || Ext.getCmp('intAudiogramaVA_OD500').getValue() === ""){
        Ext.getCmp('intAudiogramaVA_OD500').setValue(0);  
    }
    if(Ext.getCmp('intAudiogramaVA_OI500').getValue() === null || Ext.getCmp('intAudiogramaVA_OI500').getValue() === ""){
        Ext.getCmp('intAudiogramaVA_OI500').setValue(0);  
    }
    Ext.getCmp('chartAudiograma').store.add(new st.recordType({
            IDReg: recId,
            frecuencia: 500,
            OD: Ext.getCmp('intAudiogramaVA_OD500').getValue(),
            OI: Ext.getCmp('intAudiogramaVA_OI500').getValue()
        })
    );
    recId = 4;
    if(Ext.getCmp('intAudiogramaVA_OD1000').getValue() === null || Ext.getCmp('intAudiogramaVA_OD1000').getValue() === ""){
        Ext.getCmp('intAudiogramaVA_OD1000').setValue(0);  
    }
    if(Ext.getCmp('intAudiogramaVA_OI1000').getValue() === null || Ext.getCmp('intAudiogramaVA_OI1000').getValue() === ""){
        Ext.getCmp('intAudiogramaVA_OI1000').setValue(0);  
    }
    Ext.getCmp('chartAudiograma').store.add(new st.recordType({
            IDReg: recId,
            frecuencia: 1000,
            OD: Ext.getCmp('intAudiogramaVA_OD1000').getValue(),
            OI: Ext.getCmp('intAudiogramaVA_OI1000').getValue()
        })
    );
    recId = 5;
    if(Ext.getCmp('intAudiogramaVA_OD2000').getValue() === null || Ext.getCmp('intAudiogramaVA_OD2000').getValue() === ""){
        Ext.getCmp('intAudiogramaVA_OD2000').setValue(0);  
    }
    if(Ext.getCmp('intAudiogramaVA_OI2000').getValue() === null || Ext.getCmp('intAudiogramaVA_OI2000').getValue() === ""){
        Ext.getCmp('intAudiogramaVA_OI2000').setValue(0);  
    }
    Ext.getCmp('chartAudiograma').store.add(new st.recordType({
            IDReg: recId,
            frecuencia: 2000,
            OD: Ext.getCmp('intAudiogramaVA_OD2000').getValue(),
            OI: Ext.getCmp('intAudiogramaVA_OI2000').getValue()
        })
    );
    recId = 6;
    if(Ext.getCmp('intAudiogramaVA_OD3000').getValue() === null || Ext.getCmp('intAudiogramaVA_OD3000').getValue() === ""){
        Ext.getCmp('intAudiogramaVA_OD3000').setValue(0);  
    }
    if(Ext.getCmp('intAudiogramaVA_OI3000').getValue() === null || Ext.getCmp('intAudiogramaVA_OI3000').getValue() === ""){
        Ext.getCmp('intAudiogramaVA_OI3000').setValue(0);  
    }
    Ext.getCmp('chartAudiograma').store.add(new st.recordType({
            IDReg: recId,
            frecuencia: 3000,
            OD: Ext.getCmp('intAudiogramaVA_OD3000').getValue(),
            OI: Ext.getCmp('intAudiogramaVA_OI3000').getValue()
        })
    );
    recId = 7;
    if(Ext.getCmp('intAudiogramaVA_OD4000').getValue() === null || Ext.getCmp('intAudiogramaVA_OD4000').getValue() === ""){
        Ext.getCmp('intAudiogramaVA_OD4000').setValue(0);  
    }
    if(Ext.getCmp('intAudiogramaVA_OI4000').getValue() === null || Ext.getCmp('intAudiogramaVA_OI4000').getValue() === ""){
        Ext.getCmp('intAudiogramaVA_OI4000').setValue(0);  
    }
    Ext.getCmp('chartAudiograma').store.add(new st.recordType({
            IDReg: recId,
            frecuencia: 4000,
            OD: Ext.getCmp('intAudiogramaVA_OD4000').getValue(),
            OI: Ext.getCmp('intAudiogramaVA_OI4000').getValue()
        })
    );
    recId = 8;
    if(Ext.getCmp('intAudiogramaVA_OD6000').getValue() === null || Ext.getCmp('intAudiogramaVA_OD6000').getValue() === ""){
        Ext.getCmp('intAudiogramaVA_OD6000').setValue(0);  
    }
    if(Ext.getCmp('intAudiogramaVA_OI6000').getValue() === null || Ext.getCmp('intAudiogramaVA_OI6000').getValue() === ""){
        Ext.getCmp('intAudiogramaVA_OI6000').setValue(0);  
    }
    Ext.getCmp('chartAudiograma').store.add(new st.recordType({
            IDReg: recId,
            frecuencia: 6000,
            OD: Ext.getCmp('intAudiogramaVA_OD6000').getValue(),
            OI: Ext.getCmp('intAudiogramaVA_OI6000').getValue()
        })
    );
    recId = 9;
    if(Ext.getCmp('intAudiogramaVA_OD8000').getValue() === null || Ext.getCmp('intAudiogramaVA_OD8000').getValue() === ""){
        Ext.getCmp('intAudiogramaVA_OD8000').setValue(0);  
    }
    if(Ext.getCmp('intAudiogramaVA_OI8000').getValue() === null || Ext.getCmp('intAudiogramaVA_OI8000').getValue() === ""){
        Ext.getCmp('intAudiogramaVA_OI8000').setValue(0);  
    }
    Ext.getCmp('chartAudiograma').store.add(new st.recordType({
            IDReg: recId,
            frecuencia: 8000,
            OD: Ext.getCmp('intAudiogramaVA_OD8000').getValue(),
            OI: Ext.getCmp('intAudiogramaVA_OI8000').getValue()
        })
    );
    Ext.getCmp('chartAudiograma').refresh();
}