/*
* @category    Formulario Modelo Evolucion Historia Clinica Laboratorio Sueño
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winHCneurologia005Ui = Ext.extend(Ext.Window, {
    title: 'eOfiClinic ©  .:: Plantilla HC - Laboratorio Sueño ::.',
    width: 990,
    height: 636,
    closable: false,
    resizable: false,
    draggable: false,
    modal: true,
    id: 'winHC',
    initComponent: function() {
        
        tmpmx = objMX;
        tmpmxadd = objMXADD;
        tmpexa = objEXA;
        tmprem = objREM;
        myPaciente = 0;
        myCAS = 0;
        
        try {
            var campo = Ext.getCmp('sysPacientePlantillaHC');
            if ( campo != null ) {
                myPaciente = Ext.getCmp('sysPacientePlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myPaciente == 0){
            try {
                var campo1 = Ext.getCmp('sysIdPacienteHC');
                if ( campo1 != null ) {
                    myPaciente = Ext.getCmp('sysIdPacienteHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myPaciente == 0){
            try {
                var campo5 = Ext.getCmp('sysPacienteRefHC');
                if ( campo5 != null ) {
                    myPaciente = Ext.getCmp('sysPacienteRefHC').getValue();
                }
            }catch(ex){
            }
        }
        try {
            var campo2 = Ext.getCmp('sysCASPlantillaHC');
            if ( campo2 != null ) {
                myCAS = Ext.getCmp('sysCASPlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myCAS == 0){
            try {
                var campo3 = Ext.getCmp('sysCASHC');
                if ( campo3 != null ) {
                    myCAS = Ext.getCmp('sysCASHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myCAS == 0){
            try {
                var campo4 = Ext.getCmp('sysCASRefHC');
                if ( campo4 != null ) {
                    myCAS = Ext.getCmp('sysCASRefHC').getValue();
                }
            }catch(ex){
            }
        }
        
        if (objMX != "NA"){
            var xSolMX = eval(objMX);
            Ext.getCmp('gridMedicamentosHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: myPaciente,
                    pCAS: myCAS
                }
            });
        }
        else{
            var xSolMX = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        if (objEXA != "NA"){
            var xSolEXA = eval(objEXA);
            Ext.getCmp('gridExamenesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: myPaciente,
                    pCAS: myCAS
                }
            });
        }else{
            var xSolEXA = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }    
        if (objREM != "NA"){
            var xSolREM = eval(objREM);
            Ext.getCmp('gridRemisionesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: myPaciente,
                    pCAS: myCAS
                }
            });
        }else{
            var xSolREM = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        
        var xSolNOPOS = new SolNOPOS001Ui();
        Ext.getCmp('gridSolicitudesNOPOSxPaciente').store.load({
            params: {
                task: 'LISTAR_NOPOS',
                pPaciente: myPaciente
            }
        });
        
        var dataDuermeNoche = [
            ['Muy Bien'],
            ['Bien'],
            ['Mal'],
            ['Muy Mal']
        ];
        var stDuermeNoche = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stDuermeNoche.loadData(dataDuermeNoche);
        
        
        var dataTiempoDuerme = [
            ['Menos 15 min'],
            ['Menos 30 min'],
            ['Mas 30 min'],
            ['Mas 1 hora']
        ];
        var stTiempoDuerme = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stTiempoDuerme.loadData(dataTiempoDuerme);
        
        
        var dataTiempoDificultad = [
            ['Semanas'],
            ['Meses'],
            ['Años']
        ];
        var stTiempoDificultad = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stTiempoDificultad.loadData(dataTiempoDificultad);
        
        
        var dataTipoDificultad = [
            ['Muy Grave'],
            ['Relativamente Grave'],
            ['Leve']
        ];
        var stTipoDificultad = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stTipoDificultad.loadData(dataTipoDificultad);
        
        
        var dataSensacionSueno = [
            ['Nunca'],
            ['Una a dos veces por semana'],
            ['Tres o cuatro veces por semana'],
            ['Todos los Dias']
        ];
        var stSensacionSueno = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stSensacionSueno.loadData(dataSensacionSueno);
        
        
        var dataMovientoPiernas = [
            ['Nunca'],
            ['Un Poco'],
            ['Bastante'],
            ['Muchisimo']
        ];
        var stMovientoPiernas = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stMovientoPiernas.loadData(dataMovientoPiernas);
        
        
        var dataRonquido = [
            ['Todas las Noches'],
            ['3 - 4 Noches por Semana'],
            ['1 - 2 Noches por Semana']
        ];
        var stRonquido = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stRonquido.loadData(dataRonquido);
        
        
        var dataFaltaAire = [
            ['Nunca'],
            ['Ocasionalmente'],
            ['Frecuentemente'],
            ['Cada noche']
        ];
        var stFaltaAire = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stFaltaAire.loadData(dataFaltaAire);
        
        
        var dataCabeceaSituacion = [
            ['Nunca'],
            ['Dificilmente'],
            ['Facilmente'],
            ['Muy Facil']
        ];
        var stCabeceaSituacion = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stCabeceaSituacion.loadData(dataCabeceaSituacion);
        
        
        this.items = [
            {
                xtype: 'panel',
                frame: true,
                anchor: '100%',
                id: 'panelHC',
                padding: 10,
                border: false,
                height: 610,
                autoScroll: true,
                layout: 'form',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysIdCodPlantillaHC'
                    },
                     {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        value: 1,
                        id: 'sysUsaGridSalida'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        value: 0,
                        id: 'sysYaGuardoHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysPlantillaHC',
                        name: 'PLANTILLA'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptMx'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptExa'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptRem'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Actividad',
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        id: 'sysActividadHC',
                        name: 'PLANTILLA'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Empresa',
                        id: 'sysEmpresaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'IPS',
                        id: 'sysIPSHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Usuario',
                        id: 'sysUsuarioHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Profesional',
                        id: 'sysProfesionalHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Paciente',
                        id: 'sysIdPacienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Apertura',
                        id: 'sysAperturaHC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Cliente',
                        id: 'sysClienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdClienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdPlanHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdSubPlanHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdContratoHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Genero',
                        id: 'sysGeneroPacHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Edad',
                        id: 'sysEdadPacHC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Profesional',
                        id: 'sysProfesionalAgendaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'ConsecutivoDetalle',
                        id: 'sysConsecutivoDetalleHC'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'CAS',
                                id: 'sysCASHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysFechaHC',
                                value: 'Fecha: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                width: 100,
                                id: 'sysFechaHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysHoraHC',
                                value: 'Hora: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                width: 90,
                                id: 'sysHoraHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysLegalizacionHC',
                                value: 'Legalización: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                width: 100,
                                id: 'sysLegalizaHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysAutorizacionHC',
                                value: 'Nro Autorización: '
                            },
                            {
                                xtype: 'textfield',
                                width: 210,
                                allowBlank: true,
                                style: 'color:brown;',
                                readOnly: true,
                                id: 'sysNroAutorizacionHC'
                            }
                        ]
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Paciente',
                        value: 'CC 792558261  - JORGE GALEANO RUIZ - (Masculino) FechaNac: 1973-01-30, Edad 38 Años',
                        id: 'sysPacienteHC'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                width: 120,
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'Genero',
                                id: 'sysGeneroPacHC'
                            },
                            {
                                html: 'Fecha Nacimiento'
                            },
                            {
                                xtype: 'textfield',
                                width: 120,
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysFecNacPacHC'
                            },
                            {
                                html: 'Edad'
                            },
                            {
                                xtype: 'textfield',
                                width: 250,
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysEdadPacHC'
                            }
                        ]
                    },
                    {
                        html: '<hr>',
                        style: 'background:transparent;',
                        border: false
                    },
                    {
                        xtype: 'tabpanel',
                        width: 930,
                        autoHeight: true,
                        border: false,
                        ref: 'fTabPanel',
                        id: 'fTabPanel',
                        activeTab: 0,
                        items: [
                            {
                                xtype: 'panel',
                                title: 'Evolución',
                                autoHeight: true,
                                autoScroll: true,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaEvolucion',
                                layout: 'form',
                                items: [
                                    {
                                        xtype: 'form',
                                        frame: true,
                                        anchor: '100%',
                                        id: 'frmHC',
                                        padding: 10,
                                        border: false,
                                        autoScroll: true,
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'fieldset',
                                                layout: 'form',
                                                //collapsible: true,
                                                //titleCollapse: true,
                                                labelWidth: 500,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        fieldLabel: '1. DESCRIBA BREVEMENTE SU PROBLEMA DE SUEÑO',
                                                        name: '1. DESCRIBA BREVEMENTE SU PROBLEMA DE SUEÑO',
                                                        allowBlank: true,
                                                        id: 'memDesCripcionProblemaSueno'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: '2. QUE TAL DUERME EN LA NOCHE?',
                                                        fieldLabel: '2. QUE TAL DUERME EN LA NOCHE?',
                                                        width: 150,
                                                        allowBlank: true,
                                                        store: stDuermeNoche,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strDuermeNoche'
                                                    },
                                                    {
                                                        xtype: 'numberfield',
                                                        fieldLabel: '3. CUANTAS HORAS DUERME NORMALMENTE EN LA NOCHE?',
                                                        name: '3. CUANTAS HORAS DUERME NORMALMENTE EN LA NOCHE?',
                                                        width: 68,
                                                        minValue: 0,
                                                        decimalPrecision: 0,
                                                        allowBlank: true,
                                                        id: 'intHorasSueno'
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: '4. A QUE HORAS SE ACUESTA',
                                                        layout: 'form',
                                                        anchor: '100%',
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'table',
                                                                anchor: '100%',
                                                                padding: 0,
                                                                layoutConfig: {
                                                                    columns: 3
                                                                },
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'panel',
                                                                        layout: 'form',
                                                                        width: 150,
                                                                        height: 125,
                                                                        labelWidth: 0,
                                                                        labelSeparator: '',
                                                                        labelStyle: 'color:blue;',
                                                                        title: '&nbsp;',
                                                                        items: [
                                                                            {
                                                                                xtype: 'textfield',
                                                                                fieldLabel: 'Se Acuesta',
                                                                                width: 1,
                                                                                height: 7,
                                                                                allowBlank: true,
                                                                                readOnly: true,
                                                                                border: 0,
                                                                                style: 'background:transparent;text-align:right;border:none;',
                                                                                id: 'sysExaA'
                                                                            },
                                                                            {
                                                                                xtype: 'textfield',
                                                                                fieldLabel: 'Se Levanta',
                                                                                width: 1,
                                                                                height: 7,
                                                                                allowBlank: true,
                                                                                readOnly: true,
                                                                                border: 0,
                                                                                style: 'background:transparent;text-align:right;border:none;',
                                                                                id: 'sysExaB'
                                                                            },
                                                                            {
                                                                                xtype: 'textfield',
                                                                                fieldLabel: 'Cuantas horas duerme',
                                                                                width: 1,
                                                                                height: 7,
                                                                                allowBlank: true,
                                                                                readOnly: true,
                                                                                border: 0,
                                                                                style: 'background:transparent;text-align:right;border:none;',
                                                                                id: 'sysExaC'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'panel',
                                                                        layout: 'form',
                                                                        width: 100,
                                                                        height: 125,
                                                                        labelWidth: 1,
                                                                        labelSeparator: '',
                                                                        labelStyle: 'color:blue;',
                                                                        title: '<center>Dias Laborados</center>',
                                                                        items: [
                                                                            {
                                                                                xtype: 'textfield',
                                                                                width: 90,
                                                                                name: 'Se Acuesta Dias Laborados',
                                                                                allowBlank: true,
                                                                                id: 'strAcuestaDiasLaborados'
                                                                            },
                                                                            {
                                                                                xtype: 'textfield',
                                                                                width: 90,
                                                                                name: 'Se Levanta Dias Laborados',
                                                                                allowBlank: true,
                                                                                id: 'strLevantaDiasLaborados'
                                                                            },
                                                                            {
                                                                                xtype: 'textfield',
                                                                                width: 90,
                                                                                name: 'Cuantas Horas Duerme Dias Laborados',
                                                                                allowBlank: true,
                                                                                id: 'strCuantasHorasDuermeDiasLaborados'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'panel',
                                                                        layout: 'form',
                                                                        width: 100,
                                                                        height: 125,
                                                                        labelWidth: 1,
                                                                        labelSeparator: '',
                                                                        labelStyle: 'color:blue;',
                                                                        title: '<center>Dias Descanso</center>',
                                                                        items: [
                                                                            {
                                                                                xtype: 'textfield',
                                                                                width: 90,
                                                                                name: 'Se Acuesta Dias de Descanso',
                                                                                allowBlank: true,
                                                                                id: 'strAcuestaDiasDescanso'
                                                                            },
                                                                            {
                                                                                xtype: 'textfield',
                                                                                width: 90,
                                                                                name: 'Se Levanta Dias de Descanso',
                                                                                allowBlank: true,
                                                                                id: 'strLevantaDiasDescanso'
                                                                            },
                                                                            {
                                                                                xtype: 'textfield',
                                                                                width: 90,
                                                                                name: 'Cuantas Horas Duerme Dias de Descanso',
                                                                                allowBlank: true,
                                                                                id: 'strCuantasHorasDuermeDiasDescanso'
                                                                            }
                                                                        ]
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: '5. CUANTO TIEMPO LE TOMA QUEDARSE DORMIDO',
                                                        fieldLabel: '5. CUANTO TIEMPO LE TOMA QUEDARSE DORMIDO',
                                                        width: 150,
                                                        allowBlank: true,
                                                        store: stTiempoDuerme,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strTiempoDormido'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        width: 150,
                                                        name: '6. CUANTAS VECES SE DESPIERTA EN LA NOCHE?',
                                                        fieldLabel: '6. CUANTAS VECES SE DESPIERTA EN LA NOCHE?',
                                                        allowBlank: true,
                                                        id: 'strDespiertaNoche'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: '7. SI SE DESPIERTA CUANTO TIEMPO LE TOMA EN VOLVER A CONCILIAR EL SUEÑO',
                                                        fieldLabel: '7. SI SE DESPIERTA CUANTO TIEMPO LE TOMA EN VOLVER A CONCILIAR EL SUEÑO',
                                                        width: 150,
                                                        allowBlank: true,
                                                        store: stTiempoDuerme,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strVolverDormir'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        width: 150,
                                                        name: '8. CUANTAS VECES UTILIZA EL BAÑO EN LA NOCHE?',
                                                        fieldLabel: '8. CUANTAS VECES UTILIZA EL BAÑO EN LA NOCHE?',
                                                        allowBlank: true,
                                                        id: 'strBanoNoche'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        width: 150,
                                                        name: '9. USTED CONSIDERA QUE TIENE DIFICULTADES CON SU SUEÑO?',
                                                        fieldLabel: '9. USTED CONSIDERA QUE TIENE DIFICULTADES CON SU SUEÑO?',
                                                        allowBlank: true,
                                                        id: 'strDificultadesSueno'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: '10. POR CUANTO TIEMPO HA TENIDO DIFICUTADES CON SU SUEÑO?',
                                                        fieldLabel: '10. POR CUANTO TIEMPO HA TENIDO DIFICUTADES CON SU SUEÑO?',
                                                        width: 150,
                                                        allowBlank: true,
                                                        store: stTiempoDificultad,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strTiempoDificultadDormir'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: '11. QUE TAN GRAVE CONSIDERA SU PROBLEMA DE SUEÑO?',
                                                        fieldLabel: '11. QUE TAN GRAVE CONSIDERA SU PROBLEMA DE SUEÑO?',
                                                        width: 150,
                                                        allowBlank: true,
                                                        store: stTipoDificultad,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strGravedadProblemaSueno'
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: '12. USTED PRESENTA',
                                                        layout: 'form',
                                                        anchor: '100%',
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Dificultad para conciliar el sueño',
                                                                name: 'Dificultad para conciliar el sueño',
                                                                width: 150,
                                                                allowBlank: true,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strDificultadSueno'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Frecuentes Despertares',
                                                                name: 'Frecuentes Despertares',
                                                                width: 150,
                                                                allowBlank: true,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strFrecuentesDespertares'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Despertar temprano en la mañana',
                                                                name: 'Despertar temprano en la mañana',
                                                                width: 150,
                                                                allowBlank: true,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strDespertarTempranoManana'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: '13. USTED HA PRESENTADO SENSACION DE HORMIGUEO, COSQUILLEO O PRESION EN LAS PIERNAS O BRAZOS CUANDO ESTA EN REPOSO QUE LE IMPIDA CONCILIAR EL SUEÑO?',
                                                        fieldLabel: '13. USTED HA PRESENTADO SENSACION DE HORMIGUEO, COSQUILLEO O PRESION EN LAS PIERNAS O BRAZOS CUANDO ESTA EN REPOSO QUE LE IMPIDA CONCILIAR EL SUEÑO?',
                                                        width: 150,
                                                        allowBlank: true,
                                                        store: stSensacionSueno,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strSensacionHormigueo'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: '14. LA SENSACION DE HORMIGUEO, COSQUILLEO O PRESION EN LAS PIERNAS SE ALIVIA TRANSITORIAMENTE CON EL MOVIMIENTO DE LAS PIERNAS?',
                                                        name: '14. LA SENSACION DE HORMIGUEO, COSQUILLEO O PRESION EN LAS PIERNAS SE ALIVIA TRANSITORIAMENTE CON EL MOVIMIENTO DE LAS PIERNAS?',
                                                        width: 150,
                                                        allowBlank: true,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strAlivioSensacionHormigueo'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: '15. SON LOS SINTOMAS DESCRITOS EN LA PREGUNTA 14 PEORES EN LA NOCHE QUE EN EL DIA?',
                                                        name: '15. SON LOS SINTOMAS DESCRITOS EN LA PREGUNTA 14 PEORES EN LA NOCHE QUE EN EL DIA?',
                                                        width: 150,
                                                        allowBlank: true,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strAlivioSensacionHormigueo'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: '16. SU COMPAÑERO(A) HA NOTADO QUE USTED MUEVE LAS PIERNAS DURANTE  EL SUEÑO?',
                                                        fieldLabel: '16. SU COMPAÑERO(A) HA NOTADO QUE USTED MUEVE LAS PIERNAS DURANTE  EL SUEÑO?',
                                                        width: 150,
                                                        allowBlank: true,
                                                        store: stMovientoPiernas,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strMovimientoPiernas'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: '17. USTED RONCA?',
                                                        name: '17. USTED RONCA?',
                                                        width: 150,
                                                        allowBlank: true,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strRoncaNoche'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: '18. SI USTED RONCA LO HACE?',
                                                        fieldLabel: '18. SI USTED RONCA LO HACE?',
                                                        width: 150,
                                                        allowBlank: true,
                                                        store: stRonquido,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strMovimientoPiernas'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: '19. LA INTENSIDAD DEL RONQUIDO AFECTA EL SUEÑO DE SU COMPAÑERO(A)?',
                                                        name: '19. LA INTENSIDAD DEL RONQUIDO AFECTA EL SUEÑO DE SU COMPAÑERO(A)?',
                                                        width: 150,
                                                        allowBlank: true,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strRoncaCompanero'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: '20. EL RONQUIDO HA AUMENTADO ULTIMAMENTE?',
                                                        name: '20. EL RONQUIDO HA AUMENTADO ULTIMAMENTE?',
                                                        width: 150,
                                                        allowBlank: true,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strRoncaAumento'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: '21. LE HAN DICHO QUE USTED DEJA DE RESPIRAR MIENTRAS DUERME?',
                                                        name: '21. LE HAN DICHO QUE USTED DEJA DE RESPIRAR MIENTRAS DUERME?',
                                                        width: 150,
                                                        allowBlank: true,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strDejarRespirarDuerme'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: '22. SE HA DESPERTADO AHOGADO O COMO SI LE FALTARA AIRE?',
                                                        fieldLabel: '22. SE HA DESPERTADO AHOGADO O COMO SI LE FALTARA AIRE?',
                                                        width: 150,
                                                        allowBlank: true,
                                                        store: stFaltaAire,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strAhogadoDespertar'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: '23. ES SU SUEÑO REPARADOR, SE SIENTE DESCANSADO AL LEVANTARSE?',
                                                        name: '23. ES SU SUEÑO REPARADOR, SE SIENTE DESCANSADO AL LEVANTARSE?',
                                                        width: 150,
                                                        allowBlank: true,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strSuenoDescansado'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: '24. USTED PRESENTA SOMNOLENCIA DURANTE EL DIA?',
                                                        name: '24. USTED PRESENTA SOMNOLENCIA DURANTE EL DIA?',
                                                        width: 150,
                                                        allowBlank: true,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strSomnolenciaDia'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: '25. USTED TOMA SIESTAS DURANTE EL DIA?',
                                                        name: '25. USTED TOMA SIESTAS DURANTE EL DIA?',
                                                        width: 150,
                                                        allowBlank: true,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strSiestasDia'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        width: 150,
                                                        name: '26. CUANTAS SIESTAS TOMA EN EL DIA?',
                                                        fieldLabel: '26. CUANTAS SIESTAS TOMA EN EL DIA?',
                                                        allowBlank: false,
                                                        id: 'strCuantasSiestasDia'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: '27. CUANTO DURAN LAS SIESTAS?',
                                                        fieldLabel: '27. CUANTO DURAN LAS SIESTAS?',
                                                        width: 150,
                                                        allowBlank: true,
                                                        store: stTiempoDuerme,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strTiempoSiestas'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: '28. SE SIENTE MEJOR DESPUES DE LA SIESTA?',
                                                        name: '28. SE SIENTE MEJOR DESPUES DE LA SIESTA?',
                                                        width: 150,
                                                        allowBlank: true,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strMejorSiestas'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: '29. USTED CONSUME ALCOHOL?',
                                                        name: '29. USTED CONSUME ALCOHOL?',
                                                        width: 150,
                                                        allowBlank: true,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strConsumoAlcohol'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: '30. USTED FUMA?',
                                                        name: '30. USTED FUMA?',
                                                        width: 150,
                                                        allowBlank: true,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strConsumoAlcohol'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: '31. USTED TOMA CAFE?',
                                                        name: '31. USTED TOMA CAFE?',
                                                        width: 150,
                                                        allowBlank: true,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strConsumoCafe'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        width: 150,
                                                        fieldLabel: '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;CUANTAS TAZAS DE CAFE TOMA?',
                                                        name: 'CUANTAS TAZAS DE CAFE TOMA?',
                                                        allowBlank: true,
                                                        id: 'strCuantasSiestasDia'
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: '32. QUE TAN FACIL SE QUEDA DORMIDO O CABECEA EN LAS SIGUIENTES SITUACIONES',
                                                        layout: 'form',
                                                        anchor: '100%',
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'a. Sentado y Leyendo',
                                                                fieldLabel: '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;a. Sentado y Leyendo',
                                                                width: 150,
                                                                allowBlank: true,
                                                                store: stCabeceaSituacion,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strCabeceaSentado'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'b. Mirando TV',
                                                                fieldLabel: '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;b. Mirando TV',
                                                                width: 150,
                                                                allowBlank: true,
                                                                store: stCabeceaSituacion,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strCabeceaMirandoTV'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'c. Sentado en un sitio Publico (cine, teatro, iglesia)',
                                                                fieldLabel: '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;c. Sentado en un sitio Publico (cine, teatro, iglesia)',
                                                                width: 150,
                                                                allowBlank: true,
                                                                store: stCabeceaSituacion,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strCabeceaSitioPublico'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;d. Como pasajero en un recorrido durante 1 hora',
                                                                name: 'd. Como pasajero en un recorrido durante 1 hora',
                                                                width: 150,
                                                                allowBlank: true,
                                                                store: stCabeceaSituacion,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strCabeceaPasajero'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;e. Recostado en la tarde cuando las circustancias lo permiten',
                                                                name: 'e. Recostado en la tarde cuando las circustancias lo permiten',
                                                                width: 150,
                                                                allowBlank: true,
                                                                store: stCabeceaSituacion,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strCabeceaTarde'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;f. Conversando',
                                                                name: 'f. Conversando',
                                                                width: 150,
                                                                allowBlank: true,
                                                                store: stCabeceaSituacion,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strCabeceaConversando'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;g. En el carro, esperando el cambio de luz',
                                                                name: 'g. En el carro, esperando el cambio de luz',
                                                                width: 150,
                                                                allowBlank: true,
                                                                store: stCabeceaSituacion,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strCabeceaCarroCambioLuz'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;h. Reuniones',
                                                                name: 'h. Reuniones',
                                                                width: 150,
                                                                allowBlank: true,
                                                                store: stCabeceaSituacion,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strCabeceaReuniones'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;i. Cuando Maneja por mas de 30 minutos',
                                                                name: 'i. Cuando Maneja por mas de 30 minutos',
                                                                width: 150,
                                                                allowBlank: true,
                                                                store: stCabeceaSituacion,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strCabeceaManejoMas30Min'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;j. Cuando Maneja por menos de 30 minutos',
                                                                name: 'j. Cuando Maneja por menos de 30 minutos',
                                                                width: 150,
                                                                allowBlank: true,
                                                                store: stCabeceaSituacion,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strCabeceaManejoMenos30Min'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: '33. HA GANADO PESO ULTIMAMENTE?',
                                                        name: '33. HA GANADO PESO ULTIMAMENTE?',
                                                        width: 150,
                                                        allowBlank: true,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strAumentoPeso'
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: '34. HA TENIDO ALGUNO(S) DE LOS SIGUIENTES PROBLEMAS',
                                                        layout: 'form',
                                                        anchor: '100%',
                                                        labelWidth: 150,
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'table',
                                                                anchor: '100%',
                                                                padding: 0,
                                                                layoutConfig: {
                                                                    columns: 2
                                                                },
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'panel',
                                                                        layout: 'form',
                                                                        width: 450,
                                                                        height: 125,
                                                                        labelSeparator: '',
                                                                        labelStyle: 'color:blue;',
                                                                        items: [
                                                                            {
                                                                                xtype: 'combo',
                                                                                fieldLabel: 'Convulsiones',
                                                                                name: 'Problemas Convulsiones',
                                                                                width: 150,
                                                                                allowBlank: true,
                                                                                store: 'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                mode: 'local',
                                                                                forceSelection: true,
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 10,
                                                                                triggerAction: 'all',
                                                                                id: 'strProblemasConvulsiones'
                                                                            },
                                                                            {
                                                                                xtype: 'combo',
                                                                                fieldLabel: 'Trombosis',
                                                                                name: 'Problemas Trombosis',
                                                                                width: 150,
                                                                                allowBlank: true,
                                                                                store: 'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                mode: 'local',
                                                                                forceSelection: true,
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 10,
                                                                                triggerAction: 'all',
                                                                                id: 'strProblemasTrombosis'
                                                                            },
                                                                            {
                                                                                xtype: 'combo',
                                                                                fieldLabel: 'Hipertension',
                                                                                name: 'Problemas Hipertension',
                                                                                width: 150,
                                                                                allowBlank: true,
                                                                                store: 'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                mode: 'local',
                                                                                forceSelection: true,
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 10,
                                                                                triggerAction: 'all',
                                                                                id: 'strProblemasHipertension'
                                                                            },
                                                                            {
                                                                                xtype: 'combo',
                                                                                fieldLabel: 'Enfermedad Cardiaca',
                                                                                name: 'Problemas Enfermedad Cardiaca',
                                                                                width: 150,
                                                                                allowBlank: true,
                                                                                store: 'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                mode: 'local',
                                                                                forceSelection: true,
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 10,
                                                                                triggerAction: 'all',
                                                                                id: 'strProblemasEnfermedadCardiaca'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'panel',
                                                                        layout: 'form',
                                                                        width: 450,
                                                                        height: 125,
                                                                        labelSeparator: '',
                                                                        labelStyle: 'color:blue;',
                                                                        items: [
                                                                            {
                                                                                xtype: 'combo',
                                                                                fieldLabel: 'Enfermedad Pulmonar',
                                                                                name: 'Problemas Enfermedad Pulmonar',
                                                                                width: 150,
                                                                                allowBlank: true,
                                                                                store: 'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                mode: 'local',
                                                                                forceSelection: true,
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 10,
                                                                                triggerAction: 'all',
                                                                                id: 'strProblemasEnfermedadPulmonar'
                                                                            },
                                                                            {
                                                                                xtype: 'combo',
                                                                                fieldLabel: 'Diabetes',
                                                                                name: 'Problemas Diabetes',
                                                                                width: 150,
                                                                                allowBlank: true,
                                                                                store: 'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                mode: 'local',
                                                                                forceSelection: true,
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 10,
                                                                                triggerAction: 'all',
                                                                                id: 'strProblemasDiabetes'
                                                                            },
                                                                            {
                                                                                xtype: 'combo',
                                                                                fieldLabel: 'Depresion',
                                                                                name: 'Problemas Depresion',
                                                                                width: 150,
                                                                                allowBlank: true,
                                                                                store: 'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                mode: 'local',
                                                                                forceSelection: true,
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 10,
                                                                                triggerAction: 'all',
                                                                                id: 'strProblemasDepresion'
                                                                            },
                                                                            {
                                                                                xtype: 'textfield',
                                                                                width: 150,
                                                                                fieldLabel: 'Otro Problema de Salud',
                                                                                name: 'Otro Problema de Salud',
                                                                                allowBlank: true,
                                                                                id: 'strProblemasOtros'
                                                                            }
                                                                        ]
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        width: 150,
                                                        fieldLabel: '35. LE HAN REALIZADO ALGUNA CIRUGIA?',
                                                        name: '35. LE HAN REALIZADO ALGUNA CIRUGIA?',
                                                        allowBlank: true,
                                                        id: 'strCirugias'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        width: 150,
                                                        fieldLabel: '36. TOMA O HA TOMADO MEDICAMENTOS PARA DORMIR?',
                                                        name: '36. TOMA O HA TOMADO MEDICAMENTOS PARA DORMIR?',
                                                        allowBlank: true,
                                                        id: 'strMedicamentosDormir'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        width: 150,
                                                        fieldLabel: '37. POR FAVOR MENCIONE LOS MEDICAMENTOS QUE ESTA TOMANDO ACTUALMENTE?',
                                                        name: '37. POR FAVOR MENCIONE LOS MEDICAMENTOS QUE ESTA TOMANDO ACTUALMENTE?',
                                                        allowBlank: true,
                                                        id: 'strMedicamentosActuales'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: '38. HA CAMINADO DORMIDO?',
                                                        name: '38. HA CAMINADO DORMIDO?',
                                                        width: 150,
                                                        allowBlank: true,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strCaminarDormido'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: '39. HABLA DORMIDO?',
                                                        name: '39. HABLA DORMIDO?',
                                                        width: 150,
                                                        allowBlank: true,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strHablaDormido'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: '40. LE CHIRREAN LOS DIENTES MIENTRAS DUERME?',
                                                        name: '40. LE CHIRREAN LOS DIENTES MIENTRAS DUERME?',
                                                        width: 150,
                                                        allowBlank: true,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strChirreanDientesDormido'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: '41. SE HA ORINADO MIENTRAS DUERME?',
                                                        name: '41. SE HA ORINADO MIENTRAS DUERME?',
                                                        width: 150,
                                                        allowBlank: true,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strOrinadoDormido'
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: 'EXAMEN FISICO',
                                                        layout: 'form',
                                                        anchor: '100%',
                                                        labelWidth: 80,
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'table',
                                                                anchor: '100%',
                                                                padding: 0,
                                                                layoutConfig: {
                                                                    columns: 2
                                                                },
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'panel',
                                                                        layout: 'form',
                                                                        width: 450,
                                                                        autoHeight: true,
                                                                        labelSeparator: '',
                                                                        labelStyle: 'color:blue;',
                                                                        items: [
                                                                            {
                                                                                xtype: 'numberfield',
                                                                                fieldLabel: 'Peso',
                                                                                name: 'Peso',
                                                                                width: 150,
                                                                                decimalPrecision: 0,
                                                                                allowBlank: true,
                                                                                id: 'intExamenFisicoPeso'
                                                                            },
                                                                            {
                                                                                xtype: 'numberfield',
                                                                                fieldLabel: 'Talla',
                                                                                name: 'Talla',
                                                                                width: 150,
                                                                                decimalPrecision: 0,
                                                                                allowBlank: true,
                                                                                id: 'intExamenFisicoTalla'
                                                                            },
                                                                            {
                                                                                xtype: 'numberfield',
                                                                                fieldLabel: 'PC',
                                                                                name: 'PC',
                                                                                width: 150,
                                                                                decimalPrecision: 0,
                                                                                allowBlank: true,
                                                                                id: 'intExamenFisicoPC'
                                                                            },
                                                                            {
                                                                                xtype: 'textfield',
                                                                                fieldLabel: 'ICC',
                                                                                name: 'ICC',
                                                                                width: 150,
                                                                                allowBlank: true,
                                                                                id: 'strExamenFisicoICC'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'panel',
                                                                        layout: 'form',
                                                                        width: 450,
                                                                        autoHeight: true,
                                                                        labelSeparator: '',
                                                                        labelStyle: 'color:blue;',
                                                                        items: [
                                                                            {
                                                                                xtype: 'compositefield',
                                                                                style: 'background:transparent;',
                                                                                items: [
                                                                                    {
                                                                                        xtype: 'numberfield',
                                                                                        fieldLabel: 'TA',
                                                                                        name: 'TA Sistolica',
                                                                                        width: 80,
                                                                                        decimalPrecision: 0,
                                                                                        allowBlank: true,
                                                                                        id: 'intExamenFisicoTASistolica'
                                                                                    },
                                                                                    {
                                                                                        html: '/'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'numberfield',
                                                                                        name: 'TA Diastolica',
                                                                                        width: 80,
                                                                                        decimalPrecision: 0,
                                                                                        allowBlank: true,
                                                                                        id: 'intExamenFisicoTADiastolica'
                                                                                    }
                                                                                ]
                                                                            },
                                                                            {
                                                                                xtype: 'textfield',
                                                                                fieldLabel: 'IBM',
                                                                                name: 'IBM',
                                                                                width: 150,
                                                                                allowBlank: true,
                                                                                id: 'intExamenFisicoIBM'
                                                                            },
                                                                            {
                                                                                xtype: 'numberfield',
                                                                                fieldLabel: 'FC',
                                                                                name: 'FC',
                                                                                width: 150,
                                                                                decimalPrecision: 0,
                                                                                allowBlank: true,
                                                                                id: 'intExamenFisicoFC'
                                                                            },
                                                                            {
                                                                                xtype: 'textfield',
                                                                                fieldLabel: 'SPO2',
                                                                                name: 'SPO2',
                                                                                width: 150,
                                                                                allowBlank: true,
                                                                                id: 'strExamenFisicoSPO2'
                                                                            }
                                                                        ]
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                html: '<br>'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                fieldLabel: 'COMENTARIO',
                                                                name: 'COMENTARIO',
                                                                anchor: '100%',
                                                                allowBlank: true,
                                                                id: 'strExamenFisicoComentario'
                                                            },
                                                            {
                                                                html: '<br>'
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                title: 'Via Aerea',
                                                                layout: 'form',
                                                                anchor: '100%',
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Tabique',
                                                                        name: 'Tabique',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        id: 'strExamenFisicoTabique'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Fosas',
                                                                        name: 'Fosas',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        id: 'strExamenFisicoFosas'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Uvula',
                                                                        name: 'Uvula',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        id: 'strExamenFisicoUvula'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Amigdalas',
                                                                        name: 'Amigdalas',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        id: 'strExamenFisicoAmigdalas'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'RIPS',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: false,
                                                                fieldLabel: 'Diagnostico Principal',
                                                                id: 'sysDiagPpalHC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request({
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                        Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    },
                                                                    blur: function(t){
                                                                        if(Ext.getCmp('sysDiagPpalHCNom').getValue()==null || Ext.getCmp('sysDiagPpalHCNom').getValue()== "")
                                                                        {
                                                                            if (Ext.getCmp('sysDiagPpalHC').getValue() != "" && Ext.getCmp('sysDiagPpalHC').getValue() != null && Ext.getCmp('sysDiagPpalHC').getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && Ext.getCmp('sysDiagPpalHC').getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && Ext.getCmp('sysDiagPpalHC').getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request({
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: Ext.getCmp('sysDiagPpalHC').getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                        Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagPpalHCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Principal',
                                                                id: 'btnSearchDiagPpalHC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagPpalHC','sysDiagPpalHCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.1',
                                                                id: 'sysDiagRel1HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    },
                                                                    blur: function(t){
                                                                        if (Ext.getCmp('sysDiagRel1HCNom').getValue == null ||  Ext.getCmp('sysDiagRel1HCNom').getValue() == "")
                                                                        {
                                                                            if (Ext.getCmp('sysDiagRel1HC').getValue() != "" && Ext.getCmp('sysDiagRel1HC').getValue() != null && Ext.getCmp('sysDiagRel1HC').getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && Ext.getCmp('sysDiagRel1HC').getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && Ext.getCmp('sysDiagRel1HC').getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: Ext.getCmp('sysDiagRel1HC').getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel1HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado1',
                                                                id: 'btnSearchDiagRel1HC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel1HC','sysDiagRel1HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.2',
                                                                id: 'sysDiagRel2HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    },
                                                                    blur: function(t){
                                                                        if (Ext.getCmp('sysDiagRel2HCNom').getValue == null || Ext.getCmp('sysDiagRel2HCNom').getValue() == "")
                                                                        {
                                                                            if (Ext.getCmp('sysDiagRel2HC').getValue() != "" && Ext.getCmp('sysDiagRel2HC').getValue() != null && Ext.getCmp('sysDiagRel2HC').getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && Ext.getCmp('sysDiagRel2HC').getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && Ext.getCmp('sysDiagRel2HC').getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: Ext.getCmp('sysDiagRel2HC').getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel2HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado2',
                                                                id: 'btnSearchDiagRel2HC1',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel2HC','sysDiagRel2HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.3',
                                                                id: 'sysDiagRel3HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    },
                                                                    blur: function(t){
                                                                        if (Ext.getCmp('sysDiagRel3HCNom').getValue == null || Ext.getCmp('sysDiagRel3HCNom').getValue() == "")
                                                                        {
                                                                            if (Ext.getCmp('sysDiagRel3HC').getValue() != "" && Ext.getCmp('sysDiagRel3HC').getValue() != null && Ext.getCmp('sysDiagRel3HC').getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && Ext.getCmp('sysDiagRel3HC').getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && Ext.getCmp('sysDiagRel3HC').getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: Ext.getCmp('sysDiagRel3HC').getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel3HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado3',
                                                                id: 'btnSearchDiagRel3HC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel3HC','sysDiagRel3HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Tipo de Diagnostico',
                                                        anchor: '100%',
                                                        name: 'Tipo de Diagnostico',
                                                        allowBlank: false,
                                                        store: 'StoreTipoDiagnostico',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        id: 'sysTipoDiagosticoHC'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Finalidad Consulta',
                                                        anchor: '100%',
                                                        name: 'Finalidad Consulta',
                                                        allowBlank: false,
                                                        store: 'StoreFinalidadConsulta',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 10,
                                                        id: 'sysFinalidadConsultaHC'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Causa Externa',
                                                        anchor: '100%',
                                                        name: 'Causa Externa',
                                                        allowBlank: false,
                                                        store: 'StoreCausaExterna',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 13,
                                                        id: 'sysCausaExternaHC'
                                                    }
                                                ]
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Medicamentos',
                                height: 352,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaMedicamentos',
                                items: [
                                    xSolMX
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Servicios',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaServicios',
                                items: [
                                    xSolEXA
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Remisiones',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaRemisiones',
                                items: [
                                    xSolREM
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud NO POS',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaNOPOS',
                                items: [
                                    xSolNOPOS
                                ]
                            }
                            /*,
                            {
                                xtype: 'panel',
                                title: 'Consentimientos Informados',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaConsentimientos',
                                items: [
                                ]
                            },*/
                        ]
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btnSalirEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 1) 
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    if (Ext.getCmp('sysUsaGridSalida').getValue() == 1){
                                                        Ext.getCmp('gridFormulario').store.reload();
                                                    }
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Usted No ha Guardado la Evolución del Paciente y Se Perdera la Información, Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                },
                tbar:{
                    items: [
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Ver Historia Clínica',
                            iconCls: 'btnVerHC',
                            id: 'btnVerHC',
                            listeners:{
                                click : function(){
                                    var cmpResumenHC = new winFrmVerHistorialHC({
                                        renderTo: Ext.getBody()
                                    });
                                    Ext.getCmp('winViewEvolucionHC').title = "PACIENTE: " + Ext.getCmp('sysPacienteHC').getValue();
                                    Ext.getCmp('gridHistorialEvoluciones').store.load({
                                        params: {
                                            pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                                            pPaciente: Ext.getCmp('sysIdPacienteHC').getValue()
                                        }
                                    });
                                    cmpResumenHC.show();
                                }
                            }
                        },
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar Evolución',
                            iconCls: 'btnGuardar',
                            id: 'btnGuardarEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 0) 
                                    {
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Guardar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnGuardarRegistros();
                                                }
                                            }
                                        });
                                    }else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Modificar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnModificarRegistros();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                }
            }
        ];
        this.on({
            afterlayout:{scope:this, single:true, fn:function() {
                Ext.Msg.hide();
                if(paramOpcion === "Nuevo"){ 
                    var frm = Ext.getCmp('frmHC').getForm();
                    frm.doAction('load', {
                        url: '../../controlador/asistencial/evolucionhc.php',
                        waitMsg: 'Cargando Información...',
                        params:{
                            pCAS: myCAS,
                            pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                            task: 'ImportarAntecedentesFamiliares'
                        },
                        success:function(form, action) {
                            CargarDataHCAntecedentes(action.result.data.sysEvolucion);
                            frm.doAction('load', {
                                url: '../../controlador/asistencial/evolucionhc.php',
                                waitMsg: 'Cargando Información...',
                                params:{
                                    pCAS: myCAS,
                                    pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                                    task: 'ImportarAntecedentesPersonales'
                                },
                                success:function(form, action) {
                                    CargarDataHCAntecedentes(action.result.data.sysEvolucion);
                                }
                            });
                        }
                    });
                }
                var frm = Ext.getCmp('frmHC').getForm();
                frm.doAction('load', {
                    url: '../../controlador/asistencial/evolucionhc.php',
                    waitMsg: 'Cargando Información...',
                    params:{
                        pCAS: myCAS,
                        pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                        task: 'ImportarUltimaAtencion'
                    },
                    success:function(form, action) {
                        Ext.getCmp('viewResumenUltimaAtencionHC').load({
                            url: '../../controlador/asistencial/viewhcxformato.php?pEmpresa=' + ID_EMPRESA + '&pIPS=' + ID_IPS + '&pPaciente=' + Ext.getCmp('sysIdPacienteHC').getValue() + '&pEvolucion=' + action.result.data.ConsecutivoHC,
                            scripts:true,
                            scope:this,
                            nocache: false,
                            text: 'Cargando...'
                        });
                        //CargarDataHCUltimaAtencion(action.result.data.sysEvolucion);
                    }
                });
            }}
        });
        winHCneurologia005Ui.superclass.initComponent.call(this);
    }
});

function fnGuardarRegistros(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc.php',
            params:{
                task: 'guardar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pidPlantillaHC : Ext.getCmp('sysIdCodPlantillaHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1); 
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function fnModificarRegistros(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc.php',
            params:{
                task: 'modificar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}
